/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Heartbeat;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.catalina.tribes.membership.MembershipProviderBase;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.ExceptionUtils;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class StaticMembershipProvider
extends MembershipProviderBase
implements RpcCallback,
ChannelListener,
Heartbeat {
    protected static final StringManager sm = StringManager.getManager(StaticMembershipProvider.class);
    private static final Log log = LogFactory.getLog(StaticMembershipProvider.class);
    protected Channel channel;
    protected RpcChannel rpcChannel;
    private String membershipName = null;
    private byte[] membershipId = null;
    protected ArrayList<StaticMember> staticMembers;
    protected int sendOptions = 8;
    protected long expirationTime = 5000L;
    protected int connectTimeout = 500;
    protected long rpcTimeout = 3000L;
    protected int startLevel = 0;
    protected boolean useThread = false;
    protected long pingInterval = 1000L;
    protected volatile boolean running = true;
    protected PingThread thread = null;

    @Override
    public void init(Properties properties) throws Exception {
        String string = properties.getProperty("expirationTime");
        this.expirationTime = Long.parseLong(string);
        String string2 = properties.getProperty("connectTimeout");
        this.connectTimeout = Integer.parseInt(string2);
        String string3 = properties.getProperty("rpcTimeout");
        this.rpcTimeout = Long.parseLong(string3);
        this.membershipName = properties.getProperty("membershipName");
        this.membershipId = this.membershipName.getBytes(StandardCharsets.ISO_8859_1);
        this.membership = new Membership(this.service.getLocalMember(true));
        this.rpcChannel = new RpcChannel(this.membershipId, this.channel, this);
        this.channel.addChannelListener(this);
        String string4 = properties.getProperty("useThread");
        this.useThread = Boolean.parseBoolean(string4);
        String string5 = properties.getProperty("pingInterval");
        this.pingInterval = Long.parseLong(string5);
    }

    @Override
    public void start(int n) throws Exception {
        if (4 == (n & 4)) {
            // empty if block
        }
        if (8 == (n & 8)) {
            // empty if block
        }
        this.startLevel |= n;
        if (this.startLevel == 12) {
            this.startMembership(this.getAliveMembers(this.staticMembers.toArray(new Member[0])));
            this.running = true;
            if (this.thread == null && this.useThread) {
                this.thread = new PingThread();
                this.thread.setDaemon(true);
                this.thread.setName("StaticMembership.PingThread[" + this.channel.getName() + "]");
                this.thread.start();
            }
        }
    }

    @Override
    public boolean stop(int n) throws Exception {
        if (4 == (n & 4)) {
            // empty if block
        }
        if (8 == (n & 8)) {
            // empty if block
        }
        this.startLevel &= ~n;
        if (this.startLevel == 0) {
            this.running = false;
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            if (this.rpcChannel != null) {
                this.rpcChannel.breakdown();
            }
            if (this.channel != null) {
                try {
                    this.stopMembership(this.getMembers());
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                }
                this.channel.removeChannelListener(this);
                this.channel = null;
            }
            this.rpcChannel = null;
            this.membership.reset();
        }
        return this.startLevel == 0;
    }

    protected void startMembership(Member[] memberArray) throws ChannelException {
        if (memberArray.length == 0) {
            return;
        }
        MemberMessage memberMessage = new MemberMessage(this.membershipId, 1, this.service.getLocalMember(true));
        Response[] responseArray = this.rpcChannel.send(memberArray, memberMessage, 3, this.sendOptions, this.rpcTimeout);
        if (responseArray.length > 0) {
            for (Response response : responseArray) {
                this.messageReceived(response.getMessage(), response.getSource());
            }
        } else {
            log.warn((Object)sm.getString("staticMembershipProvider.startMembership.noReplies"));
        }
    }

    protected Member setupMember(Member member) {
        return member;
    }

    protected void memberAdded(Member member) {
        final Member member2 = this.setupMember(member);
        if (this.membership.memberAlive(member2)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String string = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("StaticMembership-memberAdded");
                        StaticMembershipProvider.this.membershipListener.memberAdded(member2);
                    }
                    finally {
                        Thread.currentThread().setName(string);
                    }
                }
            };
            this.executor.execute(runnable);
        }
    }

    protected void memberDisappeared(final Member member) {
        this.membership.removeMember(member);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName("StaticMembership-memberDisappeared");
                    StaticMembershipProvider.this.membershipListener.memberDisappeared(member);
                }
                finally {
                    Thread.currentThread().setName(string);
                }
            }
        };
        this.executor.execute(runnable);
    }

    protected void memberAlive(Member member) {
        if (!this.membership.contains(member)) {
            this.memberAdded(member);
        }
        this.membership.memberAlive(member);
    }

    protected void stopMembership(Member[] memberArray) {
        if (memberArray.length == 0) {
            return;
        }
        Member member = this.service.getLocalMember(false);
        member.setCommand(Member.SHUTDOWN_PAYLOAD);
        MemberMessage memberMessage = new MemberMessage(this.membershipId, 2, member);
        try {
            this.channel.send(memberArray, memberMessage, this.sendOptions);
        }
        catch (ChannelException channelException) {
            log.error((Object)sm.getString("staticMembershipProvider.stopMembership.sendFailed"), (Throwable)channelException);
        }
    }

    @Override
    public void messageReceived(Serializable serializable, Member member) {
        MemberMessage memberMessage = (MemberMessage)serializable;
        Member member2 = memberMessage.getMember();
        if (memberMessage.getMsgtype() == 1) {
            this.memberAdded(member2);
        } else if (memberMessage.getMsgtype() == 2) {
            this.memberDisappeared(member2);
        } else if (memberMessage.getMsgtype() == 3) {
            this.memberAlive(member2);
        }
    }

    @Override
    public boolean accept(Serializable serializable, Member member) {
        boolean bl = false;
        if (serializable instanceof MemberMessage) {
            bl = Arrays.equals(this.membershipId, ((MemberMessage)serializable).getMembershipId());
        }
        return bl;
    }

    @Override
    public Serializable replyRequest(Serializable serializable, Member member) {
        if (!(serializable instanceof MemberMessage)) {
            return null;
        }
        MemberMessage memberMessage = (MemberMessage)serializable;
        if (memberMessage.getMsgtype() == 1) {
            this.messageReceived(memberMessage, member);
            memberMessage.setMember(this.service.getLocalMember(true));
            return memberMessage;
        }
        if (memberMessage.getMsgtype() == 3) {
            this.messageReceived(memberMessage, member);
            memberMessage.setMember(this.service.getLocalMember(true));
            return memberMessage;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("staticMembershipProvider.replyRequest.ignored", memberMessage.getTypeDesc()));
        }
        return null;
    }

    @Override
    public void leftOver(Serializable serializable, Member member) {
        if (!(serializable instanceof MemberMessage)) {
            return;
        }
        MemberMessage memberMessage = (MemberMessage)serializable;
        if (memberMessage.getMsgtype() == 1) {
            this.messageReceived(memberMessage, member);
        } else if (memberMessage.getMsgtype() == 3) {
            this.messageReceived(memberMessage, member);
        } else if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("staticMembershipProvider.leftOver.ignored", memberMessage.getTypeDesc()));
        }
    }

    @Override
    public void heartbeat() {
        try {
            if (!this.useThread) {
                this.ping();
            }
        }
        catch (ChannelException channelException) {
            log.warn((Object)sm.getString("staticMembershipProvider.heartbeat.failed"), (Throwable)channelException);
        }
    }

    protected void ping() throws ChannelException {
        Member[] memberArray = this.getAliveMembers(this.staticMembers.toArray(new Member[0]));
        if (memberArray.length > 0) {
            try {
                Response[] responseArray;
                MemberMessage memberMessage = new MemberMessage(this.membershipId, 3, this.service.getLocalMember(true));
                for (Response response : responseArray = this.rpcChannel.send(memberArray, memberMessage, 3, this.sendOptions, this.rpcTimeout)) {
                    this.messageReceived(response.getMessage(), response.getSource());
                }
            }
            catch (ChannelException channelException) {
                ChannelException.FaultyMember[] faultyMemberArray;
                for (ChannelException.FaultyMember faultyMember : faultyMemberArray = channelException.getFaultyMembers()) {
                    this.memberDisappeared(faultyMember.getMember());
                }
                throw channelException;
            }
        }
        this.checkExpired();
    }

    protected void checkExpired() {
        Member[] memberArray;
        for (Member member : memberArray = this.membership.expire(this.expirationTime)) {
            this.membershipListener.memberDisappeared(member);
        }
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setStaticMembers(ArrayList<StaticMember> arrayList) {
        this.staticMembers = arrayList;
    }

    private Member[] getAliveMembers(Member[] memberArray) {
        ArrayList<Member> arrayList = new ArrayList<Member>();
        for (Member member : memberArray) {
            try (Socket socket = new Socket();){
                InetAddress inetAddress = InetAddress.getByAddress(member.getHost());
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, member.getPort());
                socket.connect(inetSocketAddress, this.connectTimeout);
                arrayList.add(member);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
            }
        }
        return arrayList.toArray(new Member[0]);
    }

    protected class PingThread
    extends Thread {
        protected PingThread() {
        }

        @Override
        public void run() {
            while (StaticMembershipProvider.this.running) {
                try {
                    PingThread.sleep(StaticMembershipProvider.this.pingInterval);
                    StaticMembershipProvider.this.ping();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("staticMembershipProvider.pingThread.failed"), (Throwable)exception);
                }
            }
        }
    }

    public static class MemberMessage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int MSG_START = 1;
        public static final int MSG_STOP = 2;
        public static final int MSG_PING = 3;
        private final int msgtype;
        private final byte[] membershipId;
        private Member member;

        public MemberMessage(byte[] byArray, int n, Member member) {
            this.membershipId = byArray;
            this.msgtype = n;
            this.member = member;
        }

        public int getMsgtype() {
            return this.msgtype;
        }

        public byte[] getMembershipId() {
            return this.membershipId;
        }

        public Member getMember() {
            return this.member;
        }

        public void setMember(Member member) {
            this.member = member;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("MemberMessage[");
            stringBuilder.append("name=");
            stringBuilder.append(new String(this.membershipId));
            stringBuilder.append("; type=");
            stringBuilder.append(this.getTypeDesc());
            stringBuilder.append("; member=");
            stringBuilder.append(this.member);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        protected String getTypeDesc() {
            switch (this.msgtype) {
                case 1: {
                    return "MSG_START";
                }
                case 2: {
                    return "MSG_STOP";
                }
                case 3: {
                    return "MSG_PING";
                }
            }
            return "UNKNOWN";
        }
    }
}

