/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import org.apache.tomcat.util.res.StringManager;

public final class HexUtils {
    private static final StringManager sm = StringManager.getManager(HexUtils.class);
    private static final int[] DEC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final char[] hex = "0123456789abcdef".toCharArray();

    public static int getDec(int n) {
        try {
            return DEC[n - 48];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public static byte getHex(int n) {
        return HEX[n];
    }

    public static String toHexString(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        for (byte by : byArray) {
            stringBuilder.append(hex[(by & 0xF0) >> 4]).append(hex[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static byte[] fromHexString(String string) {
        if (string == null) {
            return null;
        }
        if ((string.length() & 1) == 1) {
            throw new IllegalArgumentException(sm.getString("hexUtils.fromHex.oddDigits"));
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[string.length() >> 1];
        for (int i = 0; i < byArray.length; ++i) {
            int n = HexUtils.getDec(cArray[2 * i]);
            int n2 = HexUtils.getDec(cArray[2 * i + 1]);
            if (n < 0 || n2 < 0) {
                throw new IllegalArgumentException(sm.getString("hexUtils.fromHex.nonHex"));
            }
            byArray[i] = (byte)((n << 4) + n2);
        }
        return byArray;
    }
}

