/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.security;

public class Escape {
    private Escape() {
    }

    public static String htmlElementContent(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("&#39;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c == '/') {
                stringBuilder.append("&#47;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.length() > string.length() ? stringBuilder.toString() : string;
    }

    public static String htmlElementContent(Object object) {
        if (object == null) {
            return "?";
        }
        try {
            return Escape.htmlElementContent(object.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String xml(String string) {
        return Escape.xml(null, string);
    }

    public static String xml(String string, String string2) {
        return Escape.xml(string, false, string2);
    }

    public static String xml(String string, boolean bl, String string2) {
        if (string2 == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("&apos;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (bl && c == '\r') {
                stringBuilder.append("&#13;");
                continue;
            }
            if (bl && c == '\n') {
                stringBuilder.append("&#10;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.length() > string2.length() ? stringBuilder.toString() : string2;
    }
}

