/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.interceptors.EncryptInterceptorMBean;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class EncryptInterceptor
extends ChannelInterceptorBase
implements EncryptInterceptorMBean {
    private static final Log log = LogFactory.getLog(EncryptInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(EncryptInterceptor.class);
    private static final String DEFAULT_ENCRYPTION_ALGORITHM = "AES/CBC/PKCS5Padding";
    private String providerName;
    private String encryptionAlgorithm = "AES/CBC/PKCS5Padding";
    private byte[] encryptionKeyBytes;
    private String encryptionKeyString;
    private BaseEncryptionManager encryptionManager;
    private static final int[] DEC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    @Override
    public void start(int n) throws ChannelException {
        this.validateChannelChain();
        if (2 == (n & 2)) {
            try {
                this.encryptionManager = EncryptInterceptor.createEncryptionManager(this.getEncryptionAlgorithm(), this.getEncryptionKeyInternal(), this.getProviderName());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ChannelException(sm.getString("encryptInterceptor.init.failed"), generalSecurityException);
            }
        }
        super.start(n);
    }

    private void validateChannelChain() throws ChannelException {
        for (ChannelInterceptor channelInterceptor = this.getPrevious(); null != channelInterceptor; channelInterceptor = channelInterceptor.getPrevious()) {
            if (!(channelInterceptor instanceof TcpFailureDetector)) continue;
            throw new ChannelConfigException(sm.getString("encryptInterceptor.tcpFailureDetector.ordering"));
        }
    }

    @Override
    public void stop(int n) throws ChannelException {
        if (2 == (n & 2)) {
            this.encryptionManager.shutdown();
        }
        super.stop(n);
    }

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        try {
            byte[] byArray = channelMessage.getMessage().getBytes();
            byte[][] byArray2 = this.encryptionManager.encrypt(byArray);
            XByteBuffer xByteBuffer = channelMessage.getMessage();
            xByteBuffer.clear();
            xByteBuffer.append(byArray2[0], 0, byArray2[0].length);
            xByteBuffer.append(byArray2[1], 0, byArray2[1].length);
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
        }
        catch (GeneralSecurityException generalSecurityException) {
            log.error((Object)sm.getString("encryptInterceptor.encrypt.failed"));
            throw new ChannelException(generalSecurityException);
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        try {
            byte[] byArray = channelMessage.getMessage().getBytes();
            byArray = this.encryptionManager.decrypt(byArray);
            XByteBuffer xByteBuffer = channelMessage.getMessage();
            xByteBuffer.clear();
            xByteBuffer.append(byArray, 0, byArray.length);
            super.messageReceived(channelMessage);
        }
        catch (GeneralSecurityException generalSecurityException) {
            log.error((Object)sm.getString("encryptInterceptor.decrypt.failed"), (Throwable)generalSecurityException);
        }
    }

    @Override
    public void setEncryptionAlgorithm(String string) {
        if (null == this.getEncryptionAlgorithm()) {
            throw new IllegalStateException(sm.getString("encryptInterceptor.algorithm.required"));
        }
        int n = string.indexOf(47);
        if (n < 0) {
            throw new IllegalArgumentException(sm.getString("encryptInterceptor.algorithm.required"));
        }
        if ((n = string.indexOf(47, n + 1)) < 0) {
            throw new IllegalArgumentException(sm.getString("encryptInterceptor.algorithm.required"));
        }
        this.encryptionAlgorithm = string;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public void setEncryptionKey(byte[] byArray) {
        this.encryptionKeyBytes = (byte[])(null == byArray ? null : (byte[])byArray.clone());
    }

    public void setEncryptionKey(String string) {
        this.encryptionKeyString = string;
        if (null == string) {
            this.setEncryptionKey((byte[])null);
        } else {
            this.setEncryptionKey(EncryptInterceptor.fromHexString(string.trim()));
        }
    }

    @Override
    public byte[] getEncryptionKey() {
        byte[] byArray = this.getEncryptionKeyInternal();
        if (null != byArray) {
            byArray = (byte[])byArray.clone();
        }
        return byArray;
    }

    private byte[] getEncryptionKeyInternal() {
        return this.encryptionKeyBytes;
    }

    public String getEncryptionKeyString() {
        return this.encryptionKeyString;
    }

    public void setEncryptionKeyString(String string) {
        this.setEncryptionKey(string);
    }

    @Override
    public void setProviderName(String string) {
        this.providerName = string;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    private static int getDec(int n) {
        try {
            return DEC[n - 48];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    private static byte[] fromHexString(String string) {
        if (string == null) {
            return null;
        }
        if ((string.length() & 1) == 1) {
            throw new IllegalArgumentException(sm.getString("hexUtils.fromHex.oddDigits"));
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[string.length() >> 1];
        for (int i = 0; i < byArray.length; ++i) {
            int n = EncryptInterceptor.getDec(cArray[2 * i]);
            int n2 = EncryptInterceptor.getDec(cArray[2 * i + 1]);
            if (n < 0 || n2 < 0) {
                throw new IllegalArgumentException(sm.getString("hexUtils.fromHex.nonHex"));
            }
            byArray[i] = (byte)((n << 4) + n2);
        }
        return byArray;
    }

    private static BaseEncryptionManager createEncryptionManager(String string, byte[] byArray, String string2) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        String string3;
        String string4;
        if (null == byArray) {
            throw new IllegalStateException(sm.getString("encryptInterceptor.key.required"));
        }
        int n = string.indexOf(47);
        if (n >= 0) {
            string4 = string.substring(0, n);
            int n2 = string.indexOf(47, n + 1);
            string3 = n2 >= 0 ? string.substring(n + 1, n2) : "CBC";
        } else {
            string4 = string;
            string3 = "CBC";
        }
        if ("GCM".equalsIgnoreCase(string3)) {
            return new GCMEncryptionManager(string, new SecretKeySpec(byArray, string4), string2);
        }
        if ("CBC".equalsIgnoreCase(string3) || "OFB".equalsIgnoreCase(string3) || "CFB".equalsIgnoreCase(string3)) {
            return new BaseEncryptionManager(string, new SecretKeySpec(byArray, string4), string2);
        }
        throw new IllegalArgumentException(sm.getString("encryptInterceptor.algorithm.unsupported-mode", string3));
    }

    static class ChannelConfigException
    extends ChannelException {
        private static final long serialVersionUID = 1L;

        public ChannelConfigException(String string) {
            super(string);
        }
    }

    private static class GCMEncryptionManager
    extends BaseEncryptionManager {
        public GCMEncryptionManager(String string, SecretKeySpec secretKeySpec, String string2) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(string, secretKeySpec, string2);
        }

        @Override
        protected int getIVSize() {
            return 12;
        }

        @Override
        protected AlgorithmParameterSpec generateIV(byte[] byArray, int n, int n2) {
            return new GCMParameterSpec(128, byArray, n, n2);
        }
    }

    private static class BaseEncryptionManager {
        private final String algorithm;
        private final int blockSize;
        private final String providerName;
        private final SecretKeySpec secretKey;
        private final ConcurrentLinkedQueue<Cipher> cipherPool;
        private final ConcurrentLinkedQueue<SecureRandom> randomPool;

        public BaseEncryptionManager(String string, SecretKeySpec secretKeySpec, String string2) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            this.algorithm = string;
            this.providerName = string2;
            this.secretKey = secretKeySpec;
            this.cipherPool = new ConcurrentLinkedQueue();
            Cipher cipher = this.createCipher();
            this.blockSize = cipher.getBlockSize();
            this.cipherPool.offer(cipher);
            this.randomPool = new ConcurrentLinkedQueue();
        }

        public void shutdown() {
            this.cipherPool.clear();
            this.randomPool.clear();
        }

        private String getAlgorithm() {
            return this.algorithm;
        }

        private SecretKeySpec getSecretKey() {
            return this.secretKey;
        }

        protected int getIVSize() {
            return this.blockSize;
        }

        private String getProviderName() {
            return this.providerName;
        }

        private Cipher createCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            String string = this.getProviderName();
            if (null == string) {
                return Cipher.getInstance(this.getAlgorithm());
            }
            return Cipher.getInstance(this.getAlgorithm(), string);
        }

        private Cipher getCipher() throws GeneralSecurityException {
            Cipher cipher = this.cipherPool.poll();
            if (null == cipher) {
                cipher = this.createCipher();
            }
            return cipher;
        }

        private void returnCipher(Cipher cipher) {
            this.cipherPool.offer(cipher);
        }

        private SecureRandom getRandom() {
            SecureRandom secureRandom = this.randomPool.poll();
            if (null == secureRandom) {
                secureRandom = new SecureRandom();
            }
            return secureRandom;
        }

        private void returnRandom(SecureRandom secureRandom) {
            this.randomPool.offer(secureRandom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[][] encrypt(byte[] byArray) throws GeneralSecurityException {
            Cipher cipher = null;
            byte[] byArray2 = this.generateIVBytes();
            try {
                cipher = this.getCipher();
                cipher.init(1, (Key)this.getSecretKey(), this.generateIV(byArray2, 0, this.getIVSize()));
                byte[][] byArrayArray = new byte[][]{byArray2, cipher.doFinal(byArray)};
                byte[][] byArrayArray2 = byArrayArray;
                return byArrayArray2;
            }
            finally {
                if (null != cipher) {
                    this.returnCipher(cipher);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] decrypt(byte[] byArray) throws GeneralSecurityException {
            Cipher cipher = null;
            int n = this.getIVSize();
            AlgorithmParameterSpec algorithmParameterSpec = this.generateIV(byArray, 0, n);
            try {
                cipher = this.getCipher();
                cipher.init(2, (Key)this.getSecretKey(), algorithmParameterSpec);
                byte[] byArray2 = cipher.doFinal(byArray, n, byArray.length - n);
                return byArray2;
            }
            finally {
                if (null != cipher) {
                    this.returnCipher(cipher);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] generateIVBytes() {
            byte[] byArray = new byte[this.getIVSize()];
            SecureRandom secureRandom = null;
            try {
                secureRandom = this.getRandom();
                secureRandom.nextBytes(byArray);
                byte[] byArray2 = byArray;
                return byArray2;
            }
            finally {
                if (null != secureRandom) {
                    this.returnRandom(secureRandom);
                }
            }
        }

        protected AlgorithmParameterSpec generateIV(byte[] byArray, int n, int n2) {
            return new IvParameterSpec(byArray, n, n2);
        }
    }
}

