/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private final ResourceBundle bundle;
    private final Locale locale;
    private static final Hashtable<String, StringManager> managers = new Hashtable();

    private StringManager(String string) {
        ResourceBundle resourceBundle;
        block4: {
            String string2 = string + ".LocalStrings";
            resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault());
            }
            catch (MissingResourceException missingResourceException) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) break block4;
                try {
                    resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault(), classLoader);
                }
                catch (MissingResourceException missingResourceException2) {
                    // empty catch block
                }
            }
        }
        this.locale = resourceBundle != null ? resourceBundle.getLocale() : null;
        this.bundle = resourceBundle;
    }

    public String getString(String string) {
        if (string == null) {
            String string2 = "key may not have a null value";
            throw new IllegalArgumentException(string2);
        }
        String string3 = null;
        try {
            if (this.bundle != null) {
                string3 = this.bundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            string3 = null;
        }
        return string3;
    }

    public String getString(String string, Object ... objectArray) {
        String string2 = this.getString(string);
        if (string2 == null) {
            string2 = string;
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        messageFormat.setLocale(this.locale);
        return messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static final synchronized StringManager getManager(String string) {
        StringManager stringManager = managers.get(string);
        if (stringManager == null) {
            stringManager = new StringManager(string);
            managers.put(string, stringManager);
        }
        return stringManager;
    }

    public static final StringManager getManager(Class<?> clazz) {
        return StringManager.getManager(clazz.getPackage().getName());
    }
}

