/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.NodeSession;
import com.mysql.cj.api.xdevapi.XSession;
import com.mysql.cj.core.conf.url.ConnectionUrl;
import com.mysql.cj.core.conf.url.HostInfo;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.InvalidConnectionAttributeException;
import com.mysql.cj.xdevapi.NodeSessionImpl;
import com.mysql.cj.xdevapi.XSessionImpl;
import java.util.Properties;

public class XSessionFactory {
    private ConnectionUrl parseUrl(String url) {
        ConnectionUrl connUrl = ConnectionUrl.getConnectionUrlInstance(url, null);
        if (connUrl.getType() != ConnectionUrl.Type.XDEVAPI_SESSION) {
            throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, "Initialization via URL failed for \"" + url + "\"");
        }
        return connUrl;
    }

    public XSession getSession(String url) {
        CJCommunicationsException latestException = null;
        ConnectionUrl connUrl = this.parseUrl(url);
        for (HostInfo hi : connUrl.getHostsList()) {
            try {
                return new XSessionImpl(hi.exposeAsProperties());
            }
            catch (CJCommunicationsException e) {
                latestException = e;
            }
        }
        if (latestException != null) {
            throw latestException;
        }
        return null;
    }

    public XSession getSession(Properties properties) {
        return new XSessionImpl(properties);
    }

    public NodeSession getNodeSession(String url) {
        ConnectionUrl connUrl = this.parseUrl(url);
        if (connUrl.getHostsList().size() > 1) {
            throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, "A NodeSession cannot be initialized with a multi-host URL.");
        }
        return new NodeSessionImpl(connUrl.getMainHost().exposeAsProperties());
    }

    public NodeSession getNodeSession(Properties properties) {
        return new NodeSessionImpl(properties);
    }
}

