/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e1rabe";
        final String metaValue_bn = "bengal\u00ed";
        final String metaValue_bo = "tibetano";
        final String metaValue_el = "grego";
        final String metaValue_gu = "guxarati";
        final String metaValue_he = "hebreo";
        final String metaValue_hy = "armenio";
        final String metaValue_ja = "xapon\u00e9s";
        final String metaValue_ka = "xeorxiano";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannar\u00e1";
        final String metaValue_ko = "coreano";
        final String metaValue_lo = "laosiano";
        final String metaValue_ml = "malabar";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmano";
        final String metaValue_or = "odi\u00e1";
        final String metaValue_si = "cingal\u00e9s";
        final String metaValue_ta = "t\u00e1mil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailand\u00e9s";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "mwl", "mirand\u00e9s" },
            { "Zsym", "s\u00edmbolos" },
            { "Zsye", "emojis" },
            { "egy", "exipcio antigo" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "AC", "Illa de Ascensi\u00f3n" },
            { "rar", "rarotongano" },
            { "tet", "tetun" },
            { "AD", "Andorra" },
            { "AE", "Os Emiratos \u00c1rabes Unidos" },
            { "nl_BE", "flamengo" },
            { "AF", "Afganist\u00e1n" },
            { "AG", "Antigua e Barbuda" },
            { "type.ca.ethiopic", "calendario et\u00edope" },
            { "AI", "Anguila" },
            { "key.tz", "fuso horario" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "A Ant\u00e1rtida" },
            { "AR", "A Arxentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "ingl\u00e9s estadounidense" },
            { "AX", "Illas \u00c5land" },
            { "AZ", "Acerbaix\u00e1n" },
            { "BA", "Bosnia e Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumyk" },
            { "BE", "B\u00e9lxica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Illas Bermudas" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe Neerland\u00e9s" },
            { "BR", "O Brasil" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "But\u00e1n" },
            { "BV", "Illa Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belar\u00fas" },
            { "BZ", "Belize" },
            { "type.ca.persian", "calendario persa" },
            { "type.nu.hebr", "numeraci\u00f3n hebrea" },
            { "CA", "O Canad\u00e1" },
            { "CC", "Illas Cocos (Keeling)" },
            { "mzn", "mazandaran\u00ed" },
            { "CD", "Rep\u00fablica Democr\u00e1tica do Congo" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Rep\u00fablica do Congo" },
            { "CH", "Su\u00edza" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Illas Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u00fan" },
            { "CN", "A China" },
            { "CO", "Colombia" },
            { "CP", "Illa Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Illa Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Chequia" },
            { "eka", "ekajuk" },
            { "DE", "Alema\u00f1a" },
            { "ace", "achin\u00e9s" },
            { "cgg", "kiga" },
            { "DG", "Diego Garc\u00eda" },
            { "type.nu.deva", "d\u00edxitos devanag\u00e1ricos" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarca" },
            { "ach", "achol\u00ed" },
            { "Brai", "braille" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "numeraci\u00f3n armenia en min\u00fascula" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "gor", "gorontalo" },
            { "zun", "zuni" },
            { "tig", "tigr\u00e9" },
            { "DZ", "Alxeria" },
            { "pag", "pangasinan" },
            { "type.d0.hwidth", "ancho medio" },
            { "EA", "Ceuta e Melilla" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "EG", "Exipto" },
            { "EH", "O S\u00e1hara Occidental" },
            { "pau", "palauano" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chr", "cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "ET", "Etiop\u00eda" },
            { "EU", "Uni\u00f3n Europea" },
            { "type.ca.gregorian", "calendario gregoriano" },
            { "EZ", "Eurozona" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "d\u00edxitos guxaratis" },
            { "ady", "adigueo" },
            { "FI", "Finlandia" },
            { "FJ", "Fixi" },
            { "FK", "Illas Malvinas" },
            { "FM", "Micronesia" },
            { "key.va", "variante rexional" },
            { "FO", "Illas Feroe" },
            { "Taml", metaValue_ta },
            { "FR", "Francia" },
            { "root", "ra\u00edz" },
            { "type.ca.indian", "Calendario nacional indio" },
            { "grc", "grego antigo" },
            { "GA", "Gab\u00f3n" },
            { "GB", "O Reino Unido" },
            { "pcm", "pidgin nixeriano" },
            { "GD", "Granada" },
            { "GE", "Xeorxia" },
            { "GF", "G\u00fciana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Xibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Illas Xeorxia do Sur e Sandwich do Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "A Guinea Bissau" },
            { "tlh", "klingon" },
            { "GY", "G\u00fciana" },
            { "ckb", "kurdo central" },
            { "zxx", "sen contido ling\u00fc\u00edstico" },
            { "de_AT", "alem\u00e1n austr\u00edaco" },
            { "HK", "Hong Kong RAE da China" },
            { "HM", "Illa Heard e Illas McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "agq", "aghem" },
            { "gsw", "alem\u00e1n su\u00edzo" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hungr\u00eda" },
            { "IC", "Illas Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "zza", "zazaki" },
            { "IL", "Israel" },
            { "IM", "Illa de Man" },
            { "IN", "A India" },
            { "IO", "Territorio Brit\u00e1nico do Oc\u00e9ano \u00cdndico" },
            { "IQ", "Iraq" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "Zmth", "notaci\u00f3n matem\u00e1tica" },
            { "type.nu.thai", "d\u00edxitos tailandeses" },
            { "type.nu.beng", "d\u00edxitos bengal\u00eds" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calendario isl\u00e1mico" },
            { "Beng", metaValue_bn },
            { "JM", "Xamaica" },
            { "JO", "Xordania" },
            { "JP", "O Xap\u00f3n" },
            { "ain", "ainu" },
            { "guz", "gusii" },
            { "type.nu.knda", "d\u00edxitos kannar\u00e1s" },
            { "de_CH", "alto alem\u00e1n su\u00edzo" },
            { "type.co.phonetic", "Orde de clasificaci\u00f3n fon\u00e9tica" },
            { "type.ca.buddhist", "calendario budista" },
            { "KE", "Kenya" },
            { "419", "Am\u00e9rica Latina" },
            { "KG", "Kirguizist\u00e1n" },
            { "KH", "Camboxa" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts e Nevis" },
            { "fr_CA", "franc\u00e9s canadense" },
            { "KP", "Corea do Norte" },
            { "KR", "Corea do Sur" },
            { "fr_CH", "franc\u00e9s su\u00edzo" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Illas Caim\u00e1n" },
            { "KZ", "Kazakist\u00e1n" },
            { "Cyrl", "cir\u00edlico" },
            { "LA", "Laos" },
            { "LB", "O L\u00edbano" },
            { "LC", "Santa Luc\u00eda" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "baixo alem\u00e1n" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marrocos" },
            { "MC", "M\u00f3naco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Illas Marshall" },
            { "ale", "aleutiano" },
            { "type.nu.vaii", "D\u00edxitos Vai" },
            { "MK", "Macedonia do Norte" },
            { "ML", "Mal\u00ed" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macau RAE da China" },
            { "MP", "Illas Marianas do Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "transliteraci\u00f3n do UNGEGN" },
            { "MU", "Mauricio" },
            { "alt", "altai meridional" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "M\u00e9xico" },
            { "type.ca.japanese", "calendario xapon\u00e9s" },
            { "MY", "Malaisia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "202", "\u00c1frica subsahariana" },
            { "type.ca.hebrew", "calendario hebreo" },
            { "type.co.dictionary", "Criterio de ordenaci\u00f3n do dicionario" },
            { "NC", "Nova Caledonia" },
            { "NE", "N\u00edxer" },
            { "NF", "Illa Norfolk" },
            { "NG", "Nixeria" },
            { "trv", "taroko" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00edses Baixos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "NZ", "Nova Zelandia" },
            { "OM", "Om\u00e1n" },
            { "anp", "angika" },
            { "crs", "seselwa (crioulo das Seychelles)" },
            { "PA", "Panam\u00e1" },
            { "type.ca.islamic-civil", "Calendario isl\u00e1mico (civil, tabular)" },
            { "en_GB", "ingl\u00e9s brit\u00e1nico" },
            { "PE", "O Per\u00fa" },
            { "PF", "A Polinesia Francesa" },
            { "PG", "Pap\u00faa-Nova Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Paquist\u00e1n" },
            { "PL", "Polonia" },
            { "ewo", "ewondo" },
            { "PM", "Saint Pierre et Miquelon" },
            { "PN", "Illas Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "numeraci\u00f3n grega en min\u00fascula" },
            { "PY", "O Paraguai" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "niu", "niueano" },
            { "QO", "Territorios afastados de Ocean\u00eda" },
            { "lez", "lezguio" },
            { "tvl", "tuval\u00e9s" },
            { "001", "Mundo" },
            { "002", "\u00c1frica" },
            { "003", "Am\u00e9rica do Norte" },
            { "RE", "Reuni\u00f3n" },
            { "005", "Am\u00e9rica do Sur" },
            { "jbo", "lojban" },
            { "009", "Ocean\u00eda" },
            { "RO", "Roman\u00eda" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Illas Salom\u00f3n" },
            { "twq", "tasawaq" },
            { "011", "\u00c1frica Occidental" },
            { "SC", "Seychelles" },
            { "SD", "O Sud\u00e1n" },
            { "013", "Am\u00e9rica Central" },
            { "SE", "Suecia" },
            { "014", "\u00c1frica Oriental" },
            { "arc", "arameo" },
            { "015", "\u00c1frica Setentrional" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "type.lb.strict", "estilo de quebra de li\u00f1a estrita" },
            { "017", "\u00c1frica Central" },
            { "SI", "Eslovenia" },
            { "018", "\u00c1frica Meridional" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "019", "Am\u00e9rica" },
            { "SK", "Eslovaquia" },
            { "SL", "Serra Leoa" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "type.nu.taml", "numeraci\u00f3n t\u00e1mil tradicional" },
            { "SR", "Suriname" },
            { "SS", "O Sud\u00e1n do Sur" },
            { "ST", "San Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "O Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Trist\u00e1n da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "sistema estadounidense de unidades" },
            { "021", "Am\u00e9rica Setentrional" },
            { "TC", "Illas Turks e Caicos" },
            { "yav", "yangben" },
            { "TD", "Chad" },
            { "TF", "Territorios Austrais Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Taxiquist\u00e1n" },
            { "029", "Caribe" },
            { "TK", "Tokelau" },
            { "TL", "Timor Leste" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "Clasificar por consonante inicial hangul" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turqu\u00eda" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "ast", "asturiano" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "sistema de escritura desco\u00f1ecido" },
            { "UA", "Ucra\u00edna" },
            { "rup", "aroman\u00e9s" },
            { "030", "Asia Oriental" },
            { "tyv", "tuvaniano" },
            { "sw_CD", "suahili congol\u00e9s" },
            { "034", "Asia Meridional" },
            { "035", "Sueste Asi\u00e1tico" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Orde de clasificaci\u00f3n pinyin" },
            { "039", "Europa Meridional" },
            { "Sinh", metaValue_si },
            { "UM", "Illas Menores Distantes dos Estados Unidos" },
            { "UN", "Naci\u00f3ns Unidas" },
            { "US", "Os Estados Unidos" },
            { "haw", "hawaiano" },
            { "type.co.gb2312han", "orde de clasifcaci\u00f3n chinesa simplificada - GB2312" },
            { "UY", "O Uruguai" },
            { "prg", "prusiano" },
            { "UZ", "Uzbekist\u00e1n" },
            { "tzm", "tamazight de Marrocos central" },
            { "type.co.stroke", "Orde de clasificaci\u00f3n polo n\u00famero de trazos" },
            { "nnh", "ngiemboon" },
            { "VA", "Cidade do Vaticano" },
            { "VC", "San Vicente e As Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Illas Virxes Brit\u00e1nicas" },
            { "VI", "Illas Virxes Estadounidenses" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis e Futuna" },
            { "type.co.traditional", "Orde de clasificaci\u00f3n tradicional" },
            { "057", "Rexi\u00f3n de Micronesia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "type.nu.finance", "N\u00fameros financeiros" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "wolaytta" },
            { "XA", "Pseudoacentos" },
            { "war", "waray-waray" },
            { "XB", "Pseudobidireccional" },
            { "awa", "awadhi" },
            { "061", "Polinesia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "non escrito" },
            { "wbp", "walrpiri" },
            { "YE", "O Iemen" },
            { "nqo", "n\u2019ko" },
            { "type.co.standard", "criterio de ordenaci\u00f3n est\u00e1ndar" },
            { "YT", "Mayotte" },
            { "ZA", "Sur\u00e1frica" },
            { "type.lb.loose", "estilo de quebra de li\u00f1a flexible" },
            { "Deva", "devan\u00e1gari" },
            { "type.nu.geor", "numeraci\u00f3n xeorxiana" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rexi\u00f3n desco\u00f1ecida" },
            { "type.ms.metric", "sistema m\u00e9trico decimal" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "nso", "sesotho do norte" },
            { "type.nu.telu", "d\u00edxitos de telugu" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "numeraci\u00f3n financeira chinesa simplificada" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "d\u00edxitos indoar\u00e1bigos ampliados" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "d\u00edxitos de ancho completo" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "lrc", "luri setentrional" },
            { "udm", "udmurto" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "Calendario isl\u00e1mico (Arabia Saudita," },
            { "sad", "sandawe" },
            { "type.nu.roman", "numeraci\u00f3n romana" },
            { "sah", "iacuto" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "type.d0.npinyin", "Num\u00e9rico" },
            { "type.nu.native", "D\u00edxitos orixinais" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "type.d0.fwidth", "ancho completo" },
            { "sbp", "sangu" },
            { "nyn", "nyankole" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "lus", "mizo" },
            { "ban", "balin\u00e9s" },
            { "luy", "luyia" },
            { "bas", "basaa" },
            { "es_ES", "espa\u00f1ol de Espa\u00f1a" },
            { "sco", "escoc\u00e9s" },
            { "scn", "siciliano" },
            { "aa", "afar" },
            { "ab", "abkhazo" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amh\u00e1rico" },
            { "Arab", metaValue_ar },
            { "an", "aragon\u00e9s" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "silabarios xaponeses" },
            { "as", "assam\u00e9s" },
            { "av", "avar" },
            { "sdh", "kurdo meridional" },
            { "ay", "aimar\u00e1" },
            { "az", "acerbaixano" },
            { "ba", "baxkir" },
            { "type.co.unihan", "Criterio de ordenaci\u00f3n radical-trazo" },
            { "be", "belaruso" },
            { "bg", "b\u00falgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bret\u00f3n" },
            { "bs", "bosn\u00edaco" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "d\u00edxitos laosianos" },
            { "seh", "sena" },
            { "ca", "catal\u00e1n" },
            { "ses", "koyraboro senni" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "Orya", metaValue_or },
            { "cs", "checo" },
            { "cu", "eslavo eclesi\u00e1stico" },
            { "cv", "chuvaxo" },
            { "cy", "gal\u00e9s" },
            { "type.nu.ethi", "numeraci\u00f3n et\u00edope" },
            { "da", "dinamarqu\u00e9s" },
            { "pt_PT", "portugu\u00e9s de Portugal" },
            { "de", "alem\u00e1n" },
            { "type.cf.standard", "formato de moeda est\u00e1ndar" },
            { "bem", "bemba" },
            { "type.nu.mong", "D\u00edxitos mongoles" },
            { "dv", "divehi" },
            { "es_419", "espa\u00f1ol de Am\u00e9rica" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "calendario chin\u00e9s" },
            { "dje", "zarma" },
            { "type.nu.grek", "numeraci\u00f3n grega" },
            { "ee", "ewe" },
            { "type.lb.normal", "estilo de quebra de li\u00f1a normal" },
            { "ro_MD", "moldavo" },
            { "el", metaValue_el },
            { "en", "ingl\u00e9s" },
            { "eo", "esperanto" },
            { "type.co.big5han", "Orde de clasificaci\u00f3n chinesa tradicional - Big5" },
            { "es", "espa\u00f1ol" },
            { "et", "estoniano" },
            { "Hanb", "han con bopomofo" },
            { "eu", "\u00e9uscaro" },
            { "Hang", "hangul" },
            { "shi", "tachelhit" },
            { "hsb", "alto sorbio" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "fa", "persa" },
            { "Hans", "simplificado" },
            { "type.nu.latn", "d\u00edxitos occidentais" },
            { "Hant", "tradicional" },
            { "ff", "fula" },
            { "fi", "fin\u00e9s" },
            { "fj", "fixiano" },
            { "fon", "fon" },
            { "bgn", "baluchi occidental" },
            { "yue", "canton\u00e9s" },
            { "fo", "fero\u00e9s" },
            { "type.m0.bgn", "transliteraci\u00f3n do BGN" },
            { "umb", "umbundu" },
            { "fr", "franc\u00e9s" },
            { "fy", "fris\u00f3n occidental" },
            { "ga", "irland\u00e9s" },
            { "gd", "ga\u00e9lico escoc\u00e9s" },
            { "gl", "galego" },
            { "gn", "guaran\u00ed" },
            { "bho", "bhojpuri" },
            { "und", "lingua desco\u00f1ecida" },
            { "type.ca.ethiopic-amete-alem", "Calendario Amete Alem et\u00edope" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bin", "bini" },
            { "hr", "croata" },
            { "ht", "crioulo haitiano" },
            { "hu", "h\u00fangaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesio" },
            { "type.nu.tibt", "d\u00edxitos tibetanos" },
            { "ig", "igbo" },
            { "ii", "yi sichuan\u00e9s" },
            { "io", "ido" },
            { "is", "island\u00e9s" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "sma", "saami meridional" },
            { "jv", "xavan\u00e9s" },
            { "mad", "madur\u00e9s" },
            { "smj", "saami de Lule" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "smn", "saami de Inari" },
            { "ka", metaValue_ka },
            { "bla", "siksik\u00e1" },
            { "mak", "makasar" },
            { "sms", "saami skolt" },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kazako" },
            { "kl", "groenland\u00e9s" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "caxemir\u00e9s" },
            { "ku", "kurdo" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnico" },
            { "ky", "kirguiz" },
            { "snk", "soninke" },
            { "la", "lat\u00edn" },
            { "lb", "luxemburgu\u00e9s" },
            { "type.nu.mlym", "d\u00edxitos malabares" },
            { "lg", "ganda" },
            { "li", "limburgu\u00e9s" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulano" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "sistema imperial de unidades" },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "let\u00f3n" },
            { "mg", "malgaxe" },
            { "mh", "marshal\u00e9s" },
            { "type.co.ducet", "criterio de ordenaci\u00f3n Unicode predeterminado" },
            { "mi", "maor\u00ed" },
            { "mk", "macedonio" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malaio" },
            { "mt", "malt\u00e9s" },
            { "my", metaValue_my },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "dsb", "baixo sorbio" },
            { "na", "nauruano" },
            { "type.co.search", "busca de car\u00e1cter xeral" },
            { "nb", "noruegu\u00e9s bokm\u00e5l" },
            { "nd", "ndebele setentrional" },
            { "ne", "nepal\u00ed" },
            { "ng", "ndonga" },
            { "nl", "neerland\u00e9s" },
            { "nn", "noruegu\u00e9s nynorsk" },
            { "no", "noruegu\u00e9s" },
            { "nr", "ndebele meridional" },
            { "nv", "navajo" },
            { "ny", "chewa" },
            { "kac", "kachin" },
            { "kab", "cabila" },
            { "oc", "occitano" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "mer", "meru" },
            { "type.nu.armn", "numeraci\u00f3n armenia" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetio" },
            { "kbd", "cabardiano" },
            { "mfe", "crioulo mauriciano" },
            { "srn", "sranan tongo" },
            { "pa", "panxab\u00ed" },
            { "dua", "duala" },
            { "pl", "polaco" },
            { "type.ca.dangi", "calendario dangi" },
            { "ps", "paxto" },
            { "pt", "portugu\u00e9s" },
            { "key.co", "criterio de ordenaci\u00f3n" },
            { "pt_BR", "portugu\u00e9s do Brasil" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "formato de moeda" },
            { "key.ca", "calendario" },
            { "Laoo", metaValue_lo },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "sistema de 24 horas (0\u201323)" },
            { "type.hc.h24", "sistema de 24 horas (1\u201324)" },
            { "ssy", "saho" },
            { "type.nu.mymr", "d\u00edxitos birmanos" },
            { "qu", "quechua" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "Ethi", "et\u00edope" },
            { "type.hc.h12", "sistema de 12 horas (1\u201312)" },
            { "type.hc.h11", "sistema de 12 horas (0\u201311)" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "key.cu", "moeda" },
            { "ro", "roman\u00e9s" },
            { "type.nu.orya", "d\u00edxitos do odi\u00e1" },
            { "type.nu.hanidec", "numeraci\u00f3n decimal chinesa" },
            { "ru", "ruso" },
            { "rw", "ki\u00f1aruanda" },
            { "kea", "caboverdiano" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "ingl\u00e9s australiano" },
            { "sa", "s\u00e1nscrito" },
            { "sc", "sardo" },
            { "sd", "sindhi" },
            { "se", "saami setentrional" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbocroata" },
            { "si", metaValue_si },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somal\u00ed" },
            { "type.nu.arab", "d\u00edxitos indoar\u00e1bigos" },
            { "sq", "alban\u00e9s" },
            { "sr", "serbio" },
            { "ss", "suazi" },
            { "type.cf.account", "formato de moeda contable" },
            { "st", "sesotho" },
            { "su", "sundan\u00e9s" },
            { "sv", "sueco" },
            { "sw", "suahili" },
            { "type.nu.hantfin", "numeraci\u00f3n financeira chinesa tradicional" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "143", "Asia Central" },
            { "te", metaValue_te },
            { "145", "Asia Occidental" },
            { "tg", "taxico" },
            { "th", metaValue_th },
            { "ti", "tigri\u00f1a" },
            { "bug", "bugin\u00e9s" },
            { "kfo", "koro" },
            { "en_CA", "ingl\u00e9s canadense" },
            { "tk", "turkmeno" },
            { "tl", "tagalo" },
            { "tn", "tswana" },
            { "to", "tongano" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "numeraci\u00f3n xaponesa" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "swb", "comoriano" },
            { "tt", "t\u00e1rtaro" },
            { "tw", "twi" },
            { "ty", "tahitiano" },
            { "150", "Europa" },
            { "151", "Europa do Leste" },
            { "154", "Europa Setentrional" },
            { "dzg", "dazaga" },
            { "155", "Europa Occidental" },
            { "ug", "uigur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "com\u00fan" },
            { "uk", "ucra\u00edno" },
            { "type.ca.coptic", "Calendario c\u00f3ptico" },
            { "ur", "urd\u00fa" },
            { "xal", "calmuco" },
            { "uz", "uzbeko" },
            { "kha", "khasi" },
            { "nds_NL", "baixo sax\u00f3n" },
            { "ve", "venda" },
            { "type.ca.roc", "calendario Minguo" },
            { "vi", "vietnamita" },
            { "khq", "koyra chiini" },
            { "key.hc", "ciclo horario (12 ou 24)" },
            { "vo", "volapuk" },
            { "quc", "quich\u00e9" },
            { "gaa", "ga" },
            { "wa", "val\u00f3n" },
            { "gag", "gagauz" },
            { "syr", "sir\u00edaco" },
            { "Grek", metaValue_el },
            { "wo", "w\u00f3lof" },
            { "zgh", "tamazight marroqu\u00ed est\u00e1ndar" },
            { "ar_001", "\u00e1rabe est\u00e1ndar moderno" },
            { "Cans", "Silabario aborixe canadiano unificado" },
            { "Mong", metaValue_mn },
            { "mni", "manipuri" },
            { "Latn", "latino" },
            { "type.nu.hans", "numeraci\u00f3n chinesa simplificada" },
            { "type.nu.hant", "numeraci\u00f3n chinesa tradicional" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "numeraci\u00f3n romana en min\u00fasculas" },
            { "byn", "blin" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "yi", "yiddish" },
            { "mos", "mossi" },
            { "yo", "ioruba" },
            { "type.nu.traditional", "Numeros tradicionais" },
            { "es_MX", "espa\u00f1ol de M\u00e9xico" },
            { "vai", "vai" },
            { "kln", "kalenjin" },
            { "zh", "chin\u00e9s" },
            { "Bopo", "bopomofo" },
            { "key.lb", "estilo de quebra de li\u00f1a" },
            { "zu", "zul\u00fa" },
            { "type.co.phonebook", "orde de clasificaci\u00f3n da gu\u00eda telef\u00f3nica" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "numeraci\u00f3n financeira xaponesa" },
            { "gez", "ge\u2019ez" },
            { "type.co.reformed", "Criterio de ordenaci\u00f3n reformado" },
            { "ebu", "embu" },
            { "zh_Hans", "chin\u00e9s simplificado" },
            { "koi", "komi permio" },
            { "kok", "konkani" },
            { "zh_Hant", "chin\u00e9s tradicional" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "d\u00edxitos khmer" },
            { "ilo", "ilocano" },
            { "mua", "mundang" },
            { "type.nu.guru", "d\u00edxitos do gurmukhi" },
            { "mul", "varias linguas" },
            { "key.ms", "sistema internacional de unidades" },
            { "mus", "creek" },
            { "gil", "kiribatiano" },
            { "type.nu.tamldec", "d\u00edxitos do t\u00e1mil" },
            { "krc", "carachaio-b\u00e1lcara" },
            { "inh", "inguxo" },
            { "krl", "carelio" },
            { "efi", "efik" },
            { "key.nu", "n\u00fameros" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
