/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.Comparator;

public class ControlFlowGraph<N>
extends LinkedDirectedGraph<N, Branch> {
    private final DiGraph.DiGraphNode<N, Branch> implicitReturn = this.createNode((Object)null);
    private final DiGraph.DiGraphNode<N, Branch> entry;

    ControlFlowGraph(N entry, boolean nodeAnnotations, boolean edgeAnnotations) {
        super(nodeAnnotations, edgeAnnotations);
        this.entry = this.createNode((Object)entry);
    }

    public DiGraph.DiGraphNode<N, Branch> getImplicitReturn() {
        return this.implicitReturn;
    }

    public DiGraph.DiGraphNode<N, Branch> getEntry() {
        return this.entry;
    }

    public boolean isImplicitReturn(DiGraph.DiGraphNode<N, Branch> node) {
        return node == this.implicitReturn;
    }

    public Comparator<DiGraph.DiGraphNode<N, Branch>> getOptionalNodeComparator(boolean isForward) {
        return null;
    }

    public static boolean isEnteringNewCfgNode(Node n) {
        Node parent = n.getParent();
        switch (parent.getToken()) {
            case BLOCK: 
            case ROOT: 
            case SCRIPT: 
            case TRY: {
                return true;
            }
            case FUNCTION: {
                return n != parent.getSecondChild();
            }
            case WHILE: 
            case DO: 
            case IF: {
                return NodeUtil.getConditionExpression(parent) != n;
            }
            case FOR: {
                return NodeUtil.getConditionExpression(parent) != n;
            }
            case FOR_IN: {
                return n != parent.getFirstChild();
            }
            case SWITCH: 
            case CASE: 
            case CATCH: 
            case WITH: {
                return n != parent.getFirstChild();
            }
        }
        return false;
    }

    public String toString() {
        String s = "CFG:\n";
        for (GraphvizGraph.GraphvizEdge e : this.getGraphvizEdges()) {
            s = s + e.toString() + '\n';
        }
        return s;
    }

    public static abstract class AbstractCfgNodeTraversalCallback
    implements NodeTraversal.Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (parent == null) {
                return true;
            }
            return !ControlFlowGraph.isEnteringNewCfgNode(n);
        }
    }

    public static enum Branch {
        ON_TRUE,
        ON_FALSE,
        UNCOND,
        ON_EX,
        SYN_BLOCK;


        public boolean isConditional() {
            return this == ON_TRUE || this == ON_FALSE;
        }
    }
}

