/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.List;

public final class ImplicitNullabilityCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType IMPLICITLY_NULLABLE_JSDOC = DiagnosticType.disabled("JSC_IMPLICITLY_NULLABLE_JSDOC", "Name {0} in JSDoc is implicitly nullable, and is discouraged by the style guide.\nPlease add a '!' to make it non-nullable, or a '?' to make it explicitly nullable.");
    public static final DiagnosticType IMPLICITLY_NONNULL_JSDOC = DiagnosticType.disabled("JSC_IMPLICITLY_NONNULL_JSDOC", "Name {0} in JSDoc is implicitly non-null, and is discouraged by the style guide.\nPlease add a '!' to make it explicit.");
    private static final ImmutableSet<String> NULLABILITY_OMITTED_TYPES = ImmutableSet.of("*", "?", "bigint", "boolean", "null", "number", new String[]{"string", "symbol", "undefined", "void"});
    private final AbstractCompiler compiler;

    public ImplicitNullabilityCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    public static ImmutableList<Result> findImplicitNullabilityResults(JSDocInfo info, final NodeTraversal t) {
        if (info == null) {
            return ImmutableList.of();
        }
        final List<Node> thrownTypes = Lists.transform(info.getThrownTypes(), new Function<JSTypeExpression, Node>(){

            @Override
            public Node apply(JSTypeExpression expr) {
                return expr.getRoot();
            }
        });
        final ImmutableList.Builder builder = ImmutableList.builder();
        for (Node typeRoot : info.getTypeNodes()) {
            NodeUtil.visitPreOrder(typeRoot, new NodeUtil.Visitor(){

                @Override
                public void visit(Node node) {
                    if (!node.isString()) {
                        return;
                    }
                    if (thrownTypes.contains(node)) {
                        return;
                    }
                    Node parent = node.getParent();
                    if (parent != null) {
                        switch (parent.getToken()) {
                            case BANG: 
                            case QMARK: 
                            case THIS: 
                            case NEW: 
                            case TYPEOF: {
                                return;
                            }
                            case PIPE: {
                                Node gp = parent.getParent();
                                if (gp != null && gp.getToken() == Token.QMARK) {
                                    return;
                                }
                                for (Node child : parent.children()) {
                                    if ((!child.isString() || !child.getString().equals("null")) && child.getToken() != Token.QMARK) continue;
                                    return;
                                }
                                break;
                            }
                        }
                    }
                    String typeName = node.getString();
                    if (NULLABILITY_OMITTED_TYPES.contains(typeName)) {
                        return;
                    }
                    JSTypeRegistry registry = t.getCompiler().getTypeRegistry();
                    if (registry.getType(t.getScope(), typeName) == null) {
                        return;
                    }
                    JSType type = registry.createTypeFromCommentNode(node);
                    Nullability nullability = type.isNullable() ? Nullability.NULLABLE : Nullability.NONNULL;
                    builder.add(Result.create(node, nullability));
                }
            }, Predicates.alwaysTrue());
        }
        return builder.build();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node p) {
        JSDocInfo info = n.getJSDocInfo();
        for (Result r : ImplicitNullabilityCheck.findImplicitNullabilityResults(info, t)) {
            Node stringNode = r.getNode();
            DiagnosticType dt = r.getNullability().isNullable() ? IMPLICITLY_NULLABLE_JSDOC : IMPLICITLY_NONNULL_JSDOC;
            this.compiler.report(JSError.make(stringNode, dt, stringNode.getString()));
        }
    }

    public static class Result {
        final Node node;
        final Nullability nullability;

        private Result(Node node, Nullability nullability) {
            Preconditions.checkArgument(node.isString());
            this.node = node;
            this.nullability = nullability;
        }

        static Result create(Node node, Nullability nullability) {
            return new Result(node, nullability);
        }

        public Nullability getNullability() {
            return this.nullability;
        }

        public Node getNode() {
            return this.node;
        }
    }

    public static enum Nullability {
        NONNULL,
        NULLABLE;


        public boolean isNullable() {
            return this == NULLABLE;
        }
    }
}

