/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.PropertyRenamingDiagnostics;
import com.google.javascript.jscomp.disambiguate.FlatType;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.rhino.Node;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

final class UseSiteRenamer {
    private static final String INVALIDATED_NAME_VALUE = "<INVALIDATED>";
    private final ImmutableMap<String, CheckLevel> propsToCheckLevel;
    private final Consumer<JSError> errorCb;
    private final Consumer<Node> mutationCb;
    private final ImmutableSetMultimap.Builder<String, String> renamingIndex = ImmutableSetMultimap.builder();

    UseSiteRenamer(ImmutableMap<String, CheckLevel> propsToCheckLevel, Consumer<JSError> errorCb, Consumer<Node> mutationCb) {
        this.propsToCheckLevel = propsToCheckLevel;
        this.errorCb = errorCb;
        this.mutationCb = mutationCb;
    }

    void renameUses(PropertyClustering prop) {
        if (prop.isInvalidated()) {
            this.renamingIndex.put((Object)prop.getName(), (Object)INVALIDATED_NAME_VALUE);
            CheckLevel level = this.propsToCheckLevel.getOrDefault(prop.getName(), CheckLevel.OFF);
            if (!level.equals(CheckLevel.OFF)) {
                this.errorCb.accept(UseSiteRenamer.createInvalidationError(level, prop.getName()));
            }
            return;
        }
        ImmutableMap<FlatType, String> clusterNames = UseSiteRenamer.createAllClusterNames(prop);
        if (clusterNames.size() <= 1) {
            this.renamingIndex.put((Object)prop.getName(), (Object)prop.getName());
            return;
        }
        this.renamingIndex.putAll((Object)prop.getName(), (Iterable)clusterNames.values());
        for (Map.Entry<Node, FlatType> usage : prop.getUseSites().entrySet()) {
            Node site = usage.getKey();
            FlatType flatRep = prop.getClusters().find(usage.getValue());
            String newName = clusterNames.get(flatRep);
            if (Objects.equals(newName, site.getString())) continue;
            site.setString(newName);
            this.mutationCb.accept(site);
        }
    }

    ImmutableSetMultimap<String, String> getRenamingIndex() {
        return this.renamingIndex.build();
    }

    private static ImmutableMap<FlatType, String> createAllClusterNames(PropertyClustering prop) {
        return prop.getClusters().allRepresentatives().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), r -> UseSiteRenamer.createClusterName(prop, r)));
    }

    private static String createClusterName(PropertyClustering prop, FlatType rep) {
        if (Objects.equals(prop.getExternsClusterRep(), rep)) {
            return prop.getName();
        }
        return "JSC$" + rep.getId() + "_" + prop.getName();
    }

    private static JSError createInvalidationError(CheckLevel level, String name) {
        return JSError.make(null, -1, -1, level, PropertyRenamingDiagnostics.INVALIDATION, name, "", "", "");
    }
}

