/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.ParsingUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.javascript.jscomp.parsing.parser.TemplateLiteralToken;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.AmbientDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.AwaitExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallSignatureTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionForTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionIfTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyDefinitionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyGetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMethodTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertySetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DynamicImportTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EnumDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForAwaitOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.GenericTypeListTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportMetaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.IndexSignatureTree;
import com.google.javascript.jscomp.parsing.parser.trees.InterfaceDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.IterRestTree;
import com.google.javascript.jscomp.parsing.parser.trees.IterSpreadTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NamespaceDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.NamespaceNameTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewTargetExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectSpreadTree;
import com.google.javascript.jscomp.parsing.parser.trees.OptionalCallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.OptionalMemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.OptionalMemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.OptionalParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParameterizedTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RecordTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralPortionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateSubstitutionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeAliasTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeNameTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeQueryTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypedParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnionTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.UpdateExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NonJSDocComment;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.TypeDeclarationsIR;
import com.google.javascript.rhino.dtoa.DToA;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class IRFactory {
    static final String GETTER_ERROR_MESSAGE = "getters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String SETTER_ERROR_MESSAGE = "setters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String INVALID_ES3_PROP_NAME = "Keywords and reserved words are not allowed as unquoted property names in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String INVALID_ES5_STRICT_OCTAL = "Octal integer literals are not supported in strict mode.";
    static final String INVALID_OCTAL_DIGIT = "Invalid octal digit in octal literal.";
    static final String STRING_CONTINUATION_WARNING = "String continuations are not recommended. See https://google.github.io/styleguide/jsguide.html#features-strings-no-line-continuations";
    static final String OCTAL_STRING_LITERAL_WARNING = "Octal literals in strings are not supported in this language mode.";
    static final String DUPLICATE_PARAMETER = "Duplicate parameter name \"%s\"";
    static final String DUPLICATE_LABEL = "Duplicate label \"%s\"";
    static final String UNLABELED_BREAK = "unlabelled break must be inside loop or switch";
    static final String UNEXPECTED_CONTINUE = "continue must be inside loop";
    static final String UNEXPECTED_LABELLED_CONTINUE = "continue can only use labeles of iteration statements";
    static final String UNEXPECTED_RETURN = "return must be inside function";
    static final String UNEXPECTED_NEW_DOT_TARGET = "new.target must be inside a function";
    static final String UNDEFINED_LABEL = "undefined label \"%s\"";
    private final String sourceString;
    private final StaticSourceFile sourceFile;
    private final String sourceName;
    private final Config config;
    private final ErrorReporter errorReporter;
    private final TransformDispatcher transformDispatcher;
    private static final ImmutableSet<String> USE_STRICT_ONLY = ImmutableSet.of("use strict");
    private static final ImmutableSet<String> ALLOWED_DIRECTIVES = USE_STRICT_ONLY;
    private static final ImmutableSet<String> ES5_RESERVED_KEYWORDS = ImmutableSet.of("class", "const", "enum", "export", "extends", "import", new String[]{"super"});
    private static final ImmutableSet<String> ES5_STRICT_RESERVED_KEYWORDS = ImmutableSet.of("class", "const", "enum", "export", "extends", "import", new String[]{"super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"});
    @Nullable
    private final Set<String> reservedKeywords;
    private final Set<Comment> parsedComments = new HashSet<Comment>();
    JSDocInfoBuilder fileLevelJsDocBuilder;
    JSDocInfo fileOverviewInfo = null;
    private final Node templateNode;
    private final UnmodifiableIterator<Comment> nextCommentIter;
    private final UnmodifiableIterator<Comment> nextNonJSDocCommentIter;
    private Comment currentComment;
    private Comment currentNonJSDocComment;
    private boolean currentFileIsExterns = false;
    private boolean hasJsDocTypeAnnotations = false;
    private FeatureSet features = FeatureSet.BARE_MINIMUM;
    private Node resultNode;

    private IRFactory(String sourceString, StaticSourceFile sourceFile, Config config, ErrorReporter errorReporter, ImmutableList<Comment> comments) {
        this.sourceString = sourceString;
        this.nextCommentIter = comments.iterator();
        this.nextNonJSDocCommentIter = comments.iterator();
        this.currentComment = IRFactory.skipNonJsDoc(this.nextCommentIter);
        this.currentNonJSDocComment = IRFactory.skipJsDocComments(this.nextNonJSDocCommentIter);
        this.sourceFile = sourceFile;
        this.templateNode = this.createTemplateNode();
        this.fileLevelJsDocBuilder = new JSDocInfoBuilder(config.jsDocParsingMode().shouldParseDescriptions());
        this.sourceName = sourceFile == null ? null : sourceFile.getName();
        this.config = config;
        this.errorReporter = errorReporter;
        this.transformDispatcher = new TransformDispatcher();
        this.reservedKeywords = config.strictMode().isStrict() ? ES5_STRICT_RESERVED_KEYWORDS : (config.languageMode() == Config.LanguageMode.ECMASCRIPT3 ? null : ES5_RESERVED_KEYWORDS);
    }

    private static Comment skipNonJsDoc(UnmodifiableIterator<Comment> comments) {
        while (comments.hasNext()) {
            Comment comment = (Comment)comments.next();
            if (comment.type != Comment.Type.JSDOC) continue;
            return comment;
        }
        return null;
    }

    private Node createTemplateNode() {
        Node templateNode = new Node(com.google.javascript.rhino.Token.SCRIPT);
        templateNode.setStaticSourceFile(this.sourceFile);
        return templateNode;
    }

    public static IRFactory transformTree(ProgramTree tree, StaticSourceFile sourceFile, String sourceString, Config config, ErrorReporter errorReporter) {
        IRFactory irFactory = new IRFactory(sourceString, sourceFile, config, errorReporter, tree.sourceComments);
        Node n = irFactory.transformDispatcher.process(tree);
        irFactory.setSourceInfo(n, tree);
        if (tree.sourceComments != null) {
            for (Comment comment : tree.sourceComments) {
                if (comment.type != Comment.Type.JSDOC && comment.type != Comment.Type.IMPORTANT || irFactory.parsedComments.contains(comment)) continue;
                irFactory.handlePossibleFileOverviewJsDoc(comment);
            }
        }
        irFactory.setFileOverviewJsDoc(n);
        irFactory.validateAll(n);
        irFactory.resultNode = n;
        return irFactory;
    }

    Node getResultNode() {
        return this.resultNode;
    }

    FeatureSet getFeatures() {
        return this.features;
    }

    private void validateAll(Node n) {
        ArrayDeque<Node> work = new ArrayDeque<Node>();
        while (n != null) {
            this.validate(n);
            Node nextSibling = n.getNext();
            Node firstChild = n.getFirstChild();
            if (firstChild != null) {
                if (nextSibling != null) {
                    work.push(nextSibling);
                }
                n = firstChild;
                continue;
            }
            if (nextSibling != null) {
                n = nextSibling;
                continue;
            }
            n = (Node)work.poll();
        }
        Preconditions.checkState(work.isEmpty());
    }

    private void validate(Node n) {
        this.validateParameters(n);
        this.validateBreakContinue(n);
        this.validateReturn(n);
        this.validateNewDotTarget(n);
        this.validateLabel(n);
        this.validateBlockScopedFunctions(n);
    }

    private void validateReturn(Node n) {
        if (n.isReturn()) {
            Node parent = n;
            while ((parent = parent.getParent()) != null) {
                if (!parent.isFunction()) continue;
                return;
            }
            this.errorReporter.error(UNEXPECTED_RETURN, this.sourceName, n.getLineno(), n.getCharno());
        }
    }

    private void validateNewDotTarget(Node n) {
        if (n.getToken() == com.google.javascript.rhino.Token.NEW_TARGET) {
            Node parent = n;
            while ((parent = parent.getParent()) != null) {
                if (!parent.isFunction()) continue;
                return;
            }
            this.errorReporter.error(UNEXPECTED_NEW_DOT_TARGET, this.sourceName, n.getLineno(), n.getCharno());
        }
    }

    private void validateBreakContinue(Node n) {
        block8: {
            block9: {
                if (!n.isBreak() && !n.isContinue()) break block8;
                Node labelName = n.getFirstChild();
                if (labelName == null) break block9;
                Node parent = n.getParent();
                while (!parent.isLabel() || !IRFactory.labelsMatch(parent, labelName)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(SimpleFormat.format(UNDEFINED_LABEL, labelName.getString()), this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!parent.isLabel() || !IRFactory.labelsMatch(parent, labelName) || !n.isContinue() || IRFactory.isContinueTarget(parent.getLastChild())) break block8;
                this.errorReporter.error(UNEXPECTED_LABELLED_CONTINUE, this.sourceName, n.getLineno(), n.getCharno());
                break block8;
            }
            if (n.isContinue()) {
                Node parent = n.getParent();
                while (!IRFactory.isContinueTarget(parent)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(UNEXPECTED_CONTINUE, this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
            } else {
                Node parent = n.getParent();
                while (!IRFactory.isBreakTarget(parent)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(UNLABELED_BREAK, this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
            }
        }
    }

    private static boolean isBreakTarget(Node n) {
        switch (n.getToken()) {
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case WHILE: 
            case DO: 
            case SWITCH: {
                return true;
            }
        }
        return false;
    }

    private static boolean isContinueTarget(Node n) {
        switch (n.getToken()) {
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case WHILE: 
            case DO: {
                return true;
            }
        }
        return false;
    }

    private static boolean labelsMatch(Node label, Node labelName) {
        return label.getFirstChild().getString().equals(labelName.getString());
    }

    private void validateLabel(Node n) {
        if (n.isLabel()) {
            Node labelName = n.getFirstChild();
            for (Node parent = n.getParent(); parent != null && !parent.isFunction(); parent = parent.getParent()) {
                if (!parent.isLabel() || !IRFactory.labelsMatch(parent, labelName)) continue;
                this.errorReporter.error(SimpleFormat.format(DUPLICATE_LABEL, labelName.getString()), this.sourceName, n.getLineno(), n.getCharno());
                break;
            }
        }
    }

    private void validateParameters(Node n) {
        if (n.isParamList()) {
            LinkedHashSet seenNames = new LinkedHashSet();
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                ParsingUtil.getParamOrPatternNames(c, param -> {
                    String paramName = param.getString();
                    if (!seenNames.add(paramName)) {
                        this.errorReporter.warning(SimpleFormat.format(DUPLICATE_PARAMETER, paramName), this.sourceName, param.getLineno(), param.getCharno());
                    }
                });
            }
        }
    }

    private void validateBlockScopedFunctions(Node n) {
        if (n.isFunction() && n.getParent().isBlock() && !n.getGrandparent().isFunction()) {
            this.maybeWarnForFeature(n, FeatureSet.Feature.BLOCK_SCOPED_FUNCTION_DECLARATION);
        }
    }

    JSDocInfo recordJsDoc(SourceRange location, JSDocInfo info) {
        if (info != null && info.hasTypeInformation()) {
            this.hasJsDocTypeAnnotations = true;
            if (this.features.version().equals("ts")) {
                this.errorReporter.error("Can only have JSDoc or inline type annotations, not both", this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
            }
        }
        return info;
    }

    void recordTypeSyntax(SourceRange location) {
        if (this.hasJsDocTypeAnnotations) {
            this.errorReporter.error("Can only have JSDoc or inline type annotations, not both", this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
        }
    }

    private void setFileOverviewJsDoc(Node irNode) {
        JSDocInfo rootNodeJsDoc = this.fileLevelJsDocBuilder.build();
        if (rootNodeJsDoc != null) {
            irNode.setJSDocInfo(rootNodeJsDoc);
        }
        if (this.fileOverviewInfo != null) {
            if (irNode.getJSDocInfo() != null && irNode.getJSDocInfo().getLicense() != null) {
                JSDocInfoBuilder builder = JSDocInfoBuilder.copyFrom(this.fileOverviewInfo);
                builder.recordLicense(irNode.getJSDocInfo().getLicense());
                this.fileOverviewInfo = builder.build();
            }
            irNode.setJSDocInfo(this.fileOverviewInfo);
        }
    }

    Node transformBlock(ParseTree node) {
        Node irNode = this.transform(node);
        if (!irNode.isBlock()) {
            if (irNode.isEmpty()) {
                irNode.setToken(com.google.javascript.rhino.Token.BLOCK);
            } else {
                Node newBlock = this.newNode(com.google.javascript.rhino.Token.BLOCK, irNode);
                this.setSourceInfo(newBlock, irNode);
                irNode = newBlock;
            }
            irNode.setIsAddedBlock(true);
        }
        return irNode;
    }

    private boolean handlePossibleFileOverviewJsDoc(JsDocInfoParser jsDocParser) {
        if (jsDocParser.getFileOverviewJSDocInfo() != this.fileOverviewInfo) {
            this.fileOverviewInfo = jsDocParser.getFileOverviewJSDocInfo();
            if (this.fileOverviewInfo.isExterns()) {
                this.currentFileIsExterns = true;
            }
            return true;
        }
        return false;
    }

    private void handlePossibleFileOverviewJsDoc(Comment comment) {
        JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment);
        this.parsedComments.add(comment);
        this.handlePossibleFileOverviewJsDoc(jsDocParser);
    }

    private Comment getJsDoc(SourceRange location) {
        Comment closestPreviousComment = null;
        while (this.hasPendingCommentBefore(location)) {
            closestPreviousComment = this.currentComment;
            this.currentComment = IRFactory.skipNonJsDoc(this.nextCommentIter);
        }
        return closestPreviousComment;
    }

    private Comment getJsDoc(ParseTree tree) {
        return this.getJsDoc(tree.location);
    }

    private Comment getJsDoc(Token token) {
        return this.getJsDoc(token.location);
    }

    private boolean hasPendingCommentBefore(SourceRange location) {
        return this.currentComment != null && this.currentComment.location.end.offset <= location.start.offset;
    }

    private boolean hasPendingCommentBefore(ParseTree tree) {
        return this.hasPendingCommentBefore(tree.location);
    }

    private JSDocInfo handleJsDoc(Comment comment) {
        if (comment != null) {
            JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment);
            this.parsedComments.add(comment);
            if (!this.handlePossibleFileOverviewJsDoc(jsDocParser)) {
                return this.recordJsDoc(comment.location, jsDocParser.retrieveAndResetParsedJSDocInfo());
            }
        }
        return null;
    }

    private JSDocInfo handleJsDoc(ParseTree node) {
        if (!this.shouldAttachJSDocHere(node)) {
            return null;
        }
        return this.handleJsDoc(this.getJsDoc(node));
    }

    JSDocInfo handleJsDoc(Token token) {
        return this.handleJsDoc(this.getJsDoc(token));
    }

    private boolean shouldAttachJSDocHere(ParseTree tree) {
        switch (tree.type) {
            case EXPRESSION_STATEMENT: 
            case LABELLED_STATEMENT: 
            case EXPORT_DECLARATION: 
            case TEMPLATE_SUBSTITUTION: {
                return false;
            }
            case CALL_EXPRESSION: 
            case CONDITIONAL_EXPRESSION: 
            case BINARY_OPERATOR: 
            case MEMBER_EXPRESSION: 
            case MEMBER_LOOKUP_EXPRESSION: 
            case UPDATE_EXPRESSION: {
                ParseTree nearest = IRFactory.findNearestNode(tree);
                return nearest.type != ParseTreeType.PAREN_EXPRESSION;
            }
        }
        return true;
    }

    private static NonJSDocComment combineCommentsIntoSingleComment(ArrayList<Comment> comments) {
        String result = "";
        Iterator<Comment> itr = comments.iterator();
        int prevCommentEndLine = Integer.MAX_VALUE;
        int completeCommentBegin = Integer.MAX_VALUE;
        int completeCommentEnd = 0;
        while (itr.hasNext()) {
            Comment currComment = itr.next();
            if (currComment.location.start.offset < completeCommentBegin) {
                completeCommentBegin = currComment.location.start.offset;
            }
            if (currComment.location.end.offset > completeCommentEnd) {
                completeCommentEnd = currComment.location.end.offset;
            }
            while (prevCommentEndLine < currComment.location.start.line) {
                result = result + "\n";
                ++prevCommentEndLine;
            }
            result = result + currComment.value;
            if (!itr.hasNext()) continue;
            prevCommentEndLine = currComment.location.end.line;
        }
        SourcePosition start = comments.get((int)0).location.start;
        SourcePosition end = Iterables.getLast(comments).location.end;
        NonJSDocComment nonJSDocComment = new NonJSDocComment(start, end, result);
        nonJSDocComment.setEndsAsLineComment(Iterables.getLast(comments).type == Comment.Type.LINE);
        return nonJSDocComment;
    }

    private static Comment skipJsDocComments(UnmodifiableIterator<Comment> comments) {
        while (comments.hasNext()) {
            Comment comment = (Comment)comments.next();
            if (comment.type != Comment.Type.LINE && comment.type != Comment.Type.BLOCK) continue;
            return comment;
        }
        return null;
    }

    private boolean hasPendingNonJSDocCommentBefore(SourceRange location) {
        return this.currentNonJSDocComment != null && this.currentNonJSDocComment.location.end.offset <= location.start.offset;
    }

    private boolean hasPendingNonJSDocCommentBefore(SourcePosition pos) {
        return this.currentNonJSDocComment != null && this.currentNonJSDocComment.location.end.line <= pos.line && this.currentNonJSDocComment.location.end.offset <= pos.offset;
    }

    private ArrayList<Comment> getNonJSDocComments(SourceRange location) {
        ArrayList<Comment> previousComments = new ArrayList<Comment>();
        while (this.hasPendingNonJSDocCommentBefore(location)) {
            previousComments.add(this.currentNonJSDocComment);
            this.currentNonJSDocComment = IRFactory.skipJsDocComments(this.nextNonJSDocCommentIter);
        }
        return previousComments;
    }

    private ArrayList<Comment> getNonJSDocComments(Token token) {
        return this.getNonJSDocComments(token.location);
    }

    private ArrayList<Comment> getNonJSDocComments(ParseTree tree) {
        return this.getNonJSDocComments(tree.location);
    }

    private ArrayList<Comment> getNonJSDocCommentsBefore(SourcePosition pos) {
        ArrayList<Comment> previousComments = new ArrayList<Comment>();
        while (this.hasPendingNonJSDocCommentBefore(pos)) {
            previousComments.add(this.currentNonJSDocComment);
            this.currentNonJSDocComment = IRFactory.skipJsDocComments(this.nextNonJSDocCommentIter);
        }
        return previousComments;
    }

    private static ParseTree findNearestNode(ParseTree tree) {
        block9: while (true) {
            switch (tree.type) {
                case EXPRESSION_STATEMENT: {
                    tree = tree.asExpressionStatement().expression;
                    continue block9;
                }
                case CALL_EXPRESSION: {
                    tree = tree.asCallExpression().operand;
                    continue block9;
                }
                case BINARY_OPERATOR: {
                    tree = tree.asBinaryOperator().left;
                    continue block9;
                }
                case CONDITIONAL_EXPRESSION: {
                    tree = tree.asConditionalExpression().condition;
                    continue block9;
                }
                case MEMBER_EXPRESSION: {
                    tree = tree.asMemberExpression().operand;
                    continue block9;
                }
                case MEMBER_LOOKUP_EXPRESSION: {
                    tree = tree.asMemberLookupExpression().operand;
                    continue block9;
                }
                case UPDATE_EXPRESSION: {
                    tree = tree.asUpdateExpression().operand;
                    continue block9;
                }
            }
            break;
        }
        return tree;
    }

    Node transform(ParseTree tree) {
        ArrayList<Comment> nonJSDocComments;
        JSDocInfo info = this.handleJsDoc(tree);
        NonJSDocComment associatedNonJSDocComment = null;
        if (this.config.jsDocParsingMode() == Config.JsDocParsing.INCLUDE_ALL_COMMENTS && !(nonJSDocComments = this.getNonJSDocComments(tree)).isEmpty()) {
            associatedNonJSDocComment = IRFactory.combineCommentsIntoSingleComment(nonJSDocComments);
        }
        Node node = this.transformDispatcher.process(tree);
        if (info != null) {
            node = this.maybeInjectCastNode(tree, info, node);
            node.setJSDocInfo(info);
        }
        if (this.config.jsDocParsingMode() == Config.JsDocParsing.INCLUDE_ALL_COMMENTS && associatedNonJSDocComment != null) {
            node.setNonJSDocComment(associatedNonJSDocComment);
        }
        this.setSourceInfo(node, tree);
        return node;
    }

    private Node maybeInjectCastNode(ParseTree node, JSDocInfo info, Node irNode) {
        if (node.type == ParseTreeType.PAREN_EXPRESSION && info.hasType()) {
            irNode = this.newNode(com.google.javascript.rhino.Token.CAST, irNode);
        }
        return irNode;
    }

    Node transformNodeWithInlineComments(ParseTree tree) {
        ArrayList<Comment> nonJSDocComments;
        JSDocInfo info = this.handleInlineJsDoc(tree);
        NonJSDocComment associatedNonJSDocComment = null;
        if (this.config.jsDocParsingMode() == Config.JsDocParsing.INCLUDE_ALL_COMMENTS && !(nonJSDocComments = this.getNonJSDocComments(tree)).isEmpty()) {
            associatedNonJSDocComment = IRFactory.combineCommentsIntoSingleComment(nonJSDocComments);
            associatedNonJSDocComment.setIsInline(true);
        }
        Node node = this.transformDispatcher.process(tree);
        if (info != null) {
            node.setJSDocInfo(info);
        }
        if (this.config.jsDocParsingMode() == Config.JsDocParsing.INCLUDE_ALL_COMMENTS && associatedNonJSDocComment != null) {
            node.setNonJSDocComment(associatedNonJSDocComment);
        }
        this.setSourceInfo(node, tree);
        return node;
    }

    JSDocInfo handleInlineJsDoc(ParseTree node) {
        return this.handleInlineJsDoc(node.location);
    }

    JSDocInfo handleInlineJsDoc(Token token) {
        return this.handleInlineJsDoc(token.location);
    }

    JSDocInfo handleInlineJsDoc(SourceRange location) {
        Comment comment = this.getJsDoc(location);
        if (comment != null && !comment.value.contains("@")) {
            return this.recordJsDoc(location, this.parseInlineTypeDoc(comment));
        }
        return this.handleJsDoc(comment);
    }

    Node transformNumberAsString(LiteralToken token) {
        Node irNode;
        if (token.type == TokenType.BIGINT) {
            BigInteger value = this.normalizeBigInt(token);
            irNode = this.newStringNode(value.toString());
        } else {
            double value = this.normalizeNumber(token);
            irNode = this.newStringNode(DToA.numberToString(value));
        }
        JSDocInfo jsDocInfo = this.handleJsDoc(token);
        if (jsDocInfo != null) {
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, token);
        return irNode;
    }

    static int lineno(ParseTree node) {
        return IRFactory.lineno(node.location.start);
    }

    static int lineno(Token token) {
        return IRFactory.lineno(token.location.start);
    }

    static int lineno(SourcePosition location) {
        return location.line + 1;
    }

    static int charno(ParseTree node) {
        return IRFactory.charno(node.location.start);
    }

    static int charno(Token token) {
        return IRFactory.charno(token.location.start);
    }

    static int charno(SourcePosition location) {
        return location.column;
    }

    String languageFeatureWarningMessage(FeatureSet.Feature feature) {
        Config.LanguageMode forFeature = Config.LanguageMode.minimumRequiredFor(feature);
        if (forFeature == Config.LanguageMode.UNSUPPORTED) {
            return "This language feature is not currently supported by the compiler: " + (Object)((Object)feature);
        }
        return "This language feature is only supported for " + (Object)((Object)Config.LanguageMode.minimumRequiredFor(feature)) + " mode or better: " + (Object)((Object)feature);
    }

    void maybeWarnForFeature(ParseTree node, FeatureSet.Feature feature) {
        this.features = this.features.with(feature);
        if (!this.isSupportedForInputLanguageMode(feature)) {
            this.errorReporter.warning(this.languageFeatureWarningMessage(feature), this.sourceName, IRFactory.lineno(node), IRFactory.charno(node));
        }
    }

    void maybeWarnForFeature(Token token, FeatureSet.Feature feature) {
        this.features = this.features.with(feature);
        if (!this.isSupportedForInputLanguageMode(feature)) {
            this.errorReporter.warning(this.languageFeatureWarningMessage(feature), this.sourceName, IRFactory.lineno(token), IRFactory.charno(token));
        }
    }

    void maybeWarnForFeature(Node node, FeatureSet.Feature feature) {
        this.features = this.features.with(feature);
        if (!this.isSupportedForInputLanguageMode(feature)) {
            this.errorReporter.warning(this.languageFeatureWarningMessage(feature), this.sourceName, node.getLineno(), node.getCharno());
        }
    }

    void setSourceInfo(Node node, Node ref) {
        node.setLineno(ref.getLineno());
        node.setCharno(ref.getCharno());
        this.setLengthFrom(node, ref);
    }

    void setSourceInfo(Node irNode, ParseTree node) {
        if (irNode.getLineno() == -1) {
            this.setSourceInfo(irNode, node.location.start, node.location.end);
        }
    }

    void setSourceInfo(Node irNode, Token token) {
        this.setSourceInfo(irNode, token.location.start, token.location.end);
    }

    void setSourceInfo(Node node, SourcePosition start, SourcePosition end) {
        if (node.getLineno() == -1) {
            int lineno = IRFactory.lineno(start);
            node.setLineno(lineno);
            int charno = IRFactory.charno(start);
            node.setCharno(charno);
            this.setLength(node, start, end);
        }
    }

    private JsDocInfoParser createJsDocInfoParser(Comment node) {
        String comment = node.value;
        int lineno = IRFactory.lineno(node.location.start);
        int charno = IRFactory.charno(node.location.start);
        int position = node.location.start.offset;
        int numOpeningChars = 3;
        JsDocInfoParser jsdocParser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, charno + numOpeningChars), comment, position, this.templateNode, this.config, this.errorReporter);
        jsdocParser.setFileLevelJsDocBuilder(this.fileLevelJsDocBuilder);
        jsdocParser.setFileOverviewJSDocInfo(this.fileOverviewInfo);
        if (node.type == Comment.Type.IMPORTANT && node.value.length() > 0) {
            jsdocParser.parseImportantComment();
        } else {
            jsdocParser.parse();
        }
        return jsdocParser;
    }

    private JSDocInfo parseInlineTypeDoc(Comment node) {
        String comment = node.value;
        int lineno = IRFactory.lineno(node.location.start);
        int charno = IRFactory.charno(node.location.start);
        int numOpeningChars = 3;
        JsDocInfoParser parser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, charno + numOpeningChars), comment, node.location.start.offset, this.templateNode, this.config, this.errorReporter);
        return parser.parseInlineTypeDoc();
    }

    void setLength(Node node, SourcePosition start, SourcePosition end) {
        node.setLength(end.offset - start.offset);
    }

    void setLengthFrom(Node node, Node ref) {
        node.setLength(ref.getLength());
    }

    private void reportErrorIfYieldOrAwaitInDefaultValue(Node defaultValueNode) {
        Node awaitNode;
        Node yieldNode = IRFactory.findNodeTypeInExpression(defaultValueNode, com.google.javascript.rhino.Token.YIELD);
        if (yieldNode != null) {
            this.errorReporter.error("`yield` is illegal in parameter default value.", yieldNode.getSourceFileName(), yieldNode.getLineno(), yieldNode.getCharno());
        }
        if ((awaitNode = IRFactory.findNodeTypeInExpression(defaultValueNode, com.google.javascript.rhino.Token.AWAIT)) != null) {
            this.errorReporter.error("`await` is illegal in parameter default value.", awaitNode.getSourceFileName(), awaitNode.getLineno(), awaitNode.getCharno());
        }
    }

    private static Node findNodeTypeInExpression(Node expressionNode, com.google.javascript.rhino.Token token) {
        ArrayDeque<Node> worklist = new ArrayDeque<Node>();
        worklist.add(expressionNode);
        while (!worklist.isEmpty()) {
            Node node = (Node)worklist.remove();
            if (node.getToken() == token) {
                return node;
            }
            if (node.isFunction() || node.isClass()) continue;
            for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                worklist.add(child);
            }
        }
        return null;
    }

    String normalizeRegex(LiteralToken token) {
        String value = token.value;
        int lastSlash = value.lastIndexOf(47);
        int cur = value.indexOf(92);
        if (cur == -1) {
            return value.substring(1, lastSlash);
        }
        StringBuilder result = new StringBuilder();
        int start = 1;
        while (cur != -1) {
            result.append(value, start, cur);
            char c = value.charAt(++cur);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '?': 
                case 'B': 
                case 'D': 
                case 'P': 
                case 'S': 
                case 'W': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'f': 
                case 'n': 
                case 'p': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case '{': 
                case '|': 
                case '}': {
                    result.append('\\');
                }
            }
            result.append(c);
            start = cur + 1;
            cur = value.indexOf(92, start);
        }
        result.append(value, start, lastSlash);
        return result.toString();
    }

    String normalizeString(LiteralToken token, boolean templateLiteral) {
        String value = token.value;
        value = value.replaceAll("\r\n?", "\n");
        int start = templateLiteral ? 0 : 1;
        int cur = value.indexOf(92);
        if (cur == -1) {
            return templateLiteral ? value : value.substring(1, value.length() - 1);
        }
        StringBuilder result = new StringBuilder();
        while (cur != -1) {
            result.append(value, start, cur);
            char c = value.charAt(++cur);
            switch (c) {
                case 'b': {
                    result.append('\b');
                    break;
                }
                case 'f': {
                    result.append('\f');
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'v': {
                    result.append('\u000b');
                    break;
                }
                case '\n': {
                    this.maybeWarnForFeature(token, FeatureSet.Feature.STRING_CONTINUATION);
                    this.errorReporter.warning(STRING_CONTINUATION_WARNING, this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int numDigits = cur + 1 < value.length() && IRFactory.isOctalDigit(value.charAt(cur + 1)) ? (cur + 2 < value.length() && IRFactory.isOctalDigit(value.charAt(cur + 2)) ? 3 : 2) : 1;
                    if ((this.inStrictContext() || templateLiteral) && (c != '0' || numDigits != 1)) {
                        this.errorReporter.warning(OCTAL_STRING_LITERAL_WARNING, this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
                    }
                    result.append((char)Integer.parseInt(value.substring(cur, cur + numDigits), 8));
                    cur += numDigits - 1;
                    break;
                }
                case 'x': {
                    result.append((char)(IRFactory.hexdigit(value.charAt(cur + 1)) * 16 + IRFactory.hexdigit(value.charAt(cur + 2))));
                    cur += 2;
                    break;
                }
                case 'u': {
                    String hexDigits;
                    int escapeEnd;
                    if (value.charAt(cur + 1) != '{') {
                        escapeEnd = cur + 5;
                        hexDigits = value.substring(cur + 1, escapeEnd);
                    } else {
                        escapeEnd = cur + 2;
                        while (Character.digit(value.charAt(escapeEnd), 16) >= 0) {
                            ++escapeEnd;
                        }
                        hexDigits = value.substring(cur + 2, escapeEnd);
                        ++escapeEnd;
                    }
                    int codePointValue = Integer.parseInt(hexDigits, 16);
                    if (codePointValue > 0x10FFFF) {
                        this.errorReporter.error("Undefined Unicode code-point", this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
                        result.append("\\u{");
                        result.append(hexDigits);
                        result.append("}");
                    } else {
                        result.append(Character.toChars(codePointValue));
                    }
                    cur = escapeEnd - 1;
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            start = cur + 1;
            cur = value.indexOf(92, start);
        }
        result.append(value, start, templateLiteral ? value.length() : value.length() - 1);
        return result.toString();
    }

    boolean isSupportedForInputLanguageMode(FeatureSet.Feature feature) {
        return this.config.languageMode().featureSet.has(feature);
    }

    boolean isEs5OrBetterMode() {
        return this.config.languageMode().featureSet.contains(FeatureSet.ES5);
    }

    private boolean inStrictContext() {
        return this.config.strictMode().isStrict();
    }

    double normalizeNumber(LiteralToken token) {
        String value = token.value;
        if (value.contains("_")) {
            value = this.removeNumericSeparators(value, token);
        }
        SourceRange location = token.location;
        int length = value.length();
        Preconditions.checkState(length > 0);
        Preconditions.checkState(value.charAt(0) != '-' && value.charAt(0) != '+');
        if (value.charAt(0) == '.') {
            return Double.parseDouble('0' + value);
        }
        if (value.charAt(0) == '0' && length > 1) {
            switch (value.charAt(1)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return Double.parseDouble(value);
                }
                case 'B': 
                case 'b': {
                    this.maybeWarnForFeature(token, FeatureSet.Feature.BINARY_LITERALS);
                    double v = 0.0;
                    int c = 1;
                    while (++c < length) {
                        v = v * 2.0 + (double)IRFactory.binarydigit(value.charAt(c));
                    }
                    return v;
                }
                case 'O': 
                case 'o': {
                    this.maybeWarnForFeature(token, FeatureSet.Feature.OCTAL_LITERALS);
                    double v = 0.0;
                    int c = 1;
                    while (++c < length) {
                        v = v * 8.0 + (double)IRFactory.octaldigit(value.charAt(c));
                    }
                    return v;
                }
                case 'X': 
                case 'x': {
                    double v = 0.0;
                    int c = 1;
                    while (++c < length) {
                        v = v * 16.0 + (double)IRFactory.hexdigit(value.charAt(c));
                    }
                    return v;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    double v = 0.0;
                    int c = 0;
                    while (++c < length) {
                        char digit = value.charAt(c);
                        if (IRFactory.isOctalDigit(digit)) {
                            v = v * 8.0 + (double)IRFactory.octaldigit(digit);
                            continue;
                        }
                        this.errorReporter.error(INVALID_OCTAL_DIGIT, this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
                        return 0.0;
                    }
                    if (this.inStrictContext()) {
                        this.errorReporter.error(INVALID_ES5_STRICT_OCTAL, this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
                    } else {
                        this.errorReporter.warning(INVALID_ES5_STRICT_OCTAL, this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
                    }
                    return v;
                }
                case '8': 
                case '9': {
                    this.errorReporter.error(INVALID_OCTAL_DIGIT, this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
                    return 0.0;
                }
            }
            throw new IllegalStateException("Unexpected character in number literal: " + value.charAt(1));
        }
        return Double.parseDouble(value);
    }

    BigInteger normalizeBigInt(LiteralToken token) {
        int length;
        String value = token.value;
        if ((value = value.substring(0, value.indexOf(110))).contains("_")) {
            value = this.removeNumericSeparators(value, token);
        }
        Preconditions.checkState((length = value.length()) > 0);
        Preconditions.checkState(value.charAt(0) != '-' && value.charAt(0) != '+');
        if (value.charAt(0) == '0' && length > 1) {
            switch (value.charAt(1)) {
                case 'B': 
                case 'b': {
                    this.maybeWarnForFeature(token, FeatureSet.Feature.BINARY_LITERALS);
                    return new BigInteger(value.substring(2), 2);
                }
                case 'O': 
                case 'o': {
                    this.maybeWarnForFeature(token, FeatureSet.Feature.OCTAL_LITERALS);
                    return new BigInteger(value.substring(2), 8);
                }
                case 'X': 
                case 'x': {
                    return new BigInteger(value.substring(2), 16);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    throw new IllegalStateException("Nonzero BigInts can't have a leading zero");
                }
            }
            throw new IllegalStateException("Unexpected character in bigint literal: " + value.charAt(1));
        }
        return new BigInteger(value);
    }

    private String removeNumericSeparators(String value, LiteralToken token) {
        this.maybeWarnForFeature(token, FeatureSet.Feature.NUMERIC_SEPARATOR);
        return value.replace("_", "");
    }

    private static int binarydigit(char c) {
        if (c >= '0' && c <= '1') {
            return c - 48;
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    private static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }

    private static int octaldigit(char c) {
        if (IRFactory.isOctalDigit(c)) {
            return c - 48;
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    private static int hexdigit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    static com.google.javascript.rhino.Token transformBooleanTokenType(TokenType token) {
        switch (token) {
            case TRUE: {
                return com.google.javascript.rhino.Token.TRUE;
            }
            case FALSE: {
                return com.google.javascript.rhino.Token.FALSE;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    static com.google.javascript.rhino.Token transformUpdateTokenType(TokenType token) {
        switch (token) {
            case PLUS_PLUS: {
                return com.google.javascript.rhino.Token.INC;
            }
            case MINUS_MINUS: {
                return com.google.javascript.rhino.Token.DEC;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    static com.google.javascript.rhino.Token transformUnaryTokenType(TokenType token) {
        switch (token) {
            case BANG: {
                return com.google.javascript.rhino.Token.NOT;
            }
            case TILDE: {
                return com.google.javascript.rhino.Token.BITNOT;
            }
            case PLUS: {
                return com.google.javascript.rhino.Token.POS;
            }
            case MINUS: {
                return com.google.javascript.rhino.Token.NEG;
            }
            case DELETE: {
                return com.google.javascript.rhino.Token.DELPROP;
            }
            case TYPEOF: {
                return com.google.javascript.rhino.Token.TYPEOF;
            }
            case VOID: {
                return com.google.javascript.rhino.Token.VOID;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    static com.google.javascript.rhino.Token transformBinaryTokenType(TokenType token) {
        switch (token) {
            case BAR: {
                return com.google.javascript.rhino.Token.BITOR;
            }
            case CARET: {
                return com.google.javascript.rhino.Token.BITXOR;
            }
            case AMPERSAND: {
                return com.google.javascript.rhino.Token.BITAND;
            }
            case EQUAL_EQUAL: {
                return com.google.javascript.rhino.Token.EQ;
            }
            case NOT_EQUAL: {
                return com.google.javascript.rhino.Token.NE;
            }
            case OPEN_ANGLE: {
                return com.google.javascript.rhino.Token.LT;
            }
            case LESS_EQUAL: {
                return com.google.javascript.rhino.Token.LE;
            }
            case CLOSE_ANGLE: {
                return com.google.javascript.rhino.Token.GT;
            }
            case GREATER_EQUAL: {
                return com.google.javascript.rhino.Token.GE;
            }
            case LEFT_SHIFT: {
                return com.google.javascript.rhino.Token.LSH;
            }
            case RIGHT_SHIFT: {
                return com.google.javascript.rhino.Token.RSH;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return com.google.javascript.rhino.Token.URSH;
            }
            case PLUS: {
                return com.google.javascript.rhino.Token.ADD;
            }
            case MINUS: {
                return com.google.javascript.rhino.Token.SUB;
            }
            case STAR: {
                return com.google.javascript.rhino.Token.MUL;
            }
            case SLASH: {
                return com.google.javascript.rhino.Token.DIV;
            }
            case PERCENT: {
                return com.google.javascript.rhino.Token.MOD;
            }
            case STAR_STAR: {
                return com.google.javascript.rhino.Token.EXPONENT;
            }
            case EQUAL_EQUAL_EQUAL: {
                return com.google.javascript.rhino.Token.SHEQ;
            }
            case NOT_EQUAL_EQUAL: {
                return com.google.javascript.rhino.Token.SHNE;
            }
            case IN: {
                return com.google.javascript.rhino.Token.IN;
            }
            case INSTANCEOF: {
                return com.google.javascript.rhino.Token.INSTANCEOF;
            }
            case COMMA: {
                return com.google.javascript.rhino.Token.COMMA;
            }
            case EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN;
            }
            case BAR_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_BITOR;
            }
            case CARET_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_BITXOR;
            }
            case AMPERSAND_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_BITAND;
            }
            case LEFT_SHIFT_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_LSH;
            }
            case RIGHT_SHIFT_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_RSH;
            }
            case UNSIGNED_RIGHT_SHIFT_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_URSH;
            }
            case PLUS_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_ADD;
            }
            case MINUS_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_SUB;
            }
            case STAR_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_MUL;
            }
            case STAR_STAR_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_EXPONENT;
            }
            case SLASH_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_DIV;
            }
            case PERCENT_EQUAL: {
                return com.google.javascript.rhino.Token.ASSIGN_MOD;
            }
            case OR: {
                return com.google.javascript.rhino.Token.OR;
            }
            case AND: {
                return com.google.javascript.rhino.Token.AND;
            }
            case QUESTION_QUESTION: {
                return com.google.javascript.rhino.Token.COALESCE;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    Node newNode(com.google.javascript.rhino.Token type) {
        return new Node(type).clonePropsFrom(this.templateNode);
    }

    Node newNode(com.google.javascript.rhino.Token type, Node child1) {
        return new Node(type, child1).clonePropsFrom(this.templateNode);
    }

    Node newNode(com.google.javascript.rhino.Token type, Node child1, Node child2) {
        return new Node(type, child1, child2).clonePropsFrom(this.templateNode);
    }

    Node newNode(com.google.javascript.rhino.Token type, Node child1, Node child2, Node child3) {
        return new Node(type, child1, child2, child3).clonePropsFrom(this.templateNode);
    }

    Node newStringNode(String value) {
        return IR.string(value).clonePropsFrom(this.templateNode);
    }

    Node newStringNode(com.google.javascript.rhino.Token type, String value) {
        return Node.newString(type, value).clonePropsFrom(this.templateNode);
    }

    Node newTemplateLitStringNode(String cooked, String raw) {
        return Node.newTemplateLitString(cooked, raw).clonePropsFrom(this.templateNode);
    }

    Node newNumberNode(Double value) {
        return IR.number(value).clonePropsFrom(this.templateNode);
    }

    Node newBigIntNode(BigInteger value) {
        return Node.newBigInt(value).clonePropsFrom(this.templateNode);
    }

    Node cloneProps(Node n) {
        if (!n.hasProps()) {
            n.clonePropsFrom(this.templateNode);
        }
        for (Node child : n.children()) {
            this.cloneProps(child);
        }
        return n;
    }

    private class TransformDispatcher {
        private TransformDispatcher() {
        }

        private Node processObjectLitKeyAsString(Token token) {
            Node ret;
            if (token == null) {
                return this.createMissingExpressionNode();
            }
            if (token.type == TokenType.IDENTIFIER) {
                ret = this.processName(token.asIdentifier(), true);
            } else if (token.type == TokenType.NUMBER || token.type == TokenType.BIGINT) {
                ret = IRFactory.this.transformNumberAsString(token.asLiteral());
                ret.putBooleanProp(Node.QUOTED_PROP, true);
            } else {
                ret = this.processString(token.asLiteral());
                ret.putBooleanProp(Node.QUOTED_PROP, true);
            }
            Preconditions.checkState(ret.isString());
            return ret;
        }

        Node processComprehension(ComprehensionTree tree) {
            return this.unsupportedLanguageFeature(tree, "array/generator comprehensions");
        }

        Node processComprehensionFor(ComprehensionForTree tree) {
            return this.unsupportedLanguageFeature(tree, "array/generator comprehensions");
        }

        Node processComprehensionIf(ComprehensionIfTree tree) {
            return this.unsupportedLanguageFeature(tree, "array/generator comprehensions");
        }

        Node processArrayLiteral(ArrayLiteralExpressionTree tree) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.ARRAYLIT);
            node.setTrailingComma(tree.hasTrailingComma);
            for (ParseTree child : tree.elements) {
                Node c = IRFactory.this.transform(child);
                node.addChildToBack(c);
            }
            return node;
        }

        Node processArrayPattern(ArrayPatternTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.ARRAY_DESTRUCTURING);
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.ARRAY_PATTERN);
            for (ParseTree child : tree.elements) {
                Node elementNode;
                switch (child.type) {
                    case DEFAULT_PARAMETER: {
                        elementNode = this.processDefaultParameter(child.asDefaultParameter());
                        break;
                    }
                    case ITER_REST: {
                        IRFactory.this.maybeWarnForFeature(child, FeatureSet.Feature.ARRAY_PATTERN_REST);
                        elementNode = IRFactory.this.transformNodeWithInlineComments(child);
                        break;
                    }
                    default: {
                        elementNode = IRFactory.this.transformNodeWithInlineComments(child);
                    }
                }
                node.addChildToBack(elementNode);
            }
            return node;
        }

        Node processObjectPattern(ObjectPatternTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.OBJECT_DESTRUCTURING);
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.OBJECT_PATTERN);
            for (ParseTree child : tree.fields) {
                Node childNode = this.processObjectPatternElement(child);
                node.addChildToBack(childNode);
            }
            return node;
        }

        private Node processObjectPatternElement(ParseTree child) {
            switch (child.type) {
                case DEFAULT_PARAMETER: {
                    return this.processObjectPatternShorthandWithDefault(child.asDefaultParameter());
                }
                case PROPERTY_NAME_ASSIGNMENT: {
                    return this.processObjectPatternPropertyNameAssignment(child.asPropertyNameAssignment());
                }
                case COMPUTED_PROPERTY_DEFINITION: {
                    ComputedPropertyDefinitionTree computedPropertyDefinition = child.asComputedPropertyDefinition();
                    return this.processObjectPatternComputedPropertyDefinition(computedPropertyDefinition);
                }
                case OBJECT_REST: {
                    IRFactory.this.maybeWarnForFeature(child, FeatureSet.Feature.OBJECT_PATTERN_REST);
                    Node target = IRFactory.this.transformNodeWithInlineComments(child.asObjectRest().assignmentTarget);
                    Node rest = IRFactory.this.newNode(com.google.javascript.rhino.Token.OBJECT_REST, target);
                    IRFactory.this.setSourceInfo(rest, child);
                    return rest;
                }
            }
            throw new IllegalStateException("Unexpected object pattern element: " + child);
        }

        private Node processObjectPatternShorthandWithDefault(DefaultParameterTree defaultParameter) {
            Node defaultValueNode = this.processDefaultParameter(defaultParameter);
            Node nameNode = defaultValueNode.getFirstChild();
            Node stringKeyNode = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.STRING_KEY, nameNode.getString());
            IRFactory.this.setSourceInfo(stringKeyNode, nameNode);
            stringKeyNode.setShorthandProperty(true);
            stringKeyNode.addChildToBack(defaultValueNode);
            return stringKeyNode;
        }

        private Node processObjectPatternPropertyNameAssignment(PropertyNameAssignmentTree propertyNameAssignment) {
            Node valueNode;
            Node key = this.processObjectLitKeyAsString(propertyNameAssignment.name);
            key.setToken(com.google.javascript.rhino.Token.STRING_KEY);
            ParseTree targetTree = propertyNameAssignment.value;
            if (targetTree == null) {
                valueNode = this.processNameWithInlineComments(propertyNameAssignment.name.asIdentifier());
                key.setShorthandProperty(true);
            } else {
                valueNode = this.processDestructuringElementTarget(targetTree);
            }
            key.addChildToFront(valueNode);
            return key;
        }

        private Node processDestructuringElementTarget(ParseTree targetTree) {
            Node valueNode = targetTree.type == ParseTreeType.DEFAULT_PARAMETER ? this.processDefaultParameter(targetTree.asDefaultParameter()) : (targetTree.type == ParseTreeType.IDENTIFIER_EXPRESSION ? this.processNameWithInlineComments(targetTree.asIdentifierExpression()) : IRFactory.this.transformNodeWithInlineComments(targetTree));
            return valueNode;
        }

        private Node processObjectPatternComputedPropertyDefinition(ComputedPropertyDefinitionTree computedPropertyDefinition) {
            IRFactory.this.maybeWarnForFeature(computedPropertyDefinition, FeatureSet.Feature.COMPUTED_PROPERTIES);
            Node expressionNode = IRFactory.this.transform(computedPropertyDefinition.property);
            ParseTree valueTree = computedPropertyDefinition.value;
            Node valueNode = this.processDestructuringElementTarget(valueTree);
            Node computedPropertyNode = IRFactory.this.newNode(com.google.javascript.rhino.Token.COMPUTED_PROP, expressionNode, valueNode);
            IRFactory.this.setSourceInfo(computedPropertyNode, computedPropertyDefinition);
            return computedPropertyNode;
        }

        Node processAstRoot(ProgramTree rootNode) {
            Node scriptNode = IRFactory.this.newNode(com.google.javascript.rhino.Token.SCRIPT);
            for (ParseTree child : rootNode.sourceElements) {
                scriptNode.addChildToBack(IRFactory.this.transform(child));
            }
            this.parseDirectives(scriptNode);
            boolean isGoogModule = this.isGoogModuleFile(scriptNode);
            if (isGoogModule || IRFactory.this.features.has(FeatureSet.Feature.MODULES)) {
                Node moduleNode = IRFactory.this.newNode(com.google.javascript.rhino.Token.MODULE_BODY);
                IRFactory.this.setSourceInfo(moduleNode, rootNode);
                moduleNode.addChildrenToBack(scriptNode.removeChildren());
                scriptNode.addChildToBack(moduleNode);
                if (isGoogModule) {
                    scriptNode.putBooleanProp(Node.GOOG_MODULE, true);
                } else {
                    scriptNode.putBooleanProp(Node.ES6_MODULE, true);
                }
            }
            return scriptNode;
        }

        private boolean isGoogModuleFile(Node scriptNode) {
            Preconditions.checkArgument(scriptNode.isScript());
            if (!scriptNode.hasChildren()) {
                return false;
            }
            Node exprResult = scriptNode.getFirstChild();
            if (!exprResult.isExprResult()) {
                return false;
            }
            Node call = exprResult.getFirstChild();
            if (!call.isCall()) {
                return false;
            }
            return call.getFirstChild().matchesQualifiedName("goog.module");
        }

        private void parseDirectives(Node node) {
            ImmutableSet.Builder directives = null;
            while (this.isDirective(node.getFirstChild())) {
                String directive = node.removeFirstChild().getFirstChild().getString();
                if (directives == null) {
                    directives = new ImmutableSet.Builder();
                }
                directives.add(directive);
            }
            if (directives != null) {
                ImmutableCollection result = directives.build();
                if (result.size() == 1 && result.contains("use strict")) {
                    result = USE_STRICT_ONLY;
                }
                node.setDirectives((Set<String>)((Object)result));
            }
        }

        private boolean isDirective(Node n) {
            if (n == null) {
                return false;
            }
            com.google.javascript.rhino.Token nType = n.getToken();
            return nType == com.google.javascript.rhino.Token.EXPR_RESULT && n.getFirstChild().isString() && ALLOWED_DIRECTIVES.contains(n.getFirstChild().getString());
        }

        Node processBlock(BlockTree blockNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.BLOCK);
            for (ParseTree child : blockNode.statements) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processBreakStatement(BreakStatementTree statementNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.BREAK);
            if (statementNode.getLabel() != null) {
                Node labelName = this.transformLabelName(statementNode.name);
                node.addChildToBack(labelName);
            }
            return node;
        }

        Node transformLabelName(IdentifierToken token) {
            Node label = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.LABEL_NAME, token.value);
            IRFactory.this.setSourceInfo(label, token);
            return label;
        }

        Node processConditionalExpression(ConditionalExpressionTree exprNode) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.HOOK, IRFactory.this.transform(exprNode.condition), IRFactory.this.transform(exprNode.left), IRFactory.this.transform(exprNode.right));
        }

        Node processContinueStatement(ContinueStatementTree statementNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.CONTINUE);
            if (statementNode.getLabel() != null) {
                Node labelName = this.transformLabelName(statementNode.name);
                node.addChildToBack(labelName);
            }
            return node;
        }

        Node processDoLoop(DoWhileStatementTree loopNode) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.DO, IRFactory.this.transformBlock(loopNode.body), IRFactory.this.transform(loopNode.condition));
        }

        Node processElementGet(MemberLookupExpressionTree getNode) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.GETELEM, IRFactory.this.transform(getNode.operand), IRFactory.this.transform(getNode.memberExpression));
        }

        Node processOptChainElementGet(OptionalMemberLookupExpressionTree getNode) {
            IRFactory.this.maybeWarnForFeature(getNode, FeatureSet.Feature.OPTIONAL_CHAINING);
            Node getElem = IRFactory.this.newNode(com.google.javascript.rhino.Token.OPTCHAIN_GETELEM, IRFactory.this.transform(getNode.operand), IRFactory.this.transform(getNode.memberExpression));
            getElem.setIsOptionalChainStart(getNode.isStartOfOptionalChain);
            return getElem;
        }

        Node processEmptyStatement(EmptyStatementTree exprNode) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.EMPTY);
        }

        Node processExpressionStatement(ExpressionStatementTree statementNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.EXPR_RESULT);
            node.addChildToBack(IRFactory.this.transform(statementNode.expression));
            return node;
        }

        Node processForInLoop(ForInStatementTree loopNode) {
            Node initializer = IRFactory.this.transform(loopNode.initializer);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.FOR_IN, initializer, IRFactory.this.transform(loopNode.collection), IRFactory.this.transformBlock(loopNode.body));
        }

        Node processForOf(ForOfStatementTree loopNode) {
            IRFactory.this.maybeWarnForFeature(loopNode, FeatureSet.Feature.FOR_OF);
            Node initializer = IRFactory.this.transform(loopNode.initializer);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.FOR_OF, initializer, IRFactory.this.transform(loopNode.collection), IRFactory.this.transformBlock(loopNode.body));
        }

        Node processForAwaitOf(ForAwaitOfStatementTree loopNode) {
            IRFactory.this.maybeWarnForFeature(loopNode, FeatureSet.Feature.FOR_AWAIT_OF);
            Node initializer = IRFactory.this.transform(loopNode.initializer);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.FOR_AWAIT_OF, initializer, IRFactory.this.transform(loopNode.collection), IRFactory.this.transformBlock(loopNode.body));
        }

        Node processForLoop(ForStatementTree loopNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.FOR, this.transformOrEmpty(loopNode.initializer, (ParseTree)loopNode), this.transformOrEmpty(loopNode.condition, (ParseTree)loopNode), this.transformOrEmpty(loopNode.increment, (ParseTree)loopNode));
            node.addChildToBack(IRFactory.this.transformBlock(loopNode.body));
            return node;
        }

        Node transformOrEmpty(ParseTree tree, ParseTree parent) {
            if (tree == null) {
                Node n = IRFactory.this.newNode(com.google.javascript.rhino.Token.EMPTY);
                IRFactory.this.setSourceInfo(n, parent);
                return n;
            }
            return IRFactory.this.transform(tree);
        }

        Node transformOrEmpty(IdentifierToken token, ParseTree parent) {
            if (token == null) {
                Node n = IRFactory.this.newNode(com.google.javascript.rhino.Token.EMPTY);
                IRFactory.this.setSourceInfo(n, parent);
                return n;
            }
            return this.processName(token);
        }

        Node processFunctionCall(CallExpressionTree callNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.CALL, IRFactory.this.transform(callNode.operand));
            node.setTrailingComma(callNode.arguments.hasTrailingComma);
            ArgumentListTree argumentsTree = callNode.arguments;
            List<SourcePosition> zones = this.getEndOfArgCommentZones(argumentsTree.arguments, argumentsTree.commaPositions, argumentsTree.location.end);
            int argCount = 0;
            for (ParseTree child : callNode.arguments.arguments) {
                Node childNode = IRFactory.this.transform(child);
                node.addChildToBack(childNode);
                this.attachPossibleTrailingCommentsForArg(childNode, zones.get(argCount));
            }
            return node;
        }

        List<SourcePosition> getEndOfArgCommentZones(ImmutableList<ParseTree> args, ImmutableList<SourcePosition> commaPositions, SourcePosition argListEndPosition) {
            ImmutableList.Builder zones = ImmutableList.builder();
            int commaCount = 0;
            for (ParseTree arg : args) {
                if (args.size() > commaCount + 1) {
                    ParseTree nextParam = (ParseTree)args.get(commaCount + 1);
                    if (nextParam.location.start.line > arg.location.end.line) {
                        SourcePosition tempSourcePos = new SourcePosition(null, Integer.MAX_VALUE, arg.location.end.line, Integer.MAX_VALUE);
                        zones.add(tempSourcePos);
                    } else {
                        SourcePosition commaPosition = (SourcePosition)commaPositions.get(commaCount);
                        zones.add(commaPosition);
                    }
                } else {
                    zones.add(argListEndPosition);
                }
                ++commaCount;
            }
            return zones.build();
        }

        void attachPossibleTrailingCommentsForArg(Node paramNode, SourcePosition endZone) {
            NonJSDocComment trailingComment = null;
            if (IRFactory.this.hasPendingNonJSDocCommentBefore(endZone)) {
                trailingComment = IRFactory.combineCommentsIntoSingleComment(IRFactory.this.getNonJSDocCommentsBefore(endZone));
                trailingComment.setIsInline(true);
                NonJSDocComment nonTrailingComment = paramNode.getNonJSDocComment();
                if (nonTrailingComment != null) {
                    nonTrailingComment.appendTrailingCommentToNonTrailing(trailingComment);
                } else {
                    trailingComment.setIsTrailing(true);
                    paramNode.setNonJSDocComment(trailingComment);
                }
            }
        }

        Node processOptChainFunctionCall(OptionalCallExpressionTree callNode) {
            IRFactory.this.maybeWarnForFeature(callNode, FeatureSet.Feature.OPTIONAL_CHAINING);
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.OPTCHAIN_CALL, IRFactory.this.transform(callNode.operand));
            node.setTrailingComma(callNode.hasTrailingComma);
            for (ParseTree child : callNode.arguments.arguments) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            node.setIsOptionalChainStart(callNode.isStartOfOptionalChain);
            return node;
        }

        Node processFunction(FunctionDeclarationTree functionTree) {
            Node result;
            Node newName;
            IdentifierToken name;
            boolean isSignature;
            boolean isDeclaration = functionTree.kind == FunctionDeclarationTree.Kind.DECLARATION;
            boolean isMember = functionTree.kind == FunctionDeclarationTree.Kind.MEMBER;
            boolean isArrow = functionTree.kind == FunctionDeclarationTree.Kind.ARROW;
            boolean isAsync = functionTree.isAsync;
            boolean isGenerator = functionTree.isGenerator;
            boolean bl = isSignature = functionTree.functionBody.type == ParseTreeType.EMPTY_STATEMENT;
            if (isGenerator) {
                IRFactory.this.maybeWarnForFeature(functionTree, FeatureSet.Feature.GENERATORS);
            }
            if (isMember) {
                IRFactory.this.maybeWarnForFeature(functionTree, FeatureSet.Feature.MEMBER_DECLARATIONS);
            }
            if (isArrow) {
                IRFactory.this.maybeWarnForFeature(functionTree, FeatureSet.Feature.ARROW_FUNCTIONS);
            }
            if (isAsync) {
                IRFactory.this.maybeWarnForFeature(functionTree, FeatureSet.Feature.ASYNC_FUNCTIONS);
            }
            if (isGenerator && isAsync) {
                IRFactory.this.maybeWarnForFeature(functionTree, FeatureSet.Feature.ASYNC_GENERATORS);
            }
            if ((name = functionTree.name) != null) {
                newName = this.processNameWithInlineComments(name);
            } else {
                if (isDeclaration || isMember) {
                    IRFactory.this.errorReporter.error("unnamed function statement", IRFactory.this.sourceName, IRFactory.lineno(functionTree), IRFactory.charno(functionTree));
                    newName = this.createMissingNameNode();
                } else {
                    newName = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, "");
                }
                IRFactory.this.setSourceInfo(newName, functionTree);
            }
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.FUNCTION);
            if (isMember) {
                newName.setString("");
            }
            node.addChildToBack(newName);
            this.maybeProcessGenerics(node.getFirstChild(), functionTree.generics);
            node.addChildToBack(IRFactory.this.transform(functionTree.formalParameterList));
            this.maybeProcessType(node, functionTree.returnType);
            Node bodyNode = IRFactory.this.transform(functionTree.functionBody);
            if (!(isArrow || isSignature || bodyNode.isBlock())) {
                Preconditions.checkState(IRFactory.this.config.runMode() == Config.RunMode.KEEP_GOING);
                bodyNode = IR.block();
            }
            this.parseDirectives(bodyNode);
            node.addChildToBack(bodyNode);
            node.setIsGeneratorFunction(isGenerator);
            node.setIsArrowFunction(isArrow);
            node.setIsAsyncFunction(isAsync);
            node.putBooleanProp(Node.OPT_ES6_TYPED, functionTree.isOptional);
            if (isMember) {
                IRFactory.this.setSourceInfo(node, functionTree);
                Node member = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.MEMBER_FUNCTION_DEF, name.value);
                member.addChildToBack(node);
                member.setStaticMember(functionTree.isStatic);
                this.maybeProcessAccessibilityModifier(functionTree, member, functionTree.access);
                node.setDeclaredTypeExpression(node.getDeclaredTypeExpression());
                IRFactory.this.setSourceInfo(member, name);
                result = member;
            } else {
                result = node;
            }
            return result;
        }

        Node processFormalParameterList(FormalParameterListTree tree) {
            Node params = IRFactory.this.newNode(com.google.javascript.rhino.Token.PARAM_LIST);
            params.setTrailingComma(tree.hasTrailingComma);
            if (!this.checkParameters(tree.parameters)) {
                return params;
            }
            ImmutableList<ParseTree> parameters = tree.parameters;
            List<SourcePosition> zones = this.getEndOfArgCommentZones(parameters, tree.commaPositions, tree.location.end);
            int argCount = 0;
            for (ParseTree param : tree.parameters) {
                Node paramNode;
                switch (param.type) {
                    case DEFAULT_PARAMETER: {
                        paramNode = this.processDefaultParameter(param.asDefaultParameter());
                        break;
                    }
                    case ITER_REST: {
                        IRFactory.this.maybeWarnForFeature(param, FeatureSet.Feature.REST_PARAMETERS);
                        paramNode = IRFactory.this.transformNodeWithInlineComments(param);
                        break;
                    }
                    default: {
                        paramNode = IRFactory.this.transformNodeWithInlineComments(param);
                        this.attachPossibleTrailingCommentsForArg(paramNode, zones.get(argCount));
                    }
                }
                Preconditions.checkState(paramNode.isName() || paramNode.isRest() || paramNode.isArrayPattern() || paramNode.isObjectPattern() || paramNode.isDefaultValue());
                params.addChildToBack(paramNode);
                ++argCount;
            }
            return params;
        }

        Node processDefaultParameter(DefaultParameterTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.DEFAULT_PARAMETERS);
            ParseTree targetTree = tree.lhs;
            Node targetNode = targetTree.type == ParseTreeType.IDENTIFIER_EXPRESSION ? this.processNameWithInlineComments(targetTree.asIdentifierExpression()) : IRFactory.this.transformNodeWithInlineComments(targetTree);
            Node defaultValueExpression = IRFactory.this.transform(tree.defaultValue);
            Node defaultValueNode = IRFactory.this.newNode(com.google.javascript.rhino.Token.DEFAULT_VALUE, targetNode, defaultValueExpression);
            IRFactory.this.reportErrorIfYieldOrAwaitInDefaultValue(defaultValueNode);
            IRFactory.this.setSourceInfo(defaultValueNode, tree);
            return defaultValueNode;
        }

        Node processIterRest(IterRestTree tree) {
            Node target = IRFactory.this.transformNodeWithInlineComments(tree.assignmentTarget);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.ITER_REST, target);
        }

        Node processIterSpread(IterSpreadTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.SPREAD_EXPRESSIONS);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.ITER_SPREAD, IRFactory.this.transform(tree.expression));
        }

        Node processObjectSpread(ObjectSpreadTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.OBJECT_SPREAD, IRFactory.this.transform(tree.expression));
        }

        Node processIfStatement(IfStatementTree statementNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.IF);
            node.addChildToBack(IRFactory.this.transform(statementNode.condition));
            node.addChildToBack(IRFactory.this.transformBlock(statementNode.ifClause));
            if (statementNode.elseClause != null) {
                node.addChildToBack(IRFactory.this.transformBlock(statementNode.elseClause));
            }
            return node;
        }

        Node processBinaryExpression(BinaryOperatorTree exprNode) {
            if (IRFactory.this.hasPendingCommentBefore(exprNode.right)) {
                if (exprNode.operator.type == TokenType.STAR_STAR || exprNode.operator.type == TokenType.STAR_STAR_EQUAL) {
                    IRFactory.this.maybeWarnForFeature(exprNode, FeatureSet.Feature.EXPONENT_OP);
                } else if (exprNode.operator.type == TokenType.QUESTION_QUESTION) {
                    IRFactory.this.maybeWarnForFeature(exprNode, FeatureSet.Feature.NULL_COALESCE_OP);
                }
                return IRFactory.this.newNode(IRFactory.transformBinaryTokenType(exprNode.operator.type), IRFactory.this.transform(exprNode.left), IRFactory.this.transform(exprNode.right));
            }
            return this.processBinaryExpressionHelper(exprNode);
        }

        private Node processBinaryExpressionHelper(BinaryOperatorTree exprTree) {
            Node root = null;
            Node current = null;
            Node previous = null;
            while (exprTree != null) {
                if (exprTree.operator.type == TokenType.STAR_STAR || exprTree.operator.type == TokenType.STAR_STAR_EQUAL) {
                    IRFactory.this.maybeWarnForFeature(exprTree, FeatureSet.Feature.EXPONENT_OP);
                }
                if (exprTree.operator.type == TokenType.QUESTION_QUESTION) {
                    IRFactory.this.maybeWarnForFeature(exprTree, FeatureSet.Feature.NULL_COALESCE_OP);
                }
                previous = current;
                current = IRFactory.this.newNode(IRFactory.transformBinaryTokenType(exprTree.operator.type), IRFactory.this.transform(exprTree.right));
                IRFactory.this.setSourceInfo(current, exprTree);
                if (previous != null) {
                    previous.addChildToFront(current);
                }
                if (exprTree.left instanceof BinaryOperatorTree) {
                    exprTree = (BinaryOperatorTree)exprTree.left;
                } else {
                    Node leftNode = IRFactory.this.transform(exprTree.left);
                    current.addChildToFront(leftNode);
                    exprTree = null;
                }
                if (root != null) continue;
                root = current;
            }
            return root;
        }

        Node processDebuggerStatement(DebuggerStatementTree node) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.DEBUGGER);
        }

        Node processThisExpression(ThisExpressionTree node) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.THIS);
        }

        Node processLabeledStatement(LabelledStatementTree labelTree) {
            Node statement = IRFactory.this.transform(labelTree.statement);
            if (statement.isFunction() || statement.isClass() || statement.isLet() || statement.isConst()) {
                IRFactory.this.errorReporter.error("Lexical declarations are only allowed at top level or inside a block.", IRFactory.this.sourceName, IRFactory.lineno(labelTree), IRFactory.charno(labelTree));
                return statement;
            }
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.LABEL, this.transformLabelName(labelTree.name), statement);
        }

        Node processName(IdentifierExpressionTree nameNode) {
            return this.processName(nameNode, false);
        }

        Node processName(IdentifierExpressionTree nameNode, boolean asString) {
            return this.processName(nameNode.identifierToken, asString);
        }

        Node processName(IdentifierToken identifierToken) {
            return this.processName(identifierToken, false);
        }

        Node processName(IdentifierToken identifierToken, boolean asString) {
            Node node;
            if (asString) {
                node = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.STRING, identifierToken.value);
            } else {
                JSDocInfo info = IRFactory.this.handleJsDoc(identifierToken);
                this.maybeWarnReservedKeyword(identifierToken);
                node = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, identifierToken.value);
                if (info != null) {
                    node.setJSDocInfo(info);
                }
            }
            IRFactory.this.setSourceInfo(node, identifierToken);
            return node;
        }

        Node processString(LiteralToken token) {
            Preconditions.checkArgument(token.type == TokenType.STRING);
            Node node = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.STRING, IRFactory.this.normalizeString(token, false));
            IRFactory.this.setSourceInfo(node, token);
            return node;
        }

        Node processTemplateLiteralToken(TemplateLiteralToken token) {
            Preconditions.checkArgument(token.type == TokenType.NO_SUBSTITUTION_TEMPLATE || token.type == TokenType.TEMPLATE_HEAD || token.type == TokenType.TEMPLATE_MIDDLE || token.type == TokenType.TEMPLATE_TAIL);
            Node node = token.hasError() ? IRFactory.this.newTemplateLitStringNode(null, token.value) : IRFactory.this.newTemplateLitStringNode(IRFactory.this.normalizeString(token, true), token.value);
            IRFactory.this.setSourceInfo(node, token);
            return node;
        }

        private Node processNameWithInlineComments(IdentifierExpressionTree identifierExpression) {
            return this.processNameWithInlineComments(identifierExpression.identifierToken);
        }

        Node processNameWithInlineComments(IdentifierToken identifierToken) {
            ArrayList nonJSDocComments;
            JSDocInfo info = IRFactory.this.handleInlineJsDoc(identifierToken);
            NonJSDocComment associatedNonJSDocComment = null;
            if (IRFactory.this.config.jsDocParsingMode() == Config.JsDocParsing.INCLUDE_ALL_COMMENTS && !(nonJSDocComments = IRFactory.this.getNonJSDocComments(identifierToken)).isEmpty()) {
                associatedNonJSDocComment = IRFactory.combineCommentsIntoSingleComment(nonJSDocComments);
            }
            this.maybeWarnReservedKeyword(identifierToken);
            Node node = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, identifierToken.value);
            if (info != null) {
                node.setJSDocInfo(info);
            }
            if (IRFactory.this.config.jsDocParsingMode() == Config.JsDocParsing.INCLUDE_ALL_COMMENTS && associatedNonJSDocComment != null) {
                node.setNonJSDocComment(associatedNonJSDocComment);
            }
            IRFactory.this.setSourceInfo(node, identifierToken);
            return node;
        }

        private void maybeWarnKeywordProperty(Node node) {
            if (TokenStream.isKeyword(node.getString())) {
                IRFactory.this.features = IRFactory.this.features.with(FeatureSet.Feature.KEYWORDS_AS_PROPERTIES);
                if (IRFactory.this.config.languageMode() == Config.LanguageMode.ECMASCRIPT3) {
                    IRFactory.this.errorReporter.warning(IRFactory.INVALID_ES3_PROP_NAME, IRFactory.this.sourceName, node.getLineno(), node.getCharno());
                }
            }
        }

        private void maybeWarnReservedKeyword(IdentifierToken token) {
            String identifier = token.value;
            boolean isIdentifier = false;
            if (TokenStream.isKeyword(identifier)) {
                IRFactory.this.features = IRFactory.this.features.with(FeatureSet.Feature.ES3_KEYWORDS_AS_IDENTIFIERS);
                boolean bl = isIdentifier = IRFactory.this.config.languageMode() == Config.LanguageMode.ECMASCRIPT3;
            }
            if (IRFactory.this.reservedKeywords != null && IRFactory.this.reservedKeywords.contains(identifier)) {
                IRFactory.this.features = IRFactory.this.features.with(FeatureSet.Feature.KEYWORDS_AS_PROPERTIES);
                boolean bl = isIdentifier = IRFactory.this.config.languageMode() == Config.LanguageMode.ECMASCRIPT3;
            }
            if (isIdentifier) {
                IRFactory.this.errorReporter.error("identifier is a reserved word", IRFactory.this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
            }
        }

        Node processNewExpression(NewExpressionTree exprNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.NEW, IRFactory.this.transform(exprNode.operand));
            node.setTrailingComma(exprNode.hasTrailingComma);
            if (exprNode.arguments != null) {
                for (ParseTree arg : exprNode.arguments.arguments) {
                    node.addChildToBack(IRFactory.this.transform(arg));
                }
            }
            return node;
        }

        Node processNumberLiteral(LiteralExpressionTree literalNode) {
            double value = IRFactory.this.normalizeNumber(literalNode.literalToken.asLiteral());
            Node number = IRFactory.this.newNumberNode(value);
            IRFactory.this.setSourceInfo(number, literalNode);
            return number;
        }

        Node processBigIntLiteral(LiteralExpressionTree literalNode) {
            IRFactory.this.maybeWarnForFeature(literalNode, FeatureSet.Feature.BIGINT);
            BigInteger value = IRFactory.this.normalizeBigInt(literalNode.literalToken.asLiteral());
            Node bigint = IRFactory.this.newBigIntNode(value);
            IRFactory.this.setSourceInfo(bigint, literalNode);
            return bigint;
        }

        Node processObjectLiteral(ObjectLiteralExpressionTree objTree) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.OBJECTLIT);
            node.setTrailingComma(objTree.hasTrailingComma);
            boolean maybeWarn = false;
            for (ParseTree el : objTree.propertyNameAndValues) {
                if (el.type == ParseTreeType.DEFAULT_PARAMETER) {
                    IRFactory.this.errorReporter.error("Default value cannot appear at top level of an object literal.", IRFactory.this.sourceName, IRFactory.lineno(el), 0);
                    continue;
                }
                if (el.type == ParseTreeType.GET_ACCESSOR && this.maybeReportGetter(el) || el.type == ParseTreeType.SET_ACCESSOR && this.maybeReportSetter(el)) continue;
                Node key = IRFactory.this.transform(el);
                if (!(key.isComputedProp() || key.isQuotedString() || key.isSpread() || IRFactory.this.currentFileIsExterns)) {
                    this.maybeWarnKeywordProperty(key);
                }
                if (key.isShorthandProperty()) {
                    maybeWarn = true;
                }
                node.addChildToBack(key);
            }
            if (maybeWarn) {
                IRFactory.this.maybeWarnForFeature(objTree, FeatureSet.Feature.EXTENDED_OBJECT_LITERALS);
            }
            return node;
        }

        Node processComputedPropertyDefinition(ComputedPropertyDefinitionTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.COMPUTED_PROPERTIES);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.COMPUTED_PROP, IRFactory.this.transform(tree.property), IRFactory.this.transform(tree.value));
        }

        Node processComputedPropertyMemberVariable(ComputedPropertyMemberVariableTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.COMPUTED_PROPERTIES);
            this.maybeWarnTypeSyntax(tree, FeatureSet.Feature.MEMBER_VARIABLE_IN_CLASS);
            Node n = IRFactory.this.newNode(com.google.javascript.rhino.Token.COMPUTED_PROP, IRFactory.this.transform(tree.property));
            this.maybeProcessType(n, tree.declaredType);
            n.putBooleanProp(Node.COMPUTED_PROP_VARIABLE, true);
            n.putProp(Node.ACCESS_MODIFIER, (Object)tree.access);
            n.setStaticMember(tree.isStatic);
            this.maybeProcessAccessibilityModifier(tree, n, tree.access);
            return n;
        }

        Node processComputedPropertyMethod(ComputedPropertyMethodTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.COMPUTED_PROPERTIES);
            Node n = IRFactory.this.newNode(com.google.javascript.rhino.Token.COMPUTED_PROP, IRFactory.this.transform(tree.property), IRFactory.this.transform(tree.method));
            n.putBooleanProp(Node.COMPUTED_PROP_METHOD, true);
            if (tree.method.asFunctionDeclaration().isStatic) {
                n.setStaticMember(true);
            }
            this.maybeProcessAccessibilityModifier(tree, n, tree.access);
            return n;
        }

        Node processComputedPropertyGetter(ComputedPropertyGetterTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.COMPUTED_PROPERTIES);
            Node key = IRFactory.this.transform(tree.property);
            Node body = IRFactory.this.transform(tree.body);
            Node function = IR.function(IR.name(""), IR.paramList(new Node[0]), body);
            function.useSourceInfoIfMissingFromForTree(body);
            Node n = IRFactory.this.newNode(com.google.javascript.rhino.Token.COMPUTED_PROP, key, function);
            n.putBooleanProp(Node.COMPUTED_PROP_GETTER, true);
            n.putBooleanProp(Node.STATIC_MEMBER, tree.isStatic);
            return n;
        }

        Node processComputedPropertySetter(ComputedPropertySetterTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.COMPUTED_PROPERTIES);
            Node key = IRFactory.this.transform(tree.property);
            Node paramList = this.processFormalParameterList(tree.parameter);
            IRFactory.this.setSourceInfo(paramList, tree.parameter);
            Node body = IRFactory.this.transform(tree.body);
            Node function = IR.function(IR.name(""), paramList, body);
            function.useSourceInfoIfMissingFromForTree(body);
            Node n = IRFactory.this.newNode(com.google.javascript.rhino.Token.COMPUTED_PROP, key, function);
            n.putBooleanProp(Node.COMPUTED_PROP_SETTER, true);
            n.putBooleanProp(Node.STATIC_MEMBER, tree.isStatic);
            return n;
        }

        Node processGetAccessor(GetAccessorTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.propertyName);
            key.setToken(com.google.javascript.rhino.Token.GETTER_DEF);
            Node body = IRFactory.this.transform(tree.body);
            Node dummyName = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, "");
            IRFactory.this.setSourceInfo(dummyName, tree.body);
            Node paramList = IRFactory.this.newNode(com.google.javascript.rhino.Token.PARAM_LIST);
            IRFactory.this.setSourceInfo(paramList, tree.body);
            Node value = IRFactory.this.newNode(com.google.javascript.rhino.Token.FUNCTION, dummyName, paramList, body);
            IRFactory.this.setSourceInfo(value, tree.body);
            key.addChildToFront(value);
            this.maybeProcessType(value, tree.returnType);
            key.setStaticMember(tree.isStatic);
            return key;
        }

        Node processSetAccessor(SetAccessorTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.propertyName);
            key.setToken(com.google.javascript.rhino.Token.SETTER_DEF);
            Node paramList = this.processFormalParameterList(tree.parameter);
            IRFactory.this.setSourceInfo(paramList, tree.parameter);
            Node body = IRFactory.this.transform(tree.body);
            Node dummyName = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, "");
            IRFactory.this.setSourceInfo(dummyName, tree.propertyName);
            Node value = IRFactory.this.newNode(com.google.javascript.rhino.Token.FUNCTION, dummyName, paramList, body);
            IRFactory.this.setSourceInfo(value, tree.body);
            key.addChildToFront(value);
            key.setStaticMember(tree.isStatic);
            return key;
        }

        Node processPropertyNameAssignment(PropertyNameAssignmentTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.name);
            key.setToken(com.google.javascript.rhino.Token.STRING_KEY);
            if (tree.value != null) {
                key.addChildToFront(IRFactory.this.transform(tree.value));
            } else {
                Node value = key.cloneNode();
                key.setShorthandProperty(true);
                value.setToken(com.google.javascript.rhino.Token.NAME);
                key.addChildToFront(value);
            }
            return key;
        }

        private void checkParenthesizedExpression(ParenExpressionTree exprNode) {
            if (exprNode.expression.type == ParseTreeType.COMMA_EXPRESSION) {
                ImmutableList<ParseTree> commaNodes = exprNode.expression.asCommaExpression().expressions;
                ParseTree lastChild = Iterables.getLast(commaNodes);
                if (lastChild.type == ParseTreeType.ITER_REST) {
                    IRFactory.this.errorReporter.error("A rest parameter must be in a parameter list.", IRFactory.this.sourceName, IRFactory.lineno(lastChild), IRFactory.charno(lastChild));
                }
            }
        }

        Node processParenthesizedExpression(ParenExpressionTree exprNode) {
            this.checkParenthesizedExpression(exprNode);
            Node expr = IRFactory.this.transform(exprNode.expression);
            expr.setIsParenthesized(true);
            return expr;
        }

        Node processPropertyGet(MemberExpressionTree getNode) {
            Node leftChild = IRFactory.this.transform(getNode.operand);
            IdentifierToken nodeProp = getNode.memberName;
            Node rightChild = this.processObjectLitKeyAsString(nodeProp);
            if (!rightChild.isQuotedString() && !IRFactory.this.currentFileIsExterns) {
                this.maybeWarnKeywordProperty(rightChild);
            }
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.GETPROP, leftChild, rightChild);
        }

        Node processOptChainPropertyGet(OptionalMemberExpressionTree getNode) {
            IRFactory.this.maybeWarnForFeature(getNode, FeatureSet.Feature.OPTIONAL_CHAINING);
            Node leftChild = IRFactory.this.transform(getNode.operand);
            IdentifierToken nodeProp = getNode.memberName;
            Node rightChild = this.processObjectLitKeyAsString(nodeProp);
            if (!rightChild.isQuotedString() && !IRFactory.this.currentFileIsExterns) {
                this.maybeWarnKeywordProperty(rightChild);
            }
            Node getProp = IRFactory.this.newNode(com.google.javascript.rhino.Token.OPTCHAIN_GETPROP, leftChild, rightChild);
            getProp.setIsOptionalChainStart(getNode.isStartOfOptionalChain);
            return getProp;
        }

        Node processRegExpLiteral(LiteralExpressionTree literalTree) {
            LiteralToken token = literalTree.literalToken.asLiteral();
            Node literalStringNode = IRFactory.this.newStringNode(IRFactory.this.normalizeRegex(token));
            IRFactory.this.setSourceInfo(literalStringNode, token);
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.REGEXP, literalStringNode);
            String rawRegex = token.value;
            int lastSlash = rawRegex.lastIndexOf(47);
            String flags = "";
            if (lastSlash < rawRegex.length()) {
                flags = rawRegex.substring(lastSlash + 1);
            }
            this.validateRegExpFlags(literalTree, flags);
            if (!flags.isEmpty()) {
                Node flagsNode = IRFactory.this.newStringNode(flags);
                IRFactory.this.setSourceInfo(flagsNode, token);
                node.addChildToBack(flagsNode);
            }
            return node;
        }

        private void validateRegExpFlags(LiteralExpressionTree tree, String flags) {
            Iterator iterator = Lists.charactersOf(flags).iterator();
            block5: while (iterator.hasNext()) {
                char flag = ((Character)iterator.next()).charValue();
                switch (flag) {
                    case 'g': 
                    case 'i': 
                    case 'm': {
                        continue block5;
                    }
                    case 'u': 
                    case 'y': {
                        FeatureSet.Feature feature = flag == 'u' ? FeatureSet.Feature.REGEXP_FLAG_U : FeatureSet.Feature.REGEXP_FLAG_Y;
                        IRFactory.this.maybeWarnForFeature(tree, feature);
                        continue block5;
                    }
                    case 's': {
                        IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.REGEXP_FLAG_S);
                        continue block5;
                    }
                }
                IRFactory.this.errorReporter.error("Invalid RegExp flag '" + flag + "'", IRFactory.this.sourceName, IRFactory.lineno(tree), IRFactory.charno(tree));
            }
        }

        Node processReturnStatement(ReturnStatementTree statementNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.RETURN);
            if (statementNode.expression != null) {
                node.addChildToBack(IRFactory.this.transform(statementNode.expression));
            }
            return node;
        }

        Node processStringLiteral(LiteralExpressionTree literalTree) {
            LiteralToken token = literalTree.literalToken.asLiteral();
            Node n = this.processString(token);
            String value = n.getString();
            if (value.indexOf(11) != -1) {
                int start = token.location.start.offset;
                int end = token.location.end.offset;
                if (start < IRFactory.this.sourceString.length() && IRFactory.this.sourceString.substring(start, Math.min(IRFactory.this.sourceString.length(), end)).contains("\\v")) {
                    n.putBooleanProp(Node.SLASH_V, true);
                }
            }
            return n;
        }

        Node processTemplateLiteral(TemplateLiteralExpressionTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.TEMPLATE_LITERALS);
            Node templateLitNode = IRFactory.this.newNode(com.google.javascript.rhino.Token.TEMPLATELIT);
            IRFactory.this.setSourceInfo(templateLitNode, tree);
            Node node = tree.operand == null ? templateLitNode : IRFactory.this.newNode(com.google.javascript.rhino.Token.TAGGED_TEMPLATELIT, IRFactory.this.transform(tree.operand), templateLitNode);
            for (ParseTree child : tree.elements) {
                templateLitNode.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processTemplateLiteralPortion(TemplateLiteralPortionTree tree) {
            return this.processTemplateLiteralToken(tree.value.asTemplateLiteral());
        }

        Node processTemplateSubstitution(TemplateSubstitutionTree tree) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.TEMPLATELIT_SUB, IRFactory.this.transform(tree.expression));
        }

        Node processSwitchCase(CaseClauseTree caseNode) {
            ParseTree expr = caseNode.expression;
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.CASE, IRFactory.this.transform(expr));
            Node block = IRFactory.this.newNode(com.google.javascript.rhino.Token.BLOCK);
            block.setIsAddedBlock(true);
            IRFactory.this.setSourceInfo(block, caseNode);
            if (caseNode.statements != null) {
                for (ParseTree child : caseNode.statements) {
                    block.addChildToBack(IRFactory.this.transform(child));
                }
            }
            node.addChildToBack(block);
            return node;
        }

        Node processSwitchDefault(DefaultClauseTree caseNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.DEFAULT_CASE);
            Node block = IRFactory.this.newNode(com.google.javascript.rhino.Token.BLOCK);
            block.setIsAddedBlock(true);
            IRFactory.this.setSourceInfo(block, caseNode);
            if (caseNode.statements != null) {
                for (ParseTree child : caseNode.statements) {
                    block.addChildToBack(IRFactory.this.transform(child));
                }
            }
            node.addChildToBack(block);
            return node;
        }

        Node processSwitchStatement(SwitchStatementTree statementNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.SWITCH, IRFactory.this.transform(statementNode.expression));
            for (ParseTree child : statementNode.caseClauses) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processThrowStatement(ThrowStatementTree statementNode) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.THROW, IRFactory.this.transform(statementNode.value));
        }

        Node processTryStatement(TryStatementTree statementNode) {
            Node node = IRFactory.this.newNode(com.google.javascript.rhino.Token.TRY, IRFactory.this.transformBlock(statementNode.body));
            Node block = IRFactory.this.newNode(com.google.javascript.rhino.Token.BLOCK);
            boolean lineSet = false;
            ParseTree cc = statementNode.catchBlock;
            if (cc != null) {
                IRFactory.this.setSourceInfo(block, cc);
                lineSet = true;
                block.addChildToBack(IRFactory.this.transform(cc));
            }
            node.addChildToBack(block);
            ParseTree finallyBlock = statementNode.finallyBlock;
            if (finallyBlock != null) {
                node.addChildToBack(IRFactory.this.transformBlock(finallyBlock));
            }
            if (!lineSet && finallyBlock != null) {
                IRFactory.this.setSourceInfo(block, finallyBlock);
            }
            return node;
        }

        Node processCatchClause(CatchTree clauseNode) {
            if (clauseNode.exception.type == ParseTreeType.EMPTY_STATEMENT) {
                IRFactory.this.maybeWarnForFeature(clauseNode, FeatureSet.Feature.OPTIONAL_CATCH_BINDING);
            }
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.CATCH, IRFactory.this.transform(clauseNode.exception), IRFactory.this.transformBlock(clauseNode.catchBody));
        }

        Node processFinally(FinallyTree finallyNode) {
            return IRFactory.this.transformBlock(finallyNode.block);
        }

        Node processUnaryExpression(UnaryExpressionTree exprNode) {
            com.google.javascript.rhino.Token type = IRFactory.transformUnaryTokenType(exprNode.operator.type);
            Node operand = IRFactory.this.transform(exprNode.operand);
            if (type == com.google.javascript.rhino.Token.NEG && (operand.isNumber() || operand.isBigInt())) {
                if (operand.isBigInt()) {
                    operand.setBigInt(operand.getBigInt().negate());
                } else {
                    operand.setDouble(-operand.getDouble());
                }
                operand.setLineno(-1);
                IRFactory.this.setSourceInfo(operand, exprNode.operator.getStart(), exprNode.operand.getEnd());
                return operand;
            }
            if (!(type != com.google.javascript.rhino.Token.DELPROP || operand.isGetProp() || operand.isGetElem() || operand.isName() || operand.isOptChainGetProp() || operand.isOptChainGetElem())) {
                String msg = "Invalid delete operand. Only properties can be deleted.";
                IRFactory.this.errorReporter.error(msg, IRFactory.this.sourceName, operand.getLineno(), 0);
            }
            if (type == com.google.javascript.rhino.Token.POS && operand.isBigInt()) {
                IRFactory.this.errorReporter.error("Cannot convert a BigInt value to a number", IRFactory.this.sourceName, operand.getLineno(), 0);
            }
            return IRFactory.this.newNode(type, operand);
        }

        Node processUpdateExpression(UpdateExpressionTree updateExpr) {
            com.google.javascript.rhino.Token type = IRFactory.transformUpdateTokenType(updateExpr.operator.type);
            Node operand = IRFactory.this.transform(updateExpr.operand);
            return this.createUpdateNode(type, updateExpr.operatorPosition == UpdateExpressionTree.OperatorPosition.POSTFIX, operand);
        }

        private Node createUpdateNode(com.google.javascript.rhino.Token type, boolean postfix, Node operand) {
            Node assignTarget;
            Node node = assignTarget = operand.isCast() ? operand.getFirstChild() : operand;
            if (!assignTarget.isValidAssignmentTarget()) {
                IRFactory.this.errorReporter.error(SimpleFormat.format("Invalid %s %s operand.", postfix ? "postfix" : "prefix", type == com.google.javascript.rhino.Token.INC ? "increment" : "decrement"), IRFactory.this.sourceName, operand.getLineno(), operand.getCharno());
            }
            Node node2 = IRFactory.this.newNode(type, operand);
            node2.putBooleanProp(Node.INCRDECR_PROP, postfix);
            return node2;
        }

        Node processVariableStatement(VariableStatementTree stmt) {
            return IRFactory.this.transformDispatcher.process(stmt.declarations);
        }

        Node processVariableDeclarationList(VariableDeclarationListTree decl) {
            com.google.javascript.rhino.Token declType;
            switch (decl.declarationType) {
                case CONST: {
                    IRFactory.this.maybeWarnForFeature(decl, FeatureSet.Feature.CONST_DECLARATIONS);
                    declType = com.google.javascript.rhino.Token.CONST;
                    break;
                }
                case LET: {
                    IRFactory.this.maybeWarnForFeature(decl, FeatureSet.Feature.LET_DECLARATIONS);
                    declType = com.google.javascript.rhino.Token.LET;
                    break;
                }
                case VAR: {
                    declType = com.google.javascript.rhino.Token.VAR;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Node node = IRFactory.this.newNode(declType);
            for (VariableDeclarationTree child : decl.declarations) {
                node.addChildToBack(IRFactory.this.transformNodeWithInlineComments(child));
            }
            return node;
        }

        Node processVariableDeclaration(VariableDeclarationTree decl) {
            Node lhs;
            Node node = IRFactory.this.transformNodeWithInlineComments(decl.lvalue);
            Node node2 = lhs = node.isDestructuringPattern() ? IRFactory.this.newNode(com.google.javascript.rhino.Token.DESTRUCTURING_LHS, node) : node;
            if (decl.initializer != null) {
                Node initializer = IRFactory.this.transform(decl.initializer);
                lhs.addChildToBack(initializer);
                IRFactory.this.setLength(lhs, decl.location.start, decl.location.end);
            }
            this.maybeProcessType(lhs, decl.declaredType);
            return lhs;
        }

        Node processWhileLoop(WhileStatementTree stmt) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.WHILE, IRFactory.this.transform(stmt.condition), IRFactory.this.transformBlock(stmt.body));
        }

        Node processWithStatement(WithStatementTree stmt) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.WITH, IRFactory.this.transform(stmt.expression), IRFactory.this.transformBlock(stmt.body));
        }

        Node processMissingExpression(MissingPrimaryExpressionTree tree) {
            return this.createMissingExpressionNode();
        }

        private Node createMissingNameNode() {
            return IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, "__missing_name__");
        }

        private Node createMissingExpressionNode() {
            return IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, "__missing_expression__");
        }

        Node processIllegalToken(ParseTree node) {
            IRFactory.this.errorReporter.error("Unsupported syntax: " + (Object)((Object)node.type), IRFactory.this.sourceName, IRFactory.lineno(node), 0);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.EMPTY);
        }

        boolean maybeReportGetter(ParseTree node) {
            IRFactory.this.features = IRFactory.this.features.with(FeatureSet.Feature.GETTER);
            if (IRFactory.this.config.languageMode() == Config.LanguageMode.ECMASCRIPT3) {
                IRFactory.this.errorReporter.error(IRFactory.GETTER_ERROR_MESSAGE, IRFactory.this.sourceName, IRFactory.lineno(node), 0);
                return true;
            }
            return false;
        }

        boolean maybeReportSetter(ParseTree node) {
            IRFactory.this.features = IRFactory.this.features.with(FeatureSet.Feature.SETTER);
            if (IRFactory.this.config.languageMode() == Config.LanguageMode.ECMASCRIPT3) {
                IRFactory.this.errorReporter.error(IRFactory.SETTER_ERROR_MESSAGE, IRFactory.this.sourceName, IRFactory.lineno(node), 0);
                return true;
            }
            return false;
        }

        Node processBooleanLiteral(LiteralExpressionTree literal) {
            return IRFactory.this.newNode(IRFactory.transformBooleanTokenType(literal.literalToken.type));
        }

        Node processNullLiteral(LiteralExpressionTree literal) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.NULL);
        }

        Node processNull(NullTree literal) {
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.EMPTY);
        }

        Node processCommaExpression(CommaExpressionTree tree) {
            Node root = IRFactory.this.newNode(com.google.javascript.rhino.Token.COMMA);
            SourcePosition start = ((ParseTree)tree.expressions.get((int)0)).location.start;
            SourcePosition end = ((ParseTree)tree.expressions.get((int)1)).location.end;
            IRFactory.this.setSourceInfo(root, start, end);
            for (ParseTree expr : tree.expressions) {
                int count = root.getChildCount();
                if (count < 2) {
                    root.addChildToBack(IRFactory.this.transform(expr));
                    continue;
                }
                end = expr.location.end;
                root = IRFactory.this.newNode(com.google.javascript.rhino.Token.COMMA, root, IRFactory.this.transform(expr));
                IRFactory.this.setSourceInfo(root, start, end);
            }
            return root;
        }

        Node processClassDeclaration(ClassDeclarationTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.CLASSES);
            Node name = this.transformOrEmpty(tree.name, (ParseTree)tree);
            this.maybeProcessGenerics(name, tree.generics);
            Node superClass = this.transformOrEmpty(tree.superClass, (ParseTree)tree);
            if (!superClass.isEmpty()) {
                IRFactory.this.features = IRFactory.this.features.with(FeatureSet.Feature.CLASS_EXTENDS);
            }
            Node interfaces = this.transformListOrEmpty(com.google.javascript.rhino.Token.IMPLEMENTS, tree.interfaces);
            Node body = IRFactory.this.newNode(com.google.javascript.rhino.Token.CLASS_MEMBERS);
            IRFactory.this.setSourceInfo(body, tree);
            boolean hasConstructor = false;
            for (ParseTree child : tree.elements) {
                switch (child.type) {
                    case MEMBER_VARIABLE: 
                    case COMPUTED_PROPERTY_MEMBER_VARIABLE: {
                        this.maybeWarnTypeSyntax(child, FeatureSet.Feature.MEMBER_VARIABLE_IN_CLASS);
                        break;
                    }
                }
                switch (child.type) {
                    case COMPUTED_PROPERTY_GETTER: 
                    case COMPUTED_PROPERTY_SETTER: 
                    case GET_ACCESSOR: 
                    case SET_ACCESSOR: {
                        IRFactory.this.features = IRFactory.this.features.with(FeatureSet.Feature.CLASS_GETTER_SETTER);
                        break;
                    }
                }
                boolean childIsCtor = this.validateClassConstructorMember(child);
                if (childIsCtor) {
                    if (hasConstructor) {
                        IRFactory.this.errorReporter.error("Class may have only one constructor.", IRFactory.this.sourceName, IRFactory.lineno(child), IRFactory.charno(child));
                    }
                    hasConstructor = true;
                }
                body.addChildToBack(IRFactory.this.transform(child));
            }
            Node classNode = IRFactory.this.newNode(com.google.javascript.rhino.Token.CLASS, name, superClass, body);
            if (!interfaces.isEmpty()) {
                this.maybeWarnTypeSyntax(tree, FeatureSet.Feature.IMPLEMENTS);
                classNode.putProp(Node.IMPLEMENTS, interfaces);
            }
            return classNode;
        }

        private boolean validateClassConstructorMember(ParseTree member) {
            boolean hasIllegalModifier;
            boolean isStatic;
            Token memberName;
            switch (member.type) {
                case GET_ACCESSOR: {
                    GetAccessorTree getter = member.asGetAccessor();
                    memberName = getter.propertyName;
                    isStatic = getter.isStatic;
                    hasIllegalModifier = true;
                    break;
                }
                case SET_ACCESSOR: {
                    SetAccessorTree setter = member.asSetAccessor();
                    memberName = setter.propertyName;
                    isStatic = setter.isStatic;
                    hasIllegalModifier = true;
                    break;
                }
                case FUNCTION_DECLARATION: {
                    FunctionDeclarationTree method = member.asFunctionDeclaration();
                    memberName = method.name;
                    isStatic = method.isStatic;
                    hasIllegalModifier = method.isGenerator || method.isAsync;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (isStatic) {
                return false;
            }
            if (!memberName.type.equals((Object)TokenType.IDENTIFIER) || !memberName.asIdentifier().value.equals("constructor")) {
                return false;
            }
            if (hasIllegalModifier) {
                IRFactory.this.errorReporter.error("Class constructor may not be getter, setter, async, or generator.", IRFactory.this.sourceName, IRFactory.lineno(member), IRFactory.charno(member));
                return false;
            }
            return true;
        }

        Node processInterfaceDeclaration(InterfaceDeclarationTree tree) {
            this.maybeWarnTypeSyntax(tree, FeatureSet.Feature.INTERFACE);
            Node name = this.processName(tree.name);
            this.maybeProcessGenerics(name, tree.generics);
            Node superInterfaces = this.transformListOrEmpty(com.google.javascript.rhino.Token.INTERFACE_EXTENDS, tree.superInterfaces);
            Node body = IRFactory.this.newNode(com.google.javascript.rhino.Token.INTERFACE_MEMBERS);
            IRFactory.this.setSourceInfo(body, tree);
            for (ParseTree child : tree.elements) {
                body.addChildToBack(IRFactory.this.transform(child));
            }
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.INTERFACE, name, superInterfaces, body);
        }

        Node processEnumDeclaration(EnumDeclarationTree tree) {
            this.maybeWarnTypeSyntax(tree, FeatureSet.Feature.ENUM);
            Node name = this.processName(tree.name);
            Node body = IRFactory.this.newNode(com.google.javascript.rhino.Token.ENUM_MEMBERS);
            IRFactory.this.setSourceInfo(body, tree);
            for (ParseTree child : tree.members) {
                Node childNode = IRFactory.this.transform(child);
                if (childNode.isShorthandProperty()) {
                    childNode.removeChild(childNode.getLastChild());
                    childNode.setShorthandProperty(false);
                }
                body.addChildToBack(childNode);
            }
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.ENUM, name, body);
        }

        Node processSuper(SuperExpressionTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.SUPER);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.SUPER);
        }

        Node processNewTarget(NewTargetExpressionTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.NEW_TARGET);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.NEW_TARGET);
        }

        Node processMemberVariable(MemberVariableTree tree) {
            Node member = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.MEMBER_VARIABLE_DEF, tree.name.value);
            this.maybeProcessType(member, tree.declaredType);
            member.setStaticMember(tree.isStatic);
            member.putBooleanProp(Node.OPT_ES6_TYPED, tree.isOptional);
            this.maybeProcessAccessibilityModifier(tree, member, tree.access);
            return member;
        }

        Node processYield(YieldExpressionTree tree) {
            Node yield = IRFactory.this.newNode(com.google.javascript.rhino.Token.YIELD);
            if (tree.expression != null) {
                yield.addChildToBack(IRFactory.this.transform(tree.expression));
            }
            yield.setYieldAll(tree.isYieldAll);
            return yield;
        }

        Node processAwait(AwaitExpressionTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.ASYNC_FUNCTIONS);
            Node await = IRFactory.this.newNode(com.google.javascript.rhino.Token.AWAIT);
            await.addChildToBack(IRFactory.this.transform(tree.expression));
            return await;
        }

        Node processExportDecl(ExportDeclarationTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.MODULES);
            Node decls = null;
            if (tree.isExportAll) {
                Preconditions.checkState(tree.declaration == null && tree.exportSpecifierList == null);
            } else if (tree.declaration != null) {
                Preconditions.checkState(tree.exportSpecifierList == null);
                decls = IRFactory.this.transform(tree.declaration);
            } else {
                decls = this.transformList(com.google.javascript.rhino.Token.EXPORT_SPECS, tree.exportSpecifierList);
            }
            if (decls == null) {
                decls = IRFactory.this.newNode(com.google.javascript.rhino.Token.EMPTY);
            }
            IRFactory.this.setSourceInfo(decls, tree);
            Node export = IRFactory.this.newNode(com.google.javascript.rhino.Token.EXPORT, decls);
            if (tree.from != null) {
                Node from = this.processString(tree.from);
                export.addChildToBack(from);
            }
            export.putBooleanProp(Node.EXPORT_ALL_FROM, tree.isExportAll);
            export.putBooleanProp(Node.EXPORT_DEFAULT, tree.isDefault);
            return export;
        }

        Node processExportSpec(ExportSpecifierTree tree) {
            Node importedName = this.processName(tree.importedName, true);
            importedName.setToken(com.google.javascript.rhino.Token.NAME);
            Node exportSpec = IRFactory.this.newNode(com.google.javascript.rhino.Token.EXPORT_SPEC, importedName);
            if (tree.destinationName == null) {
                exportSpec.setShorthandProperty(true);
                exportSpec.addChildToBack(importedName.cloneTree());
            } else {
                Node destinationName = this.processName(tree.destinationName, true);
                destinationName.setToken(com.google.javascript.rhino.Token.NAME);
                exportSpec.addChildToBack(destinationName);
            }
            return exportSpec;
        }

        Node processImportDecl(ImportDeclarationTree tree) {
            Node secondChild;
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.MODULES);
            Node firstChild = this.transformOrEmpty(tree.defaultBindingIdentifier, (ParseTree)tree);
            if (tree.nameSpaceImportIdentifier == null) {
                secondChild = this.transformListOrEmpty(com.google.javascript.rhino.Token.IMPORT_SPECS, tree.importSpecifierList);
                IRFactory.this.setSourceInfo(secondChild, tree);
            } else {
                secondChild = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.IMPORT_STAR, tree.nameSpaceImportIdentifier.value);
                IRFactory.this.setSourceInfo(secondChild, tree.nameSpaceImportIdentifier);
            }
            Node thirdChild = this.processString(tree.moduleSpecifier);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.IMPORT, firstChild, secondChild, thirdChild);
        }

        Node processImportSpec(ImportSpecifierTree tree) {
            Node importedName = this.processName(tree.importedName, true);
            importedName.setToken(com.google.javascript.rhino.Token.NAME);
            Node importSpec = IRFactory.this.newNode(com.google.javascript.rhino.Token.IMPORT_SPEC, importedName);
            if (tree.destinationName == null) {
                importSpec.setShorthandProperty(true);
                importSpec.addChildToBack(importedName.cloneTree());
            } else {
                importSpec.addChildToBack(this.processName(tree.destinationName));
            }
            return importSpec;
        }

        Node processDynamicImport(DynamicImportTree dynamicImportNode) {
            IRFactory.this.maybeWarnForFeature(dynamicImportNode, FeatureSet.Feature.DYNAMIC_IMPORT);
            Node argument = IRFactory.this.transform(dynamicImportNode.argument);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.DYNAMIC_IMPORT, argument);
        }

        Node processImportMeta(ImportMetaExpressionTree tree) {
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.MODULES);
            IRFactory.this.maybeWarnForFeature(tree, FeatureSet.Feature.IMPORT_META);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.IMPORT_META);
        }

        Node processTypeName(TypeNameTree tree) {
            Node typeNode;
            if (tree.segments.size() == 1) {
                String typeName;
                switch (typeName = (String)tree.segments.get(0)) {
                    case "any": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.anyType());
                        break;
                    }
                    case "number": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.numberType());
                        break;
                    }
                    case "boolean": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.booleanType());
                        break;
                    }
                    case "string": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.stringType());
                        break;
                    }
                    case "void": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.voidType());
                        break;
                    }
                    case "undefined": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.undefinedType());
                        break;
                    }
                    default: {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.namedType(tree.segments));
                        break;
                    }
                }
            } else {
                typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.namedType(tree.segments));
            }
            IRFactory.this.setSourceInfo(typeNode, tree);
            return typeNode;
        }

        Node processTypedParameter(TypedParameterTree typeAnnotation) {
            Node param = IRFactory.this.transform(typeAnnotation.param);
            this.maybeProcessType(param, typeAnnotation.typeAnnotation);
            return param;
        }

        Node processOptionalParameter(OptionalParameterTree optionalParam) {
            this.maybeWarnTypeSyntax(optionalParam, FeatureSet.Feature.OPTIONAL_PARAMETER);
            Node param = IRFactory.this.transform(optionalParam.param);
            param.putBooleanProp(Node.OPT_ES6_TYPED, true);
            return param;
        }

        private void maybeProcessType(Node typeTarget, ParseTree typeTree) {
            if (typeTree != null) {
                IRFactory.this.recordJsDoc(typeTree.location, typeTarget.getJSDocInfo());
                Node typeExpression = this.convertTypeTree(typeTree);
                if (typeExpression.isString()) {
                    typeExpression = IRFactory.this.cloneProps(new Node.TypeDeclarationNode(com.google.javascript.rhino.Token.STRING, typeExpression.getString()));
                }
                typeTarget.setDeclaredTypeExpression((Node.TypeDeclarationNode)typeExpression);
            }
        }

        private void maybeProcessGenerics(Node n, GenericTypeListTree generics) {
            if (generics != null) {
                this.maybeWarnTypeSyntax(generics, FeatureSet.Feature.GENERICS);
                n.putProp(Node.GENERIC_TYPE_LIST, IRFactory.this.transform(generics));
            }
        }

        private Node convertTypeTree(ParseTree typeTree) {
            this.maybeWarnTypeSyntax(typeTree, FeatureSet.Feature.TYPE_ANNOTATION);
            return IRFactory.this.transform(typeTree);
        }

        Node processParameterizedType(ParameterizedTypeTree tree) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (ParseTree arg : tree.typeArguments) {
                arguments.add((Node.TypeDeclarationNode)IRFactory.this.transform(arg));
            }
            Node.TypeDeclarationNode typeName = (Node.TypeDeclarationNode)IRFactory.this.transform(tree.typeName);
            return IRFactory.this.cloneProps(TypeDeclarationsIR.parameterizedType(typeName, arguments.build()));
        }

        Node processArrayType(ArrayTypeTree tree) {
            return IRFactory.this.cloneProps(TypeDeclarationsIR.arrayType(IRFactory.this.transform(tree.elementType)));
        }

        Node processRecordType(RecordTypeTree tree) {
            Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(com.google.javascript.rhino.Token.RECORD_TYPE);
            for (ParseTree child : tree.members) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return IRFactory.this.cloneProps(node);
        }

        Node processUnionType(UnionTypeTree tree) {
            ImmutableList.Builder options = ImmutableList.builder();
            for (ParseTree option : tree.types) {
                options.add((Node.TypeDeclarationNode)IRFactory.this.transform(option));
            }
            return IRFactory.this.cloneProps(TypeDeclarationsIR.unionType(options.build()));
        }

        Node processTypeAlias(TypeAliasTree tree) {
            this.maybeWarnTypeSyntax(tree, FeatureSet.Feature.TYPE_ALIAS);
            Node typeAlias = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.TYPE_ALIAS, tree.alias.value);
            typeAlias.addChildToFront(IRFactory.this.transform(tree.original));
            return typeAlias;
        }

        Node processAmbientDeclaration(AmbientDeclarationTree tree) {
            this.maybeWarnTypeSyntax(tree, FeatureSet.Feature.AMBIENT_DECLARATION);
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.DECLARE, IRFactory.this.transform(tree.declaration));
        }

        Node processNamespaceDeclaration(NamespaceDeclarationTree tree) {
            this.maybeWarnTypeSyntax(tree, FeatureSet.Feature.NAMESPACE_DECLARATION);
            Node name = this.processNamespaceName(tree.name);
            Node body = IRFactory.this.newNode(com.google.javascript.rhino.Token.NAMESPACE_ELEMENTS);
            IRFactory.this.setSourceInfo(body, tree);
            for (ParseTree child : tree.elements) {
                body.addChildToBack(IRFactory.this.transform(child));
            }
            return IRFactory.this.newNode(com.google.javascript.rhino.Token.NAMESPACE, name, body);
        }

        Node processNamespaceName(NamespaceNameTree name) {
            ImmutableList<String> segments = name.segments;
            if (segments.size() == 1) {
                Node namespaceName = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, (String)segments.get(0));
                IRFactory.this.setSourceInfo(namespaceName, name);
                return namespaceName;
            }
            Iterator segmentsIt = segments.iterator();
            Node node = IR.name((String)segmentsIt.next());
            IRFactory.this.setSourceInfo(node, name);
            while (segmentsIt.hasNext()) {
                Node string = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.STRING, (String)segmentsIt.next());
                IRFactory.this.setSourceInfo(string, name);
                node = IRFactory.this.newNode(com.google.javascript.rhino.Token.GETPROP, node, string);
                IRFactory.this.setSourceInfo(node, name);
            }
            return node;
        }

        Node processIndexSignature(IndexSignatureTree tree) {
            this.maybeWarnTypeSyntax(tree, FeatureSet.Feature.INDEX_SIGNATURE);
            Node name = IRFactory.this.transform(tree.name);
            Node.TypeDeclarationNode indexType = name.getDeclaredTypeExpression();
            if (indexType.getToken() != com.google.javascript.rhino.Token.NUMBER_TYPE && indexType.getToken() != com.google.javascript.rhino.Token.STRING_TYPE) {
                IRFactory.this.errorReporter.error("Index signature parameter type must be 'string' or 'number'", IRFactory.this.sourceName, IRFactory.lineno(tree.name), IRFactory.charno(tree.name));
            }
            Node signature = IRFactory.this.newNode(com.google.javascript.rhino.Token.INDEX_SIGNATURE, name);
            this.maybeProcessType(signature, tree.declaredType);
            return signature;
        }

        Node processCallSignature(CallSignatureTree tree) {
            this.maybeWarnTypeSyntax(tree, tree.isNew ? FeatureSet.Feature.CONSTRUCTOR_SIGNATURE : FeatureSet.Feature.CALL_SIGNATURE);
            Node signature = IRFactory.this.newNode(com.google.javascript.rhino.Token.CALL_SIGNATURE, IRFactory.this.transform(tree.formalParameterList));
            this.maybeProcessType(signature, tree.returnType);
            this.maybeProcessGenerics(signature, tree.generics);
            signature.putBooleanProp(Node.CONSTRUCT_SIGNATURE, tree.isNew);
            return signature;
        }

        private boolean checkParameters(ImmutableList<ParseTree> params) {
            boolean seenOptional = false;
            boolean good = true;
            block5: for (int i = 0; i < params.size(); ++i) {
                ParseTree param = (ParseTree)params.get(i);
                Node type = null;
                if (param.type == ParseTreeType.TYPED_PARAMETER) {
                    TypedParameterTree typedParam = param.asTypedParameter();
                    type = IRFactory.this.transform(typedParam.typeAnnotation);
                    param = typedParam.param;
                }
                switch (param.type) {
                    case IDENTIFIER_EXPRESSION: {
                        if (!seenOptional) continue block5;
                        IRFactory.this.errorReporter.error("A required parameter cannot follow an optional parameter.", IRFactory.this.sourceName, IRFactory.lineno(param), IRFactory.charno(param));
                        good = false;
                        continue block5;
                    }
                    case OPTIONAL_PARAMETER: {
                        seenOptional = true;
                        continue block5;
                    }
                    case ITER_REST: {
                        if (i != params.size() - 1) {
                            IRFactory.this.errorReporter.error("A rest parameter must be last in a parameter list.", IRFactory.this.sourceName, IRFactory.lineno(param), IRFactory.charno(param));
                            good = false;
                        }
                        if (type == null || type.getToken() == com.google.javascript.rhino.Token.ARRAY_TYPE) continue block5;
                        IRFactory.this.errorReporter.error("A rest parameter must be of an array type.", IRFactory.this.sourceName, IRFactory.lineno(param), IRFactory.charno(param));
                        good = false;
                        continue block5;
                    }
                }
            }
            return good;
        }

        Node processFunctionType(FunctionTypeTree tree) {
            LinkedHashMap<String, Node.TypeDeclarationNode> requiredParams = new LinkedHashMap<String, Node.TypeDeclarationNode>();
            LinkedHashMap<String, Node.TypeDeclarationNode> optionalParams = new LinkedHashMap<String, Node.TypeDeclarationNode>();
            String restName = null;
            Node.TypeDeclarationNode restType = null;
            if (this.checkParameters(tree.formalParameterList.parameters)) {
                block5: for (ParseTree param : tree.formalParameterList.parameters) {
                    Node.TypeDeclarationNode type = null;
                    if (param.type == ParseTreeType.TYPED_PARAMETER) {
                        TypedParameterTree typedParam = param.asTypedParameter();
                        type = (Node.TypeDeclarationNode)IRFactory.this.transform(typedParam.typeAnnotation);
                        param = typedParam.param;
                    }
                    switch (param.type) {
                        case IDENTIFIER_EXPRESSION: {
                            requiredParams.put(param.asIdentifierExpression().identifierToken.value, type);
                            continue block5;
                        }
                        case OPTIONAL_PARAMETER: {
                            this.maybeWarnTypeSyntax(param, FeatureSet.Feature.OPTIONAL_PARAMETER);
                            optionalParams.put(param.asOptionalParameter().param.asIdentifierExpression().identifierToken.value, type);
                            continue block5;
                        }
                        case ITER_REST: {
                            restName = param.asIterRest().assignmentTarget.asIdentifierExpression().identifierToken.value;
                            restType = type;
                            continue block5;
                        }
                    }
                    throw new IllegalStateException("Illegal parameter type: " + (Object)((Object)param.type));
                }
            }
            return IRFactory.this.cloneProps(TypeDeclarationsIR.functionType(IRFactory.this.transform(tree.returnType), requiredParams, optionalParams, restName, restType));
        }

        Node processTypeQuery(TypeQueryTree tree) {
            Iterator segmentsIt = tree.segments.iterator();
            Node node = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.NAME, (String)segmentsIt.next());
            while (segmentsIt.hasNext()) {
                node = IR.getprop(node, IR.string((String)segmentsIt.next()));
            }
            return IRFactory.this.cloneProps(new Node.TypeDeclarationNode(com.google.javascript.rhino.Token.TYPEOF, node));
        }

        Node processGenericTypeList(GenericTypeListTree tree) {
            Node list = IRFactory.this.newNode(com.google.javascript.rhino.Token.GENERIC_TYPE_LIST);
            for (Map.Entry<IdentifierToken, ParseTree> generic : tree.generics.entrySet()) {
                Node type = IRFactory.this.newStringNode(com.google.javascript.rhino.Token.GENERIC_TYPE, generic.getKey().value);
                ParseTree bound = generic.getValue();
                if (bound != null) {
                    type.addChildToBack(IRFactory.this.transform(bound));
                }
                list.addChildToBack(type);
            }
            return list;
        }

        private Node transformList(com.google.javascript.rhino.Token type, ImmutableList<ParseTree> list) {
            Node n = IRFactory.this.newNode(type);
            for (ParseTree tree : list) {
                n.addChildToBack(IRFactory.this.transform(tree));
            }
            return n;
        }

        private Node transformListOrEmpty(com.google.javascript.rhino.Token type, ImmutableList<ParseTree> list) {
            if (list == null || list.isEmpty()) {
                return IRFactory.this.newNode(com.google.javascript.rhino.Token.EMPTY);
            }
            return this.transformList(type, list);
        }

        void maybeProcessAccessibilityModifier(ParseTree parseTree, Node n, @Nullable TokenType type) {
            if (type != null) {
                JSDocInfo.Visibility access;
                switch (type) {
                    case PUBLIC: {
                        access = JSDocInfo.Visibility.PUBLIC;
                        break;
                    }
                    case PROTECTED: {
                        access = JSDocInfo.Visibility.PROTECTED;
                        break;
                    }
                    case PRIVATE: {
                        access = JSDocInfo.Visibility.PRIVATE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected access modifier type");
                    }
                }
                this.maybeWarnTypeSyntax(parseTree, FeatureSet.Feature.ACCESSIBILITY_MODIFIER);
                n.putProp(Node.ACCESS_MODIFIER, (Object)access);
            }
        }

        void maybeWarnTypeSyntax(ParseTree node, FeatureSet.Feature feature) {
            if (IRFactory.this.config.languageMode() != Config.LanguageMode.TYPESCRIPT) {
                IRFactory.this.errorReporter.warning("type syntax is only supported in ES6 typed mode: " + (Object)((Object)feature), IRFactory.this.sourceName, IRFactory.lineno(node), IRFactory.charno(node));
            }
            IRFactory.this.features = IRFactory.this.features.with(feature);
            IRFactory.this.recordTypeSyntax(node.location);
        }

        Node unsupportedLanguageFeature(ParseTree node, String feature) {
            IRFactory.this.errorReporter.error("unsupported language feature: " + feature, IRFactory.this.sourceName, IRFactory.lineno(node), IRFactory.charno(node));
            return this.createMissingExpressionNode();
        }

        Node processLiteralExpression(LiteralExpressionTree expr) {
            switch (expr.literalToken.type) {
                case NUMBER: {
                    return this.processNumberLiteral(expr);
                }
                case STRING: {
                    return this.processStringLiteral(expr);
                }
                case BIGINT: {
                    return this.processBigIntLiteral(expr);
                }
                case FALSE: 
                case TRUE: {
                    return this.processBooleanLiteral(expr);
                }
                case NULL: {
                    return this.processNullLiteral(expr);
                }
                case REGULAR_EXPRESSION: {
                    return this.processRegExpLiteral(expr);
                }
            }
            throw new IllegalStateException("Unexpected literal type: " + expr.literalToken.getClass() + " type: " + (Object)((Object)expr.literalToken.type));
        }

        public Node process(ParseTree node) {
            switch (node.type) {
                case BINARY_OPERATOR: {
                    return this.processBinaryExpression(node.asBinaryOperator());
                }
                case ARRAY_LITERAL_EXPRESSION: {
                    return this.processArrayLiteral(node.asArrayLiteralExpression());
                }
                case TEMPLATE_LITERAL_EXPRESSION: {
                    return this.processTemplateLiteral(node.asTemplateLiteralExpression());
                }
                case TEMPLATE_LITERAL_PORTION: {
                    return this.processTemplateLiteralPortion(node.asTemplateLiteralPortion());
                }
                case TEMPLATE_SUBSTITUTION: {
                    return this.processTemplateSubstitution(node.asTemplateSubstitution());
                }
                case UNARY_EXPRESSION: {
                    return this.processUnaryExpression(node.asUnaryExpression());
                }
                case BLOCK: {
                    return this.processBlock(node.asBlock());
                }
                case BREAK_STATEMENT: {
                    return this.processBreakStatement(node.asBreakStatement());
                }
                case CALL_EXPRESSION: {
                    return this.processFunctionCall(node.asCallExpression());
                }
                case OPT_CHAIN__CALL_EXPRESSION: {
                    return this.processOptChainFunctionCall(node.asOptionalCallExpression());
                }
                case CASE_CLAUSE: {
                    return this.processSwitchCase(node.asCaseClause());
                }
                case DEFAULT_CLAUSE: {
                    return this.processSwitchDefault(node.asDefaultClause());
                }
                case CATCH: {
                    return this.processCatchClause(node.asCatch());
                }
                case CONTINUE_STATEMENT: {
                    return this.processContinueStatement(node.asContinueStatement());
                }
                case DO_WHILE_STATEMENT: {
                    return this.processDoLoop(node.asDoWhileStatement());
                }
                case EMPTY_STATEMENT: {
                    return this.processEmptyStatement(node.asEmptyStatement());
                }
                case EXPRESSION_STATEMENT: {
                    return this.processExpressionStatement(node.asExpressionStatement());
                }
                case DEBUGGER_STATEMENT: {
                    return this.processDebuggerStatement(node.asDebuggerStatement());
                }
                case THIS_EXPRESSION: {
                    return this.processThisExpression(node.asThisExpression());
                }
                case FOR_STATEMENT: {
                    return this.processForLoop(node.asForStatement());
                }
                case FOR_IN_STATEMENT: {
                    return this.processForInLoop(node.asForInStatement());
                }
                case FUNCTION_DECLARATION: {
                    return this.processFunction(node.asFunctionDeclaration());
                }
                case MEMBER_LOOKUP_EXPRESSION: {
                    return this.processElementGet(node.asMemberLookupExpression());
                }
                case OPT_CHAIN_MEMBER_LOOKUP_EXPRESSION: {
                    return this.processOptChainElementGet(node.asOptionalMemberLookupExpression());
                }
                case MEMBER_EXPRESSION: {
                    return this.processPropertyGet(node.asMemberExpression());
                }
                case OPT_CHAIN_MEMBER_EXPRESSION: {
                    return this.processOptChainPropertyGet(node.asOptionalMemberExpression());
                }
                case CONDITIONAL_EXPRESSION: {
                    return this.processConditionalExpression(node.asConditionalExpression());
                }
                case IF_STATEMENT: {
                    return this.processIfStatement(node.asIfStatement());
                }
                case LABELLED_STATEMENT: {
                    return this.processLabeledStatement(node.asLabelledStatement());
                }
                case PAREN_EXPRESSION: {
                    return this.processParenthesizedExpression(node.asParenExpression());
                }
                case IDENTIFIER_EXPRESSION: {
                    return this.processName(node.asIdentifierExpression());
                }
                case NEW_EXPRESSION: {
                    return this.processNewExpression(node.asNewExpression());
                }
                case OBJECT_LITERAL_EXPRESSION: {
                    return this.processObjectLiteral(node.asObjectLiteralExpression());
                }
                case COMPUTED_PROPERTY_DEFINITION: {
                    return this.processComputedPropertyDefinition(node.asComputedPropertyDefinition());
                }
                case COMPUTED_PROPERTY_GETTER: {
                    return this.processComputedPropertyGetter(node.asComputedPropertyGetter());
                }
                case COMPUTED_PROPERTY_MEMBER_VARIABLE: {
                    return this.processComputedPropertyMemberVariable(node.asComputedPropertyMemberVariable());
                }
                case COMPUTED_PROPERTY_METHOD: {
                    return this.processComputedPropertyMethod(node.asComputedPropertyMethod());
                }
                case COMPUTED_PROPERTY_SETTER: {
                    return this.processComputedPropertySetter(node.asComputedPropertySetter());
                }
                case RETURN_STATEMENT: {
                    return this.processReturnStatement(node.asReturnStatement());
                }
                case UPDATE_EXPRESSION: {
                    return this.processUpdateExpression(node.asUpdateExpression());
                }
                case PROGRAM: {
                    return this.processAstRoot(node.asProgram());
                }
                case LITERAL_EXPRESSION: {
                    return this.processLiteralExpression(node.asLiteralExpression());
                }
                case SWITCH_STATEMENT: {
                    return this.processSwitchStatement(node.asSwitchStatement());
                }
                case THROW_STATEMENT: {
                    return this.processThrowStatement(node.asThrowStatement());
                }
                case TRY_STATEMENT: {
                    return this.processTryStatement(node.asTryStatement());
                }
                case VARIABLE_STATEMENT: {
                    return this.processVariableStatement(node.asVariableStatement());
                }
                case VARIABLE_DECLARATION_LIST: {
                    return this.processVariableDeclarationList(node.asVariableDeclarationList());
                }
                case VARIABLE_DECLARATION: {
                    return this.processVariableDeclaration(node.asVariableDeclaration());
                }
                case WHILE_STATEMENT: {
                    return this.processWhileLoop(node.asWhileStatement());
                }
                case WITH_STATEMENT: {
                    return this.processWithStatement(node.asWithStatement());
                }
                case COMMA_EXPRESSION: {
                    return this.processCommaExpression(node.asCommaExpression());
                }
                case NULL: {
                    return this.processNull(node.asNull());
                }
                case FINALLY: {
                    return this.processFinally(node.asFinally());
                }
                case MISSING_PRIMARY_EXPRESSION: {
                    return this.processMissingExpression(node.asMissingPrimaryExpression());
                }
                case PROPERTY_NAME_ASSIGNMENT: {
                    return this.processPropertyNameAssignment(node.asPropertyNameAssignment());
                }
                case GET_ACCESSOR: {
                    return this.processGetAccessor(node.asGetAccessor());
                }
                case SET_ACCESSOR: {
                    return this.processSetAccessor(node.asSetAccessor());
                }
                case FORMAL_PARAMETER_LIST: {
                    return this.processFormalParameterList(node.asFormalParameterList());
                }
                case CLASS_DECLARATION: {
                    return this.processClassDeclaration(node.asClassDeclaration());
                }
                case SUPER_EXPRESSION: {
                    return this.processSuper(node.asSuperExpression());
                }
                case NEW_TARGET_EXPRESSION: {
                    return this.processNewTarget(node.asNewTargetExpression());
                }
                case YIELD_EXPRESSION: {
                    return this.processYield(node.asYieldStatement());
                }
                case AWAIT_EXPRESSION: {
                    return this.processAwait(node.asAwaitExpression());
                }
                case FOR_OF_STATEMENT: {
                    return this.processForOf(node.asForOfStatement());
                }
                case FOR_AWAIT_OF_STATEMENT: {
                    return this.processForAwaitOf(node.asForAwaitOfStatement());
                }
                case EXPORT_DECLARATION: {
                    return this.processExportDecl(node.asExportDeclaration());
                }
                case EXPORT_SPECIFIER: {
                    return this.processExportSpec(node.asExportSpecifier());
                }
                case IMPORT_DECLARATION: {
                    return this.processImportDecl(node.asImportDeclaration());
                }
                case IMPORT_SPECIFIER: {
                    return this.processImportSpec(node.asImportSpecifier());
                }
                case DYNAMIC_IMPORT_EXPRESSION: {
                    return this.processDynamicImport(node.asDynamicImportExpression());
                }
                case IMPORT_META_EXPRESSION: {
                    return this.processImportMeta(node.asImportMetaExpression());
                }
                case ARRAY_PATTERN: {
                    return this.processArrayPattern(node.asArrayPattern());
                }
                case OBJECT_PATTERN: {
                    return this.processObjectPattern(node.asObjectPattern());
                }
                case COMPREHENSION: {
                    return this.processComprehension(node.asComprehension());
                }
                case COMPREHENSION_FOR: {
                    return this.processComprehensionFor(node.asComprehensionFor());
                }
                case COMPREHENSION_IF: {
                    return this.processComprehensionIf(node.asComprehensionIf());
                }
                case DEFAULT_PARAMETER: {
                    return this.processDefaultParameter(node.asDefaultParameter());
                }
                case ITER_REST: {
                    return this.processIterRest(node.asIterRest());
                }
                case ITER_SPREAD: {
                    return this.processIterSpread(node.asIterSpread());
                }
                case OBJECT_REST: {
                    return this.processObjectPatternElement(node.asObjectRest());
                }
                case OBJECT_SPREAD: {
                    return this.processObjectSpread(node.asObjectSpread());
                }
                case TYPE_NAME: {
                    return this.processTypeName(node.asTypeName());
                }
                case TYPED_PARAMETER: {
                    return this.processTypedParameter(node.asTypedParameter());
                }
                case OPTIONAL_PARAMETER: {
                    return this.processOptionalParameter(node.asOptionalParameter());
                }
                case PARAMETERIZED_TYPE_TREE: {
                    return this.processParameterizedType(node.asParameterizedType());
                }
                case ARRAY_TYPE: {
                    return this.processArrayType(node.asArrayType());
                }
                case RECORD_TYPE: {
                    return this.processRecordType(node.asRecordType());
                }
                case UNION_TYPE: {
                    return this.processUnionType(node.asUnionType());
                }
                case FUNCTION_TYPE: {
                    return this.processFunctionType(node.asFunctionType());
                }
                case TYPE_QUERY: {
                    return this.processTypeQuery(node.asTypeQuery());
                }
                case GENERIC_TYPE_LIST: {
                    return this.processGenericTypeList(node.asGenericTypeList());
                }
                case MEMBER_VARIABLE: {
                    return this.processMemberVariable(node.asMemberVariable());
                }
                case INTERFACE_DECLARATION: {
                    return this.processInterfaceDeclaration(node.asInterfaceDeclaration());
                }
                case ENUM_DECLARATION: {
                    return this.processEnumDeclaration(node.asEnumDeclaration());
                }
                case TYPE_ALIAS: {
                    return this.processTypeAlias(node.asTypeAlias());
                }
                case AMBIENT_DECLARATION: {
                    return this.processAmbientDeclaration(node.asAmbientDeclaration());
                }
                case NAMESPACE_DECLARATION: {
                    return this.processNamespaceDeclaration(node.asNamespaceDeclaration());
                }
                case INDEX_SIGNATURE: {
                    return this.processIndexSignature(node.asIndexSignature());
                }
                case CALL_SIGNATURE: {
                    return this.processCallSignature(node.asCallSignature());
                }
            }
            return this.processIllegalToken(node);
        }
    }
}

