/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.InstantiatedMember;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.annotation.AnnotationMapper;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.annotation.TypedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Scope;

public abstract class AbstractAnnotationMetadataBuilder<T, A> {
    private static final Map<String, List<AnnotationMapper>> ANNOTATION_MAPPERS = new HashMap<String, List<AnnotationMapper>>();
    private static final Map<String, List<AnnotationRemapper>> ANNOTATION_REMAPPERS = new HashMap<String, List<AnnotationRemapper>>();
    private static final Map<MetadataKey, AnnotationMetadata> MUTATED_ANNOTATION_METADATA = new HashMap<MetadataKey, AnnotationMetadata>();
    private boolean validating = true;
    private final Set<T> erroneousElements = new HashSet<T>();

    protected AbstractAnnotationMetadataBuilder() {
    }

    public AnnotationMetadata buildDeclared(T element) {
        AnnotationMetadata existing = MUTATED_ANNOTATION_METADATA.get(element);
        if (existing != null) {
            return existing;
        }
        DefaultAnnotationMetadata annotationMetadata = new DefaultAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, true, true);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            if ("org.eclipse.jdt.internal.compiler.problem.AbortCompilation".equals(e.getClass().getName())) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            throw e;
        }
    }

    public AnnotationMetadata build(T element) {
        String declaringType = this.getDeclaringType(element);
        return this.build(declaringType, element);
    }

    public AnnotationMetadata build(String declaringType, T element) {
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        if (existing != null) {
            return existing;
        }
        DefaultAnnotationMetadata annotationMetadata = new DefaultAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, true, false);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            if ("org.eclipse.jdt.internal.compiler.problem.AbortCompilation".equals(e.getClass().getName())) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            throw e;
        }
    }

    protected abstract boolean isMethodOrClassElement(T var1);

    @Nonnull
    protected abstract String getDeclaringType(@Nonnull T var1);

    public AnnotationMetadata buildForMethod(T element) {
        String declaringType = this.getDeclaringType(element);
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        if (existing != null) {
            return existing;
        }
        DefaultAnnotationMetadata annotationMetadata = new DefaultAnnotationMetadata();
        return this.buildInternal(null, element, annotationMetadata, false, false);
    }

    public AnnotationMetadata buildForParent(T parent, T element) {
        String declaringType = this.getDeclaringType(element);
        return this.buildForParent(declaringType, parent, element);
    }

    public AnnotationMetadata buildForParent(String declaringType, T parent, T element) {
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        DefaultAnnotationMetadata annotationMetadata = existing instanceof DefaultAnnotationMetadata ? (DefaultAnnotationMetadata)((DefaultAnnotationMetadata)existing).clone() : new DefaultAnnotationMetadata();
        return this.buildInternal(parent, element, annotationMetadata, false, false);
    }

    public AnnotationMetadata buildForParent(T parent, T element, boolean inheritTypeAnnotations) {
        String declaringType = this.getDeclaringType(element);
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        DefaultAnnotationMetadata annotationMetadata = existing instanceof DefaultAnnotationMetadata ? (DefaultAnnotationMetadata)((DefaultAnnotationMetadata)existing).clone() : new DefaultAnnotationMetadata();
        return this.buildInternal(parent, element, annotationMetadata, inheritTypeAnnotations, false);
    }

    protected abstract T getTypeForAnnotation(A var1);

    protected abstract boolean hasAnnotation(T var1, Class<? extends Annotation> var2);

    protected abstract String getAnnotationTypeName(A var1);

    protected abstract List<? extends A> getAnnotationsForType(T var1);

    protected abstract List<T> buildHierarchy(T var1, boolean var2, boolean var3);

    protected abstract void readAnnotationRawValues(T var1, String var2, T var3, String var4, Object var5, Map<CharSequence, Object> var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAnnotationValue(T originatingElement, String annotationName, T member, final String memberName, Object resolvedValue) {
        if (!this.validating) {
            return;
        }
        AnnotatedElementValidator elementValidator = this.getElementValidator();
        if (elementValidator != null && !this.erroneousElements.contains(member)) {
            boolean shouldValidate;
            boolean bl = shouldValidate = !annotationName.equals(AliasFor.class.getName()) && (!(resolvedValue instanceof String) || !resolvedValue.toString().contains("${"));
            if (shouldValidate) {
                AnnotationMetadata metadata;
                try {
                    this.validating = false;
                    metadata = this.buildDeclared(member);
                }
                finally {
                    this.validating = true;
                }
                Set<String> errors = elementValidator.validatedAnnotatedElement(new AnnotatedElement(){

                    @Nonnull
                    public String getName() {
                        return memberName;
                    }

                    public AnnotationMetadata getAnnotationMetadata() {
                        return metadata;
                    }
                }, resolvedValue);
                if (CollectionUtils.isNotEmpty(errors)) {
                    this.erroneousElements.add(member);
                    for (String error : errors) {
                        error = "@" + NameUtils.getSimpleName((String)annotationName) + "." + memberName + ": " + error;
                        this.addError(originatingElement, error);
                    }
                }
            }
        }
    }

    @Nullable
    protected AnnotatedElementValidator getElementValidator() {
        return null;
    }

    protected abstract void addError(@Nonnull T var1, @Nonnull String var2);

    protected abstract Object readAnnotationValue(T var1, T var2, String var3, Object var4);

    protected abstract Map<? extends T, ?> readAnnotationDefaultValues(A var1);

    protected abstract Map<? extends T, ?> readAnnotationDefaultValues(String var1, T var2);

    protected abstract Map<? extends T, ?> readAnnotationRawValues(A var1);

    protected abstract OptionalValues<?> getAnnotationValues(T var1, T var2, Class<?> var3);

    protected abstract String getAnnotationMemberName(T var1);

    @Nullable
    protected abstract String getRepeatableName(A var1);

    @Nullable
    protected abstract String getRepeatableNameForType(T var1);

    protected AnnotationValue readNestedAnnotationValue(T originatingElement, A annotationMirror) {
        AnnotationValue av;
        Map<T, ?> annotationValues = this.readAnnotationRawValues(annotationMirror);
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        if (annotationValues.isEmpty()) {
            av = new AnnotationValue(annotationTypeName);
        } else {
            LinkedHashMap<CharSequence, Object> resolvedValues = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<T, ?> entry : annotationValues.entrySet()) {
                T member = entry.getKey();
                OptionalValues<AliasFor> aliasForValues = this.getAnnotationValues(originatingElement, member, AliasFor.class);
                Object annotationValue = entry.getValue();
                Optional aliasMember = aliasForValues.get((CharSequence)"member");
                Optional aliasAnnotation = aliasForValues.get((CharSequence)"annotation");
                Optional aliasAnnotationName = aliasForValues.get((CharSequence)"annotationName");
                if (aliasMember.isPresent() && !aliasAnnotation.isPresent() && !aliasAnnotationName.isPresent()) {
                    String aliasedNamed = aliasMember.get().toString();
                    this.readAnnotationRawValues(originatingElement, annotationTypeName, member, aliasedNamed, annotationValue, resolvedValues);
                }
                String memberName = this.getAnnotationMemberName(member);
                this.readAnnotationRawValues(originatingElement, annotationTypeName, member, memberName, annotationValue, resolvedValues);
            }
            av = new AnnotationValue(annotationTypeName, resolvedValues);
        }
        return av;
    }

    protected abstract Optional<T> getAnnotationMirror(String var1);

    protected Map<CharSequence, Object> populateAnnotationData(T originatingElement, A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        Map<CharSequence, Object> annotationValues;
        String annotationName = this.getAnnotationTypeName(annotationMirror);
        this.processAnnotationDefaults(originatingElement, annotationMirror, metadata, annotationName);
        ArrayList<String> parentAnnotations = new ArrayList<String>();
        parentAnnotations.add(annotationName);
        Map<T, ?> elementValues = this.readAnnotationRawValues(annotationMirror);
        if (CollectionUtils.isEmpty(elementValues)) {
            annotationValues = Collections.emptyMap();
        } else {
            annotationValues = new LinkedHashMap();
            for (Map.Entry<T, ?> entry : elementValues.entrySet()) {
                T member = entry.getKey();
                if (member == null) continue;
                boolean isInstantiatedMember = this.hasAnnotation(member, InstantiatedMember.class);
                Optional aliases = this.getAnnotationValues(originatingElement, member, Aliases.class).get((CharSequence)"value");
                Object annotationValue = entry.getValue();
                if (isInstantiatedMember) {
                    String memberName = this.getAnnotationMemberName(member);
                    Object rawValue = this.readAnnotationValue(originatingElement, member, memberName, annotationValue);
                    if (!(rawValue instanceof AnnotationClassValue)) continue;
                    AnnotationClassValue acv = (AnnotationClassValue)rawValue;
                    annotationValues.put(memberName, new AnnotationClassValue(acv.getName(), true));
                    continue;
                }
                if (aliases.isPresent()) {
                    Object value = aliases.get();
                    if (value instanceof AnnotationValue[]) {
                        AnnotationClassValue values;
                        for (AnnotationClassValue av : values = (AnnotationClassValue)value) {
                            OptionalValues aliasForValues = OptionalValues.of(Object.class, (Map)av.getValues());
                            this.processAnnotationAlias(originatingElement, annotationName, member, metadata, isDeclared, parentAnnotations, annotationValues, annotationValue, aliasForValues);
                        }
                    }
                    this.readAnnotationRawValues(originatingElement, annotationName, member, this.getAnnotationMemberName(member), annotationValue, annotationValues);
                    continue;
                }
                OptionalValues<AliasFor> aliasForValues = this.getAnnotationValues(originatingElement, member, AliasFor.class);
                this.processAnnotationAlias(originatingElement, annotationName, member, metadata, isDeclared, parentAnnotations, annotationValues, annotationValue, aliasForValues);
                this.readAnnotationRawValues(originatingElement, annotationName, member, this.getAnnotationMemberName(member), annotationValue, annotationValues);
            }
        }
        List<AnnotationMapper> mappers = ANNOTATION_MAPPERS.get(annotationName);
        if (mappers != null) {
            AnnotationValue annotationValue = new AnnotationValue(annotationName, annotationValues);
            VisitorContext visitorContext = this.createVisitorContext();
            for (AnnotationMapper mapper : mappers) {
                List<AnnotationValue<?>> mapped = mapper.map(annotationValue, visitorContext);
                if (mapped == null) continue;
                for (AnnotationValue<?> o : mapped) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue<?> av = o;
                    String mappedAnnotationName = av.getAnnotationName();
                    Optional<Object> mappedMirror = this.getAnnotationMirror(mappedAnnotationName);
                    String repeatableName = mappedMirror.map(this::getRepeatableNameForType).orElse(null);
                    if (repeatableName != null) {
                        if (isDeclared) {
                            metadata.addDeclaredRepeatable(repeatableName, av);
                        } else {
                            metadata.addRepeatable(repeatableName, av);
                        }
                    } else if (isDeclared) {
                        metadata.addDeclaredAnnotation(mappedAnnotationName, av.getValues());
                    } else {
                        metadata.addAnnotation(mappedAnnotationName, av.getValues());
                    }
                    mappedMirror.ifPresent(annMirror -> {
                        Map<Object, ?> defaultValues = this.readAnnotationDefaultValues(mappedAnnotationName, annMirror);
                        this.processAnnotationDefaults(originatingElement, metadata, mappedAnnotationName, defaultValues);
                        ArrayList<String> parents = new ArrayList<String>();
                        this.processAnnotationStereotype(parents, annMirror, mappedAnnotationName, metadata, isDeclared);
                    });
                }
            }
        }
        return annotationValues;
    }

    protected abstract VisitorContext createVisitorContext();

    private void processAnnotationDefaults(T originatingElement, A annotationMirror, DefaultAnnotationMetadata metadata, String annotationName) {
        Map<T, ?> elementDefaultValues = this.readAnnotationDefaultValues(annotationMirror);
        this.processAnnotationDefaults(originatingElement, metadata, annotationName, elementDefaultValues);
    }

    private void processAnnotationDefaults(T originatingElement, DefaultAnnotationMetadata metadata, String annotationName, Map<? extends T, ?> elementDefaultValues) {
        if (elementDefaultValues != null) {
            LinkedHashMap<CharSequence, Object> defaultValues = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<T, ?> entry : elementDefaultValues.entrySet()) {
                T member = entry.getKey();
                String memberName = this.getAnnotationMemberName(member);
                if (defaultValues.containsKey(memberName)) continue;
                Object annotationValue = entry.getValue();
                this.readAnnotationRawValues(originatingElement, annotationName, member, memberName, annotationValue, defaultValues);
            }
            metadata.addDefaultAnnotationValues(annotationName, defaultValues);
            HashMap<String, Object> annotationDefaults = new HashMap<String, Object>(defaultValues.size());
            for (Map.Entry entry : defaultValues.entrySet()) {
                annotationDefaults.put(((CharSequence)entry.getKey()).toString(), entry.getValue());
            }
            DefaultAnnotationMetadata.registerAnnotationDefaults(annotationName, annotationDefaults);
        } else {
            metadata.addDefaultAnnotationValues(annotationName, Collections.emptyMap());
        }
    }

    private AnnotationMetadata lookupExisting(String declaringType, T element) {
        return MUTATED_ANNOTATION_METADATA.get(new MetadataKey<T>(declaringType, element));
    }

    private void processAnnotationAlias(T originatingElement, String annotationName, T member, DefaultAnnotationMetadata metadata, boolean isDeclared, List<String> parentAnnotations, Map<CharSequence, Object> annotationValues, Object annotationValue, OptionalValues<?> aliasForValues) {
        Optional aliasAnnotation = aliasForValues.get((CharSequence)"annotation");
        Optional aliasAnnotationName = aliasForValues.get((CharSequence)"annotationName");
        Optional aliasMember = aliasForValues.get((CharSequence)"member");
        if (aliasAnnotation.isPresent() || aliasAnnotationName.isPresent()) {
            if (aliasMember.isPresent()) {
                String aliasedAnnotationName = aliasAnnotation.isPresent() ? aliasAnnotation.get().toString() : aliasAnnotationName.get().toString();
                String aliasedMemberName = aliasMember.get().toString();
                Object v = this.readAnnotationValue(originatingElement, member, aliasedMemberName, annotationValue);
                if (v != null) {
                    Optional<Object> annotationMirror = this.getAnnotationMirror(aliasedAnnotationName);
                    if (annotationMirror.isPresent()) {
                        Map<T, ?> defaultValues = this.readAnnotationDefaultValues(aliasedAnnotationName, annotationMirror.get());
                        this.processAnnotationDefaults(originatingElement, metadata, aliasedAnnotationName, defaultValues);
                    }
                    if (isDeclared) {
                        metadata.addDeclaredStereotype(parentAnnotations, aliasedAnnotationName, Collections.singletonMap(aliasedMemberName, v));
                    } else {
                        metadata.addStereotype(parentAnnotations, aliasedAnnotationName, Collections.singletonMap(aliasedMemberName, v));
                    }
                    annotationMirror.ifPresent(annMirror -> this.processAnnotationStereotype(parentAnnotations, annMirror, aliasedAnnotationName, metadata, isDeclared));
                }
            }
        } else if (aliasMember.isPresent()) {
            String aliasedNamed = aliasMember.get().toString();
            Object v = this.readAnnotationValue(originatingElement, member, aliasedNamed, annotationValue);
            if (v != null) {
                annotationValues.put(aliasedNamed, v);
            }
            this.readAnnotationRawValues(originatingElement, annotationName, member, aliasedNamed, annotationValue, annotationValues);
        }
    }

    private AnnotationMetadata buildInternal(T parent, T element, DefaultAnnotationMetadata annotationMetadata, boolean inheritTypeAnnotations, boolean declaredOnly) {
        List<T> hierarchy = this.buildHierarchy(element, inheritTypeAnnotations, declaredOnly);
        if (parent != null) {
            List<T> parentHierarchy = this.buildHierarchy(parent, inheritTypeAnnotations, declaredOnly);
            hierarchy.addAll(0, parentHierarchy);
        }
        Collections.reverse(hierarchy);
        for (Object currentElement : hierarchy) {
            List<A> annotationHierarchy;
            if (currentElement == null || (annotationHierarchy = this.getAnnotationsForType(currentElement)).isEmpty()) continue;
            boolean isDeclared = currentElement == element;
            for (A annotationMirror : annotationHierarchy) {
                VisitorContext visitorContext;
                AnnotationValue av;
                String annotationName = this.getAnnotationTypeName(annotationMirror);
                if (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName)) continue;
                Map<CharSequence, Object> annotationValues = this.populateAnnotationData(currentElement, annotationMirror, annotationMetadata, isDeclared);
                String repeatableName = this.getRepeatableName(annotationMirror);
                String packageName = NameUtils.getPackageName((String)annotationName);
                List<AnnotationRemapper> annotationRemappers = ANNOTATION_REMAPPERS.get(packageName);
                boolean notRemapped = CollectionUtils.isEmpty(annotationRemappers);
                if (repeatableName != null) {
                    if (notRemapped) {
                        av = new AnnotationValue(annotationName, annotationValues);
                        if (isDeclared) {
                            annotationMetadata.addDeclaredRepeatable(repeatableName, av);
                            continue;
                        }
                        annotationMetadata.addRepeatable(repeatableName, av);
                        continue;
                    }
                    AnnotationValue repeatableAnn = new AnnotationValue(repeatableName);
                    visitorContext = this.createVisitorContext();
                    AnnotationValue av2 = new AnnotationValue(annotationName, annotationValues);
                    for (AnnotationRemapper annotationRemapper : annotationRemappers) {
                        List<AnnotationValue<?>> remappedRepeatable = annotationRemapper.remap(repeatableAnn, visitorContext);
                        List<AnnotationValue<?>> remappedValue = annotationRemapper.remap(av2, visitorContext);
                        if (!CollectionUtils.isNotEmpty(remappedRepeatable) || !CollectionUtils.isNotEmpty(remappedRepeatable)) continue;
                        for (AnnotationValue<?> repeatable : remappedRepeatable) {
                            for (AnnotationValue<?> rmv : remappedValue) {
                                if (isDeclared) {
                                    annotationMetadata.addDeclaredRepeatable(repeatable.getAnnotationName(), rmv);
                                    continue;
                                }
                                annotationMetadata.addRepeatable(repeatable.getAnnotationName(), rmv);
                            }
                        }
                    }
                    continue;
                }
                if (notRemapped) {
                    if (isDeclared) {
                        annotationMetadata.addDeclaredAnnotation(annotationName, annotationValues);
                        continue;
                    }
                    annotationMetadata.addAnnotation(annotationName, annotationValues);
                    continue;
                }
                av = new AnnotationValue(annotationName, annotationValues);
                visitorContext = this.createVisitorContext();
                for (AnnotationRemapper annotationRemapper : annotationRemappers) {
                    List<AnnotationValue<?>> remapped = annotationRemapper.remap(av, visitorContext);
                    if (!CollectionUtils.isNotEmpty(remapped)) continue;
                    for (AnnotationValue<?> annotationValue : remapped) {
                        if (isDeclared) {
                            annotationMetadata.addDeclaredAnnotation(annotationValue.getAnnotationName(), annotationValue.getValues());
                            continue;
                        }
                        annotationMetadata.addAnnotation(annotationValue.getAnnotationName(), annotationValue.getValues());
                    }
                }
            }
            for (A annotationMirror : annotationHierarchy) {
                String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
                String packageName = NameUtils.getPackageName((String)annotationTypeName);
                if (AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName)) continue;
                this.processAnnotationStereotype(annotationMirror, annotationMetadata, isDeclared);
            }
        }
        if (!annotationMetadata.hasDeclaredStereotype(Scope.class) && annotationMetadata.hasDeclaredStereotype(DefaultScope.class)) {
            Optional value = annotationMetadata.stringValue(DefaultScope.class);
            value.ifPresent(name -> annotationMetadata.addDeclaredAnnotation((String)name, Collections.emptyMap()));
        }
        return annotationMetadata;
    }

    private void buildStereotypeHierarchy(List<String> parents, T element, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        List<A> annotationMirrors = this.getAnnotationsForType(element);
        if (!annotationMirrors.isEmpty()) {
            ArrayList<A> topLevel = new ArrayList<A>();
            for (Object annotationMirror : annotationMirrors) {
                String annotationName;
                if (this.getTypeForAnnotation(annotationMirror) == element || AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName = this.getAnnotationTypeName(annotationMirror))) continue;
                topLevel.add(annotationMirror);
                Map<CharSequence, Object> data = this.populateAnnotationData(element, annotationMirror, metadata, isDeclared);
                String repeatableName = this.getRepeatableName(annotationMirror);
                if (repeatableName != null) {
                    AnnotationValue av = new AnnotationValue(annotationName, data);
                    if (isDeclared) {
                        metadata.addDeclaredRepeatableStereotype(parents, repeatableName, av);
                        continue;
                    }
                    metadata.addRepeatableStereotype(parents, repeatableName, av);
                    continue;
                }
                if (isDeclared) {
                    metadata.addDeclaredStereotype(parents, annotationName, data);
                    continue;
                }
                metadata.addStereotype(parents, annotationName, data);
            }
            for (Object annotationMirror : topLevel) {
                this.processAnnotationStereotype(parents, annotationMirror, metadata, isDeclared);
            }
        }
    }

    private void processAnnotationStereotype(A annotationMirror, DefaultAnnotationMetadata annotationMetadata, boolean isDeclared) {
        T annotationType = this.getTypeForAnnotation(annotationMirror);
        String parentAnnotationName = this.getAnnotationTypeName(annotationMirror);
        if (!parentAnnotationName.endsWith(".Nullable")) {
            this.processAnnotationStereotypes(annotationMetadata, isDeclared, annotationType, parentAnnotationName);
        }
    }

    private void processAnnotationStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, T annotationType, String annotationName) {
        ArrayList<String> parentAnnotations = new ArrayList<String>();
        parentAnnotations.add(annotationName);
        this.buildStereotypeHierarchy(parentAnnotations, annotationType, annotationMetadata, isDeclared);
    }

    private void processAnnotationStereotype(List<String> parents, A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        T typeForAnnotation = this.getTypeForAnnotation(annotationMirror);
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        this.processAnnotationStereotype(parents, typeForAnnotation, annotationTypeName, metadata, isDeclared);
    }

    private void processAnnotationStereotype(List<String> parents, T annotationType, String annotationTypeName, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        ArrayList<String> stereoTypeParents = new ArrayList<String>(parents);
        stereoTypeParents.add(annotationTypeName);
        this.buildStereotypeHierarchy(stereoTypeParents, annotationType, metadata, isDeclared);
    }

    @Internal
    public static void addMutatedMetadata(String declaringType, Object element, AnnotationMetadata metadata) {
        if (element != null && metadata != null) {
            MUTATED_ANNOTATION_METADATA.put(new MetadataKey<Object>(declaringType, element), metadata);
        }
    }

    @Internal
    public static boolean isMetadataMutated(String declaringType, Object element) {
        if (element != null) {
            return MUTATED_ANNOTATION_METADATA.containsKey(new MetadataKey<Object>(declaringType, element));
        }
        return false;
    }

    @Internal
    public static void clearMutated() {
        MUTATED_ANNOTATION_METADATA.clear();
    }

    @Internal
    public static boolean isAnnotationMapped(@Nullable String annotationName) {
        return annotationName != null && ANNOTATION_MAPPERS.containsKey(annotationName);
    }

    public <A2 extends Annotation> AnnotationMetadata annotate(AnnotationMetadata annotationMetadata, AnnotationValue<A2> annotationValue) {
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            Optional<Object> annotationMirror = this.getAnnotationMirror(annotationValue.getAnnotationName());
            DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)annotationMetadata;
            defaultMetadata.addDeclaredAnnotation(annotationValue.getAnnotationName(), annotationValue.getValues());
            annotationMirror.ifPresent(annotationType -> this.processAnnotationStereotypes(defaultMetadata, true, annotationType, annotationValue.getAnnotationName()));
        } else if (annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
            Optional<Object> annotationMirror = this.getAnnotationMirror(annotationValue.getAnnotationName());
            Map values = annotationValue.getValues();
            Map<String, Map<CharSequence, Object>> declared = Collections.singletonMap(annotationValue.getAnnotationName(), values);
            DefaultAnnotationMetadata newMetadata = new DefaultAnnotationMetadata(declared, null, null, null, null);
            annotationMirror.ifPresent(annotationType -> this.processAnnotationStereotypes(newMetadata, true, annotationType, annotationValue.getAnnotationName()));
            return newMetadata;
        }
        return annotationMetadata;
    }

    static {
        SoftServiceLoader serviceLoader = SoftServiceLoader.load(AnnotationMapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (ServiceDefinition definition : serviceLoader) {
            if (!definition.isPresent()) continue;
            AnnotationMapper mapper = (AnnotationMapper)definition.load();
            try {
                String name = null;
                if (mapper instanceof TypedAnnotationMapper) {
                    name = ((TypedAnnotationMapper)mapper).annotationType().getName();
                } else if (mapper instanceof NamedAnnotationMapper) {
                    name = ((NamedAnnotationMapper)mapper).getName();
                }
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_MAPPERS.computeIfAbsent(name, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable name) {}
        }
        SoftServiceLoader remapperLoader = SoftServiceLoader.load(AnnotationRemapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (ServiceDefinition definition : remapperLoader) {
            if (!definition.isPresent()) continue;
            AnnotationRemapper mapper = (AnnotationRemapper)definition.load();
            try {
                String name = mapper.getPackageName();
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_REMAPPERS.computeIfAbsent(name, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable throwable) {}
        }
    }

    private static class MetadataKey<T> {
        final String declaringName;
        final T element;

        MetadataKey(String declaringName, T element) {
            this.declaringName = declaringName;
            this.element = element;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataKey that = (MetadataKey)o;
            return this.declaringName.equals(that.declaringName) && this.element.equals(that.element);
        }

        public int hashCode() {
            return Objects.hash(this.declaringName, this.element);
        }
    }
}

