/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import javax.swing.SwingWorker;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.TaskManager;

public abstract class Task
implements Runnable,
ProgressObserver {
    private long value;
    private String status;
    private long maximum;
    private String label;
    private volatile Thread thread;
    private volatile SwingWorker.StateValue state = SwingWorker.StateValue.PENDING;
    private volatile boolean cancellable = true;

    protected Task() {
    }

    @Override
    public final void run() {
        this.state = SwingWorker.StateValue.STARTED;
        TaskManager.instance.fireRunning(this);
        try {
            this.thread = Thread.currentThread();
            this._run();
            this.thread = null;
        }
        catch (Throwable throwable) {
            Log.log(9, this, throwable);
        }
        this.state = SwingWorker.StateValue.DONE;
        TaskManager.instance.fireDone(this);
    }

    public abstract void _run();

    @Override
    public final void setValue(long l) {
        this.value = l;
        TaskManager.instance.fireValueUpdated(this);
    }

    @Override
    public final void setMaximum(long l) {
        this.maximum = l;
        TaskManager.instance.fireMaximumUpdated(this);
    }

    @Override
    public void setStatus(String string) {
        this.status = string;
        TaskManager.instance.fireStatusUpdated(this);
    }

    public long getValue() {
        return this.value;
    }

    public String getStatus() {
        return this.status;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public SwingWorker.StateValue getState() {
        return this.state;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public void setCancellable(boolean bl) {
        this.cancellable = bl;
    }

    public void cancel() {
        if (this.cancellable && this.thread != null) {
            this.thread.interrupt();
        }
    }

    public String toString() {
        return "Task[" + this.state + "," + this.status + "," + this.value + "/" + this.maximum + "]";
    }
}

