/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.TerrainCursor;
import net.sf.freecol.client.gui.TileViewer;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.ai.AIUnit;

public final class MapViewer {
    private static final Logger logger = Logger.getLogger(MapViewer.class.getName());
    private final FreeColClient freeColClient;
    private final SwingGUI gui;
    private Dimension size;
    private ImageLibrary lib;
    private final TileViewer tv;
    private TerrainCursor cursor;
    private Tile selectedTile;
    private Tile focus = null;
    private Unit activeUnit;
    private int viewMode = 0;
    private PathNode currentPath;
    private PathNode gotoPath = null;
    private boolean gotoStarted = false;
    private int tileHeight;
    private int tileWidth;
    private int halfHeight;
    private int halfWidth;
    private int topSpace;
    private int topRows;
    private int bottomRows;
    private int leftSpace;
    private int rightSpace;
    private int bottomRow = -1;
    private int topRow;
    private int bottomRowY;
    private int topRowY;
    private int leftColumn;
    private int rightColumn;
    private int leftColumnX;
    private boolean alignedTop = false;
    private boolean alignedBottom = false;
    private boolean alignedLeft = false;
    private boolean alignedRight = false;
    private static final float MAP_SCALE_MIN = 0.25f;
    private static final float MAP_SCALE_MAX = 2.0f;
    private static final float MAP_SCALE_STEP = 0.25f;
    private static final int UNIT_OFFSET = 20;
    private static final int OTHER_UNITS_OFFSET_X = -5;
    private static final int OTHER_UNITS_OFFSET_Y = 1;
    private static final int OTHER_UNITS_WIDTH = 3;
    private static final int MAX_OTHER_UNITS = 10;
    private final java.util.Map<Unit, Integer> unitsOutForAnimation;
    private final java.util.Map<Unit, JLabel> unitsOutForAnimationLabels;
    private final EnumMap<Direction, Point2D.Float> borderPoints = new EnumMap(Direction.class);
    private final EnumMap<Direction, Point2D.Float> controlPoints = new EnumMap(Direction.class);
    private Stroke borderStroke = new BasicStroke(4.0f);
    private Stroke gridStroke = new BasicStroke(1.0f);

    MapViewer(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.gui = (SwingGUI)freeColClient.getGUI();
        this.size = null;
        this.tv = new TileViewer(freeColClient);
        this.setImageLibraryAndUpdateData(new ImageLibrary());
        this.cursor = null;
        this.unitsOutForAnimation = new HashMap<Unit, Integer>();
        this.unitsOutForAnimationLabels = new HashMap<Unit, JLabel>();
    }

    ImageLibrary getImageLibrary() {
        return this.lib;
    }

    int getViewMode() {
        return this.viewMode;
    }

    void toggleViewMode() {
        this.changeViewMode(1 - this.viewMode);
    }

    void changeViewMode(int newViewMode) {
        if (newViewMode != this.viewMode) {
            logger.fine("Changed to " + (newViewMode == 0 ? "Move Units" : "View Terrain") + " mode");
            this.viewMode = newViewMode;
            if (this.viewMode == 0) {
                this.restartBlinking();
            } else {
                this.stopBlinking();
            }
            if (this.activeUnit != null) {
                Tile tile = this.activeUnit.getTile();
                if (this.isTileVisible(tile)) {
                    this.gui.refreshTile(tile);
                }
                if (this.selectedTile != tile && this.isTileVisible(this.selectedTile)) {
                    this.gui.refreshTile(this.selectedTile);
                }
            } else if (this.isTileVisible(this.selectedTile)) {
                this.gui.refreshTile(this.selectedTile);
            }
            this.gui.updateMapControls();
        }
    }

    void centerActiveUnit() {
        if (this.activeUnit != null && this.activeUnit.getTile() != null) {
            this.gui.setFocus(this.activeUnit.getTile());
        }
    }

    Tile convertToMapTile(int x, int y) {
        Game game = this.freeColClient.getGame();
        if (game == null || game.getMap() == null) {
            return null;
        }
        int leftOffset = this.focus.getX() < this.getLeftColumns() ? ((this.focus.getY() & 1) == 0 ? this.tileWidth * this.focus.getX() + this.halfWidth : this.tileWidth * (this.focus.getX() + 1)) : (this.focus.getX() >= game.getMap().getWidth() - this.getRightColumns() ? ((this.focus.getY() & 1) == 0 ? this.size.width - (game.getMap().getWidth() - this.focus.getX()) * this.tileWidth : this.size.width - (game.getMap().getWidth() - this.focus.getX() - 1) * this.tileWidth - this.halfWidth) : ((this.focus.getY() & 1) == 0 ? this.size.width / 2 : this.size.width / 2 + this.halfWidth));
        int topOffset = this.focus.getY() < this.topRows ? (this.focus.getY() + 1) * this.halfHeight : (this.focus.getY() >= game.getMap().getHeight() - this.bottomRows ? this.size.height - (game.getMap().getHeight() - this.focus.getY()) * this.halfHeight : this.size.height / 2);
        int dcol = (x - leftOffset + (x > leftOffset ? this.halfWidth : -this.halfWidth)) / this.tileWidth;
        int drow = (y - topOffset + (y > topOffset ? this.halfHeight : -this.halfHeight)) / this.tileHeight;
        int px = leftOffset + dcol * this.tileWidth;
        int py = topOffset + drow * this.tileHeight;
        int newCol = this.focus.getX() + dcol;
        int newRow = this.focus.getY() + drow * 2;
        logger.finest("Old focus was " + this.focus.getX() + ", " + this.focus.getY() + ". Preliminary focus is " + newCol + ", " + newRow + ".");
        Direction direction = null;
        if (x > px) {
            if (y > py) {
                if (y - py > this.halfHeight - (x - px) / 2) {
                    direction = Direction.SE;
                }
            } else if (y - py < (x - px) / 2 - this.halfHeight) {
                direction = Direction.NE;
            }
        } else if (y > py) {
            if (y - py > (x - px) / 2 + this.halfHeight) {
                direction = Direction.SW;
            }
        } else if (y - py < (px - x) / 2 - this.halfHeight) {
            direction = Direction.NW;
        }
        int col = newCol;
        int row = newRow;
        if (direction != null) {
            Map.Position step = direction.step(newCol, newRow);
            col = step.x;
            row = step.y;
        }
        logger.finest("Direction is " + direction + ", new focus is " + col + ", " + row);
        return this.freeColClient.getGame().getMap().getTile(col, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeWithUnitOutForAnimation(Unit unit, Tile sourceTile, OutForAnimationCallback r) {
        JLabel unitLabel = this.enterUnitOutForAnimation(unit, sourceTile);
        try {
            r.executeWithUnitOutForAnimation(unitLabel);
        }
        finally {
            this.releaseUnitOutForAnimation(unit);
        }
    }

    private JLabel enterUnitOutForAnimation(Unit unit, Tile sourceTile) {
        Integer i = this.unitsOutForAnimation.get(unit);
        if (i == null) {
            JLabel unitLabel = this.createUnitLabel(unit);
            i = 1;
            unitLabel.setLocation(this.calculateUnitLabelPositionInTile(unitLabel.getWidth(), unitLabel.getHeight(), this.calculateTilePosition(sourceTile)));
            this.unitsOutForAnimationLabels.put(unit, unitLabel);
            this.gui.getCanvas().add((Component)unitLabel, JLayeredPane.DEFAULT_LAYER);
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.unitsOutForAnimation.put(unit, i);
        return this.unitsOutForAnimationLabels.get(unit);
    }

    private void releaseUnitOutForAnimation(Unit unit) {
        Integer i = this.unitsOutForAnimation.get(unit);
        if (i == null) {
            throw new IllegalStateException("Tried to release unit that was not out for animation");
        }
        if (i == 1) {
            this.unitsOutForAnimation.remove(unit);
            this.gui.getCanvas().removeFromCanvas(this.unitsOutForAnimationLabels.remove(unit));
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i - 1);
            this.unitsOutForAnimation.put(unit, i);
        }
    }

    private boolean isOutForAnimation(Unit unit) {
        return this.unitsOutForAnimation.containsKey(unit);
    }

    private JLabel createUnitLabel(Unit unit) {
        BufferedImage unitImg = this.lib.getUnitImage(unit);
        int width = this.halfWidth + unitImg.getWidth() / 2;
        int height = unitImg.getHeight();
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        int unitX = (width - unitImg.getWidth()) / 2;
        g.drawImage((Image)unitImg, unitX, 0, null);
        Player player = this.freeColClient.getMyPlayer();
        String text = Messages.message(unit.getOccupationLabel(player, false));
        g.drawImage((Image)this.lib.getOccupationIndicatorChip(g, unit, text), 0, 0, null);
        JLabel label = new JLabel(new ImageIcon(img));
        label.setSize(width, height);
        g.dispose();
        return label;
    }

    Rectangle calculateTileBounds(Tile tile) {
        Rectangle result = new Rectangle(0, 0, this.size.width, this.size.height);
        if (this.isTileVisible(tile)) {
            result.x = (tile.getX() - this.leftColumn) * this.tileWidth + this.leftColumnX;
            result.y = (tile.getY() - this.topRow) * this.halfHeight + this.topRowY - this.tileHeight;
            if ((tile.getY() & 1) != 0) {
                result.x += this.halfWidth;
            }
            result.width = this.tileWidth;
            result.height = this.tileHeight * 2;
        }
        return result;
    }

    Point calculateTilePosition(Tile t) {
        this.repositionMapIfNeeded();
        if (!this.isTileVisible(t)) {
            return null;
        }
        int x = (t.getX() - this.leftColumn) * this.tileWidth + this.leftColumnX;
        int y = (t.getY() - this.topRow) * this.halfHeight + this.topRowY;
        if ((t.getY() & 1) != 0) {
            x += this.halfWidth;
        }
        return new Point(x, y);
    }

    int getTileWidth() {
        return this.tileWidth;
    }

    Point calculateUnitLabelPositionInTile(int labelWidth, int labelHeight, Point tileP) {
        if (tileP != null) {
            int labelX = tileP.x + this.tileWidth / 2 - labelWidth / 2;
            int labelY = tileP.y + this.tileHeight / 2 - labelHeight / 2 - (int)(20.0f * this.lib.getScaleFactor());
            return new Point(labelX, labelY);
        }
        return null;
    }

    boolean onScreen(Tile tileToCheck) {
        if (tileToCheck == null) {
            return false;
        }
        this.repositionMapIfNeeded();
        return !(tileToCheck.getY() - 2 <= this.topRow && !this.alignedTop || tileToCheck.getY() + 4 >= this.bottomRow && !this.alignedBottom || tileToCheck.getX() - 1 <= this.leftColumn && !this.alignedLeft || tileToCheck.getX() + 2 >= this.rightColumn && !this.alignedRight);
    }

    void startCursorBlinking() {
        this.cursor = new TerrainCursor();
        this.cursor.addActionListener(ae -> {
            Tile tile;
            Unit unit = this.activeUnit;
            if (unit != null && this.isTileVisible(tile = unit.getTile())) {
                this.gui.refreshTile(tile);
            }
        });
        this.cursor.startBlinking();
    }

    void stopBlinking() {
        this.cursor.stopBlinking();
    }

    void restartBlinking() {
        this.cursor.startBlinking();
    }

    Tile getFocus() {
        return this.focus;
    }

    void setFocus(Tile focus) {
        this.focus = focus;
        this.forceReposition();
    }

    int setOffsetFocus(Tile tile) {
        int where;
        if (tile == null) {
            return 0;
        }
        Map map = this.freeColClient.getGame().getMap();
        int tx = tile.getX();
        int ty = tile.getY();
        int width = this.rightColumn - this.leftColumn;
        int moveX = -1;
        this.gui.setFocus(tile);
        this.positionMap(tile);
        if (this.leftColumn <= 0) {
            if (tx <= width / 4) {
                where = -1;
            } else if (tx >= 3 * width / 4) {
                where = 1;
            } else {
                moveX = tx + width / 4;
                where = -1;
            }
        } else if (this.rightColumn >= width - 1) {
            if (tx >= this.rightColumn - width / 4) {
                where = 1;
            } else if (tx <= this.rightColumn - 3 * width / 4) {
                where = -1;
            } else {
                moveX = tx - width / 4;
                where = 1;
            }
        } else {
            moveX = tx - width / 4;
            where = 1;
        }
        if (moveX >= 0) {
            Tile other = map.getTile(moveX, ty);
            this.gui.setFocus(other);
            this.positionMap(other);
        }
        return where;
    }

    void forceReposition() {
        this.bottomRow = -1;
    }

    private void repositionMapIfNeeded() {
        if (this.bottomRow < 0 && this.focus != null) {
            this.positionMap(this.focus);
        }
    }

    private void positionMap(Tile pos) {
        Game game = this.freeColClient.getGame();
        int x = pos.getX();
        int y = pos.getY();
        int leftColumns = this.getLeftColumns();
        int rightColumns = this.getRightColumns();
        this.alignedTop = false;
        this.alignedBottom = false;
        if (y < this.topRows) {
            this.alignedTop = true;
            this.bottomRow = this.size.height / this.halfHeight - 1;
            if (this.size.height % this.halfHeight != 0) {
                ++this.bottomRow;
            }
            this.topRow = 0;
            this.bottomRowY = this.bottomRow * this.halfHeight;
            this.topRowY = 0;
        } else if (y >= game.getMap().getHeight() - this.bottomRows) {
            this.alignedBottom = true;
            this.bottomRow = game.getMap().getHeight() - 1;
            this.topRow = this.size.height / this.halfHeight;
            if (this.size.height % this.halfHeight > 0) {
                ++this.topRow;
            }
            this.topRow = game.getMap().getHeight() - this.topRow;
            this.bottomRowY = this.size.height - this.tileHeight;
            this.topRowY = this.bottomRowY - (this.bottomRow - this.topRow) * this.halfHeight;
        } else {
            this.bottomRow = y + this.bottomRows - 1;
            this.topRow = y - this.topRows;
            this.bottomRowY = this.topSpace + this.halfHeight * this.bottomRows;
            this.topRowY = this.topSpace - this.topRows * this.halfHeight;
        }
        this.alignedLeft = false;
        this.alignedRight = false;
        if (x < leftColumns) {
            this.leftColumn = 0;
            this.rightColumn = this.size.width / this.tileWidth - 1;
            if (this.size.width % this.tileWidth > 0) {
                ++this.rightColumn;
            }
            this.leftColumnX = 0;
            this.alignedLeft = true;
        } else if (x >= game.getMap().getWidth() - rightColumns) {
            this.rightColumn = game.getMap().getWidth() - 1;
            this.leftColumn = this.size.width / this.tileWidth;
            if (this.size.width % this.tileWidth > 0) {
                ++this.leftColumn;
            }
            this.leftColumnX = this.size.width - this.tileWidth - this.halfWidth - this.leftColumn * this.tileWidth;
            this.leftColumn = this.rightColumn - this.leftColumn;
            this.alignedRight = true;
        } else {
            this.leftColumn = x - leftColumns;
            this.rightColumn = x + rightColumns;
            this.leftColumnX = (this.size.width - this.tileWidth) / 2 - leftColumns * this.tileWidth;
        }
    }

    boolean scrollMap(Direction direction) {
        Tile t = this.focus;
        if (t == null) {
            return false;
        }
        int fx = t.getX();
        int fy = t.getY();
        if ((t = t.getNeighbourOrNull(direction)) == null) {
            return false;
        }
        int tx = t.getX();
        int ty = t.getY();
        int y = this.isMapNearTop(ty) && this.isMapNearTop(fy) ? (ty <= fy ? fy : this.topRows) : (this.isMapNearBottom(ty) && this.isMapNearBottom(fy) ? (ty >= fy ? fy : this.freeColClient.getGame().getMap().getWidth() - this.bottomRows) : ty);
        int x = this.isMapNearLeft(tx, ty) && this.isMapNearLeft(fx, fy) ? (tx <= fx ? fx : this.getLeftColumns(ty)) : (this.isMapNearRight(tx, ty) && this.isMapNearRight(fx, fy) ? (tx >= fx ? fx : this.freeColClient.getGame().getMap().getWidth() - this.getRightColumns(ty)) : tx);
        if (x == fx && y == fy) {
            return false;
        }
        this.gui.setFocus(this.freeColClient.getGame().getMap().getTile(x, y));
        return true;
    }

    private boolean isMapNearBottom(int y) {
        return y >= this.freeColClient.getGame().getMap().getHeight() - this.bottomRows;
    }

    private boolean isMapNearLeft(int x, int y) {
        return x < this.getLeftColumns(y);
    }

    private boolean isMapNearRight(int x, int y) {
        return x >= this.freeColClient.getGame().getMap().getWidth() - this.getRightColumns(y);
    }

    private int getLeftColumns() {
        return this.getLeftColumns(this.focus.getY());
    }

    private int getLeftColumns(int y) {
        int leftColumns = this.leftSpace / this.tileWidth + 1;
        if ((y & 1) == 0) {
            if (this.leftSpace % this.tileWidth > 32) {
                ++leftColumns;
            }
        } else if (this.leftSpace % this.tileWidth == 0) {
            --leftColumns;
        }
        return leftColumns;
    }

    private int getRightColumns() {
        return this.getRightColumns(this.focus.getY());
    }

    private int getRightColumns(int y) {
        int rightColumns = this.rightSpace / this.tileWidth + 1;
        if ((y & 1) == 0) {
            if (this.rightSpace % this.tileWidth == 0) {
                --rightColumns;
            }
        } else if (this.rightSpace % this.tileWidth > 32) {
            ++rightColumns;
        }
        return rightColumns;
    }

    private boolean isMapNearTop(int y) {
        return y < this.topRows;
    }

    private boolean isTileVisible(Tile tile) {
        if (tile == null) {
            return false;
        }
        return tile.getY() >= this.topRow && tile.getY() <= this.bottomRow && tile.getX() >= this.leftColumn && tile.getX() <= this.rightColumn;
    }

    Tile getSelectedTile() {
        return this.selectedTile;
    }

    boolean setSelectedTile(Tile newTile) {
        Tile oldTile = this.selectedTile;
        boolean ret = false;
        this.selectedTile = newTile;
        if (this.viewMode == 0 && (this.activeUnit == null || this.activeUnit.getTile() != newTile)) {
            Unit unitInFront = this.findUnitInFront(newTile);
            if (unitInFront != null) {
                ret = this.gui.setActiveUnit(unitInFront);
                this.updateCurrentPathForActiveUnit();
            } else {
                this.gui.setFocus(newTile);
                ret = true;
            }
        }
        if (!this.onScreen(newTile) || this.freeColClient.getClientOptions().getBoolean("model.option.alwaysCenter")) {
            this.gui.setFocus(newTile);
            ret = true;
        } else {
            if (oldTile != null) {
                this.gui.refreshTile(oldTile);
            }
            if (newTile != null) {
                this.gui.refreshTile(newTile);
            }
        }
        return ret;
    }

    private Unit findUnitInFront(Tile unitTile) {
        Unit result;
        if (unitTile == null || unitTile.isEmpty()) {
            result = null;
        } else if (this.activeUnit != null && this.activeUnit.getTile() == unitTile) {
            result = this.activeUnit;
        } else if (unitTile.hasSettlement()) {
            result = null;
        } else if (this.activeUnit != null && this.activeUnit.isOffensiveUnit()) {
            result = unitTile.getDefendingUnit(this.activeUnit);
        } else {
            List<Unit> units = unitTile.getUnitList();
            result = units.remove(0);
            int best = result.getMovesLeft();
            boolean active = result.getState() == Unit.UnitState.ACTIVE;
            for (Unit u : units) {
                boolean carrier = false;
                if (active) {
                    if (u.getState() == Unit.UnitState.ACTIVE) {
                        if (best < u.getMovesLeft()) {
                            best = u.getMovesLeft();
                            result = u;
                        }
                    } else {
                        carrier = !u.isEmpty();
                    }
                } else if (u.getState() == Unit.UnitState.ACTIVE) {
                    active = true;
                    best = u.getMovesLeft();
                    result = u;
                } else {
                    if (best < u.getMovesLeft()) {
                        best = u.getMovesLeft();
                        result = u;
                    }
                    boolean bl = carrier = !u.isEmpty();
                }
                if (!carrier) continue;
                for (Unit c : u.getUnitList()) {
                    if (active) {
                        if (best >= c.getMovesLeft()) continue;
                        best = c.getMovesLeft();
                        result = c;
                        continue;
                    }
                    if (c.getState() != Unit.UnitState.ACTIVE) continue;
                    active = true;
                    best = c.getMovesLeft();
                    result = c;
                }
            }
        }
        return result;
    }

    Unit getActiveUnit() {
        return this.activeUnit;
    }

    boolean setActiveUnit(Unit activeUnit) {
        Tile tile = activeUnit == null ? null : activeUnit.getTile();
        this.activeUnit = activeUnit;
        if (this.viewMode == 1 && activeUnit != null) {
            this.changeViewMode(0);
        }
        if (activeUnit == null || tile == null) {
            this.gui.getCanvas().stopGoto();
        } else {
            this.updateCurrentPathForActiveUnit();
            if (!this.gui.setSelectedTile(tile) || this.freeColClient.getClientOptions().getBoolean("model.option.jumpToActiveUnit")) {
                this.gui.setFocus(tile);
                return true;
            }
        }
        return false;
    }

    boolean isGotoStarted() {
        return this.gotoStarted;
    }

    void startGoto() {
        this.gotoStarted = true;
        this.setGotoPath(null);
    }

    void stopGoto() {
        this.setGotoPath(null);
        this.updateCurrentPathForActiveUnit();
        this.gotoStarted = false;
    }

    PathNode getGotoPath() {
        return this.gotoPath;
    }

    void setGotoPath(PathNode gotoPath) {
        this.gotoPath = gotoPath;
        this.forceReposition();
    }

    void updateCurrentPathForActiveUnit() {
        PathNode path;
        if (this.activeUnit == null || this.activeUnit.getDestination() == null || ((FreeColGameObject)((Object)this.activeUnit.getDestination())).isDisposed() || Map.isSameLocation(this.activeUnit.getLocation(), this.activeUnit.getDestination())) {
            path = null;
        } else {
            try {
                path = this.activeUnit.findPath(this.activeUnit.getDestination());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Path fail", e);
                path = null;
                this.activeUnit.setDestination(null);
            }
        }
        this.setCurrentPath(path);
    }

    void setCurrentPath(PathNode path) {
        this.currentPath = path;
    }

    void setSize(Dimension size) {
        this.size = size;
        this.updateMapDisplayVariables();
    }

    void resetMapScale() {
        this.setImageLibraryAndUpdateData(new ImageLibrary());
        this.updateMapDisplayVariables();
    }

    boolean isAtMaxMapScale() {
        return this.lib.getScaleFactor() == 2.0f;
    }

    boolean isAtMinMapScale() {
        return this.lib.getScaleFactor() == 0.25f;
    }

    void increaseMapScale() {
        float newScale = this.lib.getScaleFactor() + 0.25f;
        if (newScale >= 2.0f) {
            newScale = 2.0f;
        }
        this.setImageLibraryAndUpdateData(new ImageLibrary(newScale));
        this.updateMapDisplayVariables();
    }

    void decreaseMapScale() {
        float newScale = this.lib.getScaleFactor() - 0.25f;
        if (newScale <= 0.25f) {
            newScale = 0.25f;
        }
        this.setImageLibraryAndUpdateData(new ImageLibrary(newScale));
        this.updateMapDisplayVariables();
    }

    private void updateMapDisplayVariables() {
        this.topSpace = (this.size.height - this.tileHeight) / 2;
        this.topRows = this.topSpace % this.halfHeight != 0 ? this.topSpace / this.halfHeight + 2 : this.topSpace / this.halfHeight + 1;
        this.bottomRows = this.topRows;
        this.rightSpace = this.leftSpace = (this.size.width - this.tileWidth) / 2;
    }

    private void setImageLibraryAndUpdateData(ImageLibrary lib) {
        this.lib = lib;
        this.tv.setImageLibraryAndUpdateData(lib);
        Dimension tileSize = lib.tileSize;
        this.tileHeight = tileSize.height;
        this.tileWidth = tileSize.width;
        this.halfHeight = this.tileHeight / 2;
        this.halfWidth = this.tileWidth / 2;
        int dx = this.tileWidth / 16;
        int dy = this.tileHeight / 16;
        int ddx = dx + dx / 2;
        int ddy = dy + dy / 2;
        this.controlPoints.put(Direction.N, new Point2D.Float(this.halfWidth, dy));
        this.controlPoints.put(Direction.E, new Point2D.Float(this.tileWidth - dx, this.halfHeight));
        this.controlPoints.put(Direction.S, new Point2D.Float(this.halfWidth, this.tileHeight - dy));
        this.controlPoints.put(Direction.W, new Point2D.Float(dx, this.halfHeight));
        this.controlPoints.put(Direction.SE, new Point2D.Float(this.halfWidth, this.tileHeight));
        this.controlPoints.put(Direction.NE, new Point2D.Float(this.tileWidth, this.halfHeight));
        this.controlPoints.put(Direction.SW, new Point2D.Float(0.0f, this.halfHeight));
        this.controlPoints.put(Direction.NW, new Point2D.Float(this.halfWidth, 0.0f));
        this.borderPoints.put(Direction.NW, new Point2D.Float(dx + ddx, this.halfHeight - ddy));
        this.borderPoints.put(Direction.N, new Point2D.Float(this.halfWidth - ddx, dy + ddy));
        this.borderPoints.put(Direction.NE, new Point2D.Float(this.halfWidth + ddx, dy + ddy));
        this.borderPoints.put(Direction.E, new Point2D.Float(this.tileWidth - dx - ddx, this.halfHeight - ddy));
        this.borderPoints.put(Direction.SE, new Point2D.Float(this.tileWidth - dx - ddx, this.halfHeight + ddy));
        this.borderPoints.put(Direction.S, new Point2D.Float(this.halfWidth + ddx, this.tileHeight - dy - ddy));
        this.borderPoints.put(Direction.SW, new Point2D.Float(this.halfWidth - ddx, this.tileHeight - dy - ddy));
        this.borderPoints.put(Direction.W, new Point2D.Float(dx + ddx, this.halfHeight + ddy));
        this.borderStroke = new BasicStroke(dy);
        this.gridStroke = new BasicStroke(lib.getScaleFactor());
    }

    void displayMap(Graphics2D g) {
        ClientOptions options = this.freeColClient.getClientOptions();
        Game game = this.freeColClient.getGame();
        Map map = game.getMap();
        AffineTransform originTransform = g.getTransform();
        Rectangle clipBounds = g.getClipBounds();
        this.repositionMapIfNeeded();
        int firstRow = (clipBounds.y - this.topRowY) / this.halfHeight - 1;
        int clipTopY = this.topRowY + firstRow * this.halfHeight;
        firstRow = this.topRow + firstRow;
        int firstColumn = (clipBounds.x - this.leftColumnX) / this.tileWidth - 1;
        int clipLeftX = this.leftColumnX + firstColumn * this.tileWidth;
        firstColumn = this.leftColumn + firstColumn;
        int lastRow = (clipBounds.y + clipBounds.height - this.topRowY) / this.halfHeight;
        lastRow = this.topRow + lastRow;
        int lastColumn = (clipBounds.x + clipBounds.width - this.leftColumnX) / this.tileWidth;
        lastColumn = this.leftColumn + lastColumn;
        g.setColor(Color.black);
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        g.translate(clipLeftX, clipTopY);
        AffineTransform baseTransform = g.getTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x0 = firstColumn;
        int y0 = firstRow;
        map.forSubMap(x0, y0, lastColumn - firstColumn + 1, lastRow - firstRow + 1, tile -> {
            int x = tile.getX();
            int y = tile.getY();
            int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
            int yt = (y - y0) * this.halfHeight;
            g.translate(xt, yt);
            this.tv.displayTileWithBeachAndBorder(g, (Tile)tile);
            this.tv.displayUnknownTileBorder(g, (Tile)tile);
            g.translate(-xt, -yt);
        });
        if (options.getBoolean("model.option.displayGrid")) {
            GeneralPath gridPath = new GeneralPath();
            gridPath.moveTo(0.0f, 0.0f);
            int nextX = this.halfWidth;
            int nextY = -this.halfHeight;
            for (int i = 0; i <= (lastColumn - firstColumn) * 2 + 1; ++i) {
                gridPath.lineTo(nextX, nextY);
                nextX += this.halfWidth;
                nextY = nextY == 0 ? -this.halfHeight : 0;
            }
            g.setStroke(this.gridStroke);
            g.setColor(Color.BLACK);
            for (int row = firstRow; row <= lastRow; ++row) {
                g.translate(0, this.halfHeight);
                AffineTransform rowTransform = g.getTransform();
                if ((row & 1) == 1) {
                    g.translate(this.halfWidth, 0);
                }
                g.draw(gridPath);
                g.setTransform(rowTransform);
            }
            g.setTransform(baseTransform);
        }
        if (options.getInteger("model.option.displayTileText") == 3) {
            map.forSubMap(x0, y0 - 1, lastColumn - firstColumn + 1, lastRow - firstRow + 1 + 1, tile -> {
                int x = tile.getX();
                int y = tile.getY();
                int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
                int yt = (y - y0) * this.halfHeight;
                g.translate(xt, yt);
                this.displayTerritorialBorders(g, (Tile)tile, BorderType.REGION, true);
                g.translate(-xt, -yt);
            });
        }
        if (options.getBoolean("model.option.displayBorders")) {
            map.forSubMap(x0, y0 - 1, lastColumn - firstColumn + 1, lastRow - firstRow + 1 + 1, tile -> {
                int x = tile.getX();
                int y = tile.getY();
                int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
                int yt = (y - y0) * this.halfHeight;
                g.translate(xt, yt);
                this.displayTerritorialBorders(g, (Tile)tile, BorderType.COUNTRY, true);
                g.translate(-xt, -yt);
            });
        }
        Set<String> overlayCache = ImageLibrary.createOverlayCache();
        int colonyLabels = options.getInteger("model.option.displayColonyLabels");
        boolean withNumbers = colonyLabels == 1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        map.forSubMap(x0, y0, lastColumn - firstColumn + 1, lastRow - firstRow + 1, tile -> {
            if (!tile.isExplored()) {
                return;
            }
            int x = tile.getX();
            int y = tile.getY();
            int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
            int yt = (y - y0) * this.halfHeight;
            g.translate(xt, yt);
            BufferedImage overlayImage = this.lib.getOverlayImage((Tile)tile, overlayCache);
            this.tv.displayTileItems(g, (Tile)tile, overlayImage);
            this.tv.displaySettlementWithChipsOrPopulationNumber(g, (Tile)tile, withNumbers);
            this.tv.displayFogOfWar(g, (Tile)tile);
            this.tv.displayOptionalTileText(g, (Tile)tile);
            g.translate(-xt, -yt);
        });
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (options.getInteger("model.option.displayTileText") == 3) {
            map.forSubMap(x0, y0 - 1, lastColumn - firstColumn + 1, lastRow - firstRow + 1 + 1, tile -> {
                int x = tile.getX();
                int y = tile.getY();
                int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
                int yt = (y - y0) * this.halfHeight;
                g.translate(xt, yt);
                this.displayTerritorialBorders(g, (Tile)tile, BorderType.REGION, false);
                g.translate(-xt, -yt);
            });
        }
        if (options.getBoolean("model.option.displayBorders")) {
            map.forSubMap(x0, y0 - 1, lastColumn - firstColumn + 1, lastRow - firstRow + 1 + 1, tile -> {
                int x = tile.getX();
                int y = tile.getY();
                int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
                int yt = (y - y0) * this.halfHeight;
                g.translate(xt, yt);
                this.displayTerritorialBorders(g, (Tile)tile, BorderType.COUNTRY, false);
                g.translate(-xt, -yt);
            });
        }
        Tile cursorTile = null;
        switch (this.viewMode) {
            case 0: {
                if (this.activeUnit == null || !this.cursor.isActive() && this.activeUnit.getMovesLeft() > 0) break;
                cursorTile = this.activeUnit.getTile();
                break;
            }
            case 1: {
                if (this.selectedTile == null) break;
                cursorTile = this.selectedTile;
            }
        }
        if (cursorTile != null) {
            int x = cursorTile.getX();
            int y = cursorTile.getY();
            if (x >= x0 && y >= y0 && x <= lastColumn && y <= lastRow) {
                int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
                int yt = (y - y0) * this.halfHeight;
                g.translate(xt, yt);
                this.displayCursor(g);
                g.translate(-xt, -yt);
            }
        }
        g.setColor(Color.BLACK);
        if (!game.isInRevengeMode()) {
            map.forSubMap(x0, y0, lastColumn - firstColumn + 1, lastRow - firstRow + 1, tile -> {
                Unit unit = this.findUnitInFront((Tile)tile);
                if (unit == null || this.isOutForAnimation(unit)) {
                    return;
                }
                int x = tile.getX();
                int y = tile.getY();
                int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
                int yt = (y - y0) * this.halfHeight;
                g.translate(xt, yt);
                this.displayUnit(g, unit);
                g.translate(-xt, -yt);
            });
        } else {
            map.forSubMap(x0 - 2, y0 - 4, lastColumn - firstColumn + 1 + 4, lastRow - firstRow + 1 + 8, tile -> {
                Unit unit = this.findUnitInFront((Tile)tile);
                if (unit == null) {
                    return;
                }
                int x = tile.getX();
                int y = tile.getY();
                int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
                int yt = (y - y0) * this.halfHeight;
                g.translate(xt, yt);
                if (unit.isUndead()) {
                    BufferedImage darkness = this.lib.getMiscImage("image.halo.dark");
                    this.tv.displayCenteredImage(g, darkness);
                }
                if (!this.isOutForAnimation(unit)) {
                    this.displayUnit(g, unit);
                }
                g.translate(-xt, -yt);
            });
        }
        if (colonyLabels != 0) {
            Player player = this.freeColClient.getMyPlayer();
            FontLibrary fontLibrary = new FontLibrary(this.lib.getScaleFactor());
            Font font = fontLibrary.createScaledFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.SMALLER, 1);
            Font italicFont = fontLibrary.createScaledFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.SMALLER, 3);
            Font productionFont = fontLibrary.createScaledFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, 1);
            map.forSubMap(x0, y0 - 1, lastColumn - firstColumn + 1, lastRow - firstRow + 1 + 1, tile -> {
                Settlement settlement = tile.getSettlement();
                if (settlement == null) {
                    return;
                }
                int x = tile.getX();
                int y = tile.getY();
                int xt = (x - x0) * this.tileWidth + (y & 1) * this.halfWidth;
                int yt = (y - y0) * this.halfHeight;
                g.translate(xt, yt);
                this.displaySettlementLabels(g, settlement, player, colonyLabels, font, italicFont, productionFont);
                g.translate(-xt, -yt);
            });
        }
        g.setTransform(originTransform);
        if (this.currentPath != null) {
            this.displayPath(g, this.currentPath);
        }
        if (this.gotoPath != null) {
            this.displayPath(g, this.gotoPath);
        }
    }

    private void displaySettlementLabels(Graphics2D g, Settlement settlement, Player player, int colonyLabels, Font font, Font italicFont, Font productionFont) {
        if (settlement.isDisposed()) {
            logger.warning("Settlement display race detected: " + settlement.getName());
            return;
        }
        String name = Messages.message(settlement.getLocationLabelFor(player));
        if (name == null) {
            return;
        }
        Color backgroundColor = settlement.getOwner().getNationColor();
        if (backgroundColor == null) {
            backgroundColor = Color.WHITE;
        }
        int yOffset = this.tileHeight;
        switch (colonyLabels) {
            case 1: {
                BufferedImage img = this.lib.getStringImage(g, name, backgroundColor, font);
                g.drawImage((Image)img, (this.tileWidth - img.getWidth()) / 2 + 1, yOffset, null);
                break;
            }
            default: {
                Colony colony;
                BuildableType buildable;
                backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 128);
                TextSpecification[] specs = new TextSpecification[1];
                if (settlement instanceof Colony && settlement.getOwner() == player && (buildable = (colony = (Colony)settlement).getCurrentlyBuilding()) != null) {
                    specs = new TextSpecification[2];
                    String t = Messages.getName(buildable) + " " + Turn.getTurnsText(colony.getTurnsToComplete(buildable));
                    specs[1] = new TextSpecification(t, productionFont);
                }
                specs[0] = new TextSpecification(name, font);
                BufferedImage nameImage = MapViewer.createLabel(g, specs, backgroundColor);
                if (nameImage == null) break;
                int spacing = 3;
                BufferedImage leftImage = null;
                BufferedImage rightImage = null;
                if (settlement instanceof Colony) {
                    int bonusProduction;
                    Colony colony2 = (Colony)settlement;
                    String string = Integer.toString(colony2.getDisplayUnitCount());
                    leftImage = MapViewer.createLabel(g, string, colony2.getPreferredSizeChange() > 0 ? italicFont : font, backgroundColor);
                    if (player.owns(settlement) && (bonusProduction = colony2.getProductionBonus()) != 0) {
                        String bonus = bonusProduction > 0 ? "+" + bonusProduction : Integer.toString(bonusProduction);
                        rightImage = MapViewer.createLabel(g, bonus, font, backgroundColor);
                    }
                } else if (settlement instanceof IndianSettlement) {
                    Unit missionary;
                    IndianSettlement is = (IndianSettlement)settlement;
                    if (is.getType().isCapital()) {
                        leftImage = MapViewer.createCapitalLabel(nameImage.getHeight(), 5, backgroundColor);
                    }
                    if ((missionary = is.getMissionary()) != null) {
                        boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                        backgroundColor = missionary.getOwner().getNationColor();
                        backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 128);
                        rightImage = MapViewer.createReligiousMissionLabel(nameImage.getHeight(), 5, backgroundColor, expert);
                    }
                }
                int width = (int)((float)nameImage.getWidth() * this.lib.getScaleFactor() + (leftImage != null ? (float)leftImage.getWidth() * this.lib.getScaleFactor() + (float)spacing : 0.0f) + (rightImage != null ? (float)rightImage.getWidth() * this.lib.getScaleFactor() + (float)spacing : 0.0f));
                int labelOffset = (this.tileWidth - width) / 2;
                yOffset = (int)((float)yOffset - (float)nameImage.getHeight() * this.lib.getScaleFactor() / 2.0f);
                if (leftImage != null) {
                    g.drawImage((Image)leftImage, labelOffset, yOffset, null);
                    labelOffset = (int)((float)labelOffset + ((float)leftImage.getWidth() * this.lib.getScaleFactor() + (float)spacing));
                }
                g.drawImage((Image)nameImage, labelOffset, yOffset, null);
                if (rightImage == null) break;
                labelOffset = (int)((float)labelOffset + ((float)nameImage.getWidth() * this.lib.getScaleFactor() + (float)spacing));
                g.drawImage((Image)rightImage, labelOffset, yOffset, null);
                break;
            }
        }
    }

    private static BufferedImage createCapitalLabel(int extent, int padding, Color backgroundColor) {
        double deg2rad = Math.PI / 180;
        double angle = -90.0 * deg2rad;
        double offset = (double)extent * 0.5;
        double size1 = (double)(extent - padding - padding) * 0.5;
        GeneralPath path = new GeneralPath();
        path.moveTo(Math.cos(angle) * size1 + offset, Math.sin(angle) * size1 + offset);
        for (int i = 0; i < 4; ++i) {
            path.lineTo(Math.cos(angle += 144.0 * deg2rad) * size1 + offset, Math.sin(angle) * size1 + offset);
        }
        path.closePath();
        BufferedImage bi = new BufferedImage(extent, extent, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(backgroundColor);
        g.fill(new RoundRectangle2D.Float(0.0f, 0.0f, extent, extent, padding, padding));
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(2.4f, 1, 1));
        g.draw(path);
        g.setColor(Color.WHITE);
        g.fill(path);
        g.dispose();
        return bi;
    }

    private static BufferedImage createLabel(Graphics2D g, String text, Font font, Color backgroundColor) {
        TextSpecification[] specs = new TextSpecification[]{new TextSpecification(text, font)};
        return MapViewer.createLabel(g, specs, backgroundColor);
    }

    private static BufferedImage createLabel(Graphics2D g, TextSpecification[] textSpecs, Color backgroundColor) {
        int i;
        int hPadding = 15;
        int vPadding = 10;
        int linePadding = 5;
        int width = 0;
        int height = vPadding;
        TextLayout[] labels = new TextLayout[textSpecs.length];
        for (i = 0; i < textSpecs.length; ++i) {
            TextLayout label;
            TextSpecification spec = textSpecs[i];
            labels[i] = label = new TextLayout(spec.text, spec.font, g.getFontRenderContext());
            Rectangle textRectangle = label.getPixelBounds(null, 0.0f, 0.0f);
            width = Math.max(width, textRectangle.width + hPadding);
            if (i > 0) {
                height += linePadding;
            }
            height += (int)(label.getAscent() + label.getDescent());
        }
        int radius = Math.min(hPadding, vPadding);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setColor(backgroundColor);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, radius, radius));
        g2.setColor(ImageLibrary.getForegroundColor(backgroundColor));
        float y = vPadding / 2;
        for (i = 0; i < labels.length; ++i) {
            Rectangle textRectangle = labels[i].getPixelBounds(null, 0.0f, 0.0f);
            float x = (width - textRectangle.width) / 2;
            labels[i].draw(g2, x, y += labels[i].getAscent());
            y += labels[i].getDescent() + (float)linePadding;
        }
        g2.dispose();
        return bi;
    }

    private static BufferedImage createReligiousMissionLabel(int extent, int padding, Color backgroundColor, boolean expertMissionary) {
        double offset = (double)extent * 0.5;
        double size1 = extent - padding - padding;
        double bar = size1 / 3.0;
        double inset = 0.0;
        double kludge = 0.0;
        GeneralPath circle = new GeneralPath();
        GeneralPath cross = new GeneralPath();
        if (expertMissionary) {
            circle.append(new Ellipse2D.Double(padding - 1, padding - 1, size1 + 1.0, size1 + 1.0), false);
            inset = 4.0;
            bar = (size1 - inset - inset) / 3.0;
            kludge = 1.0;
        }
        cross.moveTo(offset -= 1.0, (double)padding + inset - kludge);
        cross.lineTo(offset, (double)(extent - padding) - inset);
        cross.moveTo(offset - bar, (double)padding + bar + inset);
        cross.lineTo(offset + bar + 1.0, (double)padding + bar + inset);
        BufferedImage bi = new BufferedImage(extent, extent, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(backgroundColor);
        g.fill(new RoundRectangle2D.Float(0.0f, 0.0f, extent, extent, padding, padding));
        g.setColor(ImageLibrary.getForegroundColor(backgroundColor));
        if (expertMissionary) {
            g.setStroke(new BasicStroke(2.0f, 1, 1));
            g.draw(circle);
            g.setStroke(new BasicStroke(1.6f, 1, 1));
        } else {
            g.setStroke(new BasicStroke(2.4f, 1, 1));
        }
        g.draw(cross);
        g.dispose();
        return bi;
    }

    private void displayPath(Graphics2D g, PathNode path) {
        Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, this.lib.getScaleFactor());
        boolean debug = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.PATHS);
        PathNode p = path;
        while (p != null) {
            Point point;
            Tile tile = p.getTile();
            if (tile != null && (point = this.calculateTilePosition(tile)) != null) {
                BufferedImage image = p.isOnCarrier() ? ImageLibrary.getPathImage(ImageLibrary.PathType.NAVAL) : (this.activeUnit != null ? ImageLibrary.getPathImage(this.activeUnit) : null);
                BufferedImage turns = p.getTurns() <= 0 ? null : this.lib.getStringImage(g, Integer.toString(p.getTurns()), Color.WHITE, font);
                g.setColor(turns == null ? Color.GREEN : Color.RED);
                if (debug) {
                    if (this.activeUnit != null) {
                        image = ImageLibrary.getPathNextTurnImage(this.activeUnit);
                    }
                    turns = this.lib.getStringImage(g, Integer.toString(p.getTurns()) + "/" + Integer.toString(p.getMovesLeft()), Color.WHITE, font);
                }
                g.translate(point.x, point.y);
                if (image == null) {
                    g.fillOval(this.halfWidth, this.halfHeight, 10, 10);
                    g.setColor(Color.BLACK);
                    g.drawOval(this.halfWidth, this.halfHeight, 10, 10);
                } else {
                    this.tv.displayCenteredImage(g, image);
                    if (turns != null) {
                        this.tv.displayCenteredImage(g, turns);
                    }
                }
                g.translate(-point.x, -point.y);
            }
            p = p.next;
        }
    }

    private void displayUnit(Graphics2D g, Unit unit) {
        AIUnit au;
        Player player = this.freeColClient.getMyPlayer();
        boolean fade = unit.getState() == Unit.UnitState.SENTRY || unit.hasTile() && player != null && !player.canSee(unit.getTile());
        BufferedImage image = this.lib.getUnitImage(unit, fade);
        Point p = this.calculateUnitImagePositionInTile(image);
        g.drawImage((Image)image, p.x, p.y, null);
        String text = Messages.message(unit.getOccupationLabel(player, false));
        g.drawImage((Image)this.lib.getOccupationIndicatorChip(g, unit, text), (int)(25.0f * this.lib.getScaleFactor()), 0, null);
        int unitsOnTile = 0;
        if (unit.hasTile()) {
            unitsOnTile = unit.getTile().getTotalUnitCount();
        }
        if (unitsOnTile > 1) {
            g.setColor(Color.WHITE);
            int unitLinesY = 1;
            int x1 = (int)(20.0f * this.lib.getScaleFactor());
            int x2 = (int)(23.0f * this.lib.getScaleFactor());
            for (int i = 0; i < unitsOnTile && i < 10; ++i) {
                g.drawLine(x1, unitLinesY, x2, unitLinesY);
                unitLinesY += 2;
            }
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && player != null && !player.owns(unit) && unit.getOwner().isAI() && this.freeColClient.getFreeColServer() != null && (au = this.freeColClient.getFreeColServer().getAIMain().getAIUnit(unit)) != null) {
            if (FreeColDebugger.debugShowMission()) {
                g.setColor(Color.WHITE);
                g.drawString(!au.hasMission() ? "No mission" : StringUtils.lastPart(au.getMission().getClass().toString(), "."), 0, 0);
            }
            if (FreeColDebugger.debugShowMissionInfo() && au.hasMission()) {
                g.setColor(Color.WHITE);
                g.drawString(au.getMission().toString(), 0, 25);
            }
        }
    }

    private Point calculateUnitImagePositionInTile(BufferedImage unitImage) {
        int unitX = (this.tileWidth - unitImage.getWidth()) / 2;
        int unitY = (this.tileHeight - unitImage.getHeight()) / 2 - (int)(20.0f * this.lib.getScaleFactor());
        return new Point(unitX, unitY);
    }

    private void displayCursor(Graphics2D g) {
        BufferedImage cursorImage = this.lib.getMiscImage("image.tile.unitSelect");
        g.drawImage((Image)cursorImage, 0, 0, null);
    }

    private void displayTerritorialBorders(Graphics2D g, Tile tile, BorderType type, boolean opaque) {
        Player owner = tile.getOwner();
        Region region = tile.getRegion();
        if (type == BorderType.COUNTRY && owner != null || type == BorderType.REGION && region != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(this.borderStroke);
            Color oldColor = g.getColor();
            Color c = null;
            if (type == BorderType.COUNTRY) {
                c = owner.getNationColor();
            }
            if (c == null) {
                c = Color.WHITE;
            }
            Color newColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), opaque ? 255 : 100);
            g.setColor(newColor);
            GeneralPath path = new GeneralPath(0);
            path.moveTo(this.borderPoints.get((Object)Direction.longSides.get((int)0)).x, this.borderPoints.get((Object)Direction.longSides.get((int)0)).y);
            for (Direction d : Direction.longSides) {
                Tile otherTile = tile.getNeighbourOrNull(d);
                Direction next = d.getNextDirection();
                Direction next2 = next.getNextDirection();
                if (otherTile == null || type == BorderType.COUNTRY && !owner.owns(otherTile) || type == BorderType.REGION && otherTile.getRegion() != region) {
                    Tile tile1 = tile.getNeighbourOrNull(next);
                    Tile tile2 = tile.getNeighbourOrNull(next2);
                    if (tile2 == null || type == BorderType.COUNTRY && !owner.owns(tile2) || type == BorderType.REGION && tile2.getRegion() != region) {
                        path.lineTo(this.borderPoints.get((Object)next).x, this.borderPoints.get((Object)next).y);
                        path.quadTo(this.controlPoints.get((Object)next).x, this.controlPoints.get((Object)next).y, this.borderPoints.get((Object)next2).x, this.borderPoints.get((Object)next2).y);
                        continue;
                    }
                    int dx = 0;
                    int dy = 0;
                    switch (d) {
                        case NW: {
                            dx = this.halfWidth;
                            dy = -this.halfHeight;
                            break;
                        }
                        case NE: {
                            dx = this.halfWidth;
                            dy = this.halfHeight;
                            break;
                        }
                        case SE: {
                            dx = -this.halfWidth;
                            dy = this.halfHeight;
                            break;
                        }
                        case SW: {
                            dx = -this.halfWidth;
                            dy = -this.halfHeight;
                            break;
                        }
                    }
                    if (tile1 != null && (type == BorderType.COUNTRY && owner.owns(tile1) || type == BorderType.REGION && tile1.getRegion() == region)) {
                        path.lineTo(this.borderPoints.get((Object)next).x, this.borderPoints.get((Object)next).y);
                        Direction previous = d.getPreviousDirection();
                        Direction previous2 = previous.getPreviousDirection();
                        int ddx = 0;
                        int ddy = 0;
                        switch (d) {
                            case NW: {
                                ddy = -this.tileHeight;
                                break;
                            }
                            case NE: {
                                ddx = this.tileWidth;
                                break;
                            }
                            case SE: {
                                ddy = this.tileHeight;
                                break;
                            }
                            case SW: {
                                ddx = -this.tileWidth;
                                break;
                            }
                        }
                        path.quadTo(this.controlPoints.get((Object)previous).x + (float)dx, this.controlPoints.get((Object)previous).y + (float)dy, this.borderPoints.get((Object)previous2).x + (float)ddx, this.borderPoints.get((Object)previous2).y + (float)ddy);
                        continue;
                    }
                    path.lineTo(this.borderPoints.get((Object)d).x + (float)dx, this.borderPoints.get((Object)d).y + (float)dy);
                    continue;
                }
                path.moveTo(this.borderPoints.get((Object)next2).x, this.borderPoints.get((Object)next2).y);
            }
            g.draw(path);
            g.setColor(oldColor);
            g.setStroke(oldStroke);
        }
    }

    private static class TextSpecification {
        public final String text;
        public final Font font;

        public TextSpecification(String newText, Font newFont) {
            this.text = newText;
            this.font = newFont;
        }
    }

    private static enum BorderType {
        COUNTRY,
        REGION;

    }
}

