<?php

declare(strict_types=1);

/**
 * @copyright Copyright (c) 2018 Robin Appelman <robin@icewind.nl>
 *
 * @author Julien Lutran <julien.lutran@corp.ovh.com>
 * @author Robin Appelman <robin@icewind.nl>
 * @author Robin McCorkell <robin@mccorkell.me.uk>
 * @author Roeland Jago Douma <roeland@famdouma.nl>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace OCA\Files_External\Lib\Auth\OpenStack;

use OCA\Files_External\Lib\Auth\AuthMechanism;
use OCA\Files_External\Lib\DefinitionParameter;
use OCP\IL10N;

/**
 * OpenStack Keystone authentication
 */
class OpenStackV3 extends AuthMechanism {
	public function __construct(IL10N $l) {
		$this
			->setIdentifier('openstack::openstackv3')
			->setScheme(self::SCHEME_OPENSTACK)
			->setText($l->t('OpenStack v3'))
			->addParameters([
				new DefinitionParameter('user', $l->t('Username')),
				new DefinitionParameter('domain', $l->t('Domain')),
				(new DefinitionParameter('password', $l->t('Password')))
					->setType(DefinitionParameter::VALUE_PASSWORD),
				new DefinitionParameter('tenant', $l->t('Tenant name')),
				new DefinitionParameter('url', $l->t('Identity endpoint URL'))
			])
		;
	}
}
