/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Taskbar;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import mediathek.config.Daten;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.mac.OsxIndicatorThread;
import mediathek.mac.OsxPowerManager;
import mediathek.mac.Spotlight;
import mediathek.mac.tabs.TabDownloadsMac;
import mediathek.mac.tabs.TabFilmeMac;
import mediathek.mac.touchbar.TouchBarUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.notification.GenericNotificationCenter;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.MacNotificationCenter;
import mediathek.tool.notification.NullNotificationCenter;
import mediathek.tool.threads.IndicatorThread;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MediathekGuiMac
extends MediathekGui {
    private static final String SHUTDOWN_HELPER_APP_BINARY_PATH = "/Contents/MacOS/MediathekView Shutdown Helper";
    private final OsxPowerManager powerManager = new OsxPowerManager();
    protected static Logger logger = LogManager.getLogger(MediathekGuiMac.class);

    public MediathekGuiMac() {
        this.setupDockIcon();
    }

    @Override
    public void initializeSystemTray() {
    }

    @Override
    protected void installTouchBarSupport() {
        logger.trace("install touch bar support");
        if (TouchBarUtils.isTouchBarSupported()) {
            this.tabFilme.touchBar.show(this);
            JTabbedPane tabbedPane = this.getTabbedPane();
            tabbedPane.addChangeListener(e -> {
                Component comp = tabbedPane.getSelectedComponent();
                if (comp.equals(this.tabFilme)) {
                    this.tabDownloads.touchBar.hide(this);
                    this.tabFilme.touchBar.show(this);
                } else if (comp.equals(this.tabDownloads)) {
                    this.tabFilme.touchBar.hide(this);
                    this.tabDownloads.touchBar.show(this);
                }
            });
        }
    }

    @Override
    protected void setupNotificationCenter() {
        try {
            INotificationCenter notificationCenter = this.daten.notificationCenter();
            if (notificationCenter != null) {
                notificationCenter.close();
            }
        }
        catch (IOException e) {
            logger.error("error closing notification center", (Throwable)e);
        }
        boolean showNotifications = this.config.getBoolean("application.notifications.show", true);
        this.config.setProperty("application.notifications.native_support", false);
        if (!showNotifications) {
            this.daten.setNotificationCenter(new NullNotificationCenter());
        } else if (this.config.getBoolean("application.notifications.show_native", false)) {
            this.daten.setNotificationCenter(new MacNotificationCenter());
        } else {
            this.daten.setNotificationCenter(new GenericNotificationCenter());
        }
    }

    @Override
    protected JPanel createTabFilme(@NotNull Daten daten) {
        return new TabFilmeMac(daten, this);
    }

    @Override
    protected JPanel createTabDownloads(@NotNull Daten daten) {
        return new TabDownloadsMac(daten, this);
    }

    @Override
    protected void shutdownComputer() {
        try {
            List<File> result = Spotlight.find("kMDItemCFBundleIdentifier == org.mediathekview.MediathekView-Shutdown-Helper");
            if (result.isEmpty()) {
                logger.error("could not locate mediathekview shutdown helper app");
            } else {
                File appLocation = result.get(0);
                logger.debug("Shutdown Helper location: {}", (Object)appLocation.toString());
                logger.info("Executing shutdown helper");
                ProcessBuilder builder = new ProcessBuilder(appLocation.toString() + SHUTDOWN_HELPER_APP_BINARY_PATH);
                builder.command().add("-shutdown");
                builder.start();
                logger.debug("shutdown helper app was launched");
            }
        }
        catch (Exception e) {
            logger.error("unexpected error occured", (Throwable)e);
        }
    }

    @Override
    protected void installMenuTabSwitchListener() {
    }

    @Override
    @Handler
    protected void handleInstallTabSwitchListenerEvent(InstallTabSwitchListenerEvent msg) {
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.setupUserInterfaceForOsx();
    }

    @Override
    protected IndicatorThread createProgressIndicatorThread() {
        return new OsxIndicatorThread();
    }

    @Override
    protected void handleDownloadStart(DownloadStartEvent msg) {
        super.handleDownloadStart(msg);
        this.powerManager.disablePowerManagement();
        this.setDownloadsBadge(this.numDownloadsStarted.get());
    }

    @Override
    protected void handleDownloadFinishedEvent(DownloadFinishedEvent msg) {
        super.handleDownloadFinishedEvent(msg);
        int numDownloads = this.numDownloadsStarted.get();
        if (numDownloads == 0) {
            this.powerManager.enablePowerManagement();
        }
        this.setDownloadsBadge(numDownloads);
    }

    private void setDownloadsBadge(int numDownloads) {
        Taskbar taskbar;
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_BADGE_NUMBER)) {
            if (numDownloads > 0) {
                taskbar.setIconBadge(Integer.toString(numDownloads));
            } else {
                taskbar.setIconBadge("");
            }
        }
    }

    private void setupUserInterfaceForOsx() {
        Desktop desktop = Desktop.getDesktop();
        desktop.disableSuddenTermination();
        desktop.setQuitHandler((e, response) -> {
            if (!this.beenden(false, false)) {
                response.cancelQuit();
            } else {
                response.performQuit();
            }
        });
        desktop.setAboutHandler(e -> this.showAboutDialog());
        desktop.setPreferencesHandler(e -> this.showSettingsDialog());
    }

    private void setupDockIcon() {
        try {
            Taskbar taskbar;
            if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
                URL url = this.getClass().getResource("/mediathek/res/MediathekView.png");
                BufferedImage appImage = ImageIO.read(url);
                Taskbar.getTaskbar().setIconImage(appImage);
            }
        }
        catch (IOException ex) {
            logger.error("OS X Application image could not be loaded", (Throwable)ex);
        }
    }

    static class WorkaroundStage
    extends Stage {
        public WorkaroundStage() {
            this.initStyle(StageStyle.UTILITY);
            StackPane root = new StackPane();
            root.setStyle("-fx-background-color: TRANSPARENT");
            Scene scene = new Scene(root, 1.0, 1.0);
            scene.setFill(Color.TRANSPARENT);
            this.setScene(scene);
            this.setWidth(1.0);
            this.setHeight(1.0);
            this.setOpacity(0.0);
        }
    }
}

