/**
 * SECTION:dummy-full-persona
 * @short_description: A persona subclass representing a single ‘full’ contact.
 * 
 * <para>This mocks up a ‘full’ persona which implements all the available property interfaces provided by libfolks. This is in contrast with <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>, which provides a base class implementing none of libfolks’ interfaces.</para><para>The full dummy persona can be used to simulate a persona from most libfolks backends, if writing a custom <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link> subclass is not an option.</para><para>There are two sides to this class’ interface: the normal methods required by the libfolks ‘details’ interfaces, such as <link linkend="folks-gender-details-change-gender"><function>folks_gender_details_change_gender()</function></link>, and the backend methods which should be called by test driver code to simulate changes in the backing store providing this persona, such as <link linkend="folks-dummy-full-persona-update-gender"><function>folks_dummy_full_persona_update_gender()</function></link>. For example, test driver code should call <link linkend="folks-dummy-full-persona-update-nickname"><function>folks_dummy_full_persona_update_nickname()</function></link> to simulate the user editing a contact’s nickname in an online address book which is being exposed to libfolks. The <code>update_</code>, <code>register_</code> and <code>unregister_</code> prefixes are commonly used for backend methods.</para><para>The API in FolksDummy is unstable and may change wildly. It is designed mostly for use by libfolks unit tests.</para>
 *
 * Since: 0.9.7
 */
/**
 * FOLKS_DUMMY_TYPE_FULL_PERSONA:
 * 
 * The type for <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link>.
 */
/**
 * folks_dummy_full_persona_update_gender:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @gender: (in): &nbsp;.  <para>persona&apos;s new gender </para>
 * 
 * Update persona&apos;s gender.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_calendar_event_id:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @calendar_event_id: (in) (allow-none): &nbsp;.  <para>persona&apos;s new birthday calendar event ID </para>
 * 
 * Update persona&apos;s birthday calendar event ID.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_birthday:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @birthday: (in) (allow-none): &nbsp;.  <para>persona&apos;s new birthday </para>
 * 
 * Update persona&apos;s birthday.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_roles:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @roles: (in): &nbsp;.  <para>persona&apos;s new roles </para>
 * 
 * Update persona&apos;s roles.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_groups:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @groups: (in): &nbsp;.  <para>persona&apos;s new groups </para>
 * 
 * Update persona&apos;s groups.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_web_service_addresses:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @web_service_addresses: (in): &nbsp;.  <para>persona&apos;s new web service addresses </para>
 * 
 * Update persona&apos;s web service addresses.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_email_addresses:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @email_addresses: (in): &nbsp;.  <para>persona&apos;s new e-mail addresses </para>
 * 
 * Update persona&apos;s e-mail addresses.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_notes:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @notes: (in): &nbsp;.  <para>persona&apos;s new notes </para>
 * 
 * Update persona&apos;s notes.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_full_name:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @full_name: (in): &nbsp;.  <para>persona&apos;s new full name </para>
 * 
 * Update persona&apos;s full name.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_nickname:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @nickname: (in): &nbsp;.  <para>persona&apos;s new nickname </para>
 * 
 * Update persona&apos;s nickname.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_structured_name:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @structured_name: (in) (allow-none): &nbsp;.  <para>persona&apos;s new structured name </para>
 * 
 * Update persona&apos;s structured name.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_avatar:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @avatar: (in) (allow-none): &nbsp;.  <para>persona&apos;s new avatar </para>
 * 
 * Update persona&apos;s avatar.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_urls:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @urls: (in): &nbsp;.  <para>persona&apos;s new URIs </para>
 * 
 * Update persona&apos;s URIs.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_im_addresses:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @im_addresses: (in): &nbsp;.  <para>persona&apos;s new IM addresses </para>
 * 
 * Update persona&apos;s IM addresses.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_phone_numbers:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @phone_numbers: (in): &nbsp;.  <para>persona&apos;s new phone numbers </para>
 * 
 * Update persona&apos;s phone numbers.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_postal_addresses:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @postal_addresses: (in): &nbsp;.  <para>persona&apos;s new postal addresses </para>
 * 
 * Update persona&apos;s postal addresses.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_local_ids:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @local_ids: (in): &nbsp;.  <para>persona&apos;s new local IDs </para>
 * 
 * Update persona&apos;s local IDs.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_is_favourite:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @is_favourite: (in): &nbsp;.  <para>persona&apos;s new status as a favourite </para>
 * 
 * Update persona&apos;s status as a favourite.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_update_anti_links:
 * @self: the <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> instance
 * @anti_links: (in): &nbsp;.  <para>persona&apos;s new anti-links </para>
 * 
 * Update persona&apos;s anti-links.
 * 
 * <para>This simulates a backing-store-side update of the persona&apos;s <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> property. It is intended to be used for testing code which consumes this property. If the property value changes, this results in a property change notification on the persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_full_persona_new:
 * @store: (in): &nbsp;.  <para>the store which will contain the persona </para>
 * @contact_id: (in): &nbsp;.  <para>a unique free-form string identifier for the persona </para>
 * @is_user: (in): &nbsp;.  <para><code>true</code> if the persona represents the user, <code>false</code> otherwise </para>
 * @linkable_properties: (in) (array length=linkable_properties_length1): &nbsp;.  <para>an array of names of the properties which should be used for linking this persona to others </para>
 * @linkable_properties_length1: length of the @linkable_properties array
 * 
 * Create a new ‘full’ persona.
 * 
 * <para>Create a new persona for the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> <code>store</code>, with the given construct-only properties.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyFullPersona:
 * 
 * A persona subclass representing a single ‘full’ contact.
 * 
 * <para>This mocks up a ‘full’ persona which implements all the available property interfaces provided by libfolks. This is in contrast with <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>, which provides a base class implementing none of libfolks’ interfaces.</para><para>The full dummy persona can be used to simulate a persona from most libfolks backends, if writing a custom <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link> subclass is not an option.</para><para>There are two sides to this class’ interface: the normal methods required by the libfolks ‘details’ interfaces, such as <link linkend="folks-gender-details-change-gender"><function>folks_gender_details_change_gender()</function></link>, and the backend methods which should be called by test driver code to simulate changes in the backing store providing this persona, such as <link linkend="folks-dummy-full-persona-update-gender"><function>folks_dummy_full_persona_update_gender()</function></link>. For example, test driver code should call <link linkend="folks-dummy-full-persona-update-nickname"><function>folks_dummy_full_persona_update_nickname()</function></link> to simulate the user editing a contact’s nickname in an online address book which is being exposed to libfolks. The <code>update_</code>, <code>register_</code> and <code>unregister_</code> prefixes are commonly used for backend methods.</para><para>The API in FolksDummy is unstable and may change wildly. It is designed mostly for use by libfolks unit tests.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyFullPersonaClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-DUMMY-TYPE-FULL-PERSONA:CAPS"><literal>FOLKS_DUMMY_TYPE_FULL_PERSONA</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
