/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.naming.Constants;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.http.FastHttpDateFormat;

public class DirContextURLConnection
extends URLConnection {
    private static final UDecoder URL_DECODER = new UDecoder();
    protected DirContext context;
    protected Resource resource;
    protected DirContext collection;
    protected Object object;
    protected Attributes attributes;
    protected long date;
    protected Permission permission;
    private String path = null;

    public DirContextURLConnection(DirContext dirContext, URL uRL) {
        super(uRL);
        if (dirContext == null) {
            throw new IllegalArgumentException("Directory context can't be null");
        }
        if (Constants.IS_SECURITY_ENABLED) {
            this.permission = new JndiPermission(uRL.toString());
        }
        this.context = dirContext;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            try {
                this.date = System.currentTimeMillis();
                this.path = URL_DECODER.convert(this.getURL().getFile(), false);
                if (this.context instanceof ProxyDirContext) {
                    ProxyDirContext proxyDirContext = (ProxyDirContext)this.context;
                    String string = proxyDirContext.getHostName();
                    String string2 = proxyDirContext.getContextPath();
                    if (string != null) {
                        if (!this.path.startsWith("/" + string + "/")) {
                            return;
                        }
                        this.path = this.path.substring(string.length() + 1);
                    }
                    if (string2 != null) {
                        if (!this.path.startsWith(string2 + "/")) {
                            return;
                        }
                        this.path = this.path.substring(string2.length());
                    }
                }
                this.object = this.context.lookup(this.path);
                this.attributes = this.context.getAttributes(this.path);
                if (this.object instanceof Resource) {
                    this.resource = (Resource)this.object;
                }
                if (this.object instanceof DirContext) {
                    this.collection = (DirContext)this.object;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.connected = true;
        }
    }

    @Override
    public int getContentLength() {
        return this.getHeaderFieldInt("getcontentlength", -1);
    }

    @Override
    public String getContentType() {
        return this.getHeaderField("getcontenttype");
    }

    @Override
    public long getDate() {
        return this.date;
    }

    @Override
    public long getLastModified() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.attributes == null) {
            return 0L;
        }
        Attribute attribute = this.attributes.get("getlastmodified");
        if (attribute != null) {
            try {
                Date date = (Date)attribute.get();
                return date.getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    protected String getHeaderValueAsString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return FastHttpDateFormat.formatDate((long)((Date)object).getTime(), null);
        }
        return object.toString();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        HashMap hashMap = new HashMap(this.attributes.size());
        NamingEnumeration<String> namingEnumeration = this.attributes.getIDs();
        try {
            while (namingEnumeration.hasMore()) {
                String string = namingEnumeration.next();
                Attribute attribute = this.attributes.get(string);
                if (attribute == null) continue;
                ArrayList<String> arrayList = new ArrayList<String>(attribute.size());
                NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMore()) {
                    Object obj = namingEnumeration2.next();
                    arrayList.add(this.getHeaderValueAsString(obj));
                }
                arrayList.trimToSize();
                hashMap.put(string, Collections.unmodifiableList(arrayList));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public String getHeaderField(String string) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.attributes == null) {
            return null;
        }
        NamingEnumeration<String> namingEnumeration = this.attributes.getIDs();
        try {
            while (namingEnumeration.hasMore()) {
                String string2 = namingEnumeration.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                Attribute attribute = this.attributes.get(string2);
                if (attribute == null) {
                    return null;
                }
                Object object = attribute.get(attribute.size() - 1);
                return this.getHeaderValueAsString(object);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource != null) {
            return this.getInputStream();
        }
        if (this.collection != null) {
            return this.collection;
        }
        if (this.object != null) {
            return this.object;
        }
        throw new FileNotFoundException(this.getURL() == null ? "null" : this.getURL().toString());
    }

    public Object getContent(Class[] classArray) throws IOException {
        Object object = this.getContent();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isInstance(object)) continue;
            return object;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource == null) {
            throw new FileNotFoundException(this.getURL() == null ? "null" : this.getURL().toString());
        }
        try {
            this.resource = (Resource)this.context.lookup(this.path);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return this.resource.streamContent();
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    public Enumeration<String> list() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource == null && this.collection == null) {
            throw new FileNotFoundException(this.getURL() == null ? "null" : this.getURL().toString());
        }
        Vector<String> vector = new Vector<String>();
        if (this.collection != null) {
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = this.collection.list("/");
                UEncoder uEncoder = new UEncoder(UEncoder.SafeCharsSet.WITH_SLASH);
                while (namingEnumeration.hasMoreElements()) {
                    NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                    String string = nameClassPair.getName();
                    vector.addElement(uEncoder.encodeURL(string, 0, string.length()).toString());
                }
            }
            catch (NamingException namingException) {
                throw new FileNotFoundException(this.getURL() == null ? "null" : this.getURL().toString());
            }
        }
        return vector.elements();
    }
}

