/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.scan.Jar;

public class FileUrlJar
implements Jar {
    private JarFile jarFile;
    private final boolean multiRelease;
    private Enumeration<JarEntry> entries;
    private Set<String> entryNamesSeen;
    private JarEntry entry = null;

    public FileUrlJar(URL uRL) throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        jarURLConnection.setUseCaches(false);
        this.jarFile = jarURLConnection.getJarFile();
        this.multiRelease = JreCompat.getInstance().jarFileIsMultiRelease(this.jarFile);
    }

    @Override
    @Deprecated
    public boolean entryExists(String string) {
        return false;
    }

    @Override
    public InputStream getInputStream(String string) throws IOException {
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        return this.jarFile.getInputStream(zipEntry);
    }

    @Override
    public void close() {
        if (this.jarFile != null) {
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void nextEntry() {
        block6: {
            if (this.entries == null) {
                this.entries = this.jarFile.entries();
                if (this.multiRelease) {
                    this.entryNamesSeen = new HashSet<String>();
                }
            }
            if (this.multiRelease) {
                String string = null;
                while (this.entries.hasMoreElements()) {
                    this.entry = this.entries.nextElement();
                    string = this.entry.getName();
                    if (string.startsWith("META-INF/versions/")) {
                        int n = string.indexOf(47, 18);
                        if (n == -1) continue;
                        string = string.substring(n + 1);
                    }
                    if (string.length() == 0 || this.entryNamesSeen.contains(string)) continue;
                    this.entryNamesSeen.add(string);
                    this.entry = this.jarFile.getJarEntry(this.entry.getName());
                    break block6;
                }
                this.entry = null;
            } else {
                this.entry = this.entries.hasMoreElements() ? this.entries.nextElement() : null;
            }
        }
    }

    @Override
    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        if (this.entry == null) {
            return null;
        }
        return this.jarFile.getInputStream(this.entry);
    }

    @Override
    public void reset() throws IOException {
        this.entries = null;
        this.entryNamesSeen = null;
        this.entry = null;
    }
}

