/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpNioProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpNioProtocol
extends AbstractAjpProtocol<NioChannel> {
    private static final Log log = LogFactory.getLog(AjpNioProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpNioProtocol() {
        this.endpoint = new NioEndpoint();
        this.endpoint.setAddress(JreCompat.getInstance().getLoopbackAddress());
        this.cHandler = new AjpConnectionHandler(this);
        ((NioEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
        ((NioEndpoint)this.endpoint).setUseSendfile(false);
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-nio";
    }

    protected static class AjpConnectionHandler
    extends AbstractAjpProtocol.AbstractAjpConnectionHandler<NioChannel, AjpNioProcessor>
    implements NioEndpoint.Handler {
        protected AjpNioProtocol proto;

        public AjpConnectionHandler(AjpNioProtocol ajpNioProtocol) {
            this.proto = ajpNioProtocol;
        }

        @Override
        protected AbstractProtocol<NioChannel> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return null;
        }

        @Override
        public void release(SocketChannel socketChannel) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Iterating through our connections to release a socket channel:" + socketChannel));
            }
            boolean bl = false;
            Iterator iterator = this.connections.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((NioChannel)entry.getKey()).getIOChannel() != socketChannel) continue;
                iterator.remove();
                Processor processor = (Processor)entry.getValue();
                processor.recycle(true);
                this.unregister(processor);
                bl = true;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Done iterating through our connections to release a socket channel:" + socketChannel + " released:" + bl));
            }
        }

        @Override
        public void release(SocketWrapper<NioChannel> socketWrapper) {
            Processor processor = (Processor)this.connections.remove(socketWrapper.getSocket());
            if (processor != null) {
                processor.recycle(true);
                this.recycledProcessors.offer(processor);
            }
        }

        @Override
        public void release(SocketWrapper<NioChannel> socketWrapper, Processor<NioChannel> processor, boolean bl, boolean bl2) {
            processor.recycle(bl);
            this.recycledProcessors.offer(processor);
            if (bl2) {
                socketWrapper.setTimeout(this.getProtocol().getKeepAliveTimeout());
                socketWrapper.getSocket().getPoller().add(socketWrapper.getSocket());
            }
        }

        @Override
        protected AjpNioProcessor createProcessor() {
            AjpNioProcessor ajpNioProcessor = new AjpNioProcessor(this.proto.packetSize, (NioEndpoint)this.proto.endpoint);
            ajpNioProcessor.setAdapter(this.proto.adapter);
            ajpNioProcessor.setAjpFlush(this.proto.getAjpFlush());
            ajpNioProcessor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            ajpNioProcessor.setTomcatAuthorization(this.proto.getTomcatAuthorization());
            ajpNioProcessor.setSecret(this.proto.getSecret());
            ajpNioProcessor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            ajpNioProcessor.setClientCertProvider(this.proto.getClientCertProvider());
            ajpNioProcessor.setMaxCookieCount(this.proto.getMaxCookieCount());
            ajpNioProcessor.setAllowedRequestAttributesPatternPattern(this.proto.getAllowedRequestAttributesPatternPattern());
            this.register(ajpNioProcessor);
            return ajpNioProcessor;
        }
    }
}

