/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.ExternalDropHandler;

public class EditorView
extends ViewElement {
    private static final boolean IS_GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    private ViewElement editorArea;
    private EditorAreaComponent editorAreaComponent;
    private final WindowDnDManager windowDnDManager;
    private static DataFlavor URI_LIST_DATA_FLAVOR;

    public EditorView(Controller controller, WindowDnDManager windowDnDManager, double d, ViewElement viewElement) {
        super(controller, d);
        this.editorArea = viewElement;
        this.windowDnDManager = windowDnDManager;
    }

    Rectangle getPureBounds() {
        EditorAreaComponent editorAreaComponent = this.getEditorAreaComponent();
        Rectangle rectangle = editorAreaComponent.getBounds();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, editorAreaComponent);
        rectangle.setLocation(point);
        return rectangle;
    }

    private EditorAreaComponent getEditorAreaComponent() {
        if (this.editorAreaComponent == null) {
            this.editorAreaComponent = new EditorAreaComponent(this, this.windowDnDManager);
        }
        if (IS_GTK && !this.editorAreaComponent.isValid()) {
            this.editorAreaComponent.repaint();
        }
        return this.editorAreaComponent;
    }

    private void manageBorder(JPanel jPanel) {
        if (this.editorArea != null) {
            jPanel.setBorder(null);
        } else if (Utilities.isMac()) {
            jPanel.setBorder(BorderFactory.createEmptyBorder());
        } else {
            Border border = UIManager.getBorder("Nb.EmptyEditorArea.border");
            if (null == border) {
                border = UIManager.getBorder("Nb.ScrollPane.border");
            }
            jPanel.setBorder(border);
        }
    }

    public ViewElement getEditorArea() {
        return this.editorArea;
    }

    public void setEditorArea(ViewElement viewElement) {
        this.editorArea = viewElement;
    }

    @Override
    public Component getComponent() {
        return this.getEditorAreaComponent();
    }

    @Override
    public boolean updateAWTHierarchy(Dimension dimension) {
        boolean bl = false;
        EditorAreaComponent editorAreaComponent = this.getEditorAreaComponent();
        Dimension dimension2 = (Dimension)editorAreaComponent.getClientProperty("lastAvailableSpace");
        Dimension dimension3 = editorAreaComponent.getPreferredSize();
        if (!dimension.equals(dimension2) || !dimension.equals(dimension3)) {
            editorAreaComponent.setPreferredSize(dimension);
            editorAreaComponent.putClientProperty("lastAvailableSpace", dimension);
            bl = true;
        }
        this.assureComponentInEditorArea();
        if (this.editorArea != null) {
            bl |= this.editorArea.updateAWTHierarchy(new Dimension(dimension.width - 5, dimension.height - 5));
        }
        return bl;
    }

    void assureComponentInEditorArea() {
        EditorAreaComponent editorAreaComponent = this.getEditorAreaComponent();
        if (this.editorArea == null) {
            editorAreaComponent.setAreaComponent(null);
        } else {
            editorAreaComponent.setAreaComponent(this.editorArea.getComponent());
        }
        this.manageBorder(editorAreaComponent);
    }

    static {
        try {
            URI_LIST_DATA_FLAVOR = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private static class EditorAreaComponent
    extends JPanel
    implements TopComponentDroppable {
        private final EditorView editorView;
        private final WindowDnDManager windowDnDManager;
        private Component areaComponent;

        public EditorAreaComponent(EditorView editorView, WindowDnDManager windowDnDManager) {
            this.editorView = editorView;
            this.windowDnDManager = windowDnDManager;
            this.init();
        }

        private void init() {
            Object object;
            this.setLayout(new BorderLayout());
            String string = UIManager.getLookAndFeel().getID();
            String string2 = Constants.SWITCH_IMAGE_SOURCE;
            if (string2 != null) {
                object = ImageUtilities.loadImage((String)string2);
                if (object != null) {
                    JLabel jLabel = new JLabel(new ImageIcon((Image)object));
                    jLabel.setMinimumSize(new Dimension(0, 0));
                    this.add((Component)jLabel, "Center");
                } else {
                    Logger.getLogger(EditorView.class.getName()).log(Level.WARNING, null, new NullPointerException("Image not found at " + string2));
                }
            }
            object = new DropTarget(this, new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                }

                @Override
                public void dragExit(DropTargetEvent dropTargetEvent) {
                }

                @Override
                public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                    for (ExternalDropHandler externalDropHandler : Lookup.getDefault().lookupAll(ExternalDropHandler.class)) {
                        if (!externalDropHandler.canDrop(dropTargetDragEvent)) continue;
                        dropTargetDragEvent.acceptDrag(1);
                        return;
                    }
                    dropTargetDragEvent.rejectDrag();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    boolean bl = false;
                    try {
                        for (ExternalDropHandler externalDropHandler : Lookup.getDefault().lookupAll(ExternalDropHandler.class)) {
                            if (!externalDropHandler.canDrop(dropTargetDropEvent)) continue;
                            dropTargetDropEvent.acceptDrop(1);
                            bl = externalDropHandler.handleDrop(dropTargetDropEvent);
                            break;
                        }
                    }
                    finally {
                        dropTargetDropEvent.dropComplete(bl);
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                }
            });
            this.setDropTarget((DropTarget)object);
            if (UIManager.getBoolean("NbMainWindow.showCustomBackground") || "Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.setOpaque(false);
            }
        }

        public void setAreaComponent(Component component) {
            if (this.areaComponent == component) {
                if (component != null && !Arrays.asList(this.getComponents()).contains(component)) {
                    this.add(component, "Center");
                }
                return;
            }
            if (this.areaComponent != null) {
                this.remove(this.areaComponent);
            }
            this.areaComponent = component;
            if (this.areaComponent != null) {
                this.add(this.areaComponent, "Center");
            }
        }

        @Override
        public Shape getIndicationForLocation(Point point) {
            int n = this.windowDnDManager.getStartingTransfer().getKind();
            if (n == 1) {
                Rectangle rectangle = this.getBounds();
                rectangle.setLocation(0, 0);
                return rectangle;
            }
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            String string = this.getSideForLocation(point);
            double d = 0.25;
            if ("top".equals(string)) {
                return new Rectangle(0, 0, rectangle.width, (int)((double)rectangle.height * d));
            }
            if (string == "left") {
                return new Rectangle(0, 0, (int)((double)rectangle.width * d), rectangle.height);
            }
            if (string == "right") {
                return new Rectangle(rectangle.width - (int)((double)rectangle.width * d), 0, (int)((double)rectangle.width * d), rectangle.height);
            }
            if (string == "bottom") {
                return new Rectangle(0, rectangle.height - (int)((double)rectangle.height * d), rectangle.width, (int)((double)rectangle.height * d));
            }
            if (this.windowDnDManager.getStartingTransfer().isAllowedToMoveAnywhere()) {
                return rectangle;
            }
            return null;
        }

        @Override
        public Object getConstraintForLocation(Point point) {
            int n = this.windowDnDManager.getStartingTransfer().getKind();
            if (n == 1) {
                return null;
            }
            return this.getSideForLocation(point);
        }

        private String getSideForLocation(Point point) {
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            int n = 20;
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, n);
            if (rectangle2.contains(point)) {
                return "top";
            }
            Rectangle rectangle3 = new Rectangle(0, n, n, rectangle.height - 2 * n);
            if (rectangle3.contains(point)) {
                return "left";
            }
            Rectangle rectangle4 = new Rectangle(rectangle.width - n, n, n, rectangle.height - 2 * n);
            if (rectangle4.contains(point)) {
                return "right";
            }
            Rectangle rectangle5 = new Rectangle(0, rectangle.height - n, rectangle.width, n);
            if (rectangle5.contains(point)) {
                return "bottom";
            }
            return null;
        }

        @Override
        public Component getDropComponent() {
            return this;
        }

        @Override
        public ViewElement getDropViewElement() {
            return this.editorView;
        }

        @Override
        public boolean canDrop(TopComponentDraggable topComponentDraggable, Point point) {
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            int n = topComponentDraggable.getKind();
            if (n == 1) {
                return true;
            }
            return WindowManagerImpl.getInstance().getEditorAreaState() == 0 && this.getSideForLocation(point) != null;
        }

        @Override
        public boolean supportsKind(TopComponentDraggable topComponentDraggable) {
            return true;
        }

        @Override
        public int getKind() {
            return 1;
        }
    }
}

