/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public final class DesktopUtils {
    private static final Object allowDesktopOpen = System.getProperty("com.sun.tools.visualvm.core.ui.DesktopUtils.allowDesktopOpen");
    private static boolean desktopSupported;
    private static boolean desktopSupportedInitialized;
    private static boolean browseAvailable;
    private static boolean browseAvailableInitialized;
    private static boolean openAvailable;
    private static boolean openAvailableInitialized;

    public static synchronized boolean isDesktopSupported() {
        if (!desktopSupportedInitialized) {
            desktopSupported = Desktop.isDesktopSupported();
            desktopSupportedInitialized = true;
        }
        return desktopSupported;
    }

    public static synchronized boolean isBrowseAvailable() {
        if (!browseAvailableInitialized) {
            browseAvailable = !DesktopUtils.isDesktopSupported() ? false : Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
            browseAvailableInitialized = true;
        }
        return browseAvailable;
    }

    public static synchronized boolean isOpenAvailable() {
        if (!openAvailableInitialized) {
            openAvailable = "true".equals(allowDesktopOpen) && DesktopUtils.isDesktopSupported() ? Desktop.getDesktop().isSupported(Desktop.Action.OPEN) : false;
            openAvailableInitialized = true;
        }
        return openAvailable;
    }

    public static void browse(URI uri) throws IOException {
        Desktop.getDesktop().browse(uri);
    }

    public static void open(File file) throws IOException {
        Desktop.getDesktop().open(file);
    }

    static {
        desktopSupportedInitialized = false;
        browseAvailableInitialized = false;
        openAvailableInitialized = false;
    }
}

