/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.upgrader;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.ui.upgrader.CopyFiles;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Upgrader {
    private static final String UPGRADER_LAST_VERSION = "Upgrader_Last_Version";
    private static final List<String> VERSION_TO_CHECK = Arrays.asList("0.9.0");

    public void upgrade() {
        File latestPreviousVersion;
        String currentVersion = this.getCurrentVersion();
        Logger.getLogger("").log(Level.INFO, "Current Version is {0}", currentVersion);
        String lastVersion = NbPreferences.forModule(Upgrader.class).get(UPGRADER_LAST_VERSION, null);
        if (!(lastVersion != null && lastVersion.equals(currentVersion) || (latestPreviousVersion = this.checkPrevious()) == null || latestPreviousVersion.getName().replace(".", "").equals(currentVersion))) {
            File source = new File(latestPreviousVersion, "dev");
            File dest = new File(System.getProperty("netbeans.user"));
            if (source.exists() && dest.exists()) {
                NbPreferences.forModule(Upgrader.class).put(UPGRADER_LAST_VERSION, currentVersion);
                boolean confirm = this.showUpgradeDialog(latestPreviousVersion);
                if (confirm) {
                    try {
                        CopyFiles.copyDeep(source, dest);
                        if (this.showRestartDialog()) {
                            LifecycleManager.getDefault().markForRestart();
                            LifecycleManager.getDefault().exit();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    private boolean showRestartDialog() {
        String msg = NbBundle.getMessage(Upgrader.class, (String)"Upgrader.restart.message");
        String title = NbBundle.getMessage(Upgrader.class, (String)"Upgrader.restart.title");
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, title, 0, 3);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION;
    }

    private boolean showUpgradeDialog(File source) {
        String msg = NbBundle.getMessage(Upgrader.class, (String)"Upgrader.message", (Object)source.getName());
        String title = NbBundle.getMessage(Upgrader.class, (String)"Upgrader.title");
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, title, 0, 3);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION;
    }

    private String getCurrentVersion() {
        File userDir = new File(System.getProperty("netbeans.user"));
        if (userDir.getName().equalsIgnoreCase("testuserdir")) {
            return userDir.getName();
        }
        return userDir.getParentFile().getName().replace(".", "");
    }

    private File checkPrevious() {
        File userDir = new File(System.getProperty("netbeans.user"));
        File sourceFolder = null;
        if (userDir.exists()) {
            File userHomeFile = userDir.getName().equalsIgnoreCase("userdir") ? userDir.getParentFile() : userDir.getParentFile().getParentFile();
            Iterator<String> it = VERSION_TO_CHECK.iterator();
            while (it.hasNext() && sourceFolder == null) {
                String ver = it.next();
                sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (sourceFolder.isDirectory() || (sourceFolder = new File(userHomeFile.getAbsolutePath(), "." + ver)).isDirectory()) break;
                sourceFolder = null;
            }
            return sourceFolder;
        }
        return null;
    }
}

