/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public String format;
    private final Date dat = new Date();

    public LogFormatter(String logformat) {
        this.format = logformat;
    }

    @Override
    public String format(LogRecord record) {
        String source;
        this.dat.setTime(record.getMillis());
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName().substring(record.getSourceClassName().lastIndexOf(46) + 1);
            if (record.getSourceMethodName() != null) {
                source = source + "." + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        return String.format(this.format, this.dat, source, record.getLoggerName(), record.getLevel(), message, throwable);
    }
}

