/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin;

import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;

public abstract class AbstractLayout
implements Layout {
    private final LayoutBuilder layoutBuilder;
    protected GraphModel graphModel;
    private boolean converged;

    public AbstractLayout(LayoutBuilder layoutBuilder) {
        this.layoutBuilder = layoutBuilder;
    }

    public LayoutBuilder getBuilder() {
        return this.layoutBuilder;
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    public boolean canAlgo() {
        return !this.isConverged() && this.graphModel != null;
    }

    public void setConverged(boolean converged) {
        this.converged = converged;
    }

    public boolean isConverged() {
        return this.converged;
    }

    public static void ensureSafeLayoutNodePositions(GraphModel graphModel) {
        Graph graph = graphModel.getGraph();
        NodeIterable nodesIterable = graph.getNodes();
        for (Node node : nodesIterable) {
            if (node.x() == 0.0f && node.y() == 0.0f) continue;
            nodesIterable.doBreak();
            return;
        }
        nodesIterable = graph.getNodes();
        for (Node node : nodesIterable) {
            node.setX((float)((0.01 + Math.random()) * 1000.0) - 500.0f);
            node.setY((float)((0.01 + Math.random()) * 1000.0) - 500.0f);
        }
    }
}

