/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import com.zaxxer.sansorm.internal.FieldColumnInfo;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import javax.persistence.EnumType;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import org.postgresql.util.PGobject;

public final class Introspected {
    private final Class<?> clazz;
    final List<FieldColumnInfo> idFcInfos;
    private String tableName;
    private final TreeMap<String, FieldColumnInfo> columnToField;
    private final Map<String, FieldColumnInfo> propertyToField;
    private final List<FieldColumnInfo> allFcInfos;
    private List<FieldColumnInfo> insertableFcInfos;
    private List<FieldColumnInfo> updatableFcInfos;
    private FieldColumnInfo selfJoinFCInfo;
    private boolean isGeneratedId;
    private FieldColumnInfo[] idFieldColumnInfos;
    private String[] idColumnNames;
    private String[] columnTableNames;
    private String[] insertableColumns;
    private String[] updatableColumns;
    private String[] delimitedColumnNames;
    private String[] caseSensitiveColumnNames;
    private String[] delimitedColumnsSansIds;
    private FieldColumnInfo[] insertableFcInfosArray;
    private FieldColumnInfo[] updatableFcInfosArray;
    private FieldColumnInfo[] selectableFcInfosArray;

    Introspected(Class<?> clazz) {
        this.clazz = clazz;
        this.columnToField = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.propertyToField = new HashMap<String, FieldColumnInfo>();
        this.insertableFcInfos = new ArrayList<FieldColumnInfo>();
        this.updatableFcInfos = new ArrayList<FieldColumnInfo>();
        this.allFcInfos = new ArrayList<FieldColumnInfo>();
        this.idFcInfos = new ArrayList<FieldColumnInfo>();
        this.extractClassTableName();
        try {
            for (Field field : this.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers)) continue;
                field.setAccessible(true);
                FieldColumnInfo fcInfo = new FieldColumnInfo(field, clazz);
                if (fcInfo.isTransient) continue;
                this.columnToField.put(fcInfo.getCaseSensitiveColumnName(), fcInfo);
                this.propertyToField.put(fcInfo.getPropertyName(), fcInfo);
                this.allFcInfos.add(fcInfo);
                if (fcInfo.isIdField) {
                    this.idFcInfos.add(fcInfo);
                    boolean bl = this.isGeneratedId = this.isGeneratedId || fcInfo.isGeneratedId;
                    if (this.isGeneratedId && this.idFcInfos.size() > 1) {
                        throw new IllegalStateException("Cannot have multiple @Id annotations and @GeneratedValue at the same time.");
                    }
                    if (fcInfo.isGeneratedId) continue;
                    if (fcInfo.isInsertable() == null || fcInfo.isInsertable().booleanValue()) {
                        this.insertableFcInfos.add(fcInfo);
                    }
                    if (fcInfo.isUpdatable() != null && !fcInfo.isUpdatable().booleanValue()) continue;
                    this.updatableFcInfos.add(fcInfo);
                    continue;
                }
                if (fcInfo.isSelfJoinField()) {
                    this.selfJoinFCInfo = fcInfo;
                    continue;
                }
                if (fcInfo.isInsertable() == null || fcInfo.isInsertable().booleanValue()) {
                    this.insertableFcInfos.add(fcInfo);
                }
                if (fcInfo.isUpdatable() != null && !fcInfo.isUpdatable().booleanValue()) continue;
                this.updatableFcInfos.add(fcInfo);
            }
            this.precalculateColumnInfos(this.idFcInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    FieldColumnInfo getFieldColumnInfo(String columnName) {
        return this.columnToField.get(columnName);
    }

    private Collection<Field> getDeclaredFields() {
        LinkedList<Field> declaredFields = new LinkedList<Field>(Arrays.asList(this.clazz.getDeclaredFields()));
        for (Class<?> c = this.clazz.getSuperclass(); c != null; c = c.getSuperclass()) {
            if (c.getAnnotation(MappedSuperclass.class) == null) continue;
            if (c.getAnnotation(Table.class) == null) {
                declaredFields.addAll(Arrays.asList(c.getDeclaredFields()));
                continue;
            }
            throw new RuntimeException("Class " + c.getName() + " annotated with @MappedSuperclass cannot also have @Table annotation");
        }
        return declaredFields;
    }

    private void extractClassTableName() {
        Table tableAnnotation = this.clazz.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            String tableName = tableAnnotation.name();
            this.tableName = tableName.isEmpty() ? this.clazz.getSimpleName() : tableName;
        }
    }

    Object get(Object target, FieldColumnInfo fcInfo) {
        if (fcInfo == null) {
            throw new RuntimeException("FieldColumnInfo must not be null. Type is " + target.getClass().getCanonicalName());
        }
        try {
            Object value = fcInfo.field.get(target);
            if (fcInfo.getConverter() != null) {
                value = fcInfo.getConverter().convertToDatabaseColumn(value);
            } else if (fcInfo.enumConstants != null && value != null) {
                value = fcInfo.enumType == EnumType.ORDINAL ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name();
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void set(Object target, FieldColumnInfo fcInfo, Object value) {
        if (fcInfo == null) {
            throw new RuntimeException("FieldColumnInfo must not be null. Type is " + target.getClass().getCanonicalName());
        }
        try {
            Class<?> fieldType = fcInfo.fieldType;
            Class<?> columnType = value.getClass();
            Object columnValue = value;
            if (fcInfo.getConverter() != null) {
                columnValue = fcInfo.getConverter().convertToEntityAttribute(columnValue);
            } else if (fieldType != columnType) {
                if (fieldType == Boolean.TYPE && columnType == Integer.class) {
                    columnValue = (Integer)columnValue != 0;
                } else if (columnType == BigDecimal.class) {
                    if (fieldType == BigInteger.class) {
                        columnValue = ((BigDecimal)columnValue).toBigInteger();
                    } else if (fieldType == Integer.class) {
                        columnValue = (int)((BigDecimal)columnValue).longValue();
                    } else if (fieldType == Long.class) {
                        columnValue = ((BigDecimal)columnValue).longValue();
                    }
                } else if (columnType == UUID.class && fieldType == String.class) {
                    columnValue = columnValue.toString();
                } else if (fcInfo.enumConstants != null) {
                    columnValue = fcInfo.enumConstants.get(columnValue);
                } else if (columnValue instanceof Clob) {
                    columnValue = Introspected.readClob((Clob)columnValue);
                } else if ("PGobject".equals(columnType.getSimpleName()) && "citext".equalsIgnoreCase(((PGobject)columnValue).getType())) {
                    columnValue = ((PGobject)columnValue).getValue();
                }
            }
            fcInfo.field.set(target, columnValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasSelfJoinColumn() {
        return this.selfJoinFCInfo != null;
    }

    public boolean isSelfJoinColumn(String columnName) {
        return this.selfJoinFCInfo.getCaseSensitiveColumnName().equals(columnName);
    }

    public String getSelfJoinColumn() {
        return this.selfJoinFCInfo != null ? this.selfJoinFCInfo.getColumnName() : null;
    }

    FieldColumnInfo getSelfJoinColumnInfo() {
        return this.selfJoinFCInfo;
    }

    public String[] getColumnNames() {
        return this.delimitedColumnNames;
    }

    public String[] getColumnTableNames() {
        return this.columnTableNames;
    }

    public String[] getIdColumnNames() {
        return this.idColumnNames;
    }

    public String[] getColumnsSansIds() {
        return this.delimitedColumnsSansIds;
    }

    public boolean hasGeneratedId() {
        return this.isGeneratedId;
    }

    public String[] getInsertableColumns() {
        return this.insertableColumns;
    }

    private void precalculateInsertableColumns() {
        this.insertableColumns = new String[this.insertableFcInfos.size()];
        this.insertableFcInfosArray = new FieldColumnInfo[this.insertableFcInfos.size()];
        for (int i = 0; i < this.insertableColumns.length; ++i) {
            this.insertableColumns[i] = this.insertableFcInfos.get(i).getDelimitedColumnName();
            this.insertableFcInfosArray[i] = this.insertableFcInfos.get(i);
        }
    }

    public String[] getUpdatableColumns() {
        return this.updatableColumns;
    }

    private void precalculateUpdatableColumns() {
        this.updatableColumns = new String[this.updatableFcInfos.size()];
        this.updatableFcInfosArray = new FieldColumnInfo[this.updatableColumns.length];
        for (int i = 0; i < this.updatableColumns.length; ++i) {
            this.updatableColumns[i] = this.updatableFcInfos.get(i).getDelimitedColumnName();
            this.updatableFcInfosArray[i] = this.updatableFcInfos.get(i);
        }
    }

    public boolean isInsertableColumn(String columnName) {
        FieldColumnInfo[] fcInfos = this.getInsertableFcInfos();
        for (int i = 0; i < fcInfos.length; ++i) {
            if (!fcInfos[i].getCaseSensitiveColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUpdatableColumn(String columnName) {
        FieldColumnInfo[] fcInfos = this.getUpdatableFcInfos();
        for (int i = 0; i < fcInfos.length; ++i) {
            if (!fcInfos[i].getCaseSensitiveColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    Object[] getActualIds(Object target) {
        if (this.idColumnNames.length == 0) {
            return null;
        }
        try {
            FieldColumnInfo[] fcInfos = this.idFieldColumnInfos;
            Object[] ids = new Object[this.idColumnNames.length];
            for (int i = 0; i < fcInfos.length; ++i) {
                ids[i] = fcInfos[i].field.get(target);
            }
            return ids;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnNameForProperty(String propertyName) {
        return Optional.ofNullable(this.propertyToField.get(propertyName)).map(fcInfo -> fcInfo.getDelimitedColumnName()).orElse(null);
    }

    private void precalculateColumnInfos(List<FieldColumnInfo> idFcInfos) {
        this.idFieldColumnInfos = new FieldColumnInfo[idFcInfos.size()];
        this.idColumnNames = new String[idFcInfos.size()];
        String[] columnNames = new String[this.columnToField.size()];
        this.columnTableNames = new String[columnNames.length];
        this.caseSensitiveColumnNames = new String[columnNames.length];
        this.delimitedColumnNames = new String[columnNames.length];
        String[] columnsSansIds = new String[columnNames.length - this.idColumnNames.length];
        this.delimitedColumnsSansIds = new String[columnsSansIds.length];
        this.selectableFcInfosArray = new FieldColumnInfo[this.allFcInfos.size()];
        int fieldCount = 0;
        int idCount = 0;
        int sansIdCount = 0;
        for (FieldColumnInfo fcInfo : this.allFcInfos) {
            if (!fcInfo.isTransient) {
                columnNames[fieldCount] = fcInfo.getColumnName();
                this.caseSensitiveColumnNames[fieldCount] = fcInfo.getCaseSensitiveColumnName();
                this.delimitedColumnNames[fieldCount] = fcInfo.getDelimitedColumnName();
                this.columnTableNames[fieldCount] = fcInfo.columnTableName;
                this.selectableFcInfosArray[fieldCount] = fcInfo;
                if (!fcInfo.isIdField) {
                    columnsSansIds[sansIdCount] = fcInfo.getColumnName();
                    this.delimitedColumnsSansIds[sansIdCount] = fcInfo.getDelimitedColumnName();
                    ++sansIdCount;
                } else {
                    this.idColumnNames[idCount] = fcInfo.getDelimitedColumnName();
                    this.idFieldColumnInfos[idCount] = fcInfo;
                    ++idCount;
                }
            }
            ++fieldCount;
        }
        this.precalculateInsertableColumns();
        this.precalculateUpdatableColumns();
    }

    private static String readClob(Clob clob) throws IOException, SQLException {
        try (Reader reader = clob.getCharacterStream();){
            int rc;
            StringBuilder sb = new StringBuilder();
            char[] cbuf = new char[1024];
            while ((rc = reader.read(cbuf)) != -1) {
                sb.append(cbuf, 0, rc);
            }
            String string = sb.toString();
            return string;
        }
    }

    String[] getCaseSensitiveColumnNames() {
        return this.caseSensitiveColumnNames;
    }

    FieldColumnInfo[] getInsertableFcInfos() {
        return this.insertableFcInfosArray;
    }

    FieldColumnInfo getGeneratedIdFcInfo() {
        return this.idFieldColumnInfos[0];
    }

    FieldColumnInfo[] getUpdatableFcInfos() {
        return this.updatableFcInfosArray;
    }

    FieldColumnInfo[] getSelectableFcInfos() {
        return this.selectableFcInfosArray;
    }

    public List<FieldColumnInfo> getIdFcInfos() {
        return this.idFcInfos;
    }
}

