/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Display;
import oshi.hardware.common.AbstractDisplay;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@Immutable
final class SolarisDisplay
extends AbstractDisplay {
    private static final Logger LOG = LoggerFactory.getLogger(SolarisDisplay.class);

    SolarisDisplay(byte[] edid) {
        super(edid);
        LOG.debug("Initialized SolarisDisplay");
    }

    public static Display[] getDisplays() {
        List<String> xrandr = ExecutingCommand.runNative("xrandr --verbose");
        if (xrandr.isEmpty()) {
            return new Display[0];
        }
        ArrayList<SolarisDisplay> displays = new ArrayList<SolarisDisplay>();
        StringBuilder sb = null;
        for (String s2 : xrandr) {
            if (s2.contains("EDID")) {
                sb = new StringBuilder();
                continue;
            }
            if (sb == null) continue;
            sb.append(s2.trim());
            if (sb.length() < 256) continue;
            String edidStr = sb.toString();
            LOG.debug("Parsed EDID: {}", (Object)edidStr);
            byte[] edid = ParseUtil.hexStringToByteArray(edidStr);
            if (edid.length >= 128) {
                displays.add(new SolarisDisplay(edid));
            }
            sb = null;
        }
        return displays.toArray(new Display[0]);
    }
}

