/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/private/qglobal_p.h>

QT_BEGIN_NAMESPACE

/* This part of the file isn't generated, but written by hand since
 * Unicode CLDR doesn't contain measurement system information.
 */
struct CountryLanguage
{
    quint16 languageId;
    quint16 countryId;
    QLocale::MeasurementSystem system;
};
static const CountryLanguage ImperialMeasurementSystems[] = {
    { QLocale::English, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::English, QLocale::UnitedStatesMinorOutlyingIslands, QLocale::ImperialUSSystem },
    { QLocale::Spanish, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::Hawaiian, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::English, QLocale::UnitedKingdom, QLocale::ImperialUKSystem }
};
static const int ImperialMeasurementSystemsCount =
    sizeof(ImperialMeasurementSystems)/sizeof(ImperialMeasurementSystems[0]);

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2020-11-12 from the
    Common Locale Data Repository v38

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

static const QLocaleId likely_subtags[] = {
    {   2,   0,   0 }, {   2,  27,  90 }, // ab -> ab_Cyrl_GE
    {   3,   0,   0 }, {   3,  66,  77 }, // aa -> aa_Latn_ET
    {   4,   0,   0 }, {   4,  66, 216 }, // af -> af_Latn_ZA
    {   5,   0,   0 }, {   5,  66,  40 }, // agq -> agq_Latn_CM
    {   6,   0,   0 }, {   6,  66,  92 }, // ak -> ak_Latn_GH
    {   7,   0,   0 }, {   7,  25, 113 }, // akk -> akk_Xsux_IQ
    {   8,   0,   0 }, {   8,  66,  40 }, // bss -> bss_Latn_CM
    {   9,   0,   0 }, {   9,  66,   3 }, // sq -> sq_Latn_AL
    {  10,   0,   0 }, {  10, 117, 248 }, // ase -> ase_Sgnw_US
    {  11,   0,   0 }, {  11,  33,  77 }, // am -> am_Ethi_ET
    {  12,   0,   0 }, {  12,  31,  71 }, // egy -> egy_Egyp_EG
    {  13,  70,   0 }, {  13,  70,  94 }, // grc_Linb -> grc_Linb_GR
    {  13,   0,   0 }, {  13,  26,  63 }, // grc -> grc_Cprt_CY
    {  14,   0,   0 }, {  14,   4,  71 }, // ar -> ar_Arab_EG
    {  15,   0,   0 }, {  15,  66, 220 }, // an -> an_Latn_ES
    {  16,  87,   0 }, {  16,  87, 122 }, // arc_Nbat -> arc_Nbat_JO
    {  16, 104,   0 }, {  16, 104, 227 }, // arc_Palm -> arc_Palm_SY
    {  16,   0,   0 }, {  16,  49, 112 }, // arc -> arc_Armi_IR
    {  17,   0,   0 }, {  17,   5,  12 }, // hy -> hy_Armn_AM
    {  18,   0,   0 }, {  18,   9, 110 }, // as -> as_Beng_IN
    {  19,   0,   0 }, {  19,  66, 220 }, // ast -> ast_Latn_ES
    {  20,   0,   0 }, {  20,  66, 230 }, // asa -> asa_Latn_TZ
    {  21,   0,   0 }, {  21,  66, 169 }, // cch -> cch_Latn_NG
    {  22,   0,   0 }, {  22,  27, 193 }, // av -> av_Cyrl_RU
    {  23,   0,   0 }, {  23,   6, 112 }, // ae -> ae_Avst_IR
    {  24,   0,   0 }, {  24,  66,  28 }, // ay -> ay_Latn_BO
    {  25,   0, 112 }, {  25,   4, 112 }, // az_IR -> az_Arab_IR
    {  25,   0, 113 }, {  25,   4, 113 }, // az_IQ -> az_Arab_IQ
    {  25,   0, 193 }, {  25,  27, 193 }, // az_RU -> az_Cyrl_RU
    {  25,   4,   0 }, {  25,   4, 112 }, // az_Arab -> az_Arab_IR
    {  25,   0,   0 }, {  25,  66,  17 }, // az -> az_Latn_AZ
    {  26,   0,   0 }, {  26,  66,  40 }, // ksf -> ksf_Latn_CM
    {  27,   0,   0 }, {  27,  66, 111 }, // ban -> ban_Latn_ID
    {  28,   0,   0 }, {  28,  66, 145 }, // bm -> bm_Latn_ML
    {  29,   0,   0 }, {  29,   8,  40 }, // bax -> bax_Bamu_CM
    {  30,   0,   0 }, {  30,   9,  20 }, // bn -> bn_Beng_BD
    {  31,   0,   0 }, {  31,  66,  40 }, // bas -> bas_Latn_CM
    {  32,   0,   0 }, {  32,  27, 193 }, // ba -> ba_Cyrl_RU
    {  33,   0,   0 }, {  33,  66, 220 }, // eu -> eu_Latn_ES
    {  34,   0,   0 }, {  34,  66, 111 }, // bbc -> bbc_Latn_ID
    {  35,   0,   0 }, {  35,  27,  22 }, // be -> be_Cyrl_BY
    {  36,   0,   0 }, {  36,  66, 260 }, // bem -> bem_Latn_ZM
    {  37,   0,   0 }, {  37,  66, 230 }, // bez -> bez_Latn_TZ
    {  38,   0,   0 }, {  38,  29, 110 }, // bho -> bho_Deva_IN
    {  39,   0,   0 }, {  39,  66, 252 }, // bi -> bi_Latn_VU
    {  40,   0,   0 }, {  40,  33,  74 }, // byn -> byn_Ethi_ER
    {  41,   0,   0 }, {  41,  29, 110 }, // brx -> brx_Deva_IN
    {  42,   0,   0 }, {  42,  66,  29 }, // bs -> bs_Latn_BA
    {  43,   0,   0 }, {  43,  66,  84 }, // br -> br_Latn_FR
    {  44,   0,   0 }, {  44,  66, 111 }, // bug -> bug_Latn_ID
    {  45,   0,   0 }, {  45,  27,  36 }, // bg -> bg_Cyrl_BG
    {  46,   0,   0 }, {  46,  86, 161 }, // my -> my_Mymr_MM
    {  47,   0,  50 }, {  47, 118,  50 }, // yue_CN -> yue_Hans_CN
    {  47, 118,   0 }, {  47, 118,  50 }, // yue_Hans -> yue_Hans_CN
    {  47,   0,   0 }, {  47, 137, 107 }, // yue -> yue_Hant_HK
    {  48,   0,   0 }, {  48,  66, 220 }, // ca -> ca_Latn_ES
    {  49,   0,   0 }, {  49,  66, 185 }, // ceb -> ceb_Latn_PH
    {  50,   0,   0 }, {  50,  66, 159 }, // tzm -> tzm_Latn_MA
    {  51,   0,   0 }, {  51,   4, 113 }, // ckb -> ckb_Arab_IQ
    {  52,   0,   0 }, {  52,  21,  20 }, // ccp -> ccp_Cakm_BD
    {  53,   0,   0 }, {  53,  66,  98 }, // ch -> ch_Latn_GU
    {  54,   0,   0 }, {  54,  27, 193 }, // ce -> ce_Cyrl_RU
    {  55,   0,   0 }, {  55,  23, 248 }, // chr -> chr_Cher_US
    {  56,   0,   0 }, {  56,  66, 248 }, // cic -> cic_Latn_US
    {  57,   0,   0 }, {  57,  66, 243 }, // cgg -> cgg_Latn_UG
    {  58,   0,  15 }, {  58, 137,  15 }, // zh_AU -> zh_Hant_AU
    {  58,   0,  35 }, {  58, 137,  35 }, // zh_BN -> zh_Hant_BN
    {  58,   0,  85 }, {  58, 137,  85 }, // zh_GF -> zh_Hant_GF
    {  58,   0,  86 }, {  58, 137,  86 }, // zh_PF -> zh_Hant_PF
    {  58,   0, 107 }, {  58, 137, 107 }, // zh_HK -> zh_Hant_HK
    {  58,   0, 111 }, {  58, 137, 111 }, // zh_ID -> zh_Hant_ID
    {  58,   0, 139 }, {  58, 137, 139 }, // zh_MO -> zh_Hant_MO
    {  58,   0, 181 }, {  58, 137, 181 }, // zh_PA -> zh_Hant_PA
    {  58,   0, 185 }, {  58, 137, 185 }, // zh_PH -> zh_Hant_PH
    {  58,   0, 223 }, {  58, 137, 223 }, // zh_SR -> zh_Hant_SR
    {  58,   0, 228 }, {  58, 137, 228 }, // zh_TW -> zh_Hant_TW
    {  58,   0, 231 }, {  58, 137, 231 }, // zh_TH -> zh_Hant_TH
    {  58,   0, 246 }, {  58, 137, 246 }, // zh_GB -> zh_Hant_GB
    {  58,   0, 248 }, {  58, 137, 248 }, // zh_US -> zh_Hant_US
    {  58,   0, 255 }, {  58, 137, 255 }, // zh_VN -> zh_Hant_VN
    {  58,  13,   0 }, {  58,  13, 228 }, // zh_Bopo -> zh_Bopo_TW
    {  58,  45,   0 }, {  58,  45, 228 }, // zh_Hanb -> zh_Hanb_TW
    {  58, 137,   0 }, {  58, 137, 228 }, // zh_Hant -> zh_Hant_TW
    {  58,   0,   0 }, {  58, 118,  50 }, // zh -> zh_Hans_CN
    {  59,  36,   0 }, {  59,  36,  36 }, // cu_Glag -> cu_Glag_BG
    {  59,   0,   0 }, {  59,  27, 193 }, // cu -> cu_Cyrl_RU
    {  60,   0,   0 }, {  60,  27, 193 }, // cv -> cv_Cyrl_RU
    {  61,   0,   0 }, {  61,  66,  91 }, // ksh -> ksh_Latn_DE
    {  62,   0,   0 }, {  62,  24,  71 }, // cop -> cop_Copt_EG
    {  63,   0,   0 }, {  63,  66, 246 }, // kw -> kw_Latn_GB
    {  64,   0,   0 }, {  64,  66,  84 }, // co -> co_Latn_FR
    {  65,   0,   0 }, {  65,  18,  41 }, // cr -> cr_Cans_CA
    {  66,   0,   0 }, {  66,  66,  60 }, // hr -> hr_Latn_HR
    {  67,   0,   0 }, {  67,  66,  64 }, // cs -> cs_Latn_CZ
    {  68,   0,   0 }, {  68,  66,  65 }, // da -> da_Latn_DK
    {  69,   0,   0 }, {  69, 132, 144 }, // dv -> dv_Thaa_MV
    {  70,   0,   0 }, {  70,  29, 110 }, // doi -> doi_Deva_IN
    {  71,   0,   0 }, {  71,  66,  40 }, // dua -> dua_Latn_CM
    {  72,   0,   0 }, {  72,  66, 165 }, // nl -> nl_Latn_NL
    {  73,   0,   0 }, {  73, 134,  27 }, // dz -> dz_Tibt_BT
    {  74,   0,   0 }, {  74,  66, 124 }, // ebu -> ebu_Latn_KE
    {  75, 115,   0 }, {  75, 115, 246 }, // en_Shaw -> en_Shaw_GB
    {  75,   0,   0 }, {  75,  66, 248 }, // en -> en_Latn_US
    {  76,   0,   0 }, {  76,  27, 193 }, // myv -> myv_Cyrl_RU
    {  77,   0,   0 }, {  77,  66, 258 }, // eo -> eo_Latn_001
    {  78,   0,   0 }, {  78,  66,  75 }, // et -> et_Latn_EE
    {  79,   0,   0 }, {  79,  66,  92 }, // ee -> ee_Latn_GH
    {  80,   0,   0 }, {  80,  66,  40 }, // ewo -> ewo_Latn_CM
    {  81,   0,   0 }, {  81,  66,  81 }, // fo -> fo_Latn_FO
    {  82,   0,   0 }, {  82,  66,  82 }, // fj -> fj_Latn_FJ
    {  83,   0,   0 }, {  83,  66, 185 }, // fil -> fil_Latn_PH
    {  84,   0,   0 }, {  84,  66,  83 }, // fi -> fi_Latn_FI
    {  85,   0,   0 }, {  85,  66,  84 }, // fr -> fr_Latn_FR
    {  86,   0,   0 }, {  86,  66, 117 }, // fur -> fur_Latn_IT
    {  87,   1,   0 }, {  87,   1, 102 }, // ff_Adlm -> ff_Adlm_GN
    {  87,   0,   0 }, {  87,  66, 206 }, // ff -> ff_Latn_SN
    {  88,   0,   0 }, {  88,  66, 246 }, // gd -> gd_Latn_GB
    {  89,   0,   0 }, {  89,  66,  92 }, // gaa -> gaa_Latn_GH
    {  90,   0,   0 }, {  90,  66, 220 }, // gl -> gl_Latn_ES
    {  91,   0,   0 }, {  91,  66, 243 }, // lg -> lg_Latn_UG
    {  92,   0,   0 }, {  92,  33,  77 }, // gez -> gez_Ethi_ET
    {  93,   0,   0 }, {  93,  35,  90 }, // ka -> ka_Geor_GE
    {  94,   0,   0 }, {  94,  66,  91 }, // de -> de_Latn_DE
    {  95,   0,   0 }, {  95,  37, 244 }, // got -> got_Goth_UA
    {  96,   0,   0 }, {  96,  39,  94 }, // el -> el_Grek_GR
    {  97,   0,   0 }, {  97,  66, 183 }, // gn -> gn_Latn_PY
    {  98,   0,   0 }, {  98,  40, 110 }, // gu -> gu_Gujr_IN
    {  99,   0,   0 }, {  99,  66, 124 }, // guz -> guz_Latn_KE
    { 100,   0,   0 }, { 100,  66, 104 }, // ht -> ht_Latn_HT
    { 101,   0,  40 }, { 101,   4,  40 }, // ha_CM -> ha_Arab_CM
    { 101,   0, 222 }, { 101,   4, 222 }, // ha_SD -> ha_Arab_SD
    { 101,   0,   0 }, { 101,  66, 169 }, // ha -> ha_Latn_NG
    { 102,   0,   0 }, { 102,  66, 248 }, // haw -> haw_Latn_US
    { 103,   0,   0 }, { 103,  47, 116 }, // he -> he_Hebr_IL
    { 104,   0,   0 }, { 104,  66, 162 }, // hz -> hz_Latn_NA
    { 105,   0,   0 }, { 105,  29, 110 }, // hi -> hi_Deva_IN
    { 106,   0,   0 }, { 106,  66, 182 }, // ho -> ho_Latn_PG
    { 107,   0,   0 }, { 107,  66, 108 }, // hu -> hu_Latn_HU
    { 108,   0,   0 }, { 108,  66, 109 }, // is -> is_Latn_IS
    { 109,   0,   0 }, { 109,  66, 258 }, // io -> io_Latn_001
    { 110,   0,   0 }, { 110,  66, 169 }, // ig -> ig_Latn_NG
    { 111,   0,   0 }, { 111,  66,  83 }, // smn -> smn_Latn_FI
    { 112,   0,   0 }, { 112,  66, 111 }, // id -> id_Latn_ID
    { 113,   0,   0 }, { 113,  27, 193 }, // inh -> inh_Cyrl_RU
    { 114,   0,   0 }, { 114,  66, 258 }, // ia -> ia_Latn_001
    { 116,   0,   0 }, { 116,  18,  41 }, // iu -> iu_Cans_CA
    { 117,   0,   0 }, { 117,  66, 248 }, // ik -> ik_Latn_US
    { 118,   0,   0 }, { 118,  66, 114 }, // ga -> ga_Latn_IE
    { 119,   0,   0 }, { 119,  66, 117 }, // it -> it_Latn_IT
    { 120,   0,   0 }, { 120,  53, 120 }, // ja -> ja_Jpan_JP
    { 121,   0,   0 }, { 121,  66, 111 }, // jv -> jv_Latn_ID
    { 122,   0,   0 }, { 122,  66, 169 }, // kaj -> kaj_Latn_NG
    { 123,   0,   0 }, { 123,  66, 206 }, // dyo -> dyo_Latn_SN
    { 124,   0,   0 }, { 124,  66,  43 }, // kea -> kea_Latn_CV
    { 125,   0,   0 }, { 125,  66,   4 }, // kab -> kab_Latn_DZ
    { 126,   0,   0 }, { 126,  66,  40 }, // kkj -> kkj_Latn_CM
    { 127,   0,   0 }, { 127,  66,  95 }, // kl -> kl_Latn_GL
    { 128,   0,   0 }, { 128,  66, 124 }, // kln -> kln_Latn_KE
    { 129,   0,   0 }, { 129,  66, 124 }, // kam -> kam_Latn_KE
    { 130,   0,   0 }, { 130,  56, 110 }, // kn -> kn_Knda_IN
    { 131,   0,   0 }, { 131,  66,   0 }, // kr -> kr_Latn
    { 132,   0,   0 }, { 132,   4, 110 }, // ks -> ks_Arab_IN
    { 133,   0,   1 }, { 133,   4,   1 }, // kk_AF -> kk_Arab_AF
    { 133,   0,  50 }, { 133,   4,  50 }, // kk_CN -> kk_Arab_CN
    { 133,   0, 112 }, { 133,   4, 112 }, // kk_IR -> kk_Arab_IR
    { 133,   0, 156 }, { 133,   4, 156 }, // kk_MN -> kk_Arab_MN
    { 133,   4,   0 }, { 133,   4,  50 }, // kk_Arab -> kk_Arab_CN
    { 133,   0,   0 }, { 133,  27, 123 }, // kk -> kk_Cyrl_KZ
    { 134,   0,   0 }, { 134,  66,  40 }, // ken -> ken_Latn_CM
    { 135,   0,   0 }, { 135,  60,  39 }, // km -> km_Khmr_KH
    { 136,   0,   0 }, { 136,  66,  99 }, // quc -> quc_Latn_GT
    { 137,   0,   0 }, { 137,  66, 124 }, // ki -> ki_Latn_KE
    { 138,   0,   0 }, { 138,  66, 194 }, // rw -> rw_Latn_RW
    { 139,   0,   0 }, { 139,  27, 193 }, // kv -> kv_Cyrl_RU
    { 140,   0,   0 }, { 140,  66,  57 }, // kg -> kg_Latn_CD
    { 141,   0,   0 }, { 141,  29, 110 }, // kok -> kok_Deva_IN
    { 142,   0,   0 }, { 142,  63, 218 }, // ko -> ko_Kore_KR
    { 143,   0,   0 }, { 143,  66, 118 }, // kfo -> kfo_Latn_CI
    { 144,   0,   0 }, { 144,  66, 145 }, // ses -> ses_Latn_ML
    { 145,   0,   0 }, { 145,  66, 145 }, // khq -> khq_Latn_ML
    { 146,   0,   0 }, { 146,  66, 134 }, // kpe -> kpe_Latn_LR
    { 147,   0,   0 }, { 147,  66, 162 }, // kj -> kj_Latn_NA
    { 148,   0, 132 }, { 148,   4, 132 }, // ku_LB -> ku_Arab_LB
    { 148,   4,   0 }, { 148,   4, 113 }, // ku_Arab -> ku_Arab_IQ
    { 148,   0,   0 }, { 148,  66, 239 }, // ku -> ku_Latn_TR
    { 149,   0,   0 }, { 149,  66,  40 }, // nmg -> nmg_Latn_CM
    { 150,   0,  50 }, { 150,   4,  50 }, // ky_CN -> ky_Arab_CN
    { 150,   0, 239 }, { 150,  66, 239 }, // ky_TR -> ky_Latn_TR
    { 150,   4,   0 }, { 150,   4,  50 }, // ky_Arab -> ky_Arab_CN
    { 150,  66,   0 }, { 150,  66, 239 }, // ky_Latn -> ky_Latn_TR
    { 150,   0,   0 }, { 150,  27, 128 }, // ky -> ky_Cyrl_KG
    { 151,   0,   0 }, { 151,  66, 248 }, // lkt -> lkt_Latn_US
    { 152,   0,   0 }, { 152,  66, 230 }, // lag -> lag_Latn_TZ
    { 153,   0,   0 }, { 153,  65, 129 }, // lo -> lo_Laoo_LA
    { 154,   0,   0 }, { 154,  66, 253 }, // la -> la_Latn_VA
    { 155,   0,   0 }, { 155,  66, 131 }, // lv -> lv_Latn_LV
    { 156,   0,   0 }, { 156,  27, 193 }, // lez -> lez_Cyrl_RU
    { 157,   0,   0 }, { 157,  66, 165 }, // li -> li_Latn_NL
    { 158,   0,   0 }, { 158,  66,  57 }, // ln -> ln_Latn_CD
    { 159,   0,   0 }, { 159, 118,  50 }, // lzh -> lzh_Hans_CN
    { 160,   0,   0 }, { 160,  66, 137 }, // lt -> lt_Latn_LT
    { 161,   0,   0 }, { 161,  66, 258 }, // jbo -> jbo_Latn_001
    { 162,   0,   0 }, { 162,  66,  91 }, // dsb -> dsb_Latn_DE
    { 163,   0,   0 }, { 163,  66,  91 }, // nds -> nds_Latn_DE
    { 164,   0,   0 }, { 164,  66,  57 }, // lu -> lu_Latn_CD
    { 165,   0,   0 }, { 165,  66, 225 }, // smj -> smj_Latn_SE
    { 166,   0,   0 }, { 166,  66, 124 }, // luo -> luo_Latn_KE
    { 167,   0,   0 }, { 167,  66, 138 }, // lb -> lb_Latn_LU
    { 168,   0,   0 }, { 168,  66, 124 }, // luy -> luy_Latn_KE
    { 169,   0,   0 }, { 169,  27, 140 }, // mk -> mk_Cyrl_MK
    { 170,   0,   0 }, { 170,  66, 230 }, // jmc -> jmc_Latn_TZ
    { 171,   0,   0 }, { 171,  29, 110 }, // mai -> mai_Deva_IN
    { 172,   0,   0 }, { 172,  66, 160 }, // mgh -> mgh_Latn_MZ
    { 173,   0,   0 }, { 173,  66, 230 }, // kde -> kde_Latn_TZ
    { 174,   0,   0 }, { 174,  66, 141 }, // mg -> mg_Latn_MG
    { 175,   0,   0 }, { 175,  74, 110 }, // ml -> ml_Mlym_IN
    { 176,   0,  53 }, { 176,   4,  53 }, // ms_CC -> ms_Arab_CC
    { 176,   0,   0 }, { 176,  66, 143 }, // ms -> ms_Latn_MY
    { 177,   0,   0 }, { 177,  66, 146 }, // mt -> mt_Latn_MT
    { 178,   0, 102 }, { 178,  90, 102 }, // man_GN -> man_Nkoo_GN
    { 178,  90,   0 }, { 178,  90, 102 }, // man_Nkoo -> man_Nkoo_GN
    { 178,   0,   0 }, { 178,  66,  89 }, // man -> man_Latn_GM
    { 179,   0,   0 }, { 179,   9, 110 }, // mni -> mni_Beng_IN
    { 180,   0,   0 }, { 180,  66, 115 }, // gv -> gv_Latn_IM
    { 181,   0,   0 }, { 181,  66, 167 }, // mi -> mi_Latn_NZ
    { 182,   0,   0 }, { 182,  66,  49 }, // arn -> arn_Latn_CL
    { 183,   0,   0 }, { 183,  29, 110 }, // mr -> mr_Deva_IN
    { 184,   0,   0 }, { 184,  66, 147 }, // mh -> mh_Latn_MH
    { 185,   0,   0 }, { 185,  66, 124 }, // mas -> mas_Latn_KE
    { 186,   0,   0 }, { 186,   4, 112 }, // mzn -> mzn_Arab_IR
    { 187,   0,   0 }, { 187,  66, 209 }, // men -> men_Latn_SL
    { 188,   0,   0 }, { 188,  66, 124 }, // mer -> mer_Latn_KE
    { 189,   0,   0 }, { 189,  66,  40 }, // mgo -> mgo_Latn_CM
    { 190,   0,   0 }, { 190,  66,  41 }, // moh -> moh_Latn_CA
    { 191,   0,  50 }, { 191,  83,  50 }, // mn_CN -> mn_Mong_CN
    { 191,  83,   0 }, { 191,  83,  50 }, // mn_Mong -> mn_Mong_CN
    { 191,   0,   0 }, { 191,  27, 156 }, // mn -> mn_Cyrl_MN
    { 192,   0,   0 }, { 192,  66, 150 }, // mfe -> mfe_Latn_MU
    { 193,   0,   0 }, { 193,  66,  40 }, // mua -> mua_Latn_CM
    { 194,   0,   0 }, { 194,  66, 248 }, // mus -> mus_Latn_US
    { 195,   0,   0 }, { 195,  66, 162 }, // naq -> naq_Latn_NA
    { 196,   0,   0 }, { 196,  66, 163 }, // na -> na_Latn_NR
    { 197,   0,   0 }, { 197,  66, 248 }, // nv -> nv_Latn_US
    { 198,   0,   0 }, { 198,  66, 162 }, // ng -> ng_Latn_NA
    { 199,   0,   0 }, { 199,  29, 164 }, // ne -> ne_Deva_NP
    { 200,   0,   0 }, { 200,  29, 164 }, // new -> new_Deva_NP
    { 201,   0,   0 }, { 201,  66,  40 }, // nnh -> nnh_Latn_CM
    { 202,   0,   0 }, { 202,  66,  40 }, // jgo -> jgo_Latn_CM
    { 203,   0,   0 }, { 203,  66, 169 }, // pcm -> pcm_Latn_NG
    { 204,   0,   0 }, { 204,  90, 102 }, // nqo -> nqo_Nkoo_GN
    { 205,   0,   0 }, { 205,   4, 112 }, // lrc -> lrc_Arab_IR
    { 206,   0,   0 }, { 206,  66, 175 }, // se -> se_Latn_NO
    { 207,   0,   0 }, { 207,  66, 216 }, // nso -> nso_Latn_ZA
    { 208,   0,   0 }, { 208,  66, 261 }, // nd -> nd_Latn_ZW
    { 209,   0,   0 }, { 209,  66, 175 }, // nb -> nb_Latn_NO
    { 210,   0,   0 }, { 210,  66, 175 }, // nn -> nn_Latn_NO
    { 211,   0,   0 }, { 211,  66, 219 }, // nus -> nus_Latn_SS
    { 212,   0,   0 }, { 212,  66, 142 }, // ny -> ny_Latn_MW
    { 213,   0,   0 }, { 213,  66, 243 }, // nyn -> nyn_Latn_UG
    { 214,   0,   0 }, { 214,  66,  84 }, // oc -> oc_Latn_FR
    { 215,   0,   0 }, { 215,  91, 110 }, // or -> or_Orya_IN
    { 217,   0,   0 }, { 217,  92, 114 }, // sga -> sga_Ogam_IE
    { 218,   0,   0 }, { 218, 111, 225 }, // non -> non_Runr_SE
    { 219,   0,   0 }, { 219,  98, 112 }, // peo -> peo_Xpeo_IR
    { 220,   0,   0 }, { 220,  66,  77 }, // om -> om_Latn_ET
    { 221,   0,   0 }, { 221, 101, 248 }, // osa -> osa_Osge_US
    { 222,   0,   0 }, { 222,  27,  90 }, // os -> os_Cyrl_GE
    { 223, 109,   0 }, { 223, 109,  50 }, // pal_Phlp -> pal_Phlp_CN
    { 223,   0,   0 }, { 223,  50, 112 }, // pal -> pal_Phli_IR
    { 224,   0,   0 }, { 224,  66, 179 }, // pau -> pau_Latn_PW
    { 226,   0,   0 }, { 226,  66,  13 }, // pap -> pap_Latn_AW
    { 227,   0,   0 }, { 227,   4,   1 }, // ps -> ps_Arab_AF
    { 228,   0,   0 }, { 228,   4, 112 }, // fa -> fa_Arab_IR
    { 229,   0,   0 }, { 229, 107, 132 }, // phn -> phn_Phnx_LB
    { 230,   0,   0 }, { 230,  66, 187 }, // pl -> pl_Latn_PL
    { 231,   0,   0 }, { 231,  66,  32 }, // pt -> pt_Latn_BR
    { 232,   0,   0 }, { 232,  66, 258 }, // prg -> prg_Latn_001
    { 233,   0, 178 }, { 233,   4, 178 }, // pa_PK -> pa_Arab_PK
    { 233,   4,   0 }, { 233,   4, 178 }, // pa_Arab -> pa_Arab_PK
    { 233,   0,   0 }, { 233,  41, 110 }, // pa -> pa_Guru_IN
    { 234,   0,   0 }, { 234,  66, 184 }, // qu -> qu_Latn_PE
    { 235,   0,   0 }, { 235,  66, 192 }, // ro -> ro_Latn_RO
    { 236,   0,   0 }, { 236,  66, 226 }, // rm -> rm_Latn_CH
    { 237,   0,   0 }, { 237,  66, 230 }, // rof -> rof_Latn_TZ
    { 238,   0,   0 }, { 238,  66,  38 }, // rn -> rn_Latn_BI
    { 239,   0,   0 }, { 239,  27, 193 }, // ru -> ru_Cyrl_RU
    { 240,   0,   0 }, { 240,  66, 230 }, // rwk -> rwk_Latn_TZ
    { 241,   0,   0 }, { 241,  66,  74 }, // ssy -> ssy_Latn_ER
    { 242,   0,   0 }, { 242,  27, 193 }, // sah -> sah_Cyrl_RU
    { 243,   0,   0 }, { 243,  66, 124 }, // saq -> saq_Latn_KE
    { 244,   0,   0 }, { 244,  66, 202 }, // sm -> sm_Latn_WS
    { 245,   0,   0 }, { 245,  66,  46 }, // sg -> sg_Latn_CF
    { 246,   0,   0 }, { 246,  66, 230 }, // sbp -> sbp_Latn_TZ
    { 247,   0,   0 }, { 247,  29, 110 }, // sa -> sa_Deva_IN
    { 248,   0,   0 }, { 248,  93, 110 }, // sat -> sat_Olck_IN
    { 249,   0,   0 }, { 249,  66, 117 }, // sc -> sc_Latn_IT
    { 250,   0,   0 }, { 250, 113, 110 }, // saz -> saz_Saur_IN
    { 251,   0,   0 }, { 251,  66, 160 }, // seh -> seh_Latn_MZ
    { 252,   0, 157 }, { 252,  66, 157 }, // sr_ME -> sr_Latn_ME
    { 252,   0, 192 }, { 252,  66, 192 }, // sr_RO -> sr_Latn_RO
    { 252,   0, 193 }, { 252,  66, 193 }, // sr_RU -> sr_Latn_RU
    { 252,   0, 239 }, { 252,  66, 239 }, // sr_TR -> sr_Latn_TR
    { 252,   0,   0 }, { 252,  27, 207 }, // sr -> sr_Cyrl_RS
    { 253,   0,   0 }, { 253,  66, 230 }, // ksb -> ksb_Latn_TZ
    { 254,   0,   0 }, { 254,  66, 261 }, // sn -> sn_Latn_ZW
    { 255,   0,   0 }, { 255, 141,  50 }, // ii -> ii_Yiii_CN
    { 256,   0,   0 }, { 256,  66, 117 }, // scn -> scn_Latn_IT
    { 257,   0,   0 }, { 257,  66,  77 }, // sid -> sid_Latn_ET
    { 258,   0,   0 }, { 258,  66, 187 }, // szl -> szl_Latn_PL
    { 259,  29,   0 }, { 259,  29, 110 }, // sd_Deva -> sd_Deva_IN
    { 259,  61,   0 }, { 259,  61, 110 }, // sd_Khoj -> sd_Khoj_IN
    { 259,  62,   0 }, { 259,  62, 110 }, // sd_Sind -> sd_Sind_IN
    { 259,   0,   0 }, { 259,   4, 178 }, // sd -> sd_Arab_PK
    { 260,   0,   0 }, { 260, 119, 221 }, // si -> si_Sinh_LK
    { 261,   0,   0 }, { 261,  66,  83 }, // sms -> sms_Latn_FI
    { 262,   0,   0 }, { 262,  66, 212 }, // sk -> sk_Latn_SK
    { 263,   0,   0 }, { 263,  66, 213 }, // sl -> sl_Latn_SI
    { 264,   0,   0 }, { 264,  66, 243 }, // xog -> xog_Latn_UG
    { 265,   0,   0 }, { 265,  66, 215 }, // so -> so_Latn_SO
    { 266,   0,   0 }, { 266,   4, 112 }, // sdh -> sdh_Arab_IR
    { 267,   0,   0 }, { 267,  66, 225 }, // sma -> sma_Latn_SE
    { 268,   0,   0 }, { 268,  66, 216 }, // st -> st_Latn_ZA
    { 269,   0,   0 }, { 269,  66, 216 }, // nr -> nr_Latn_ZA
    { 270,   0,   0 }, { 270,  66, 220 }, // es -> es_Latn_ES
    { 271,   0,   0 }, { 271, 135, 159 }, // zgh -> zgh_Tfng_MA
    { 272,   0,   0 }, { 272,  66, 111 }, // su -> su_Latn_ID
    { 273,   0,   0 }, { 273,  66, 230 }, // sw -> sw_Latn_TZ
    { 274,   0,   0 }, { 274,  66, 216 }, // ss -> ss_Latn_ZA
    { 275,   0,   0 }, { 275,  66, 225 }, // sv -> sv_Latn_SE
    { 276,   0,   0 }, { 276,  66, 226 }, // gsw -> gsw_Latn_CH
    { 277,   0,   0 }, { 277, 123, 113 }, // syr -> syr_Syrc_IQ
    { 278,   0,   0 }, { 278, 135, 159 }, // shi -> shi_Tfng_MA
    { 279,   0,   0 }, { 279,  66,  86 }, // ty -> ty_Latn_PF
    { 280,   0,   0 }, { 280, 127, 255 }, // blt -> blt_Tavt_VN
    { 281,   0,   0 }, { 281,  66, 124 }, // dav -> dav_Latn_KE
    { 282,   0, 178 }, { 282,   4, 178 }, // tg_PK -> tg_Arab_PK
    { 282,   4,   0 }, { 282,   4, 178 }, // tg_Arab -> tg_Arab_PK
    { 282,   0,   0 }, { 282,  27, 229 }, // tg -> tg_Cyrl_TJ
    { 283,   0,   0 }, { 283, 129, 110 }, // ta -> ta_Taml_IN
    { 284,   0,   0 }, { 284,  66, 228 }, // trv -> trv_Latn_TW
    { 285,   0,   0 }, { 285,  66, 170 }, // twq -> twq_Latn_NE
    { 286,   0,   0 }, { 286,  27, 193 }, // tt -> tt_Cyrl_RU
    { 287,   0,   0 }, { 287, 131, 110 }, // te -> te_Telu_IN
    { 288,   0,   0 }, { 288,  66, 243 }, // teo -> teo_Latn_UG
    { 289,   0,   0 }, { 289, 133, 231 }, // th -> th_Thai_TH
    { 290,   0,   0 }, { 290, 134,  50 }, // bo -> bo_Tibt_CN
    { 291,   0,   0 }, { 291,  33,  74 }, // tig -> tig_Ethi_ER
    { 292,   0,   0 }, { 292,  33,  77 }, // ti -> ti_Ethi_ET
    { 293,   0,   0 }, { 293,  66, 234 }, // tkl -> tkl_Latn_TK
    { 294,   0,   0 }, { 294,  66, 182 }, // tpi -> tpi_Latn_PG
    { 295,   0,   0 }, { 295,  66, 235 }, // to -> to_Latn_TO
    { 296,   0,   0 }, { 296,  66, 216 }, // ts -> ts_Latn_ZA
    { 297,   0,   0 }, { 297,  66, 216 }, // tn -> tn_Latn_ZA
    { 298,   0,   0 }, { 298,  66, 239 }, // tr -> tr_Latn_TR
    { 299,   0,   0 }, { 299,  66, 240 }, // tk -> tk_Latn_TM
    { 300,   0,   0 }, { 300,  66, 242 }, // tvl -> tvl_Latn_TV
    { 301,   0,   0 }, { 301,  66, 169 }, // kcg -> kcg_Latn_NG
    { 302,   0,   0 }, { 302, 138, 227 }, // uga -> uga_Ugar_SY
    { 303,   0,   0 }, { 303,  27, 244 }, // uk -> uk_Cyrl_UA
    { 304,   0,   0 }, { 304,  66,  91 }, // hsb -> hsb_Latn_DE
    { 305,   0,   0 }, { 305,   4, 178 }, // ur -> ur_Arab_PK
    { 306,   0, 123 }, { 306,  27, 123 }, // ug_KZ -> ug_Cyrl_KZ
    { 306,   0, 156 }, { 306,  27, 156 }, // ug_MN -> ug_Cyrl_MN
    { 306,  27,   0 }, { 306,  27, 123 }, // ug_Cyrl -> ug_Cyrl_KZ
    { 306,   0,   0 }, { 306,   4,  50 }, // ug -> ug_Arab_CN
    { 307,   0,   1 }, { 307,   4,   1 }, // uz_AF -> uz_Arab_AF
    { 307,   0,  50 }, { 307,  27,  50 }, // uz_CN -> uz_Cyrl_CN
    { 307,   4,   0 }, { 307,   4,   1 }, // uz_Arab -> uz_Arab_AF
    { 307,   0,   0 }, { 307,  66, 251 }, // uz -> uz_Latn_UZ
    { 308,   0,   0 }, { 308, 139, 134 }, // vai -> vai_Vaii_LR
    { 309,   0,   0 }, { 309,  66, 216 }, // ve -> ve_Latn_ZA
    { 310,   0,   0 }, { 310,  66, 255 }, // vi -> vi_Latn_VN
    { 311,   0,   0 }, { 311,  66, 258 }, // vo -> vo_Latn_001
    { 312,   0,   0 }, { 312,  66, 230 }, // vun -> vun_Latn_TZ
    { 313,   0,   0 }, { 313,  66,  23 }, // wa -> wa_Latn_BE
    { 314,   0,   0 }, { 314,  66, 226 }, // wae -> wae_Latn_CH
    { 315,   0,   0 }, { 315,  66,  15 }, // wbp -> wbp_Latn_AU
    { 316,   0,   0 }, { 316,  66, 246 }, // cy -> cy_Latn_GB
    { 317,   0,   0 }, { 317,   4, 178 }, // bgn -> bgn_Arab_PK
    { 318,   0,   0 }, { 318,  66, 165 }, // fy -> fy_Latn_NL
    { 319,   0,   0 }, { 319,  33,  77 }, // wal -> wal_Ethi_ET
    { 320,   0,   0 }, { 320,  66, 206 }, // wo -> wo_Latn_SN
    { 321,   0,   0 }, { 321,  66, 216 }, // xh -> xh_Latn_ZA
    { 322,   0,   0 }, { 322,  66,  40 }, // yav -> yav_Latn_CM
    { 323,   0,   0 }, { 323,  47, 258 }, // yi -> yi_Hebr_001
    { 324,   0,   0 }, { 324,  66, 169 }, // yo -> yo_Latn_NG
    { 325,   0,   0 }, { 325,  66, 170 }, // dje -> dje_Latn_NE
    { 326,   0,   0 }, { 326,  66,  50 }, // za -> za_Latn_CN
    { 327,   0,   0 }, { 327,  66, 216 }, // zu -> zu_Latn_ZA
    {   0,  66,   1 }, { 299,  66,   1 }, // und_Latn_AF -> tk_Latn_AF
    {   0,   0,   1 }, { 228,   4,   1 }, // und_AF -> fa_Arab_AF
    {   0,   0,   2 }, { 275,  66,   2 }, // und_AX -> sv_Latn_AX
    {   0,  27,   3 }, { 169,  27,   3 }, // und_Cyrl_AL -> mk_Cyrl_AL
    {   0,   0,   3 }, {   9,  66,   3 }, // und_AL -> sq_Latn_AL
    {   0,  66,   4 }, {  85,  66,   4 }, // und_Latn_DZ -> fr_Latn_DZ
    {   0,   0,   4 }, {  14,   4,   4 }, // und_DZ -> ar_Arab_DZ
    {   0,   0,   5 }, { 244,  66,   5 }, // und_AS -> sm_Latn_AS
    {   0,   0,   6 }, {  48,  66,   6 }, // und_AD -> ca_Latn_AD
    {   0,   0,   7 }, { 231,  66,   7 }, // und_AO -> pt_Latn_AO
    {   0,   0,   9 }, {   0,  66,   9 }, // und_AQ -> und_Latn_AQ
    {   0,   0,  11 }, { 270,  66,  11 }, // und_AR -> es_Latn_AR
    {   0,  66,  12 }, { 148,  66,  12 }, // und_Latn_AM -> ku_Latn_AM
    {   0,   0,  12 }, {  17,   5,  12 }, // und_AM -> hy_Armn_AM
    {   0,   0,  13 }, {  72,  66,  13 }, // und_AW -> nl_Latn_AW
    {   0,   0,  16 }, {  94,  66,  16 }, // und_AT -> de_Latn_AT
    {   0,   0,  17 }, {  25,  66,  17 }, // und_AZ -> az_Latn_AZ
    {   0,   0,  19 }, {  14,   4,  19 }, // und_BH -> ar_Arab_BH
    {   0,   0,  20 }, {  30,   9,  20 }, // und_BD -> bn_Beng_BD
    {   0,   0,  22 }, {  35,  27,  22 }, // und_BY -> be_Cyrl_BY
    {   0,   0,  23 }, {  72,  66,  23 }, // und_BE -> nl_Latn_BE
    {   0,   0,  25 }, {  85,  66,  25 }, // und_BJ -> fr_Latn_BJ
    {   0,  29,  27 }, { 199,  29,  27 }, // und_Deva_BT -> ne_Deva_BT
    {   0,   0,  27 }, {  73, 134,  27 }, // und_BT -> dz_Tibt_BT
    {   0,   0,  28 }, { 270,  66,  28 }, // und_BO -> es_Latn_BO
    {   0,  27,  29 }, { 252,  27,  29 }, // und_Cyrl_BA -> sr_Cyrl_BA
    {   0,   0,  29 }, {  42,  66,  29 }, // und_BA -> bs_Latn_BA
    {   0,   0,  31 }, {   0,  66,  31 }, // und_BV -> und_Latn_BV
    {   0,   0,  32 }, { 231,  66,  32 }, // und_BR -> pt_Latn_BR
    {   0,   0,  35 }, { 176,  66,  35 }, // und_BN -> ms_Latn_BN
    {   0,   0,  36 }, {  45,  27,  36 }, // und_BG -> bg_Cyrl_BG
    {   0,   0,  37 }, {  85,  66,  37 }, // und_BF -> fr_Latn_BF
    {   0,   0,  38 }, { 238,  66,  38 }, // und_BI -> rn_Latn_BI
    {   0,   0,  39 }, { 135,  60,  39 }, // und_KH -> km_Khmr_KH
    {   0,   0,  40 }, {  85,  66,  40 }, // und_CM -> fr_Latn_CM
    {   0,  47,  41 }, { 323,  47,  41 }, // und_Hebr_CA -> yi_Hebr_CA
    {   0,   0,  42 }, { 270,  66,  42 }, // und_IC -> es_Latn_IC
    {   0,   0,  43 }, { 231,  66,  43 }, // und_CV -> pt_Latn_CV
    {   0,   0,  44 }, { 226,  66,  44 }, // und_BQ -> pap_Latn_BQ
    {   0,   0,  46 }, {  85,  66,  46 }, // und_CF -> fr_Latn_CF
    {   0,   0,  47 }, { 270,  66,  47 }, // und_EA -> es_Latn_EA
    {   0,   0,  48 }, {  85,  66,  48 }, // und_TD -> fr_Latn_TD
    {   0,   0,  49 }, { 270,  66,  49 }, // und_CL -> es_Latn_CL
    {   0,   4,  50 }, { 306,   4,  50 }, // und_Arab_CN -> ug_Arab_CN
    {   0,  66,  50 }, { 326,  66,  50 }, // und_Latn_CN -> za_Latn_CN
    {   0,   0,  50 }, {  58, 118,  50 }, // und_CN -> zh_Hans_CN
    {   0,   0,  52 }, {   0,  66,  52 }, // und_CP -> und_Latn_CP
    {   0,   4,  53 }, { 176,   4,  53 }, // und_Arab_CC -> ms_Arab_CC
    {   0,   0,  54 }, { 270,  66,  54 }, // und_CO -> es_Latn_CO
    {   0,  66,  55 }, {  85,  66,  55 }, // und_Latn_KM -> fr_Latn_KM
    {   0,   0,  55 }, {  14,   4,  55 }, // und_KM -> ar_Arab_KM
    {   0,   0,  56 }, {  85,  66,  56 }, // und_CG -> fr_Latn_CG
    {   0,   0,  57 }, { 273,  66,  57 }, // und_CD -> sw_Latn_CD
    {   0,   0,  59 }, { 270,  66,  59 }, // und_CR -> es_Latn_CR
    {   0,   0,  60 }, {  66,  66,  60 }, // und_HR -> hr_Latn_HR
    {   0,   0,  61 }, { 270,  66,  61 }, // und_CU -> es_Latn_CU
    {   0,   0,  62 }, { 226,  66,  62 }, // und_CW -> pap_Latn_CW
    {   0,  66,  63 }, { 298,  66,  63 }, // und_Latn_CY -> tr_Latn_CY
    {   0,   0,  63 }, {  96,  39,  63 }, // und_CY -> el_Grek_CY
    {   0,   0,  64 }, {  67,  66,  64 }, // und_CZ -> cs_Latn_CZ
    {   0,   0,  65 }, {  68,  66,  65 }, // und_DK -> da_Latn_DK
    {   0,   0,  67 }, {   3,  66,  67 }, // und_DJ -> aa_Latn_DJ
    {   0,   0,  69 }, { 270,  66,  69 }, // und_DO -> es_Latn_DO
    {   0,   0,  70 }, { 270,  66,  70 }, // und_EC -> es_Latn_EC
    {   0,   0,  71 }, {  14,   4,  71 }, // und_EG -> ar_Arab_EG
    {   0,   0,  72 }, { 270,  66,  72 }, // und_SV -> es_Latn_SV
    {   0,   0,  73 }, { 270,  66,  73 }, // und_GQ -> es_Latn_GQ
    {   0,   0,  74 }, { 292,  33,  74 }, // und_ER -> ti_Ethi_ER
    {   0,   0,  75 }, {  78,  66,  75 }, // und_EE -> et_Latn_EE
    {   0,  66,  77 }, {  75,  66,  77 }, // und_Latn_ET -> en_Latn_ET
    {   0,   0,  77 }, {  11,  33,  77 }, // und_ET -> am_Ethi_ET
    {   0,   0,  78 }, { 239,  27, 193 }, // und_150 -> ru_Cyrl_RU
    {   0,   0,  79 }, {  75,  66, 114 }, // und_EU -> en_Latn_IE
    {   0,   0,  81 }, {  81,  66,  81 }, // und_FO -> fo_Latn_FO
    {   0,   0,  83 }, {  84,  66,  83 }, // und_FI -> fi_Latn_FI
    {   0,   0,  84 }, {  85,  66,  84 }, // und_FR -> fr_Latn_FR
    {   0,   0,  85 }, {  85,  66,  85 }, // und_GF -> fr_Latn_GF
    {   0,   0,  86 }, {  85,  66,  86 }, // und_PF -> fr_Latn_PF
    {   0,   0,  87 }, {  85,  66,  87 }, // und_TF -> fr_Latn_TF
    {   0,   0,  88 }, {  85,  66,  88 }, // und_GA -> fr_Latn_GA
    {   0,  27,  90 }, { 222,  27,  90 }, // und_Cyrl_GE -> os_Cyrl_GE
    {   0,  66,  90 }, { 148,  66,  90 }, // und_Latn_GE -> ku_Latn_GE
    {   0,   0,  90 }, {  93,  35,  90 }, // und_GE -> ka_Geor_GE
    {   0,   0,  91 }, {  94,  66,  91 }, // und_DE -> de_Latn_DE
    {   0,   0,  92 }, {   6,  66,  92 }, // und_GH -> ak_Latn_GH
    {   0,  27,  94 }, { 169,  27,  94 }, // und_Cyrl_GR -> mk_Cyrl_GR
    {   0,   0,  94 }, {  96,  39,  94 }, // und_GR -> el_Grek_GR
    {   0,   0,  95 }, { 127,  66,  95 }, // und_GL -> kl_Latn_GL
    {   0,   0,  97 }, {  85,  66,  97 }, // und_GP -> fr_Latn_GP
    {   0,   0,  99 }, { 270,  66,  99 }, // und_GT -> es_Latn_GT
    {   0,   0, 101 }, { 231,  66, 101 }, // und_GW -> pt_Latn_GW
    {   0,   0, 102 }, {  85,  66, 102 }, // und_GN -> fr_Latn_GN
    {   0,   0, 104 }, { 100,  66, 104 }, // und_HT -> ht_Latn_HT
    {   0,   0, 105 }, {   0,  66, 105 }, // und_HM -> und_Latn_HM
    {   0,   0, 106 }, { 270,  66, 106 }, // und_HN -> es_Latn_HN
    {   0,   0, 107 }, {  58, 137, 107 }, // und_HK -> zh_Hant_HK
    {   0,   0, 108 }, { 107,  66, 108 }, // und_HU -> hu_Latn_HU
    {   0,   0, 109 }, { 108,  66, 109 }, // und_IS -> is_Latn_IS
    {   0,   4, 110 }, { 305,   4, 110 }, // und_Arab_IN -> ur_Arab_IN
    {   0,   0, 110 }, { 105,  29, 110 }, // und_IN -> hi_Deva_IN
    {   0,   4, 111 }, { 176,   4, 111 }, // und_Arab_ID -> ms_Arab_ID
    {   0,   0, 111 }, { 112,  66, 111 }, // und_ID -> id_Latn_ID
    {   0,  66, 112 }, { 299,  66, 112 }, // und_Latn_IR -> tk_Latn_IR
    {   0,   0, 112 }, { 228,   4, 112 }, // und_IR -> fa_Arab_IR
    {   0,   0, 113 }, {  14,   4, 113 }, // und_IQ -> ar_Arab_IQ
    {   0,   0, 116 }, { 103,  47, 116 }, // und_IL -> he_Hebr_IL
    {   0,   0, 117 }, { 119,  66, 117 }, // und_IT -> it_Latn_IT
    {   0,   0, 118 }, {  85,  66, 118 }, // und_CI -> fr_Latn_CI
    {   0,   0, 120 }, { 120,  53, 120 }, // und_JP -> ja_Jpan_JP
    {   0,   0, 122 }, {  14,   4, 122 }, // und_JO -> ar_Arab_JO
    {   0,   0, 123 }, { 239,  27, 123 }, // und_KZ -> ru_Cyrl_KZ
    {   0,   0, 124 }, { 273,  66, 124 }, // und_KE -> sw_Latn_KE
    {   0,  27, 126 }, { 252,  27, 126 }, // und_Cyrl_XK -> sr_Cyrl_XK
    {   0,   0, 126 }, {   9,  66, 126 }, // und_XK -> sq_Latn_XK
    {   0,   0, 127 }, {  14,   4, 127 }, // und_KW -> ar_Arab_KW
    {   0,   0, 128 }, { 150,  27, 128 }, // und_KG -> ky_Cyrl_KG
    {   0,   0, 129 }, { 153,  65, 129 }, // und_LA -> lo_Laoo_LA
    {   0,   0, 130 }, { 270,  66, 130 }, // und_419 -> es_Latn_419
    {   0,   0, 131 }, { 155,  66, 131 }, // und_LV -> lv_Latn_LV
    {   0,   0, 132 }, {  14,   4, 132 }, // und_LB -> ar_Arab_LB
    {   0,   0, 133 }, { 268,  66, 133 }, // und_LS -> st_Latn_LS
    {   0,   0, 135 }, {  14,   4, 135 }, // und_LY -> ar_Arab_LY
    {   0,   0, 136 }, {  94,  66, 136 }, // und_LI -> de_Latn_LI
    {   0,   0, 137 }, { 160,  66, 137 }, // und_LT -> lt_Latn_LT
    {   0,   0, 138 }, {  85,  66, 138 }, // und_LU -> fr_Latn_LU
    {   0,  66, 139 }, { 231,  66, 139 }, // und_Latn_MO -> pt_Latn_MO
    {   0,   0, 139 }, {  58, 137, 139 }, // und_MO -> zh_Hant_MO
    {   0,  66, 140 }, {   9,  66, 140 }, // und_Latn_MK -> sq_Latn_MK
    {   0,   0, 140 }, { 169,  27, 140 }, // und_MK -> mk_Cyrl_MK
    {   0,   0, 141 }, { 174,  66, 141 }, // und_MG -> mg_Latn_MG
    {   0,   0, 143 }, { 176,  66, 143 }, // und_MY -> ms_Latn_MY
    {   0,   0, 144 }, {  69, 132, 144 }, // und_MV -> dv_Thaa_MV
    {   0,   0, 145 }, {  28,  66, 145 }, // und_ML -> bm_Latn_ML
    {   0,   0, 146 }, { 177,  66, 146 }, // und_MT -> mt_Latn_MT
    {   0,   0, 148 }, {  85,  66, 148 }, // und_MQ -> fr_Latn_MQ
    {   0,  66, 149 }, {  85,  66, 149 }, // und_Latn_MR -> fr_Latn_MR
    {   0,   0, 149 }, {  14,   4, 149 }, // und_MR -> ar_Arab_MR
    {   0,   4, 150 }, { 305,   4, 150 }, // und_Arab_MU -> ur_Arab_MU
    {   0,  29, 150 }, {  38,  29, 150 }, // und_Deva_MU -> bho_Deva_MU
    {   0,   0, 150 }, { 192,  66, 150 }, // und_MU -> mfe_Latn_MU
    {   0,   0, 151 }, {  85,  66, 151 }, // und_YT -> fr_Latn_YT
    {   0,   0, 152 }, { 270,  66, 152 }, // und_MX -> es_Latn_MX
    {   0,  27, 154 }, { 303,  27, 154 }, // und_Cyrl_MD -> uk_Cyrl_MD
    {   0,   0, 154 }, { 235,  66, 154 }, // und_MD -> ro_Latn_MD
    {   0,   0, 155 }, {  85,  66, 155 }, // und_MC -> fr_Latn_MC
    {   0,   4, 156 }, { 133,   4, 156 }, // und_Arab_MN -> kk_Arab_MN
    {   0,   0, 156 }, { 191,  27, 156 }, // und_MN -> mn_Cyrl_MN
    {   0,   0, 157 }, { 252,  66, 157 }, // und_ME -> sr_Latn_ME
    {   0,  66, 159 }, {  85,  66, 159 }, // und_Latn_MA -> fr_Latn_MA
    {   0,   0, 159 }, {  14,   4, 159 }, // und_MA -> ar_Arab_MA
    {   0,   0, 160 }, { 231,  66, 160 }, // und_MZ -> pt_Latn_MZ
    {   0,   0, 161 }, {  46,  86, 161 }, // und_MM -> my_Mymr_MM
    {   0,   0, 162 }, {   4,  66, 162 }, // und_NA -> af_Latn_NA
    {   0,   0, 164 }, { 199,  29, 164 }, // und_NP -> ne_Deva_NP
    {   0,   0, 165 }, {  72,  66, 165 }, // und_NL -> nl_Latn_NL
    {   0,   0, 166 }, {  85,  66, 166 }, // und_NC -> fr_Latn_NC
    {   0,   0, 168 }, { 270,  66, 168 }, // und_NI -> es_Latn_NI
    {   0,   4, 169 }, { 101,   4, 169 }, // und_Arab_NG -> ha_Arab_NG
    {   0,   0, 170 }, { 101,  66, 170 }, // und_NE -> ha_Latn_NE
    {   0,   0, 174 }, { 142,  63, 174 }, // und_KP -> ko_Kore_KP
    {   0,   0, 175 }, { 209,  66, 175 }, // und_NO -> nb_Latn_NO
    {   0,   0, 176 }, {  14,   4, 176 }, // und_OM -> ar_Arab_OM
    {   0,   0, 177 }, {  75,  66,  66 }, // und_QO -> en_Latn_DG
    {   0,   4, 178 }, { 305,   4, 178 }, // und_Arab_PK -> ur_Arab_PK
    {   0,   0, 178 }, { 305,   4, 178 }, // und_PK -> ur_Arab_PK
    {   0,   0, 179 }, { 224,  66, 179 }, // und_PW -> pau_Latn_PW
    {   0,   0, 180 }, {  14,   4, 180 }, // und_PS -> ar_Arab_PS
    {   0,   0, 181 }, { 270,  66, 181 }, // und_PA -> es_Latn_PA
    {   0,   0, 182 }, { 294,  66, 182 }, // und_PG -> tpi_Latn_PG
    {   0,   0, 183 }, {  97,  66, 183 }, // und_PY -> gn_Latn_PY
    {   0,   0, 184 }, { 270,  66, 184 }, // und_PE -> es_Latn_PE
    {   0,   0, 185 }, {  83,  66, 185 }, // und_PH -> fil_Latn_PH
    {   0,   0, 187 }, { 230,  66, 187 }, // und_PL -> pl_Latn_PL
    {   0,   0, 188 }, { 231,  66, 188 }, // und_PT -> pt_Latn_PT
    {   0,   0, 189 }, { 270,  66, 189 }, // und_PR -> es_Latn_PR
    {   0,   0, 190 }, {  14,   4, 190 }, // und_QA -> ar_Arab_QA
    {   0,   0, 191 }, {  85,  66, 191 }, // und_RE -> fr_Latn_RE
    {   0,  27, 192 }, {  45,  27, 192 }, // und_Cyrl_RO -> bg_Cyrl_RO
    {   0,   0, 192 }, { 235,  66, 192 }, // und_RO -> ro_Latn_RO
    {   0,   0, 193 }, { 239,  27, 193 }, // und_RU -> ru_Cyrl_RU
    {   0,   0, 194 }, { 138,  66, 194 }, // und_RW -> rw_Latn_RW
    {   0,   0, 195 }, {  85,  66, 195 }, // und_BL -> fr_Latn_BL
    {   0,   0, 199 }, {  85,  66, 199 }, // und_MF -> fr_Latn_MF
    {   0,   0, 200 }, {  85,  66, 200 }, // und_PM -> fr_Latn_PM
    {   0,   0, 202 }, { 244,  66, 202 }, // und_WS -> sm_Latn_WS
    {   0,   0, 203 }, { 119,  66, 203 }, // und_SM -> it_Latn_SM
    {   0,   0, 204 }, { 231,  66, 204 }, // und_ST -> pt_Latn_ST
    {   0,   0, 205 }, {  14,   4, 205 }, // und_SA -> ar_Arab_SA
    {   0,   0, 206 }, {  85,  66, 206 }, // und_SN -> fr_Latn_SN
    {   0,   0, 207 }, { 252,  27, 207 }, // und_RS -> sr_Cyrl_RS
    {   0,   0, 208 }, {  85,  66, 208 }, // und_SC -> fr_Latn_SC
    {   0,  27, 212 }, { 303,  27, 212 }, // und_Cyrl_SK -> uk_Cyrl_SK
    {   0,   0, 212 }, { 262,  66, 212 }, // und_SK -> sk_Latn_SK
    {   0,   0, 213 }, { 263,  66, 213 }, // und_SI -> sl_Latn_SI
    {   0,   0, 215 }, { 265,  66, 215 }, // und_SO -> so_Latn_SO
    {   0,   0, 217 }, {   0,  66, 217 }, // und_GS -> und_Latn_GS
    {   0,   0, 218 }, { 142,  63, 218 }, // und_KR -> ko_Kore_KR
    {   0,   0, 220 }, { 270,  66, 220 }, // und_ES -> es_Latn_ES
    {   0,   0, 221 }, { 260, 119, 221 }, // und_LK -> si_Sinh_LK
    {   0,   0, 222 }, {  14,   4, 222 }, // und_SD -> ar_Arab_SD
    {   0,   0, 223 }, {  72,  66, 223 }, // und_SR -> nl_Latn_SR
    {   0,   0, 224 }, { 209,  66, 224 }, // und_SJ -> nb_Latn_SJ
    {   0,  47, 225 }, { 323,  47, 225 }, // und_Hebr_SE -> yi_Hebr_SE
    {   0,   0, 225 }, { 275,  66, 225 }, // und_SE -> sv_Latn_SE
    {   0,   0, 226 }, {  94,  66, 226 }, // und_CH -> de_Latn_CH
    {   0,  66, 227 }, {  85,  66, 227 }, // und_Latn_SY -> fr_Latn_SY
    {   0,   0, 227 }, {  14,   4, 227 }, // und_SY -> ar_Arab_SY
    {   0,  66, 228 }, { 284,  66, 228 }, // und_Latn_TW -> trv_Latn_TW
    {   0,   0, 228 }, {  58, 137, 228 }, // und_TW -> zh_Hant_TW
    {   0,   4, 229 }, { 228,   4, 229 }, // und_Arab_TJ -> fa_Arab_TJ
    {   0,   0, 229 }, { 282,  27, 229 }, // und_TJ -> tg_Cyrl_TJ
    {   0,   0, 230 }, { 273,  66, 230 }, // und_TZ -> sw_Latn_TZ
    {   0,   0, 231 }, { 289, 133, 231 }, // und_TH -> th_Thai_TH
    {   0,   0, 232 }, { 231,  66, 232 }, // und_TL -> pt_Latn_TL
    {   0,   0, 233 }, {  85,  66, 233 }, // und_TG -> fr_Latn_TG
    {   0,   0, 234 }, { 293,  66, 234 }, // und_TK -> tkl_Latn_TK
    {   0,   0, 235 }, { 295,  66, 235 }, // und_TO -> to_Latn_TO
    {   0,  66, 238 }, {  85,  66, 238 }, // und_Latn_TN -> fr_Latn_TN
    {   0,   0, 238 }, {  14,   4, 238 }, // und_TN -> ar_Arab_TN
    {   0,   4, 239 }, {  25,   4, 239 }, // und_Arab_TR -> az_Arab_TR
    {   0,   0, 239 }, { 298,  66, 239 }, // und_TR -> tr_Latn_TR
    {   0,   0, 240 }, { 299,  66, 240 }, // und_TM -> tk_Latn_TM
    {   0,   0, 242 }, { 300,  66, 242 }, // und_TV -> tvl_Latn_TV
    {   0,   0, 243 }, { 273,  66, 243 }, // und_UG -> sw_Latn_UG
    {   0,  47, 244 }, { 323,  47, 244 }, // und_Hebr_UA -> yi_Hebr_UA
    {   0,  66, 244 }, { 230,  66, 244 }, // und_Latn_UA -> pl_Latn_UA
    {   0,   0, 244 }, { 303,  27, 244 }, // und_UA -> uk_Cyrl_UA
    {   0,   0, 245 }, {  14,   4, 245 }, // und_AE -> ar_Arab_AE
    {   0,   4, 246 }, { 132,   4, 246 }, // und_Arab_GB -> ks_Arab_GB
    {   0,  47, 246 }, { 323,  47, 246 }, // und_Hebr_GB -> yi_Hebr_GB
    {   0,  47, 248 }, { 323,  47, 248 }, // und_Hebr_US -> yi_Hebr_US
    {   0,   0, 250 }, { 270,  66, 250 }, // und_UY -> es_Latn_UY
    {   0,   0, 251 }, { 307,  66, 251 }, // und_UZ -> uz_Latn_UZ
    {   0,   0, 252 }, {  39,  66, 252 }, // und_VU -> bi_Latn_VU
    {   0,   0, 253 }, { 119,  66, 253 }, // und_VA -> it_Latn_VA
    {   0,   0, 254 }, { 270,  66, 254 }, // und_VE -> es_Latn_VE
    {   0,   0, 255 }, { 310,  66, 255 }, // und_VN -> vi_Latn_VN
    {   0,   0, 256 }, {  85,  66, 256 }, // und_WF -> fr_Latn_WF
    {   0,   0, 257 }, {  14,   4, 257 }, // und_EH -> ar_Arab_EH
    {   0,   0, 259 }, {  14,   4, 259 }, // und_YE -> ar_Arab_YE
    {   0,   0, 261 }, { 254,  66, 261 }, // und_ZW -> sn_Latn_ZW
    {   0,   1,   0 }, {  87,   1, 102 }, // und_Adlm -> ff_Adlm_GN
    {   0,   4,   0 }, {  14,   4,  71 }, // und_Arab -> ar_Arab_EG
    {   0,   5,   0 }, {  17,   5,  12 }, // und_Armn -> hy_Armn_AM
    {   0,   6,   0 }, {  23,   6, 112 }, // und_Avst -> ae_Avst_IR
    {   0,   7,   0 }, {  27,   7, 111 }, // und_Bali -> ban_Bali_ID
    {   0,   8,   0 }, {  29,   8,  40 }, // und_Bamu -> bax_Bamu_CM
    {   0,   9,   0 }, {  30,   9,  20 }, // und_Beng -> bn_Beng_BD
    {   0,  11,   0 }, {  34,  11, 111 }, // und_Batk -> bbc_Batk_ID
    {   0,  12,   0 }, { 247,  12, 110 }, // und_Bhks -> sa_Bhks_IN
    {   0,  13,   0 }, {  58,  13, 228 }, // und_Bopo -> zh_Bopo_TW
    {   0,  15,   0 }, {  85,  15,  84 }, // und_Brai -> fr_Brai_FR
    {   0,  16,   0 }, {  44,  16, 111 }, // und_Bugi -> bug_Bugi_ID
    {   0,  18,   0 }, {  65,  18,  41 }, // und_Cans -> cr_Cans_CA
    {   0,  20,   0 }, { 156,  20, 193 }, // und_Aghb -> lez_Aghb_RU
    {   0,  21,   0 }, {  52,  21,  20 }, // und_Cakm -> ccp_Cakm_BD
    {   0,  23,   0 }, {  55,  23, 248 }, // und_Cher -> chr_Cher_US
    {   0,  24,   0 }, {  62,  24,  71 }, // und_Copt -> cop_Copt_EG
    {   0,  25,   0 }, {   7,  25, 113 }, // und_Xsux -> akk_Xsux_IQ
    {   0,  26,   0 }, {  13,  26,  63 }, // und_Cprt -> grc_Cprt_CY
    {   0,  27,   0 }, { 239,  27, 193 }, // und_Cyrl -> ru_Cyrl_RU
    {   0,  29,   0 }, { 105,  29, 110 }, // und_Deva -> hi_Deva_IN
    {   0,  30,   0 }, {  85,  30,  84 }, // und_Dupl -> fr_Dupl_FR
    {   0,  31,   0 }, {  12,  31,  71 }, // und_Egyp -> egy_Egyp_EG
    {   0,  32,   0 }, {   9,  32,   3 }, // und_Elba -> sq_Elba_AL
    {   0,  33,   0 }, {  11,  33,  77 }, // und_Ethi -> am_Ethi_ET
    {   0,  35,   0 }, {  93,  35,  90 }, // und_Geor -> ka_Geor_GE
    {   0,  36,   0 }, {  59,  36,  36 }, // und_Glag -> cu_Glag_BG
    {   0,  37,   0 }, {  95,  37, 244 }, // und_Goth -> got_Goth_UA
    {   0,  38,   0 }, { 247,  38, 110 }, // und_Gran -> sa_Gran_IN
    {   0,  39,   0 }, {  96,  39,  94 }, // und_Grek -> el_Grek_GR
    {   0,  40,   0 }, {  98,  40, 110 }, // und_Gujr -> gu_Gujr_IN
    {   0,  41,   0 }, { 233,  41, 110 }, // und_Guru -> pa_Guru_IN
    {   0,  42,   0 }, { 142,  42, 218 }, // und_Hang -> ko_Hang_KR
    {   0,  43,   0 }, {  58,  43,  50 }, // und_Hani -> zh_Hani_CN
    {   0,  45,   0 }, {  58,  45, 228 }, // und_Hanb -> zh_Hanb_TW
    {   0,  47,   0 }, { 103,  47, 116 }, // und_Hebr -> he_Hebr_IL
    {   0,  48,   0 }, { 120,  48, 120 }, // und_Hira -> ja_Hira_JP
    {   0,  49,   0 }, {  16,  49, 112 }, // und_Armi -> arc_Armi_IR
    {   0,  50,   0 }, { 223,  50, 112 }, // und_Phli -> pal_Phli_IR
    {   0,  52,   0 }, { 142,  52, 218 }, // und_Jamo -> ko_Jamo_KR
    {   0,  53,   0 }, { 120,  53, 120 }, // und_Jpan -> ja_Jpan_JP
    {   0,  54,   0 }, { 121,  54, 111 }, // und_Java -> jv_Java_ID
    {   0,  55,   0 }, {  38,  55, 110 }, // und_Kthi -> bho_Kthi_IN
    {   0,  56,   0 }, { 130,  56, 110 }, // und_Knda -> kn_Knda_IN
    {   0,  57,   0 }, { 120,  57, 120 }, // und_Kana -> ja_Kana_JP
    {   0,  60,   0 }, { 135,  60,  39 }, // und_Khmr -> km_Khmr_KH
    {   0,  61,   0 }, { 259,  61, 110 }, // und_Khoj -> sd_Khoj_IN
    {   0,  62,   0 }, { 259,  62, 110 }, // und_Sind -> sd_Sind_IN
    {   0,  63,   0 }, { 142,  63, 218 }, // und_Kore -> ko_Kore_KR
    {   0,  65,   0 }, { 153,  65, 129 }, // und_Laoo -> lo_Laoo_LA
    {   0,  70,   0 }, {  13,  70,  94 }, // und_Linb -> grc_Linb_GR
    {   0,  73,   0 }, { 105,  73, 110 }, // und_Mahj -> hi_Mahj_IN
    {   0,  74,   0 }, { 175,  74, 110 }, // und_Mlym -> ml_Mlym_IN
    {   0,  77,   0 }, { 290,  77,  50 }, // und_Marc -> bo_Marc_CN
    {   0,  78,   0 }, { 179,  78, 110 }, // und_Mtei -> mni_Mtei_IN
    {   0,  79,   0 }, { 187,  79, 209 }, // und_Mend -> men_Mend_SL
    {   0,  82,   0 }, { 183,  82, 110 }, // und_Modi -> mr_Modi_IN
    {   0,  83,   0 }, { 191,  83,  50 }, // und_Mong -> mn_Mong_CN
    {   0,  86,   0 }, {  46,  86, 161 }, // und_Mymr -> my_Mymr_MM
    {   0,  87,   0 }, {  16,  87, 122 }, // und_Nbat -> arc_Nbat_JO
    {   0,  88,   0 }, { 200,  88, 164 }, // und_Newa -> new_Newa_NP
    {   0,  90,   0 }, { 178,  90, 102 }, // und_Nkoo -> man_Nkoo_GN
    {   0,  91,   0 }, { 215,  91, 110 }, // und_Orya -> or_Orya_IN
    {   0,  92,   0 }, { 217,  92, 114 }, // und_Ogam -> sga_Ogam_IE
    {   0,  93,   0 }, { 248,  93, 110 }, // und_Olck -> sat_Olck_IN
    {   0,  94,   0 }, { 107,  94, 108 }, // und_Hung -> hu_Hung_HU
    {   0,  97,   0 }, { 139,  97, 193 }, // und_Perm -> kv_Perm_RU
    {   0,  98,   0 }, { 219,  98, 112 }, // und_Xpeo -> peo_Xpeo_IR
    {   0, 101,   0 }, { 221, 101, 248 }, // und_Osge -> osa_Osge_US
    {   0, 102,   0 }, { 265, 102, 215 }, // und_Osma -> so_Osma_SO
    {   0, 104,   0 }, {  16, 104, 227 }, // und_Palm -> arc_Palm_SY
    {   0, 106,   0 }, { 159, 106,  50 }, // und_Phag -> lzh_Phag_CN
    {   0, 107,   0 }, { 229, 107, 132 }, // und_Phnx -> phn_Phnx_LB
    {   0, 109,   0 }, { 223, 109,  50 }, // und_Phlp -> pal_Phlp_CN
    {   0, 111,   0 }, { 218, 111, 225 }, // und_Runr -> non_Runr_SE
    {   0, 113,   0 }, { 250, 113, 110 }, // und_Saur -> saz_Saur_IN
    {   0, 114,   0 }, { 247, 114, 110 }, // und_Shrd -> sa_Shrd_IN
    {   0, 115,   0 }, {  75, 115, 246 }, // und_Shaw -> en_Shaw_GB
    {   0, 116,   0 }, { 247, 116, 110 }, // und_Sidd -> sa_Sidd_IN
    {   0, 117,   0 }, {  10, 117, 248 }, // und_Sgnw -> ase_Sgnw_US
    {   0, 118,   0 }, {  58, 118,  50 }, // und_Hans -> zh_Hans_CN
    {   0, 119,   0 }, { 260, 119, 221 }, // und_Sinh -> si_Sinh_LK
    {   0, 121,   0 }, { 272, 121, 111 }, // und_Sund -> su_Sund_ID
    {   0, 123,   0 }, { 277, 123, 113 }, // und_Syrc -> syr_Syrc_IQ
    {   0, 124,   0 }, {  83, 124, 185 }, // und_Tglg -> fil_Tglg_PH
    {   0, 127,   0 }, { 280, 127, 255 }, // und_Tavt -> blt_Tavt_VN
    {   0, 128,   0 }, {  70, 128, 110 }, // und_Takr -> doi_Takr_IN
    {   0, 129,   0 }, { 283, 129, 110 }, // und_Taml -> ta_Taml_IN
    {   0, 131,   0 }, { 287, 131, 110 }, // und_Telu -> te_Telu_IN
    {   0, 132,   0 }, {  69, 132, 144 }, // und_Thaa -> dv_Thaa_MV
    {   0, 133,   0 }, { 289, 133, 231 }, // und_Thai -> th_Thai_TH
    {   0, 134,   0 }, { 290, 134,  50 }, // und_Tibt -> bo_Tibt_CN
    {   0, 135,   0 }, { 271, 135, 159 }, // und_Tfng -> zgh_Tfng_MA
    {   0, 136,   0 }, { 171, 136, 110 }, // und_Tirh -> mai_Tirh_IN
    {   0, 137,   0 }, {  58, 137, 228 }, // und_Hant -> zh_Hant_TW
    {   0, 138,   0 }, { 302, 138, 227 }, // und_Ugar -> uga_Ugar_SY
    {   0, 139,   0 }, { 308, 139, 134 }, // und_Vaii -> vai_Vaii_LR
    {   0, 141,   0 }, { 255, 141,  50 }  // und_Yiii -> ii_Yiii_CN
};

static const quint16 locale_index[] = {
     0, // AnyLanguage
     0, // C
     0, // Abkhazian
     1, // Afar
     2, // Afrikaans
     4, // Aghem
     5, // Akan
     0, // Akkadian
     6, // Akoose
     7, // Albanian
     0, // American Sign Language
    10, // Amharic
     0, // Ancient Egyptian
     0, // Ancient Greek
    11, // Arabic
    39, // Aragonese
     0, // Aramaic
    40, // Armenian
    41, // Assamese
    42, // Asturian
    43, // Asu
    44, // Atsam
     0, // Avaric
     0, // Avestan
     0, // Aymara
    45, // Azerbaijani
    48, // Bafia
     0, // Balinese
    49, // Bambara
     0, // Bamun
    51, // Bangla
    53, // Basaa
    54, // Bashkir
    55, // Basque
     0, // Batak Toba
    56, // Belarusian
    57, // Bemba
    58, // Bena
     0, // Bhojpuri
     0, // Bislama
    59, // Blin
    60, // Bodo
    61, // Bosnian
    63, // Breton
     0, // Buginese
    64, // Bulgarian
    65, // Burmese
    66, // Cantonese
    68, // Catalan
    72, // Cebuano
    73, // Central Atlas Tamazight
    74, // Central Kurdish
    76, // Chakma
     0, // Chamorro
    78, // Chechen
    79, // Cherokee
    80, // Chickasaw
    81, // Chiga
    82, // Chinese
    89, // Church
    90, // Chuvash
    91, // Colognian
     0, // Coptic
    92, // Cornish
    93, // Corsican
     0, // Cree
    94, // Croatian
    96, // Czech
    97, // Danish
    99, // Divehi
   100, // Dogri
   101, // Duala
   102, // Dutch
   109, // Dzongkha
   110, // Embu
   111, // English
   217, // Erzya
   218, // Esperanto
   219, // Estonian
   220, // Ewe
   222, // Ewondo
   223, // Faroese
     0, // Fijian
   225, // Filipino
   226, // Finnish
   227, // French
   273, // Friulian
   274, // Fulah
   298, // Gaelic
   299, // Ga
   300, // Galician
   301, // Ganda
   302, // Geez
   303, // Georgian
   304, // German
     0, // Gothic
   311, // Greek
   313, // Guarani
   314, // Gujarati
   315, // Gusii
     0, // Haitian
   316, // Hausa
   320, // Hawaiian
   321, // Hebrew
     0, // Herero
   322, // Hindi
     0, // Hiri Motu
   324, // Hungarian
   325, // Icelandic
   326, // Ido
   327, // Igbo
   328, // Inari Sami
   329, // Indonesian
     0, // Ingush
   330, // Interlingua
     0, // Interlingue
   331, // Inuktitut
     0, // Inupiaq
   333, // Irish
   335, // Italian
   339, // Japanese
   340, // Javanese
   341, // Jju
   342, // Jola Fonyi
   343, // Kabuverdianu
   344, // Kabyle
   345, // Kako
   346, // Kalaallisut
   347, // Kalenjin
   348, // Kamba
   349, // Kannada
     0, // Kanuri
   350, // Kashmiri
   352, // Kazakh
   353, // Kenyang
   354, // Khmer
   355, // Kiche
   356, // Kikuyu
   357, // Kinyarwanda
     0, // Komi
     0, // Kongo
   358, // Konkani
   359, // Korean
     0, // Koro
   361, // Koyraboro Senni
   362, // Koyra Chiini
   363, // Kpelle
     0, // Kuanyama
   364, // Kurdish
   365, // Kwasio
   366, // Kyrgyz
   367, // Lakota
   368, // Langi
   369, // Lao
   370, // Latin
   371, // Latvian
     0, // Lezghian
     0, // Limburgish
   372, // Lingala
     0, // Literary Chinese
   376, // Lithuanian
   377, // Lojban
   378, // Lower Sorbian
   379, // Low German
   381, // Luba Katanga
   382, // Lule Sami
   383, // Luo
   384, // Luxembourgish
   385, // Luyia
   386, // Macedonian
   387, // Machame
   388, // Maithili
   389, // Makhuwa Meetto
   390, // Makonde
   391, // Malagasy
   392, // Malayalam
   393, // Malay
   398, // Maltese
     0, // Mandingo
   399, // Manipuri
   401, // Manx
   402, // Maori
   403, // Mapuche
   404, // Marathi
     0, // Marshallese
   405, // Masai
   407, // Mazanderani
     0, // Mende
   408, // Meru
   409, // Meta
   410, // Mohawk
   411, // Mongolian
   413, // Morisyen
   414, // Mundang
   415, // Muscogee
   416, // Nama
     0, // Nauru
   417, // Navajo
     0, // Ndonga
   418, // Nepali
     0, // Newari
   420, // Ngiemboon
   421, // Ngomba
   422, // Nigerian Pidgin
   423, // Nko
   424, // Northern Luri
   426, // Northern Sami
   429, // Northern Sotho
   430, // North Ndebele
   431, // Norwegian Bokmal
   433, // Norwegian Nynorsk
   434, // Nuer
   435, // Nyanja
   436, // Nyankole
   437, // Occitan
   438, // Odia
     0, // Ojibwa
     0, // Old Irish
     0, // Old Norse
     0, // Old Persian
   439, // Oromo
   441, // Osage
   442, // Ossetic
     0, // Pahlavi
     0, // Palauan
     0, // Pali
     0, // Papiamento
   444, // Pashto
   446, // Persian
     0, // Phoenician
   448, // Polish
   449, // Portuguese
   461, // Prussian
   462, // Punjabi
   464, // Quechua
   467, // Romanian
   469, // Romansh
   470, // Rombo
   471, // Rundi
   472, // Russian
   478, // Rwa
   479, // Saho
   480, // Sakha
   481, // Samburu
     0, // Samoan
   482, // Sango
   483, // Sangu
   484, // Sanskrit
   485, // Santali
   487, // Sardinian
     0, // Saurashtra
   488, // Sena
   489, // Serbian
   497, // Shambala
   498, // Shona
   499, // Sichuan Yi
   500, // Sicilian
   501, // Sidamo
   502, // Silesian
   503, // Sindhi
   505, // Sinhala
   506, // Skolt Sami
   507, // Slovak
   508, // Slovenian
   509, // Soga
   510, // Somali
   514, // Southern Kurdish
   515, // Southern Sami
   516, // Southern Sotho
   517, // South Ndebele
   518, // Spanish
   546, // Standard Moroccan Tamazight
   547, // Sundanese
   548, // Swahili
   552, // Swati
   553, // Swedish
   556, // Swiss German
   559, // Syriac
   560, // Tachelhit
     0, // Tahitian
   562, // Tai Dam
   563, // Taita
   564, // Tajik
   565, // Tamil
   569, // Taroko
   570, // Tasawaq
   571, // Tatar
   572, // Telugu
   573, // Teso
   575, // Thai
   576, // Tibetan
   578, // Tigre
   579, // Tigrinya
     0, // Tokelau
     0, // Tok Pisin
   581, // Tongan
   582, // Tsonga
   583, // Tswana
   584, // Turkish
   586, // Turkmen
     0, // Tuvalu
   587, // Tyap
     0, // Ugaritic
   588, // Ukrainian
   589, // Upper Sorbian
   590, // Urdu
   592, // Uyghur
   593, // Uzbek
   596, // Vai
   598, // Venda
   599, // Vietnamese
   600, // Volapuk
   601, // Vunjo
   602, // Walloon
   603, // Walser
   604, // Warlpiri
   605, // Welsh
   606, // Western Balochi
   607, // Western Frisian
   608, // Wolaytta
   609, // Wolof
   610, // Xhosa
   611, // Yangben
   612, // Yiddish
   613, // Yoruba
   615, // Zarma
     0, // Zhuang
   616, // Zulu
     0 // trailing 0
};

static const QLocaleData locale_data[] = {
   //  lang  script   terr lStrt lpMid lpEnd lPair lDelm  dec  group prcnt  zero minus plus   exp  qtOpn qtEnd altQO altQE lDFmt sDFmt lTFmt sTFmt slDay lDays ssDys sDays snDay nDays   am    pm   byte siQnt iecQn crSym crDsp crFmt crFNg ntLng ntTer                                                                                                                                                        currISO   curDgt curRnd dow1st  wknd+  wknd- grpTop grpMid grpEnd
    {      1,     0,     0,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    6,    7,    7,    8,    8,    0,   17,    0,    0,    0,    0,   56,   56,   83,   96,    0,    0,    0,    5,   22,    0,    0,    0,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  8, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  0,  0,  4,  0,  0,  0,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // C/AnyScript/AnyCountry
    {      3,    66,    77,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {69,84,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Afar/Latin/Ethiopia
    {      4,    66,   216,    0,    0,    7,    7,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,   54,   44,    0,    0,  109,  109,  166,  166,  193,  193,    2,    2,   45,    5,   22,    0,    0,    9,   13,    0,    9,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 57, 57, 27, 27, 13, 13,  3,  3,  5, 17, 23,  1, 20,  4,  6,  9, 11, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Afrikaans/Latin/South Africa
    {      4,    66,   162,    0,    0,    7,    7,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   44,   10,   22,  109,  109,  166,  166,  193,  193,    2,    2,   45,    5,   22,    1,   20,    9,   13,    0,   20,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 12,  7, 57, 57, 27, 27, 13, 13,  3,  3,  5, 17, 23,  1, 16,  4,  6,  9,  7, {78,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Afrikaans/Latin/Namibia
    {      5,    66,    40,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,    0,    0,  206,  206,  277,  277,  304,  304,    5,    5,    0,    5,   22,    2,   36,    0,    0,   27,   32,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 71, 71, 27, 27, 13, 13,  3,  3,  4, 17, 23,  4, 14,  4,  0,  5,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Aghem/Latin/Cameroon
    {      6,    66,    92,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   95,  113,   10,   22,  317,  317,  365,  365,  392,  392,    8,    8,    0,    5,   22,    6,   50,    9,    0,   39,   43,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 12,  7, 48, 48, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 10,  4,  0,  4,  5, {71,72,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Akan/Latin/Ghana
    {      8,    66,    40,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    2,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  4,  0,  5,  0,  0,  0, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Akoose/Latin/Cameroon
    {      9,    66,     3,    0,    0,   15,   15,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,    0,  121,   29,   22,  405,  405,  462,  489,  516,  516,   10,   10,   50,    5,   22,    9,   60,   19,   24,   48,   53,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 13,  7, 57, 57, 27, 27, 14, 14, 11, 10,  4, 17, 23,  4, 13,  5,  7,  5,  8, {65,76,76},      0,     0,     1,     6,     7,     2,     3,     3 }, // Albanian/Latin/Albania
    {      9,    66,   126,    0,    0,   15,   15,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,    0,  121,    0,    0,  405,  405,  462,  489,  516,  516,   10,   10,   50,    5,   22,   13,   73,   19,   24,   48,   61,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 10,  5, 57, 57, 27, 27, 14, 14, 11, 10,  4, 17, 23,  1,  6,  5,  7,  5,  6, {69,85,82},      2,     1,     1,     6,     7,     2,     3,     3 }, // Albanian/Latin/Kosovo
    {      9,    66,   140,    0,    0,   15,   15,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,    0,  121,    0,    0,  405,  405,  462,  489,  516,  516,   10,   10,   50,    5,   22,   14,   79,   19,   24,   48,   67,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 10,  5, 57, 57, 27, 27, 14, 14, 11, 10,  4, 17, 23,  3, 16,  5,  7,  5, 18, {77,75,68},      2,     1,     1,     6,     7,     2,     3,     3 }, // Albanian/Latin/Macedonia
    {     11,    33,    77,   24,   24,   30,   39,    6,    0,    1,    2,    3,    4,    5,    9,   17,   18,   19,   20,   27,  127,   10,   22,  530,  530,  557,  557,  583,  583,   21,   20,   54,   57,   22,   17,   95,    9,   13,   85,   89,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 27, 27, 26, 26, 13, 13,  3,  4,  3, 23, 23,  2,  9,  4,  6,  4,  5, {69,84,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Amharic/Ethiopic/Ethiopia
    {     14,     4,    71,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   19,  104,   19,    0,   94,  101,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5,  9,  5,  0,  7,  3, {69,71,80},      2,     1,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Egypt
    {     14,     4,     4,   47,   47,   47,   47,    6,    1,    0,   32,    3,   35,   37,    9,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   24,  113,    9,   13,   94,  104,  6,  6,  6,  6,  1,  1,  1,  3,  1,  2,  2,  1,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 12,  4,  6,  7,  7, {68,90,68},      2,     1,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Algeria
    {     14,     4,    19,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   29,  125,   19,    0,   94,  111,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 12,  5,  0,  7,  7, {66,72,68},      3,     0,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Bahrain
    {     14,     4,    48,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,    2,  137,   19,    0,   94,  118,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  4, 15,  5,  0,  7,  4, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Chad
    {     14,     4,    55,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,    0,    0,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,    3,  152,   19,    0,   94,  122,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 10,  5, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  2, 14,  5,  0,  7,  9, {75,77,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Comoros
    {     14,     4,    67,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   34,  166,   19,    0,   94,  131,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  3, 11,  5,  0,  7,  6, {68,74,70},      0,     0,     6,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Djibouti
    {     14,     4,    74,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   37,  177,   19,    0,   94,  137,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  3, 12,  5,  0,  7,  7, {69,82,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Eritrea
    {     14,     4,   113,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   40,  189,   19,    0,   94,  144,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 11,  5,  0,  7,  6, {73,81,68},      0,     0,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Iraq
    {     14,     4,   116,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,    1,    1,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   45,  200,   19,    0,   94,  150,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10,  9,  4, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  1, 18,  5,  0,  7,  7, {73,76,83},      2,     1,     7,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Israel
    {     14,     4,   122,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   46,  218,   19,    0,   94,  157,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 11,  5,  0,  7,  6, {74,79,68},      3,     0,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Jordan
    {     14,     4,   127,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   51,  229,   19,    0,   94,  163,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 11,  5,  0,  7,  6, {75,87,68},      3,     0,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Kuwait
    {     14,     4,   132,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   56,  240,   19,    0,   94,  169,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 11,  5,  0,  7,  5, {76,66,80},      0,     0,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Lebanon
    {     14,     4,   135,   47,   47,   47,   47,    6,    1,    0,   32,    3,   35,   37,    9,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   61,  251,    9,   13,   94,  174,  6,  6,  6,  6,  1,  1,  1,  3,  1,  2,  2,  1,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 10,  4,  6,  7,  5, {76,89,68},      3,     0,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Libya
    {     14,     4,   149,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   66,  261,   19,    0,   94,  179,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  4, 15,  5,  0,  7,  9, {77,82,85},      2,     1,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Mauritania
    {     14,     4,   159,   47,   47,   47,   47,    6,    1,    0,   32,    3,   35,   37,    9,   11,   10,   13,   12,  137,  154,    0,    0,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   70,  276,    9,   13,   94,  188,  6,  6,  6,  6,  1,  1,  1,  3,  1,  2,  2,  1,  1,  1,  1,  1, 17, 10, 10,  5, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 10,  4,  6,  7,  6, {77,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Morocco
    {     14,     4,   176,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   75,  286,   19,    0,   94,  194,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 10,  5,  0,  7,  5, {79,77,82},      3,     0,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Oman
    {     14,     4,   180,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   45,  200,   19,    0,   94,  199,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  1, 18,  5,  0,  7, 18, {73,76,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Palestinian Territories
    {     14,     4,   190,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   80,  296,   19,    0,   94,  217,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5,  9,  5,  0,  7,  3, {81,65,82},      2,     1,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Qatar
    {     14,     4,   205,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   85,  305,   19,    0,   94,  220,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 10,  5,  0,  7, 24, {83,65,82},      2,     1,     7,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Saudi Arabia
    {     14,     4,   215,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   90,  315,   19,    0,   94,  244,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  1, 10,  5,  0,  7,  7, {83,79,83},      0,     0,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Somalia
    {     14,     4,   219,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   91,  325,   19,    0,   94,  251,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  1, 17,  5,  0,  7, 12, {83,83,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/South Sudan
    {     14,     4,   222,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   92,  342,   19,    0,   94,  263,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  4, 11,  5,  0,  7,  7, {83,68,71},      2,     1,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Sudan
    {     14,     4,   227,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   96,  353,   19,    0,   94,  270,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 10,  5,  0,  7,  5, {83,89,80},      0,     0,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Syria
    {     14,     4,   238,   47,   47,   47,   47,    6,    1,    0,   32,    3,   35,   37,    9,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,  101,  363,    9,   13,   94,  275,  6,  6,  6,  6,  1,  1,  1,  3,  1,  2,  2,  1,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 11,  4,  6,  7,  4, {84,78,68},      3,     0,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Tunisia
    {     14,     4,   245,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,  106,  374,   19,    0,   94,  279,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 12,  5,  0,  7, 24, {65,69,68},      2,     1,     6,     5,     6,     1,     3,     3 }, // Arabic/Arabic/United Arab Emirates
    {     14,     4,   257,   47,   47,   47,   47,    6,    0,    1,   32,    3,   35,   37,    9,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,   70,  276,    9,   13,   94,  303,  6,  6,  6,  6,  1,  1,  1,  3,  1,  2,  2,  1,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5, 10,  4,  6,  7, 15, {77,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/Western Sahara
    {     14,     4,   258,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,    0,    0,   19,    0,  318,  340,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  0,  0,  5,  0, 22,  6,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // Arabic/Arabic/World
    {     14,     4,   259,   47,   47,   47,   47,   53,   21,   22,   23,   25,   26,   28,   30,   11,   10,   13,   12,  137,  154,   10,   22,  596,  596,  596,  596,  647,  647,   24,   24,   80,   84,   22,  111,  386,   19,    0,   94,  346,  6,  6,  6,  6,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 51, 51, 51, 51, 13, 13,  1,  1,  4, 47, 23,  5,  9,  5,  0,  7,  5, {89,69,82},      0,     0,     7,     5,     6,     1,     3,     3 }, // Arabic/Arabic/Yemen
    {     15,    66,   220,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   13,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Aragonese/Latin/Spain
    {     17,     5,    12,    0,    0,   54,   54,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   17,   18,  164,  184,    0,    0,  660,  660,  721,  721,  748,  748,    0,    0,  131,  137,   22,  116,  395,   19,    0,  351,  358,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  8, 10,  5, 61, 61, 27, 27, 13, 13,  2,  2,  6, 17, 23,  1, 13,  5,  0,  7,  8, {65,77,68},      2,     0,     1,     6,     7,     1,     3,     3 }, // Armenian/Armenian/Armenia
    {     18,     9,   110,    0,    0,   61,   61,    6,    0,    1,    2,   39,    4,    5,    9,   10,   11,   12,   13,  192,  210,   42,   42,  761,  761,  818,  818,  849,  849,   25,   25,  154,  158,   22,  117,  408,    4,    0,  366,  373,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 12,  7, 57, 57, 31, 31, 13, 13,  9,  7,  4, 37, 23,  1, 12,  5,  0,  7,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Assamese/Bangla/India
    {     19,    66,   220,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  218,   87,    0,    0,  862,  862,  915,  915,  942,  942,   34,   32,    0,    5,   22,   13,  420,   19,    0,  377,  386,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  6, 10,  5, 53, 53, 27, 27, 13, 13, 12, 11,  5, 17, 23,  1,  4,  5,  0,  9,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Asturian/Latin/Spain
    {     20,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,  955,  955, 1014, 1014, 1041, 1041,   46,   43,    0,    5,   22,  118,  424,   19,    0,  392,  398,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 59, 59, 27, 27, 13, 13,  9,  8,  4, 17, 23,  3, 21,  5,  0,  6,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Asu/Latin/Tanzania
    {     21,    66,   169,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  121,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Atsam/Latin/Nigeria
    {     25,    66,    17,    0,    0,   77,   77,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  240,  184,    0,    0, 1054, 1054, 1120, 1146,   96,   96,    0,    0,  195,    5,   22,  122,  445,   19,    0,  406,  416,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8, 10,  5, 66, 66, 26, 26, 13, 13,  2,  2,  4, 17, 23,  1, 17,  5,  0, 10, 10, {65,90,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Azerbaijani/Latin/Azerbaijan
    {     25,     4,   112,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {73,82,82},      0,     0,     6,     5,     5,     1,     3,     3 }, // Azerbaijani/Arabic/Iran
    {     25,    27,    17,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   19,   20,  240,  184,    0,    0, 1172, 1172, 1238, 1238,   96,   96,   55,   51,    0,    5,   22,  122,  462,   19,    0,  426,  436,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8, 10,  5, 66, 66, 26, 26, 13, 13,  2,  2,  4, 17, 23,  1,  5,  5,  0, 10, 10, {65,90,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Azerbaijani/Cyrillic/Azerbaijan
    {     26,    66,    40,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   12,   13,   71,   87,    0,    0, 1264, 1264, 1308, 1308, 1336, 1336,   57,   53,    0,    5,   22,    2,  467,   19,    0,  446,  451,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 44, 44, 28, 28, 13, 13,  6,  7,  4, 17, 23,  4,  4,  5,  0,  5,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Bafia/Latin/Cameroon
    {     28,    66,   145,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,   87,    0,    0, 1349, 1349, 1392, 1392, 1419, 1419,    0,    0,    0,    5,   22,    3,  471,    9,   13,  458,  467,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 43, 43, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 17,  4,  6,  9,  4, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Bambara/Latin/Mali
    {     28,    90,   145,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    3,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Bambara/Nko/Mali
    {     30,     9,    20,    0,    0,   85,   85,    6,    0,    1,    2,   39,    4,    5,    9,   10,   11,   12,   13,  192,   87,   10,   22, 1432, 1432, 1489, 1489, 1525, 1525,    0,    0,  154,    5,   22,  123,  488,    0,   31,  471,  476,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 57, 57, 36, 36, 17, 17,  2,  2,  4, 17, 23,  1, 14,  4,  6,  5,  8, {66,68,84},      2,     1,     7,     6,     7,     1,     2,     3 }, // Bangla/Bangla/Bangladesh
    {     30,     9,   110,    0,    0,   85,   85,    6,    0,    1,    2,   39,    4,    5,    9,   10,   11,   12,   13,  192,   87,   10,   22, 1432, 1432, 1489, 1489, 1525, 1525,    0,    0,  154,    5,   22,  117,  502,    0,   31,  471,  484,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 57, 57, 36, 36, 17, 17,  2,  2,  4, 17, 23,  1, 12,  4,  6,  5,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Bangla/Bangla/India
    {     31,    66,    40,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,   71,   87,    0,    0, 1542, 1542, 1611, 1611, 1638, 1638,   63,   60,    0,    5,   22,    2,  514,   19,    0,  488,  493,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 69, 69, 27, 27, 13, 13, 10,  9,  4, 17, 23,  4, 15,  5,  0,  5,  8, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Basaa/Latin/Cameroon
    {     32,    27,   193,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  124,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Bashkir/Cyrillic/Russia
    {     33,    66,   220,    0,    0,   94,   94,    6,    1,    0,    2,    3,   40,    5,    9,   10,   11,   10,   11,  257,  293,   54,    0, 1651, 1651, 1718, 1718, 1745, 1745,    0,    0,  199,    5,   22,   13,  529,   19,   24,  501,  508,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 36,  6, 12,  5, 67, 67, 27, 27, 13, 13,  2,  2,  7, 17, 23,  1,  5,  5,  7,  7,  8, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Basque/Latin/Spain
    {     35,    27,    22,    0,    0,  103,  103,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,  299,  185,   66,    0, 1758, 1758, 1813, 1813, 1833, 1833,    0,    0,  206,  211,   22,  125,  534,   19,    0,  516,  526,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  7, 11,  5, 55, 55, 20, 20, 13, 13,  2,  2,  5, 17, 23,  2, 16,  5,  0, 10,  8, {66,89,78},      2,     0,     1,     6,     7,     2,     3,     3 }, // Belarusian/Cyrillic/Belarus
    {     36,    66,   260,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22, 1846, 1846, 1846, 1846,   83,   83,   73,   69,    0,    5,   22,  127,    0,    9,   13,  534,  543,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 79, 79, 79, 79, 13, 13,  8,  7,  4, 17, 23,  1,  0,  4,  6,  9,  6, {90,77,87},      2,     1,     1,     6,     7,     1,     3,     3 }, // Bemba/Latin/Zambia
    {     37,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 1925, 1925, 2006, 2006, 2033, 2033,   81,   76,    0,    5,   22,  118,  550,    0,    0,  549,  555,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 81, 81, 27, 27, 13, 13,  7,  7,  4, 17, 23,  3, 22,  4,  0,  6, 10, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Bena/Latin/Tanzania
    {     40,    33,    74,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {69,82,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Blin/Ethiopic/Eritrea
    {     41,    29,   110,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22, 2046, 2046, 2099, 2099, 2131, 2131,   88,   83,    0,    5,   22,  117,  572,    4,    0,  565,  569,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 53, 53, 32, 32, 18, 18,  3,  6,  4, 17, 23,  1,  3,  5,  0,  4,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Bodo/Devanagari/India
    {     42,    66,    29,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   15,   11,   12,   13,  345,  364,    0,    0, 2149, 2149, 2206, 2206, 2233, 2246,   91,   89,  228,    5,   22,  128,  575,   19,    0,  573,  581,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19, 11, 10,  5, 57, 57, 27, 27, 13, 13, 10,  7,  7, 17, 23,  2, 40,  5,  0,  8, 19, {66,65,77},      2,     1,     1,     6,     7,     1,     3,     3 }, // Bosnian/Latin/Bosnia And Herzegovina
    {     42,    27,    29,    0,    0,  117,  117,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  375,  395,    0,    0, 2259, 2259, 2314, 2314, 2341, 2341,  101,   96,    0,    5,   22,  130,  615,   19,    0,  600,  608,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 55, 55, 27, 27, 13, 13, 11, 13,  4, 17, 23,  2, 19,  5,  0,  8, 19, {66,65,77},      2,     1,     1,     6,     7,     1,     3,     3 }, // Bosnian/Cyrillic/Bosnia And Herzegovina
    {     43,    66,    84,    0,    0,  124,  124,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,  127,    0,    0, 2354, 2354, 2396, 2396, 2428, 2428,  112,  109,  235,  242,  259,   13,  420,   19,    0,  627,  636,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 42, 42, 32, 32, 17, 17,  4,  4,  7, 17, 23,  1,  4,  5,  0,  9,  5, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Breton/Latin/France
    {     45,    27,    36,    0,    0,  117,  117,    6,    1,   14,    2,    3,    4,    5,    9,   15,   10,   15,   10,  299,  402,   77,   91, 2445, 2445, 2499, 2499, 2519, 2519,  116,  113,  282,    5,   22,  132,  634,   19,   24,  641,  650,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 12, 14,  9, 54, 54, 20, 20, 13, 13,  6,  6,  7, 17, 23,  3, 13,  5,  7,  9,  8, {66,71,78},      2,     1,     1,     6,     7,     2,     3,     3 }, // Bulgarian/Cyrillic/Bulgaria
    {     46,    86,   161,  132,  132,  138,  138,  134,    0,    1,    2,   41,    4,    5,    9,   10,   11,   12,   13,  414,  432,  100,  110, 2532, 2532, 2532, 2532, 2585, 2585,  122,  119,  289,    5,   22,  127,  647,    4,    0,  658,  658,  6,  6, 10, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  6, 53, 53, 53, 53, 13, 13,  5,  3,  5, 17, 23,  1, 11,  5,  0,  6,  6, {77,77,75},      0,     0,     7,     6,     7,     1,     3,     3 }, // Burmese/Myanmar/Myanmar
    {     47,   137,   107,  148,  148,  153,  153,    6,    0,    1,    2,    3,    4,    5,    9,   42,   43,   44,   45,  440,  454,  116,   27, 2598, 2598, 2598, 2598, 2625, 2625,  127,  122,    0,    5,   22,  135,  658,    9,   13,  664,  666,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 14,  8, 13,  6, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  2,  4,  6,  2, 14, {72,75,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Cantonese/Traditional Han/Hong Kong
    {     47,   118,    50,  148,  148,  153,  153,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  462,  454,  129,   27, 2598, 2598, 2638, 2638, 2625, 2625,  127,  122,    0,    5,   22,  138,  660,    9,   13,  680,  682,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 13,  8, 11,  6, 27, 27, 20, 20, 13, 13,  2,  2,  4, 17, 23,  1,  3,  4,  6,  2,  7, {67,78,89},      2,     1,     7,     6,     7,     1,     3,     3 }, // Cantonese/Simplified Han/China
    {     48,    66,   220,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  218,   87,   55,    1, 2658, 2658, 2717, 2717, 2744, 2744,  129,  124,    0,    5,   22,   13,  420,   19,   24,  689,  695,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  6, 11,  4, 59, 59, 27, 27, 20, 20,  5,  5,  5, 17, 23,  1,  4,  5,  7,  6,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Catalan/Latin/Spain
    {     48,    66,     6,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  218,   87,   55,    1, 2658, 2658, 2717, 2717, 2744, 2744,  129,  124,    0,    5,   22,   13,  420,   19,   24,  689,  702,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  6, 11,  4, 59, 59, 27, 27, 20, 20,  5,  5,  5, 17, 23,  1,  4,  5,  7,  6,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Catalan/Latin/Andorra
    {     48,    66,    84,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  218,   87,   55,    1, 2658, 2658, 2717, 2717, 2744, 2744,  129,  124,    0,    5,   22,   13,  420,   19,   24,  689,  709,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  6, 11,  4, 59, 59, 27, 27, 20, 20,  5,  5,  5, 17, 23,  1,  4,  5,  7,  6,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Catalan/Latin/France
    {     48,    66,   117,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  218,   87,   55,    1, 2658, 2658, 2717, 2717, 2744, 2744,  129,  124,    0,    5,   22,   13,  420,   19,   24,  689,  715,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  6, 11,  4, 59, 59, 27, 27, 20, 20,  5,  5,  5, 17, 23,  1,  4,  5,  7,  6,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Catalan/Latin/Italy
    {     49,    66,   185,    0,    0,  158,  167,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22, 2764, 2764, 2819, 2819, 2846, 2846,    0,    0,  294,    5,   22,  139,  663,    9,   13,  721,  729,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 55, 55, 27, 27, 13, 13,  2,  2,  8, 17, 23,  1, 15,  4,  6,  8,  9, {80,72,80},      2,     1,     7,     6,     7,     1,     3,     3 }, // Cebuano/Latin/Philippines
    {     50,    66,   159,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 2859, 2859, 2906, 2906, 2933, 2933,  134,  129,    0,    5,   22,    0,  678,   19,    0,  738,  755,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 47, 47, 27, 27, 13, 13,  9, 10,  4, 17, 23,  0, 15,  5,  0, 17,  6, {77,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Central Atlas Tamazight/Latin/Morocco
    {     51,     4,   113,    0,    0,    0,    0,   53,   21,   22,   23,   25,   46,   48,   30,   10,   11,   12,   13,   27,   44,   10,   22, 2946, 2946, 2946, 2946, 3003, 3003,  143,  139,    0,    5,   22,   40,  693,   19,    0,  761,  775,  6,  6,  6,  6,  1,  1,  1,  1,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 57, 57, 57, 57, 13, 13,  3,  3,  4, 17, 23,  5, 13,  5,  0, 14,  5, {73,81,68},      0,     0,     6,     5,     6,     1,     3,     3 }, // Central Kurdish/Arabic/Iraq
    {     51,     4,   112,    0,    0,    0,    0,   53,   21,   22,   23,   25,   46,   48,   30,   10,   11,   12,   13,   27,   44,    0,    0, 2946, 2946, 2946, 2946, 3003, 3003,  143,  139,    0,    5,   22,    0,  706,   19,    0,  761,  780,  6,  6,  6,  6,  1,  1,  1,  1,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 10,  5, 57, 57, 57, 57, 13, 13,  3,  3,  4, 17, 23,  0, 12,  5,  0, 14,  5, {73,82,82},      0,     0,     6,     5,     5,     1,     3,     3 }, // Central Kurdish/Arabic/Iran
    {     52,    21,    20,    0,    0,  175,  175,    6,    0,    1,    2,   50,    4,    5,    9,   10,   11,   12,   13,  192,   87,   10,   22, 3016, 3016, 3142, 3142, 3226, 3226,    0,    0,  302,    5,   22,  123,  718,    0,   31,  785,  797,  6,  6, 12, 12,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7,126,126, 84, 84, 38, 38,  2,  2,  8, 17, 23,  1, 21,  4,  6, 12, 14, {66,68,84},      2,     1,     7,     6,     7,     1,     2,     3 }, // Chakma/Chakma/Bangladesh
    {     52,    21,   110,    0,    0,  175,  175,    6,    0,    1,    2,   50,    4,    5,    9,   10,   11,   12,   13,  192,   87,   10,   22, 3016, 3016, 3142, 3142, 3226, 3226,    0,    0,  302,    5,   22,  117,  739,    0,   31,  785,  811,  6,  6, 12, 12,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7,126,126, 84, 84, 38, 38,  2,  2,  8, 17, 23,  1, 27,  4,  6, 12, 10, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Chakma/Chakma/India
    {     54,    27,   193,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 3264, 3264, 3308, 3308, 3332, 3308,    0,    0,    0,    5,   22,  124,  766,   19,    0,  821,  828,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 44, 44, 24, 24, 16, 24,  2,  2,  4, 17, 23,  1, 11,  5,  0,  7,  5, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Chechen/Cyrillic/Russia
    {     55,    23,   248,    0,    0,  187,  196,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22, 3348, 3348, 3396, 3396, 3423, 3423,  146,  142,  310,    5,   22,    1,  777,    9,   13,  833,  836,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 48, 48, 27, 27, 13, 13,  3,  6,  6, 17, 23,  1,  6,  4,  6,  3, 15, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Cherokee/Cherokee/United States
    {     56,    66,   248,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  140,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Chickasaw/Latin/United States
    {     57,    66,   243,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 3436, 3436, 3509, 3509, 3536, 3536,    0,    0,    0,    5,   22,  143,  783,    9,    0,  851,  857,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 73, 73, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 19,  4,  0,  6,  6, {85,71,88},      0,     0,     1,     7,     7,     1,     3,     3 }, // Chiga/Latin/Uganda
    {     58,   118,    50,  148,  148,  204,  204,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  462,  454,  129,   27, 2598, 2598, 2638, 2638, 2625, 2625,  127,  122,  316,    5,   22,  146,  660,    9,   13,  863,  867,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 13,  8, 11,  6, 27, 27, 20, 20, 13, 13,  2,  2,  2, 17, 23,  1,  3,  4,  6,  4,  2, {67,78,89},      2,     1,     7,     6,     7,     1,     3,     3 }, // Chinese/Simplified Han/China
    {     58,   118,   107,  148,  148,  204,  204,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  462,   87,  129,   27, 2598, 2598, 2638, 2638, 2625, 2625,  127,  122,  316,    5,   22,  135,  802,    9,   13,  863,  869,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 13,  6, 11,  6, 27, 27, 20, 20, 13, 13,  2,  2,  2, 17, 23,  3,  2,  4,  6,  4,  9, {72,75,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Chinese/Simplified Han/Hong Kong
    {     58,   118,   139,  148,  148,  204,  204,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  462,   87,  129,   27, 2598, 2598, 2638, 2638, 2625, 2625,  127,  122,  316,    5,   22,  147,  804,    9,   13,  863,  878,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 13,  6, 11,  6, 27, 27, 20, 20, 13, 13,  2,  2,  2, 17, 23,  4,  3,  4,  6,  4,  9, {77,79,80},      2,     1,     7,     6,     7,     1,     3,     3 }, // Chinese/Simplified Han/Macao
    {     58,   118,   210,  148,  148,  204,  204,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  462,  127,  129,   27, 2598, 2598, 2638, 2638, 2625, 2625,  127,  122,  316,    5,   22,    1,  807,    9,   13,  863,  887,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 13,  8, 11,  6, 27, 27, 20, 20, 13, 13,  2,  2,  2, 17, 23,  1,  4,  4,  6,  4,  3, {83,71,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Chinese/Simplified Han/Singapore
    {     58,   137,   107,  148,  148,  209,  209,    6,    0,    1,    2,    3,    4,    5,    9,   42,   43,   44,   45,  462,   87,  116,   27, 2598, 2598, 3549, 3549, 2625, 2625,  127,  122,  318,    5,   22,  135,  802,    9,   13,  890,  894,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 13,  8, 13,  6, 27, 27, 20, 20, 13, 13,  2,  2,  3, 17, 23,  3,  2,  4,  6,  4,  9, {72,75,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Chinese/Traditional Han/Hong Kong
    {     58,   137,   139,  148,  148,  209,  209,    6,    0,    1,    2,    3,    4,    5,    9,   42,   43,   44,   45,  462,   87,  116,   27, 2598, 2598, 3549, 3549, 2625, 2625,  127,  122,  318,    5,   22,  147,  811,    9,   13,  890,  903,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 13,  8, 13,  6, 27, 27, 20, 20, 13, 13,  2,  2,  3, 17, 23,  4,  3,  4,  6,  4,  9, {77,79,80},      2,     1,     7,     6,     7,     1,     3,     3 }, // Chinese/Traditional Han/Macao
    {     58,   137,   228,  148,  148,  204,  204,    6,    0,    1,    2,    3,    4,    5,    9,   42,   43,   44,   45,  440,  454,  116,   27, 2598, 2598, 3549, 3549, 2625, 2625,  127,  122,    0,    5,   22,    1,  814,    9,   13,  890,  912,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 14,  8, 13,  6, 27, 27, 20, 20, 13, 13,  2,  2,  4, 17, 23,  1,  3,  4,  6,  4,  2, {84,87,68},      2,     0,     7,     6,     7,     1,     3,     3 }, // Chinese/Traditional Han/Taiwan
    {     59,    27,   193,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  124,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Church/Cyrillic/Russia
    {     60,    27,   193,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  124,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Chuvash/Cyrillic/Russia
    {     61,    66,    91,    0,    0,  214,  214,    6,    1,   14,    2,    3,   40,    5,   52,   15,   10,   16,   12,  475,  364,    0,    0, 3569, 3569, 3640, 3640, 3667, 3667,  149,  148,    0,    5,   22,   13,   73,   19,    0,  914,  920,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 23, 10, 10,  5, 71, 71, 27, 27, 13, 13, 16, 16,  4, 17, 23,  1,  4,  5,  0,  6, 11, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Colognian/Latin/Germany
    {     63,    66,   246,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,  127,    0,    0, 3680, 3680, 3740, 3740,   83,   83,  165,  164,    0,    5,   22,   91,    0,    9,    0,  931,  939,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 60, 60, 27, 27, 13, 13,  4,  4,  4, 17, 23,  1,  0,  4,  0,  8, 14, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // Cornish/Latin/United Kingdom
    {     64,    66,    84,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   13,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Corsican/Latin/France
    {     66,    66,    60,    0,    0,  110,  110,    6,    1,    0,    2,    3,   40,    5,    9,   15,   10,   16,   12,  345,  498,   54,    0, 2149, 2149, 2206, 2206, 2233, 2246,    0,    0,  228,    5,   22,  151,  817,   19,    0,  953,  961,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19, 13, 12,  5, 57, 57, 27, 27, 13, 13,  2,  2,  7, 17, 23,  3, 13,  5,  0,  8,  8, {72,82,75},      2,     1,     1,     6,     7,     1,     3,     3 }, // Croatian/Latin/Croatia
    {     66,    66,    29,    0,    0,  110,  110,    6,    1,    0,    2,    3,   40,    5,    9,   15,   10,   16,   12,  345,  511,   54,    0, 2149, 2149, 2206, 2206, 2246, 2246,    0,    0,  228,    5,   22,  128,  596,   19,    0,  953,  581,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  9, 12,  5, 57, 57, 27, 27, 13, 13,  2,  2,  7, 17, 23,  2, 19,  5,  0,  8, 19, {66,65,77},      2,     1,     1,     6,     7,     1,     3,     3 }, // Croatian/Latin/Bosnia And Herzegovina
    {     67,    66,    64,    0,    0,  222,  222,    6,    1,   14,    2,    3,    4,    5,    9,   15,   10,   16,   12,  520,  184,    1,    1, 3767, 3767, 3815, 3815, 3835, 3835,  169,  168,  321,    5,   22,  154,  830,   19,    0,  969,  976,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8,  9,  4, 48, 48, 20, 20, 13, 13,  4,  4,  5, 17, 23,  2, 12,  5,  0,  7,  5, {67,90,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Czech/Latin/Czechia
    {     68,    66,    65,    0,    0,  229,  229,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  537,  560,  140,  140, 3848, 3848, 3898, 3925, 3959, 3959,    0,    0,    0,    5,   22,  156,  842,   19,    0,  981,  986,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 10, 10,  5, 50, 50, 27, 34, 13, 13,  2,  2,  5, 17, 23,  3, 11,  5,  0,  5,  7, {68,75,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Danish/Latin/Denmark
    {     68,    66,    95,    0,    0,  229,  229,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  537,  560,  140,  140, 3848, 3848, 3898, 3925, 3959, 3959,    0,    0,    0,    5,   22,  156,  842,   19,    0,  981,  993,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 10, 10,  5, 50, 50, 27, 34, 13, 13,  2,  2,  5, 17, 23,  3, 11,  5,  0,  5,  8, {68,75,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Danish/Latin/Greenland
    {     69,   132,   144,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {77,86,82},      2,     1,     5,     6,     7,     1,     3,     3 }, // Divehi/Thaana/Maldives
    {     70,    29,   110,    0,    0,  237,  246,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  570,   87,   10,   22, 3972, 4022, 4072, 4072, 4101, 4123,  173,  172,    0,    5,   22,  117,  853,    9,    0, 1001,  569,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 50, 50, 29, 29, 22, 24,  4,  9,  4, 17, 23,  1, 10,  4,  0,  5,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Dogri/Devanagari/India
    {     71,    66,    40,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   12,   13,   71,   87,    0,    0, 4147, 4147, 4191, 4191, 4218, 4218,  177,  181,    0,    5,   22,    2,    0,   19,    0, 1006, 1011,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 44, 44, 27, 27, 13, 13,  5,  6,  4, 17, 23,  4,  0,  5,  0,  5,  8, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Duala/Latin/Cameroon
    {     72,    66,   165,    0,    0,    7,    7,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   12,   13,   71,  432,    0,    0, 4231, 4231, 4289, 4289, 4309, 4309,  165,  164,    0,    5,   22,   13,   73,    4,   37, 1019, 1019,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 58, 58, 20, 20, 13, 13,  4,  4,  4, 17, 23,  1,  4,  5,  7, 10,  9, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Dutch/Latin/Netherlands
    {     72,    66,    13,    0,    0,    7,    7,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   12,   13,   71,  432,    0,    0, 4231, 4231, 4289, 4289, 4309, 4309,  165,  164,    0,    5,   22,  159,  863,    4,   37, 1019, 1029,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 58, 58, 20, 20, 13, 13,  4,  4,  4, 17, 23,  4, 16,  5,  7, 10,  5, {65,87,71},      2,     1,     1,     6,     7,     1,     3,     3 }, // Dutch/Latin/Aruba
    {     72,    66,    23,    0,    0,    7,    7,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   12,   13,   71,  128,    0,    0, 4231, 4231, 4289, 4289, 4309, 4309,  165,  164,    0,    5,   22,   13,   73,    4,   37, 1019, 1034,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  9, 10,  5, 58, 58, 20, 20, 13, 13,  4,  4,  4, 17, 23,  1,  4,  5,  7, 10,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Dutch/Latin/Belgium
    {     72,    66,    44,    0,    0,    7,    7,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   12,   13,   71,  432,    0,    0, 4231, 4231, 4289, 4289, 4309, 4309,  165,  164,    0,    5,   22,    1,  879,    4,   37, 1019, 1040,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 58, 58, 20, 20, 13, 13,  4,  4,  4, 17, 23,  1, 18,  5,  7, 10, 19, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Dutch/Latin/Caribbean Netherlands
    {     72,    66,    62,    0,    0,    7,    7,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   12,   13,   71,  432,    0,    0, 4231, 4231, 4289, 4289, 4309, 4309,  165,  164,    0,    5,   22,  163,  897,    4,   37, 1019, 1059,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 58, 58, 20, 20, 13, 13,  4,  4,  4, 17, 23,  4, 30,  5,  7, 10,  7, {65,78,71},      2,     1,     1,     6,     7,     1,     3,     3 }, // Dutch/Latin/Curacao
    {     72,    66,   211,    0,    0,    7,    7,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   12,   13,   71,  432,    0,    0, 4231, 4231, 4289, 4289, 4309, 4309,  165,  164,    0,    5,   22,  163,  897,    4,   37, 1019, 1066,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 58, 58, 20, 20, 13, 13,  4,  4,  4, 17, 23,  4, 30,  5,  7, 10, 12, {65,78,71},      2,     1,     1,     6,     7,     1,     3,     3 }, // Dutch/Latin/Sint Maarten
    {     72,    66,   223,    0,    0,    7,    7,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   12,   13,   71,  432,    0,    0, 4231, 4231, 4289, 4289, 4309, 4309,  165,  164,    0,    5,   22,    1,  927,    4,   37, 1019, 1078,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 58, 58, 20, 20, 13, 13,  4,  4,  4, 17, 23,  1, 17,  5,  7, 10,  8, {83,82,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Dutch/Latin/Suriname
    {     73,   134,    27,  254,  254,  254,  254,    6,    0,    1,    2,   56,    4,    5,    9,   10,   11,   12,   13,  588,   44,  150,  177, 4322, 4322, 4400, 4400, 4433, 4433,  182,  187,    0,    5,   22,  167,  944,    9,    0, 1086, 1092,  9,  9,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 30, 10, 27, 22, 78, 78, 33, 33, 26, 26,  5,  6,  4, 17, 23,  3,  8,  4,  0,  6,  5, {66,84,78},      2,     1,     7,     6,     7,     1,     2,     3 }, // Dzongkha/Tibetan/Bhutan
    {     74,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 4459, 4459, 4522, 4522, 4549, 4549,  187,  193,    0,    5,   22,  170,  952,    9,   13, 1097, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 63, 63, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 17,  4,  6,  6,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Embu/Latin/Kenya
    {     75,    66,   248,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,  969,    9,   13, 1108, 1124,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  9,  4,  6, 16, 13, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/United States
    {     75,    28,   248,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  140,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Deseret/United States
    {     75,    66,     5,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,  969,    9,   13, 1117, 1137,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  9,  4,  6,  7, 14, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/American Samoa
    {     75,    66,     8,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  978,    9,   13, 1117, 1151,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7,  8, {88,67,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Anguilla
    {     75,    66,    10,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  978,    9,   13, 1117, 1159,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7, 17, {88,67,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Antigua And Barbuda
    {     75,    66,    15,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    6,   10,   11,   12,   13,    0,   87,   10,   22,    0,    0,   56,   56, 4562, 4562,   82,  195,    0,    5,   22,    1,  999,    9,   13, 1176, 1176,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 56, 56, 27, 27, 24, 24,  2,  2,  5, 17, 23,  1, 17,  4,  6, 18,  9, {65,85,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Australia
    {     75,    66,    16,    0,    0,  273,  273,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   13,   73,    4,    0, 1117, 1194,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0,  7,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Austria
    {     75,    66,    18,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1016,    9,   13, 1117, 1201,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 15,  4,  6,  7,  7, {66,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Bahamas
    {     75,    66,    21,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1031,    9,   13, 1117, 1208,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 16,  4,  6,  7,  8, {66,66,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Barbados
    {     75,    66,    23,    0,    0,  273,  273,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   13,   73,   19,    0, 1117, 1216,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0,  7,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Belgium
    {     75,    66,    24,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  618,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1047,    9,   13, 1117, 1223,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 13,  4,  6,  7,  6, {66,90,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Belize
    {     75,    66,    26,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1060,    9,   13, 1117, 1229,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 16,  4,  6,  7,  7, {66,77,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Bermuda
    {     75,    66,    30,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  618,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  149, 1076,    9,   13, 1117, 1236,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 14,  4,  6,  7,  8, {66,87,80},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Botswana
    {     75,    66,    33,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  140,  969,    9,   13, 1117, 1244,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3,  9,  4,  6,  7, 30, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/British Indian Ocean Territory
    {     75,    66,    34,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  140,  969,    9,   13, 1117, 1274,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3,  9,  4,  6,  7, 22, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/British Virgin Islands
    {     75,    66,    38,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,    0,    0,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,  173, 1090,    9,   13, 1117, 1296,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 15,  4,  6,  7,  7, {66,73,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Burundi
    {     75,    66,    40,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    2, 1105,    9,   13, 1117, 1303,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  4, 25,  4,  6,  7,  8, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Cameroon
    {     75,    66,    41,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    6,   10,   11,   12,   13,  321,   44,   10,   22,    0,    0, 4586, 4586,   83,   83,  165,  164,    0,    5,   22,    1, 1130,    9,   13, 1311, 1327,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 12,  7, 56, 56, 34, 34, 13, 13,  4,  4,  5, 17, 23,  1, 15,  4,  6, 16,  6, {67,65,68},      2,     0,     7,     6,     7,     1,     3,     3 }, // English/Latin/Canada
    {     75,    66,    45,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1145,    9,   13, 1117, 1333,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7, 14, {75,89,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Cayman Islands
    {     75,    66,    51,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  999,    9,   13, 1117, 1347,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 17,  4,  6,  7, 16, {65,85,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Christmas Island
    {     75,    66,    53,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  999,    9,   13, 1117, 1363,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 17,  4,  6,  7, 23, {65,85,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Cocos Islands
    {     75,    66,    58,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1166,    9,   13, 1117, 1386,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 18,  4,  6,  7, 12, {78,90,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Cook Islands
    {     75,    66,    63,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   13,   73,    9,   13, 1117, 1398,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  4,  6,  7,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Cyprus
    {     75,    66,    65,    0,    0,  273,  273,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,  140,  140,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  156, 1184,   19,    0, 1117, 1404,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 12,  5,  0,  7,  7, {68,75,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Denmark
    {     75,    66,    66,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  140,  969,    9,   13, 1117, 1411,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3,  9,  4,  6,  7, 12, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Diego Garcia
    {     75,    66,    68,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  978,    9,   13, 1117, 1423,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7,  8, {88,67,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Dominica
    {     75,    66,    74,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   37, 1196,    9,   13, 1117, 1431,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 14,  4,  6,  7,  7, {69,82,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Eritrea
    {     75,    66,    76,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  176, 1210,    9,   13, 1117, 1438,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 15,  4,  6,  7,  8, {83,90,76},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Eswatini
    {     75,    66,    78,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    0,    0,   19,    0, 1117, 1446,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  0,  0,  5,  0,  7,  6,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Europe
    {     75,    66,    80,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   91, 1225,    9,   13, 1117, 1452,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 22,  4,  6,  7, 16, {70,75,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Falkland Islands
    {     75,    66,    82,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1247,    9,   13, 1117, 1468,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 13,  4,  6,  7,  4, {70,74,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Fiji
    {     75,    66,    83,    0,    0,  273,  273,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,  141,  141,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   13,   73,   19,    0, 1117, 1472,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10,  9,  4, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0,  7,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Finland
    {     75,    66,    89,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  177, 1260,    9,   13, 1117, 1479,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 14,  4,  6,  7,  6, {71,77,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Gambia
    {     75,    66,    91,    0,    0,  273,  273,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   13,   73,   19,    0, 1117, 1485,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0,  7,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Germany
    {     75,    66,    92,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    6, 1274,    9,   13, 1117, 1492,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 13,  4,  6,  7,  5, {71,72,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Ghana
    {     75,    66,    93,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   91, 1287,    9,   13, 1117, 1497,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 15,  4,  6,  7,  9, {71,73,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Gibraltar
    {     75,    66,    96,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  978,    9,   13, 1117, 1506,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7,  7, {88,67,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Grenada
    {     75,    66,    98,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,  969,    9,   13, 1117, 1513,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  9,  4,  6,  7,  4, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Guam
    {     75,    66,   100,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   91, 1302,    9,   13, 1117, 1517,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  8,  4,  6,  7,  8, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Guernsey
    {     75,    66,   103,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1310,    9,   13, 1117, 1525,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 16,  4,  6,  7,  6, {71,89,68},      2,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Guyana
    {     75,    66,   107,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  135, 1326,    9,   13, 1117, 1531,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 16,  4,  6,  7, 19, {72,75,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Hong Kong
    {     75,    66,   110,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  117, 1342,    9,   13, 1117, 1252,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 12,  4,  6,  7,  5, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // English/Latin/India
    {     75,    66,   114,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,  127,    0,    0,    0,    0,   56,   56,   83,   83,  165,  164,    0,    5,   22,   13,   73,    9,   13, 1117, 1550,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 56, 56, 27, 27, 13, 13,  4,  4,  5, 17, 23,  1,  4,  4,  6,  7,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Ireland
    {     75,    66,   115,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   91, 1302,    9,   13, 1117, 1557,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  8,  4,  6,  7, 11, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Isle Of Man
    {     75,    66,   116,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    1,    1,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   45, 1354,    9,   13, 1117, 1568,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10,  9,  4, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 18,  4,  6,  7,  6, {73,76,83},      2,     1,     7,     5,     6,     1,     3,     3 }, // English/Latin/Israel
    {     75,    66,   119,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1372,    9,   13, 1117, 1574,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 15,  4,  6,  7,  7, {74,77,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Jamaica
    {     75,    66,   121,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   91, 1302,    9,   13, 1117, 1581,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  8,  4,  6,  7,  6, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Jersey
    {     75,    66,   124,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  170, 1387,    9,   13, 1117, 1103,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 15,  4,  6,  7,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Kenya
    {     75,    66,   125,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  999,    9,   13, 1117, 1587,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 17,  4,  6,  7,  8, {65,85,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Kiribati
    {     75,    66,   133,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    0, 1402,    9,   13, 1117, 1595,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 18,  4,  6,  7,  7, {90,65,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Lesotho
    {     75,    66,   134,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1420,    9,   13, 1117, 1602,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 15,  4,  6,  7,  7, {76,82,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Liberia
    {     75,    66,   139,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  147, 1435,    9,   13, 1117, 1609,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  4, 15,  4,  6,  7, 15, {77,79,80},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Macao
    {     75,    66,   141,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  178, 1450,    9,   13, 1117, 1624,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 15,  4,  6,  7, 10, {77,71,65},      0,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Madagascar
    {     75,    66,   142,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  180, 1465,    9,   13, 1117, 1634,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 15,  4,  6,  7,  6, {77,87,75},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Malawi
    {     75,    66,   143,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  182, 1480,    9,   13, 1117, 1640,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 17,  4,  6,  7,  8, {77,89,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Malaysia
    {     75,    66,   146,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   13,   73,    9,   13, 1117, 1648,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  4,  6,  7,  5, {69,85,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Malta
    {     75,    66,   147,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,  969,    9,   13, 1117, 1653,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  9,  4,  6,  7, 16, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Marshall Islands
    {     75,    66,   150,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  184, 1497,    9,   13, 1117, 1669,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 15,  4,  6,  7,  9, {77,85,82},      2,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Mauritius
    {     75,    66,   153,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  140,  969,    9,   13, 1117, 1678,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3,  9,  4,  6,  7, 10, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Micronesia
    {     75,    66,   158,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  978,    9,   13, 1117, 1688,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7, 10, {88,67,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Montserrat
    {     75,    66,   162,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1512,    9,   13, 1117, 1698,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 15,  4,  6,  7,  7, {78,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Namibia
    {     75,    66,   163,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  999,    9,   13, 1117, 1705,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 17,  4,  6,  7,  5, {65,85,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Nauru
    {     75,    66,   165,    0,    0,  273,  273,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   13,   73,    4,   37, 1117, 1710,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  7,  7, 11, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Netherlands
    {     75,    66,   167,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  128,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1166,    9,   13, 1117, 1721,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  7, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 18,  4,  6,  7, 11, {78,90,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/New Zealand
    {     75,    66,   169,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  121, 1527,    9,   13, 1117, 1732,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 14,  4,  6,  7,  7, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Nigeria
    {     75,    66,   171,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1166,    9,   13, 1117, 1739,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 18,  4,  6,  7,  4, {78,90,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Niue
    {     75,    66,   172,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  999,    9,   13, 1117, 1743,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 17,  4,  6,  7, 14, {65,85,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Norfolk Island
    {     75,    66,   173,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,  969,    9,   13, 1117, 1757,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  9,  4,  6,  7, 24, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Northern Mariana Islands
    {     75,    66,   178,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  184, 1541,    9,   13, 1117, 1781,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 15,  4,  6,  7,  8, {80,75,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // English/Latin/Pakistan
    {     75,    66,   179,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  140,  969,    9,   13, 1117, 1789,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3,  9,  4,  6,  7,  5, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Palau
    {     75,    66,   182,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  127, 1556,    9,   13, 1117, 1794,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 22,  4,  6,  7, 16, {80,71,75},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Papua New Guinea
    {     75,    66,   185,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  139, 1578,    9,   13, 1117, 1810,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 15,  4,  6,  7, 11, {80,72,80},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Philippines
    {     75,    66,   186,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1166,    9,   13, 1117, 1821,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 18,  4,  6,  7, 16, {78,90,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Pitcairn
    {     75,    66,   189,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,  969,    9,   13, 1117, 1837,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  9,  4,  6,  7, 11, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Puerto Rico
    {     75,    66,   194,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  186, 1593,    9,   13, 1117, 1848,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 13,  4,  6,  7,  6, {82,87,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Rwanda
    {     75,    66,   196,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   91, 1606,    9,   13, 1117, 1854,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 15,  4,  6,  7, 10, {83,72,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Saint Helena
    {     75,    66,   197,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  978,    9,   13, 1117, 1864,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7, 17, {88,67,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Saint Kitts And Nevis
    {     75,    66,   198,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  978,    9,   13, 1117, 1881,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7,  9, {88,67,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Saint Lucia
    {     75,    66,   201,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  978,    9,   13, 1117, 1890,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 21,  4,  6,  7, 24, {88,67,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Saint Vincent And Grenadines
    {     75,    66,   202,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  188, 1621,    9,   13, 1117, 1146,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 11,  4,  6,  7,  5, {87,83,84},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Samoa
    {     75,    66,   208,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  191, 1632,    9,   13, 1117, 1914,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 17,  4,  6,  7, 10, {83,67,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Seychelles
    {     75,    66,   209,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    9, 1649,    9,   13, 1117, 1924,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 20,  4,  6,  7, 12, {83,76,76},      0,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Sierra Leone
    {     75,    66,   210,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1669,    9,   13, 1117, 1936,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 16,  4,  6,  7,  9, {83,71,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Singapore
    {     75,    66,   211,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  163, 1685,    9,   13, 1117, 1945,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  4, 29,  4,  6,  7, 12, {65,78,71},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Sint Maarten
    {     75,    66,   213,    0,    0,  273,  273,    6,    1,    0,    2,    3,    4,    5,    6,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   13,   73,   19,   24, 1117, 1957,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  7,  7,  8, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Slovenia
    {     75,    66,   214,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1714,    9,   13, 1117, 1965,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 22,  4,  6,  7, 15, {83,66,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Solomon Islands
    {     75,    66,   216,    0,    0,  273,  273,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,  618,  636,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    0, 1402,    9,   13, 1117, 1980,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 18,  4,  6,  7, 12, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/South Africa
    {     75,    66,   219,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   91, 1736,    9,   13, 1117, 1992,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 20,  4,  6,  7, 11, {83,83,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/South Sudan
    {     75,    66,   222,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    0, 1756,    9,   13, 1117, 2003,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  0, 14,  4,  6,  7,  5, {83,68,71},      2,     1,     6,     5,     6,     1,     3,     3 }, // English/Latin/Sudan
    {     75,    66,   225,    0,    0,  273,  273,    6,    1,   14,    2,    3,    4,    5,   52,   10,   11,   12,   13,    0,   44,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  156, 1770,   19,    0, 1117, 2008,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 13,  5,  0,  7,  6, {83,69,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Sweden
    {     75,    66,   226,    0,    0,  273,  273,    6,    0,   13,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    0, 1783,    4,   44, 1117, 2014,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  0, 11,  5,  5,  7, 11, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Switzerland
    {     75,    66,   230,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  118, 1794,    9,   13, 1117, 2025,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 18,  4,  6,  7,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Tanzania
    {     75,    66,   234,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1166,    9,   13, 1117, 2033,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 18,  4,  6,  7,  7, {78,90,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Tokelau
    {     75,    66,   235,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  193, 1812,    9,   13, 1117, 2040,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 14,  4,  6,  7,  5, {84,79,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Tonga
    {     75,    66,   236,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1, 1826,    9,   13, 1117, 2045,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 24,  4,  6,  7, 17, {84,84,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Trinidad And Tobago
    {     75,    66,   241,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  140,  969,    9,   13, 1117, 2062,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3,  9,  4,  6,  7, 22, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Turks And Caicos Islands
    {     75,    66,   242,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    1,  999,    9,   13, 1117, 2084,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 17,  4,  6,  7,  6, {65,85,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Tuvalu
    {     75,    66,   243,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  143, 1850,    9,   13, 1117,  857,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 16,  4,  6,  7,  6, {85,71,88},      0,     0,     1,     7,     7,     1,     3,     3 }, // English/Latin/Uganda
    {     75,    66,   245,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,  195, 1866,    9,   13, 1117, 2090,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3, 27,  4,  6,  7, 20, {65,69,68},      2,     1,     6,     5,     6,     1,     3,     3 }, // English/Latin/United Arab Emirates
    {     75,    66,   246,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,   91, 1893,    9,   13, 2110, 2125,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 13,  4,  6, 15, 14, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/United Kingdom
    {     75,    66,   247,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,  969,    9,   13, 1117, 2139,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  9,  4,  6,  7, 21, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/United States Outlying Islands
    {     75,    66,   249,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,    0,    0,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,  969,    9,   13, 1117, 2160,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1,  9,  4,  6,  7, 19, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/United States Virgin Islands
    {     75,    66,   252,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  198, 1906,    9,   13, 1117, 2179,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  2, 12,  4,  6,  7,  7, {86,85,86},      0,     0,     1,     6,     7,     1,     3,     3 }, // English/Latin/Vanuatu
    {     75,    66,   258,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,    0,    0,    9,   13, 1117, 2186,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  0,  0,  4,  6,  7,  5,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/World
    {     75,    66,   260,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  127, 1918,    9,   13, 1117,  543,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 14,  4,  6,  7,  6, {90,77,87},      2,     1,     1,     6,     7,     1,     3,     3 }, // English/Latin/Zambia
    {     75,    66,   261,    0,    0,  273,  273,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  618,   87,    0,    0,    0,    0,   56,   56,   83,   83,   82,  195,    0,    5,   22,  140,  969,    9,   13, 1117, 2191,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  3,  9,  4,  6,  7,  8, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // English/Latin/Zimbabwe
    {     76,    27,   193,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  124,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Erzya/Cyrillic/Russia
    {     77,    66,   258,    0,    0,  282,  282,    6,    1,   14,    2,    3,   40,    5,    9,   10,   11,   12,   13,  646,   46,  199,    0, 4620, 4620, 4670, 4670, 4690, 4690,  189,  197,  326,    5,   22,    0,    0,    4,    0, 2199, 2208,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26,  8, 25,  5, 50, 50, 20, 20, 13, 13,  3,  3,  6, 17, 23,  0,  0,  5,  0,  9,  5,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // Esperanto/Latin/World
    {     78,    66,    75,    0,    0,  291,  291,    6,    1,   14,    2,    3,   40,    5,   52,   15,   10,   16,   12,  345,  184,    0,    0, 4703, 4703, 4765, 4765, 4765, 4765,    0,    0,  332,    5,   22,   13,  420,   19,   24, 2213, 2218,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 18,  8, 10,  5, 62, 62, 13, 13, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  5,  5, {69,85,82},      2,     1,     1,     6,     7,     2,     3,     3 }, // Estonian/Latin/Estonia
    {     79,    66,    92,    0,    0,  299,  310,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  672,  339,  224,  224, 4778, 4778, 4821, 4821, 4848, 4848,  192,  200,    0,    5,   22,    6, 1932,    9,   13, 2223, 2229,  6,  6, 11, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  6, 17, 12, 43, 43, 27, 27, 13, 13,  3,  5,  4, 17, 23,  3, 10,  4,  6,  6, 12, {71,72,83},      2,     1,     1,     6,     7,     3,     3,     3 }, // Ewe/Latin/Ghana
    {     79,    66,   233,    0,    0,  299,  310,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  672,  339,    0,    0, 4778, 4778, 4821, 4821, 4848, 4848,  192,  200,    0,    5,   22,    3, 1942,    9,   13, 2223, 2241,  6,  6, 11, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  6, 10,  5, 43, 43, 27, 27, 13, 13,  3,  5,  4, 17, 23,  3, 33,  4,  6,  6, 11, {88,79,70},      0,     0,     1,     6,     7,     3,     3,     3 }, // Ewe/Latin/Togo
    {     80,    66,    40,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,   87,    0,    0, 4861, 4861, 4945, 4945, 4974, 4974,  195,  205,    0,    5,   22,    2, 1975,   19,    0, 2252, 2258,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 84, 84, 29, 29, 13, 13,  7,  9,  4, 17, 23,  4, 16,  5,  0,  6,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Ewondo/Latin/Cameroon
    {     81,    66,    81,    0,    0,  229,  229,    6,    1,    0,    2,    3,   40,    5,    9,   10,   11,   12,   13,  345,  184,    0,    0, 4987, 4987, 5060, 5087, 5121, 5121,    0,    0,  338,    5,   22,  156, 1991,   19,   24, 2265, 2273,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 73, 73, 27, 34, 13, 13,  2,  2,  3, 17, 23,  2, 11,  5,  7,  8,  7, {68,75,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Faroese/Latin/Faroe Islands
    {     81,    66,    65,    0,    0,  229,  229,    6,    1,    0,    2,    3,   40,    5,    9,   10,   11,   12,   13,  345,  184,    0,    0, 4987, 4987, 5060, 5087, 5121, 5121,    0,    0,  338,    5,   22,  156, 1991,   19,   24, 2265,  986,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 73, 73, 27, 34, 13, 13,  2,  2,  3, 17, 23,  3, 11,  5,  7,  8,  7, {68,75,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Faroese/Latin/Denmark
    {     83,    66,   185,    0,    0,  320,  329,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22, 5134, 5134, 5188, 5188, 5188, 5188,    0,    0,    0,    5,   22,  139, 2002,    9,   13, 2280,  729,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 54, 54, 27, 27, 27, 27,  2,  2,  5, 17, 23,  1, 17,  4,  6,  8,  9, {80,72,80},      2,     1,     7,     6,     7,     1,     3,     3 }, // Filipino/Latin/Philippines
    {     84,    66,    83,    0,    0,  291,  291,    6,    1,   14,    2,    3,   40,    5,    9,   11,   11,   13,   13,  520,  695,  141,  141, 5215, 5281, 5361, 5361, 5381, 5381,  202,  214,  341,  346,  363,   13,  420,   19,    0, 2288, 2293,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8,  9,  4, 66, 80, 20, 20, 13, 13,  3,  3,  5, 17, 23,  1,  4,  5,  0,  5,  5, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Finnish/Latin/Finland
    {     85,    66,    84,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2306,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/France
    {     85,    66,     4,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,   10,   22, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  177, 2019,   19,   24, 2298, 2312,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 12,  7, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 14,  5,  7,  8,  7, {68,90,68},      2,     1,     6,     5,     6,     1,     3,     3 }, // French/Latin/Algeria
    {     85,    66,    23,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  128,  241,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2319,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  7, 23,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8,  8, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Belgium
    {     85,    66,    25,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    3, 2033,   19,   24, 2298, 2327,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 17,  5,  7,  8,  5, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Benin
    {     85,    66,    37,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    3, 2033,   19,   24, 2298, 2332,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 17,  5,  7,  8, 12, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Burkina Faso
    {     85,    66,    38,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  173, 2050,   19,   24, 2298, 1296,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 15,  5,  7,  8,  7, {66,73,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Burundi
    {     85,    66,    40,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,  205,  217,  386,  242,  259,    2, 2065,   19,   24, 2298, 1011,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  5,  4,  6, 17, 23,  4, 16,  5,  7,  8,  8, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Cameroon
    {     85,    66,    41,    0,    0,  337,  337,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   11,   10,   71,   44,  264,  264, 5394, 5394, 5445, 5445, 5479, 5479,  165,  164,  386,  242,  259,  200, 2081,   19,   24, 2344, 1327,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 24,  9, 51, 51, 34, 34, 13, 13,  4,  4,  6, 17, 23,  4, 15,  5,  7, 17,  6, {67,65,68},      2,     0,     7,     6,     7,     1,     3,     3 }, // French/Latin/Canada
    {     85,    66,    46,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    2, 2065,   19,   24, 2298, 2361,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  4, 16,  5,  7,  8, 25, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Central African Republic
    {     85,    66,    48,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,   10,   22, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    2, 2065,   19,   24, 2298, 2386,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 12,  7, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  4, 16,  5,  7,  8,  5, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Chad
    {     85,    66,    55,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    3, 2096,   19,   24, 2298, 2391,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 14,  5,  7,  8,  7, {75,77,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Comoros
    {     85,    66,    56,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    2, 2065,   19,   24, 2298, 2398,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  4, 16,  5,  7,  8, 17, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Congo Brazzaville
    {     85,    66,    57,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    2, 2110,   19,   24, 2298, 2415,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 15,  5,  7,  8, 14, {67,68,70},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Congo Kinshasa
    {     85,    66,    67,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,   10,   22, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   34, 2125,   19,   24, 2298, 2429,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 12,  7, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 16,  5,  7,  8,  8, {68,74,70},      0,     0,     6,     6,     7,     1,     3,     3 }, // French/Latin/Djibouti
    {     85,    66,    73,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    2, 2065,   19,   24, 2298, 2437,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  4, 16,  5,  7,  8, 18, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Equatorial Guinea
    {     85,    66,    85,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2455,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8, 16, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/French Guiana
    {     85,    66,    86,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  204, 2141,   19,   24, 2298, 2471,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  4,  9,  5,  7,  8, 19, {88,80,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/French Polynesia
    {     85,    66,    88,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    2, 2065,   19,   24, 2298, 2490,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  4, 16,  5,  7,  8,  5, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Gabon
    {     85,    66,    97,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2495,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8, 10, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Guadeloupe
    {     85,    66,   102,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  208, 2150,   19,   24, 2298, 2437,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 13,  5,  7,  8,  6, {71,78,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Guinea
    {     85,    66,   104,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    6, 2163,   19,   24, 2298, 2505,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1, 16,  5,  7,  8,  5, {72,84,71},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Haiti
    {     85,    66,   118,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    3, 2033,   19,   24, 2298, 2510,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 17,  5,  7,  8, 13, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Ivory Coast
    {     85,    66,   138,    0,    0,  337,  337,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2523,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8, 10, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Luxembourg
    {     85,    66,   141,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  178, 2179,   19,   24, 2298, 1624,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 15,  5,  7,  8, 10, {77,71,65},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Madagascar
    {     85,    66,   145,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    3, 2033,   19,   24, 2298,  467,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 17,  5,  7,  8,  4, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Mali
    {     85,    66,   148,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2533,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8, 10, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Martinique
    {     85,    66,   149,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,   10,   22, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  210, 2194,   19,   24, 2298, 2543,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 12,  7, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 19,  5,  7,  8, 10, {77,82,85},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Mauritania
    {     85,    66,   150,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  184, 2213,   19,   24, 2298, 2553,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 18,  5,  7,  8,  7, {77,85,82},      2,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Mauritius
    {     85,    66,   151,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2560,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Mayotte
    {     85,    66,   155,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2567,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Monaco
    {     85,    66,   159,    0,    0,  337,  337,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,  165,  164,  386,  242,  259,  212, 2231,   19,   24, 2298, 2573,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  4,  4,  6, 17, 23,  3, 15,  5,  7,  8,  5, {77,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Morocco
    {     85,    66,   166,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  204, 2141,   19,   24, 2298, 2578,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  4,  9,  5,  7,  8, 18, {88,80,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/New Caledonia
    {     85,    66,   170,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    3, 2033,   19,   24, 2298, 1732,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 17,  5,  7,  8,  5, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Niger
    {     85,    66,   191,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2596,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8, 10, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Reunion
    {     85,    66,   194,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  186, 2246,   19,   24, 2298, 1848,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 14,  5,  7,  8,  6, {82,87,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Rwanda
    {     85,    66,   195,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2606,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8, 16, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Saint Barthelemy
    {     85,    66,   199,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2622,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8, 12, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Saint Martin
    {     85,    66,   200,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,   13,  420,   19,   24, 2298, 2634,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  1,  4,  5,  7,  8, 24, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Saint Pierre And Miquelon
    {     85,    66,   206,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    3, 2033,   19,   24, 2298, 2658,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 17,  5,  7,  8,  7, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Senegal
    {     85,    66,   208,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  191, 2260,   19,   24, 2298, 1914,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 21,  5,  7,  8, 10, {83,67,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // French/Latin/Seychelles
    {     85,    66,   226,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   19,   20,    0,  184,  288,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  215, 2281,   19,   24, 2665, 2680,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8, 14,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 12,  5,  7, 15,  6, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Switzerland
    {     85,    66,   227,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,   10,   22, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  218, 2293,   19,   24, 2298, 2686,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 12,  7, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 14,  5,  7,  8,  5, {83,89,80},      0,     0,     6,     5,     6,     1,     3,     3 }, // French/Latin/Syria
    {     85,    66,   233,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,    3, 2033,   19,   24, 2298, 2241,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  3, 17,  5,  7,  8,  4, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Togo
    {     85,    66,   238,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,   10,   22, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  220, 2307,   19,   24, 2298, 2691,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 12,  7, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 14,  5,  7,  8,  7, {84,78,68},      3,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Tunisia
    {     85,    66,   252,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,   10,   22, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  198, 2321,   19,   24, 2298, 2179,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 12,  7, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  2, 14,  5,  7,  8,  7, {86,85,86},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Vanuatu
    {     85,    66,   256,    0,    0,  337,  337,    6,    1,   57,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,  127,    0,    0, 5394, 5394, 5445, 5445, 5479, 5479,    0,    0,  386,  242,  259,  204, 2141,   19,   24, 2298, 2698,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 51, 51, 34, 34, 13, 13,  2,  2,  6, 17, 23,  4,  9,  5,  7,  8, 16, {88,80,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // French/Latin/Wallis And Futuna
    {     86,    66,   117,    0,    0,  345,  345,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   10,   11,  703,  127,    0,    0, 5492, 5492, 5541, 5541, 5479, 5479,    5,  124,    0,    5,   22,   13,  420,    4,    0, 2714, 2720,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 49, 49, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0,  6,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Friulian/Latin/Italy
    {     87,    66,   206,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,    0,    0, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,    3, 2335,   19,    0, 2726, 2732,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  3, 19,  5,  0,  6,  8, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Senegal
    {     87,     1,    37,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  222, 2354,    4,    0, 2740, 2750,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  6, 51,  5,  0, 10, 25, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Burkina Faso
    {     87,     1,    40,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  228, 2405,    4,    0, 2740, 2775,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  8, 44,  5,  0, 10, 16, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Cameroon
    {     87,     1,    89,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,   10,   22, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  177, 2449,    4,    0, 2740, 2791,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  1, 29,  5,  0, 10, 14, {71,77,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Gambia
    {     87,     1,    92,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,   10,   22, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,    6, 2478,    4,    0, 2740, 2805,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  3, 23,  5,  0, 10,  8, {71,72,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Ghana
    {     87,     1,   101,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  222, 2354,    4,    0, 2740, 2813,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  6, 51,  5,  0, 10, 23, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Guinea Bissau
    {     87,     1,   102,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  208, 2501,    4,    0, 2740, 2813,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  2, 25,  5,  0, 10,  8, {71,78,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Guinea
    {     87,     1,   134,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,   10,   22, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,    1, 2526,    4,    0, 2740, 2836,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  1, 31,  5,  0, 10, 18, {76,82,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Liberia
    {     87,     1,   149,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,   10,   22, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  210, 2557,    4,    0, 2740, 2854,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  2, 37,  5,  0, 10, 16, {77,82,85},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Mauritania
    {     87,     1,   169,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  121, 2594,    4,    0, 2740, 2870,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  1, 33,  5,  0, 10, 18, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Nigeria
    {     87,     1,   170,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  222, 2354,    4,    0, 2740, 2888,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  6, 51,  5,  0, 10, 12, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Niger
    {     87,     1,   206,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,  222, 2354,    4,    0, 2740, 2900,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  6, 51,  5,  0, 10, 16, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Senegal
    {     87,     1,   209,  352,  352,  352,  358,    6,    0,   58,    2,   59,    4,    5,    9,   10,   11,   12,   13,   27,   44,   10,   22, 5666, 5666, 5784, 5784, 5836, 5836,  216,  228,  392,  404,   22,    9, 2627,    4,    0, 2740, 2916,  6,  6,  6,  8,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7,118,118, 52, 52, 22, 22,  4,  4, 12, 27, 23,  2, 33,  5,  0, 10, 14, {83,76,76},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Adlam/Sierra Leone
    {     87,    66,    37,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,    0,    0, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,    3, 2335,   19,    0, 2726, 2930,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  3, 19,  5,  0,  6, 14, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Burkina Faso
    {     87,    66,    40,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,    0,    0, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,    2, 2660,   19,    0, 2726, 2944,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  4, 18,  5,  0,  6,  8, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Cameroon
    {     87,    66,    89,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,   10,   22, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,  177, 2678,   19,    0, 2726, 2952,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 12,  7, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  1, 13,  5,  0,  6,  6, {71,77,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Gambia
    {     87,    66,    92,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,   10,   22, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,    6,    0,   19,    0, 2726, 2958,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 12,  7, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  3,  0,  5,  0,  6,  5, {71,72,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Ghana
    {     87,    66,   101,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,    0,    0, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,    3, 2335,   19,    0, 2726, 2963,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  3, 19,  5,  0,  6, 12, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Guinea Bissau
    {     87,    66,   102,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,    0,    0, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,  208,    0,   19,    0, 2726, 2963,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  2,  0,  5,  0,  6,  4, {71,78,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Guinea
    {     87,    66,   134,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,   10,   22, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,    1, 2691,   19,    0, 2726, 2975,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 12,  7, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  1, 16,  5,  0,  6,  9, {76,82,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Liberia
    {     87,    66,   149,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,   10,   22, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,  210, 2707,   19,    0, 2726, 2984,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 12,  7, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  2, 15,  5,  0,  6,  8, {77,82,85},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Mauritania
    {     87,    66,   169,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,    0,    0, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,  121, 2722,   19,    0, 2726, 2992,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  1, 16,  5,  0,  6,  9, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Nigeria
    {     87,    66,   170,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,    0,    0, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,    3, 2335,   19,    0, 2726, 3001,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  3, 19,  5,  0,  6,  6, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Niger
    {     87,    66,   209,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   16,   13,   71,   87,   10,   22, 5568, 5568, 5626, 5626, 5653, 5653,  210,  221,    0,    5,   22,    9, 2738,   19,    0, 2726, 3007,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 12,  7, 58, 58, 27, 27, 13, 13,  6,  7,  4, 17, 23,  2, 18,  5,  0,  6, 11, {83,76,76},      0,     0,     1,     6,     7,     1,     3,     3 }, // Fulah/Latin/Sierra Leone
    {     88,    66,   246,    0,    0,  366,  366,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  730,  127,    0,    0, 5858, 5858, 5926, 5926, 5953, 5953,    3,  131,  431,    5,   22,   91, 2756,    9,   13, 3018, 3026,  6,  6, 10, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 21, 10, 10,  5, 68, 68, 27, 27, 13, 13,  1,  1,  6, 17, 23,  1, 15,  4,  6,  8, 22, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // Gaelic/Latin/United Kingdom
    {     89,    66,    92,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    6,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {71,72,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Ga/Latin/Ghana
    {     90,    66,   220,    0,    0,  345,  345,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,  127,    0,    0, 5966, 6014, 6062, 6096,  942, 6130,  165,  164,    0,    5,   22,   13,  420,   19,    0, 3048,  386,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 48, 48, 34, 34, 13, 20,  4,  4,  5, 17, 23,  1,  4,  5,  0,  6,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Galician/Latin/Spain
    {     91,    66,   243,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 6150, 6150, 6215, 6215, 6242, 6242,    0,    0,    0,    5,   22,  143, 2771,    0,    0, 3054, 3061,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 65, 65, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 19,  4,  0,  7,  7, {85,71,88},      0,     0,     1,     7,     7,     1,     3,     3 }, // Ganda/Latin/Uganda
    {     92,    33,    77,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {69,84,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Geez/Ethiopic/Ethiopia
    {     93,    35,    90,    0,    0,  376,  376,    6,    1,   14,    2,    3,    4,    5,    9,   15,   10,   17,   18,  778,  184,    0,    0, 6255, 6255, 6316, 6316, 6343, 6343,    0,    0,  437,  442,   22,  236, 2790,   19,    0, 3068, 3075,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  8, 10,  5, 61, 61, 27, 27, 13, 13,  2,  2,  5, 37, 23,  1, 12,  5,  0,  7, 10, {71,69,76},      2,     1,     1,     6,     7,     2,     3,     3 }, // Georgian/Georgian/Georgia
    {     94,    66,    91,    0,    0,  384,  384,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  184,    0,    0, 6356, 6356, 6415, 6435, 3667, 3667,    0,    0,  479,    5,   22,   13,   73,   19,    0, 3085, 3092,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 59, 59, 20, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0,  7, 11, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // German/Latin/Germany
    {     94,    66,    16,    0,    0,  384,  384,    6,    1,   14,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  184,    0,    0, 6356, 6356, 6415, 6435, 3667, 3667,    0,    0,  479,    5,   22,   13,   73,   19,    0, 3103, 3103,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 59, 59, 20, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0, 24, 10, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // German/Latin/Austria
    {     94,    66,    23,    0,    0,  384,  384,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  184,    0,    0, 6356, 6356, 6415, 6435, 3667, 3667,    0,    0,  479,    5,   22,   13,   73,   19,    0, 3085, 3127,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 59, 59, 20, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0,  7,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // German/Latin/Belgium
    {     94,    66,   117,    0,    0,  384,  384,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  184,    0,    0, 6356, 6356, 6415, 6435, 3667, 3667,    0,    0,  479,    5,   22,   13,   73,   19,    0, 3085, 3134,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 59, 59, 20, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0,  7,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // German/Latin/Italy
    {     94,    66,   136,    0,    0,  384,  384,    6,    0,   13,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  184,    0,    0, 6356, 6356, 6415, 6435, 3667, 3667,    0,    0,  479,    5,   22,  215, 2802,   19,    0, 3085, 3141,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 59, 59, 20, 27, 13, 13,  2,  2,  5, 17, 23,  3, 17,  5,  0,  7, 13, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // German/Latin/Liechtenstein
    {     94,    66,   138,    0,    0,  384,  384,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  184,    0,    0, 6356, 6356, 6415, 6435, 3667, 3667,    0,    0,  479,    5,   22,   13,   73,   19,    0, 3085, 3154,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 59, 59, 20, 27, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  0,  7,  9, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // German/Latin/Luxembourg
    {     94,    66,   226,    0,    0,  384,  384,    6,    0,   13,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  184,    0,    0, 6356, 6356, 6415, 6435, 3667, 3667,    0,    0,  479,    5,   22,  215, 2802,   19,    0, 3163, 3163,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 59, 59, 20, 27, 13, 13,  2,  2,  5, 17, 23,  3, 17,  5,  0, 21,  7, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // German/Latin/Switzerland
    {     96,    39,    94,    0,    0,  393,  393,    6,    1,    0,    2,    3,    4,    5,    6,   17,   18,   10,   11,    0,   87,   10,   22, 6462, 6462, 6516, 6516, 6543, 6543,  220,  232,    0,    5,   22,   13, 2819,   19,    0, 3184, 3192,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 54, 54, 27, 27, 13, 13,  4,  4,  4, 17, 23,  1,  4,  5,  0,  8,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Greek/Greek/Greece
    {     96,    39,    63,    0,    0,  393,  393,    6,    1,    0,    2,    3,    4,    5,    6,   17,   18,   10,   11,    0,   87,   10,   22, 6462, 6462, 6516, 6516, 6543, 6543,  220,  232,    0,    5,   22,   13, 2819,   19,    0, 3184, 3198,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 54, 54, 27, 27, 13, 13,  4,  4,  4, 17, 23,  1,  4,  5,  0,  8,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Greek/Greek/Cyprus
    {     97,    66,   183,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  237,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {80,89,71},      0,     0,     7,     6,     7,     1,     3,     3 }, // Guarani/Latin/Paraguay
    {     98,    40,   110,    0,    0,  402,  402,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,   87,  302,  315, 6556, 6556, 6608, 6608, 6639, 6639,    0,    0,  484,    5,   22,  117, 2823,    9,   13, 3204, 3211,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 13,  8, 52, 52, 31, 31, 18, 18,  2,  2,  4, 17, 23,  1, 13,  4,  6,  7,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Gujarati/Gujarati/India
    {     99,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 6657, 6657, 6718, 6718, 6745, 6745,  224,  236,    0,    5,   22,  170,  952,    9,   13, 3215, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 61, 61, 27, 27, 13, 13,  6,  3,  4, 17, 23,  3, 17,  4,  6,  8,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Gusii/Latin/Kenya
    {    101,    66,   169,    0,    0,  411,  420,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  797,   87,    0,    0, 6758, 6758, 6809, 6809, 6836, 6836,  230,  239,    0,  488,  529,  121, 2836,    4,    0, 3223, 3228,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 10,  5, 51, 51, 27, 27, 13, 13,  6,  5,  5, 41, 47,  1, 15,  5,  0,  5,  8, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Hausa/Latin/Nigeria
    {    101,     4,   169,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  121,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Hausa/Arabic/Nigeria
    {    101,    66,    92,    0,    0,  411,  420,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  797,   87,   10,   22, 6758, 6758, 6809, 6809, 6836, 6836,  230,  239,    0,  488,  529,    6, 2851,    4,    0, 3223, 2958,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 51, 51, 27, 27, 13, 13,  6,  5,  5, 41, 47,  3, 13,  5,  0,  5,  4, {71,72,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Hausa/Latin/Ghana
    {    101,    66,   170,    0,    0,  411,  420,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  797,   87,    0,    0, 6758, 6758, 6809, 6809, 6836, 6836,  230,  239,    0,  488,  529,    3, 2864,    4,    0, 3223, 3236,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 10,  5, 51, 51, 27, 27, 13, 13,  6,  5,  5, 41, 47,  3, 29,  5,  0,  5,  5, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Hausa/Latin/Niger
    {    102,    66,   248,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22, 6849, 6849, 6905, 6905,   83,   83,    0,    0,    0,    5,   22,    1,    0,    9,   13, 3241, 3255,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 56, 56, 20, 20, 13, 13,  2,  2,  4, 17, 23,  1,  0,  4,  6, 14, 19, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Hawaiian/Latin/United States
    {    103,    47,   116,    0,    0,  428,  428,    6,    0,    1,    2,    3,   35,   37,    9,   11,   11,   13,   13,  814,  695,    1,    1, 6925, 6925, 6989, 6989, 7034, 7034,  236,  244,  576,    5,   22,   45, 2893,   19,    0, 3274, 3279,  6,  6,  6,  6,  1,  1,  1,  1,  1,  2,  2,  1,  1,  1,  1,  1, 18,  8,  9,  4, 64, 64, 45, 45, 20, 20,  6,  5,  4, 17, 23,  1,  7,  5,  0,  5,  5, {73,76,83},      2,     1,     7,     5,     6,     1,     3,     3 }, // Hebrew/Hebrew/Israel
    {    105,    29,   110,    0,    0,  434,  443,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22, 7054, 7054, 7106, 7106, 7137, 7137,   82,  195,  580,    5,   22,  117, 2900,    9,    0, 3284,  569,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 52, 52, 31, 31, 18, 18,  2,  2,  4, 17, 23,  1, 12,  4,  0,  6,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Hindi/Devanagari/India
    {    105,    66,   110,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  117,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Hindi/Latin/India
    {    107,    66,   108,    0,    0,  451,  451,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   18,   17,  832,  851,    1,    1, 7155, 7155, 7206, 7206, 7224, 7224,  242,  249,  584,    5,   22,  238, 2912,   19,    0, 3290, 3296,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19, 13,  9,  4, 51, 51, 18, 18, 16, 16,  3,  3,  4, 17, 23,  2, 13,  5,  0,  6, 12, {72,85,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // Hungarian/Latin/Hungary
    {    108,    66,   109,    0,    0,  229,  229,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  695,    0,    0, 7240, 7240, 7320, 7320, 7354, 7354,  245,  252,  588,    5,   22,  240, 2925,   19,    0, 3308, 3316,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 80, 80, 34, 34, 13, 13,  4,  4,  4, 17, 23,  3, 13,  5,  0,  8,  6, {73,83,75},      0,     0,     1,     6,     7,     1,     3,     3 }, // Icelandic/Latin/Iceland
    {    109,    66,   258,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // Ido/Latin/World
    {    110,    66,   169,    0,    0,  459,  468,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,    0,    0, 7367, 7367, 7420, 7420,   83,   83,  249,  256,    0,    5,   22,  121, 2938,    9,   13, 3322, 3326,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 10,  5, 53, 53, 28, 28, 13, 13,  7,  7,  4, 17, 23,  1,  5,  4,  6,  4,  8, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Igbo/Latin/Nigeria
    {    111,    66,    83,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,  864,  695,  141,  141, 7448, 7517, 7589, 7589,   83, 7616,  256,  263,    0,    5,   22,   13,  420,   19,    0, 3334, 3345,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8,  9,  4, 69, 72, 27, 27, 13, 13,  3,  3,  4, 17, 23,  1,  4,  5,  0, 11,  5, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Inari Sami/Latin/Finland
    {    112,    66,   111,    0,    0,  476,  486,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  618,  127,  140,  140, 7629, 7629, 7671, 7671, 7698, 7698,    0,    0,    0,    5,   22,  243, 2943,    9,    0, 3350, 3350,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 42, 42, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2, 16,  4,  0,  9,  9, {73,68,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Indonesian/Latin/Indonesia
    {    114,    66,   258,    0,    0,  345,  345,    6,    1,    0,    2,    3,    4,    5,    9,   12,   13,   10,   11,  882,  432,    0,    0, 7711, 7711, 7767, 7767, 7794, 7794,    0,    0,    0,    5,   22,    0,    0,    4,   37, 3359, 3370,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26, 10, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  5, 17, 23,  0,  0,  5,  7, 11,  5,    {0,0,0},      2,     1,     1,     6,     7,     2,     3,     3 }, // Interlingua/Latin/World
    {    116,    18,    41,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  245,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {67,65,68},      2,     0,     7,     6,     7,     1,     3,     3 }, // Inuktitut/Canadian Aboriginal/Canada
    {    116,    66,    41,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  245,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {67,65,68},      2,     0,     7,     6,     7,     1,     3,     3 }, // Inuktitut/Latin/Canada
    {    118,    66,   114,    0,    0,  366,  366,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,  127,    0,    0, 7807, 7807, 7881, 7881, 7917, 7917,  259,  266,  592,    5,   22,   13,   73,    9,   13, 3375, 3382,  6,  6, 10, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 74, 74, 36, 36, 13, 13,  4,  4,  6, 17, 23,  1,  4,  4,  6,  7,  4, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Irish/Latin/Ireland
    {    118,    66,   246,    0,    0,  366,  366,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,  127,    0,    0, 7807, 7807, 7881, 7881, 7917, 7917,  259,  266,  592,    5,   22,   91, 2959,    9,   13, 3375, 3386,  6,  6, 10, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 74, 74, 36, 36, 13, 13,  4,  4,  6, 17, 23,  1, 14,  4,  6,  7, 19, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // Irish/Latin/United Kingdom
    {    119,    66,   117,    0,    0,  345,  345,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,  127,    0,    0, 7930, 7930, 7986, 7986, 8013, 8013,    0,    0,    0,    5,   22,   13,  420,   19,    0, 3405, 3413,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0,  8,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Italian/Latin/Italy
    {    119,    66,   203,    0,    0,  345,  345,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,  127,    0,    0, 7930, 7930, 7986, 7986, 8013, 8013,    0,    0,    0,    5,   22,   13,  420,   19,    0, 3405, 3419,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0,  8, 10, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Italian/Latin/San Marino
    {    119,    66,   226,    0,    0,  345,  345,    6,    0,   13,    2,    3,    4,    5,    9,   17,   18,   19,   20,    0,  184,    0,    0, 7930, 7930, 7986, 7986, 8013, 8013,    0,    0,    0,    5,   22,    0, 2973,   19,    0, 3405, 3429,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0, 15,  5,  0,  8,  8, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // Italian/Latin/Switzerland
    {    119,    66,   253,    0,    0,  345,  345,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,  127,    0,    0, 7930, 7930, 7986, 7986, 8013, 8013,    0,    0,    0,    5,   22,   13,  420,   19,    0, 3405, 3437,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 56, 56, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0,  8, 18, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Italian/Latin/Vatican City
    {    120,    53,   120,  148,  148,  148,  148,    6,    0,    1,    2,    3,    4,    5,    9,   42,   43,   44,   45,  462,  636,  323,    1, 8026, 8026, 8053, 8053, 8053, 8053,  263,  270,  598,  601,   22,  138, 2988,    9,   13, 3455, 3455,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 13, 10, 10,  4, 27, 27, 13, 13, 13, 13,  2,  2,  3, 17, 23,  1,  3,  4,  6,  3,  2, {74,80,89},      0,     0,     7,     6,     7,     1,     3,     3 }, // Japanese/Japanese/Japan
    {    121,    66,   111,    0,    0,  495,  505,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  432,    0,    0, 8066, 8066, 8106, 8106, 8134, 8134,  265,  272,  618,    5,   22,  243, 2943,    4,    0, 3458, 3462,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 40, 40, 28, 28, 13, 13,  4,  5,  4, 17, 23,  2, 16,  5,  0,  4,  9, {73,68,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Javanese/Latin/Indonesia
    {    122,    66,   169,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  121,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Jju/Latin/Nigeria
    {    123,    66,   206,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,   87,    0,    0, 8147, 8147, 8196, 8196, 8223, 8223,    0,    0,    0,    5,   22,    3, 2991,   19,    0, 3471, 3476,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 49, 49, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 16,  5,  0,  5,  7, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Jola Fonyi/Latin/Senegal
    {    124,    66,    43,    0,    0,  110,  110,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,  908,  127,    0,    0, 8236, 8236, 8308, 8308, 8335, 8335,   82,  195,    0,    5,   22,  248, 3007,   19,   24, 3483, 3495,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27, 10, 10,  5, 72, 72, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1, 18,  5,  7, 12, 10, {67,86,69},      2,     1,     1,     6,     7,     1,     3,     3 }, // Kabuverdianu/Latin/Cape Verde
    {    125,    66,     4,    0,    0,  514,  522,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,   87,   10,   22, 8348, 8381, 8431, 8458, 8487, 8500,  269,  277,  622,  629,   22,  177, 3025,    0,    0, 3505, 3514,  6,  6,  8,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 12,  7, 33, 50, 27, 29, 13, 13,  7,  9,  7, 21, 23,  2, 14,  4,  0,  9,  8, {68,90,68},      2,     1,     6,     5,     6,     1,     3,     3 }, // Kabyle/Latin/Algeria
    {    126,    66,    40,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   19,   20,   54,  935,    0,    0, 8513, 8513, 8513, 8513, 8566, 8566,    0,    0,    0,    5,   22,    2, 3039,    4,    0, 3522, 3526,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 53, 53, 53, 53, 20, 20,  2,  2,  4, 17, 23,  4,  9,  5,  0,  4,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Kako/Latin/Cameroon
    {    127,    66,    95,    0,    0,  529,  529,    6,    1,    0,    2,    3,   40,    5,   52,   18,   17,   20,   19,   54,   44,  140,  140, 8586, 8586, 8683, 8683, 8710, 8710,    0,    0,    0,    5,   22,  156, 3048,    9,   49, 3533, 3544,  6,  6, 11, 11,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 17, 10, 10,  5, 97, 97, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 19,  4,  5, 11, 16, {68,75,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Kalaallisut/Latin/Greenland
    {    128,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 8723, 8723, 8775, 8775, 8802, 8802,  276,  286,    0,    5,   22,  170, 3067,    9,   13, 3560, 3568,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 52, 52, 27, 27, 13, 13,  6, 10,  4, 17, 23,  3, 19,  4,  6,  8, 12, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Kalenjin/Latin/Kenya
    {    129,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 8815, 8815, 8888, 8888, 8915, 8915,  282,  296,    0,    5,   22,  170, 3086,    9,   13, 3580, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 73, 73, 27, 27, 13, 13,  9,  7,  4, 17, 23,  3, 16,  4,  6,  7,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Kamba/Latin/Kenya
    {    130,    56,   110,    0,    0,  540,  552,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,   87,  302,  315, 8928, 8928, 8981, 8981, 9013, 9013,  291,  303,  650,  658,   22,  117, 3102,    9,   13, 3587, 3592,  6,  6, 12, 11,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 13,  8, 53, 53, 32, 32, 19, 19,  9,  7,  8, 35, 23,  1, 13,  4,  6,  5,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Kannada/Kannada/India
    {    132,     4,   110,    0,    0,    0,    0,   53,   21,   22,   23,   61,   35,   62,   65,   10,   11,   12,   13,  321,  339,   10,   22, 9032, 9032, 9083, 9083, 9132, 9132,    0,    0,    0,    5,   22,  117, 3115,    4,    0, 3596, 3601,  6,  6,  6,  6,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 18,  6, 12,  7, 51, 51, 49, 49, 13, 13,  2,  2,  4, 17, 23,  1, 16,  5,  0,  5,  9, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Kashmiri/Arabic/India
    {    132,    29,   110,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  117,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Kashmiri/Devanagari/India
    {    133,    27,   123,    0,    0,    0,  563,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  945,  184,    0,    0, 9145, 9145, 9200, 9200, 9220, 9220,    0,    0,  206,  693,  710,  249, 3131,   19,    0, 3610, 3620,  6,  6,  6, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  8, 10,  5, 55, 55, 20, 20, 13, 13,  2,  2,  4, 17, 23,  1, 17,  5,  0, 10,  9, {75,90,84},      2,     1,     1,     6,     7,     1,     3,     3 }, // Kazakh/Cyrillic/Kazakhstan
    {    134,    66,    40,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    2,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  4,  0,  5,  0,  0,  0, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Kenyang/Latin/Cameroon
    {    135,    60,    39,    0,    0,  573,  582,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,   10,   22, 9233, 9278, 9324, 9324, 9363, 9363,    0,    0,  733,    5,   22,  250, 3148,    0,   31, 3629, 3634,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  6, 12,  7, 45, 46, 39, 39, 13, 13,  2,  2,  2, 17, 23,  1, 11,  4,  6,  5,  7, {75,72,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Khmer/Khmer/Cambodia
    {    136,    66,    99,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  251,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {71,84,81},      2,     1,     7,     6,     7,     1,     3,     3 }, // Kiche/Latin/Guatemala
    {    137,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 9376, 9376, 9438, 9438, 9465, 9465,  300,  310,    0,    5,   22,  170, 3159,    9,   13, 3641, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 62, 62, 27, 27, 13, 13,  6,  8,  4, 17, 23,  3, 16,  4,  6,  6,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Kikuyu/Latin/Kenya
    {    138,    66,   194,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   12,   13,   27,   44,    0,    0, 9478, 9478, 9561, 9561,   83,   83,    0,    0,    0,    5,   22,  186,    0,    4,    0, 3647, 3658,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 83, 83, 34, 34, 13, 13,  2,  2,  4, 17, 23,  2,  0,  5,  0, 11,  8, {82,87,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Kinyarwanda/Latin/Rwanda
    {    141,    29,   110,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,  210,   10,   22, 9595, 9595, 9595, 9595, 9645, 9663,    0,    0,  735,    5,   22,  117, 2900,    9,   13, 3666,  569,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  6, 12,  7, 50, 50, 50, 50, 18, 19,  2,  2,  4, 17, 23,  1, 12,  4,  6,  6,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Konkani/Devanagari/India
    {    142,    63,   218,    0,    0,  591,  591,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  967,  983,  333,  346, 9682, 9682, 9709, 9709, 9709, 9709,  306,  318,  739,    5,   22,  252, 3175,    9,   13, 3672, 3675,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  9, 13,  7, 27, 27, 13, 13, 13, 13,  2,  2,  3, 17, 23,  1,  6,  4,  6,  3,  4, {75,82,87},      0,     0,     7,     6,     7,     1,     3,     3 }, // Korean/Korean/South Korea
    {    142,    63,   174,    0,    0,  591,  591,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  967,  983,  333,  346, 9682, 9682, 9709, 9709, 9709, 9709,  306,  318,  739,    5,   22,  253, 3181,    9,   13, 3672, 3679,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  9, 13,  7, 27, 27, 13, 13, 13, 13,  2,  2,  3, 17, 23,  3, 16,  4,  6,  3, 11, {75,80,87},      0,     0,     1,     6,     7,     1,     3,     3 }, // Korean/Korean/North Korea
    {    144,    66,   145,    0,    0,    0,    0,    6,    0,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0, 9722, 9722, 9775, 9775, 9802, 9802,  308,  320,    0,    5,   22,    3, 3197,    0,    0, 3690, 3705,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 53, 53, 27, 27, 13, 13,  6,  6,  4, 17, 23,  3, 16,  4,  0, 15,  5, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Koyraboro Senni/Latin/Mali
    {    145,    66,   145,    0,    0,    0,    0,    6,    0,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0, 9815, 9815, 9867, 9867, 9802, 9802,  308,  320,    0,    5,   22,    3, 3197,    0,    0, 3710, 3705,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 52, 52, 27, 27, 13, 13,  6,  6,  4, 17, 23,  3, 16,  4,  0, 11,  5, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Koyra Chiini/Latin/Mali
    {    146,    66,   134,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {76,82,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Kpelle/Latin/Liberia
    {    148,    66,   239,    0,    0,  598,  598,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0, 9894, 9894, 9935, 9935, 9954, 9954,  314,  326,    0,    5,   22,  256,    0,   19,   24, 3721, 3726,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 41, 41, 19, 19, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  7,  5,  7, {84,82,89},      2,     1,     1,     6,     7,     1,     3,     3 }, // Kurdish/Latin/Turkey
    {    149,    66,    40,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   17,   18,   71,   87,    0,    0, 9967, 9967,10055,10055,10084,10084,  316,  328,    0,    5,   22,    2, 3213,   19,    0, 3733, 3739,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 88, 88, 29, 29, 13, 13,  4,  4,  4, 17, 23,  4, 13,  5,  0,  6,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Kwasio/Latin/Cameroon
    {    150,    27,   128,    0,    0,  605,  605,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,  992,   87,    0,    0,10097,10097,10153,10153,10190,10190,  320,  332,  206,  742,   22,  257, 3226,   19,    0, 3746, 3754,  6,  6, 10, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  6, 10,  5, 56, 56, 37, 37, 13, 13,  5, 14,  4, 18, 23,  3, 15,  5,  0,  8, 10, {75,71,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Kyrgyz/Cyrillic/Kyrgyzstan
    {    151,    66,   248,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,10203,10203,10203,10203,   83,10289,    0,    0,    0,    5,   22,    1,    0,    4,    0, 3764, 3776,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 86, 86, 86, 86, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0, 12, 22, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Lakota/Latin/United States
    {    152,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   11,   11,   13,   13,    0,  127,    0,    0,10302,10302,10364,10364,10399,10399,  325,  346,    0,    5,   22,  118, 3241,    4,    0, 3798, 3806,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 62, 62, 35, 35, 13, 13,  3,  3,  4, 17, 23,  3, 22,  5,  0,  8,  9, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Langi/Latin/Tanzania
    {    153,    65,   129,    0,    0,    0,  615,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1015,   87,  353,    1,10412,10412,10468,10468,10503,10503,  328,  349,    0,    5,   22,  260, 3263,    9,   44, 3815, 3815,  6,  6,  6,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  8, 24,  4, 56, 56, 35, 35, 16, 16,  8,  8,  4, 17, 23,  1,  7,  4,  5,  3,  3, {76,65,75},      0,     0,     7,     6,     7,     1,     3,     3 }, // Lao/Lao/Laos
    {    154,    66,   253,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   13,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Latin/Latin/Vatican City
    {    155,    66,   131,    0,    0,  214,  214,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1034,  184,    0,    0,10519,10590,10661,10711,10761,10761,  336,  357,  760,    5,   22,   13, 3270,   19,    0, 3818, 3826,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26,  8, 10,  5, 71, 71, 50, 50, 13, 13, 14, 11,  5, 17, 23,  1,  4,  5,  0,  8,  7, {69,85,82},      2,     1,     1,     6,     7,     2,     3,     3 }, // Latvian/Latin/Latvia
    {    158,    66,    57,    0,    0,  624,  624,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0,10774,10774,10873,10873,10900,10900,  350,  368,    0,    5,   22,    2, 3274,   19,    0, 3833, 3840,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 99, 99, 27, 27, 13, 13,  8,  6,  4, 17, 23,  2, 16,  5,  0,  7, 30, {67,68,70},      2,     1,     1,     6,     7,     1,     3,     3 }, // Lingala/Latin/Congo Kinshasa
    {    158,    66,     7,    0,    0,  624,  624,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0,10774,10774,10873,10873,10900,10900,  350,  368,    0,    5,   22,  261, 3290,   19,    0, 3833, 3870,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 99, 99, 27, 27, 13, 13,  8,  6,  4, 17, 23,  2, 16,  5,  0,  7,  6, {65,79,65},      2,     1,     1,     6,     7,     1,     3,     3 }, // Lingala/Latin/Angola
    {    158,    66,    46,    0,    0,  624,  624,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0,10774,10774,10873,10873,10900,10900,  350,  368,    0,    5,   22,    2, 3306,   19,    0, 3833, 3876,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 99, 99, 27, 27, 13, 13,  8,  6,  4, 17, 23,  4, 16,  5,  0,  7, 26, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Lingala/Latin/Central African Republic
    {    158,    66,    56,    0,    0,  624,  624,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0,10774,10774,10873,10873,10900,10900,  350,  368,    0,    5,   22,    2, 3306,   19,    0, 3833, 3902,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 99, 99, 27, 27, 13, 13,  8,  6,  4, 17, 23,  4, 16,  5,  0,  7,  5, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Lingala/Latin/Congo Brazzaville
    {    160,    66,   137,    0,    0,  633,  633,    6,    1,   14,    2,    3,   40,    5,   52,   15,   10,   15,   10, 1060,   44,    0,    0,10913,10913,11001,11001,11021,11021,  358,  374,  765,    5,   22,   13, 3322,   19,    0, 3907, 3915,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 27, 10, 10,  5, 88, 88, 20, 20, 13, 13,  9,  6,  6, 17, 23,  1,  5,  5,  0,  8,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Lithuanian/Latin/Lithuania
    {    161,    66,   258,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // Lojban/Latin/World
    {    162,    66,    91,    0,    0,  222,  222,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  121,    1,    1,11034,11034,11086,11086,11113,11113,  367,  380,    0,    5,   22,   13,  420,   19,    0, 3922, 3936,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6,  9,  4, 52, 52, 27, 27, 13, 13,  9, 10,  4, 17, 23,  1,  4,  5,  0, 14,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Lower Sorbian/Latin/Germany
    {    163,    66,    91,    0,    0,  214,  214,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12, 1087,  185,  377,  396,11126,11126,11190,11190, 3667, 3667,    0,    0,    0,    5,   22,   13,   73,   19,    0, 3942, 3956,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  7, 19, 10, 64, 64, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0, 14, 11, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Low German/Latin/Germany
    {    163,    66,   165,    0,    0,  214,  214,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12, 1087,  185,  377,  396,11126,11126,11190,11190, 3667, 3667,    0,    0,    0,    5,   22,   13,   73,   19,    0, 3942, 3967,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  7, 19, 10, 64, 64, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0, 14, 12, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Low German/Latin/Netherlands
    {    164,    66,    57,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0,11217,11217,11266,11266,11293,11293,  376,  390,    0,    5,   22,    2, 3327,    0,    0, 3979, 3987,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 49, 49, 27, 27, 13, 13,  5,  6,  4, 17, 23,  2, 17,  4,  0,  8, 16, {67,68,70},      2,     1,     1,     6,     7,     1,     3,     3 }, // Luba Katanga/Latin/Congo Kinshasa
    {    165,    66,   225,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  156,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2,  0,  5,  0,  0,  0, {83,69,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Lule Sami/Latin/Sweden
    {    166,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,11306,11306,11374,11374,11401,11401,  381,  396,    0,    5,   22,  170, 3344,    0,    0, 4003, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 68, 68, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 16,  4,  0,  6,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Luo/Latin/Kenya
    {    167,    66,   138,    0,    0,  641,  641,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  184,    0,    0,11414,11414,11478,11505, 3667, 3667,  383,  398,  479,    5,   22,   13,   73,   19,    0, 4009, 4009,  6,  6, 10, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 64, 64, 27, 34, 13, 13,  5,  8,  5, 17, 23,  1,  4,  5,  0, 14, 10, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Luxembourgish/Latin/Luxembourg
    {    168,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   15,   10,   16,   12,    0,  127,    0,    0,11539,11539,11613,11613,   83,   83,  165,  164,    0,    5,   22,  170, 3360,    9,   54, 4023, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 74, 74, 20, 20, 13, 13,  4,  4,  4, 17, 23,  3, 16,  4,  6,  7,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Luyia/Latin/Kenya
    {    169,    27,   140,    0,    0,  117,  117,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,    0,  121,    0,    0,11633,11633,11686,11720, 2519, 2519,  388,  406,  771,    5,   22,  263, 3376,   19,    0, 4030, 4040,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 10,  5, 53, 53, 34, 33, 13, 13, 10,  8,  5, 17, 23,  4, 16,  5,  0, 10, 18, {77,75,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Macedonian/Cyrillic/Macedonia
    {    170,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,11753,11753,11814,11814, 1041, 1041,  398,  414,    0,    5,   22,  118, 3392,    9,    0, 4058, 2025,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 61, 61, 27, 27, 13, 13,  5,  9,  4, 17, 23,  3, 20,  4,  0,  9,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Machame/Latin/Tanzania
    {    171,    29,   110,    0,    0,  434,  443,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22, 7054, 7054, 7106, 7106, 7137, 7137,   82,  195,    0,    5,   22,  117, 2900,    4,    0, 4067,  569,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 52, 52, 31, 31, 18, 18,  2,  2,  4, 17, 23,  1, 12,  5,  0,  6,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Maithili/Devanagari/India
    {    172,    66,   160,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,11841,11841,11899,11899,11926,11926,  403,  423,    0,    5,   22,  267,    0,    4,    0, 4073, 4078,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 58, 58, 27, 27, 13, 13,  8, 10,  4, 17, 23,  3,  0,  5,  0,  5, 10, {77,90,78},      2,     1,     7,     6,     7,     1,     3,     3 }, // Makhuwa Meetto/Latin/Mozambique
    {    173,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,11939,11939,12071,12071,12098,12098,  411,  433,    0,    5,   22,  118, 3392,    9,   13, 4088, 2025,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,132,132, 27, 27, 13, 13,  4,  5,  4, 17, 23,  3, 20,  4,  6, 10,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Makonde/Latin/Tanzania
    {    174,    66,   141,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,   44,    0,    0,12111,12111,12170,12170,12203,12203,    0,    0,    0,    5,   22,  178, 1459,    9,    0, 4098, 4106,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 59, 59, 33, 33, 13, 13,  2,  2,  4, 17, 23,  2,  6,  4,  0,  8, 12, {77,71,65},      0,     0,     1,     6,     7,     1,     3,     3 }, // Malagasy/Latin/Madagascar
    {    175,    74,   110,    0,    0,  651,  664,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1110,   87,   10,   22,12216,12292,12367,12367,12407,12428,    0,    0,  776,  782,   22,  117, 3412,    9,   13, 4118, 4124,  6,  6, 13, 12,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 76, 75, 40, 40, 21, 20,  2,  2,  6, 27, 23,  1, 11,  4,  6,  6,  6, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Malayalam/Malayalam/India
    {    176,    66,   143,    0,    0,  486,  486,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  128,   10,   22,12448,12448,12490,12490,12517,12517,  415,  438,  760,    5,   22,  182, 3423,    9,   13, 4130, 1640,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  7, 12,  7, 42, 42, 27, 27, 13, 13,  2,  3,  4, 17, 23,  2, 16,  4,  6,  6,  8, {77,89,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Malay/Latin/Malaysia
    {    176,     4,   143,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  182,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2,  0,  5,  0,  0,  0, {77,89,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Malay/Arabic/Malaysia
    {    176,    66,    35,    0,    0,  486,  486,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   59,  128,   10,   22,12448,12448,12490,12490,12517,12517,  415,  438,  760,    5,   22,    1, 3439,    9,   13, 4130, 4136,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 12,  7, 12,  7, 42, 42, 27, 27, 13, 13,  2,  3,  4, 17, 23,  1, 12,  4,  6,  6,  6, {66,78,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Malay/Latin/Brunei
    {    176,    66,   111,    0,    0,  486,  486,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  618,  127,  140,  140,12448,12448,12490,12490,12517,12517,  415,  438,  760,    5,   22,  243, 2943,    9,    0, 4130, 3350,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 42, 42, 27, 27, 13, 13,  2,  3,  4, 17, 23,  2, 16,  4,  0,  6,  9, {73,68,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Malay/Latin/Indonesia
    {    176,    66,   210,    0,    0,  486,  486,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  128,   10,   22,12448,12448,12490,12490,12517,12517,  415,  438,  760,    5,   22,    1, 3451,    9,   13, 4130, 4142,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  7, 12,  7, 42, 42, 27, 27, 13, 13,  2,  3,  4, 17, 23,  1, 15,  4,  6,  6,  9, {83,71,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Malay/Latin/Singapore
    {    177,    66,   146,    0,    0,  676,  684,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1128,  127,    0,    0,12530,12530,12592,12592,12619,12639,    0,    0,    0,    5,   22,   13, 3466,    9,    0, 4151, 1648,  6,  6,  8,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 10, 10,  5, 62, 62, 27, 27, 20, 19,  2,  2,  4, 17, 23,  1,  4,  4,  0,  5,  5, {69,85,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Maltese/Latin/Malta
    {    179,     9,   110,    0,    0,  691,  691,    6,    0,    1,    2,   39,    4,    5,    9,   10,   11,   12,   13, 1151,   87,   10,   22,12658,12658,12658,12658,12716,12741,  417,  441,    0,    5,   22,  117, 3470,    4,    0, 4156, 4164,  6,  6, 11, 11,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 58, 58, 58, 58, 25, 26,  4,  5,  4, 17, 23,  1, 14,  5,  0,  8,  8, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Manipuri/Bangla/India
    {    179,    78,   110,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  117,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Manipuri/Meitei Mayek/India
    {    180,    66,   115,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   54,  127,    0,    0,12767,12767,12823,12823,   83,   83,  165,  164,    0,    5,   22,   91,    0,    9,    0, 4172, 4177,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8, 10,  5, 56, 56, 29, 29, 13, 13,  4,  4,  4, 17, 23,  1,  0,  4,  0,  5, 12, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // Manx/Latin/Isle Of Man
    {    181,    66,   167,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  432,   10,   22,12852,12852,12898,12898,12924,12924,    0,    0,    0,    5,   22,    1, 3484,    4,    0, 4189, 4201,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 46, 46, 26, 26, 13, 13,  2,  2,  4, 17, 23,  1, 15,  5,  0, 12,  8, {78,90,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Maori/Latin/New Zealand
    {    182,    66,    49,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    1,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {67,76,80},      0,     0,     1,     6,     7,     1,     3,     3 }, // Mapuche/Latin/Chile
    {    183,    29,   110,    0,    0,  702,  702,    6,    0,    1,    2,   69,    4,    5,    9,   10,   11,   12,   13,  192,   87,   10,   22,12937,12937,12989,12989, 7137, 7137,    0,    0,  580,    5,   22,  117, 2900,    9,   13, 4209,  569,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 52, 52, 31, 31, 18, 18,  2,  2,  4, 17, 23,  1, 12,  4,  6,  5,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Marathi/Devanagari/India
    {    185,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,13020,13020,11814,11814,12098,12098,  421,  446,    0,    5,   22,  170, 3499,    9,   13, 1071, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 57, 57, 27, 27, 13, 13,  9,  6,  4, 17, 23,  3, 18,  4,  6,  3,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Masai/Latin/Kenya
    {    185,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,13020,13020,11814,11814,12098,12098,  421,  446,    0,    5,   22,  118, 3517,    9,   13, 1071, 4214,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 57, 57, 27, 27, 13, 13,  9,  6,  4, 17, 23,  3, 21,  4,  6,  3,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Masai/Latin/Tanzania
    {    186,     4,   112,    0,    0,    0,    0,   53,   21,   22,   23,   61,   35,   62,   65,   17,   18,   19,   20,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,  809,  813,   22,  270, 3538,    4,    0, 4222, 4229,  6,  6,  6,  6,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 39, 23,  3, 10,  5,  0,  7,  5, {73,82,82},      0,     0,     6,     5,     5,     1,     3,     3 }, // Mazanderani/Arabic/Iran
    {    188,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,13077,13077,13127,13127,13154,13154,  430,  452,    0,    5,   22,  170,  952,    9,   13, 4234, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 50, 50, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 17,  4,  6,  6,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Meru/Latin/Kenya
    {    189,    66,    40,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   95,   44,    0,    0,13167,13167,13167,13167,13215,13215,    0,    0,    0,    5,   22,    2, 3548,    4,    0, 4240, 4245,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 10,  5, 48, 48, 48, 48, 20, 20,  2,  2,  4, 17, 23,  4,  5,  5,  0,  5,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Meta/Latin/Cameroon
    {    190,    66,    41,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  245,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {67,65,68},      2,     0,     7,     6,     7,     1,     3,     3 }, // Mohawk/Latin/Canada
    {    191,    27,   156,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1169, 1204,   54,    0,13235,13277,13319,13319,13319,13319,  432,  454,  206,  852,   22,  273, 3553,    4,    0, 4252, 4258,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 35, 10, 12,  5, 42, 42, 20, 20, 20, 20,  4,  4,  4, 17, 23,  1, 13,  5,  0,  6,  6, {77,78,84},      2,     0,     1,     6,     7,     1,     3,     3 }, // Mongolian/Cyrillic/Mongolia
    {    191,    83,    50,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  274,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {67,78,89},      2,     1,     7,     6,     7,     1,     3,     3 }, // Mongolian/Mongolian/China
    {    192,    66,   150,    0,    0,    0,    0,    6,    0,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0,13339,13339,13386,13386,13412,13412,    0,    0,    0,    5,   22,  184, 3566,    4,    0, 4264, 4278,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 47, 47, 26, 26, 13, 13,  2,  2,  4, 17, 23,  2, 14,  5,  0, 14,  5, {77,85,82},      2,     0,     1,     6,     7,     1,     3,     3 }, // Morisyen/Latin/Mauritius
    {    193,    66,    40,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,   87,    0,    0,13425,13425,13498,13498,13525,13525,  436,  458,    0,    5,   22,    2, 3580,    9,   13, 4283, 4289,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 73, 73, 27, 27, 13, 13,  5,  5,  4, 17, 23,  4, 10,  4,  6,  6,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Mundang/Latin/Cameroon
    {    194,    66,   248,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  140,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Muscogee/Latin/United States
    {    195,    66,   162,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,13538,13538,13629,13629,13651,13651,  441,  463,    0,    5,   22,    1, 3590,    9,    0, 4296, 4309,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 91, 91, 22, 22, 13, 13,  7,  5,  4, 17, 23,  1, 15,  4,  0, 13,  8, {78,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Nama/Latin/Namibia
    {    197,    66,   248,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  140,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Navajo/Latin/United States
    {    199,    29,   164,  711,    0,  716,  716,    6,    0,    1,    2,   69,    4,    5,    9,   10,   11,   12,   13,   27,  293,    0,    0,13664,13664,13717,13717,13749,13749,  448,  468,  580,  869,   22,  277, 3605,    4,    0, 4317, 4317,  5,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 10,  5, 53, 53, 32, 32, 17, 17,  9,  7,  4, 19, 23,  4, 14,  5,  0,  6,  5, {78,80,82},      2,     1,     7,     6,     7,     1,     2,     3 }, // Nepali/Devanagari/Nepal
    {    199,    29,   110,  711,    0,  716,  716,    6,    0,    1,    2,   69,    4,    5,    9,   10,   11,   12,   13,   27,  293,   10,   22,13664,13664,13717,13717,13749,13749,  448,  468,  580,  869,   22,  117, 3619,    4,    0, 4317,  569,  5,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 53, 53, 32, 32, 17, 17,  9,  7,  4, 19, 23,  1, 14,  5,  0,  6,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Nepali/Devanagari/India
    {    201,    66,    40,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11, 1214,  127,    0,    0,13766,13766,13766,13766,   83,   83,  457,  475,    0,    5,   22,    2, 3633,    4,    0, 4323, 4339,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 32,  8, 10,  5,110,110,110,110, 13, 13,  9,  8,  4, 17, 23,  4,  9,  5,  0, 16,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Ngiemboon/Latin/Cameroon
    {    202,    66,    40,  723,  723,  734,  750,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   19,   20,   95,   44,    0,    0,13876,13876,13876,13876,13935,13935,  466,  483,    0,    5,   22,    2, 3642,    4,    0, 4346, 4351, 11, 11, 16,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 10,  5, 59, 59, 59, 59, 24, 24,  8, 13,  4, 17, 23,  4,  5,  5,  0,  5,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Ngomba/Latin/Cameroon
    {    203,    66,   169,    0,    0,  759,  768,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,13959,13959,14010,14010,   83,   83,  474,  496,  888,    5,   22,  121, 3647,    9,    0, 4358, 4372,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 51, 51, 32, 32, 13, 13,  9,  8,  8, 17, 23,  1, 14,  4,  0, 14,  8, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Nigerian Pidgin/Latin/Nigeria
    {    204,    90,   102,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  208,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2,  0,  5,  0,  0,  0, {71,78,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Nko/Nko/Guinea
    {    205,     4,   112,    0,    0,    0,    0,   53,   21,   22,   23,   61,   35,   62,   65,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0, 4380,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0, 11,  0, {73,82,82},      0,     0,     6,     5,     5,     1,     3,     3 }, // Northern Luri/Arabic/Iran
    {    205,     4,   113,    0,    0,    0,    0,   53,   21,   22,   23,   61,   35,   62,   65,   10,   11,   12,   13,   27,   44,   10,   22,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   40,    0,    4,    0, 4380,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 17, 10, 12,  7, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  5,  0,  5,  0, 11,  0, {73,81,68},      0,     0,     6,     5,     6,     1,     3,     3 }, // Northern Luri/Arabic/Iraq
    {    206,    66,   175,    0,    0,  291,  291,    6,    1,   14,    2,    3,   40,    5,   70,   11,   11,   13,   13,   27,   44,    0,    0,14042,14042,14116,14116,14148,14148,  483,  504,    0,    5,   22,  156, 3661,   19,    0, 4391, 4406,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 17, 10, 10,  5, 74, 74, 32, 32, 13, 13, 11, 13,  4, 17, 23,  2, 14,  5,  0, 15,  5, {78,79,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Northern Sami/Latin/Norway
    {    206,    66,    83,    0,    0,  291,  291,    6,    1,   14,    2,    3,   40,    5,   70,   11,   11,   13,   13,   71,  560,    0,    0,14161,14161,14230,14230,14250,14250,  494,  181,    0,    5,   22,   13,  420,   19,    0, 4391, 4411,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 16, 10, 10,  5, 69, 69, 20, 20, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0, 15,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Northern Sami/Latin/Finland
    {    206,    66,   225,    0,    0,  291,  291,    6,    1,   14,    2,    3,   40,    5,   70,   11,   11,   13,   13,   27,   44,    0,    0,14042,14042,14116,14116,14148,14148,  483,  504,    0,    5,   22,  156, 3675,   19,    0, 4391, 4417,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 17, 10, 10,  5, 74, 74, 32, 32, 13, 13, 11, 13,  4, 17, 23,  2, 14,  5,  0, 15,  6, {83,69,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Northern Sami/Latin/Sweden
    {    207,    66,   216,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Northern Sotho/Latin/South Africa
    {    208,    66,   261,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,14263,14263,14312,14312,14339,14339,    0,    0,    0,    5,   22,  140, 3689,    9,   13, 4423, 2191,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 49, 49, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 17,  4,  6, 10,  8, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // North Ndebele/Latin/Zimbabwe
    {    209,    66,   175,    0,    0,  229,  229,    6,    1,   14,    2,    3,   40,    5,    9,   17,   18,   12,   13,  520,  560,    0,    0, 3848, 3848, 3925, 3925, 3959, 3959,  165,  164,    0,    5,   22,  156, 3706,    4,    0, 4433, 4445,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 50, 50, 34, 34, 13, 13,  4,  4,  4, 17, 23,  2, 13,  5,  0, 12,  5, {78,79,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Norwegian Bokmal/Latin/Norway
    {    209,    66,   224,    0,    0,  229,  229,    6,    1,   14,    2,    3,   40,    5,    9,   17,   18,   12,   13,  520,  560,    0,    0, 3848, 3848, 3925, 3925, 3959, 3959,  165,  164,    0,    5,   22,  156, 3706,    4,    0, 4433, 4450,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 50, 50, 34, 34, 13, 13,  4,  4,  4, 17, 23,  2, 13,  5,  0, 12, 21, {78,79,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Norwegian Bokmal/Latin/Svalbard And Jan Mayen
    {    210,    66,   175,    0,    0,  229,  229,    6,    1,   14,    2,    3,   40,    5,    9,   17,   18,   12,   13,  520,  560,  406,    0,14352,14352,14402,14429, 3959, 3959,  496,  517,    0,    5,   22,  156, 3706,   19,    0, 4471, 4484,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 16,  5, 50, 50, 27, 27, 13, 13,  9, 11,  4, 17, 23,  2, 13,  5,  0, 13,  5, {78,79,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Norwegian Nynorsk/Latin/Norway
    {    211,    66,   219,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,  128,  422,   22,14456,14456,14534,14534,14571,14571,  505,  528,    0,    5,   22,   91,    0,    9,   13, 4489,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  9, 12,  7, 78, 78, 37, 37, 13, 13,  2,  2,  4, 17, 23,  1,  0,  4,  6,  9,  0, {83,83,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // Nuer/Latin/South Sudan
    {    212,    66,   142,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {77,87,75},      2,     1,     1,     6,     7,     1,     3,     3 }, // Nyanja/Latin/Malawi
    {    213,    66,   243,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0, 3436, 3436, 3509, 3509, 3536, 3536,    0,    0,    0,    5,   22,  143,  783,    9,    0, 4498,  857,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 73, 73, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 19,  4,  0, 10,  6, {85,71,88},      0,     0,     1,     7,     7,     1,     3,     3 }, // Nyankole/Latin/Uganda
    {    214,    66,    84,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   13,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Occitan/Latin/France
    {    215,    91,   110,    0,    0,  776,  784,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,   10,   22,14584,14584,14637,14637,14669,14669,    0,    0,  896,    5,   22,  117, 3719,    9,   13, 4508, 4513,  6,  6,  8,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 53, 53, 32, 32, 17, 17,  2,  2,  5, 17, 23,  1, 12,  4,  6,  5,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Odia/Odia/India
    {    220,    66,    77,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  127,   10,   22,14686,14686,14740,14740,   83,   83,  507,  530,    0,    5,   22,  125, 3731,    9,    0, 4517, 4523,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 12,  7, 54, 54, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2, 17,  4,  0,  6, 10, {69,84,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Oromo/Latin/Ethiopia
    {    220,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  127,    0,    0,14686,14686,14740,14740,14767,14767,  507,  530,    0,    5,   22,  170,    0,    9,    0, 4517, 4533,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 54, 54, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  4,  0,  6,  8, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Oromo/Latin/Kenya
    {    221,   101,   248,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  140,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Osage/Osage/United States
    {    222,    27,    90,    0,    0,  791,  791,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10, 1246,  184,    0,    0,14780,14840,14900,14927,14954,14954,  509,  532,    0,    5,   22,  236, 3748,    4,    0, 4541, 4545,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  8, 10,  5, 60, 60, 27, 27, 13, 13, 15, 15,  4, 17, 23,  1,  3,  5,  0,  4, 11, {71,69,76},      2,     1,     1,     6,     7,     1,     3,     3 }, // Ossetic/Cyrillic/Georgia
    {    222,    27,   193,    0,    0,  791,  791,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10, 1246,  184,    0,    0,14780,14840,14900,14927,14954,14954,  509,  532,    0,    5,   22,  124, 3751,    4,    0, 4541, 4556,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  8, 10,  5, 60, 60, 27, 27, 13, 13, 15, 15,  4, 17, 23,  1,  3,  5,  0,  4,  6, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Ossetic/Cyrillic/Russia
    {    227,     4,     1,  800,  800,  806,  815,   53,   21,   22,   23,   61,   35,   62,   65,   10,   11,   12,   13, 1269,  454,   55,    1,14967,14967,14967,14967,   83,   83,  524,  547,  901,    5,   22,  281, 3754,    9,   13, 4562, 4566,  6,  6,  9,  8,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 20,  8, 11,  4, 38, 38, 38, 38, 13, 13,  4,  4,  5, 17, 23,  1,  6,  4,  6,  4,  9, {65,70,78},      0,     0,     6,     4,     5,     1,     3,     3 }, // Pashto/Arabic/Afghanistan
    {    227,     4,   178,  800,  800,  806,  815,   53,   21,   22,   23,   61,   35,   62,   65,   10,   11,   12,   13, 1269,  454,   10,   22,14967,14967,14967,14967,   83,   83,  524,  547,  901,    5,   22,  184, 3760,    9,   13, 4562, 4575,  6,  6,  9,  8,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 20,  8, 12,  7, 38, 38, 38, 38, 13, 13,  4,  4,  5, 17, 23,  2, 15,  4,  6,  4,  7, {80,75,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Pashto/Arabic/Pakistan
    {    228,     4,   112,  823,  823,  830,  838,   53,   21,   22,   23,   61,   74,   37,   65,   17,   18,   19,   20,   71,  454,   55,    1,15005,15005,15005,15005,15053,15053,  528,  551,  809,  906,   22,  282, 3775,   60,   66, 4582, 4229,  7,  7,  8,  7,  1,  1,  1,  1,  1,  2,  2,  4,  1,  1,  1,  1, 16,  8, 11,  4, 48, 48, 48, 48, 13, 13,  9,  8,  4, 42, 23,  4, 10,  6,  8,  5,  5, {73,82,82},      0,     0,     6,     5,     5,     1,     3,     3 }, // Persian/Arabic/Iran
    {    228,     4,     1,  823,  823,  830,  838,   53,   21,   22,   23,   61,   74,   37,   65,   17,   18,   19,   20,   71,  454,   55,    1,15005,15005,15005,15005,15053,15053,  528,  551,  809,  906,   22,  281, 3785,    4,   66, 4587, 4566,  7,  7,  8,  7,  1,  1,  1,  1,  1,  2,  2,  4,  1,  1,  1,  1, 16,  8, 11,  4, 48, 48, 48, 48, 13, 13,  9,  8,  4, 42, 23,  1, 16,  5,  8,  3,  9, {65,70,78},      0,     0,     6,     4,     5,     1,     3,     3 }, // Persian/Arabic/Afghanistan
    {    230,    66,   187,    0,    0,  110,  110,    6,    1,   14,    2,    3,    4,    5,    9,   15,   11,   17,   18,    0,  560,    0,    0,15066,15066,15124,15124,15157,15170,    0,    0,  321,    5,   22,  286, 3801,   19,   24, 4590, 4596,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 58, 58, 33, 33, 13, 13,  2,  2,  5, 17, 23,  2, 12,  5,  7,  6,  6, {80,76,78},      2,     1,     1,     6,     7,     2,     3,     3 }, // Polish/Latin/Poland
    {    231,    66,    32,    0,    0,  345,  345,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,  127,    0,    0,15183,15183,15261,15261,15295,15295,    0,    0,    0,    5,   22,    0, 3813,    4,    0, 4602, 4611,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27, 10, 10,  5, 78, 78, 34, 34, 13, 13,  2,  2,  5, 17, 23,  2, 15,  5,  0,  9,  6, {66,82,76},      2,     1,     7,     6,     7,     1,     3,     3 }, // Portuguese/Latin/Brazil
    {    231,    66,     7,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,  261, 3828,   19,   24, 4602, 4617,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  2, 15,  5,  7,  9,  6, {65,79,65},      2,     1,     1,     6,     7,     1,     3,     3 }, // Portuguese/Latin/Angola
    {    231,    66,    43,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,  248, 3843,   19,   24, 4602, 4623,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  1, 20,  5,  7,  9, 10, {67,86,69},      2,     1,     1,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Cape Verde
    {    231,    66,    73,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,    2, 3863,   19,   24, 4602, 4633,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  4, 17,  5,  7,  9, 16, {88,65,70},      0,     0,     1,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Equatorial Guinea
    {    231,    66,   101,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,    3, 3880,   19,   24, 4602, 4649,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  3, 18,  5,  7,  9, 12, {88,79,70},      0,     0,     1,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Guinea Bissau
    {    231,    66,   138,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,   13,  420,   19,   24, 4602, 4661,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  1,  4,  5,  7,  9, 10, {69,85,82},      2,     1,     1,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Luxembourg
    {    231,    66,   139,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,   10,   22,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,  147, 3898,   19,   24, 4602, 4671,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 12,  7, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  4, 15,  5,  7,  9, 19, {77,79,80},      2,     1,     7,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Macao
    {    231,    66,   160,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,  267, 3913,   19,   24, 4602, 4690,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  3, 19,  5,  7,  9, 10, {77,90,78},      2,     1,     7,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Mozambique
    {    231,    66,   188,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,   13,  420,   19,   24, 4700, 4717,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  1,  4,  5,  7, 17,  8, {69,85,82},      2,     1,     7,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Portugal
    {    231,    66,   204,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,  288, 3932,   19,   24, 4602, 4725,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  2, 28,  5,  7,  9, 19, {83,84,78},      2,     1,     1,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Sao Tome And Principe
    {    231,    66,   226,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,  215, 3960,   19,   24, 4602, 4744,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  3, 12,  5,  7,  9,  5, {67,72,70},      2,     0,     1,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Switzerland
    {    231,    66,   232,    0,    0,  345,  345,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,  127,    0,    0,15183,15183,15308,15308,15295,15295,  537,  559,    0,    5,   22,  140, 3972,   19,   24, 4602, 4749,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 78, 78, 48, 48, 13, 13,  8,  8,  5, 17, 23,  3, 24,  5,  7,  9, 11, {85,83,68},      2,     1,     1,     6,     7,     2,     3,     3 }, // Portuguese/Latin/Timor-Leste
    {    232,    66,   258,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // Prussian/Latin/World
    {    233,    41,   110,    0,    0,  845,  845,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22,15356,15356,15412,15412,15447,15447,  545,  567,  948,    5,   22,  117, 3996,    4,    0, 4760, 4766,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 56, 56, 35, 35, 22, 22,  6,  6,  4, 17, 23,  1, 11,  5,  0,  6,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Punjabi/Gurmukhi/India
    {    233,     4,   178,    0,    0,    0,    0,   53,   21,   22,   23,   61,   35,   62,   65,   10,   11,   12,   13,  618,  127,   10,   22,15469,15469,15469,15469,   83,   83,    0,    0,    0,    5,   22,   75, 4007,    4,    0, 4770, 4575,  6,  6,  6,  6,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 18, 10, 12,  7, 36, 36, 36, 36, 13, 13,  2,  2,  4, 17, 23,  1,  6,  5,  0,  6,  7, {80,75,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Punjabi/Arabic/Pakistan
    {    234,    66,   184,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,  127,    0,    0,15505,15505,15557,15557,15584,15584,  165,  164,    0,    5,   22,  290, 4013,    4,    0, 4776, 4784,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 10,  5, 52, 52, 27, 27, 13, 13,  4,  4,  4, 17, 23,  2, 11,  5,  0,  8,  4, {80,69,78},      2,     1,     7,     6,     7,     1,     3,     3 }, // Quechua/Latin/Peru
    {    234,    66,    28,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,  127,    0,    0,15505,15505,15557,15557,15584,15584,  165,  164,    0,    5,   22,  292, 4024,    4,    0, 4776, 4788,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 10,  5, 52, 52, 27, 27, 13, 13,  4,  4,  4, 17, 23,  2,  9,  5,  0,  8,  7, {66,79,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Quechua/Latin/Bolivia
    {    234,    66,    70,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,  127,    0,    0,15505,15505,15557,15557,15584,15584,  165,  164,    0,    5,   22,    1, 4033,    4,    0, 4776, 4795,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 10,  5, 52, 52, 27, 27, 13, 13,  4,  4,  4, 17, 23,  1, 15,  5,  0,  8,  7, {85,83,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Quechua/Latin/Ecuador
    {    235,    66,   192,    0,    0,  854,  854,    6,    1,    0,    2,    3,    4,    5,    9,   15,   11,   17,   18,    0,  560,    0,    0,15597,15597,15644,15644, 5479, 5479,  165,  164,  952,    5,   22,  294, 4048,   19,   24, 4802, 4808,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 47, 47, 33, 33, 13, 13,  4,  4,  4, 17, 23,  3, 12,  5,  7,  6,  7, {82,79,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Romanian/Latin/Romania
    {    235,    66,   154,    0,    0,  854,  854,    6,    1,    0,    2,    3,    4,    5,    9,   15,   11,   17,   18,    0,  560,    0,    0,15597,15597,15677,15677,15704,15704,  165,  164,  952,    5,   22,    9, 4060,   19,   24, 4802, 4815,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 47, 47, 27, 27, 15, 15,  4,  4,  4, 17, 23,  1, 15,  5,  7,  6, 17, {77,68,76},      2,     1,     1,     6,     7,     1,     3,     3 }, // Romanian/Latin/Moldova
    {    236,    66,   226,    0,    0,  345,  345,    6,    0,   13,    2,    3,   40,    5,    9,   17,   18,   19,   20, 1289,  432,    0,    0,15719,15719,15774,15774,15796,15796,    0,    0,    0,    5,   22,  215, 4075,   19,    0, 4832, 4841,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  8, 10,  5, 55, 55, 22, 22, 13, 13,  2,  2,  5, 17, 23,  3, 13,  5,  0,  9,  6, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // Romansh/Latin/Switzerland
    {    237,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,15809,15809,15873,15873,12098,12098,  551,  573,    0,    5,   22,  118, 4088,    9,    0, 4847, 2025,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 64, 64, 28, 28, 13, 13,  8,  7,  4, 17, 23,  3, 18,  4,  0,  9,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Rombo/Latin/Tanzania
    {    238,    66,    38,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   11,   11,   13,   13,   71,   87,    0,    0,15901,15901,15989,15989,   83,   83,  559,  580,    0,    5,   22,  173, 4106,    0,    0, 4856, 4864,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 88, 88, 33, 33, 13, 13,  5,  5,  4, 17, 23,  3, 20,  4,  0,  8,  8, {66,73,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Rundi/Latin/Burundi
    {    239,    27,   193,    0,    0,  117,  117,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,  299,  560,    0,    0,16022,16022,16083,16083,16103,16083,    0,    0,  206,  852,   22,  124, 4126,   19,    0, 4872, 4879,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 10, 10,  5, 61, 61, 20, 20, 13, 20,  2,  2,  5, 17, 23,  1, 16,  5,  0,  7,  6, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Russian/Cyrillic/Russia
    {    239,    27,    22,    0,    0,  117,  117,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,  299,  560,    0,    0,16022,16022,16083,16083,16103,16083,    0,    0,  206,  852,   22,  125, 4142,   19,    0, 4872,  526,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 10, 10,  5, 61, 61, 20, 20, 13, 20,  2,  2,  5, 17, 23,  2, 17,  5,  0,  7,  8, {66,89,78},      2,     0,     1,     6,     7,     1,     3,     3 }, // Russian/Cyrillic/Belarus
    {    239,    27,   123,    0,    0,  117,  117,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,  299,  560,    0,    0,16022,16022,16083,16083,16103,16083,    0,    0,  206,  852,   22,  249, 4159,   19,    0, 4872, 4885,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 10, 10,  5, 61, 61, 20, 20, 13, 20,  2,  2,  5, 17, 23,  1, 15,  5,  0,  7,  9, {75,90,84},      2,     1,     1,     6,     7,     1,     3,     3 }, // Russian/Cyrillic/Kazakhstan
    {    239,    27,   128,    0,    0,  117,  117,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,  299,  560,    0,    0,16022,16022,16083,16083,16103,16083,    0,    0,  206,  852,   22,  257, 4174,   19,    0, 4872, 4894,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 10, 10,  5, 61, 61, 20, 20, 13, 20,  2,  2,  5, 17, 23,  3, 14,  5,  0,  7,  8, {75,71,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Russian/Cyrillic/Kyrgyzstan
    {    239,    27,   154,    0,    0,  117,  117,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,  299,  560,    0,    0,16022,16022,16083,16083,16103,16083,    0,    0,  206,  852,   22,    9, 4188,   19,    0, 4872, 4902,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 10, 10,  5, 61, 61, 20, 20, 13, 20,  2,  2,  5, 17, 23,  1, 14,  5,  0,  7,  7, {77,68,76},      2,     1,     1,     6,     7,     1,     3,     3 }, // Russian/Cyrillic/Moldova
    {    239,    27,   244,    0,    0,  117,  117,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10,  299,  560,    0,    0,16022,16022,16083,16083,16103,16083,    0,    0,  206,  852,   22,  297, 4202,   19,    0, 4872, 4909,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 10, 10,  5, 61, 61, 20, 20, 13, 20,  2,  2,  5, 17, 23,  1, 17,  5,  0,  7,  7, {85,65,72},      2,     1,     1,     6,     7,     2,     3,     3 }, // Russian/Cyrillic/Ukraine
    {    240,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,11753,11753,11814,11814, 1041, 1041,  398,  414,    0,    5,   22,  118, 3392,    0,    0, 4916, 2025,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 61, 61, 27, 27, 13, 13,  5,  9,  4, 17, 23,  3, 20,  4,  0,  6,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Rwa/Latin/Tanzania
    {    241,    66,    74,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {69,82,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Saho/Latin/Eritrea
    {    242,    27,   193,    0,    0,  862,  862,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   10, 1312,  293,    0,    0,16116,16116,16186,16186,16206,16206,  564,  585,  956,  961,   22,  124, 4219,   19,    0, 4922, 4931,  6,  6, 11, 11,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 30,  6, 10,  5, 70, 70, 20, 20, 13, 13,  2,  2,  5, 17, 23,  1, 20,  5,  0,  9,  9, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Sakha/Cyrillic/Russia
    {    243,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,16219,16219,16323,16323,16350,16350,  566,  587,    0,    5,   22,  170, 4239,    9,   13, 4940, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,104,104, 27, 27, 13, 13,  7,  5,  4, 17, 23,  3, 18,  4,  6,  8,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Samburu/Latin/Kenya
    {    245,    66,    46,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,   71,   87,    0,    0,16363,16363,16428,16428,16455,16455,  573,  592,    0,    5,   22,    2, 4257,    9,   44, 4948, 4953,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 65, 65, 27, 27, 13, 13,  2,  2,  4, 17, 23,  4, 18,  4,  5,  5, 22, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Sango/Latin/Central African Republic
    {    246,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,16468,16468,16527,16527,16554,16554,  575,  594,    0,    5,   22,  118, 4275,    0,    0, 4975, 4984,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 59, 59, 27, 27, 13, 13,  9,  9,  4, 17, 23,  3, 18,  4,  0,  9,  9, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Sangu/Latin/Tanzania
    {    247,    29,   110,    0,    0,  873,  883,    6,    0,    1,    2,   69,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22,16567,16567, 7106, 7106, 7137, 7137,  448,  468,    0,    5,   22,  117, 4293,    4,    0, 4993, 5005,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 66, 66, 31, 31, 18, 18,  9,  7,  4, 17, 23,  1, 15,  5,  0, 12,  5, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Sanskrit/Devanagari/India
    {    248,    93,   110,    0,    0,    0,    0,    6,    0,    1,    2,   76,    4,    5,    9,   10,   11,   12,   13,    0,   87,   10,   22,16633,16633,16674,16674,16699,16699,  584,  603,    0,    5,   22,  117, 4308,    4,    0, 5010, 5017,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 41, 41, 25, 25, 13, 13,  5,  5,  4, 17, 23,  1, 16,  5,  0,  7,  6, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Santali/Ol Chiki/India
    {    248,    29,   110,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  117,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Santali/Devanagari/India
    {    249,    66,   117,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   13,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Sardinian/Latin/Italy
    {    251,    66,   160,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,16712,16712,16766,16766,16793,16793,    0,    0,    0,    5,   22,  267, 4324,    0,    0, 5023, 4690,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 54, 54, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 21,  4,  0,  4, 10, {77,90,78},      2,     1,     7,     6,     7,     1,     3,     3 }, // Sena/Latin/Mozambique
    {    252,    27,   207,    0,    0,  117,  117,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   12,   12,  375,  395,    0,    0,16806,16806,16857,16857, 2341, 2341,  589,  608,  978,    5,   22,  298, 4345,   19,   24, 5027, 5033,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 51, 51, 27, 27, 13, 13,  9,  8,  7, 17, 23,  3, 12,  5,  7,  6,  6, {82,83,68},      0,     0,     1,     6,     7,     1,     3,     3 }, // Serbian/Cyrillic/Serbia
    {    252,    66,    29,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   12,   12,  375,  395,    0,    0, 2149, 2149, 2206,16884, 2233, 2233,  598,  616,  228,    5,   22,  128,  575,   19,   24, 5039,  581,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 57, 57, 27, 27, 13, 13, 11,  8,  7, 17, 23,  2, 40,  5,  7,  6, 19, {66,65,77},      2,     1,     1,     6,     7,     1,     3,     3 }, // Serbian/Latin/Bosnia And Herzegovina
    {    252,    66,   207,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   12,   12,  375,  395,    0,    0,16911,16911,16884,16884, 2233, 2233,  609,  616,  228,    5,   22,  298, 4357,   19,   24, 5039, 5045,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 53, 53, 27, 27, 13, 13,  9,  8,  7, 17, 23,  3, 12,  5,  7,  6,  6, {82,83,68},      0,     0,     1,     6,     7,     1,     3,     3 }, // Serbian/Latin/Serbia
    {    252,    27,    29,    0,    0,  117,  117,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   12,   12,  375,  395,    0,    0, 2259, 2259, 2314,16857, 2341, 2341,  101,  608,  978,    5,   22,  130, 4369,   19,   24, 5027,  608,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 55, 55, 27, 27, 13, 13, 11,  8,  7, 17, 23,  2, 40,  5,  7,  6, 19, {66,65,77},      2,     1,     1,     6,     7,     1,     3,     3 }, // Serbian/Cyrillic/Bosnia And Herzegovina
    {    252,    27,   126,    0,    0,  117,  117,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   12,   12,  375,  395,    0,    0,16806,16806,16857,16857, 2341, 2341,  589,  608,  978,    5,   22,   13, 4409,   19,   24, 5027, 5051,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 51, 51, 27, 27, 13, 13,  9,  8,  7, 17, 23,  1,  4,  5,  7,  6,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Serbian/Cyrillic/Kosovo
    {    252,    27,   157,    0,    0,  117,  117,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   12,   12,  375,  395,    0,    0,16964,16964,16857,16857, 2341, 2341,  101,  608,  978,    5,   22,   13, 4409,   19,   24, 5027, 5057,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 54, 54, 27, 27, 13, 13, 11,  8,  7, 17, 23,  1,  4,  5,  7,  6,  9, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Serbian/Cyrillic/Montenegro
    {    252,    66,   126,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   12,   12,  375,  395,    0,    0,16911,16911,16884,16884, 2233, 2233,  609,  616,  228,    5,   22,   13, 4413,   19,   24, 5039, 5066,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 53, 53, 27, 27, 13, 13,  9,  8,  7, 17, 23,  1,  4,  5,  7,  6,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Serbian/Latin/Kosovo
    {    252,    66,   157,    0,    0,  110,  110,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   12,   12,  375,  395,    0,    0,17018,17018,16884,16884, 2233, 2233,  598,  616,  228,    5,   22,   13, 4413,   19,   24, 5039, 5072,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  7, 10,  5, 56, 56, 27, 27, 13, 13, 11,  8,  7, 17, 23,  1,  4,  5,  7,  6,  9, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Serbian/Latin/Montenegro
    {    253,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,17074,17074,17136,17136,17163,17163,  618,  624,    0,    5,   22,  118, 4417,    0,    0, 5081, 2025,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 62, 62, 27, 27, 13, 13,  5,  8,  4, 17, 23,  3, 20,  4,  0,  9,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Shambala/Latin/Tanzania
    {    254,    66,   261,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   11,   11,   13,   13,   27,   44,    0,    0,17176,17176,17230,17230,17257,17257,    0,    0,    0,    5,   22,  140, 4437,    9,   13, 5090, 2191,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 54, 54, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 15,  4,  6,  8,  8, {85,83,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Shona/Latin/Zimbabwe
    {    255,   141,    50,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,   10,   22,17270,17270,17297,17297,17317,17317,  623,  632,    0,    5,   22,  146,    0,    4,    0, 5098, 5101,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 27, 27, 20, 20, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  3,  2, {67,78,89},      2,     1,     7,     6,     7,     1,     3,     3 }, // Sichuan Yi/Yi/China
    {    256,    66,   117,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   13,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Sicilian/Latin/Italy
    {    257,    66,    77,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {69,84,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Sidamo/Latin/Ethiopia
    {    258,    66,   187,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  286,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2,  0,  5,  0,  0,  0, {80,76,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Silesian/Latin/Poland
    {    259,     4,   178,    0,    0,  892,  900,   53,   21,   22,   23,   25,   26,   28,   30,   10,   11,   12,   13,   27,   44,   10,   22,17330,17330,17330,17330,17364,17364,  625,  634,  985,  991,   22,  184, 4452,   19,    0, 5103, 5107,  6,  6,  8,  7,  1,  1,  1,  2,  1,  2,  2,  2,  1,  1,  1,  1, 17, 10, 12,  7, 34, 34, 34, 34, 30, 30, 11, 11,  6, 25, 23,  2, 12,  5,  0,  4,  7, {80,75,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Sindhi/Arabic/Pakistan
    {    259,    29,   110,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,  434,  346,17394,17420,17460,17484,17511,17530,  636,  645,    0,    5,   22,  117, 4464,    4,    0, 5114,  569,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6, 12,  7, 26, 40, 24, 27, 19, 18, 16, 13,  4, 17, 23,  1, 17,  5,  0,  6,  4, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Sindhi/Devanagari/India
    {    260,   119,   221,    0,    0,  907,  916,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,  140,  140,17548,17548,17609,17609,17647,17647,  652,  658, 1016, 1021,   22,  301, 4481,    9,   13, 5120, 5125,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 61, 61, 38, 38, 18, 18,  5,  4,  5, 42, 23,  3, 17,  4,  6,  5, 11, {76,75,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Sinhala/Sinhala/Sri Lanka
    {    261,    66,    83,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   13,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Skolt Sami/Latin/Finland
    {    262,    66,   212,    0,    0,  222,  924,    6,    1,   14,    2,    3,    4,    5,    6,   15,   10,   16,   12,  520,  364,    1,    1,17665,17665,17716,17716,17736,17736,    0,    0,  321,    5,   22,   13,  420,   19,   24, 5136, 5146,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10,  9,  4, 51, 51, 20, 20, 13, 13,  2,  2,  5, 17, 23,  1,  4,  5,  7, 10,  9, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Slovak/Latin/Slovakia
    {    263,    66,   213,    0,    0,  931,  931,    6,    1,    0,    2,    3,   40,    5,    6,   15,   10,   16,   12,  375,  499,    0,    0,17749,17749,17800,17800,17834,17834,  169,  662,   50,    5,   22,   13, 4498,   19,   24, 5155, 5166,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  9, 10,  5, 51, 51, 34, 34, 13, 13,  4,  4,  4, 17, 23,  1,  4,  5,  7, 11,  9, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Slovenian/Latin/Slovenia
    {    264,    66,   243,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,17847,17847,17911,17911,17945,17945,  657,  666,    0,    5,   22,  143, 2771,   19,    0, 5175, 3061,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 64, 64, 34, 34, 13, 13,  6,  6,  4, 17, 23,  3, 19,  5,  0,  7,  7, {85,71,88},      0,     0,     1,     7,     7,     1,     3,     3 }, // Soga/Latin/Uganda
    {    265,    66,   215,    0,    0,  939,  939,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1342,  127,   10,   22,17958,17958,18004,18004,18035,18035,  663,  672, 1063, 1069,   22,   90, 4502,    9,   13, 5182, 5190,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  8, 12,  7, 46, 46, 31, 31, 14, 14,  2,  2,  6, 17, 23,  1, 20,  4,  6,  8, 10, {83,79,83},      0,     0,     1,     6,     7,     1,     3,     3 }, // Somali/Latin/Somalia
    {    265,    66,    67,    0,    0,  939,  939,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1342,  127,   10,   22,17958,17958,18004,18004,18035,18035,  663,  672, 1063, 1069,   22,   34, 4522,    9,   13, 5182, 5200,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  8, 12,  7, 46, 46, 31, 31, 14, 14,  2,  2,  6, 17, 23,  3, 13,  4,  6,  8,  7, {68,74,70},      0,     0,     6,     6,     7,     1,     3,     3 }, // Somali/Latin/Djibouti
    {    265,    66,    77,    0,    0,  939,  939,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1342,  127,   10,   22,17958,17958,18004,18004,18035,18035,  663,  672, 1063, 1069,   22,  125, 4535,    9,   13, 5182, 5207,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  8, 12,  7, 46, 46, 31, 31, 14, 14,  2,  2,  6, 17, 23,  2, 15,  4,  6,  8,  8, {69,84,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Somali/Latin/Ethiopia
    {    265,    66,   124,    0,    0,  939,  939,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1342,  127,    0,    0,17958,17958,18004,18004,18035,18035,  663,  672, 1063, 1069,   22,  170, 4550,    9,   13, 5182, 1103,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  8, 10,  5, 46, 46, 31, 31, 14, 14,  2,  2,  6, 17, 23,  3, 15,  4,  6,  8,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Somali/Latin/Kenya
    {    266,     4,   112,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {73,82,82},      0,     0,     6,     5,     5,     1,     3,     3 }, // Southern Kurdish/Arabic/Iran
    {    267,    66,   225,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  156,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2,  0,  5,  0,  0,  0, {83,69,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Southern Sami/Latin/Sweden
    {    268,    66,   216,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Southern Sotho/Latin/South Africa
    {    269,    66,   216,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // South Ndebele/Latin/South Africa
    {    270,    66,   220,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,   87,   55,    1,18049,18049,18101,18101,15584,15584,  129,  124,    0,    5,   22,   13,  420,   19,    0, 5215,  386,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 11,  4, 52, 52, 27, 27, 13, 13,  5,  5,  5, 17, 23,  1,  4,  5,  0, 17,  6, {69,85,82},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Spain
    {    270,    66,    11,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 5479,  129,  124,    0,    5,   22,    1, 4565,    4,   37, 5215, 5232,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 14,  5,  7,  7,  9, {65,82,83},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Argentina
    {    270,    66,    24,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    1, 4579,    9,    0, 5215, 5241,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 14,  4,  0,  7,  6, {66,90,68},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Belize
    {    270,    66,    28,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,  292, 4593,    9,    0, 5215, 4788,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  2,  9,  4,  0,  7,  7, {66,79,66},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Bolivia
    {    270,    66,    32,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    0, 4602,    9,    0, 5215, 4611,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  2, 14,  4,  0,  7,  6, {66,82,76},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Brazil
    {    270,    66,    42,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,   87,   55,    1,18049,18049,18101,18101,15584,15584,  129,  124,    0,    5,   22,   13,  420,   19,    0, 5215, 5247,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 11,  4, 52, 52, 27, 27, 13, 13,  5,  5,  5, 17, 23,  1,  4,  5,  0,  7,  8, {69,85,82},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Canary Islands
    {    270,    66,    47,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,   87,   55,    1,18049,18049,18101,18101,15584,15584,  129,  124,    0,    5,   22,   13,  420,   19,    0, 5215, 5255,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 11,  4, 52, 52, 27, 27, 13, 13,  5,  5,  5, 17, 23,  1,  4,  5,  0,  7, 15, {69,85,82},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Ceuta And Melilla
    {    270,    66,    49,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,  432,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    1, 4616,    9,    0, 5215, 5270,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 12,  4,  0,  7,  5, {67,76,80},      0,     0,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Chile
    {    270,    66,    54,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,  128,   10,   22,18049,18049,18128,18101, 7794, 5479,  129,  124,    0,    5,   22,    1, 4628,    9,    0, 5215, 5275,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  7, 12,  7, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 15,  4,  0,  7,  8, {67,79,80},      2,     0,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Colombia
    {    270,    66,    59,    0,    0,   70,   70,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,  304, 4643,    9,    0, 5215, 5283,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 19,  4,  0,  7, 10, {67,82,67},      2,     0,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Costa Rica
    {    270,    66,    61,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    1, 4662,    9,    0, 5215, 5293,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 11,  4,  0,  7,  4, {67,85,80},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Cuba
    {    270,    66,    69,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,   10,   22,18049,18049,18128,18101, 5479, 5479,  129,  124,    0,    5,   22,  305, 4673,    9,   13, 5215, 5297,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 12,  7, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  3, 15,  4,  6,  7, 20, {68,79,80},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Dominican Republic
    {    270,    66,    70,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    1, 4688,    9,    0, 5215, 4795,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 20,  4,  0,  7,  7, {85,83,68},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Ecuador
    {    270,    66,    72,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    1, 4688,    9,    0, 5215, 5317,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 20,  4,  0,  7, 11, {85,83,68},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/El Salvador
    {    270,    66,    73,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,   87,   55,    1,18049,18049,18101,18101,15584,15584,  129,  124,    0,    5,   22,    2, 4708,   19,    0, 5215, 5328,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 11,  4, 52, 52, 27, 27, 13, 13,  5,  5,  5, 17, 23,  4, 28,  5,  0,  7, 17, {88,65,70},      0,     0,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Equatorial Guinea
    {    270,    66,    99,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,  128,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,  251, 4736,    9,    0, 5215, 5345,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  7, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1,  7,  4,  0,  7,  9, {71,84,81},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Guatemala
    {    270,    66,   106,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1361,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    9, 4743,    9,    0, 5215, 5354,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 17,  4,  0,  7,  8, {72,78,76},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Honduras
    {    270,    66,   130,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    0,    0,    9,    0, 5362, 5385,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  0,  0,  4,  0, 23, 13,    {0,0,0},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Latin America
    {    270,    66,   152,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,  127,    0,    0,18049,18049,18128,18101, 5479, 5479,  129,  124,    0,    5,   22,    1, 4760,    9,    0, 5398, 5415,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 13,  4,  0, 17,  6, {77,88,78},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Mexico
    {    270,    66,   168,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,  308, 4773,    9,    0, 5215, 5421,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  2, 20,  4,  0,  7,  9, {78,73,79},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Nicaragua
    {    270,    66,   181,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751, 1388,   10,   22,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,  310, 4793,    9,    0, 5215, 5430,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 12,  7, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  3, 15,  4,  0,  7,  6, {80,65,66},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Panama
    {    270,    66,   183,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,  313, 4808,    9,    0, 5215, 5436,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  3, 17,  4,  0,  7,  8, {80,89,71},      0,     0,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Paraguay
    {    270,    66,   184,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,  128,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,  290, 4825,    9,    0, 5215, 4784,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  7, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  2, 11,  4,  0,  7,  4, {80,69,78},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Peru
    {    270,    66,   185,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,   87,   10,   22,18049,18049,18101,18101,15584,15584,  129,  124,    0,    5,   22,  139, 4836,   19,    0, 5215, 5444,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 12,  7, 52, 52, 27, 27, 13, 13,  5,  5,  5, 17, 23,  1, 13,  5,  0,  7,  9, {80,72,80},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Philippines
    {    270,    66,   189,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751, 1388,   10,   22,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    1, 4688,    9,    0, 5215, 1837,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 12,  7, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 20,  4,  0,  7, 11, {85,83,68},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Puerto Rico
    {    270,    66,   248,    0,    0,   70,   70,    6,    0,    1,    2,    3,    4,    5,    9,   17,   18,   10,   11,  751,   87,   10,   22,18049,18049,18128,18101, 5479, 5479,  129,  124,    0,    5,   22,    1, 4688,    9,    0, 5215, 5453,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  8, 12,  7, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 20,  4,  0,  7, 14, {85,83,68},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/United States
    {    270,    66,   250,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,    0,    0,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,    1, 4849,    4,   37, 5215, 5467,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 10,  5, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  1, 13,  5,  7,  7,  7, {85,89,85},      2,     1,     1,     6,     7,     2,     3,     3 }, // Spanish/Latin/Uruguay
    {    270,    66,   254,    0,    0,   70,   70,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  751,   87,   10,   22,18049,18049,18128,18101, 5479, 7794,  129,  124,    0,    5,   22,  316, 4862,    9,    0, 5215, 5474,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  6, 12,  7, 52, 52, 34, 27, 13, 13,  5,  5,  5, 17, 23,  4, 16,  4,  0,  7,  9, {86,69,83},      2,     1,     7,     6,     7,     2,     3,     3 }, // Spanish/Latin/Venezuela
    {    271,   135,   159,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   11,   71,   87,    0,    0,18162,18162,18209,18209,   83,   83,  665,  674,    0,    5,   22,    0, 4878,    0,    0, 5483, 5491,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 47, 47, 29, 29, 13, 13,  6,  8,  4, 17, 23,  0, 14,  4,  0,  8,  6, {77,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Standard Moroccan Tamazight/Tifinagh/Morocco
    {    272,    66,   111,    0,    0,  948,  961,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,   87,  141,  141,18238,18238,18281,18281, 7698, 7698,    0,    0,    0,    5,   22,  243, 4892,    9,    0, 5497,    0,  6,  6, 13, 12,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  6,  9,  4, 43, 43, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2, 15,  4,  0, 10,  0, {73,68,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Sundanese/Latin/Indonesia
    {    273,    66,   230,    0,    0,  468,  468,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,  955,  955,  955,  955,   83,   83,    0,    0,  760, 1086,   22,  118, 3392,    4,    0, 5507, 2025,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 59, 59, 59, 59, 13, 13,  2,  2,  5, 51, 23,  3, 20,  5,  0,  9,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Swahili/Latin/Tanzania
    {    273,    66,    57,    0,    0,  468,  468,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,  955,  955,  955,  955,   83,   83,    0,    0,  760, 1086,   22,    2, 4907,    4,    0, 5507, 5516,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 59, 59, 59, 59, 13, 13,  2,  2,  5, 51, 23,  2, 16,  5,  0,  9, 32, {67,68,70},      2,     1,     1,     6,     7,     1,     3,     3 }, // Swahili/Latin/Congo Kinshasa
    {    273,    66,   124,    0,    0,  468,  468,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,  955,  955,  955,  955,   83,   83,    0,    0,  760, 1086,   22,  170,  952,    4,    0, 5507, 1103,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 59, 59, 59, 59, 13, 13,  2,  2,  5, 51, 23,  3, 17,  5,  0,  9,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Swahili/Latin/Kenya
    {    273,    66,   243,    0,    0,  468,  468,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,  955,  955,  955,  955,   83,   83,    0,    0,  760, 1086,   22,  143, 4923,    4,    0, 5507,  857,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 59, 59, 59, 59, 13, 13,  2,  2,  5, 51, 23,  3, 18,  5,  0,  9,  6, {85,71,88},      0,     0,     1,     7,     7,     1,     3,     3 }, // Swahili/Latin/Uganda
    {    274,    66,   216,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Swati/Latin/South Africa
    {    275,    66,   225,    0,    0,  973,  973,    6,    1,   14,    2,    3,   40,    5,   52,   11,   11,   13,   13,   71,   44,    0,    0,18308,18308,18357,18357, 3959, 3959,  671,  682,    0,    5,   22,  156, 4941,   19,    0, 5548, 5555,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 16, 10, 10,  5, 49, 49, 28, 28, 13, 13,  2,  2,  4, 17, 23,  2, 12,  5,  0,  7,  7, {83,69,75},      2,     0,     1,     6,     7,     1,     3,     3 }, // Swedish/Latin/Sweden
    {    275,    66,     2,    0,    0,  973,  973,    6,    1,   14,    2,    3,   40,    5,   52,   11,   11,   13,   13,   71,   44,    0,    0,18308,18308,18357,18357, 3959, 3959,  671,  682,    0,    5,   22,   13,  420,   19,    0, 5548, 5562,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 16, 10, 10,  5, 49, 49, 28, 28, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0,  7,  5, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Swedish/Latin/Aland Islands
    {    275,    66,    83,    0,    0,  973,  973,    6,    1,   14,    2,    3,   40,    5,   52,   11,   11,   13,   13,   71,   44,    0,    0,18308,18308,18357,18357, 3959, 3959,  671,  682,    0,    5,   22,   13,  420,   19,    0, 5548, 1472,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  4,  1,  1,  1,  1, 16, 10, 10,  5, 49, 49, 28, 28, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  0,  7,  7, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Swedish/Latin/Finland
    {    276,    66,   226,    0,    0,  384,  384,    6,    0,   13,    2,    3,   40,    5,    9,   17,   18,   19,   20,  345,  184,    0,    0,18385,18385,18447,18447, 3667, 3667,  673,  684,    0,    5,   22,  215, 4953,   19,    0, 5567, 5567,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 62, 62, 27, 27, 13, 13, 12, 11,  4, 17, 23,  3, 16,  5,  0, 16,  7, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // Swiss German/Latin/Switzerland
    {    276,    66,    84,    0,    0,  384,  384,    6,    0,   13,    2,    3,   40,    5,    9,   17,   18,   19,   20,  345,  184,    0,    0,18385,18385,18447,18447, 3667, 3667,  673,  684,    0,    5,   22,   13,   73,   19,    0, 5567, 5583,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 62, 62, 27, 27, 13, 13, 12, 11,  4, 17, 23,  1,  4,  5,  0, 16, 10, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Swiss German/Latin/France
    {    276,    66,   136,    0,    0,  384,  384,    6,    0,   13,    2,    3,   40,    5,    9,   17,   18,   19,   20,  345,  184,    0,    0,18385,18385,18447,18447, 3667, 3667,  673,  684,    0,    5,   22,  215, 4953,   19,    0, 5567, 5593,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 62, 62, 27, 27, 13, 13, 12, 11,  4, 17, 23,  3, 16,  5,  0, 16, 13, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // Swiss German/Latin/Liechtenstein
    {    277,   123,   113,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {73,81,68},      0,     0,     6,     5,     6,     1,     3,     3 }, // Syriac/Syriac/Iraq
    {    278,   135,   159,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   11,   71,   87,    0,    0,18474,18474,18209,18209,   83,   83,  665,  674,    0,    5,   22,    0, 4878,    0,    0, 5606, 5491,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 46, 46, 29, 29, 13, 13,  6,  8,  4, 17, 23,  0, 14,  4,  0,  7,  6, {77,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tachelhit/Tifinagh/Morocco
    {    278,    66,   159,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   15,   11,   71,   87,    0,    0,18520,18520,18567,18567,   83,   83,  685,  695,    0,    5,   22,    0, 4969,    0,    0, 5613, 5623,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 47, 47, 29, 29, 13, 13,  6,  8,  4, 17, 23,  0, 14,  4,  0, 10,  6, {77,65,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tachelhit/Latin/Morocco
    {    280,   127,   255,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  320,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {86,78,68},      0,     0,     1,     6,     7,     1,     3,     3 }, // Tai Dam/Tai Viet/Vietnam
    {    281,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,18596,18596,18700,18700,18727,18727,  691,  703,    0,    5,   22,  170,  952,    9,   13, 5629, 1103,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5,104,104, 27, 27, 13, 13, 10, 10,  4, 17, 23,  3, 17,  4,  6,  7,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Taita/Latin/Kenya
    {    282,    27,   229,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,  618,  127,    0,    0,18740,18740,18794,18794,18821,18821,    0,    0,    0,    5,   22,  321, 4983,   19,    0, 5636, 5642,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 10,  5, 54, 54, 27, 27, 13, 13,  2,  2,  4, 17, 23,  4,  6,  5,  0,  6, 10, {84,74,83},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tajik/Cyrillic/Tajikistan
    {    283,   129,   110,    0,    0,  982,  982,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,   87,  434,  346,18834,18834,18882,18882,18920,18920,  701,  713, 1137,    5,   22,  117, 4989,    9,   13, 5652, 5657,  6,  6, 13, 13,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 48, 48, 38, 38, 19, 19,  8,  8,  7, 17, 23,  1, 13,  4,  6,  5,  7, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Tamil/Tamil/India
    {    283,   129,   143,    0,    0,  982,  982,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,   87,  434,  346,18834,18834,18882,18882,18920,18920,  701,  713, 1137,    5,   22,  182, 5002,    9,   13, 5652, 5664,  6,  6, 13, 13,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 48, 48, 38, 38, 19, 19,  8,  8,  7, 17, 23,  2, 17,  4,  6,  5,  7, {77,89,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tamil/Tamil/Malaysia
    {    283,   129,   210,    0,    0,  982,  982,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,   87,  434,  346,18834,18834,18882,18882,18920,18920,  701,  713, 1137,    5,   22,    1, 5019,    9,   13, 5652, 5671,  6,  6, 13, 13,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 12,  7, 48, 48, 38, 38, 19, 19,  8,  8,  7, 17, 23,  1, 17,  4,  6,  5, 11, {83,71,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Tamil/Tamil/Singapore
    {    283,   129,   221,    0,    0,  982,  982,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,   87,    0,    0,18834,18834,18882,18882,18920,18920,  701,  713, 1137,    5,   22,  325, 5036,    9,   13, 5652, 5682,  6,  6, 13, 13,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 10,  5, 48, 48, 38, 38, 19, 19,  8,  8,  7, 17, 23,  3, 13,  4,  6,  5,  6, {76,75,82},      2,     1,     1,     6,     7,     1,     2,     3 }, // Tamil/Tamil/Sri Lanka
    {    284,    66,   228,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  328,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3,  0,  5,  0,  0,  0, {84,87,68},      2,     0,     7,     6,     7,     1,     3,     3 }, // Taroko/Latin/Taiwan
    {    285,    66,   170,    0,    0,    0,    0,    6,    0,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0, 9722, 9722, 9775, 9775, 9802, 9802,  709,  721,    0,    5,   22,    3, 3197,    0,    0, 5688, 5701,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 53, 53, 27, 27, 13, 13,  8, 10,  4, 17, 23,  3, 16,  4,  0, 13,  5, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Tasawaq/Latin/Niger
    {    286,    27,   193,    0,    0,  995,  995,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1396,  560,    1,    1,18939,18939,18994,18994,19029,19029,    0,    0,    0,    5,   22,  124, 5049,   19,    0, 5706, 4879,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 10,  9,  4, 55, 55, 35, 35, 13, 13,  2,  2,  4, 17, 23,  1, 11,  5,  0,  5,  6, {82,85,66},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tatar/Cyrillic/Russia
    {    287,   131,   110,    0,    0, 1004, 1004,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1419,  432,   10,   22,19042,19042,19101,19101,19132,19132,    0,    0, 1144, 1151,   22,  117, 5060,    9,   13, 5711, 5717,  6,  6, 11, 11,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 12,  7, 59, 59, 31, 31, 17, 17,  2,  2,  7, 29, 23,  1,  6,  4,  6,  6,  8, {73,78,82},      2,     1,     7,     7,     7,     1,     2,     3 }, // Telugu/Telugu/India
    {    288,    66,   243,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,19149,19149,19217,19217,19244,19244,  717,  731,    0,    5,   22,  143, 5066,    9,   13, 5725,  857,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 68, 68, 27, 27, 13, 13,  9,  6,  4, 17, 23,  3, 21,  4,  6,  6,  6, {85,71,88},      0,     0,     1,     7,     7,     1,     3,     3 }, // Teso/Latin/Uganda
    {    288,    66,   124,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,19149,19149,19217,19217,19244,19244,  717,  731,    0,    5,   22,  170, 5087,    9,   13, 5725, 5731,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 68, 68, 27, 27, 13, 13,  9,  6,  4, 17, 23,  3, 20,  4,  6,  6,  5, {75,69,83},      2,     1,     7,     6,     7,     1,     3,     3 }, // Teso/Latin/Kenya
    {    289,   133,   231, 1015, 1015, 1020, 1028,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1437,   87,  446,    0,19257,19257,19324,19324,19346,19346,  726,  737, 1180,    5,   22,  331, 5107,    9,   13, 5736, 5736,  5,  5,  8,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  6, 28,  5, 67, 67, 22, 22, 15, 15, 10, 10,  4, 17, 23,  1,  3,  4,  6,  3,  3, {84,72,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Thai/Thai/Thailand
    {    290,   134,    50,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1456,   44,   10,   22,19361,19361,19439,19439,19489,19489,  736,  747,    0,    5,   22,  146, 5110,    4,    0, 5739, 5747,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 10, 12,  7, 78, 78, 50, 50, 26, 26,  7,  8,  4, 17, 23,  1,  6,  5,  0,  8,  6, {67,78,89},      2,     1,     7,     6,     7,     1,     3,     3 }, // Tibetan/Tibetan/China
    {    290,   134,   110,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1456,   44,   10,   22,19361,19361,19439,19439,19489,19489,  736,  747,    0,    5,   22,  117, 5116,    4,    0, 5739, 5753,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 10, 12,  7, 78, 78, 50, 50, 26, 26,  7,  8,  4, 17, 23,  1, 12,  5,  0,  8,  7, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Tibetan/Tibetan/India
    {    291,    33,    74,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {69,82,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tigre/Ethiopic/Eritrea
    {    292,    33,    77,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1479,  127,   10,   22,19515,19515,19543,19543,19563,19576,  743,  755,    0,    5,   22,  125,   95,    9,    0, 5760,   89,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  8, 12,  7, 28, 28, 20, 20, 13, 13, 12, 12,  4, 17, 23,  2,  9,  4,  0,  3,  5, {69,84,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Tigrinya/Ethiopic/Ethiopia
    {    292,    33,    74,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   12,   13,   10,   11, 1479,  127,   10,   22,19515,19515,19543,19543,19576,19576,  743,  755,    0,    5,   22,   37,    0,    9,    0, 5760, 5763,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  8, 12,  7, 28, 28, 20, 20, 13, 13, 12, 12,  4, 17, 23,  3,  0,  4,  0,  3,  4, {69,82,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tigrinya/Ethiopic/Eritrea
    {    295,    66,   235, 1035, 1035, 1035, 1035,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,   10,   22,19589,19589,19648,19648,19676,19676,  755,  767, 1184, 1189, 1248,  193, 5128,    4,    0, 5767, 2040,  8,  8,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  6, 12,  7, 59, 59, 28, 28, 13, 13, 10,  6,  5, 59, 65,  2, 17,  5,  0, 13,  5, {84,79,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tongan/Latin/Tonga
    {    296,    66,   216,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Tsonga/Latin/South Africa
    {    297,    66,   216,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Tswana/Latin/South Africa
    {    298,    66,   239,    0,    0, 1043, 1043,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1502,  561,    0,    0,19689,19689,19742,19742,19769,19769,  765,  773,  195,    5,   22,  256, 5145,    9,   13, 5780, 5786,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  9, 10,  5, 53, 53, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1, 11,  4,  6,  6,  7, {84,82,89},      2,     1,     1,     6,     7,     1,     3,     3 }, // Turkish/Latin/Turkey
    {    298,    66,    63,    0,    0, 1043, 1043,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1502,  561,   10,   22,19689,19689,19742,19742,19769,19769,  765,  773,  195,    5,   22,   13,   73,    9,   13, 5780, 5793,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  9, 12,  7, 53, 53, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  4,  4,  6,  6,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Turkish/Latin/Cyprus
    {    299,    66,   240,    0,    0, 1051, 1051,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   10,   11, 1502,  560,    0,    0,19782,19835,19888,19915,19942,19942,  767,  775, 1313,    5,   22,  332, 5156,   19,    0, 5799, 5811,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 10, 10,  5, 53, 53, 27, 27, 13, 13, 13, 14,  4, 17, 23,  3, 14,  5,  0, 12, 12, {84,77,84},      2,     1,     1,     6,     7,     1,     3,     3 }, // Turkmen/Latin/Turkmenistan
    {    301,    66,   169,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  121,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Tyap/Latin/Nigeria
    {    303,    27,   244,    0,    0,  103,  103,    6,    1,   14,    2,    3,    4,    5,   77,   17,   18,   15,   10, 1518,  184,    0,    0,19955,19955, 2499, 2499,20010,20010,  780,  789, 1317,  852,   22,  297, 5170,   19,    0, 5823, 5833,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  8, 10,  5, 55, 55, 20, 20, 13, 13,  2,  2,  5, 17, 23,  1, 17,  5,  0, 10,  7, {85,65,72},      2,     1,     1,     6,     7,     1,     3,     3 }, // Ukrainian/Cyrillic/Ukraine
    {    304,    66,    91,    0,    0,  222,  222,    6,    1,    0,    2,    3,    4,    5,    9,   15,   10,   16,   12,  345,  121,    1,  474,20023,20023,20075,20075,20102,20102,  367,  791, 1322,    5,   22,   13,  420,   19,    0, 5840, 5855,  6,  6,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6,  9, 12, 52, 52, 27, 27, 13, 13,  9,  9,  5, 17, 23,  1,  4,  5,  0, 15,  6, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Upper Sorbian/Latin/Germany
    {    305,     4,   178,  800,  800, 1059, 1069,    6,    0,    1,    2,    3,   35,   37,    9,   11,   10,   13,   12, 1540,   87,   10,   22,20115,20115,20115,20115,   83,   83,    0,    0, 1327, 1331,   22,  184, 5187,    9,   13, 5861, 4575,  6,  6, 10,  9,  1,  1,  1,  1,  1,  2,  2,  1,  1,  1,  1,  1, 18,  6, 12,  7, 35, 35, 35, 35, 13, 13,  2,  2,  4, 20, 23,  2, 14,  4,  6,  4,  7, {80,75,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Urdu/Arabic/Pakistan
    {    305,     4,   110,  800,  800, 1059, 1069,    6,   21,   22,    2,   61,   35,   62,   65,   11,   10,   13,   12, 1540,   87,   10,   22,20115,20115,20115,20115,   83,   83,    0,    0, 1327, 1331,   22,  117, 5201,    9,   13, 5861, 5865,  6,  6, 10,  9,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 18,  6, 12,  7, 35, 35, 35, 35, 13, 13,  2,  2,  4, 20, 23,  1, 12,  4,  6,  4,  5, {73,78,82},      2,     1,     7,     7,     7,     1,     3,     3 }, // Urdu/Arabic/India
    {    306,     4,    50,    0,    0,  263,  273,    6,    0,    1,    2,    3,    4,    5,    9,   18,   17,   20,   19, 1558,   44,   10,   22,20150,20150,20204,20204,20224,20224,  782,  800,    0,    5,   22,  138, 5213,    9,   13, 5870, 5878,  6,  6, 10,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 54, 54, 20, 20, 13, 13, 12, 12,  4, 17, 23,  1, 11,  4,  6,  8,  5, {67,78,89},      2,     1,     7,     6,     7,     1,     3,     3 }, // Uyghur/Arabic/China
    {    307,    66,   251,    0,    0, 1078, 1078,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   13,   12, 1575,  127,   55,    0,20237,20237,20297,20297,20328,20328,  325,  812,  195,    5,   22,  335, 5224,   19,    0, 5883, 5889,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  8, 11,  5, 60, 60, 31, 31, 13, 13,  2,  2,  4, 17, 23,  4, 17,  5,  0,  6, 11, {85,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Uzbek/Latin/Uzbekistan
    {    307,     4,     1,    0,    0,    0,    0,   53,   21,   22,   23,   61,   35,   62,   65,   10,   11,   12,   13, 1593,  454,   55,    1,15005,15005,20341,20341,   83,   83,    0,    0,    0,    5,   22,  281, 3785,   19,    0, 5900, 4566,  6,  6,  6,  6,  1,  1,  1,  1,  1,  3,  3,  4,  1,  1,  1,  1, 33,  8, 11,  4, 48, 48, 20, 20, 13, 13,  2,  2,  4, 17, 23,  1,  6,  5,  0,  6,  9, {65,70,78},      0,     0,     6,     4,     5,     1,     3,     3 }, // Uzbek/Arabic/Afghanistan
    {    307,    27,   251,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,  778,  127,   54,    0,20361,20361,20413,20413,20440,20440,  794,  814,    0,    5,   22,  339, 5241,   19,    0, 5906, 5913,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  8, 12,  5, 52, 52, 27, 27, 13, 13,  2,  2,  4, 17, 23,  3, 14,  5,  0,  7, 10, {85,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Uzbek/Cyrillic/Uzbekistan
    {    308,   139,   134,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,20453,20453,20453,20453,   83,   83,    0,    0,    0,    5,   22,    1, 5255,    9,   13, 5923, 5925,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 29, 29, 29, 29, 13, 13,  2,  2,  4, 17, 23,  1,  8,  4,  6,  2,  4, {76,82,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Vai/Vai/Liberia
    {    308,    66,   134,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,   10,   22,20482,20482,20482,20482,   83,   83,    0,    0,    0,    5,   22,    1, 5263,    9,   13, 5929, 5932,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 12,  7, 47, 47, 47, 47, 13, 13,  2,  2,  4, 17, 23,  1, 13,  4,  6,  3,  8, {76,82,68},      2,     1,     1,     6,     7,     1,     3,     3 }, // Vai/Latin/Liberia
    {    309,    66,   216,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Venda/Latin/South Africa
    {    310,    66,   255,    0,    0, 1086, 1086,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,  192,  127,    0,    0,20529,20529,20583,20583,20615,20615,  796,  816,    0,    5,   22,  320, 5276,   19,    0, 5940, 5950,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 10,  5, 54, 54, 32, 32, 20, 20,  2,  2,  4, 17, 23,  1, 13,  5,  0, 10,  8, {86,78,68},      0,     0,     1,     6,     7,     1,     3,     3 }, // Vietnamese/Latin/Vietnam
    {    311,    66,   258,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // Volapuk/Latin/World
    {    312,    66,   230,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,11753,11753,11814,11814, 1041, 1041,  398,  414,    0,    5,   22,  118, 3392,    9,    0, 5958, 2025,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 61, 61, 27, 27, 13, 13,  5,  9,  4, 17, 23,  3, 20,  4,  0,  8,  8, {84,90,83},      2,     0,     1,     6,     7,     1,     3,     3 }, // Vunjo/Latin/Tanzania
    {    313,    66,    23,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,   13,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1,  0,  5,  0,  0,  0, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Walloon/Latin/Belgium
    {    314,    66,   226,    0,    0,  384,  384,    6,    1,   13,    2,    3,    4,    5,    9,   17,   18,   19,   20,  345,   44,    0,    0,20635,20635,20687,20687,20714,20714,    0,    0,    0,    5,   22,    0,    0,    4,    0, 5966, 5972,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18, 10, 10,  5, 52, 52, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  6,  6, {67,72,70},      2,     0,     1,     6,     7,     1,     3,     3 }, // Walser/Latin/Switzerland
    {    315,    66,    15,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  246,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2,  0,  5,  0,  0,  0, {65,85,68},      2,     1,     7,     6,     7,     1,     3,     3 }, // Warlpiri/Latin/Australia
    {    316,    66,   246,    0,    0, 1094, 1105,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,    0,  127,    0,    0,20727,20727,20803,20831,20860,20860,  798,  818, 1351,    5,   22,   91, 5289,    9,   13, 5978, 5985,  6,  6, 11, 10,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  8, 10,  5, 76, 76, 28, 29, 14, 14,  2,  2,  7, 17, 23,  1, 12,  4,  6,  7, 16, {71,66,80},      2,     1,     1,     6,     7,     1,     3,     3 }, // Welsh/Latin/United Kingdom
    {    317,     4,   178,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,  184,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  2,  0,  5,  0,  0,  0, {80,75,82},      2,     0,     7,     6,     7,     1,     3,     3 }, // Western Balochi/Arabic/Pakistan
    {    318,    66,   165,    0,    0,    7,    7,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,  432,    0,    0,20874,20874,20927,20927,   83,   83,    0,    0,    0,    5,   22,   13,   73,    4,   37, 6001, 6006,  6,  6,  8,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 53, 53, 20, 20, 13, 13,  2,  2,  4, 17, 23,  1,  4,  5,  7,  5,  8, {69,85,82},      2,     1,     1,     6,     7,     1,     3,     3 }, // Western Frisian/Latin/Netherlands
    {    319,    33,    77,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,   27,   44,    0,    0,   56,   56,   56,   56,   83,   83,    0,    0,    0,    5,   22,    0,    0,    4,    0,    0,    0,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 27, 27, 27, 27, 13, 13,  2,  2,  4, 17, 23,  0,  0,  5,  0,  0,  0, {69,84,66},      2,     1,     7,     6,     7,     1,     3,     3 }, // Wolaytta/Ethiopic/Ethiopia
    {    320,    66,   206,    0,    0,    0,    0,    6,    1,    0,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1626,  432,    0,    0,20947,20947,20996,20996,20996,20996,  709,  820,    0,    5,   22,    3, 5301,    4,    0, 6014, 2732,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 49, 49, 27, 27, 27, 27,  3,  3,  4, 17, 23,  3, 29,  5,  0,  5,  8, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Wolof/Latin/Senegal
    {    321,    66,   216,    0,    0,    0,    0,    6,    0,   14,    2,    3,    4,    5,    9,   12,   13,   10,   11,   27,   44,    0,    0,21023,21023,21083,21083,   83,   83,    0,    0,    0,    5,   22,    0, 5330,    9,    0, 6019, 6027,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17, 10, 10,  5, 60, 60, 27, 27, 13, 13,  2,  2,  4, 17, 23,  1, 24,  4,  0,  8, 15, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Xhosa/Latin/South Africa
    {    322,    66,    40,    0,    0,    0,    0,    6,    1,   14,    2,    3,    4,    5,    9,   17,   18,   17,   18,   71,   87,    0,    0,21110,21110,21180,21180,21200,21200,  800,  823,    0,    5,   22,    2,    0,   19,   24, 6042, 6048,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 70, 70, 20, 20, 13, 13,  8,  8,  4, 17, 23,  4,  0,  5,  7,  6,  7, {88,65,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Yangben/Latin/Cameroon
    {    323,    47,   258,    0,    0, 1115, 1115,    6,    0,    1,    2,    3,    4,    5,    9,   11,   11,   13,   13, 1643,  127,    0,    0,21213,21213,21213,21213,   83,   83,  808,  831,    0,    5,   22,    0,    0,    4,    0, 6055, 6061,  6,  6,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 19,  8, 10,  5, 53, 53, 53, 53, 13, 13, 11, 10,  4, 17, 23,  0,  0,  5,  0,  6,  5,    {0,0,0},      2,     1,     1,     6,     7,     1,     3,     3 }, // Yiddish/Hebrew/World
    {    324,    66,   169,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1662,   87,    0,    1,21266,21309,21377,21377,21409,21409,  819,  841, 1358, 1369,   22,  121, 5354,    9,   13, 6066, 6076,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  3, 43, 68, 32, 32, 13, 13,  5,  5, 11, 37, 23,  1, 14,  4,  6, 10,  8, {78,71,78},      2,     1,     1,     6,     7,     1,     3,     3 }, // Yoruba/Latin/Nigeria
    {    324,    66,    25,    0,    0,    0,    0,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13, 1662,   87,    0,    1,21422,21465,21533,21533,21565,21565,  824,  846, 1406, 1369,   22,    3, 5368,    9,   13, 6066, 6084,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  3, 43, 68, 32, 32, 13, 13,  5,  5, 11, 37, 23,  3, 26,  4,  6, 10,  6, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Yoruba/Latin/Benin
    {    325,    66,   170,    0,    0,    0,    0,    6,    0,   14,    2,    3,    4,    5,    9,   10,   11,   12,   13,   71,   87,    0,    0,21578,21578, 9775, 9775,21630,21630,  709,  721,    0,    5,   22,    3, 3197,    0,    0, 6090, 5701,  6,  6,  6,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16,  8, 10,  5, 52, 52, 27, 27, 13, 13,  8, 10,  4, 17, 23,  3, 16,  4,  0, 10,  5, {88,79,70},      0,     0,     1,     6,     7,     1,     3,     3 }, // Zarma/Latin/Niger
    {    327,    66,   216,    0,    0, 1124, 1133,    6,    0,    1,    2,    3,    4,    5,    9,   10,   11,   12,   13,  321,  339,    0,    0,21643,21643,21716,21716,21743,21743,    0,    0,    0,    5,   22,    0, 5394,    9,   13, 6100, 6107,  6,  6,  9,  8,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 18,  6, 10,  5, 73, 73, 27, 27, 13, 13,  2,  2,  5, 17, 23,  1, 20,  4,  6,  7, 17, {90,65,82},      2,     1,     7,     6,     7,     1,     3,     3 }, // Zulu/Latin/South Africa
    {      0,     0,     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,    {0,0,0},      0,     0,     0,     0,     0,     0,     0,     0 } // trailing zeros
};

static const char16_t list_pattern_part_data[] = {
0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x3b, 0x25, 0x31, 0x20, 0x65, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x68,
0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x1363, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x648, 0x25, 0x32, 0x61b, 0x25, 0x31, 0x20, 0x587, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x986, 0x9f0, 0x9c1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x79, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x76, 0x259, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x98f, 0x9ac, 0x982, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x61,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x456, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x438, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x68, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x104a, 0x20, 0x25, 0x32, 0x25, 0x31,
0x1014, 0x103e, 0x1004, 0x1037, 0x103a, 0x20, 0x25, 0x32, 0x25, 0x31, 0x3001, 0x25, 0x32, 0x25, 0x31, 0x540c, 0x25, 0x32, 0x25, 0x31,
0x2c, 0x20, 0x75, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xd804, 0xdd03,
0xd804, 0xdd33, 0xd804, 0xdd03, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x13a0, 0x13b4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x13a0,
0x13b4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x548c, 0x25, 0x32, 0x25, 0x31, 0x53ca, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x924, 0x947, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x924, 0x947, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xf51, 0xf44, 0xf0b,
0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x6e, 0x64, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x6b, 0x61, 0x6a, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6a, 0x61, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32,
0x25, 0x31, 0x2c, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x65, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2e41, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0xd83a, 0xdd2b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x67, 0x75, 0x73, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x10d3,
0x10d0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x3ba, 0x3b1, 0x3b9, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xa85, 0xaa8, 0xac7, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x64, 0x61, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x64, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d5, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x914, 0x930,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe9, 0x73, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6c,
0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6c, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x64, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x61, 0x6d, 0x6d, 0x61, 0x20, 0x25, 0x32,
0x25, 0x31, 0x2c, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x436, 0x4d9, 0x43d, 0x435, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x1793, 0x17b7, 0x1784, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x1793, 0x17b7, 0x1784, 0x200b, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbc0f, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0xfb, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x436, 0x430, 0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xec1, 0xea5,
0xeb0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6d, 0x70, 0xe9, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x72, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x6e, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x20, 0xd0e, 0xd28,
0xd4d, 0xd28, 0xd3f, 0xd35, 0x25, 0x31, 0x20, 0xd15, 0xd42, 0xd1f, 0xd3e, 0xd24, 0xd46, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x75, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x985, 0x9ae, 0x9b8, 0x9c1, 0x982, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x906, 0x923, 0x93f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x25, 0x32, 0x25, 0x31, 0x20, 0x930,
0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x1e3f, 0x62,
0x25b, 0x6e, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x70, 0x254, 0x70, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0xb13, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xb13, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x4d5, 0x43c, 0x4d5, 0x20, 0x25, 0x32,
0x25, 0x31, 0x60c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x627, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648,
0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x200f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xa05, 0xa24, 0xa47, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x219, 0x69, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x443, 0x43e, 0x43d, 0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x924, 0x925, 0x93e,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x924, 0x925, 0x93e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x6fd, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x6fd, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xdc3, 0xdc4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xdc3,
0xdc4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0xa0, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x6e, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x73, 0x61, 0x72, 0x65, 0x6e, 0x67, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x73, 0x61, 0x72, 0x65, 0x6e, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f, 0x63, 0x68, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xbae, 0xbb1, 0xbcd, 0xbb1, 0xbc1, 0xbae, 0xbcd, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x4bb, 0x4d9,
0x43c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xc2e, 0xc30, 0xc3f, 0xc2f, 0xc41, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6d, 0x6f,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x77, 0x65, 0x20, 0x25, 0x32, 0x25,
0x31, 0x60c, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x76, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0xe0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x28,
0x63, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x63, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d0, 0x5d5,
0x5df, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x65, 0x2d, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6e, 0x65, 0x2d, 0x25,
0x32
};

static const char16_t single_character_data[] = {
0x2e, 0x2c, 0x25, 0x30, 0x2d, 0x2b, 0x65, 0x22, 0x27, 0x45, 0x201c, 0x201d, 0x2018, 0x2019, 0xa0, 0x201e, 0x201a, 0xab, 0xbb, 0x2039,
0x203a, 0x66b, 0x66c, 0x66a, 0x61c, 0x660, 0x61c, 0x2d, 0x61c, 0x2b, 0x627, 0x633, 0x200e, 0x25, 0x200e, 0x200e, 0x2d, 0x200e, 0x2b, 0x9e6,
0x2212, 0x1040, 0x300c, 0x300d, 0x300e, 0x300f, 0x200f, 0x2d, 0x200f, 0x2b, 0xd804, 0xdd36, 0xd7, 0x31, 0x30, 0x5e, 0xf20, 0x202f, 0x2e41, 0xd83a,
0xdd50, 0x6f0, 0x200e, 0x2b, 0x200e, 0xd7, 0x6f1, 0x6f0, 0x5e, 0x966, 0xb7, 0x31, 0x30, 0x5e, 0x200e, 0x2212, 0x1c50, 0x415
};

static const char16_t date_format_data[] = {
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20,
0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x4d, 0x2d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x79, 0x79, 0x2f, 0x4d, 0x4d, 0x2f, 0x64,
0x64, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64,
0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x200f, 0x2f, 0x4d, 0x200f, 0x2f,
0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x569, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20,
0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79,
0x79, 0x28, 0x27, 0x65, 0x27, 0x29, 0x27, 0x6b, 0x6f, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x27, 0x72, 0x65, 0x6e, 0x27,
0x20, 0x64, 0x28, 0x27, 0x61, 0x27, 0x29, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x433, 0x27,
0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x4d,
0x2f, 0x64, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79,
0x79, 0x79, 0x79, 0x2e, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x2e, 0x4d, 0x2e, 0x79,
0x79, 0x2e, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x20, 0x27, 0x433, 0x27, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x104a, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x104a, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79, 0x79,
0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d,
0x2f, 0x64, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x27, 0x64, 0xe4, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x2e,
0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64,
0x64, 0x20, 0x27, 0x64, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79,
0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2c, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf63,
0xf7c, 0xf0b, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0xf5a, 0xf7a, 0xf66, 0xf0b, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
0x2f, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2d, 0x27, 0x61, 0x27, 0x20, 0x27, 0x64,
0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x6c, 0x69, 0x61, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d, 0x2e, 0x79,
0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x27, 0x64, 0x61, 0x6c, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x27, 0x6d, 0x68,
0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27,
0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64,
0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20,
0x64, 0x20, 0x5d1, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x64, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d, 0x2e,
0x20, 0x64, 0x64, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2e, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x6c, 0x65, 0x27, 0x20, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69, 0x27,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d,
0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x436, 0x27, 0x2e, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0xb144, 0x20, 0x4d, 0xc6d4, 0x20, 0x64, 0xc77c, 0x20, 0x64,
0x64, 0x64, 0x64, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x27, 0x436, 0x27,
0x2e, 0x2c, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20,
0xe97, 0xeb5, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20,
0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x27, 0x67, 0x61, 0x64, 0x61, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x6d, 0x27, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x64, 0x27,
0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x64, 0x2e,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x74, 0x61, 0x27,
0x2019, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x79,
0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x43e, 0x43d, 0x44b, 0x27, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x27, 0x44b, 0x43d, 0x27, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x433, 0x430,
0x440, 0x430, 0x433, 0x27, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x4d, 0x4d, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20, 0x2c,
0x20, 0x27, 0x6c, 0x79, 0x25b, 0x27, 0x30c, 0x2bc, 0x20, 0x64, 0x20, 0x27, 0x6e, 0x61, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20,
0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x430, 0x437, 0x27, 0x64, 0x64, 0x64, 0x64, 0x20, 0x62f, 0x20, 0x79, 0x79, 0x79, 0x79,
0x20, 0x62f, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x69, 0x6c, 0x73, 0x27,
0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x441, 0x44b,
0x43b, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x43a, 0x4af, 0x43d, 0x44d, 0x27, 0x2c, 0x20, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27,
0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x2f, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x435, 0x43b, 0x27, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x64, 0xe17, 0xe35, 0xe48, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0xf60, 0xf72, 0xf0b, 0xf5a, 0xf7a, 0xf66, 0xf0b, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x1363, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x1218, 0x12d3, 0x120d, 0x1272, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x440, 0x27, 0x2e,
0x64, 0x64, 0x64, 0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
0x79, 0x79, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x646, 0x686,
0x6cc, 0x20, 0x6cc, 0x6cc, 0x644, 0x20, 0x64, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64,
0x64, 0x20, 0x6a9, 0x648, 0x646, 0x6cc, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79,
0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x5d8, 0x5df, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79
};

static const char16_t time_format_data[] = {
0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50,
0x20, 0x74, 0x68, 0x3a, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x2c,
0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a,
0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x2c, 0x20, 0x74, 0x48, 0x3a, 0x6d,
0x6d, 0x3a, 0x73, 0x73, 0x20, 0x27, 0x447, 0x27, 0x2e, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x20, 0x27, 0x447, 0x27, 0x2e,
0x74, 0x20, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x42, 0x20, 0x48, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x68, 0x3a,
0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x5b, 0x74, 0x5d, 0x74, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73,
0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20,
0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0xf46, 0xf74, 0xf0b,
0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0x48,
0x2d, 0x27, 0x61, 0x27, 0x20, 0x27, 0x68, 0x6f, 0x72, 0x6f, 0x27, 0x20, 0x27, 0x6b, 0x61, 0x6a, 0x27, 0x20, 0x6d, 0x3a,
0x73, 0x73, 0x20, 0x74, 0x41, 0x50, 0x20, 0x27, 0x67, 0x61, 0x27, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20,
0x74, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27,
0x73, 0x27, 0x20, 0x74, 0x48, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20,
0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20, 0x74, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x27, 0x68, 0x27,
0x20, 0x74, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x68, 0x68, 0x3a, 0x6d, 0x6d,
0x20, 0x41, 0x50, 0x48, 0x6642, 0x6d, 0x6d, 0x5206, 0x73, 0x73, 0x79d2, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0xc2dc, 0x20, 0x6d,
0xbd84, 0x20, 0x73, 0xcd08, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x48, 0x20, 0xec2, 0xea1, 0xe87, 0x20, 0x6d,
0x20, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x73, 0x73, 0x20, 0xea7, 0xeb4, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x74, 0x27, 0x4b, 0x6c,
0x6f, 0x63, 0x6b, 0x27, 0x20, 0x48, 0x2e, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0x27, 0x4b, 0x6c, 0x27,
0x2e, 0x20, 0x48, 0x2e, 0x6d, 0x6d, 0x27, 0x6b, 0x6c, 0x27, 0x2e, 0x20, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73,
0x20, 0x74, 0x74, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d,
0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x20, 0xe19, 0xe32, 0xe2c, 0xe34, 0xe01, 0xe32, 0x20, 0x6d, 0x6d, 0x20, 0xe19, 0xe32,
0xe17, 0xe35, 0x20, 0x73, 0x73, 0x20, 0xe27, 0xe34, 0xe19, 0xe32, 0xe17, 0xe35, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x20, 0x27,
0x68, 0x6f, 0x64, 0x17a, 0x27, 0x2e
};

static const char16_t days_data[] = {
0x53, 0x75, 0x6e, 0x64, 0x61, 0x79, 0x3b, 0x4d, 0x6f, 0x6e, 0x64, 0x61, 0x79, 0x3b, 0x54, 0x75, 0x65, 0x73, 0x64, 0x61,
0x79, 0x3b, 0x57, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x54, 0x68, 0x75, 0x72, 0x73, 0x64, 0x61, 0x79,
0x3b, 0x46, 0x72, 0x69, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x61, 0x74, 0x75, 0x72, 0x64, 0x61, 0x79, 0x53, 0x75, 0x6e, 0x3b,
0x4d, 0x6f, 0x6e, 0x3b, 0x54, 0x75, 0x65, 0x3b, 0x57, 0x65, 0x64, 0x3b, 0x54, 0x68, 0x75, 0x3b, 0x46, 0x72, 0x69, 0x3b,
0x53, 0x61, 0x74, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x53, 0x37, 0x3b, 0x31, 0x3b,
0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x53, 0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e,
0x64, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x57, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67,
0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x56, 0x72, 0x79, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x61,
0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x53, 0x6f, 0x2e, 0x3b, 0x4d, 0x61, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x57, 0x6f,
0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x56, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x57,
0x3b, 0x44, 0x3b, 0x56, 0x3b, 0x53, 0x74, 0x73, 0x75, 0x294, 0x6e, 0x74, 0x73, 0x268, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75,
0x6b, 0x70, 0xe0, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67, 0x68, 0x254, 0x65, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x74,
0x254, 0x300, 0x6d, 0x6c, 0xf2, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x6d, 0xe8, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67,
0x68, 0x268, 0x302, 0x6d, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x6e, 0x64, 0x7a, 0x268, 0x6b, 0x254, 0x294, 0x254, 0x6e, 0x74, 0x73,
0x3b, 0x6b, 0x70, 0x61, 0x3b, 0x67, 0x68, 0x254, 0x3b, 0x74, 0x254, 0x6d, 0x3b, 0x75, 0x6d, 0x65, 0x3b, 0x67, 0x68, 0x268,
0x3b, 0x64, 0x7a, 0x6b, 0x6e, 0x3b, 0x6b, 0x3b, 0x67, 0x3b, 0x74, 0x3b, 0x75, 0x3b, 0x67, 0x3b, 0x64, 0x4b, 0x77, 0x65,
0x73, 0x69, 0x64, 0x61, 0x3b, 0x44, 0x77, 0x6f, 0x77, 0x64, 0x61, 0x3b, 0x42, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x3b, 0x57,
0x75, 0x6b, 0x75, 0x64, 0x61, 0x3b, 0x59, 0x61, 0x77, 0x64, 0x61, 0x3b, 0x46, 0x69, 0x64, 0x61, 0x3b, 0x4d, 0x65, 0x6d,
0x65, 0x6e, 0x65, 0x64, 0x61, 0x4b, 0x77, 0x65, 0x3b, 0x44, 0x77, 0x6f, 0x3b, 0x42, 0x65, 0x6e, 0x3b, 0x57, 0x75, 0x6b,
0x3b, 0x59, 0x61, 0x77, 0x3b, 0x46, 0x69, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x4b, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x57, 0x3b,
0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x65, 0x20, 0x64, 0x69, 0x65, 0x6c, 0x3b, 0x65, 0x20, 0x68, 0xeb, 0x6e, 0xeb, 0x3b, 0x65,
0x20, 0x6d, 0x61, 0x72, 0x74, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0xeb, 0x72, 0x6b, 0x75, 0x72, 0xeb, 0x3b, 0x65, 0x20, 0x65,
0x6e, 0x6a, 0x74, 0x65, 0x3b, 0x65, 0x20, 0x70, 0x72, 0x65, 0x6d, 0x74, 0x65, 0x3b, 0x65, 0x20, 0x73, 0x68, 0x74, 0x75,
0x6e, 0xeb, 0x64, 0x69, 0x65, 0x3b, 0x68, 0xeb, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0xeb, 0x72, 0x3b, 0x65, 0x6e,
0x6a, 0x3b, 0x70, 0x72, 0x65, 0x3b, 0x73, 0x68, 0x74, 0x44, 0x69, 0x65, 0x3b, 0x48, 0xeb, 0x6e, 0x3b, 0x4d, 0x61, 0x72,
0x3b, 0x4d, 0xeb, 0x72, 0x3b, 0x45, 0x6e, 0x6a, 0x3b, 0x50, 0x72, 0x65, 0x3b, 0x53, 0x68, 0x74, 0x64, 0x3b, 0x68, 0x3b,
0x6d, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x70, 0x3b, 0x73, 0x68, 0x12a5, 0x1211, 0x12f5, 0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230,
0x129e, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b, 0x1245, 0x12f3, 0x121c, 0x12a5, 0x1211, 0x12f5,
0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b,
0x1245, 0x12f3, 0x121c, 0x12a5, 0x3b, 0x1230, 0x3b, 0x121b, 0x3b, 0x1228, 0x3b, 0x1210, 0x3b, 0x12d3, 0x3b, 0x1245, 0x627, 0x644, 0x623, 0x62d,
0x62f, 0x3b, 0x627, 0x644, 0x627, 0x62b, 0x646, 0x64a, 0x646, 0x3b, 0x627, 0x644, 0x62b, 0x644, 0x627, 0x62b, 0x627, 0x621, 0x3b, 0x627,
0x644, 0x623, 0x631, 0x628, 0x639, 0x627, 0x621, 0x3b, 0x627, 0x644, 0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x627, 0x644, 0x62c, 0x645, 0x639,
0x629, 0x3b, 0x627, 0x644, 0x633, 0x628, 0x62a, 0x62d, 0x3b, 0x646, 0x3b, 0x62b, 0x3b, 0x631, 0x3b, 0x62e, 0x3b, 0x62c, 0x3b, 0x633,
0x56f, 0x56b, 0x580, 0x561, 0x56f, 0x56b, 0x3b, 0x565, 0x580, 0x56f, 0x578, 0x582, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x565, 0x580,
0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x579, 0x578, 0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x570,
0x56b, 0x576, 0x563, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x578, 0x582, 0x580, 0x562, 0x561, 0x569, 0x3b, 0x577, 0x561, 0x562, 0x561,
0x569, 0x56f, 0x56b, 0x580, 0x3b, 0x565, 0x580, 0x56f, 0x3b, 0x565, 0x580, 0x584, 0x3b, 0x579, 0x580, 0x584, 0x3b, 0x570, 0x576, 0x563,
0x3b, 0x578, 0x582, 0x580, 0x3b, 0x577, 0x562, 0x569, 0x53f, 0x3b, 0x535, 0x3b, 0x535, 0x3b, 0x549, 0x3b, 0x540, 0x3b, 0x548, 0x3b,
0x547, 0x9a6, 0x9c7, 0x993, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2,
0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac,
0x9be, 0x9f0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9f0, 0x9a6, 0x9c7,
0x993, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x3b,
0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9a6, 0x3b, 0x9b8, 0x3b, 0x9ae, 0x3b, 0x9ac, 0x3b, 0x9ac, 0x3b, 0x9b6,
0x3b, 0x9b6, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x6c, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72,
0x74, 0x65, 0x73, 0x3b, 0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x78, 0x75, 0x65, 0x76, 0x65, 0x73,
0x3b, 0x76, 0x69, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x75, 0x64, 0x6f, 0x6d, 0x3b, 0x6c,
0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0xe9, 0x3b, 0x78, 0x75, 0x65, 0x3b, 0x76, 0x69, 0x65, 0x3b, 0x73,
0xe1, 0x62, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x56, 0x3b, 0x53, 0x4a, 0x75, 0x6d, 0x61, 0x70,
0x69, 0x6c, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49,
0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74,
0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4a, 0x6d,
0x6f, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x3b,
0x62, 0x61, 0x7a, 0x61, 0x72, 0x20, 0x65, 0x72, 0x74, 0x259, 0x73, 0x69, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e, 0x62,
0x259, 0x20, 0x61, 0x78, 0x15f, 0x61, 0x6d, 0x131, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x63, 0xfc,
0x6d, 0x259, 0x20, 0x61, 0x78, 0x15f, 0x61, 0x6d, 0x131, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x3b, 0x15f, 0x259, 0x6e, 0x62, 0x259,
0x42, 0x2e, 0x3b, 0x42, 0x2e, 0x45, 0x2e, 0x3b, 0xc7, 0x2e, 0x41, 0x2e, 0x3b, 0xc7, 0x2e, 0x3b, 0x43, 0x2e, 0x41, 0x2e,
0x3b, 0x43, 0x2e, 0x3b, 0x15e, 0x2e, 0x42, 0x2e, 0x3b, 0x42, 0x2e, 0x65, 0x2e, 0x3b, 0xc7, 0x2e, 0x61, 0x2e, 0x3b, 0xc7,
0x2e, 0x3b, 0x43, 0x2e, 0x61, 0x2e, 0x3b, 0x43, 0x2e, 0x3b, 0x15e, 0x2e, 0x431, 0x430, 0x437, 0x430, 0x440, 0x3b, 0x431, 0x430,
0x437, 0x430, 0x440, 0x20, 0x435, 0x440, 0x442, 0x4d9, 0x441, 0x438, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x20,
0x430, 0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9,
0x20, 0x430, 0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9, 0x3b, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x411, 0x2e,
0x3b, 0x411, 0x2e, 0x415, 0x2e, 0x3b, 0x427, 0x2e, 0x410, 0x2e, 0x3b, 0x427, 0x2e, 0x3b, 0x4b8, 0x2e, 0x410, 0x2e, 0x3b, 0x4b8,
0x2e, 0x3b, 0x428, 0x2e, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x1dd, 0x3b, 0x6c, 0x1dd, 0x6e, 0x64, 0xed, 0x3b, 0x6d, 0x61, 0x61,
0x64, 0xed, 0x3b, 0x6d, 0x25b, 0x6b, 0x72, 0x25b, 0x64, 0xed, 0x3b, 0x6a, 0x1dd, 0x1dd, 0x64, 0xed, 0x3b, 0x6a, 0xfa, 0x6d,
0x62, 0xe1, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0xed, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6c, 0x1dd, 0x6e, 0x3b, 0x6d, 0x61, 0x61,
0x3b, 0x6d, 0x25b, 0x6b, 0x3b, 0x6a, 0x1dd, 0x1dd, 0x3b, 0x6a, 0xfa, 0x6d, 0x3b, 0x73, 0x61, 0x6d, 0x73, 0x3b, 0x6c, 0x3b,
0x6d, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x73, 0x6b, 0x61, 0x72, 0x69, 0x3b, 0x6e, 0x74, 0x25b, 0x6e, 0x25b, 0x3b,
0x74, 0x61, 0x72, 0x61, 0x74, 0x61, 0x3b, 0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x6d, 0x69, 0x73, 0x61,
0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x69, 0x62, 0x69, 0x72, 0x69, 0x6b, 0x61, 0x72, 0x3b, 0x6e, 0x74, 0x25b, 0x3b,
0x74, 0x61, 0x72, 0x3b, 0x61, 0x72, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x62, 0x4b,
0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x53, 0x9b0, 0x9ac, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b8,
0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be,
0x9b0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x9ac,
0x9be, 0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x9b0, 0x9ac, 0x9bf, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd,
0x997, 0x9b2, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd,
0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x3b, 0x9ae, 0x3b, 0x9ac, 0x9c1, 0x3b, 0x9ac, 0x9c3, 0x3b, 0x9b6, 0x9c1,
0x3b, 0x9b6, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x254, 0x302, 0x79, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x6a, 0x61,
0x14b, 0x67, 0x75, 0x6d, 0x62, 0x61, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0xfb, 0x6d, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20,
0x14b, 0x67, 0xea, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6d, 0x62, 0x254, 0x6b, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6b,
0x254, 0x254, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6a, 0xf4, 0x6e, 0x6e, 0x254, 0x79, 0x3b, 0x6e, 0x6a, 0x61, 0x3b, 0x75,
0x75, 0x6d, 0x3b, 0x14b, 0x67, 0x65, 0x3b, 0x6d, 0x62, 0x254, 0x3b, 0x6b, 0x254, 0x254, 0x3b, 0x6a, 0x6f, 0x6e, 0x6e, 0x3b,
0x6e, 0x3b, 0x75, 0x3b, 0x14b, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6a, 0x69, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x61, 0x3b, 0x61,
0x73, 0x74, 0x65, 0x6c, 0x65, 0x68, 0x65, 0x6e, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x61, 0x72, 0x74, 0x65, 0x61, 0x3b,
0x61, 0x73, 0x74, 0x65, 0x61, 0x7a, 0x6b, 0x65, 0x6e, 0x61, 0x3b, 0x6f, 0x73, 0x74, 0x65, 0x67, 0x75, 0x6e, 0x61, 0x3b,
0x6f, 0x73, 0x74, 0x69, 0x72, 0x61, 0x6c, 0x61, 0x3b, 0x6c, 0x61, 0x72, 0x75, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x69, 0x67,
0x2e, 0x3b, 0x61, 0x6c, 0x2e, 0x3b, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x7a, 0x2e, 0x3b, 0x6f, 0x67, 0x2e, 0x3b, 0x6f, 0x72,
0x2e, 0x3b, 0x6c, 0x72, 0x2e, 0x49, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4f, 0x3b, 0x4f, 0x3b, 0x4c, 0x43d, 0x44f,
0x434, 0x437, 0x435, 0x43b, 0x44f, 0x3b, 0x43f, 0x430, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x430, 0x43a, 0x3b, 0x430, 0x45e, 0x442,
0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x435, 0x440, 0x430, 0x434, 0x430, 0x3b, 0x447, 0x430, 0x446, 0x432, 0x435, 0x440, 0x3b, 0x43f,
0x44f, 0x442, 0x43d, 0x456, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x430,
0x45e, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x446, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x43d, 0x3b, 0x43f, 0x3b, 0x430, 0x3b, 0x441,
0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x50, 0x61, 0x20, 0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x50, 0x61, 0x6c,
0x69, 0x63, 0x68, 0x69, 0x6d, 0x6f, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x62, 0x75, 0x6c, 0x69, 0x3b, 0x50,
0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x6e, 0x65,
0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x6f, 0x3b, 0x50, 0x61, 0x63, 0x68, 0x69, 0x62, 0x65,
0x6c, 0x75, 0x73, 0x68, 0x69, 0x70, 0x61, 0x20, 0x6d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73,
0x68, 0x61, 0x68, 0x75, 0x76, 0x69, 0x6c, 0x75, 0x68, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x76, 0x69, 0x6c, 0x69,
0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x74, 0x61, 0x79, 0x69,
0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75, 0x6c,
0x65, 0x6d, 0x62, 0x65, 0x6c, 0x61, 0x4d, 0x75, 0x6c, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x48, 0x69, 0x76, 0x3b, 0x48, 0x69,
0x64, 0x3b, 0x48, 0x69, 0x74, 0x3b, 0x48, 0x69, 0x68, 0x3b, 0x4c, 0x65, 0x6d, 0x4d, 0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x48,
0x3b, 0x48, 0x3b, 0x57, 0x3b, 0x4a, 0x930, 0x92c, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e,
0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x926, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x938, 0x925, 0x93f, 0x92c,
0x93e, 0x930, 0x3b, 0x938, 0x941, 0x916, 0x941, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x930,
0x92c, 0x93f, 0x3b, 0x938, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x926, 0x3b, 0x92c, 0x93f, 0x938, 0x925, 0x93f,
0x3b, 0x938, 0x941, 0x916, 0x941, 0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x930, 0x3b, 0x938, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941,
0x3b, 0x92c, 0x93f, 0x3b, 0x938, 0x941, 0x3b, 0x938, 0x941, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f,
0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x69,
0x6a, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b,
0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72,
0x69, 0x3b, 0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x6e, 0x3b, 0x70, 0x3b, 0x75, 0x3b, 0x73,
0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x4e, 0x3b, 0x50, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53, 0x43d,
0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442,
0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430,
0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e,
0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441, 0x440, 0x438, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443,
0x431, 0x43d, 0x3b, 0x43f, 0x3b, 0x443, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75,
0x6e, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x4d, 0x65, 0x72, 0x63, 0x2bc, 0x68, 0x65, 0x72, 0x3b, 0x59, 0x61,
0x6f, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e, 0x53, 0x75, 0x6c, 0x3b,
0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x65, 0x75, 0x2e, 0x3b, 0x4d, 0x65, 0x72, 0x2e, 0x3b, 0x59, 0x61, 0x6f, 0x75, 0x3b, 0x47,
0x77, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x64, 0x2e, 0x53, 0x75, 0x3b, 0x4c, 0x3b, 0x4d, 0x7a, 0x3b, 0x4d, 0x63, 0x3b, 0x59,
0x3b, 0x47, 0x3b, 0x53, 0x61, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d,
0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x44f, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442,
0x432, 0x44a, 0x440, 0x442, 0x44a, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x44a, 0x43a, 0x3b, 0x441, 0x44a, 0x431, 0x43e, 0x442, 0x430, 0x43d,
0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x43d,
0x3b, 0x43f, 0x3b, 0x432, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x1002, 0x1014, 0x103d,
0x1031, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x101c, 0x102c, 0x3b, 0x1021, 0x1004, 0x103a, 0x1039, 0x1002, 0x102b, 0x3b, 0x1017, 0x102f, 0x1012,
0x1039, 0x1013, 0x101f, 0x1030, 0x1038, 0x3b, 0x1000, 0x103c, 0x102c, 0x101e, 0x1015, 0x1010, 0x1031, 0x1038, 0x3b, 0x101e, 0x1031, 0x102c, 0x1000, 0x103c,
0x102c, 0x3b, 0x1005, 0x1014, 0x1031, 0x1010, 0x3b, 0x1010, 0x3b, 0x1021, 0x3b, 0x1017, 0x3b, 0x1000, 0x3b, 0x101e, 0x3b, 0x1005, 0x661f, 0x671f,
0x65e5, 0x3b, 0x661f, 0x671f, 0x4e00, 0x3b, 0x661f, 0x671f, 0x4e8c, 0x3b, 0x661f, 0x671f, 0x4e09, 0x3b, 0x661f, 0x671f, 0x56db, 0x3b, 0x661f, 0x671f,
0x4e94, 0x3b, 0x661f, 0x671f, 0x516d, 0x65e5, 0x3b, 0x4e00, 0x3b, 0x4e8c, 0x3b, 0x4e09, 0x3b, 0x56db, 0x3b, 0x4e94, 0x3b, 0x516d, 0x5468, 0x65e5,
0x3b, 0x5468, 0x4e00, 0x3b, 0x5468, 0x4e8c, 0x3b, 0x5468, 0x4e09, 0x3b, 0x5468, 0x56db, 0x3b, 0x5468, 0x4e94, 0x3b, 0x5468, 0x516d, 0x64, 0x69,
0x75, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b, 0x64, 0x69, 0x6c, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x72,
0x74, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x65, 0x63, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a, 0x6f, 0x75, 0x73, 0x3b, 0x64,
0x69, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x73, 0x73, 0x61, 0x62, 0x74, 0x65, 0x64, 0x67, 0x2e,
0x3b, 0x64, 0x6c, 0x2e, 0x3b, 0x64, 0x74, 0x2e, 0x3b, 0x64, 0x63, 0x2e, 0x3b, 0x64, 0x6a, 0x2e, 0x3b, 0x64, 0x76, 0x2e,
0x3b, 0x64, 0x73, 0x2e, 0x64, 0x67, 0x3b, 0x64, 0x6c, 0x3b, 0x64, 0x74, 0x3b, 0x64, 0x63, 0x3b, 0x64, 0x6a, 0x3b, 0x64,
0x76, 0x3b, 0x64, 0x73, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61,
0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0x79, 0x65, 0x72, 0x6b, 0x75, 0x6c, 0x65, 0x73, 0x3b, 0x48, 0x75, 0x77, 0x65,
0x62, 0x65, 0x73, 0x3b, 0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x64, 0x6f, 0x44,
0x6f, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x79, 0x3b, 0x48, 0x75, 0x77, 0x3b, 0x42,
0x69, 0x79, 0x3b, 0x53, 0x61, 0x62, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x42, 0x3b, 0x53, 0x41,
0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x41, 0x79, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x41,
0x6b, 0x72, 0x61, 0x73, 0x3b, 0x41, 0x6b, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x41,
0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x41, 0x73, 0x61, 0x3b, 0x41, 0x79, 0x6e, 0x3b, 0x41, 0x73, 0x6e, 0x3b, 0x41, 0x6b,
0x72, 0x3b, 0x41, 0x6b, 0x77, 0x3b, 0x41, 0x73, 0x6d, 0x3b, 0x41, 0x73, 0x1e0d, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x6cc, 0x6d5, 0x6a9, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x62f, 0x648, 0x648, 0x634, 0x6d5,
0x645, 0x645, 0x6d5, 0x3b, 0x633, 0x6ce, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x686, 0x648, 0x627, 0x631, 0x634, 0x6d5, 0x645, 0x645,
0x6d5, 0x3b, 0x67e, 0x6ce, 0x646, 0x62c, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x6be, 0x6d5, 0x6cc, 0x646, 0x6cc, 0x3b, 0x634, 0x6d5,
0x645, 0x645, 0x6d5, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x6be, 0x3b, 0x634, 0xd804, 0xdd22, 0xd804, 0xdd27,
0xd804, 0xdd1d, 0xd804, 0xdd28, 0xd804, 0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0xd804,
0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd27, 0xd804, 0xdd01, 0xd804, 0xdd09, 0xd804, 0xdd27, 0xd804, 0xdd23, 0xd804, 0xdd34,
0xd804, 0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd2a, 0xd804, 0xdd16, 0xd804, 0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd22, 0xd804,
0xdd34, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd28, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0xd804, 0xdd1b, 0xd804, 0xdd34, 0xd804, 0xdd1d,
0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0xd804, 0xdd07, 0xd804, 0xdd34, 0xd804, 0xdd07, 0xd804, 0xdd2e, 0xd804, 0xdd22, 0xd804,
0xdd34, 0xd804, 0xdd1d, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0xd804, 0xdd1a, 0xd804, 0xdd28, 0xd804, 0xdd1d, 0xd804, 0xdd22,
0xd804, 0xdd34, 0xd804, 0xdd22, 0xd804, 0xdd27, 0xd804, 0xdd1d, 0xd804, 0xdd28, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0xd804, 0xdd1f, 0xd804, 0xdd34, 0x3b,
0xd804, 0xdd1f, 0xd804, 0xdd27, 0xd804, 0xdd01, 0xd804, 0xdd09, 0xd804, 0xdd27, 0xd804, 0xdd23, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd2a, 0xd804,
0xdd16, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd28, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0xd804, 0xdd1b, 0xd804, 0xdd34,
0x3b, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0xd804, 0xdd07, 0xd804, 0xdd34, 0xd804, 0xdd07, 0xd804, 0xdd2e, 0xd804, 0xdd22, 0xd804, 0xdd34, 0x3b, 0xd804, 0xdd25,
0xd804, 0xdd27, 0xd804, 0xdd1a, 0xd804, 0xdd28, 0xd804, 0xdd22, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd27, 0x3b, 0xd804, 0xdd1f, 0xd804, 0xdd27,
0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd2a, 0x3b, 0xd804, 0xdd1d, 0xd804, 0xdd33, 0xd804, 0xdd22, 0xd804, 0xdd28, 0x3b, 0xd804, 0xdd25, 0xd804, 0xdd2a, 0x3b,
0xd804, 0xdd25, 0xd804, 0xdd27, 0x43a, 0x4c0, 0x438, 0x440, 0x430, 0x3b, 0x43e, 0x440, 0x448, 0x43e, 0x442, 0x3b, 0x448, 0x438, 0x43d, 0x430,
0x440, 0x430, 0x3b, 0x43a, 0x445, 0x430, 0x430, 0x440, 0x430, 0x3b, 0x435, 0x430, 0x440, 0x430, 0x3b, 0x43f, 0x4c0, 0x435, 0x440, 0x430,
0x441, 0x43a, 0x430, 0x3b, 0x448, 0x443, 0x43e, 0x442, 0x43a, 0x4c0, 0x438, 0x3b, 0x43e, 0x440, 0x3b, 0x448, 0x438, 0x3b, 0x43a, 0x445,
0x430, 0x3b, 0x435, 0x430, 0x3b, 0x43f, 0x4c0, 0x435, 0x3b, 0x448, 0x443, 0x43e, 0x43a, 0x4c0, 0x3b, 0x43e, 0x3b, 0x448, 0x3b, 0x43a,
0x445, 0x3b, 0x435, 0x3b, 0x43f, 0x4c0, 0x3b, 0x448, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3,
0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e6, 0x13a2, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x13a2,
0x13a6, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x13b6, 0x13cd, 0x13d7, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c8, 0x13d5, 0x13be, 0x13c6, 0x13cd, 0x13ac, 0x3b,
0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x3b, 0x13e6, 0x13a2, 0x13c1, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x3b,
0x13c8, 0x13d5, 0x13be, 0x13c6, 0x3b, 0x13c9, 0x3b, 0x13d4, 0x3b, 0x13e6, 0x3b, 0x13c5, 0x3b, 0x13e7, 0x3b, 0x13a4, 0x53, 0x61, 0x6e, 0x64,
0x65, 0x3b, 0x4f, 0x72, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61,
0x62, 0x69, 0x72, 0x69, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x72, 0x77,
0x61, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4f, 0x72,
0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x53, 0x41, 0x4e, 0x3b, 0x4f, 0x52, 0x4b, 0x3b, 0x4f, 0x4b, 0x42,
0x3b, 0x4f, 0x4b, 0x53, 0x3b, 0x4f, 0x4b, 0x4e, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4f, 0x4d, 0x4b, 0x53, 0x3b, 0x4b, 0x3b,
0x52, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4d, 0x9031, 0x65e5, 0x3b, 0x9031, 0x4e00, 0x3b, 0x9031, 0x4e8c, 0x3b, 0x9031, 0x4e09,
0x3b, 0x9031, 0x56db, 0x3b, 0x9031, 0x4e94, 0x3b, 0x9031, 0x516d, 0x53, 0x75, 0x6e, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d,
0x6f, 0x68, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x44, 0x69, 0x6e, 0x6e, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b,
0x4d, 0x65, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68,
0x3b, 0x46, 0x72, 0x69, 0x69, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68,
0x53, 0x75, 0x2e, 0x3b, 0x4d, 0x6f, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x65, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b,
0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x53,
0x64, 0x79, 0x20, 0x53, 0x75, 0x6c, 0x3b, 0x64, 0x79, 0x20, 0x4c, 0x75, 0x6e, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x75,
0x72, 0x74, 0x68, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x72, 0x68, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x59, 0x6f, 0x77,
0x3b, 0x64, 0x79, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e,
0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x74, 0x68, 0x3b, 0x4d, 0x68, 0x72, 0x3b, 0x59, 0x6f, 0x77, 0x3b,
0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x6e, 0x65, 0x64, 0x11b, 0x6c, 0x65, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x11b, 0x6c,
0xed, 0x3b, 0xfa, 0x74, 0x65, 0x72, 0xfd, 0x3b, 0x73, 0x74, 0x159, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x74, 0x76, 0x72, 0x74,
0x65, 0x6b, 0x3b, 0x70, 0xe1, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x6e, 0x65, 0x3b, 0x70, 0x6f,
0x3b, 0xfa, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x10d, 0x74, 0x3b, 0x70, 0xe1, 0x3b, 0x73, 0x6f, 0x4e, 0x3b, 0x50, 0x3b, 0xda,
0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61, 0x6e, 0x64, 0x61,
0x67, 0x3b, 0x74, 0x69, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72,
0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf8, 0x72, 0x64, 0x61, 0x67, 0x73, 0xf8,
0x6e, 0x3b, 0x6d, 0x61, 0x6e, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72,
0x65, 0x3b, 0x6c, 0xf8, 0x72, 0x73, 0xf8, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x6e, 0x2e, 0x3b, 0x74, 0x69, 0x72, 0x2e, 0x3b,
0x6f, 0x6e, 0x73, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x66, 0x72, 0x65, 0x2e, 0x3b, 0x6c, 0xf8, 0x72, 0x2e, 0x53,
0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x4c, 0x910, 0x924, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x94b,
0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b,
0x92c, 0x940, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x92c,
0x93e, 0x930, 0x910, 0x924, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c,
0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x940, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915,
0x94d, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x940, 0x92c, 0x93e, 0x930, 0x910, 0x924, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e,
0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x92c, 0x940, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928,
0x93f, 0x910, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x2e, 0x3b, 0x92c, 0x941, 0x2e, 0x3b, 0x92c, 0x940, 0x2e, 0x3b, 0x936, 0x941, 0x2e,
0x3b, 0x936, 0x2e, 0x910, 0x2e, 0x3b, 0x938, 0x94b, 0x2e, 0x3b, 0x92e, 0x2e, 0x3b, 0x92c, 0x941, 0x2e, 0x3b, 0x92c, 0x940, 0x2e,
0x3b, 0x936, 0x941, 0x2e, 0x3b, 0x936, 0x2e, 0xe9, 0x74, 0x69, 0x3b, 0x6d, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x6b, 0x77, 0x61,
0x73, 0xfa, 0x3b, 0x6d, 0x75, 0x6b, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x14b, 0x67, 0x69, 0x73, 0xfa, 0x3b, 0x257, 0xf3, 0x6e,
0x25b, 0x73, 0xfa, 0x3b, 0x65, 0x73, 0x61, 0x253, 0x61, 0x73, 0xfa, 0xe9, 0x74, 0x3b, 0x6d, 0x254, 0x301, 0x73, 0x3b, 0x6b,
0x77, 0x61, 0x3b, 0x6d, 0x75, 0x6b, 0x3b, 0x14b, 0x67, 0x69, 0x3b, 0x257, 0xf3, 0x6e, 0x3b, 0x65, 0x73, 0x61, 0x65, 0x3b,
0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x14b, 0x3b, 0x257, 0x3b, 0x65, 0x7a, 0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61,
0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x77, 0x6f, 0x65, 0x6e, 0x73, 0x64,
0x61, 0x67, 0x3b, 0x64, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x76, 0x72, 0x69, 0x6a, 0x64, 0x61, 0x67,
0x3b, 0x7a, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x7a, 0x6f, 0x3b, 0x6d, 0x61, 0x3b, 0x64, 0x69, 0x3b, 0x77, 0x6f,
0x3b, 0x64, 0x6f, 0x3b, 0x76, 0x72, 0x3b, 0x7a, 0x61, 0x5a, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56,
0x3b, 0x5a, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b,
0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b,
0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42,
0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b,
0xf5f, 0xfb3, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0x3b, 0xf66,
0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0x3b, 0xf49, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf62, 0x3b,
0xf63, 0xfb7, 0xf42, 0x3b, 0xf55, 0xf74, 0xf62, 0x3b, 0xf66, 0xf44, 0xfb6, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0x3b, 0xf49, 0xf72, 0x4b,
0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4e, 0x6a, 0x75, 0x6d,
0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69,
0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x74, 0x68,
0x69, 0x69, 0x4b, 0x6d, 0x61, 0x3b, 0x54, 0x61, 0x74, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x54, 0x61, 0x6e, 0x3b, 0x41, 0x72,
0x6d, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4e, 0x4d, 0x4d, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4d,
0x3b, 0x4e, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0x2e, 0x3b, 0x54, 0x75, 0x2e, 0x3b, 0x57, 0x2e, 0x3b, 0x54, 0x68, 0x2e, 0x3b,
0x46, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x53, 0x75, 0x6e, 0x2e, 0x3b, 0x4d, 0x6f, 0x6e, 0x2e, 0x3b, 0x54, 0x75, 0x65, 0x2e,
0x3b, 0x57, 0x65, 0x64, 0x2e, 0x3b, 0x54, 0x68, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x69, 0x2e, 0x3b, 0x53, 0x61, 0x74, 0x2e,
0x64, 0x69, 0x6d, 0x61, 0x6e, 0x109, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x6f, 0x3b,
0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64, 0x6f, 0x3b, 0x135, 0x61, 0x16d, 0x64, 0x6f, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72,
0x65, 0x64, 0x6f, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x64, 0x69, 0x3b, 0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x6d,
0x65, 0x3b, 0x135, 0x61, 0x3b, 0x76, 0x65, 0x3b, 0x73, 0x61, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x134, 0x3b,
0x56, 0x3b, 0x53, 0x70, 0xfc, 0x68, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x65, 0x73, 0x6d, 0x61, 0x73, 0x70, 0xe4, 0x65,
0x76, 0x3b, 0x74, 0x65, 0x69, 0x73, 0x69, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6b, 0x6f, 0x6c, 0x6d, 0x61, 0x70, 0xe4, 0x65,
0x76, 0x3b, 0x6e, 0x65, 0x6c, 0x6a, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x72, 0x65, 0x65, 0x64, 0x65, 0x3b, 0x6c, 0x61,
0x75, 0x70, 0xe4, 0x65, 0x76, 0x50, 0x3b, 0x45, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x52, 0x3b, 0x4c, 0x6b, 0x254,
0x73, 0x69, 0x256, 0x61, 0x3b, 0x64, 0x7a, 0x6f, 0x256, 0x61, 0x3b, 0x62, 0x6c, 0x61, 0x256, 0x61, 0x3b, 0x6b, 0x75, 0x256,
0x61, 0x3b, 0x79, 0x61, 0x77, 0x6f, 0x256, 0x61, 0x3b, 0x66, 0x69, 0x256, 0x61, 0x3b, 0x6d, 0x65, 0x6d, 0x6c, 0x65, 0x256,
0x61, 0x6b, 0x254, 0x73, 0x3b, 0x64, 0x7a, 0x6f, 0x3b, 0x62, 0x6c, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x3b, 0x79, 0x61, 0x77,
0x3b, 0x66, 0x69, 0x256, 0x3b, 0x6d, 0x65, 0x6d, 0x6b, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x6b, 0x3b, 0x79, 0x3b, 0x66, 0x3b,
0x6d, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64,
0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x62, 0x25b, 0x30c, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254,
0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x6c, 0x25b, 0x301, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20,
0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x6e, 0x79, 0x69, 0x3b, 0x66, 0xfa, 0x6c, 0x61, 0x64, 0xe9, 0x3b, 0x73,
0xe9, 0x72, 0x61, 0x64, 0xe9, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73,
0x6d, 0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b, 0x66, 0xfa, 0x6c, 0x3b, 0x73, 0xe9, 0x72, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b,
0x73, 0x3b, 0x73, 0x3b, 0x66, 0x3b, 0x73, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0xe1,
0x6e, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x74, 0xfd, 0x73, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0x69, 0x6b,
0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x68, 0xf3, 0x73, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0x72, 0xed, 0x67,
0x67, 0x6a, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6c, 0x65, 0x79, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72,
0x73, 0x75, 0x6e, 0x3b, 0x6d, 0xe1, 0x6e, 0x3b, 0x74, 0xfd, 0x73, 0x3b, 0x6d, 0x69, 0x6b, 0x3b, 0x68, 0xf3, 0x73, 0x3b,
0x66, 0x72, 0xed, 0x3b, 0x6c, 0x65, 0x79, 0x73, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0xe1, 0x6e, 0x2e, 0x3b, 0x74, 0xfd, 0x73,
0x2e, 0x3b, 0x6d, 0x69, 0x6b, 0x2e, 0x3b, 0x68, 0xf3, 0x73, 0x2e, 0x3b, 0x66, 0x72, 0xed, 0x2e, 0x3b, 0x6c, 0x65, 0x79,
0x2e, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x46, 0x3b, 0x4c, 0x4c, 0x69, 0x6e, 0x67, 0x67, 0x6f,
0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0x79, 0x65, 0x72, 0x6b,
0x75, 0x6c, 0x65, 0x73, 0x3b, 0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73, 0x3b, 0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65,
0x73, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x64, 0x6f, 0x4c, 0x69, 0x6e, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x4d, 0x69, 0x79, 0x3b, 0x48, 0x75, 0x77, 0x3b, 0x42, 0x69, 0x79, 0x3b, 0x53, 0x61, 0x62, 0x73, 0x75, 0x6e, 0x6e, 0x75,
0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x74,
0x61, 0x69, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74,
0x61, 0x69, 0x3b, 0x70, 0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61,
0x69, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74,
0x61, 0x69, 0x6e, 0x61, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69,
0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f, 0x6e, 0x61, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x70,
0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e,
0x61, 0x73, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x74, 0x69, 0x3b, 0x6b, 0x65, 0x3b, 0x74, 0x6f, 0x3b, 0x70, 0x65, 0x3b, 0x6c,
0x61, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x4c, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x63,
0x68, 0x65, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x72,
0x65, 0x64, 0x69, 0x3b, 0x6a, 0x65, 0x75, 0x64, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x73,
0x61, 0x6d, 0x65, 0x64, 0x69, 0x64, 0x69, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b,
0x6d, 0x65, 0x72, 0x2e, 0x3b, 0x6a, 0x65, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x6d, 0x2e, 0x44,
0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x65, 0x3b,
0x6c, 0x75, 0x6e, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x61, 0x72, 0x73, 0x3b, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x75,
0x73, 0x3b, 0x6a, 0x6f, 0x69, 0x62, 0x65, 0x3b, 0x76, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x69, 0x64,
0x65, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0x65, 0x3b, 0x6a, 0x6f, 0x69,
0x3b, 0x76, 0x69, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x64, 0x65, 0x77, 0x6f, 0x3b, 0x61, 0x61, 0x253, 0x6e, 0x64, 0x65, 0x3b,
0x6d, 0x61, 0x77, 0x62, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e, 0x6a, 0x65, 0x73, 0x6c, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e,
0x61, 0x61, 0x73, 0x61, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x6d, 0x61, 0x77, 0x6e, 0x64, 0x65, 0x3b, 0x68, 0x6f, 0x6f, 0x72,
0x65, 0x2d, 0x62, 0x69, 0x69, 0x72, 0x64, 0x65, 0x77, 0x3b, 0x61, 0x61, 0x253, 0x3b, 0x6d, 0x61, 0x77, 0x3b, 0x6e, 0x6a,
0x65, 0x3b, 0x6e, 0x61, 0x61, 0x3b, 0x6d, 0x77, 0x64, 0x3b, 0x68, 0x62, 0x69, 0x64, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6e,
0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x68, 0xd83a, 0xdd08, 0xd83a, 0xdd2b, 0xd83a, 0xdd2c, 0xd83a, 0xdd26, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a, 0xd83a, 0xdd46,
0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd00, 0xd83a, 0xdd44, 0xd83a, 0xdd29, 0xd83a, 0xdd35, 0xd83a, 0xdd32, 0xd83a, 0xdd4b, 0xd83a, 0xdd23, 0xd83a, 0xdd2b, 0x3b,
0xd83a, 0xdd03, 0xd83a, 0xdd22, 0xd83a, 0xdd31, 0xd83a, 0xdd26, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd2a, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd10, 0xd83a,
0xdd36, 0xd83a, 0xdd2b, 0xd83a, 0xdd27, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd2a, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd10, 0xd83a, 0xdd22,
0xd83a, 0xdd44, 0xd83a, 0xdd27, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd32, 0xd83a, 0xdd23, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd03, 0xd83a, 0xdd22, 0xd83a,
0xdd31, 0xd83a, 0xdd32, 0xd83a, 0xdd23, 0xd83a, 0xdd2b, 0x3b, 0xd83a, 0xdd16, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd26, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a,
0xd83a, 0xdd46, 0xd83a, 0xdd2b, 0xd83a, 0xdd08, 0xd83a, 0xdd2b, 0xd83a, 0xdd2c, 0x3b, 0xd83a, 0xdd00, 0xd83a, 0xdd44, 0xd83a, 0xdd29, 0xd83a, 0xdd35, 0x3b,
0xd83a, 0xdd03, 0xd83a, 0xdd22, 0xd83a, 0xdd26, 0x3b, 0xd83a, 0xdd14, 0xd83a, 0xdd2b, 0xd83a, 0xdd27, 0x3b, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd44,
0xd83a, 0xdd27, 0x3b, 0xd83a, 0xdd03, 0xd83a, 0xdd22, 0xd83a, 0xdd23, 0x3b, 0xd83a, 0xdd16, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd08, 0x3b, 0xd83a,
0xdd00, 0xd83a, 0xdd44, 0x3b, 0xd83a, 0xdd03, 0x3b, 0xd83a, 0xdd14, 0x3b, 0xd83a, 0xdd10, 0x3b, 0xd83a, 0xdd03, 0x3b, 0xd83a, 0xdd16, 0x44, 0x69,
0x44, 0xf2, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x3b, 0x44, 0x69, 0x4c, 0x75, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0x69,
0x4d, 0xe0, 0x69, 0x72, 0x74, 0x3b, 0x44, 0x69, 0x43, 0x69, 0x61, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x61, 0x72,
0x44, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x44, 0x69, 0x53, 0x61, 0x74,
0x68, 0x61, 0x69, 0x72, 0x6e, 0x65, 0x44, 0x69, 0x44, 0x3b, 0x44, 0x69, 0x4c, 0x3b, 0x44, 0x69, 0x4d, 0x3b, 0x44, 0x69,
0x43, 0x3b, 0x44, 0x69, 0x61, 0x3b, 0x44, 0x69, 0x68, 0x3b, 0x44, 0x69, 0x53, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x43,
0x3b, 0x41, 0x3b, 0x48, 0x3b, 0x53, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d,
0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0xe9, 0x72, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x3b, 0x58, 0x6f, 0x76, 0x65, 0x73,
0x3b, 0x56, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67,
0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d, 0xe9, 0x72, 0x63, 0x6f, 0x72,
0x65, 0x73, 0x3b, 0x78, 0x6f, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61,
0x64, 0x6f, 0x44, 0x6f, 0x6d, 0x2e, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x4d, 0xe9, 0x72,
0x2e, 0x3b, 0x58, 0x6f, 0x76, 0x2e, 0x3b, 0x56, 0x65, 0x6e, 0x2e, 0x3b, 0x53, 0xe1, 0x62, 0x2e, 0x64, 0x6f, 0x6d, 0x2e,
0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0xe9, 0x72, 0x2e, 0x3b, 0x78, 0x6f, 0x76, 0x2e,
0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e, 0x64, 0x2e, 0x3b, 0x6c, 0x2e, 0x3b, 0x6d, 0x2e, 0x3b, 0x6d,
0x2e, 0x3b, 0x78, 0x2e, 0x3b, 0x76, 0x2e, 0x3b, 0x73, 0x2e, 0x53, 0x61, 0x62, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42,
0x61, 0x6c, 0x61, 0x7a, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4c, 0x77, 0x61, 0x6b,
0x75, 0x73, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x74,
0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4c, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x53, 0x61, 0x62, 0x3b, 0x42,
0x61, 0x6c, 0x3b, 0x4c, 0x77, 0x32, 0x3b, 0x4c, 0x77, 0x33, 0x3b, 0x4c, 0x77, 0x34, 0x3b, 0x4c, 0x77, 0x35, 0x3b, 0x4c,
0x77, 0x36, 0x53, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x10d9, 0x10d5, 0x10d8, 0x10e0, 0x10d0,
0x3b, 0x10dd, 0x10e0, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10e1, 0x10d0, 0x10db, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b,
0x10dd, 0x10d7, 0x10ee, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b,
0x10de, 0x10d0, 0x10e0, 0x10d0, 0x10e1, 0x10d9, 0x10d4, 0x10d5, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x10d9, 0x10d5, 0x10d8, 0x3b,
0x10dd, 0x10e0, 0x10e8, 0x3b, 0x10e1, 0x10d0, 0x10db, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x3b,
0x10e8, 0x10d0, 0x10d1, 0x10d9, 0x3b, 0x10dd, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10ee, 0x3b, 0x10de, 0x3b, 0x10e8, 0x53, 0x6f, 0x6e, 0x6e,
0x74, 0x61, 0x67, 0x3b, 0x4d, 0x6f, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x65, 0x6e, 0x73, 0x74, 0x61, 0x67, 0x3b,
0x4d, 0x69, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x74, 0x61, 0x67, 0x3b,
0x46, 0x72, 0x65, 0x69, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x74, 0x61, 0x67, 0x53, 0x6f, 0x3b, 0x4d, 0x6f,
0x3b, 0x44, 0x69, 0x3b, 0x4d, 0x69, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61, 0x53, 0x6f, 0x2e, 0x3b, 0x4d,
0x6f, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53,
0x61, 0x2e, 0x39a, 0x3c5, 0x3c1, 0x3b9, 0x3b1, 0x3ba, 0x3ae, 0x3b, 0x394, 0x3b5, 0x3c5, 0x3c4, 0x3ad, 0x3c1, 0x3b1, 0x3b, 0x3a4, 0x3c1,
0x3af, 0x3c4, 0x3b7, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3ac, 0x3c1, 0x3c4, 0x3b7, 0x3b, 0x3a0, 0x3ad, 0x3bc, 0x3c0, 0x3c4, 0x3b7, 0x3b, 0x3a0,
0x3b1, 0x3c1, 0x3b1, 0x3c3, 0x3ba, 0x3b5, 0x3c5, 0x3ae, 0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b2, 0x3b1, 0x3c4, 0x3bf, 0x39a, 0x3c5, 0x3c1, 0x3b,
0x394, 0x3b5, 0x3c5, 0x3b, 0x3a4, 0x3c1, 0x3af, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3b, 0x3a0, 0x3ad, 0x3bc, 0x3b, 0x3a0, 0x3b1, 0x3c1, 0x3b,
0x3a3, 0x3ac, 0x3b2, 0x39a, 0x3b, 0x394, 0x3b, 0x3a4, 0x3b, 0x3a4, 0x3b, 0x3a0, 0x3b, 0x3a0, 0x3b, 0x3a3, 0xab0, 0xab5, 0xabf, 0xab5,
0xabe, 0xab0, 0x3b, 0xab8, 0xacb, 0xaae, 0xab5, 0xabe, 0xab0, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0xab5, 0xabe, 0xab0, 0x3b, 0xaac, 0xac1,
0xaa7, 0xab5, 0xabe, 0xab0, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0xab5, 0xabe,
0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0xab5, 0xabe, 0xab0, 0xab0, 0xab5, 0xabf, 0x3b, 0xab8, 0xacb, 0xaae, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3,
0x3b, 0xaac, 0xac1, 0xaa7, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0xab0,
0x3b, 0xab8, 0xacb, 0x3b, 0xaae, 0xa82, 0x3b, 0xaac, 0xac1, 0x3b, 0xa97, 0xac1, 0x3b, 0xab6, 0xac1, 0x3b, 0xab6, 0x43, 0x68, 0x75,
0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x68, 0x75,
0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d,
0x69, 0x73, 0x69, 0x3b, 0x49, 0x63, 0x68, 0x75, 0x6d, 0x61, 0x3b, 0x45, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x43, 0x70,
0x72, 0x3b, 0x43, 0x74, 0x74, 0x3b, 0x43, 0x6d, 0x6e, 0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x41, 0x72, 0x73, 0x3b, 0x49, 0x63,
0x6d, 0x3b, 0x45, 0x73, 0x74, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x45, 0x4c, 0x61,
0x68, 0x61, 0x64, 0x69, 0x3b, 0x4c, 0x69, 0x74, 0x69, 0x6e, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b,
0x4c, 0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x6d, 0x61,
0x2bc, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x61, 0x72, 0x4c, 0x61, 0x68, 0x3b, 0x4c, 0x69, 0x74, 0x3b, 0x54, 0x61, 0x6c,
0x3b, 0x4c, 0x61, 0x72, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x4c, 0x3b, 0x4c, 0x3b,
0x54, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x41, 0x4c, 0x101, 0x70, 0x75, 0x6c, 0x65, 0x3b, 0x50, 0x6f, 0x2bb, 0x61,
0x6b, 0x61, 0x68, 0x69, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x75, 0x61, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6b, 0x6f, 0x6c,
0x75, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x68, 0x101, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x69, 0x6d, 0x61, 0x3b, 0x50, 0x6f,
0x2bb, 0x61, 0x6f, 0x6e, 0x6f, 0x4c, 0x50, 0x3b, 0x50, 0x31, 0x3b, 0x50, 0x32, 0x3b, 0x50, 0x33, 0x3b, 0x50, 0x34, 0x3b,
0x50, 0x35, 0x3b, 0x50, 0x36, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d0, 0x5e9, 0x5d5, 0x5df, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9,
0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5dc, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d1, 0x5d9,
0x5e2, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d7, 0x5de, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d9, 0x5e9,
0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d1, 0x5ea, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d0, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20,
0x5d1, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d2, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d3, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd,
0x20, 0x5d4, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5d1, 0x5ea, 0x5d0, 0x5f3, 0x3b, 0x5d1, 0x5f3, 0x3b,
0x5d2, 0x5f3, 0x3b, 0x5d3, 0x5f3, 0x3b, 0x5d4, 0x5f3, 0x3b, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5f3, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930,
0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935,
0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b,
0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c,
0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x930, 0x3b, 0x938,
0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x917, 0x941, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x76, 0x61, 0x73, 0xe1, 0x72,
0x6e, 0x61, 0x70, 0x3b, 0x68, 0xe9, 0x74, 0x66, 0x151, 0x3b, 0x6b, 0x65, 0x64, 0x64, 0x3b, 0x73, 0x7a, 0x65, 0x72, 0x64,
0x61, 0x3b, 0x63, 0x73, 0xfc, 0x74, 0xf6, 0x72, 0x74, 0xf6, 0x6b, 0x3b, 0x70, 0xe9, 0x6e, 0x74, 0x65, 0x6b, 0x3b, 0x73,
0x7a, 0x6f, 0x6d, 0x62, 0x61, 0x74, 0x56, 0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x65, 0x3b, 0x43, 0x73, 0x3b, 0x50,
0x3b, 0x53, 0x7a, 0x6f, 0x56, 0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x3b, 0x43, 0x73, 0x3b, 0x50, 0x3b, 0x53, 0x7a,
0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72,
0x3b, 0xfe, 0x72, 0x69, 0xf0, 0x6a, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0x69, 0xf0, 0x76, 0x69, 0x6b, 0x75,
0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0x69, 0x6d, 0x6d, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0xf6,
0x73, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6c, 0x61, 0x75, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72,
0x73, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0xe1, 0x6e, 0x2e, 0x3b, 0xfe, 0x72, 0x69, 0x2e, 0x3b, 0x6d, 0x69, 0xf0, 0x2e, 0x3b,
0x66, 0x69, 0x6d, 0x2e, 0x3b, 0x66, 0xf6, 0x73, 0x2e, 0x3b, 0x6c, 0x61, 0x75, 0x2e, 0x53, 0x3b, 0x4d, 0x3b, 0xde, 0x3b,
0x4d, 0x3b, 0x46, 0x3b, 0x46, 0x3b, 0x4c, 0x53, 0x1ecd, 0x6e, 0x64, 0x65, 0x65, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x64, 0x65, 0x3b,
0x54, 0x69, 0x75, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x57, 0x65, 0x6e, 0x65, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x54, 0x1ecd, 0x1ecd,
0x7a, 0x64, 0x65, 0x65, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x64, 0x65, 0x65, 0x3b, 0x53, 0x61, 0x74, 0x1ecd, 0x64, 0x65, 0x65,
0x53, 0x1ecd, 0x6e, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x3b, 0x54, 0x69, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x3b, 0x54, 0x1ecd, 0x1ecd, 0x3b,
0x46, 0x72, 0x61, 0x1ecb, 0x3b, 0x53, 0x61, 0x74, 0x70, 0x61, 0x73, 0x65, 0x70, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75,
0x6f, 0x73, 0x73, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d, 0x61, 0x6a, 0x65, 0x62, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f,
0x73, 0x6b, 0x6f, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x75, 0x6f, 0x72, 0xe2, 0x73, 0x74, 0xe2, 0x68, 0x3b, 0x76, 0xe1, 0x73,
0x74, 0x75, 0x70, 0x70, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x6c, 0xe1, 0x76, 0x75, 0x72, 0x64, 0xe2, 0x68, 0x70, 0x61, 0x73,
0x65, 0x70, 0x65, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d,
0x61, 0x6a, 0x65, 0x62, 0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f, 0x73, 0x6b, 0x6f, 0x68, 0x6f, 0x3b, 0x74, 0x75,
0x6f, 0x72, 0xe2, 0x73, 0x74, 0x75, 0x76, 0x3b, 0x76, 0xe1, 0x73, 0x74, 0x75, 0x70, 0x70, 0x65, 0x65, 0x69, 0x76, 0x69,
0x3b, 0x6c, 0xe1, 0x76, 0x75, 0x72, 0x64, 0x75, 0x76, 0x70, 0x61, 0x73, 0x3b, 0x76, 0x75, 0x6f, 0x3b, 0x6d, 0x61, 0x6a,
0x3b, 0x6b, 0x6f, 0x73, 0x3b, 0x74, 0x75, 0x6f, 0x3b, 0x76, 0xe1, 0x73, 0x3b, 0x6c, 0xe1, 0x76, 0x70, 0x3b, 0x56, 0x3b,
0x4d, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x56, 0x3b, 0x4c, 0x4d, 0x69, 0x6e, 0x67, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x6e, 0x69,
0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x73, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x4d, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53,
0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x4d, 0x3b,
0x53, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x3b,
0x6c, 0x75, 0x6e, 0x65, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x75,
0x72, 0x69, 0x64, 0x69, 0x3b, 0x6a, 0x6f, 0x76, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x65, 0x72, 0x64, 0x69, 0x3b,
0x73, 0x61, 0x62, 0x62, 0x61, 0x74, 0x6f, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d,
0x65, 0x72, 0x3b, 0x6a, 0x6f, 0x76, 0x3b, 0x76, 0x65, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b,
0x6d, 0x3b, 0x6a, 0x3b, 0x76, 0x3b, 0x73, 0x44, 0xe9, 0x20, 0x44, 0x6f, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x67, 0x68, 0x3b,
0x44, 0xe9, 0x20, 0x4c, 0x75, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x20, 0x4d, 0xe1, 0x69, 0x72, 0x74, 0x3b, 0x44, 0xe9,
0x20, 0x43, 0xe9, 0x61, 0x64, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x64, 0x61, 0x6f, 0x69, 0x6e, 0x3b,
0x44, 0xe9, 0x20, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x44, 0xe9, 0x20, 0x53, 0x61, 0x74, 0x68, 0x61, 0x69, 0x72,
0x6e, 0x44, 0x6f, 0x6d, 0x68, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x3b, 0x4d, 0xe1, 0x69, 0x72, 0x74, 0x3b, 0x43, 0xe9, 0x61,
0x64, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x3b, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x53, 0x61, 0x74, 0x68, 0x44, 0x3b, 0x4c,
0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x44, 0x3b, 0x41, 0x3b, 0x53, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c,
0x75, 0x6e, 0x65, 0x64, 0xec, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x64, 0xec, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x6f, 0x6c,
0x65, 0x64, 0xec, 0x3b, 0x67, 0x69, 0x6f, 0x76, 0x65, 0x64, 0xec, 0x3b, 0x76, 0x65, 0x6e, 0x65, 0x72, 0x64, 0xec, 0x3b,
0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65,
0x72, 0x3b, 0x67, 0x69, 0x6f, 0x3b, 0x76, 0x65, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d,
0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x65e5, 0x66dc, 0x65e5, 0x3b, 0x6708, 0x66dc, 0x65e5, 0x3b, 0x706b, 0x66dc, 0x65e5, 0x3b, 0x6c34, 0x66dc,
0x65e5, 0x3b, 0x6728, 0x66dc, 0x65e5, 0x3b, 0x91d1, 0x66dc, 0x65e5, 0x3b, 0x571f, 0x66dc, 0x65e5, 0x65e5, 0x3b, 0x6708, 0x3b, 0x706b, 0x3b, 0x6c34,
0x3b, 0x6728, 0x3b, 0x91d1, 0x3b, 0x571f, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x65, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c,
0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74,
0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52,
0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x41, 0x3b, 0x53, 0x3b, 0x53, 0x3b,
0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x44, 0x69, 0x6d, 0x61, 0x73, 0x3b, 0x54, 0x65, 0x6e, 0x65, 0x14b, 0x3b, 0x54,
0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x73,
0x61, 0x79, 0x3b, 0x41, 0x72, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x74, 0x69, 0x44, 0x69, 0x6d, 0x3b,
0x54, 0x65, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x41, 0x72, 0x6a, 0x3b,
0x53, 0x69, 0x62, 0x44, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x53, 0x64, 0x75, 0x6d, 0x69,
0x6e, 0x67, 0x75, 0x3b, 0x73, 0x69, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72,
0x73, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b,
0x6b, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72,
0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x75, 0x64, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x67, 0x3b, 0x74, 0x65, 0x72, 0x3b,
0x6b, 0x75, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x3b, 0x73, 0x65, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x44, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x41, 0x63, 0x65, 0x72, 0x3b, 0x41, 0x72, 0x69, 0x6d, 0x3b, 0x41, 0x72,
0x61, 0x6d, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x41, 0x6d, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x65, 0x6d, 0x3b, 0x53, 0x65,
0x64, 0x59, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x61,
0x73, 0x73, 0x3b, 0x4b, 0x75, 0x1e93, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x1e0d, 0x69,
0x73, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x61, 0x73, 0x73, 0x41, 0x63, 0x65, 0x3b, 0x41, 0x72, 0x69, 0x3b, 0x41,
0x72, 0x61, 0x3b, 0x41, 0x68, 0x61, 0x3b, 0x41, 0x6d, 0x68, 0x3b, 0x53, 0x65, 0x6d, 0x3b, 0x53, 0x65, 0x64, 0x59, 0x61,
0x6e, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x3b, 0x4b, 0x75, 0x1e93, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53,
0x1e0d, 0x69, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x59, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53,
0x43, 0x3b, 0x52, 0x3b, 0x41, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x44, 0x73, 0x254, 0x6e, 0x64, 0x69, 0x3b, 0x6c,
0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x25b, 0x72, 0x6b, 0x25b, 0x72, 0x25b, 0x64, 0x69,
0x3b, 0x79, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x14b, 0x64, 0x25b, 0x72, 0x25b, 0x64, 0x69, 0x3b, 0x6d, 0x254, 0x6e, 0x254,
0x20, 0x73, 0x254, 0x6e, 0x64, 0x69, 0x73, 0x6f, 0x3b, 0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x25b, 0x3b, 0x79, 0x65,
0x3b, 0x76, 0x61, 0x3b, 0x6d, 0x73, 0x73, 0x61, 0x70, 0x61, 0x61, 0x74, 0x3b, 0x61, 0x74, 0x61, 0x61, 0x73, 0x69, 0x6e,
0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x6d, 0x61, 0x72, 0x6c, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65,
0x71, 0x3b, 0x70, 0x69, 0x6e, 0x67, 0x61, 0x73, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x73, 0x69,
0x73, 0x61, 0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x74, 0x61, 0x6c, 0x6c, 0x69, 0x6d, 0x61,
0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x61, 0x72, 0x66, 0x69, 0x6e, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72,
0x6e, 0x65, 0x71, 0x73, 0x61, 0x70, 0x3b, 0x61, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x70, 0x69, 0x6e, 0x3b, 0x73,
0x69, 0x73, 0x3b, 0x74, 0x61, 0x6c, 0x3b, 0x61, 0x72, 0x66, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x53, 0x3b,
0x54, 0x3b, 0x41, 0x4b, 0x6f, 0x74, 0x69, 0x73, 0x61, 0x70, 0x3b, 0x4b, 0x6f, 0x74, 0x61, 0x61, 0x69, 0x3b, 0x4b, 0x6f,
0x61, 0x65, 0x6e, 0x67, 0x2019, 0x3b, 0x4b, 0x6f, 0x73, 0x6f, 0x6d, 0x6f, 0x6b, 0x3b, 0x4b, 0x6f, 0x61, 0x6e, 0x67, 0x2019,
0x77, 0x61, 0x6e, 0x3b, 0x4b, 0x6f, 0x6d, 0x75, 0x75, 0x74, 0x3b, 0x4b, 0x6f, 0x6c, 0x6f, 0x4b, 0x74, 0x73, 0x3b, 0x4b,
0x6f, 0x74, 0x3b, 0x4b, 0x6f, 0x6f, 0x3b, 0x4b, 0x6f, 0x73, 0x3b, 0x4b, 0x6f, 0x61, 0x3b, 0x4b, 0x6f, 0x6d, 0x3b, 0x4b,
0x6f, 0x6c, 0x54, 0x3b, 0x54, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4c, 0x57, 0x61, 0x20, 0x6b, 0x79,
0x75, 0x6d, 0x77, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6d, 0x62, 0x129, 0x6c, 0x129, 0x6c, 0x79, 0x61, 0x3b,
0x57, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x57, 0x61,
0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x57, 0x61, 0x20, 0x74,
0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169, 0x57, 0x6b, 0x79, 0x3b, 0x57, 0x6b, 0x77, 0x3b, 0x57, 0x6b, 0x6c, 0x3b,
0x57, 0x74, 0x169, 0x3b, 0x57, 0x6b, 0x6e, 0x3b, 0x57, 0x74, 0x6e, 0x3b, 0x57, 0x74, 0x68, 0x59, 0x3b, 0x57, 0x3b, 0x45,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0xcad, 0xcbe, 0xca8, 0xcc1, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb8, 0xccb, 0xcae, 0xcb5,
0xcbe, 0xcb0, 0x3b, 0xcae, 0xc82, 0xc97, 0xcb3, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcac, 0xcc1, 0xca7, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xc97, 0xcc1,
0xcb0, 0xcc1, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb6, 0xca8, 0xcbf, 0xcb5, 0xcbe,
0xcb0, 0xcad, 0xcbe, 0xca8, 0xcc1, 0x3b, 0xcb8, 0xccb, 0xcae, 0x3b, 0xcae, 0xc82, 0xc97, 0xcb3, 0x3b, 0xcac, 0xcc1, 0xca7, 0x3b, 0xc97,
0xcc1, 0xcb0, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0x3b, 0xcb6, 0xca8, 0xcbf, 0xcad, 0xcbe, 0x3b, 0xcb8, 0xccb, 0x3b, 0xcae,
0xc82, 0x3b, 0xcac, 0xcc1, 0x3b, 0xc97, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0x3b, 0xcb6, 0x627, 0x64e, 0x62a, 0x6be, 0x648, 0x627, 0x631, 0x3b,
0x698, 0x654, 0x646, 0x62f, 0x631, 0x655, 0x631, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x6c6, 0x645, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648,
0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x631, 0x620, 0x633, 0x648, 0x627, 0x631, 0x3b, 0x62c, 0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679,
0x648, 0x627, 0x631, 0x622, 0x62a, 0x6be, 0x648, 0x627, 0x631, 0x3b, 0x698, 0x654, 0x646, 0x62f, 0x655, 0x631, 0x648, 0x627, 0x631, 0x3b,
0x628, 0x6c6, 0x645, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x631, 0x620, 0x633, 0x648, 0x627,
0x631, 0x3b, 0x62c, 0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679, 0x648, 0x627, 0x631, 0x627, 0x3b, 0x698, 0x3b, 0x628, 0x3b, 0x628, 0x3b,
0x628, 0x3b, 0x62c, 0x3b, 0x628, 0x436, 0x435, 0x43a, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x434, 0x4af, 0x439, 0x441, 0x435, 0x43d,
0x431, 0x456, 0x3b, 0x441, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441, 0x4d9, 0x440, 0x441, 0x435, 0x43d, 0x431, 0x456,
0x3b, 0x431, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x436, 0x4b1, 0x43c, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x431, 0x456,
0x436, 0x441, 0x3b, 0x434, 0x441, 0x3b, 0x441, 0x441, 0x3b, 0x441, 0x440, 0x3b, 0x431, 0x441, 0x3b, 0x436, 0x43c, 0x3b, 0x441, 0x431,
0x416, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x421, 0x3b, 0x411, 0x3b, 0x416, 0x3b, 0x421, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799,
0x3b, 0x1785, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784, 0x17d2, 0x1782, 0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a,
0x17a0, 0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd, 0x3b, 0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17c5, 0x179a, 0x17cd, 0x17a2, 0x17b6,
0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x17d0, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784, 0x17d2, 0x1782, 0x17b6, 0x179a, 0x3b, 0x1796,
0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd, 0x3b, 0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b,
0x179f, 0x17c5, 0x179a, 0x17cd, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784, 0x17d2,
0x1782, 0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x3b, 0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b, 0x179f,
0x17c5, 0x179a, 0x17cd, 0x17a2, 0x3b, 0x1785, 0x3b, 0x17a2, 0x3b, 0x1796, 0x3b, 0x1796, 0x3b, 0x179f, 0x3b, 0x179f, 0x4b, 0x69, 0x75, 0x6d,
0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x69, 0x6e,
0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x61, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x74, 0x68, 0x69,
0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x74, 0x68, 0x69, 0x4b, 0x4d,
0x41, 0x3b, 0x4e, 0x54, 0x54, 0x3b, 0x4e, 0x4d, 0x4e, 0x3b, 0x4e, 0x4d, 0x54, 0x3b, 0x41, 0x52, 0x54, 0x3b, 0x4e, 0x4d,
0x41, 0x3b, 0x4e, 0x4d, 0x4d, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4e, 0x3b, 0x4e, 0x4b, 0x75,
0x20, 0x63, 0x79, 0x75, 0x6d, 0x77, 0x65, 0x72, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65,
0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20,
0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74,
0x75, 0x63, 0x79, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e,
0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x906, 0x92f, 0x924, 0x93e, 0x930,
0x3b, 0x938, 0x94b, 0x92e, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930,
0x3b, 0x92c, 0x93f, 0x930, 0x947, 0x938, 0x94d, 0x924, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x93e, 0x930, 0x3b, 0x936,
0x947, 0x928, 0x935, 0x93e, 0x930, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x92c, 0x3b, 0x936, 0x941,
0x3b, 0x936, 0x947, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x92c, 0x93f, 0x3b, 0x936, 0x941, 0x3b,
0x936, 0x947, 0xc77c, 0xc694, 0xc77c, 0x3b, 0xc6d4, 0xc694, 0xc77c, 0x3b, 0xd654, 0xc694, 0xc77c, 0x3b, 0xc218, 0xc694, 0xc77c, 0x3b, 0xbaa9, 0xc694,
0xc77c, 0x3b, 0xae08, 0xc694, 0xc77c, 0x3b, 0xd1a0, 0xc694, 0xc77c, 0xc77c, 0x3b, 0xc6d4, 0x3b, 0xd654, 0x3b, 0xc218, 0x3b, 0xbaa9, 0x3b, 0xae08,
0x3b, 0xd1a0, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c,
0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73,
0x61, 0x3b, 0x41, 0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x41, 0x6c, 0x68, 0x3b, 0x41,
0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x7a, 0x3b, 0x41,
0x73, 0x69, 0x48, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x53, 0x41, 0x6c, 0x68, 0x61, 0x64,
0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72,
0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x41, 0x6c, 0x6a, 0x75, 0x6d, 0x61, 0x3b,
0x41, 0x73, 0x73, 0x61, 0x62, 0x64, 0x75, 0x41, 0x6c, 0x68, 0x3b, 0x41, 0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41,
0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x6a, 0x3b, 0x41, 0x73, 0x73, 0x79, 0x65, 0x6b, 0x15f, 0x65, 0x6d,
0x3b, 0x64, 0x75, 0x15f, 0x65, 0x6d, 0x3b, 0x73, 0xea, 0x15f, 0x65, 0x6d, 0x3b, 0xe7, 0x61, 0x72, 0x15f, 0x65, 0x6d, 0x3b,
0x70, 0xea, 0x6e, 0x63, 0x15f, 0x65, 0x6d, 0x3b, 0xee, 0x6e, 0x3b, 0x15f, 0x65, 0x6d, 0xee, 0x79, 0x15f, 0x3b, 0x64, 0x15f,
0x3b, 0x73, 0x15f, 0x3b, 0xe7, 0x15f, 0x3b, 0x70, 0x15f, 0x3b, 0xee, 0x6e, 0x3b, 0x15f, 0x59, 0x3b, 0x44, 0x3b, 0x53, 0x3b,
0xc7, 0x3b, 0x50, 0x3b, 0xce, 0x3b, 0x15e, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64, 0x254,
0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x62, 0x61, 0x3b, 0x73, 0x254,
0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6c, 0x61, 0x6c, 0x3b, 0x73, 0x254, 0x301, 0x6e,
0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x62, 0xe1, 0x67, 0xe1, 0x20,
0x6d, 0xe1, 0x20, 0x73, 0x75, 0x6b, 0x75, 0x6c, 0x3b, 0x73, 0xe1, 0x73, 0x61, 0x64, 0x69, 0x73, 0x254, 0x301, 0x6e, 0x3b,
0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b, 0x6d, 0x62, 0x73,
0x3b, 0x73, 0x61, 0x73, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x436, 0x435, 0x43a,
0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x434, 0x4af, 0x439, 0x448, 0x4e9, 0x43c, 0x431, 0x4af, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x435,
0x43c, 0x431, 0x438, 0x3b, 0x448, 0x430, 0x440, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x431, 0x435, 0x439, 0x448, 0x435, 0x43c, 0x431,
0x438, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x438, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x436, 0x435, 0x43a, 0x2e, 0x3b, 0x434, 0x4af,
0x439, 0x2e, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x2e, 0x3b, 0x448, 0x430, 0x440, 0x448, 0x2e, 0x3b, 0x431, 0x435, 0x439, 0x448, 0x2e,
0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x438, 0x448, 0x43c, 0x2e, 0x416, 0x3b, 0x414, 0x3b, 0x428, 0x3b, 0x428, 0x3b, 0x411, 0x3b,
0x416, 0x3b, 0x418, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x77, 0x61, 0x6b, 0x21f, 0x61, 0x14b, 0x3b, 0x41, 0x14b, 0x70, 0xe9,
0x74, 0x75, 0x77, 0x61, 0x14b, 0x17e, 0x69, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x6e, 0x75, 0x14b, 0x70, 0x61, 0x3b,
0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x79, 0x61, 0x6d, 0x6e, 0x69, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x74, 0x6f,
0x70, 0x61, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x7a, 0x61, 0x70, 0x74, 0x61, 0x14b, 0x3b, 0x4f, 0x77, 0xe1, 0x14b,
0x67, 0x79, 0x75, 0x17e, 0x61, 0x17e, 0x61, 0x70, 0x69, 0x41, 0x3b, 0x57, 0x3b, 0x4e, 0x3b, 0x59, 0x3b, 0x54, 0x3b, 0x5a,
0x3b, 0x4f, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0xed, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41,
0x6c, 0x61, 0x6d, 0xed, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d,
0xf3, 0x6f, 0x73, 0x69, 0x50, 0xed, 0x69, 0x6c, 0x69, 0x3b, 0x54, 0xe1, 0x61, 0x74, 0x75, 0x3b, 0xcd, 0x6e, 0x65, 0x3b,
0x54, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4d, 0xf3, 0x6f, 0x73, 0x69, 0x50,
0x3b, 0x54, 0x3b, 0x45, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4d, 0xea7, 0xeb1, 0xe99, 0xead, 0xeb2, 0xe97, 0xeb4, 0xe94,
0x3b, 0xea7, 0xeb1, 0xe99, 0xe88, 0xeb1, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead, 0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99, 0x3b, 0xea7, 0xeb1,
0xe99, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb0, 0xeab, 0xeb1, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xeaa, 0xeb8, 0xe81,
0x3b, 0xea7, 0xeb1, 0xe99, 0xec0, 0xeaa, 0xebb, 0xeb2, 0xead, 0xeb2, 0xe97, 0xeb4, 0xe94, 0x3b, 0xe88, 0xeb1, 0xe99, 0x3b, 0xead, 0xeb1,
0xe87, 0xe84, 0xeb2, 0xe99, 0x3b, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xe9e, 0xeb0, 0xeab, 0xeb1, 0xe94, 0x3b, 0xeaa, 0xeb8, 0xe81, 0x3b, 0xec0,
0xeaa, 0xebb, 0xeb2, 0xead, 0xeb2, 0x3b, 0xe88, 0x3b, 0xead, 0x3b, 0xe9e, 0x3b, 0xe9e, 0xeab, 0x3b, 0xeaa, 0xeb8, 0x3b, 0xeaa, 0x53,
0x76, 0x113, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x4f,
0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x54, 0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x43, 0x65,
0x74, 0x75, 0x72, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x50, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61,
0x3b, 0x53, 0x65, 0x73, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x73, 0x76, 0x113, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b,
0x70, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x74,
0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x63, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61,
0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x64, 0x69, 0x65, 0x6e,
0x61, 0x53, 0x76, 0x113, 0x74, 0x64, 0x2e, 0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64, 0x2e, 0x3b, 0x4f, 0x74, 0x72, 0x64, 0x2e,
0x3b, 0x54, 0x72, 0x65, 0x161, 0x64, 0x2e, 0x3b, 0x43, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x2e, 0x3b, 0x50, 0x69, 0x65,
0x6b, 0x74, 0x64, 0x2e, 0x3b, 0x53, 0x65, 0x73, 0x74, 0x64, 0x2e, 0x73, 0x76, 0x113, 0x74, 0x64, 0x2e, 0x3b, 0x70, 0x69,
0x72, 0x6d, 0x64, 0x2e, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x2e, 0x3b, 0x74, 0x72, 0x65, 0x161, 0x64, 0x2e, 0x3b, 0x63, 0x65,
0x74, 0x75, 0x72, 0x74, 0x64, 0x2e, 0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x2e, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x64,
0x2e, 0x53, 0x3b, 0x50, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x65, 0x79, 0x65, 0x6e, 0x67, 0x61,
0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x79, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x6d, 0x6f,
0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x6d, 0x6f, 0x6b, 0x254,
0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254,
0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x6e, 0xe9, 0x69, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20,
0x6d, 0xed, 0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x6d, 0x70, 0x254, 0x301, 0x73, 0x254, 0x65, 0x79, 0x65, 0x3b, 0x79, 0x62, 0x6f,
0x3b, 0x6d, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x74, 0x3b, 0x6d, 0x69, 0x6e, 0x3b, 0x6d, 0x74, 0x6e, 0x3b, 0x6d, 0x70, 0x73,
0x65, 0x3b, 0x79, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x70, 0x73, 0x65, 0x6b, 0x6d, 0x61, 0x64, 0x69,
0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x61, 0x6e, 0x74,
0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x74, 0x72, 0x65, 0x10d, 0x69, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69,
0x73, 0x3b, 0x6b, 0x65, 0x74, 0x76, 0x69, 0x72, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x65, 0x6e,
0x6b, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x161, 0x65, 0x161, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69,
0x73, 0x73, 0x6b, 0x3b, 0x70, 0x72, 0x3b, 0x61, 0x6e, 0x3b, 0x74, 0x72, 0x3b, 0x6b, 0x74, 0x3b, 0x70, 0x6e, 0x3b, 0x161,
0x74, 0x53, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x160, 0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c,
0x61, 0x3b, 0x70, 0xf3, 0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c, 0x65, 0x3b, 0x77, 0x61, 0x142, 0x74, 0x6f, 0x72, 0x61, 0x3b,
0x73, 0x72, 0x6a, 0x6f, 0x64, 0x61, 0x3b, 0x73, 0x74, 0x77, 0xf3, 0x72, 0x74, 0x6b, 0x3b, 0x70, 0x11b, 0x74, 0x6b, 0x3b,
0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x6e, 0x6a, 0x65, 0x3b, 0x70, 0xf3, 0x6e, 0x3b, 0x77, 0x61, 0x142, 0x3b, 0x73, 0x72,
0x6a, 0x3b, 0x73, 0x74, 0x77, 0x3b, 0x70, 0x11b, 0x74, 0x3b, 0x73, 0x6f, 0x62, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x73,
0x3b, 0x73, 0x3b, 0x70, 0x3b, 0x73, 0x53, 0xfc, 0x6e, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e, 0x64, 0x61,
0x67, 0x3b, 0x44, 0x69, 0x6e, 0x67, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x64, 0x64, 0x65, 0x77, 0x65, 0x6b, 0x65,
0x6e, 0x3b, 0x44, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x65, 0x64, 0x61, 0x67,
0x3b, 0x53, 0xfc, 0x6e, 0x6e, 0x61, 0x76, 0x65, 0x6e, 0x64, 0x53, 0xfc, 0x2e, 0x3b, 0x4d, 0x61, 0x2e, 0x3b, 0x44, 0x69,
0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x4c, 0x75, 0x6d,
0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4e, 0x6b, 0x6f, 0x64, 0x79, 0x61, 0x3b, 0x4e, 0x64, 0xe0, 0x61, 0x79, 0xe0, 0x3b, 0x4e,
0x64, 0x61, 0x6e, 0x67, 0xf9, 0x3b, 0x4e, 0x6a, 0xf2, 0x77, 0x61, 0x3b, 0x4e, 0x67, 0xf2, 0x76, 0x79, 0x61, 0x3b, 0x4c,
0x75, 0x62, 0x69, 0x6e, 0x67, 0x75, 0x4c, 0x75, 0x6d, 0x3b, 0x4e, 0x6b, 0x6f, 0x3b, 0x4e, 0x64, 0x79, 0x3b, 0x4e, 0x64,
0x67, 0x3b, 0x4e, 0x6a, 0x77, 0x3b, 0x4e, 0x67, 0x76, 0x3b, 0x4c, 0x75, 0x62, 0x4c, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e,
0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4c, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x3b, 0x57, 0x75, 0x6f, 0x6b, 0x20, 0x54,
0x69, 0x63, 0x68, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20,
0x41, 0x64, 0x65, 0x6b, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x6e, 0x67, 0x2019, 0x77, 0x65, 0x6e, 0x3b, 0x54, 0x69,
0x63, 0x68, 0x20, 0x41, 0x62, 0x69, 0x63, 0x68, 0x3b, 0x4e, 0x67, 0x65, 0x73, 0x6f, 0x4a, 0x4d, 0x50, 0x3b, 0x57, 0x55,
0x54, 0x3b, 0x54, 0x41, 0x52, 0x3b, 0x54, 0x41, 0x44, 0x3b, 0x54, 0x41, 0x4e, 0x3b, 0x54, 0x41, 0x42, 0x3b, 0x4e, 0x47,
0x53, 0x4a, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4e, 0x53, 0x6f, 0x6e, 0x6e, 0x64, 0x65,
0x67, 0x3b, 0x4d, 0xe9, 0x69, 0x6e, 0x64, 0x65, 0x67, 0x3b, 0x44, 0xeb, 0x6e, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b,
0x4d, 0xeb, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67,
0x3b, 0x46, 0x72, 0x65, 0x69, 0x64, 0x65, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x53, 0x6f,
0x6e, 0x3b, 0x4d, 0xe9, 0x69, 0x3b, 0x44, 0xeb, 0x6e, 0x3b, 0x4d, 0xeb, 0x74, 0x3b, 0x44, 0x6f, 0x6e, 0x3b, 0x46, 0x72,
0x65, 0x3b, 0x53, 0x61, 0x6d, 0x53, 0x6f, 0x6e, 0x2e, 0x3b, 0x4d, 0xe9, 0x69, 0x2e, 0x3b, 0x44, 0xeb, 0x6e, 0x2e, 0x3b,
0x4d, 0xeb, 0x74, 0x2e, 0x3b, 0x44, 0x6f, 0x6e, 0x2e, 0x3b, 0x46, 0x72, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x6d, 0x2e, 0x4a,
0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x75, 0x72, 0x77, 0x61, 0x20,
0x77, 0x61, 0x20, 0x4b, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4d, 0x75, 0x72, 0x77, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61,
0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x4a, 0x32, 0x3b, 0x4a, 0x33, 0x3b, 0x4a,
0x34, 0x3b, 0x4a, 0x35, 0x3b, 0x41, 0x6c, 0x3b, 0x49, 0x6a, 0x3b, 0x4a, 0x31, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x430, 0x3b,
0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441,
0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x43e, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x43e, 0x43a, 0x3b,
0x441, 0x430, 0x431, 0x43e, 0x442, 0x430, 0x43d, 0x435, 0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432, 0x442, 0x43e, 0x2e,
0x3b, 0x441, 0x440, 0x435, 0x2e, 0x3b, 0x447, 0x435, 0x442, 0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430, 0x431, 0x2e,
0x43d, 0x435, 0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432, 0x442, 0x2e, 0x3b, 0x441, 0x440, 0x435, 0x2e, 0x3b, 0x447,
0x435, 0x442, 0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430, 0x431, 0x2e, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c,
0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49,
0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74,
0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d,
0x6f, 0x53, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x68, 0x61, 0x6d,
0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x53,
0x61, 0x62, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x49,
0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x53, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x4c,
0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61,
0x20, 0x6c, 0x79, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e,
0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79,
0x61, 0x6e, 0x6f, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f,
0x20, 0x6e, 0x61, 0x20, 0x6c, 0x69, 0x6e, 0x6a, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61,
0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64,
0x75, 0x76, 0x61, 0x20, 0x6c, 0x69, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x4c, 0x6c, 0x32, 0x3b, 0x4c, 0x6c, 0x33, 0x3b, 0x4c,
0x6c, 0x34, 0x3b, 0x4c, 0x6c, 0x35, 0x3b, 0x4c, 0x6c, 0x36, 0x3b, 0x4c, 0x6c, 0x37, 0x3b, 0x4c, 0x6c, 0x31, 0x32, 0x3b,
0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x31, 0x41, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x79, 0x3b, 0x41,
0x6c, 0x61, 0x74, 0x73, 0x69, 0x6e, 0x61, 0x69, 0x6e, 0x79, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c,
0x61, 0x72, 0x6f, 0x62, 0x69, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x61, 0x6d, 0x69, 0x73, 0x79, 0x3b, 0x5a, 0x6f, 0x6d,
0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x6f, 0x74, 0x73, 0x79, 0x41, 0x6c, 0x61, 0x68, 0x3b, 0x41, 0x6c, 0x61, 0x74, 0x73,
0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x3b, 0x5a, 0x6f, 0x6d, 0x3b, 0x41,
0x73, 0x61, 0x62, 0x41, 0x3b, 0x41, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x5a, 0x3b, 0x41, 0xd1e, 0xd3e, 0xd2f, 0xd31,
0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a, 0xd4a,
0xd35, 0xd4d, 0xd35, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35,
0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d,
0x200c, 0xd1a, 0x3b, 0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0xd1e, 0xd3e, 0xd2f, 0xd31, 0xd3e, 0xd34, 0xd4d, 0x200c,
0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0xd3e,
0xd34, 0xd4d, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd3e,
0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd36, 0xd28,
0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0xd1e, 0xd3e, 0xd2f, 0xd7c, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd7e, 0x3b, 0xd1a,
0xd4a, 0xd35, 0xd4d, 0xd35, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd7b, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd02, 0x3b, 0xd35, 0xd46, 0xd33,
0xd4d, 0xd33, 0xd3f, 0x3b, 0xd36, 0xd28, 0xd3f, 0xd1e, 0xd3e, 0x3b, 0xd24, 0xd3f, 0x3b, 0xd1a, 0xd4a, 0x3b, 0xd2c, 0xd41, 0x3b, 0xd35,
0xd4d, 0xd2f, 0xd3e, 0x3b, 0xd35, 0xd46, 0x3b, 0xd36, 0xd1e, 0x3b, 0xd24, 0xd3f, 0x3b, 0xd1a, 0xd4a, 0x3b, 0xd2c, 0xd41, 0x3b, 0xd35,
0xd4d, 0xd2f, 0xd3e, 0x3b, 0xd35, 0xd46, 0x3b, 0xd36, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x6e, 0x3b, 0x53,
0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x41, 0x68, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b, 0x53, 0x65,
0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x68, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x41, 0x3b, 0x49,
0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x64, 0x64, 0x3b, 0x49, 0x74,
0x2d, 0x54, 0x6e, 0x65, 0x6a, 0x6e, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6c, 0x69, 0x65, 0x74, 0x61, 0x3b, 0x4c, 0x2d, 0x45,
0x72, 0x62, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x49, 0x6c, 0x2d, 0x120, 0x69,
0x6d, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x73, 0x2d, 0x53, 0x69, 0x62, 0x74, 0x126, 0x61, 0x64, 0x3b, 0x54, 0x6e, 0x65, 0x3b,
0x54, 0x6c, 0x69, 0x3b, 0x45, 0x72, 0x62, 0x3b, 0x126, 0x61, 0x6d, 0x3b, 0x120, 0x69, 0x6d, 0x3b, 0x53, 0x69, 0x62, 0x126,
0x64, 0x3b, 0x54, 0x6e, 0x3b, 0x54, 0x6c, 0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120, 0x6d, 0x3b, 0x53, 0x62, 0x126,
0x64, 0x3b, 0x54, 0x3b, 0x54, 0x6c, 0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120, 0x6d, 0x3b, 0x53, 0x62, 0x9a8, 0x9cb,
0x982, 0x9ae, 0x9be, 0x987, 0x99c, 0x9bf, 0x982, 0x3b, 0x9a8, 0x9bf, 0x982, 0x9a5, 0x9cc, 0x995, 0x9be, 0x9ac, 0x9be, 0x3b, 0x9b2, 0x9c8,
0x9ac, 0x9be, 0x995, 0x9aa, 0x9cb, 0x995, 0x9aa, 0x9be, 0x3b, 0x9af, 0x9bc, 0x9c1, 0x9ae, 0x9b6, 0x995, 0x9c8, 0x9b6, 0x9be, 0x3b, 0x9b6,
0x997, 0x9cb, 0x9b2, 0x9b6, 0x9c7, 0x9a8, 0x3b, 0x987, 0x9b0, 0x9be, 0x987, 0x3b, 0x9a5, 0x9be, 0x982, 0x99c, 0x9a8, 0x9cb, 0x3b, 0x9a8,
0x9bf, 0x982, 0x3b, 0x9b2, 0x9c8, 0x3b, 0x9af, 0x9bc, 0x9c1, 0x9ae, 0x3b, 0x9b6, 0x997, 0x3b, 0x987, 0x9b0, 0x9be, 0x3b, 0x9a5, 0x9be,
0x982, 0x9a8, 0x9cb, 0x982, 0x3b, 0x9a8, 0x9bf, 0x982, 0x3b, 0x9b2, 0x9c8, 0x3b, 0x9af, 0x9bc, 0x9c1, 0x9ae, 0x3b, 0x9b6, 0x997, 0x3b,
0x987, 0x9b0, 0x9be, 0x3b, 0x9a5, 0x9be, 0x982, 0x4a, 0x65, 0x64, 0x6f, 0x6f, 0x6e, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x6c, 0x68,
0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x6d, 0x61, 0x79, 0x72, 0x74, 0x3b, 0x4a, 0x65, 0x72, 0x63, 0x65, 0x61, 0x6e, 0x3b,
0x4a, 0x65, 0x72, 0x64, 0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x68, 0x65, 0x69, 0x6e, 0x65, 0x79, 0x3b, 0x4a, 0x65, 0x73,
0x61, 0x72, 0x6e, 0x4a, 0x65, 0x64, 0x3b, 0x4a, 0x65, 0x6c, 0x3b, 0x4a, 0x65, 0x6d, 0x3b, 0x4a, 0x65, 0x72, 0x63, 0x3b,
0x4a, 0x65, 0x72, 0x64, 0x3b, 0x4a, 0x65, 0x68, 0x3b, 0x4a, 0x65, 0x73, 0x52, 0x101, 0x74, 0x61, 0x70, 0x75, 0x3b, 0x52,
0x101, 0x68, 0x69, 0x6e, 0x61, 0x3b, 0x52, 0x101, 0x74, 0x16b, 0x3b, 0x52, 0x101, 0x61, 0x70, 0x61, 0x3b, 0x52, 0x101, 0x70,
0x61, 0x72, 0x65, 0x3b, 0x52, 0x101, 0x6d, 0x65, 0x72, 0x65, 0x3b, 0x52, 0x101, 0x68, 0x6f, 0x72, 0x6f, 0x69, 0x54, 0x61,
0x70, 0x3b, 0x48, 0x69, 0x6e, 0x3b, 0x54, 0x16b, 0x3b, 0x41, 0x70, 0x61, 0x3b, 0x50, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x72,
0x3b, 0x48, 0x6f, 0x72, 0x54, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x48, 0x930, 0x935, 0x93f,
0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x935, 0x93e, 0x930, 0x3b, 0x92c,
0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935,
0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x902, 0x917,
0x933, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f,
0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x6c, 0xed, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x6e, 0x254, 0x3b, 0x41, 0x6c, 0x61, 0xe1, 0x6d, 0x69,
0x73, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0xf3, 0x73, 0x69, 0x4b, 0x69, 0x75,
0x6d, 0x69, 0x61, 0x3b, 0x4d, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x6f, 0x3b, 0x57, 0x61, 0x69, 0x72, 0x69, 0x3b, 0x57,
0x65, 0x74, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x61, 0x3b, 0x57, 0x65, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x4b, 0x49, 0x55, 0x3b, 0x4d, 0x52, 0x41, 0x3b, 0x57, 0x41, 0x49, 0x3b, 0x57,
0x45, 0x54, 0x3b, 0x57, 0x45, 0x4e, 0x3b, 0x57, 0x54, 0x4e, 0x3b, 0x4a, 0x55, 0x4d, 0x4b, 0x3b, 0x4d, 0x3b, 0x57, 0x3b,
0x57, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x4a, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x31, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x32,
0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x33, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x34, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20,
0x35, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x36, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x37, 0x41, 0x31, 0x3b, 0x41, 0x32,
0x3b, 0x41, 0x33, 0x3b, 0x41, 0x34, 0x3b, 0x41, 0x35, 0x3b, 0x41, 0x36, 0x3b, 0x41, 0x37, 0x41d, 0x44f, 0x43c, 0x3b, 0x414,
0x430, 0x432, 0x430, 0x430, 0x3b, 0x41c, 0x44f, 0x433, 0x43c, 0x430, 0x440, 0x3b, 0x41b, 0x445, 0x430, 0x433, 0x432, 0x430, 0x3b, 0x41f,
0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x411, 0x430, 0x430, 0x441, 0x430, 0x43d, 0x3b, 0x411, 0x44f, 0x43c, 0x431, 0x430, 0x43d, 0x44f, 0x43c,
0x3b, 0x434, 0x430, 0x432, 0x430, 0x430, 0x3b, 0x43c, 0x44f, 0x433, 0x43c, 0x430, 0x440, 0x3b, 0x43b, 0x445, 0x430, 0x433, 0x432, 0x430,
0x3b, 0x43f, 0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x431, 0x430, 0x430, 0x441, 0x430, 0x43d, 0x3b, 0x431, 0x44f, 0x43c, 0x431, 0x430, 0x41d,
0x44f, 0x3b, 0x414, 0x430, 0x3b, 0x41c, 0x44f, 0x3b, 0x41b, 0x445, 0x3b, 0x41f, 0x4af, 0x3b, 0x411, 0x430, 0x3b, 0x411, 0x44f, 0x64,
0x69, 0x6d, 0x61, 0x6e, 0x73, 0x3b, 0x6c, 0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65,
0x72, 0x6b, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x7a, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69,
0x3b, 0x73, 0x61, 0x6d, 0x64, 0x69, 0x64, 0x69, 0x6d, 0x3b, 0x6c, 0x69, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65,
0x72, 0x3b, 0x7a, 0x65, 0x3b, 0x76, 0x61, 0x6e, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b,
0x7a, 0x3b, 0x76, 0x3b, 0x73, 0x43, 0x6f, 0x6d, 0x2019, 0x79, 0x61, 0x6b, 0x6b, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6c, 0x61,
0x61, 0x257, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x69, 0x69, 0x257, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x6b,
0x6f, 0x6c, 0x6c, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x61, 0x6c, 0x64, 0x1dd, 0x253, 0x6c, 0x69, 0x69, 0x3b, 0x43, 0x6f,
0x6d, 0x67, 0x61, 0x69, 0x73, 0x75, 0x75, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x65, 0x253, 0x73, 0x75, 0x75, 0x43, 0x79,
0x61, 0x3b, 0x43, 0x6c, 0x61, 0x3b, 0x43, 0x7a, 0x69, 0x3b, 0x43, 0x6b, 0x6f, 0x3b, 0x43, 0x6b, 0x61, 0x3b, 0x43, 0x67,
0x61, 0x3b, 0x43, 0x7a, 0x65, 0x59, 0x3b, 0x4c, 0x3b, 0x5a, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x47, 0x3b, 0x45, 0x53, 0x6f,
0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65,
0x73, 0x3b, 0x44, 0x65, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x57, 0x75, 0x6e, 0x73, 0x74,
0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65,
0x65, 0x73, 0x3b, 0x46, 0x72, 0x61, 0x69, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x74, 0x65,
0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x61, 0x3b, 0x44, 0x65, 0x3b, 0x57,
0x75, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61, 0x74, 0x53, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x57, 0x3b, 0x44,
0x3b, 0x46, 0x3b, 0x41, 0x906, 0x907, 0x924, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x919,
0x94d, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x939, 0x93f, 0x92c, 0x93e,
0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x906, 0x907, 0x924,
0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x92c, 0x93f, 0x939, 0x93f, 0x3b,
0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x3b, 0x92c, 0x941, 0x3b, 0x92c,
0x93f, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x6c, 0x79, 0x25b, 0x2bc, 0x25b, 0x301, 0x20, 0x73, 0x1e85, 0xed, 0x14b, 0x74, 0xe8, 0x3b,
0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254, 0x6e, 0x74, 0xe8, 0x20,
0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x74, 0x73, 0xe8, 0x74, 0x73, 0x25b, 0x300, 0x25b, 0x20,
0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254, 0x6e, 0x74, 0xe8, 0x20, 0x74, 0x73, 0x65, 0x74, 0x73,
0x25b, 0x300, 0x25b, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6d, 0xe0, 0x67, 0x61, 0x20,
0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0xe0, 0x67, 0x61, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x53, 0x254, 0x301, 0x6e,
0x64, 0x69, 0x3b, 0x4d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0xc1, 0x70, 0x74, 0x61, 0x20, 0x4d, 0x254, 0x301, 0x6e, 0x64,
0x69, 0x3b, 0x57, 0x25b, 0x301, 0x6e, 0x25b, 0x73, 0x25b, 0x64, 0x25b, 0x3b, 0x54, 0x254, 0x301, 0x73, 0x25b, 0x64, 0x25b, 0x3b,
0x46, 0x25b, 0x6c, 0xe2, 0x79, 0x25b, 0x64, 0x25b, 0x3b, 0x53, 0xe1, 0x73, 0x69, 0x64, 0x25b, 0x53, 0x254, 0x301, 0x3b, 0x4d,
0x254, 0x301, 0x3b, 0xc1, 0x4d, 0x3b, 0x57, 0x25b, 0x301, 0x3b, 0x54, 0x254, 0x301, 0x3b, 0x46, 0x25b, 0x3b, 0x53, 0xe1, 0x53,
0x1ecd, 0x301, 0x6e, 0x64, 0xe8, 0x3b, 0x4d, 0x1ecd, 0x301, 0x6e, 0x64, 0xe8, 0x3b, 0x54, 0x69, 0xfa, 0x7a, 0x64, 0xe8, 0x3b,
0x57, 0x1eb9, 0x301, 0x6e, 0x1eb9, 0x301, 0x7a, 0x64, 0xe8, 0x3b, 0x54, 0x1ecd, 0x301, 0x7a, 0x64, 0xe8, 0x3b, 0x46, 0x72, 0x61,
0xed, 0x64, 0xe8, 0x3b, 0x53, 0xe1, 0x74, 0x1ecd, 0x64, 0xe8, 0x53, 0x1ecd, 0x301, 0x6e, 0x3b, 0x4d, 0x1ecd, 0x301, 0x6e, 0x3b,
0x54, 0x69, 0xfa, 0x3b, 0x57, 0x1eb9, 0x301, 0x6e, 0x3b, 0x54, 0x1ecd, 0x301, 0x7a, 0x3b, 0x46, 0x72, 0x61, 0xed, 0x3b, 0x53,
0xe1, 0x74, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65, 0x61, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0xe1,
0x72, 0x67, 0x61, 0x3b, 0x6d, 0x61, 0x14b, 0x14b, 0x65, 0x62, 0xe1, 0x72, 0x67, 0x61, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x61,
0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x61, 0x73, 0x64, 0x61, 0x74, 0x3b, 0x62, 0x65, 0x61,
0x72, 0x6a, 0x61, 0x64, 0x61, 0x74, 0x3b, 0x6c, 0xe1, 0x76, 0x76, 0x61, 0x72, 0x64, 0x61, 0x74, 0x73, 0x6f, 0x74, 0x6e,
0x3b, 0x76, 0x75, 0x6f, 0x73, 0x3b, 0x6d, 0x61, 0x14b, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x3b,
0x62, 0x65, 0x61, 0x72, 0x3b, 0x6c, 0xe1, 0x76, 0x53, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42, 0x3b,
0x4c, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65, 0x61, 0x69, 0x76, 0x69, 0x3b, 0x6d, 0xe1, 0x6e, 0x6e, 0x6f, 0x64, 0x61,
0x74, 0x3b, 0x64, 0x69, 0x73, 0x64, 0x61, 0x74, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75,
0x3b, 0x64, 0x75, 0x6f, 0x72, 0x61, 0x73, 0x74, 0x61, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x74,
0x3b, 0x6c, 0xe1, 0x76, 0x76, 0x6f, 0x72, 0x64, 0x61, 0x74, 0x73, 0x6f, 0x3b, 0x6d, 0xe1, 0x3b, 0x64, 0x69, 0x3b, 0x67,
0x61, 0x3b, 0x64, 0x75, 0x3b, 0x62, 0x65, 0x3b, 0x6c, 0xe1, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x44, 0x3b,
0x42, 0x3b, 0x4c, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x6c,
0x69, 0x3b, 0x53, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x53, 0x69, 0x6e, 0x65, 0x3b, 0x53, 0x69, 0x68, 0x6c,
0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x76, 0x75, 0x3b,
0x53, 0x69, 0x62, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x53, 0x69, 0x68, 0x3b, 0x4d, 0x67, 0x71, 0x53,
0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4d, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d,
0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x79, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b,
0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0x61, 0x75, 0x72, 0x64,
0x61, 0x67, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0xe5, 0x6e, 0x3b, 0x74, 0x79, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f,
0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0x61, 0x75, 0x73, 0xf8, 0x2e, 0x3b, 0x6d, 0xe5, 0x2e, 0x3b, 0x74, 0x79, 0x2e,
0x3b, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x6c, 0x61, 0x2e, 0x43, 0xe4, 0x14b, 0x20,
0x6b, 0x75, 0x254, 0x74, 0x68, 0x3b, 0x4a, 0x69, 0x65, 0x63, 0x20, 0x6c, 0x61, 0x331, 0x74, 0x3b, 0x52, 0x25b, 0x77, 0x20,
0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x14a, 0x75,
0x61, 0x61, 0x6e, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x65, 0x65, 0x63, 0x20, 0x6c, 0xe4, 0x74,
0x6e, 0x69, 0x3b, 0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x43, 0xe4, 0x14b, 0x3b, 0x4a, 0x69,
0x65, 0x63, 0x3b, 0x52, 0x25b, 0x77, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e, 0x3b, 0x44,
0x68, 0x69, 0x65, 0x65, 0x63, 0x3b, 0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x43, 0x3b, 0x4a, 0x3b, 0x52, 0x3b, 0x44, 0x3b, 0x14a,
0x3b, 0x44, 0x3b, 0x42, 0xb30, 0xb2c, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb38, 0xb4b, 0xb2e, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2e, 0xb19,
0xb4d, 0xb17, 0xb33, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2c, 0xb41, 0xb27, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0xb2c, 0xb3e,
0xb30, 0x3b, 0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0xb30, 0xb2c, 0xb3f,
0x3b, 0xb38, 0xb4b, 0xb2e, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33, 0x3b, 0xb2c, 0xb41, 0xb27, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0x3b,
0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0xb30, 0x3b, 0xb38, 0xb4b, 0x3b, 0xb2e, 0x3b, 0xb2c, 0xb41, 0x3b, 0xb17,
0xb41, 0x3b, 0xb36, 0xb41, 0x3b, 0xb36, 0x44, 0x69, 0x6c, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x57, 0x69, 0x69, 0x78, 0x61, 0x74,
0x61, 0x3b, 0x51, 0x69, 0x62, 0x78, 0x61, 0x74, 0x61, 0x3b, 0x52, 0x6f, 0x6f, 0x62, 0x69, 0x69, 0x3b, 0x4b, 0x61, 0x6d,
0x69, 0x69, 0x73, 0x61, 0x3b, 0x4a, 0x69, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x6e, 0x62, 0x61, 0x74, 0x61,
0x44, 0x69, 0x6c, 0x3b, 0x57, 0x69, 0x78, 0x3b, 0x51, 0x69, 0x62, 0x3b, 0x52, 0x6f, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b,
0x4a, 0x69, 0x6d, 0x3b, 0x53, 0x61, 0x6e, 0x44, 0x3b, 0x57, 0x3b, 0x51, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53,
0x425, 0x443, 0x44b, 0x446, 0x430, 0x443, 0x431, 0x43e, 0x43d, 0x3b, 0x41a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b,
0x414, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x4d4, 0x440, 0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x426, 0x44b, 0x43f, 0x43f,
0x4d5, 0x440, 0x4d5, 0x43c, 0x3b, 0x41c, 0x430, 0x439, 0x440, 0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x421, 0x430, 0x431, 0x430, 0x442,
0x445, 0x443, 0x44b, 0x446, 0x430, 0x443, 0x431, 0x43e, 0x43d, 0x3b, 0x43a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b,
0x434, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x4d5, 0x440, 0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x446, 0x44b, 0x43f, 0x43f,
0x4d5, 0x440, 0x4d5, 0x43c, 0x3b, 0x43c, 0x430, 0x439, 0x440, 0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x441, 0x430, 0x431, 0x430, 0x442,
0x425, 0x446, 0x431, 0x3b, 0x41a, 0x440, 0x441, 0x3b, 0x414, 0x446, 0x433, 0x3b, 0x4d4, 0x440, 0x442, 0x3b, 0x426, 0x43f, 0x440, 0x3b,
0x41c, 0x440, 0x431, 0x3b, 0x421, 0x431, 0x442, 0x445, 0x446, 0x431, 0x3b, 0x43a, 0x440, 0x441, 0x3b, 0x434, 0x446, 0x433, 0x3b, 0x4d5,
0x440, 0x442, 0x3b, 0x446, 0x43f, 0x440, 0x3b, 0x43c, 0x440, 0x431, 0x3b, 0x441, 0x431, 0x442, 0x425, 0x3b, 0x41a, 0x3b, 0x414, 0x3b,
0x4d4, 0x3b, 0x426, 0x3b, 0x41c, 0x3b, 0x421, 0x64a, 0x648, 0x646, 0x6cd, 0x3b, 0x62f, 0x648, 0x646, 0x6cd, 0x3b, 0x62f, 0x631, 0x6d0,
0x646, 0x6cd, 0x3b, 0x685, 0x644, 0x631, 0x646, 0x6cd, 0x3b, 0x67e, 0x64a, 0x646, 0x681, 0x646, 0x6cd, 0x3b, 0x62c, 0x645, 0x639, 0x647,
0x3b, 0x627, 0x648, 0x646, 0x6cd, 0x6cc, 0x6a9, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x62f, 0x648, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x633,
0x647, 0x200c, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x686, 0x647, 0x627, 0x631, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x67e, 0x646, 0x62c, 0x634,
0x646, 0x628, 0x647, 0x3b, 0x62c, 0x645, 0x639, 0x647, 0x3b, 0x634, 0x646, 0x628, 0x647, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686,
0x3b, 0x67e, 0x3b, 0x62c, 0x3b, 0x634, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x69,
0x65, 0x64, 0x7a, 0x69, 0x61, 0x142, 0x65, 0x6b, 0x3b, 0x77, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x15b, 0x72, 0x6f, 0x64,
0x61, 0x3b, 0x63, 0x7a, 0x77, 0x61, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x69, 0x105, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f,
0x62, 0x6f, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x77, 0x74, 0x2e, 0x3b,
0x15b, 0x72, 0x2e, 0x3b, 0x63, 0x7a, 0x77, 0x2e, 0x3b, 0x70, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x4e, 0x3b, 0x50,
0x3b, 0x57, 0x3b, 0x15a, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x15b, 0x3b, 0x63, 0x3b,
0x70, 0x3b, 0x73, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66,
0x65, 0x69, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x61,
0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69,
0x72, 0x61, 0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64,
0x6f, 0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x73, 0x65, 0x67, 0x2e, 0x3b, 0x74, 0x65, 0x72, 0x2e, 0x3b, 0x71, 0x75, 0x61, 0x2e,
0x3b, 0x71, 0x75, 0x69, 0x2e, 0x3b, 0x73, 0x65, 0x78, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e, 0x44, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x51, 0x3b, 0x51, 0x3b, 0x53, 0x3b, 0x53, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x67, 0x75,
0x6e, 0x64, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x3b, 0x71, 0x75, 0x61, 0x72, 0x74, 0x61, 0x3b, 0x71, 0x75, 0x69,
0x6e, 0x74, 0x61, 0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0xa10, 0xa24, 0xa35, 0xa3e,
0xa30, 0x3b, 0xa38, 0xa4b, 0xa2e, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa2c, 0xa41, 0xa71,
0xa27, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa35, 0xa40, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15, 0xa30, 0xa35, 0xa3e,
0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa3f, 0xa71, 0xa1a, 0xa30, 0xa35, 0xa3e, 0xa30, 0xa10, 0xa24, 0x3b, 0xa38, 0xa4b, 0xa2e, 0x3b, 0xa2e,
0xa70, 0xa17, 0xa32, 0x3b, 0xa2c, 0xa41, 0xa71, 0xa27, 0x3b, 0xa35, 0xa40, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15, 0xa30, 0x3b,
0xa38, 0xa3c, 0xa28, 0xa3f, 0xa71, 0xa1a, 0xa30, 0xa10, 0x3b, 0xa38, 0xa4b, 0x3b, 0xa2e, 0xa70, 0x3b, 0xa2c, 0xa41, 0xa71, 0x3b, 0xa35,
0xa40, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0x3b, 0xa38, 0xa3c, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x67e, 0x6cc, 0x631, 0x3b, 0x645,
0x646, 0x6af, 0x644, 0x3b, 0x628, 0x64f, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645, 0x639, 0x6c1,
0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d,
0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x4a, 0x75, 0x65, 0x76,
0x65, 0x73, 0x3b, 0x56, 0x69, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x44, 0x6f, 0x6d,
0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0xe9, 0x3b, 0x4a, 0x75, 0x65, 0x3b, 0x56, 0x69, 0x65,
0x3b, 0x53, 0x61, 0x62, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53, 0x64, 0x75, 0x6d,
0x69, 0x6e, 0x69, 0x63, 0x103, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x21b, 0x69, 0x3b, 0x6d, 0x69, 0x65,
0x72, 0x63, 0x75, 0x72, 0x69, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x65, 0x72, 0x69, 0x3b, 0x73, 0xe2, 0x6d,
0x62, 0x103, 0x74, 0x103, 0x64, 0x75, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d,
0x69, 0x65, 0x2e, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x2e, 0x3b, 0x73, 0xe2, 0x6d, 0x2e, 0x44, 0x75, 0x6d,
0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x65, 0x3b, 0x4a, 0x6f, 0x69, 0x3b, 0x56, 0x69, 0x6e,
0x3b, 0x53, 0xe2, 0x6d, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x61, 0x3b, 0x4d, 0x69, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53, 0x64,
0x75, 0x6d, 0x65, 0x6e, 0x67, 0x69, 0x61, 0x3b, 0x67, 0x6c, 0x69, 0x6e, 0x64, 0x65, 0x73, 0x64, 0x69, 0x3b, 0x6d, 0x61,
0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x73, 0x65, 0x6d, 0x6e, 0x61, 0x3b, 0x67, 0x69, 0x65, 0x76, 0x67, 0x69, 0x61, 0x3b,
0x76, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x69, 0x3b, 0x73, 0x6f, 0x6e, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x67, 0x6c, 0x69,
0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x65, 0x3b, 0x67, 0x69, 0x65, 0x3b, 0x76, 0x65, 0x3b, 0x73, 0x6f, 0x44, 0x3b, 0x47, 0x3b,
0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x49,
0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x49, 0x6a,
0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75,
0x6d, 0x61, 0x61, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x49, 0x6a, 0x70, 0x3b, 0x49, 0x6a, 0x74,
0x3b, 0x49, 0x6a, 0x6e, 0x3b, 0x49, 0x6a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x49, 0x6a,
0x6d, 0x4b, 0x75, 0x20, 0x77, 0x2019, 0x69, 0x6e, 0x64, 0x77, 0x69, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62,
0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x20,
0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65,
0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20,
0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x75, 0x63, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61,
0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e,
0x64, 0x2e, 0x432, 0x43e, 0x441, 0x43a, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x435, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435,
0x43b, 0x44c, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b,
0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x433, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431, 0x431,
0x43e, 0x442, 0x430, 0x432, 0x441, 0x3b, 0x43f, 0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442,
0x3b, 0x441, 0x431, 0x412, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421, 0x431, 0x430, 0x441, 0x43a,
0x44b, 0x4bb, 0x44b, 0x430, 0x43d, 0x43d, 0x44c, 0x430, 0x3b, 0x431, 0x44d, 0x43d, 0x438, 0x434, 0x438, 0x44d, 0x43d, 0x43d, 0x44c, 0x438,
0x43a, 0x3b, 0x43e, 0x43f, 0x442, 0x443, 0x43e, 0x440, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x43a, 0x3b, 0x441, 0x44d, 0x440, 0x44d, 0x434,
0x44d, 0x3b, 0x447, 0x44d, 0x43f, 0x43f, 0x438, 0x44d, 0x440, 0x3b, 0x411, 0x44d, 0x44d, 0x442, 0x438, 0x4a5, 0x441, 0x44d, 0x3b, 0x441,
0x443, 0x431, 0x443, 0x43e, 0x442, 0x430, 0x431, 0x441, 0x3b, 0x431, 0x43d, 0x3b, 0x43e, 0x43f, 0x3b, 0x441, 0x44d, 0x3b, 0x447, 0x43f,
0x3b, 0x431, 0x44d, 0x3b, 0x441, 0x431, 0x411, 0x3b, 0x411, 0x3b, 0x41e, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x411, 0x3b, 0x421, 0x4d,
0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x61, 0x72, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20,
0x65, 0x65, 0x20, 0x6b, 0x75, 0x6e, 0x69, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6f, 0x6e,
0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x69, 0x6e, 0x65, 0x74,
0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x69, 0x6c, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f,
0x74, 0x20, 0x65, 0x65, 0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20,
0x6b, 0x77, 0x65, 0x41, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x6e, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x49,
0x6c, 0x65, 0x3b, 0x53, 0x61, 0x70, 0x3b, 0x4b, 0x77, 0x65, 0x41, 0x3b, 0x4b, 0x3b, 0x4f, 0x3b, 0x49, 0x3b, 0x49, 0x3b,
0x53, 0x3b, 0x4b, 0x42, 0x69, 0x6b, 0x75, 0x61, 0x2d, 0xf4, 0x6b, 0x6f, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0xfb,
0x73, 0x65, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x70, 0x74, 0xe2, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x75,
0x73, 0xef, 0xf6, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x6f, 0x6b, 0xfc, 0x3b, 0x4c, 0xe2, 0x70, 0xf4, 0x73, 0xf6,
0x3b, 0x4c, 0xe2, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x42, 0x6b, 0x31, 0x3b, 0x42, 0x6b, 0x32, 0x3b, 0x42, 0x6b, 0x33, 0x3b,
0x42, 0x6b, 0x34, 0x3b, 0x42, 0x6b, 0x35, 0x3b, 0x4c, 0xe2, 0x70, 0x3b, 0x4c, 0xe2, 0x79, 0x4b, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x59, 0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e,
0x6f, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x4d, 0x75, 0x6c, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a,
0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b,
0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x938, 0x930, 0x903, 0x3b, 0x938, 0x94b, 0x92e, 0x935,
0x93e, 0x938, 0x930, 0x903, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935, 0x93e, 0x938, 0x930, 0x903, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e,
0x938, 0x930, 0x903, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x938, 0x930, 0x3a, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935,
0x93e, 0x938, 0x930, 0x903, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x938, 0x930, 0x903, 0x1c65, 0x1c64, 0x1c78, 0x1c5c, 0x1c6e, 0x3b, 0x1c5a,
0x1c5b, 0x1c6e, 0x3b, 0x1c75, 0x1c5f, 0x1c5e, 0x1c6e, 0x3b, 0x1c65, 0x1c5f, 0x1c79, 0x1c5c, 0x1c69, 0x1c71, 0x3b, 0x1c65, 0x1c5f, 0x1c79, 0x1c68, 0x1c6b,
0x1c64, 0x3b, 0x1c61, 0x1c5f, 0x1c79, 0x1c68, 0x1c69, 0x1c62, 0x3b, 0x1c67, 0x1c69, 0x1c66, 0x1c69, 0x1c62, 0x1c65, 0x1c64, 0x1c78, 0x3b, 0x1c5a, 0x1c5b,
0x3b, 0x1c75, 0x1c5f, 0x3b, 0x1c65, 0x1c5f, 0x1c79, 0x3b, 0x1c65, 0x1c5f, 0x1c79, 0x1c68, 0x3b, 0x1c61, 0x1c5f, 0x1c79, 0x3b, 0x1c67, 0x1c69, 0x1c65,
0x3b, 0x1c5a, 0x3b, 0x1c75, 0x3b, 0x1c65, 0x3b, 0x1c65, 0x3b, 0x1c61, 0x3b, 0x1c67, 0x44, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b,
0x43, 0x68, 0x69, 0x70, 0x6f, 0x73, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x74,
0x61, 0x74, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75, 0x3b,
0x53, 0x61, 0x62, 0x75, 0x64, 0x75, 0x44, 0x69, 0x6d, 0x3b, 0x50, 0x6f, 0x73, 0x3b, 0x50, 0x69, 0x72, 0x3b, 0x54, 0x61,
0x74, 0x3b, 0x4e, 0x61, 0x69, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x44, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x54,
0x3b, 0x4e, 0x3b, 0x53, 0x3b, 0x53, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x459,
0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432,
0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x43d, 0x435, 0x434,
0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441, 0x440, 0x435, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f, 0x435, 0x442,
0x3b, 0x441, 0x443, 0x431, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x65, 0x3b,
0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70,
0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x65,
0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75,
0x62, 0x6f, 0x74, 0x61, 0x43d, 0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430,
0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442,
0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x6e, 0x65,
0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74,
0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x69, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61,
0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x70,
0x69, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6e, 0x65,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b,
0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x4a, 0x70, 0x69, 0x3b,
0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6d, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b,
0x4a, 0x6d, 0x6f, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x31, 0x53, 0x76, 0x6f, 0x6e,
0x64, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x68, 0x75, 0x72, 0x6f, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43,
0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e,
0x75, 0x3b, 0x4d, 0x75, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x53, 0x76, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x3b, 0x43, 0x68,
0x70, 0x3b, 0x43, 0x68, 0x74, 0x3b, 0x43, 0x68, 0x6e, 0x3b, 0x43, 0x68, 0x73, 0x3b, 0x4d, 0x75, 0x67, 0x53, 0x3b, 0x4d,
0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4d, 0xa46d, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa282, 0xa2cd, 0x3b, 0xa18f, 0xa282,
0xa44d, 0x3b, 0xa18f, 0xa282, 0xa315, 0x3b, 0xa18f, 0xa282, 0xa1d6, 0x3b, 0xa18f, 0xa282, 0xa26c, 0x3b, 0xa18f, 0xa282, 0xa0d8, 0xa46d, 0xa18f, 0x3b,
0xa18f, 0xa2cd, 0x3b, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa315, 0x3b, 0xa18f, 0xa1d6, 0x3b, 0xa18f, 0xa26c, 0x3b, 0xa18f, 0xa0d8, 0xa18f, 0x3b, 0xa2cd,
0x3b, 0xa44d, 0x3b, 0xa315, 0x3b, 0xa1d6, 0x3b, 0xa26c, 0x3b, 0xa0d8, 0x622, 0x686, 0x631, 0x3b, 0x633, 0x648, 0x645, 0x631, 0x3b, 0x627,
0x6b1, 0x627, 0x631, 0x648, 0x3b, 0x627, 0x631, 0x628, 0x639, 0x3b, 0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x62c, 0x645, 0x639, 0x648, 0x3b,
0x687, 0x646, 0x687, 0x631, 0x622, 0x686, 0x631, 0x3b, 0x633, 0x648, 0x3b, 0x627, 0x6b1, 0x627, 0x631, 0x648, 0x3b, 0x627, 0x631, 0x628,
0x639, 0x3b, 0x62e, 0x645, 0x3b, 0x62c, 0x645, 0x639, 0x648, 0x3b, 0x687, 0x646, 0x687, 0x631, 0x906, 0x930, 0x94d, 0x924, 0x3b, 0x938,
0x942, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x935, 0x93f, 0x938, 0x3b, 0x91c, 0x941, 0x92e, 0x3b, 0x91b, 0x902, 0x91b,
0x906, 0x930, 0x94d, 0x924, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x942, 0x92e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x941, 0x3b, 0x92c,
0x941, 0x927, 0x930, 0x3b, 0x935, 0x93f, 0x938, 0x94d, 0x92a, 0x924, 0x3b, 0x91c, 0x941, 0x92e, 0x913, 0x3b, 0x91b, 0x902, 0x91b, 0x930,
0x906, 0x3b, 0x938, 0x942, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x935, 0x93f, 0x938, 0x94d, 0x3b, 0x91c, 0x941, 0x92e,
0x3b, 0x91b, 0x902, 0x91b, 0x906, 0x930, 0x94d, 0x924, 0x3b, 0x938, 0x942, 0x3b, 0x92e, 0x902, 0x917, 0x3b, 0x92c, 0x941, 0x927, 0x3b,
0x935, 0x93f, 0x938, 0x3b, 0x91c, 0x941, 0x92e, 0x3b, 0x91b, 0x902, 0x91b, 0x906, 0x3b, 0x938, 0x942, 0x3b, 0x92e, 0x902, 0x3b, 0x92c,
0x941, 0x3b, 0x935, 0x93f, 0x3b, 0x936, 0x941, 0x3b, 0x91b, 0x902, 0x906, 0x3b, 0x92e, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b,
0x935, 0x93f, 0x3b, 0x936, 0x941, 0x3b, 0x91b, 0x902, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf, 0x3b,
0xd85, 0xd9f, 0xdc4, 0xdbb, 0xdd4, 0xdc0, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb,
0xdc4, 0xdc3, 0xdca, 0xdb4, 0xdad, 0xdd2, 0xdb1, 0xdca, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd2, 0xd9a, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b,
0xdc3, 0xdd9, 0xdb1, 0xdc3, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf,
0x3b, 0xd85, 0xd9f, 0xdc4, 0x3b, 0xdb6, 0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3, 0xdca, 0x3b, 0xdc3,
0xdd2, 0xd9a, 0xdd4, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0xd89, 0x3b, 0xdc3, 0x3b, 0xd85, 0x3b, 0xdb6, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0x3b,
0xdc3, 0xdd2, 0x3b, 0xdc3, 0xdd9, 0x6e, 0x65, 0x64, 0x65, 0x13e, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x65, 0x6c, 0x6f, 0x6b,
0x3b, 0x75, 0x74, 0x6f, 0x72, 0x6f, 0x6b, 0x3b, 0x73, 0x74, 0x72, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74, 0x76, 0x72, 0x74,
0x6f, 0x6b, 0x3b, 0x70, 0x69, 0x61, 0x74, 0x6f, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x6e, 0x65, 0x3b, 0x70,
0x6f, 0x3b, 0x75, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x161, 0x74, 0x3b, 0x70, 0x69, 0x3b, 0x73, 0x6f, 0x6e, 0x3b, 0x70, 0x3b,
0x75, 0x3b, 0x73, 0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e,
0x65, 0x64, 0x65, 0x6c, 0x6a, 0x65, 0x6b, 0x3b, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x73, 0x72, 0x65, 0x64, 0x61, 0x3b,
0x10d, 0x65, 0x74, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61,
0x6e, 0x65, 0x64, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x73, 0x72, 0x65, 0x2e, 0x3b,
0x10d, 0x65, 0x74, 0x2e, 0x3b, 0x70, 0x65, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x6e, 0x3b, 0x70, 0x3b, 0x74, 0x3b,
0x73, 0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x53, 0x61, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x7a,
0x61, 0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x73, 0x61, 0x74,
0x75, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x74, 0x61, 0x61, 0x6e, 0x75,
0x3b, 0x4f, 0x6c, 0x6f, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x53, 0x61, 0x62, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61,
0x3b, 0x4b, 0x75, 0x62, 0x69, 0x3b, 0x4b, 0x75, 0x73, 0x61, 0x3b, 0x4b, 0x75, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x74, 0x61,
0x3b, 0x4d, 0x75, 0x6b, 0x61, 0x53, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4d, 0x41, 0x78,
0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61, 0x64, 0x6f, 0x3b, 0x41, 0x72,
0x62, 0x61, 0x63, 0x6f, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x3b, 0x4a, 0x69, 0x6d, 0x63, 0x6f, 0x3b, 0x53,
0x61, 0x62, 0x74, 0x69, 0x41, 0x78, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b, 0x54, 0x6c, 0x64, 0x6f, 0x3b, 0x41, 0x72, 0x62,
0x63, 0x3b, 0x4b, 0x68, 0x6d, 0x73, 0x3b, 0x4a, 0x6d, 0x63, 0x3b, 0x53, 0x62, 0x74, 0x69, 0x41, 0x3b, 0x49, 0x3b, 0x54,
0x3b, 0x41, 0x3b, 0x4b, 0x68, 0x3b, 0x4a, 0x3b, 0x53, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e,
0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b,
0x6a, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64,
0x6f, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0xe9, 0x3b, 0x6a, 0x75, 0x65,
0x3b, 0x76, 0x69, 0x65, 0x3b, 0x73, 0xe1, 0x62, 0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61,
0x72, 0x2e, 0x3b, 0x6d, 0x69, 0xe9, 0x2e, 0x3b, 0x6a, 0x75, 0x65, 0x2e, 0x3b, 0x76, 0x69, 0x65, 0x2e, 0x3b, 0x73, 0xe1,
0x62, 0x2e, 0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30,
0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30,
0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62, 0x2d30, 0x2d59, 0x2d30, 0x2d59, 0x2d30, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x3b, 0x2d30, 0x2d59, 0x2d49,
0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x4d, 0x69,
0x6e, 0x67, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x6e, 0xe9, 0x6e, 0x3b, 0x53, 0x61, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x65,
0x62, 0x6f, 0x3b, 0x4b, 0x65, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x68, 0x3b, 0x53, 0x61, 0x70, 0x74,
0x75, 0x4d, 0x6e, 0x67, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x61, 0x6c, 0x3b, 0x52, 0x65, 0x62, 0x3b, 0x4b, 0x65, 0x6d,
0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x70, 0x73, 0xf6, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61,
0x67, 0x3b, 0x74, 0x69, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73,
0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf6, 0x72, 0x64, 0x61, 0x67, 0x73, 0xf6, 0x6e,
0x3b, 0x6d, 0xe5, 0x6e, 0x3b, 0x74, 0x69, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x3b, 0x66, 0x72,
0x65, 0x3b, 0x6c, 0xf6, 0x72, 0x53, 0x75, 0x6e, 0x6e, 0x74, 0x69, 0x67, 0x3b, 0x4d, 0xe4, 0xe4, 0x6e, 0x74, 0x69, 0x67,
0x3b, 0x5a, 0x69, 0x69, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x75, 0x63, 0x68, 0x3b,
0x44, 0x75, 0x6e, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x46, 0x72, 0x69, 0x69, 0x74, 0x69, 0x67, 0x3b, 0x53, 0x61,
0x6d, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0xe4, 0x2e, 0x3b, 0x5a, 0x69, 0x2e, 0x3b, 0x4d,
0x69, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30, 0x2d59,
0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59, 0x3b,
0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62, 0x2d30, 0x2d59,
0x61, 0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x61, 0x79, 0x6e, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b,
0x61, 0x6b, 0x1e5b, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x77, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b,
0x61, 0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x61, 0x73, 0x61, 0x3b, 0x61, 0x79, 0x6e, 0x3b, 0x61, 0x73, 0x69, 0x3b, 0x61,
0x6b, 0x1e5b, 0x3b, 0x61, 0x6b, 0x77, 0x3b, 0x61, 0x73, 0x69, 0x6d, 0x3b, 0x61, 0x73, 0x69, 0x1e0d, 0x49, 0x74, 0x75, 0x6b,
0x75, 0x20, 0x6a, 0x61, 0x20, 0x6a, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20,
0x6a, 0x69, 0x6d, 0x77, 0x65, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x77,
0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4b, 0x75,
0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61,
0x20, 0x6b, 0x61, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x69, 0x66, 0x75, 0x6c, 0x61, 0x20, 0x6e, 0x67, 0x75, 0x77, 0x6f,
0x4a, 0x75, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b, 0x61, 0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b,
0x4b, 0x61, 0x73, 0x3b, 0x4e, 0x67, 0x75, 0x4a, 0x3b, 0x4a, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4e,
0x42f, 0x43a, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x414, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x421, 0x435, 0x448, 0x430,
0x43d, 0x431, 0x435, 0x3b, 0x427, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x41f, 0x430, 0x43d, 0x4b7, 0x448, 0x430, 0x43d,
0x431, 0x435, 0x3b, 0x4b6, 0x443, 0x43c, 0x44a, 0x430, 0x3b, 0x428, 0x430, 0x43d, 0x431, 0x435, 0x42f, 0x448, 0x431, 0x3b, 0x414, 0x448,
0x431, 0x3b, 0x421, 0x448, 0x431, 0x3b, 0x427, 0x448, 0x431, 0x3b, 0x41f, 0x448, 0x431, 0x3b, 0x4b6, 0x43c, 0x44a, 0x3b, 0x428, 0x43d,
0x431, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x4b6, 0x3b, 0x428, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0xbb1, 0xbc1,
0x3b, 0xba4, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbb5, 0xbcd, 0xbb5, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0xbaa, 0xbc1,
0xba4, 0xba9, 0xbcd, 0x3b, 0xbb5, 0xbbf, 0xbaf, 0xbbe, 0xbb4, 0xba9, 0xbcd, 0x3b, 0xbb5, 0xbc6, 0xbb3, 0xbcd, 0xbb3, 0xbbf, 0x3b, 0xb9a,
0xba9, 0xbbf, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0x2e, 0x3b, 0xba4, 0xbbf, 0xb99, 0xbcd, 0x2e, 0x3b, 0xb9a, 0xbc6, 0xbb5, 0xbcd, 0x2e, 0x3b,
0xbaa, 0xbc1, 0xba4, 0x2e, 0x3b, 0xbb5, 0xbbf, 0xbaf, 0xbbe, 0x2e, 0x3b, 0xbb5, 0xbc6, 0xbb3, 0xbcd, 0x2e, 0x3b, 0xb9a, 0xba9, 0xbbf,
0xb9e, 0xbbe, 0x3b, 0xba4, 0xbbf, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xbaa, 0xbc1, 0x3b, 0xbb5, 0xbbf, 0x3b, 0xbb5, 0xbc6, 0x3b, 0xb9a, 0x44f,
0x43a, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x434, 0x4af, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x441, 0x438, 0x448, 0x4d9, 0x43c,
0x431, 0x435, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x43f, 0x4d9, 0x43d, 0x497, 0x435, 0x448, 0x4d9, 0x43c,
0x431, 0x435, 0x3b, 0x497, 0x43e, 0x43c, 0x433, 0x430, 0x3b, 0x448, 0x438, 0x43c, 0x431, 0x4d9, 0x44f, 0x43a, 0x448, 0x2e, 0x3b, 0x434,
0x4af, 0x448, 0x2e, 0x3b, 0x441, 0x438, 0x448, 0x2e, 0x3b, 0x447, 0x4d9, 0x440, 0x2e, 0x3b, 0x43f, 0x4d9, 0x43d, 0x497, 0x2e, 0x3b,
0x497, 0x43e, 0x43c, 0x2e, 0x3b, 0x448, 0x438, 0x43c, 0x2e, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x496,
0x3b, 0x428, 0xc06, 0xc26, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc38, 0xc4b, 0xc2e, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2e, 0xc02,
0xc17, 0xc33, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2c, 0xc41, 0xc27, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41, 0xc35,
0xc3e, 0xc30, 0xc02, 0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc36, 0xc28, 0xc3f, 0xc35, 0xc3e, 0xc30,
0xc02, 0xc06, 0xc26, 0xc3f, 0x3b, 0xc38, 0xc4b, 0xc2e, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0x3b, 0xc2c, 0xc41, 0xc27, 0x3b, 0xc17, 0xc41,
0xc30, 0xc41, 0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0x3b, 0xc36, 0xc28, 0xc3f, 0xc06, 0x3b, 0xc38, 0xc4b, 0x3b, 0xc2e, 0x3b, 0xc2c,
0xc41, 0x3b, 0xc17, 0xc41, 0x3b, 0xc36, 0xc41, 0x3b, 0xc36, 0x4e, 0x61, 0x6b, 0x61, 0x65, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x4e,
0x61, 0x6b, 0x61, 0x65, 0x62, 0x61, 0x72, 0x61, 0x73, 0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4e,
0x61, 0x6b, 0x61, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75, 0x6e, 0x67, 0x2019, 0x6f, 0x6e, 0x3b, 0x4e, 0x61,
0x6b, 0x61, 0x6b, 0x61, 0x6e, 0x79, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x73, 0x61, 0x62, 0x69, 0x74, 0x69, 0x4a, 0x75, 0x6d,
0x3b, 0x42, 0x61, 0x72, 0x3b, 0x41, 0x61, 0x72, 0x3b, 0x55, 0x6e, 0x69, 0x3b, 0x55, 0x6e, 0x67, 0x3b, 0x4b, 0x61, 0x6e,
0x3b, 0x53, 0x61, 0x62, 0x4a, 0x3b, 0x42, 0x3b, 0x41, 0x3b, 0x55, 0x3b, 0x55, 0x3b, 0x4b, 0x3b, 0x53, 0xe27, 0xe31, 0xe19,
0xe2d, 0xe32, 0xe17, 0xe34, 0xe15, 0xe22, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe08, 0xe31, 0xe19, 0xe17, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31,
0xe19, 0xe2d, 0xe31, 0xe07, 0xe04, 0xe32, 0xe23, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe38, 0xe18, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe24,
0xe2b, 0xe31, 0xe2a, 0xe1a, 0xe14, 0xe35, 0x3b, 0xe27, 0xe31, 0xe19, 0xe28, 0xe38, 0xe01, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe40,
0xe2a, 0xe32, 0xe23, 0xe4c, 0xe2d, 0xe32, 0x2e, 0x3b, 0xe08, 0x2e, 0x3b, 0xe2d, 0x2e, 0x3b, 0xe1e, 0x2e, 0x3b, 0xe1e, 0xe24, 0x2e,
0x3b, 0xe28, 0x2e, 0x3b, 0xe2a, 0x2e, 0xe2d, 0xe32, 0x3b, 0xe08, 0x3b, 0xe2d, 0x3b, 0xe1e, 0x3b, 0xe1e, 0xe24, 0x3b, 0xe28, 0x3b,
0xe2a, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b,
0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf63, 0xfb7,
0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60,
0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0xf49,
0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b,
0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66,
0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0xf49, 0xf72, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf42, 0x3b, 0xf63,
0xfb7, 0xf42, 0x3b, 0xf55, 0xf74, 0xf62, 0x3b, 0xf66, 0xf44, 0xf66, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0x1230, 0x1295, 0x1260, 0x1275, 0x3b,
0x1230, 0x1291, 0x12ed, 0x3b, 0x1220, 0x1209, 0x1235, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1283, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1262, 0x3b,
0x1240, 0x12f3, 0x121d, 0x1230, 0x1295, 0x3b, 0x1230, 0x1291, 0x3b, 0x1230, 0x1209, 0x3b, 0x1228, 0x1261, 0x3b, 0x1213, 0x1219, 0x3b, 0x12d3, 0x122d,
0x3b, 0x1240, 0x12f3, 0x1230, 0x3b, 0x1230, 0x3b, 0x1220, 0x3b, 0x1228, 0x3b, 0x1213, 0x3b, 0x12d3, 0x3b, 0x1240, 0x1230, 0x3b, 0x1230, 0x3b,
0x1230, 0x3b, 0x1228, 0x3b, 0x1213, 0x3b, 0x12d3, 0x3b, 0x1240, 0x53, 0x101, 0x70, 0x61, 0x74, 0x65, 0x3b, 0x4d, 0x14d, 0x6e, 0x69,
0x74, 0x65, 0x3b, 0x54, 0x16b, 0x73, 0x69, 0x74, 0x65, 0x3b, 0x50, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x54,
0x75, 0x2bb, 0x61, 0x70, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x46, 0x61, 0x6c, 0x61, 0x69, 0x74, 0x65, 0x3b,
0x54, 0x6f, 0x6b, 0x6f, 0x6e, 0x61, 0x6b, 0x69, 0x53, 0x101, 0x70, 0x3b, 0x4d, 0x14d, 0x6e, 0x3b, 0x54, 0x16b, 0x73, 0x3b,
0x50, 0x75, 0x6c, 0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x3b, 0x46, 0x61, 0x6c, 0x3b, 0x54, 0x6f, 0x6b, 0x53, 0x3b, 0x4d, 0x3b,
0x54, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x54, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72,
0x74, 0x65, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x6c, 0x131, 0x3b, 0xc7, 0x61, 0x72, 0x15f, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x50,
0x65, 0x72, 0x15f, 0x65, 0x6d, 0x62, 0x65, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x72, 0x74, 0x65,
0x73, 0x69, 0x50, 0x61, 0x7a, 0x3b, 0x50, 0x7a, 0x74, 0x3b, 0x53, 0x61, 0x6c, 0x3b, 0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65,
0x72, 0x3b, 0x43, 0x75, 0x6d, 0x3b, 0x43, 0x6d, 0x74, 0x50, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0x43,
0x3b, 0x43, 0xdd, 0x65, 0x6b, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x44, 0x75, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x53,
0x69, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0xc7, 0x61, 0x72, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x50, 0x65, 0x6e, 0x15f,
0x65, 0x6e, 0x62, 0x65, 0x3b, 0x41, 0x6e, 0x6e, 0x61, 0x3b, 0x15e, 0x65, 0x6e, 0x62, 0x65, 0xfd, 0x65, 0x6b, 0x15f, 0x65,
0x6e, 0x62, 0x65, 0x3b, 0x64, 0x75, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x73, 0x69, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b,
0xe7, 0x61, 0x72, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x70, 0x65, 0x6e, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x61, 0x6e,
0x6e, 0x61, 0x3b, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0xdd, 0x65, 0x6b, 0x3b, 0x44, 0x75, 0x15f, 0x3b, 0x53, 0x69, 0x15f, 0x3b,
0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x3b, 0x41, 0x6e, 0x6e, 0x3b, 0x15e, 0x65, 0x6e, 0xfd, 0x65, 0x6b, 0x3b, 0x64,
0x75, 0x15f, 0x3b, 0x73, 0x69, 0x15f, 0x3b, 0xe7, 0x61, 0x72, 0x3b, 0x70, 0x65, 0x6e, 0x3b, 0x61, 0x6e, 0x6e, 0x3b, 0x15f,
0x65, 0x6e, 0xdd, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x15e, 0x43d, 0x435, 0x434, 0x456, 0x43b,
0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x43e, 0x43a, 0x3b, 0x432, 0x456, 0x432, 0x442, 0x43e, 0x440, 0x43e, 0x43a,
0x3b, 0x441, 0x435, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x3b, 0x43f, 0x2bc, 0x44f, 0x442, 0x43d,
0x438, 0x446, 0x44f, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x41d, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b,
0x41f, 0x3b, 0x421, 0x6e, 0x6a, 0x65, 0x64, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0xf3, 0x6e, 0x64, 0x17a, 0x65, 0x6c, 0x61,
0x3b, 0x77, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74, 0x77, 0xf3, 0x72,
0x74, 0x6b, 0x3b, 0x70, 0x6a, 0x61, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x6e, 0x6a, 0x65, 0x3b, 0x70,
0xf3, 0x6e, 0x3b, 0x77, 0x75, 0x74, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x161, 0x74, 0x77, 0x3b, 0x70, 0x6a, 0x61, 0x3b, 0x73,
0x6f, 0x62, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x73, 0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x627, 0x62a, 0x648, 0x627, 0x631,
0x3b, 0x67e, 0x6cc, 0x631, 0x3b, 0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a,
0x3b, 0x62c, 0x645, 0x639, 0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x64a, 0x6d5, 0x643, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x62f,
0x6c8, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x633, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x686, 0x627, 0x631, 0x634,
0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x67e, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x62c, 0x6c8, 0x645, 0x6d5, 0x3b, 0x634,
0x6d5, 0x646, 0x628, 0x6d5, 0x64a, 0x6d5, 0x3b, 0x62f, 0x6c8, 0x3b, 0x633, 0x6d5, 0x3b, 0x686, 0x627, 0x3b, 0x67e, 0x6d5, 0x3b, 0x62c,
0x6c8, 0x3b, 0x634, 0x6d5, 0x64a, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x62c, 0x3b, 0x634, 0x79, 0x61, 0x6b,
0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x64, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x68,
0x61, 0x6e, 0x62, 0x61, 0x3b, 0x63, 0x68, 0x6f, 0x72, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x70, 0x61, 0x79, 0x73,
0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x59, 0x61, 0x6b,
0x3b, 0x44, 0x75, 0x73, 0x68, 0x3b, 0x53, 0x65, 0x73, 0x68, 0x3b, 0x43, 0x68, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b,
0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x68, 0x61, 0x6e, 0x59, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x4a, 0x3b,
0x53, 0x6cc, 0x2e, 0x3b, 0x62f, 0x2e, 0x3b, 0x633, 0x2e, 0x3b, 0x686, 0x2e, 0x3b, 0x67e, 0x2e, 0x3b, 0x62c, 0x2e, 0x3b, 0x634,
0x2e, 0x44f, 0x43a, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x434, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x441, 0x435, 0x448,
0x430, 0x43d, 0x431, 0x430, 0x3b, 0x447, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x43f, 0x430, 0x439, 0x448, 0x430, 0x43d,
0x431, 0x430, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x44f, 0x43a, 0x448, 0x3b, 0x434, 0x443, 0x448,
0x3b, 0x441, 0x435, 0x448, 0x3b, 0x447, 0x43e, 0x440, 0x3b, 0x43f, 0x430, 0x439, 0x3b, 0x436, 0x443, 0x43c, 0x3b, 0x448, 0x430, 0x43d,
0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x416, 0x3b, 0x428, 0xa55e, 0xa54c, 0xa535, 0x3b, 0xa5f3, 0xa5e1, 0xa609,
0x3b, 0xa55a, 0xa55e, 0xa55a, 0x3b, 0xa549, 0xa55e, 0xa552, 0x3b, 0xa549, 0xa524, 0xa546, 0xa562, 0x3b, 0xa549, 0xa524, 0xa540, 0xa56e, 0x3b, 0xa53b,
0xa52c, 0xa533, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x74, 0x25b, 0x25b, 0x6e, 0x25b, 0x25b, 0x3b, 0x74, 0x61, 0x6c, 0x61,
0x74, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x69, 0x6d, 0x69, 0x73, 0x61, 0x3b, 0x61, 0x69, 0x6a, 0x69,
0x6d, 0x61, 0x3b, 0x73, 0x69, 0x253, 0x69, 0x74, 0x69, 0x43, 0x68, 0x1ee7, 0x20, 0x4e, 0x68, 0x1ead, 0x74, 0x3b, 0x54, 0x68,
0x1ee9, 0x20, 0x48, 0x61, 0x69, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x42, 0x61, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x54, 0x1b0, 0x3b,
0x54, 0x68, 0x1ee9, 0x20, 0x4e, 0x103, 0x6d, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x53, 0xe1, 0x75, 0x3b, 0x54, 0x68, 0x1ee9, 0x20,
0x42, 0x1ea3, 0x79, 0x43, 0x4e, 0x3b, 0x54, 0x68, 0x20, 0x32, 0x3b, 0x54, 0x68, 0x20, 0x33, 0x3b, 0x54, 0x68, 0x20, 0x34,
0x3b, 0x54, 0x68, 0x20, 0x35, 0x3b, 0x54, 0x68, 0x20, 0x36, 0x3b, 0x54, 0x68, 0x20, 0x37, 0x43, 0x4e, 0x3b, 0x54, 0x32,
0x3b, 0x54, 0x33, 0x3b, 0x54, 0x34, 0x3b, 0x54, 0x35, 0x3b, 0x54, 0x36, 0x3b, 0x54, 0x37, 0x53, 0x75, 0x6e, 0x6e, 0x74,
0x61, 0x67, 0x3b, 0x4d, 0xe4, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x5a, 0x69, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x74,
0x74, 0x77, 0x75, 0x10d, 0x3b, 0x46, 0x72, 0xf3, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x69, 0x74, 0x61, 0x67, 0x3b,
0x53, 0x61, 0x6d, 0x161, 0x74, 0x61, 0x67, 0x53, 0x75, 0x6e, 0x3b, 0x4d, 0xe4, 0x6e, 0x3b, 0x5a, 0x69, 0x161, 0x3b, 0x4d,
0x69, 0x74, 0x3b, 0x46, 0x72, 0xf3, 0x3b, 0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x6d, 0x53, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b,
0x4d, 0x3b, 0x46, 0x3b, 0x46, 0x3b, 0x53, 0x44, 0x79, 0x64, 0x64, 0x20, 0x53, 0x75, 0x6c, 0x3b, 0x44, 0x79, 0x64, 0x64,
0x20, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 0x3b, 0x44, 0x79,
0x64, 0x64, 0x20, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x49, 0x61, 0x75, 0x3b,
0x44, 0x79, 0x64, 0x64, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x53, 0x61, 0x64,
0x77, 0x72, 0x6e, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72, 0x3b,
0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b,
0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x3b, 0x53, 0x61, 0x64,
0x53, 0x3b, 0x4c, 0x6c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x47, 0x3b, 0x53, 0x73, 0x6e, 0x65, 0x69, 0x6e, 0x3b,
0x6d, 0x6f, 0x61, 0x6e, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x77, 0x6f, 0x61, 0x6e,
0x73, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x66, 0x72, 0x65, 0x65,
0x64, 0x3b, 0x73, 0x6e, 0x65, 0x6f, 0x6e, 0x73, 0x69, 0x3b, 0x6d, 0x6f, 0x3b, 0x74, 0x69, 0x3b, 0x77, 0x6f, 0x3b, 0x74,
0x6f, 0x3b, 0x66, 0x72, 0x3b, 0x73, 0x6f, 0x44, 0x69, 0x62, 0xe9, 0x65, 0x72, 0x3b, 0x41, 0x6c, 0x74, 0x69, 0x6e, 0x65,
0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0xc0, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x78, 0x61,
0x6d, 0x69, 0x73, 0x3b, 0xc0, 0x6a, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x65, 0x65, 0x72, 0x44, 0x69, 0x62, 0x3b,
0x41, 0x6c, 0x74, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0xc0, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x78, 0x3b, 0xc0, 0x6a, 0x6a, 0x3b,
0x41, 0x73, 0x65, 0x43, 0x61, 0x77, 0x65, 0x3b, 0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62,
0x69, 0x6e, 0x69, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x73,
0x69, 0x6e, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62,
0x65, 0x6c, 0x6f, 0x43, 0x61, 0x77, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x42, 0x69, 0x6e, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53,
0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x67, 0x71, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x25b, 0x3b, 0x6d, 0xf3,
0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d, 0x75, 0xe1, 0x6e, 0x79, 0xe1, 0x14b, 0x6d, 0xf3, 0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d,
0x65, 0x74, 0xfa, 0x6b, 0x70, 0xed, 0xe1, 0x70, 0x25b, 0x3b, 0x6b, 0xfa, 0x70, 0xe9, 0x6c, 0x69, 0x6d, 0x65, 0x74, 0xfa,
0x6b, 0x70, 0x69, 0x61, 0x70, 0x25b, 0x3b, 0x66, 0x65, 0x6c, 0xe9, 0x74, 0x65, 0x3b, 0x73, 0xe9, 0x73, 0x65, 0x6c, 0xe9,
0x73, 0x64, 0x3b, 0x6d, 0x64, 0x3b, 0x6d, 0x77, 0x3b, 0x65, 0x74, 0x3b, 0x6b, 0x6c, 0x3b, 0x66, 0x6c, 0x3b, 0x73, 0x73,
0x73, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x73, 0x5d6, 0x5d5, 0x5e0, 0x5d8, 0x5d9, 0x5e7, 0x3b,
0x5de, 0x5d0, 0x5b8, 0x5e0, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5d3, 0x5d9, 0x5e0, 0x5e1, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5de, 0x5d9, 0x5d8, 0x5d5,
0x5d5, 0x5d0, 0x5da, 0x3b, 0x5d3, 0x5d0, 0x5e0, 0x5e2, 0x5e8, 0x5e9, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5e4, 0x5bf, 0x5e8, 0x5f2, 0x5b7, 0x5d8,
0x5d9, 0x5e7, 0x3b, 0x5e9, 0x5d1, 0x5ea, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc, 0x73, 0x1eb9, 0x301, 0x67,
0x75, 0x6e, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1eb8, 0x74, 0xec,
0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x1ecc,
0x6a, 0x1ecd, 0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e,
0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20,
0x1eb8, 0x74, 0xec, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0xc0, 0xec, 0x6b,
0x3b, 0x41, 0x6a, 0x3b, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301,
0x62, 0x3b, 0x1eb8, 0x74, 0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0xc0, 0x3b, 0x41, 0x3b, 0xcc, 0x3b, 0x1ecc, 0x3b, 0x1ecc, 0x3b, 0x1eb8,
0x3b, 0xc0, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x186,
0x6a, 0x254, 0x301, 0x72, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x190, 0x74, 0xec, 0x3b, 0xc0, 0x62, 0xe1,
0x6d, 0x25b, 0x301, 0x74, 0x61, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20,
0x41, 0x6a, 0xe9, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x186, 0x6a, 0x254,
0x301, 0x72, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0x190, 0x74, 0xec, 0x3b,
0x186, 0x6a, 0x254, 0x301, 0x20, 0xc0, 0x62, 0xe1, 0x6d, 0x25b, 0x301, 0x74, 0x61, 0xc0, 0xec, 0x6b, 0x3b, 0x41, 0x6a, 0x3b,
0xcc, 0x73, 0x25b, 0x301, 0x67, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x3b, 0x190, 0x74,
0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0xc0, 0x3b, 0x41, 0x3b, 0xcc, 0x3b, 0x186, 0x3b, 0x186, 0x3b, 0x190, 0x3b, 0xc0, 0x41, 0x6c,
0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61,
0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x41, 0x6c, 0x7a,
0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x48, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b,
0x5a, 0x3b, 0x53, 0x49, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x55, 0x4d, 0x73, 0x6f, 0x6d, 0x62, 0x75, 0x6c, 0x75, 0x6b,
0x6f, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x74,
0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73,
0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x55, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x53, 0x6f, 0x6e, 0x3b,
0x4d, 0x73, 0x6f, 0x3b, 0x42, 0x69, 0x6c, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61, 0x3b,
0x4d, 0x67, 0x71, 0x53, 0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x48, 0x3b, 0x4d
};

static const char16_t byte_unit_data[] = {
0x62, 0x79, 0x74, 0x65, 0x73, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b,
0x45, 0x42, 0x4b, 0x69, 0x42, 0x3b, 0x4d, 0x69, 0x42, 0x3b, 0x47, 0x69, 0x42, 0x3b, 0x54, 0x69, 0x42, 0x3b, 0x50, 0x69,
0x42, 0x3b, 0x45, 0x69, 0x42, 0x67, 0x72, 0x65, 0x65, 0x70, 0x62, 0x61, 0x6a, 0x74, 0x1263, 0x12ed, 0x1275, 0x12aa, 0x1263, 0x3b,
0x121c, 0x130b, 0x1263, 0x12ed, 0x1275, 0x3b, 0x130a, 0x1263, 0x3b, 0x1274, 0x122b, 0x1263, 0x12ed, 0x1275, 0x3b, 0x1354, 0x1263, 0x3b, 0x45, 0x42,
0x628, 0x627, 0x64a, 0x62a, 0x643, 0x64a, 0x644, 0x648, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x645, 0x64a, 0x63a, 0x627, 0x628, 0x627, 0x64a,
0x62a, 0x3b, 0x63a, 0x64a, 0x63a, 0x627, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x62a, 0x64a, 0x631, 0x627, 0x628, 0x627, 0x64a, 0x62a, 0x3b,
0x628, 0x64a, 0x62a, 0x627, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x45, 0x42, 0x562, 0x561, 0x575, 0x569, 0x565, 0x580, 0x56f, 0x532, 0x3b,
0x544, 0x532, 0x3b, 0x533, 0x532, 0x3b, 0x54f, 0x532, 0x3b, 0x54a, 0x532, 0x3b, 0x45, 0x42, 0x9ac, 0x9be, 0x987, 0x99f, 0x995, 0x9bf,
0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x9ae, 0x9c7, 0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x997, 0x9bf, 0x983, 0x20, 0x9ac, 0x9be,
0x983, 0x3b, 0x99f, 0x9c7, 0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x62, 0x61, 0x79, 0x74, 0x62,
0x79, 0x74, 0x65, 0x2d, 0x61, 0x6b, 0x431, 0x430, 0x439, 0x442, 0x44b, 0x41a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x413, 0x411, 0x3b,
0x422, 0x411, 0x3b, 0x41f, 0x411, 0x3b, 0x45, 0x42, 0x62, 0x61, 0x6a, 0x74, 0x6f, 0x76, 0x69, 0x6f, 0x6b, 0x74, 0x65, 0x64,
0x6f, 0xf9, 0x6b, 0x6f, 0x3b, 0x4d, 0x6f, 0x3b, 0x47, 0x6f, 0x3b, 0x54, 0x6f, 0x3b, 0x50, 0x6f, 0x3b, 0x45, 0x6f, 0x4b,
0x69, 0x6f, 0x3b, 0x4d, 0x69, 0x6f, 0x3b, 0x47, 0x69, 0x6f, 0x3b, 0x54, 0x69, 0x6f, 0x3b, 0x50, 0x69, 0x6f, 0x3b, 0x45,
0x69, 0x6f, 0x431, 0x430, 0x439, 0x442, 0x43e, 0x432, 0x435, 0x1018, 0x102d, 0x102f, 0x1000, 0x103a, 0x6d, 0x67, 0x61, 0x20, 0x62, 0x79,
0x74, 0x65, 0xd804, 0xdd1d, 0xd804, 0xdd2d, 0xd804, 0xdd16, 0xd804, 0xdd34, 0x13d7, 0x13d3, 0x13cd, 0x13a6, 0x13b5, 0x13a9, 0x5b57, 0x8282, 0x4f4d, 0x5143,
0x7d44, 0x62, 0x61, 0x6a, 0x74, 0x79, 0x62, 0x61, 0x6a, 0x74, 0x6f, 0x6a, 0x62, 0x61, 0x69, 0x64, 0x69, 0x64, 0x62, 0xfd,
0x74, 0x74, 0x61, 0x76, 0x75, 0x74, 0x6b, 0x74, 0x3b, 0x4d, 0x74, 0x3b, 0x47, 0x74, 0x3b, 0x54, 0x74, 0x3b, 0x50, 0x74,
0x3b, 0x45, 0x74, 0x4b, 0x69, 0x74, 0x3b, 0x4d, 0x69, 0x74, 0x3b, 0x47, 0x69, 0x74, 0x3b, 0x54, 0x69, 0x74, 0x3b, 0x50,
0x69, 0x74, 0x3b, 0x45, 0x69, 0x74, 0x6f, 0x63, 0x74, 0x65, 0x74, 0x73, 0xd83a, 0xdd36, 0xd83a, 0xdd2b, 0xd83a, 0xdd45, 0xd83a, 0xdd3c,
0xd83a, 0xdd46, 0xd83a, 0xdd2d, 0xd83a, 0xdd33, 0xd83a, 0xdd14, 0x3b, 0xd83a, 0xdd03, 0xd83a, 0xdd14, 0x3b, 0xd83a, 0xdd18, 0xd83a, 0xdd14, 0x3b, 0xd83a,
0xdd1a, 0xd83a, 0xdd14, 0x3b, 0xd83a, 0xdd06, 0xd83a, 0xdd14, 0x3b, 0x45, 0x42, 0x62, 0x61, 0x69, 0x64, 0x68, 0x74, 0x10d1, 0x10d0, 0x10d8,
0x10e2, 0x10d8, 0x10d9, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x10db, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x10d2, 0x10d1, 0x10d0, 0x10d8,
0x10e2, 0x10d8, 0x3b, 0x10e2, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x10de, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x45, 0x42, 0x42,
0x79, 0x74, 0x65, 0x73, 0xaac, 0xabe, 0xa87, 0xa9f, 0x6b, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d, 0x42, 0x20, 0x7b, 0x30,
0x7d, 0x3b, 0x47, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x54, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x42, 0x20, 0x7b,
0x30, 0x7d, 0x3b, 0x45, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x4b, 0x69, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d, 0x69, 0x42,
0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x69, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x54, 0x69, 0x42, 0x20, 0x7b, 0x30, 0x7d,
0x3b, 0x50, 0x69, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x45, 0x69, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x5d1, 0x5d9, 0x5d9, 0x5d8,
0x92c, 0x93e, 0x907, 0x91f, 0x62, 0xe1, 0x6a, 0x74, 0x62, 0xe6, 0x74, 0x69, 0x62, 0x65, 0x61, 0x72, 0x74, 0x61, 0x30d0, 0x30a4,
0x30c8, 0x4b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x62, 0x69,
0x74, 0x65, 0x61, 0x1e6d, 0x61, 0x6d, 0x1e0d, 0x61, 0x6e, 0x6b, 0x41, 0x1e6c, 0x3b, 0x4d, 0x41, 0x1e6c, 0x3b, 0x47, 0x41, 0x1e6c,
0x3b, 0x54, 0x41, 0x1e6c, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xcac, 0xcc8, 0xc9f, 0xccd, 0x200c, 0xc97, 0xcb3, 0xcc1, 0xc95, 0xcbf,
0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xcae, 0xcc6, 0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xc97, 0xcbf, 0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xc9f,
0xcc6, 0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xcaa, 0xcc6, 0xcac, 0xcc8, 0x3b, 0x45, 0x42, 0x43a, 0x411, 0x3b, 0x4d, 0x411, 0x3b, 0x413,
0x411, 0x3b, 0x54, 0x411, 0x3b, 0x41f, 0x411, 0x3b, 0x45, 0x411, 0x4b, 0x69, 0x411, 0x3b, 0x4d, 0x69, 0x411, 0x3b, 0x47, 0x69,
0x411, 0x3b, 0x54, 0x69, 0x411, 0x3b, 0x50, 0x69, 0x411, 0x3b, 0x45, 0x69, 0x411, 0x1794, 0x17c3, 0x92c, 0x93e, 0x92f, 0x91f, 0xbc14,
0xc774, 0xd2b8, 0x43a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x413, 0x411, 0x3b, 0x422, 0x411, 0x3b, 0x41f, 0x442, 0x431, 0x3b, 0x45, 0x42,
0x62, 0x61, 0x69, 0x74, 0x69, 0x62, 0x61, 0x69, 0x74, 0x61, 0x69, 0x431, 0x430, 0x458, 0x442, 0x438, 0xd2c, 0xd48, 0xd31, 0xd4d,
0xd31, 0xd4d, 0xd15, 0xd46, 0xd2c, 0xd3f, 0x3b, 0xd0e, 0xd02, 0xd2c, 0xd3f, 0x3b, 0xd1c, 0xd3f, 0xd2c, 0xd3f, 0x3b, 0xd1f, 0xd3f, 0xd2c,
0xd3f, 0x3b, 0xd2a, 0xd3f, 0xd2c, 0xd3f, 0x3b, 0x45, 0x42, 0x628, 0x627, 0x6cc, 0x62a, 0x6a9, 0x6cc, 0x644, 0x648, 0x628, 0x627, 0x6cc,
0x62a, 0x3b, 0x645, 0x6af, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x6af, 0x6cc, 0x6af, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x62a,
0x631, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x43a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x413, 0x411,
0x3b, 0x422, 0x411, 0x3b, 0x41f, 0x411, 0x3b, 0x45, 0x42, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42,
0x3b, 0x92a, 0x93f, 0x91f, 0x93e, 0x3b, 0x45, 0x42, 0x42, 0x61, 0x69, 0x74, 0x2d, 0x64, 0x1eb9, 0x6d, 0xb2c, 0xb3e, 0xb07, 0xb1f,
0xb4d, 0x628, 0x627, 0x64a, 0x67c, 0x633, 0x3c, 0x4c, 0x52, 0x4d, 0x3e, 0x6b, 0x42, 0x3b, 0x3c, 0x4c, 0x52, 0x4d, 0x3e, 0x4d,
0x42, 0x3b, 0x3c, 0x4c, 0x52, 0x4d, 0x3e, 0x47, 0x42, 0x3b, 0x3c, 0x4c, 0x52, 0x4d, 0x3e, 0x54, 0x42, 0x3b, 0x3c, 0x4c,
0x52, 0x4d, 0x3e, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xa2c, 0xa3e, 0xa07, 0xa1f, 0x62, 0x79, 0x21b, 0x69, 0x431, 0x430, 0x430, 0x439,
0x442, 0x43a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x431, 0x430,
0x458, 0x442, 0x43e, 0x432, 0x438, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x632, 0x6aa, 0x644, 0x648, 0x20, 0x628, 0x627, 0x626, 0x64a, 0x67d,
0x632, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xdb6, 0xdba, 0xdd2, 0xda7,
0xdca, 0xd9a, 0xdd2, 0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xdb8, 0xdd9, 0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xd9c, 0xdd2, 0xdb6,
0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xda7, 0xdd9, 0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x20, 0x7b, 0x30, 0x7d,
0x3b, 0x45, 0x42, 0x62, 0x65, 0x79, 0x74, 0x69, 0x73, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42,
0x3b, 0x42, 0x42, 0x3b, 0x45, 0x42, 0x6b, 0x69, 0x6c, 0x6f, 0x62, 0x61, 0x69, 0x74, 0x69, 0x20, 0x7b, 0x30, 0x7d, 0x3b,
0x4d, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x74, 0x65, 0x72, 0x61, 0x62, 0x61,
0x69, 0x74, 0x69, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x45, 0x42, 0xbaa, 0xbc8, 0xb9f,
0xbcd, 0xb95, 0xbb3, 0xbcd, 0xc2c, 0xc48, 0xc1f, 0xc4d, 0x200c, 0xc32, 0xc41, 0xc15, 0xc47, 0xc2c, 0xc40, 0x3b, 0xc0e, 0xc2e, 0xc4d, 0x200c,
0xc2c, 0xc3f, 0x3b, 0xc1c, 0xc40, 0xc2c, 0xc40, 0x3b, 0xc1f, 0xc40, 0xc2c, 0xc40, 0x3b, 0xc2a, 0xc40, 0xc2c, 0xc40, 0x3b, 0x45, 0x42,
0xe44, 0xe1a, 0xe15, 0xe4c, 0x70, 0x61, 0x69, 0x74, 0x69, 0x6b, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d,
0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x54,
0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x45,
0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x4b, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d,
0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d,
0x3b, 0x54, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b,
0x30, 0x7d, 0x3b, 0x45, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x62, 0x61, 0xfd, 0x74, 0x431, 0x430, 0x439,
0x442, 0x438, 0x62, 0x79, 0x74, 0x65, 0x79, 0x628, 0x627, 0x626, 0x679, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b,
0x54, 0x42, 0x3b, 0x67e, 0x6cc, 0x20, 0x628, 0x6cc, 0x3b, 0x45, 0x42, 0x62, 0x65, 0x69, 0x74, 0x69, 0x61, 0x75, 0xe0, 0x77,
0x1ecd, 0x301, 0x6e, 0x20, 0x62, 0xe1, 0xec, 0x74, 0xec, 0x6b, 0xe9, 0x62, 0xe1, 0xec, 0x74, 0xec, 0x3b, 0x4d, 0x42, 0x3b,
0x6a, 0xed, 0x62, 0xe1, 0xec, 0x74, 0xec, 0x3b, 0x54, 0xed, 0x62, 0xe1, 0xec, 0x74, 0xec, 0x3b, 0x50, 0xed, 0x62, 0xe1,
0xec, 0x74, 0xec, 0x3b, 0x45, 0x42, 0xe0, 0x77, 0x254, 0x301, 0x6e, 0x20, 0x62, 0xe1, 0xec, 0x74, 0xec
};

static const char16_t am_data[] = {
0x41, 0x4d, 0x76, 0x6d, 0x2e, 0x61, 0x2e, 0x67, 0x41, 0x4e, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x64, 0x69, 0x74, 0x65,
0x73, 0x1325, 0x12cb, 0x1275, 0x635, 0x9aa, 0x9c2, 0x9f0, 0x9cd, 0x9ac, 0x9be, 0x9b9, 0x9cd, 0x9a8, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x20,
0x6d, 0x61, 0xf1, 0x61, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x65, 0x68, 0x65, 0x61, 0x76, 0x6f, 0x410, 0x41c, 0x73, 0xe1, 0x72,
0xfa, 0x77, 0xe1, 0x49, 0x20, 0x62, 0x69, 0x6b, 0x25b, 0x302, 0x67, 0x6c, 0xe0, 0x75, 0x6c, 0x75, 0x63, 0x68, 0x65, 0x6c,
0x6f, 0x70, 0x61, 0x6d, 0x69, 0x6c, 0x61, 0x75, 0x92b, 0x941, 0x902, 0x70, 0x72, 0x69, 0x6a, 0x65, 0x70, 0x6f, 0x64, 0x6e,
0x65, 0x43f, 0x440, 0x438, 0x458, 0x435, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x41, 0x2e, 0x4d, 0x2e, 0x43f, 0x440, 0x2e, 0x43e,
0x431, 0x2e, 0x1014, 0x1036, 0x1014, 0x1000, 0x103a, 0x4e0a, 0x5348, 0x61, 0x2e, 0xa0, 0x6d, 0x2e, 0x5a, 0x64, 0x61, 0x74, 0x20, 0x61,
0x7a, 0x61, 0x6c, 0x628, 0x2e, 0x646, 0x13cc, 0x13be, 0x13b4, 0x55, 0x68, 0x72, 0x20, 0x76, 0xf6, 0x72, 0x6d, 0x69, 0x64, 0x64,
0x61, 0x61, 0x63, 0x68, 0x73, 0x61, 0x2e, 0x6d, 0x2e, 0x64, 0x6f, 0x70, 0x2e, 0x938, 0x935, 0x947, 0x930, 0x69, 0x64, 0x69,
0x253, 0x61, 0xf66, 0xf94, 0xf0b, 0xf46, 0xf0b, 0x4b, 0x49, 0x61, 0x74, 0x6d, 0x14b, 0x64, 0x69, 0x6b, 0xed, 0x6b, 0xed, 0x72,
0xed, 0x67, 0x61, 0x70, 0x2e, 0x6d, 0x61, 0x74, 0x69, 0x6e, 0x73, 0x75, 0x62, 0x61, 0x6b, 0x61, 0xd83a, 0xdd00, 0xd83a, 0xdd0e,
0x3c0, 0x2e, 0x3bc, 0x2e, 0x4d, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x53, 0x61, 0x66, 0x69, 0x79, 0x61, 0x5dc, 0x5e4, 0x5e0, 0x5d4,
0x5f4, 0x5e6, 0x64, 0x65, 0x2e, 0x66, 0x2e, 0x68, 0x2e, 0x4e, 0x2019, 0x1ee5, 0x74, 0x1ee5, 0x74, 0x1ee5, 0x69, 0x70, 0x2e, 0x72,
0x2e, 0x6e, 0x2e, 0x5348, 0x524d, 0x49, 0x73, 0x75, 0x6b, 0x6e, 0x20, 0x74, 0x75, 0x66, 0x61, 0x74, 0x6b, 0x61, 0x72, 0x6f,
0x6f, 0x6e, 0x128, 0x79, 0x61, 0x6b, 0x77, 0x61, 0x6b, 0x79, 0x61, 0xcaa, 0xcc2, 0xcb0, 0xccd, 0xcb5, 0xcbe, 0xcb9, 0xccd, 0xca8,
0x4b, 0x69, 0x72, 0x6f, 0x6b, 0x6f, 0xc624, 0xc804, 0x41, 0x64, 0x64, 0x75, 0x68, 0x61, 0x42, 0x4e, 0x6d, 0x61, 0x6e, 0xe1,
0x442, 0x430, 0x4a3, 0x43a, 0x44b, 0x54, 0x4f, 0x4f, 0xe81, 0xec8, 0xead, 0xe99, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x72, 0x69, 0x65,
0x6b, 0x161, 0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6e, 0x74, 0x254, 0x301, 0x6e, 0x67, 0x254, 0x301, 0x70, 0x72,
0x69, 0x65, 0x161, 0x70, 0x69, 0x65, 0x74, 0x64, 0x6f, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61, 0x44, 0x69, 0x6e, 0x64,
0x61, 0x4f, 0x44, 0x6d, 0x6f, 0x69, 0x65, 0x73, 0x43f, 0x440, 0x435, 0x442, 0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x75, 0x74,
0x75, 0x6b, 0x6f, 0x77, 0x69, 0x63, 0x68, 0x69, 0x73, 0x68, 0x75, 0x4d, 0x75, 0x68, 0x69, 0x50, 0x47, 0x98f, 0x20, 0x98f,
0x9ae, 0x190, 0x6e, 0x6b, 0x61, 0x6b, 0x25b, 0x6e, 0x79, 0xe1, 0x52, 0x168, 0x4af, 0x2e, 0x4e9, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
0x65, 0x1c1, 0x67, 0x6f, 0x61, 0x67, 0x61, 0x73, 0x92a, 0x942, 0x930, 0x94d, 0x935, 0x93e, 0x939, 0x94d, 0x928, 0x6d, 0x62, 0x61,
0x2bc, 0xe1, 0x6d, 0x62, 0x61, 0x2bc, 0x6d, 0x62, 0x61, 0xa78c, 0x6d, 0x62, 0x61, 0xa78c, 0x46, 0x1ecd, 0x20, 0x6d, 0x1ecd, 0x301,
0x6e, 0x69, 0x6e, 0x69, 0x111, 0x69, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x69, 0x62, 0x66, 0x6f, 0x72, 0x6d,
0x69, 0x64, 0x64, 0x61, 0x67, 0x52, 0x57, 0x57, 0x44, 0x4d5, 0x43c, 0x431, 0x438, 0x441, 0x431, 0x43e, 0x43d, 0x44b, 0x20, 0x440,
0x430, 0x437, 0x43c, 0x4d5, 0x63a, 0x2e, 0x645, 0x2e, 0x642, 0x628, 0x644, 0x200c, 0x627, 0x632, 0x638, 0x647, 0x631, 0x64, 0x61, 0x20,
0x6d, 0x61, 0x6e, 0x68, 0xe3, 0xa2a, 0xa42, 0x2e, 0xa26, 0xa41, 0x2e, 0x6b, 0x61, 0x6e, 0x67, 0x2019, 0x61, 0x6d, 0x61, 0x5a,
0x2e, 0x4d, 0x55, 0x2e, 0x42d, 0x418, 0x54, 0x65, 0x73, 0x69, 0x72, 0x61, 0x6e, 0x4e, 0x44, 0x4c, 0x77, 0x61, 0x6d, 0x69,
0x6c, 0x61, 0x77, 0x75, 0x1c65, 0x1c6e, 0x1c5b, 0x1c5f, 0x1c5c, 0x43f, 0x440, 0x435, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x70, 0x72,
0x69, 0x6a, 0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x70, 0x72, 0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x6d, 0x61,
0x6b, 0x65, 0x6f, 0xa3b8, 0xa111, 0x635, 0x628, 0x62d, 0x60c, 0x20, 0x645, 0x646, 0x62c, 0x647, 0x646, 0x62f, 0x92e, 0x902, 0x91d, 0x902,
0x926, 0x93f, 0x20, 0x915, 0x93e, 0x20, 0x92a, 0x939, 0x93f, 0x902, 0x930, 0x94b, 0xdb4, 0xdd9, 0x2e, 0xdc0, 0x2e, 0x4d, 0x75, 0x6e,
0x6b, 0x79, 0x6f, 0x47, 0x48, 0x2d5c, 0x2d49, 0x2d3c, 0x2d30, 0x2d61, 0x2d5c, 0x66, 0x6d, 0x61, 0x6d, 0x20, 0x56, 0x6f, 0x72, 0x6d,
0x69, 0x74, 0x74, 0x61, 0x67, 0x74, 0x69, 0x66, 0x61, 0x77, 0x74, 0x4c, 0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20,
0x4b, 0xbae, 0xbc1, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0x53, 0x75, 0x62, 0x62, 0x61, 0x61, 0x68, 0x69, 0x54, 0x61, 0x70,
0x61, 0x72, 0x61, 0x63, 0x68, 0x75, 0xe01, 0xe48, 0xe2d, 0xe19, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf66, 0xf94, 0xf0b, 0xf51,
0xfb2, 0xf7c, 0xf0b, 0x1245, 0x12f5, 0x1218, 0x20, 0x134d, 0x122d, 0x1242, 0x2d, 0x1218, 0x12d3, 0x120d, 0x1272, 0x68, 0x65, 0x6e, 0x67, 0x69,
0x68, 0x65, 0x6e, 0x67, 0x69, 0xd6, 0xd6, 0x67, 0xfc, 0x6e, 0x6f, 0x72, 0x74, 0x61, 0x64, 0x61, 0x6e, 0x20, 0xf6, 0x148,
0x434, 0x43f, 0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646, 0x20, 0x628, 0x6c7, 0x631, 0x6c7, 0x646, 0x422, 0x41e, 0x53, 0x41, 0x79, 0x62,
0x6b, 0x69, 0x25b, 0x6d, 0x25b, 0x301, 0x25b, 0x6d, 0x5e4, 0x5bf, 0x5d0, 0x5b7, 0x5e8, 0x5de, 0x5d9, 0x5d8, 0x5d0, 0x5b8, 0x5d2, 0xc0,
0xe1, 0x72, 0x1ecd, 0x300, 0xc0, 0xe1, 0x72, 0x254, 0x300
};

static const char16_t pm_data[] = {
0x50, 0x4d, 0x6e, 0x6d, 0x2e, 0x61, 0x2e, 0x6b, 0x45, 0x57, 0x65, 0x20, 0x70, 0x61, 0x73, 0x64, 0x69, 0x74, 0x65, 0x73,
0x12a8, 0x1230, 0x12d3, 0x1275, 0x645, 0x985, 0x9aa, 0x9f0, 0x9be, 0x9b9, 0x9cd, 0x9a8, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x20, 0x74, 0x61,
0x72, 0x64, 0x65, 0x69, 0x63, 0x68, 0x61, 0x6d, 0x74, 0x68, 0x69, 0x41f, 0x41c, 0x63, 0x25b, 0x25b, 0x301, 0x6e, 0x6b, 0x6f,
0x49, 0x20, 0x253, 0x75, 0x67, 0x61, 0x6a, 0x254, 0x70, 0x61, 0x6b, 0x61, 0x73, 0x75, 0x62, 0x61, 0x70, 0x61, 0x6d, 0x75,
0x6e, 0x79, 0x69, 0x92c, 0x947, 0x932, 0x93e, 0x938, 0x947, 0x70, 0x6f, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x43f, 0x43e, 0x441, 0x43b,
0x438, 0x458, 0x435, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x47, 0x2e, 0x4d, 0x2e, 0x441, 0x43b, 0x2e, 0x43e, 0x431, 0x2e, 0x100a,
0x1014, 0x1031, 0x4e0b, 0x5348, 0x70, 0x2e, 0xa0, 0x6d, 0x2e, 0x1e0c, 0x65, 0x66, 0x66, 0x69, 0x72, 0x20, 0x61, 0x7a, 0x61, 0x62f,
0x2e, 0x646, 0x13d2, 0x13af, 0x13f1, 0x13a2, 0x13d7, 0x13e2, 0x55, 0x68, 0x72, 0x20, 0x6e, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
0x61, 0x63, 0x68, 0x73, 0x70, 0x2e, 0x6d, 0x2e, 0x6f, 0x64, 0x70, 0x2e, 0x92c, 0x93e, 0x926, 0x20, 0x926, 0x92a, 0x948, 0x939,
0x930, 0x65, 0x62, 0x79, 0xe1, 0x6d, 0x75, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf46, 0xf0b, 0x55, 0x54, 0x70, 0x6d, 0x70, 0x74, 0x6d,
0x263, 0x65, 0x74, 0x72, 0x254, 0x6e, 0x67, 0x259, 0x67, 0xf3, 0x67, 0x259, 0x6c, 0x65, 0x69, 0x70, 0x2e, 0x73, 0x6f, 0x69,
0x72, 0x6b, 0x69, 0x6b, 0x69, 0x69, 0x257, 0x65, 0xd83a, 0xdd07, 0xd83a, 0xdd0e, 0x3bc, 0x2e, 0x3bc, 0x2e, 0x4d, 0x6f, 0x67, 0x59,
0x61, 0x6d, 0x6d, 0x61, 0x5d0, 0x5d7, 0x5d4, 0x5f4, 0x5e6, 0x64, 0x75, 0x2e, 0x65, 0x2e, 0x68, 0x2e, 0x4e, 0x2019, 0x61, 0x62,
0x61, 0x6c, 0x69, 0x65, 0x70, 0x2e, 0x69, 0x2e, 0x6e, 0x2e, 0x5348, 0x5f8c, 0x57, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x20, 0x74,
0x6d, 0x65, 0x64, 0x64, 0x69, 0x74, 0x6b, 0x6f, 0x6f, 0x73, 0x6b, 0x6f, 0x6c, 0x69, 0x6e, 0x79, 0x128, 0x79, 0x61, 0x77,
0x129, 0x6f, 0x6f, 0xc85, 0xcaa, 0xcb0, 0xcbe, 0xcb9, 0xccd, 0xca8, 0x48, 0x77, 0x61, 0x129, 0x2d, 0x69, 0x6e, 0x129, 0xc624, 0xd6c4,
0x41, 0x6c, 0x75, 0x75, 0x6c, 0x61, 0x50, 0x4e, 0x6b, 0x75, 0x67, 0xfa, 0x442, 0x4af, 0x448, 0x442, 0x4e9, 0x43d, 0x20, 0x43a,
0x438, 0x439, 0x438, 0x43d, 0x43a, 0x438, 0x4d, 0x55, 0x55, 0xeab, 0xebc, 0xeb1, 0xe87, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x113, 0x63,
0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6d, 0x70, 0xf3, 0x6b, 0x77, 0x61, 0x70, 0x6f, 0x70, 0x69, 0x65, 0x74,
0x77, 0xf3, 0x74, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61, 0x44, 0x69, 0x6c, 0x6f, 0x6c, 0x6f, 0x4f, 0x54, 0x6e, 0x6f,
0x6d, 0xeb, 0x74, 0x74, 0x65, 0x73, 0x43f, 0x43e, 0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x6b, 0x79, 0x69, 0x75, 0x6b, 0x6f,
0x6e, 0x79, 0x69, 0x6d, 0x63, 0x68, 0x6f, 0x63, 0x68, 0x69, 0x6c, 0x2019, 0x6c, 0x43, 0x68, 0x69, 0x6c, 0x6f, 0x50, 0x54,
0x47, 0x9aa, 0x9bf, 0x20, 0x98f, 0x9ae, 0x190, 0x6e, 0x64, 0xe1, 0x6d, 0xe2, 0x168, 0x47, 0x4af, 0x2e, 0x445, 0x2e, 0x6c, 0x69,
0x6c, 0x6c, 0x69, 0x1c3, 0x75, 0x69, 0x61, 0x73, 0x905, 0x92a, 0x930, 0x93e, 0x939, 0x94d, 0x928, 0x6e, 0x63, 0x77, 0xf2, 0x6e,
0x7a, 0xe9, 0x6d, 0x14b, 0x6b, 0x61, 0x20, 0x6d, 0x62, 0x254, 0x301, 0x74, 0x20, 0x6e, 0x6a, 0x69, 0x46, 0x1ecd, 0x20, 0xed,
0x76, 0x6e, 0x69, 0x6e, 0x65, 0x61, 0x68, 0x6b, 0x65, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x65, 0x74, 0x74,
0x65, 0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x67, 0x54, 0x14a, 0x57, 0x42, 0x4d5, 0x43c, 0x431, 0x438, 0x441, 0x431, 0x43e, 0x43d,
0x44b, 0x20, 0x444, 0x4d5, 0x441, 0x442, 0x4d5, 0x63a, 0x2e, 0x648, 0x2e, 0x628, 0x639, 0x62f, 0x627, 0x632, 0x638, 0x647, 0x631, 0x64,
0x61, 0x20, 0x74, 0x61, 0x72, 0x64, 0x65, 0xa2c, 0xa3e, 0x2e, 0xa26, 0xa41, 0x2e, 0x6b, 0x69, 0x6e, 0x67, 0x6f, 0x74, 0x6f,
0x5a, 0x2e, 0x4d, 0x57, 0x2e, 0x42d, 0x41a, 0x54, 0x65, 0x69, 0x70, 0x61, 0x4c, 0x4b, 0x50, 0x61, 0x73, 0x68, 0x61, 0x6d,
0x69, 0x68, 0x65, 0x1c67, 0x1c64, 0x1c6b, 0x1c5f, 0x1c79, 0x43f, 0x43e, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x70, 0x6f, 0x20, 0x70,
0x6f, 0x64, 0x6e, 0x65, 0x6e, 0x79, 0x69, 0x61, 0x67, 0x68, 0x75, 0x6f, 0xa06f, 0xa2d2, 0x645, 0x646, 0x62c, 0x647, 0x646, 0x62f,
0x60c, 0x20, 0x634, 0x627, 0x645, 0x92e, 0x902, 0x91d, 0x902, 0x926, 0x93f, 0x20, 0x915, 0x94b, 0x20, 0x92a, 0x94b, 0x90f, 0xdb4, 0x2e,
0xdc0, 0x2e, 0x70, 0x6f, 0x70, 0x2e, 0x45, 0x69, 0x67, 0x75, 0x6c, 0x6f, 0x47, 0x44, 0x2d5c, 0x2d30, 0x2d37, 0x2d33, 0x2d33, 0x2d6f,
0x2d30, 0x2d5c, 0x65, 0x6d, 0x61, 0x6d, 0x20, 0x4e, 0x61, 0x6d, 0x69, 0x74, 0x74, 0x61, 0x67, 0x74, 0x61, 0x64, 0x67, 0x67,
0x2b7, 0x61, 0x74, 0x6c, 0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x70, 0xbaa, 0xbbf, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2,
0xbcd, 0x5a, 0x61, 0x61, 0x72, 0x69, 0x6b, 0x61, 0x79, 0x20, 0x62, 0x45, 0x62, 0x6f, 0x6e, 0x67, 0x69, 0xe2b, 0xe25, 0xe31,
0xe07, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x12f0, 0x1215, 0x1228, 0x20, 0x134d,
0x122d, 0x1240, 0x2d, 0x1218, 0x12d3, 0x120d, 0x1272, 0x65, 0x66, 0x69, 0x61, 0x66, 0x69, 0xd6, 0x53, 0x67, 0xfc, 0x6e, 0x6f, 0x72,
0x74, 0x61, 0x64, 0x61, 0x6e, 0x20, 0x73, 0x6f, 0x148, 0x43f, 0x43f, 0x70, 0x6f, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x75,
0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646, 0x20, 0x643, 0x6d0, 0x64a, 0x649, 0x646, 0x54, 0x4b, 0x422, 0x41a, 0x43, 0x48, 0x79, 0x68,
0x4e, 0x67, 0x6f, 0x6b, 0x69, 0x73, 0x25b, 0x301, 0x6e, 0x64, 0x25b, 0x5e0, 0x5d0, 0x5b8, 0x5db, 0x5de, 0x5d9, 0x5d8, 0x5d0, 0x5b8,
0x5d2, 0x1ecc, 0x300, 0x73, 0xe1, 0x6e, 0x186, 0x300, 0x73, 0xe1, 0x6e
};

static const char16_t currency_symbol_data[] = {
0x52, 0x24, 0x46, 0x43, 0x46, 0x41, 0x47, 0x48, 0x20b5, 0x4c, 0x65, 0x6b, 0xeb, 0x20ac, 0x64, 0x65, 0x6e, 0x1265, 0x122d, 0x62c,
0x2e, 0x645, 0x2e, 0x200f, 0x62f, 0x2e, 0x62c, 0x2e, 0x200f, 0x62f, 0x2e, 0x628, 0x2e, 0x200f, 0x46, 0x64, 0x6a, 0x4e, 0x66, 0x6b,
0x62f, 0x2e, 0x639, 0x2e, 0x200f, 0x20aa, 0x62f, 0x2e, 0x623, 0x2e, 0x200f, 0x62f, 0x2e, 0x643, 0x2e, 0x200f, 0x644, 0x2e, 0x644, 0x2e,
0x200f, 0x62f, 0x2e, 0x644, 0x2e, 0x200f, 0x623, 0x2e, 0x645, 0x2e, 0x62f, 0x2e, 0x645, 0x2e, 0x200f, 0x631, 0x2e, 0x639, 0x2e, 0x200f,
0x631, 0x2e, 0x642, 0x2e, 0x200f, 0x631, 0x2e, 0x633, 0x2e, 0x200f, 0x53, 0xa3, 0x62c, 0x2e, 0x633, 0x2e, 0x644, 0x2e, 0x633, 0x2e,
0x200f, 0x62f, 0x2e, 0x62a, 0x2e, 0x200f, 0x62f, 0x2e, 0x625, 0x2e, 0x200f, 0x631, 0x2e, 0x64a, 0x2e, 0x200f, 0x58f, 0x20b9, 0x54, 0x53,
0x68, 0x20a6, 0x20bc, 0x9f3, 0x20bd, 0x42, 0x72, 0x4b, 0x4b, 0x4d, 0x41a, 0x41c, 0x43b, 0x432, 0x2e, 0x48, 0x4b, 0x24, 0xffe5, 0x20b1,
0x55, 0x53, 0x24, 0x55, 0x53, 0x68, 0xa5, 0x4d, 0x4f, 0x50, 0x24, 0x48, 0x52, 0x4b, 0x4b, 0x10d, 0x6b, 0x72, 0x2e, 0x41,
0x66, 0x6c, 0x2e, 0x4e, 0x41, 0x66, 0x2e, 0x4e, 0x75, 0x2e, 0x4b, 0x73, 0x68, 0x46, 0x42, 0x75, 0x45, 0x44, 0x41, 0x72,
0x4d, 0x4b, 0x52, 0x4d, 0x52, 0x73, 0x52, 0x46, 0x57, 0x53, 0x24, 0x53, 0x52, 0x54, 0x24, 0x41, 0x45, 0x44, 0x56, 0x54,
0x24, 0xa0, 0x43, 0x41, 0x46, 0x43, 0x46, 0x50, 0x46, 0x47, 0x55, 0x4d, 0x4d, 0x41, 0x44, 0x43, 0x48, 0x46, 0x4c, 0x53,
0x44, 0x54, 0xd83a, 0xdd05, 0xd83a, 0xdd0a, 0xd83a, 0xdd00, 0xd83a, 0xdd0a, 0xd83a, 0xdd05, 0xd83a, 0xdd0a, 0xd83a, 0xdd00, 0x20be, 0x20b2, 0x46, 0x74,
0x49, 0x53, 0x4b, 0x52, 0x70, 0x43, 0x41, 0x24, 0x200b, 0x20b8, 0x17db, 0x51, 0x20a9, 0x4b, 0x50, 0x57, 0x20ba, 0x441, 0x43e, 0x43c,
0x20ad, 0x4b, 0x7a, 0x434, 0x435, 0x43d, 0x2e, 0x4d, 0x54, 0x6e, 0x49, 0x52, 0x52, 0x20ae, 0x43, 0x4e, 0xa5, 0x928, 0x947, 0x930,
0x942, 0x60b, 0x631, 0x6cc, 0x627, 0x644, 0x7a, 0x142, 0x44, 0x62, 0x53, 0x2f, 0x42, 0x73, 0x52, 0x4f, 0x4e, 0x20b4, 0x52, 0x53,
0x44, 0xdbb, 0xdd4, 0x2e, 0x20a1, 0x52, 0x44, 0x24, 0x43, 0x24, 0x42, 0x2f, 0x2e, 0x47, 0x73, 0x2e, 0x42, 0x73, 0x2e, 0x53,
0x20ab, 0x441, 0x43e, 0x43c, 0x2e, 0x52, 0x73, 0x2e, 0x4e, 0x54, 0x24, 0xe3f, 0x54, 0x4d, 0x54, 0x73, 0x6f, 0x2bb, 0x6d, 0x441,
0x45e, 0x43c
};

static const char16_t currency_display_name_data[] = {
0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64,
0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x43, 0x46, 0x41, 0x20,
0x46, 0xe0, 0x6c, 0xe2, 0x14b, 0x20, 0x42, 0x45, 0x41, 0x43, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x53, 0x69, 0x64, 0x69,
0x4c, 0x65, 0x6b, 0x75, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x45, 0x75, 0x72, 0x6f, 0x6a, 0x61, 0x44,
0x65, 0x6e, 0x61, 0x72, 0x69, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335,
0x12eb, 0x20, 0x1265, 0x122d, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c,
0x632, 0x627, 0x626, 0x631, 0x64a, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x641, 0x631, 0x646,
0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631,
0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x646, 0x627, 0x643,
0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a,
0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a,
0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628,
0x64a, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x62f, 0x631, 0x647, 0x645,
0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x642, 0x637, 0x631, 0x64a, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x634, 0x644, 0x646, 0x20, 0x635,
0x648, 0x645, 0x627, 0x644, 0x64a, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f,
0x627, 0x646, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648,
0x631, 0x64a, 0x629, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625,
0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x570, 0x561, 0x575, 0x56f, 0x561,
0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9f0, 0x9c1, 0x9aa, 0x9c0,
0x65, 0x75, 0x72, 0x6f, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x64,
0x68, 0x61, 0x6e, 0x69, 0x61, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x6e, 0x61,
0x74, 0x131, 0x43c, 0x430, 0x43d, 0x430, 0x442, 0x66, 0x72, 0xe1, 0x14b, 0x73, 0x65, 0x66, 0x61, 0x20, 0x46, 0x72, 0x61, 0x14b,
0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be,
0x995, 0x9be, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x46, 0x72, 0x1ce, 0x14b, 0x20, 0x43,
0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x65, 0x75, 0x72, 0x6f, 0x61, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443,
0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435, 0x43b, 0x44c, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79,
0x61, 0x20, 0x48, 0x75, 0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x930, 0x93e, 0x902, 0x42, 0x6f, 0x73, 0x61, 0x6e,
0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76,
0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x41a, 0x43e, 0x43d, 0x432, 0x435,
0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x411, 0x44a, 0x43b, 0x433, 0x430, 0x440,
0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x20, 0x1000, 0x103b, 0x1015, 0x103a, 0x6e2f, 0x5e63,
0x4eba, 0x6c11, 0x5e01, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x50, 0x69, 0x73, 0x6f, 0x44, 0x65,
0x72, 0x68, 0x65, 0x6d, 0x20, 0x55, 0x6d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b, 0x69, 0x62f, 0x6cc, 0x646, 0x627, 0x631, 0x6cc, 0x20,
0x639, 0x6ce, 0x631, 0x627, 0x642, 0x6cc, 0x695, 0x6cc, 0x627, 0x6b5, 0x6cc, 0x20, 0x626, 0x6ce, 0x631, 0x627, 0x646, 0x6cc, 0xd804, 0xdd1d,
0xd804, 0xdd01, 0xd804, 0xdd23, 0xd804, 0xdd18, 0xd804, 0xdd2c, 0xd804, 0xdd25, 0xd804, 0xdd28, 0x20, 0xd804, 0xdd11, 0xd804, 0xdd2c, 0xd804, 0xdd0b, 0xd804,
0xdd03, 0xd804, 0xdd28, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0xd804, 0xdd18, 0xd804, 0xdd28, 0xd804, 0xdd20, 0xd804, 0xdd1a, 0xd804, 0xdd34, 0x20, 0xd804, 0xdd22,
0xd804, 0xdd2a, 0xd804, 0xdd1b, 0xd804, 0xdd28, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x55, 0x53, 0x20,
0x13a0, 0x13d5, 0x13b3, 0x45, 0x73, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e,
0x64, 0x61, 0x6e2f, 0x5143, 0x6fb3, 0x95e8, 0x5e01, 0x65b0, 0x52a0, 0x5761, 0x5143, 0x6fb3, 0x9580, 0x5143, 0x65b0, 0x53f0, 0x5e63, 0x68, 0x72, 0x76,
0x61, 0x74, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x10d, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75,
0x6e, 0x61, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x20, 0x930,
0x92a, 0x947, 0x93d, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x41,
0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x4e, 0x65, 0x64,
0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65,
0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0xf51, 0xf44, 0xf74, 0xf63, 0xf0b, 0xf40, 0xfb2, 0xf58, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69,
0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x55, 0x53, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x45, 0x61,
0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x41,
0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x42, 0x61, 0x68, 0x61,
0x6d, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e,
0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x42, 0x6f, 0x74, 0x73,
0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x50, 0x75, 0x6c, 0x61, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20,
0x46, 0x72, 0x61, 0x6e, 0x63, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e,
0x20, 0x43, 0x46, 0x41, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20,
0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x44, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x4b, 0x72, 0x6f, 0x6e, 0x65, 0x45, 0x72, 0x69, 0x74,
0x72, 0x65, 0x61, 0x6e, 0x20, 0x4e, 0x61, 0x6b, 0x66, 0x61, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x4c, 0x69, 0x6c, 0x61,
0x6e, 0x67, 0x65, 0x6e, 0x69, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69,
0x61, 0x6e, 0x20, 0x43, 0x65, 0x64, 0x69, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x20, 0x50, 0x6f, 0x75,
0x6e, 0x64, 0x55, 0x4b, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20,
0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x44, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c,
0x69, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x53, 0x68, 0x65, 0x6b, 0x65, 0x6c, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e,
0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69,
0x6e, 0x67, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64,
0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x4d, 0x61, 0x63, 0x61, 0x6e,
0x65, 0x73, 0x65, 0x20, 0x50, 0x61, 0x74, 0x61, 0x63, 0x61, 0x4d, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x41,
0x72, 0x69, 0x61, 0x72, 0x79, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61,
0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x4d, 0x61, 0x75,
0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e,
0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x4e, 0x61, 0x69, 0x72,
0x61, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x50, 0x61, 0x70, 0x75,
0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x4b, 0x69, 0x6e, 0x61, 0x50, 0x68,
0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x50, 0x65, 0x73, 0x6f, 0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e,
0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x53, 0x74, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x50, 0x6f, 0x75, 0x6e,
0x64, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x54, 0x61, 0x6c, 0x61, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c,
0x6f, 0x69, 0x73, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e,
0x65, 0x61, 0x6e, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x20, 0x44,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e, 0x74,
0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20, 0x47, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f,
0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x53, 0x6f, 0x75, 0x74,
0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x75, 0x64, 0x61,
0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x77, 0x65, 0x64, 0x69, 0x73, 0x68, 0x20, 0x4b, 0x72,
0x6f, 0x6e, 0x61, 0x53, 0x77, 0x69, 0x73, 0x73, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e,
0x69, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x50,
0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62,
0x61, 0x67, 0x6f, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x53, 0x68,
0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x41, 0x72, 0x61, 0x62, 0x20, 0x45, 0x6d,
0x69, 0x72, 0x61, 0x74, 0x65, 0x73, 0x20, 0x44, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68,
0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x56, 0x61, 0x74, 0x75, 0x5a, 0x61,
0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69,
0x256, 0x69, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20,
0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x46, 0x259, 0x6c, 0xe1, 0x14b,
0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3,
0x6e, 0x61, 0x50, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x64,
0x69, 0x6e, 0x61, 0x72, 0x20, 0x61, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43,
0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75,
0x6e, 0x64, 0x61, 0x69, 0x73, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43,
0x29, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67,
0x6f, 0x6c, 0x61, 0x69, 0x73, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65,
0x6e, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x50, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x67, 0x75, 0x69, 0x6e,
0xe9, 0x65, 0x6e, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x20, 0x68, 0x61, 0xef, 0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x61,
0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79,
0x61, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x6e, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20,
0x6d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x20, 0x6d, 0x61,
0x72, 0x6f, 0x63, 0x61, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73,
0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65,
0x73, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x20, 0x73,
0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65,
0x6e, 0x76, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x61, 0x6e, 0x4d, 0x62, 0x75, 0x75, 0x257,
0x75, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61, 0x61, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0xd83a, 0xdd0a, 0xd83a, 0xdd22, 0xd83a, 0xdd2a,
0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd05, 0xd83a, 0xdd0a, 0xd83a, 0xdd00, 0x20, 0xd83a, 0xdd16, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd2a,
0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd32, 0xd83a, 0xdd3a, 0xd83a, 0xdd2b, 0x20, 0xd83a, 0xdd00, 0xd83a, 0xdd2c, 0xd83a, 0xdd2a, 0xd83a,
0xdd2d, 0xd83a, 0xdd33, 0xd83a, 0xdd22, 0xd83a, 0xdd0a, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd1a, 0xd83a, 0xdd35,
0xd83a, 0xdd26, 0xd83a, 0xdd2e, 0xd83a, 0xdd45, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd00, 0xd83a, 0xdd2c, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a,
0xdd33, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0xd83a, 0xdd01, 0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0xd83a, 0xdd27, 0xd83a,
0xdd2d, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd25, 0xd83a, 0xdd26, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0xd83a, 0xdd05,
0xd83a, 0xdd2d, 0xd83a, 0xdd23, 0xd83a, 0xdd2d, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a,
0xdd2e, 0xd83a, 0xdd0a, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd18, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a, 0xdd2b,
0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0xd83a, 0xdd01, 0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0x20, 0xd83a, 0xdd02, 0xd83a, 0xdd2d, 0xd83a,
0xdd26, 0xd83a, 0xdd2b, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0xd83a, 0xdd13, 0xd83a,
0xdd3a, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0x20, 0xd83a, 0xdd03, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd3c, 0xd83a, 0xdd22,
0xd83a, 0xdd32, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd34,
0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0x20, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd36, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd34, 0xd83a,
0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e, 0xd83a, 0xdd02, 0xd83a, 0xdd2b, 0xd83a, 0xdd34, 0xd83a, 0xdd2e, 0xd83a, 0xdd32, 0x20, 0xd83a, 0xdd05,
0xd83a, 0xdd2b, 0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd33, 0xd83a, 0xdd2e,
0x4d, 0x62, 0x75, 0x75, 0x257, 0x69, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61, 0x61, 0x20, 0x42, 0x45, 0x41, 0x43, 0x44, 0x61,
0x6c, 0x61, 0x73, 0x69, 0x20, 0x47, 0x61, 0x6d, 0x6d, 0x62, 0x69, 0x44, 0x6f, 0x6c, 0x61, 0x61, 0x72, 0x20, 0x4c, 0x69,
0x62, 0x65, 0x72, 0x69, 0x79, 0x61, 0x61, 0x55, 0x67, 0x69, 0x79, 0x79, 0x61, 0x20, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61,
0x6e, 0x69, 0x4e, 0x61, 0x79, 0x72, 0x61, 0x61, 0x20, 0x4e, 0x69, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x61, 0x4c, 0x65,
0x77, 0x6f, 0x6f, 0x6e, 0x20, 0x53, 0x65, 0x72, 0x61, 0x61, 0x20, 0x4c, 0x69, 0x79, 0x6f, 0x6e, 0x50, 0x75, 0x6e, 0x6e,
0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65,
0x79, 0x61, 0x20, 0x59, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0,
0x10e0, 0x10d8, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x395,
0x3c5, 0x3c1, 0x3ce, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x4e, 0x61, 0x69, 0x72,
0x61, 0x72, 0x20, 0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x53, 0x69, 0x64, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x47,
0x68, 0x61, 0x6e, 0x61, 0x4b, 0x75, 0x257, 0x69, 0x6e, 0x20, 0x53, 0x65, 0x66, 0x61, 0x20, 0x6e, 0x61, 0x20, 0x41, 0x66,
0x69, 0x72, 0x6b, 0x61, 0x20, 0x54, 0x61, 0x20, 0x59, 0x61, 0x6d, 0x6d, 0x61, 0x5e9, 0x5e7, 0x5dc, 0x20, 0x5d7, 0x5d3, 0x5e9,
0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66,
0x6f, 0x72, 0x69, 0x6e, 0x74, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x4e, 0x61,
0x1ecb, 0x72, 0x61, 0x52, 0x75, 0x70, 0x69, 0x61, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x50,
0x75, 0x6e, 0x74, 0x20, 0x53, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20,
0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f, 0x65e5, 0x672c, 0x5186, 0x73, 0x65, 0x65, 0x66, 0x61, 0x20, 0x79, 0x61, 0x74,
0x69, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x53, 0x6b, 0x75, 0x64, 0x75, 0x20, 0x4b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72,
0x64, 0x69, 0x61, 0x6e, 0x75, 0x41, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x41, 0x7a, 0x7a, 0x61, 0x79, 0x72, 0x69, 0x46,
0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6d, 0x75, 0x74, 0x20,
0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x74, 0x61, 0x62, 0x20, 0x79, 0x61,
0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e,
0x79, 0x61, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0x6c1, 0x650, 0x646, 0x62f, 0x64f,
0x633, 0x62a, 0x672, 0x646, 0x6cd, 0x20, 0x631, 0x6c4, 0x67e, 0x64e, 0x6d2, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d,
0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x179a, 0x17c0, 0x179b, 0x200b, 0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787, 0x17b6, 0x43,
0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0x20,
0xc6d0, 0xc870, 0xc120, 0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20, 0xc778, 0xbbfc, 0x20, 0xacf5, 0xd654, 0xad6d, 0x20, 0xc6d0, 0x43, 0x46, 0x41,
0x20, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x43, 0x46,
0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c,
0x443, 0x53, 0x68, 0x69, 0x6c, 0xed, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61,
0x6e, 0xed, 0x61, 0xea5, 0xeb2, 0xea7, 0x20, 0xe81, 0xeb5, 0xe9a, 0x65, 0x69, 0x72, 0x6f, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67,
0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x79, 0x61, 0x20,
0x41, 0x6e, 0x67, 0xf3, 0x6c, 0x61, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45,
0x41, 0x43, 0x45, 0x75, 0x72, 0x61, 0x73, 0x4e, 0x66, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b,
0x6f, 0x6e, 0x67, 0x75, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61,
0x53, 0x69, 0x72, 0x69, 0x6e, 0x6a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x41c, 0x430, 0x43a, 0x435,
0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69,
0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20,
0xd30, 0xd42, 0xd2a, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x44,
0x6f, 0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x53, 0x69, 0x6e,
0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0x65, 0x77, 0x72, 0x6f, 0x987, 0x9a8, 0x9cd, 0x9a6, 0x9bf, 0x9af, 0x9bc, 0x9be, 0x9a8, 0x20,
0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x54, 0x101, 0x72, 0x61, 0x20, 0x6f, 0x20, 0x41, 0x6f, 0x74, 0x65, 0x61, 0x72, 0x6f, 0x61, 0x49,
0x72, 0x6f, 0x70, 0x69, 0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x49, 0x72, 0x6f,
0x70, 0x69, 0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x627, 0x6cc,
0x631, 0x627, 0x646, 0x20, 0x631, 0x6cc, 0x627, 0x644, 0x73, 0x68, 0x69, 0x72, 0xe8, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x20,
0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x20, 0x6d, 0x6f, 0x72, 0x69, 0x73, 0x69, 0x65, 0x6e,
0x73, 0x6f, 0x6c, 0x61, 0x69, 0x20, 0x42, 0x45, 0x41, 0x43, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x20, 0x44, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x69, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x92d,
0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x66, 0x65, 0x6c, 0xe1, 0x14b, 0x20, 0x43,
0x46, 0x41, 0x46, 0x25b, 0x6c, 0xe2, 0x14b, 0x4e, 0x61, 0x69, 0x6a, 0xed, 0x72, 0x69, 0xe1, 0x20, 0x4e, 0x61, 0xed, 0x72,
0x61, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x72, 0x75, 0x6f, 0x167, 0x167,
0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x44, 0x6f, 0x6c, 0x61, 0x20, 0x79, 0x61, 0x73, 0x65, 0x20, 0x41,
0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0xb2d,
0xb3e, 0xb30, 0xb24, 0xb40, 0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61,
0x61, 0x20, 0x42, 0x69, 0x72, 0x72, 0x69, 0x69, 0x41b, 0x430, 0x440, 0x421, 0x43e, 0x43c, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd,
0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cd, 0x20, 0x6a9, 0x644, 0x62f, 0x627, 0x631, 0x647, 0x631, 0x6cc, 0x627, 0x644, 0x20,
0x627, 0x6cc, 0x631, 0x627, 0x646, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627,
0x646, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x52, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72,
0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x61, 0x6e, 0x67, 0x6f, 0x6c,
0x61, 0x6e, 0x6f, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76, 0x65, 0x72, 0x64, 0x69,
0x61, 0x6e, 0x6f, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x70, 0x61,
0x74, 0x61, 0x63, 0x61, 0x20, 0x6d, 0x61, 0x63, 0x61, 0x65, 0x6e, 0x73, 0x65, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c,
0x20, 0x6d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x64, 0x6f, 0x62, 0x72, 0x61, 0x20, 0x64, 0x65,
0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x75, 0xed, 0xe7, 0x6f, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x64, 0x6f,
0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0xa2d, 0xa3e, 0xa30, 0xa24,
0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa07, 0xa06, 0x631, 0x648, 0x67e, 0x626, 0x6cc, 0x6c1, 0x53, 0x6f, 0x6c, 0x20, 0x50, 0x65, 0x72,
0x75, 0x61, 0x6e, 0x6f, 0x42, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x44, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x41,
0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x73, 0x63,
0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x63, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x68, 0x65, 0x6c, 0x65, 0x72, 0x69, 0x20, 0x73, 0x61, 0x20, 0x54, 0x61,
0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x49, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x72, 0x79, 0x2019, 0x55, 0x62,
0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431,
0x43b, 0x44c, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x43a,
0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437,
0x441, 0x43a, 0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b,
0x435, 0x439, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x430, 0x410,
0x440, 0x430, 0x441, 0x441, 0x44b, 0x44b, 0x439, 0x430, 0x20, 0x441, 0x43e, 0x43b, 0x43a, 0x443, 0x43e, 0x431, 0x430, 0x439, 0x430, 0x4e,
0x6a, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x65, 0x6c, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x66, 0x61, 0x72,
0xe2, 0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x49, 0x68, 0x65, 0x6c, 0x61,
0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0x69, 0x79, 0x61, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20,
0x930, 0x942, 0x92a, 0x94d, 0x92f, 0x915, 0x92e, 0x94d, 0x1c65, 0x1c64, 0x1c67, 0x1c5a, 0x1c5b, 0x20, 0x1c68, 0x1c6e, 0x1c71, 0x1c5f, 0x1c5c, 0x20,
0x1c74, 0x1c5f, 0x1c60, 0x1c5f, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d,
0x62, 0x69, 0x71, 0x75, 0x65, 0x421, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x53, 0x72, 0x70,
0x73, 0x6b, 0x69, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x411, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x445, 0x435, 0x440,
0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438,
0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x415, 0x432, 0x440, 0x43e, 0x45, 0x76, 0x72, 0x6f, 0x73, 0x68, 0x69,
0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x44, 0x6f, 0x72,
0x61, 0x20, 0x72, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627, 0x646, 0x64a,
0x20, 0x631, 0x67e, 0x64a, 0x939, 0x93f, 0x902, 0x926, 0x941, 0x938, 0x94d, 0x924, 0x93e, 0x928, 0x940, 0x20, 0x930, 0x941, 0x92a, 0x92f,
0x94b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20, 0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd, 0x65, 0x76,
0x72, 0x6f, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x6b, 0x61, 0x20, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69,
0x79, 0x61, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x20, 0x4a, 0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x42, 0x69, 0x72, 0x74, 0x61,
0x20, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x62, 0x69, 0x79, 0x61, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x6b, 0x61, 0x20,
0x4b, 0x65, 0x6e, 0x79, 0x61, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x64,
0xf3, 0x6c, 0x61, 0x72, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x63, 0x65, 0xf1, 0x6f, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61,
0x6e, 0x6f, 0x72, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0xf1, 0x6f, 0x50, 0x65, 0x73, 0x6f,
0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69,
0x61, 0x6e, 0x6f, 0x63, 0x6f, 0x6c, 0xf3, 0x6e, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e,
0x73, 0x65, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x75, 0x62, 0x61, 0x6e, 0x6f, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x64, 0x6f,
0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f,
0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x64,
0x65, 0x20, 0xc1, 0x66, 0x72, 0x69, 0x63, 0x61, 0x20, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x71, 0x75, 0x65, 0x74,
0x7a, 0x61, 0x6c, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f,
0x70, 0x65, 0x73, 0x6f, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61,
0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x20,
0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x20, 0x70, 0x61, 0x72, 0x61,
0x67, 0x75, 0x61, 0x79, 0x6f, 0x73, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x70, 0x65, 0x73, 0x6f,
0x20, 0x66, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61,
0x79, 0x6f, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72, 0x20, 0x73, 0x6f, 0x62, 0x65, 0x72, 0x61, 0x6e, 0x6f, 0x2d30, 0x2d37,
0x2d54, 0x2d49, 0x2d4e, 0x20, 0x2d4f, 0x20, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31, 0x52, 0x75, 0x70, 0x65, 0x65, 0x20, 0x49, 0x6e,
0x64, 0x6f, 0x6e, 0xe9, 0x73, 0x69, 0x61, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f,
0x6e, 0x67, 0x6f, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64,
0x61, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a,
0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x61, 0x64, 0x72, 0x69, 0x6d, 0x20, 0x6e, 0x20, 0x6c, 0x6d, 0x263,
0x72, 0x69, 0x62, 0x421, 0x43e, 0x43c, 0x43e, 0x43d, 0x4e3, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe,
0xbaf, 0xbcd, 0xbae, 0xbb2, 0xbc7, 0xbb7, 0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xb9f, 0xbcd, 0xb9a,
0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0, 0xbcd, 0xb87, 0xbb2, 0xb99, 0xbcd,
0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x44f, 0x20, 0x441, 0x443, 0x43c, 0x44b,
0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc3f, 0x41, 0x6e, 0x67, 0x6f, 0x2019, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b, 0x2019,
0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x41, 0x6e, 0x67, 0x6f, 0x2019, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b,
0x2019, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0xe1a, 0xe32, 0xe17, 0xf61, 0xf74, 0xf0b, 0xf68, 0xf53, 0xf0b, 0xf62, 0xf92, 0xfb1, 0xf0b,
0xf42, 0xf62, 0xf0b, 0xf66, 0xf92, 0xf7c, 0xf62, 0xf0b, 0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61,
0x74, 0x6f, 0x6e, 0x67, 0x61, 0x54, 0xfc, 0x72, 0x6b, 0x20, 0x4c, 0x69, 0x72, 0x61, 0x73, 0x131, 0x54, 0xfc, 0x72, 0x6b,
0x6d, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x64, 0x79, 0x443, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x441, 0x44c, 0x43a, 0x430,
0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44f, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc,
0x6c1, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x20, 0x64a,
0x6c8, 0x6d5, 0x646, 0x649, 0x4f, 0x2018, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2018, 0x6d,
0x69, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c, 0xa55e, 0xa524, 0xa52b, 0xa569, 0x20,
0xa55c, 0xa55e, 0xa54c, 0x4c, 0x61, 0x69, 0x62, 0x68, 0x69, 0x79, 0x61, 0x20, 0x44, 0x61, 0x6c, 0x61, 0x110, 0x1ed3, 0x6e, 0x67,
0x20, 0x56, 0x69, 0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69,
0x6e, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x62, 0x75, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x20,
0x53, 0x6f, 0x77, 0x77, 0x75, 0x2d, 0x6a, 0x61, 0x6e, 0x74, 0x69, 0x52, 0x61, 0x6e, 0x64, 0x69, 0x20, 0x79, 0x61, 0x73,
0x65, 0x4d, 0x7a, 0x61, 0x6e, 0x7a, 0x69, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x4e, 0xe1, 0xed, 0x72, 0xe0, 0x20,
0x4e, 0xe0, 0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x73, 0xec, 0x20, 0xec, 0x77, 0x254, 0x300,
0x2d, 0x6f, 0x6f, 0x72, 0xf9, 0x6e, 0x20, 0x41, 0x66, 0xed, 0x72, 0xed, 0x6b, 0xe0, 0x69, 0x2d, 0x53, 0x6f, 0x75, 0x74,
0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64
};

static const char16_t currency_format_data[] = {
0x25, 0x31, 0x25, 0x32, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x25, 0x32, 0x25, 0x31, 0x28, 0x25, 0x32, 0x25, 0x31, 0x29, 0x25,
0x31, 0xa0, 0x25, 0x32, 0x28, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x29, 0x28, 0x25, 0x31, 0x25, 0x32, 0x29, 0x28, 0x25, 0x32,
0xa0, 0x25, 0x31, 0x29, 0x25, 0x32, 0x2d, 0x25, 0x31, 0x25, 0x32, 0x2212, 0x25, 0x31, 0x25, 0x32, 0x2d, 0xa0, 0x25, 0x31,
0x200e, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x200e, 0x28, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x29
};

static const char16_t endonyms_data[] = {
0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61,
0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0xeb, 0x41, 0x67, 0x68, 0x65, 0x6d, 0x4b, 0xe0, 0x6d, 0xe0, 0x6c, 0xfb, 0x14b, 0x41,
0x6b, 0x61, 0x6e, 0x47, 0x61, 0x61, 0x6e, 0x61, 0x73, 0x68, 0x71, 0x69, 0x70, 0x53, 0x68, 0x71, 0x69, 0x70, 0xeb, 0x72,
0x69, 0x4b, 0x6f, 0x73, 0x6f, 0x76, 0xeb, 0x4d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x69, 0x61, 0x20, 0x65, 0x20, 0x56,
0x65, 0x72, 0x69, 0x75, 0x74, 0x12a0, 0x121b, 0x122d, 0x129b, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a,
0x629, 0x645, 0x635, 0x631, 0x627, 0x644, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x627, 0x644, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x62a, 0x634,
0x627, 0x62f, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x625, 0x631, 0x64a,
0x62a, 0x631, 0x64a, 0x627, 0x627, 0x644, 0x639, 0x631, 0x627, 0x642, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x627, 0x644, 0x623,
0x631, 0x62f, 0x646, 0x627, 0x644, 0x643, 0x648, 0x64a, 0x62a, 0x644, 0x628, 0x646, 0x627, 0x646, 0x644, 0x64a, 0x628, 0x64a, 0x627, 0x645,
0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x627, 0x627, 0x644, 0x645, 0x63a, 0x631, 0x628, 0x639, 0x64f, 0x645, 0x627, 0x646, 0x627,
0x644, 0x623, 0x631, 0x627, 0x636, 0x64a, 0x20, 0x627, 0x644, 0x641, 0x644, 0x633, 0x637, 0x64a, 0x646, 0x64a, 0x629, 0x642, 0x637, 0x631,
0x627, 0x644, 0x645, 0x645, 0x644, 0x643, 0x629, 0x20, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x633, 0x639,
0x648, 0x62f, 0x64a, 0x629, 0x627, 0x644, 0x635, 0x648, 0x645, 0x627, 0x644, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648,
0x62f, 0x627, 0x646, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x633, 0x648, 0x631, 0x64a, 0x627, 0x62a, 0x648, 0x646, 0x633, 0x627,
0x644, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x645, 0x62a,
0x62d, 0x62f, 0x629, 0x627, 0x644, 0x635, 0x62d, 0x631, 0x627, 0x621, 0x20, 0x627, 0x644, 0x63a, 0x631, 0x628, 0x64a, 0x629, 0x627, 0x644,
0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x641, 0x635, 0x62d, 0x649, 0x20, 0x627, 0x644, 0x62d, 0x62f, 0x64a, 0x62b, 0x629,
0x627, 0x644, 0x639, 0x627, 0x644, 0x645, 0x627, 0x644, 0x64a, 0x645, 0x646, 0x570, 0x561, 0x575, 0x565, 0x580, 0x565, 0x576, 0x540, 0x561,
0x575, 0x561, 0x57d, 0x57f, 0x561, 0x576, 0x985, 0x9b8, 0x9ae, 0x9c0, 0x9af, 0x9bc, 0x9be, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x61, 0x73, 0x74,
0x75, 0x72, 0x69, 0x61, 0x6e, 0x75, 0x45, 0x73, 0x70, 0x61, 0xf1, 0x61, 0x4b, 0x69, 0x70, 0x61, 0x72, 0x65, 0x54, 0x61,
0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x61, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x41, 0x7a, 0x259, 0x72,
0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x430, 0x437, 0x4d9, 0x440, 0x431, 0x430, 0x458, 0x4b9, 0x430, 0x43d, 0x410, 0x437, 0x4d9, 0x440,
0x431, 0x430, 0x458, 0x4b9, 0x430, 0x43d, 0x72, 0x69, 0x6b, 0x70, 0x61, 0x6b, 0x61, 0x6d, 0x25b, 0x72, 0xfa, 0x6e, 0x62, 0x61,
0x6d, 0x61, 0x6e, 0x61, 0x6b, 0x61, 0x6e, 0x4d, 0x61, 0x6c, 0x69, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9ac, 0x9be, 0x982, 0x9b2,
0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x181, 0xe0, 0x73, 0xe0, 0x61, 0x4b, 0xe0, 0x6d, 0x25b, 0x300, 0x72, 0xfb,
0x6e, 0x65, 0x75, 0x73, 0x6b, 0x61, 0x72, 0x61, 0x45, 0x73, 0x70, 0x61, 0x69, 0x6e, 0x69, 0x61, 0x431, 0x435, 0x43b, 0x430,
0x440, 0x443, 0x441, 0x43a, 0x430, 0x44f, 0x411, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x44c, 0x49, 0x63, 0x68, 0x69, 0x62, 0x65,
0x6d, 0x62, 0x61, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x48, 0x69, 0x62, 0x65, 0x6e, 0x61, 0x48, 0x75, 0x74, 0x61, 0x6e,
0x7a, 0x61, 0x6e, 0x69, 0x61, 0x92c, 0x921, 0x93c, 0x94b, 0x92d, 0x93e, 0x930, 0x924, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b,
0x69, 0x42, 0x6f, 0x73, 0x6e, 0x61, 0x20, 0x69, 0x20, 0x48, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x69, 0x6e, 0x61,
0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x438, 0x411, 0x43e, 0x441, 0x43d, 0x430, 0x20, 0x438, 0x20, 0x425, 0x435, 0x440, 0x446,
0x435, 0x433, 0x43e, 0x432, 0x438, 0x43d, 0x430, 0x62, 0x72, 0x65, 0x7a, 0x68, 0x6f, 0x6e, 0x65, 0x67, 0x46, 0x72, 0x61, 0xf1,
0x73, 0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x411, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x438, 0x44f, 0x1019, 0x103c,
0x1014, 0x103a, 0x1019, 0x102c, 0x7cb5, 0x8a9e, 0x4e2d, 0x83ef, 0x4eba, 0x6c11, 0x5171, 0x548c, 0x570b, 0x9999, 0x6e2f, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340,
0x7ca4, 0x8bed, 0x4e2d, 0x534e, 0x4eba, 0x6c11, 0x5171, 0x548c, 0x56fd, 0x63, 0x61, 0x74, 0x61, 0x6c, 0xe0, 0x45, 0x73, 0x70, 0x61, 0x6e,
0x79, 0x61, 0x41, 0x6e, 0x64, 0x6f, 0x72, 0x72, 0x61, 0x46, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x49, 0x74, 0xe0, 0x6c, 0x69,
0x61, 0x42, 0x69, 0x6e, 0x69, 0x73, 0x61, 0x79, 0x61, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x54, 0x61,
0x6d, 0x61, 0x7a, 0x69, 0x263, 0x74, 0x20, 0x6e, 0x20, 0x6c, 0x61, 0x1e6d, 0x6c, 0x61, 0x1e63, 0x4d, 0x65, 0x1e5b, 0x1e5b, 0x75,
0x6b, 0x6a9, 0x648, 0x631, 0x62f, 0x6cc, 0x6cc, 0x20, 0x646, 0x627, 0x648, 0x6d5, 0x646, 0x62f, 0x6cc, 0x639, 0x6ce, 0x631, 0x627, 0x642,
0x626, 0x6ce, 0x631, 0x627, 0x646, 0xd804, 0xdd0c, 0xd804, 0xdd0b, 0xd804, 0xdd34, 0xd804, 0xdd1f, 0xd804, 0xdd33, 0xd804, 0xdd26, 0xd804, 0xdd1d, 0xd804,
0xdd01, 0xd804, 0xdd23, 0xd804, 0xdd18, 0xd804, 0xdd2c, 0xd804, 0xdd0c, 0xd804, 0xdd34, 0xd804, 0xdd1e, 0xd804, 0xdd22, 0xd804, 0xdd27, 0xd804, 0xdd16, 0xd804,
0xdd34, 0x43d, 0x43e, 0x445, 0x447, 0x438, 0x439, 0x43d, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x13e3, 0x13b3, 0x13a9, 0x13cc, 0x13ca, 0x20, 0x13a2,
0x13f3, 0x13be, 0x13b5, 0x13cd, 0x13d4, 0x13c5, 0x20, 0x13cd, 0x13a6, 0x13da, 0x13a9, 0x52, 0x75, 0x6b, 0x69, 0x67, 0x61, 0x55, 0x67, 0x61,
0x6e, 0x64, 0x61, 0x7b80, 0x4f53, 0x4e2d, 0x6587, 0x4e2d, 0x56fd, 0x4e2d, 0x56fd, 0x9999, 0x6e2f, 0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x4e2d, 0x56fd,
0x6fb3, 0x95e8, 0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x65b0, 0x52a0, 0x5761, 0x7e41, 0x9ad4, 0x4e2d, 0x6587, 0x4e2d, 0x570b, 0x9999, 0x6e2f, 0x7279, 0x5225,
0x884c, 0x653f, 0x5340, 0x4e2d, 0x570b, 0x6fb3, 0x9580, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340, 0x53f0, 0x7063, 0x4b, 0xf6, 0x6c, 0x73, 0x63, 0x68,
0x44, 0x6f, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x77, 0x65, 0x6b, 0x52,
0x79, 0x77, 0x76, 0x61, 0x6e, 0x65, 0x74, 0x68, 0x20, 0x55, 0x6e, 0x79, 0x73, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b,
0x69, 0x48, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x61, 0x10d, 0x65, 0x161, 0x74, 0x69, 0x6e, 0x61, 0x10c, 0x65, 0x73, 0x6b,
0x6f, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x44, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x47, 0x72, 0xf8, 0x6e, 0x6c, 0x61, 0x6e,
0x64, 0x921, 0x94b, 0x917, 0x930, 0x940, 0x64, 0x75, 0xe1, 0x6c, 0xe1, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x6f, 0x75, 0x6e, 0x4e,
0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x41, 0x72, 0x75, 0x62, 0x61, 0x42, 0x65, 0x6c, 0x67, 0x69, 0xeb,
0x43, 0x61, 0x72, 0x69, 0x62, 0x69, 0x73, 0x63, 0x68, 0x20, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x43,
0x75, 0x72, 0x61, 0xe7, 0x61, 0x6f, 0x53, 0x69, 0x6e, 0x74, 0x2d, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x65, 0x6e, 0x53, 0x75,
0x72, 0x69, 0x6e, 0x61, 0x6d, 0x65, 0xf62, 0xfab, 0xf7c, 0xf44, 0xf0b, 0xf41, 0xf60, 0xf56, 0xfb2, 0xf74, 0xf42, 0x4b, 0x129, 0x65,
0x6d, 0x62, 0x75, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67,
0x6c, 0x69, 0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x41, 0x6d, 0x65,
0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x41, 0x6e, 0x67, 0x75, 0x69, 0x6c, 0x6c, 0x61, 0x41,
0x6e, 0x74, 0x69, 0x67, 0x75, 0x61, 0x20, 0x26, 0x20, 0x42, 0x61, 0x72, 0x62, 0x75, 0x64, 0x61, 0x41, 0x75, 0x73, 0x74,
0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x75, 0x73, 0x74, 0x72, 0x69,
0x61, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x61, 0x73, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x6f, 0x73, 0x42, 0x65, 0x6c, 0x67,
0x69, 0x75, 0x6d, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x42, 0x6f, 0x74, 0x73,
0x77, 0x61, 0x6e, 0x61, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x4f,
0x63, 0x65, 0x61, 0x6e, 0x20, 0x54, 0x65, 0x72, 0x72, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73,
0x68, 0x20, 0x56, 0x69, 0x72, 0x67, 0x69, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x42, 0x75, 0x72, 0x75,
0x6e, 0x64, 0x69, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x6f, 0x6f, 0x6e, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20,
0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x61, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20,
0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x6d, 0x61, 0x73, 0x20, 0x49, 0x73, 0x6c,
0x61, 0x6e, 0x64, 0x43, 0x6f, 0x63, 0x6f, 0x73, 0x20, 0x28, 0x4b, 0x65, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x29, 0x20, 0x49,
0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x6f, 0x6f, 0x6b, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x79,
0x70, 0x72, 0x75, 0x73, 0x44, 0x65, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x44, 0x69, 0x65, 0x67, 0x6f, 0x20, 0x47, 0x61, 0x72,
0x63, 0x69, 0x61, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x45, 0x73,
0x77, 0x61, 0x74, 0x69, 0x6e, 0x69, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64,
0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x46, 0x69, 0x6a, 0x69, 0x46, 0x69, 0x6e, 0x6c, 0x61, 0x6e, 0x64, 0x47,
0x61, 0x6d, 0x62, 0x69, 0x61, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x79, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x47, 0x69, 0x62,
0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x47, 0x72, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x47, 0x75, 0x61, 0x6d, 0x47, 0x75, 0x65,
0x72, 0x6e, 0x73, 0x65, 0x79, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67,
0x20, 0x53, 0x41, 0x52, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x49, 0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x49, 0x73, 0x6c,
0x65, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x61, 0x6e, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63,
0x61, 0x4a, 0x65, 0x72, 0x73, 0x65, 0x79, 0x4b, 0x69, 0x72, 0x69, 0x62, 0x61, 0x74, 0x69, 0x4c, 0x65, 0x73, 0x6f, 0x74,
0x68, 0x6f, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x4d, 0x61, 0x63, 0x61, 0x6f, 0x20, 0x53, 0x41, 0x52, 0x20, 0x43,
0x68, 0x69, 0x6e, 0x61, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73, 0x63, 0x61, 0x72, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69,
0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x4d, 0x61, 0x6c, 0x74, 0x61, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c,
0x6c, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x75, 0x73, 0x4d, 0x69,
0x63, 0x72, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x4d, 0x6f, 0x6e, 0x74, 0x73, 0x65, 0x72, 0x72, 0x61, 0x74, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x61, 0x4e, 0x61, 0x75, 0x72, 0x75, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x4e,
0x69, 0x75, 0x65, 0x4e, 0x6f, 0x72, 0x66, 0x6f, 0x6c, 0x6b, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x6f, 0x72,
0x74, 0x68, 0x65, 0x72, 0x6e, 0x20, 0x4d, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x61, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x50, 0x61, 0x6c, 0x61, 0x75, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20,
0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65,
0x73, 0x50, 0x69, 0x74, 0x63, 0x61, 0x69, 0x72, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x50, 0x75, 0x65,
0x72, 0x74, 0x6f, 0x20, 0x52, 0x69, 0x63, 0x6f, 0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x53, 0x74, 0x2e, 0x20, 0x48, 0x65,
0x6c, 0x65, 0x6e, 0x61, 0x53, 0x74, 0x2e, 0x20, 0x4b, 0x69, 0x74, 0x74, 0x73, 0x20, 0x26, 0x20, 0x4e, 0x65, 0x76, 0x69,
0x73, 0x53, 0x74, 0x2e, 0x20, 0x4c, 0x75, 0x63, 0x69, 0x61, 0x53, 0x74, 0x2e, 0x20, 0x56, 0x69, 0x6e, 0x63, 0x65, 0x6e,
0x74, 0x20, 0x26, 0x20, 0x47, 0x72, 0x65, 0x6e, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65,
0x6c, 0x6c, 0x65, 0x73, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x53, 0x69, 0x6e, 0x67,
0x61, 0x70, 0x6f, 0x72, 0x65, 0x53, 0x69, 0x6e, 0x74, 0x20, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x65, 0x6e, 0x53, 0x6c, 0x6f,
0x76, 0x65, 0x6e, 0x69, 0x61, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75,
0x64, 0x61, 0x6e, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x53, 0x77, 0x65, 0x64, 0x65, 0x6e, 0x53, 0x77, 0x69, 0x74, 0x7a, 0x65,
0x72, 0x6c, 0x61, 0x6e, 0x64, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x54, 0x6f, 0x6b, 0x65, 0x6c, 0x61, 0x75,
0x54, 0x6f, 0x6e, 0x67, 0x61, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61,
0x67, 0x6f, 0x54, 0x75, 0x72, 0x6b, 0x73, 0x20, 0x26, 0x20, 0x43, 0x61, 0x69, 0x63, 0x6f, 0x73, 0x20, 0x49, 0x73, 0x6c,
0x61, 0x6e, 0x64, 0x73, 0x54, 0x75, 0x76, 0x61, 0x6c, 0x75, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x41, 0x72, 0x61,
0x62, 0x20, 0x45, 0x6d, 0x69, 0x72, 0x61, 0x74, 0x65, 0x73, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x45, 0x6e,
0x67, 0x6c, 0x69, 0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b, 0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x55,
0x2e, 0x53, 0x2e, 0x20, 0x4f, 0x75, 0x74, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
0x55, 0x2e, 0x53, 0x2e, 0x20, 0x56, 0x69, 0x72, 0x67, 0x69, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x56,
0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x57, 0x6f, 0x72, 0x6c, 0x64, 0x5a, 0x69, 0x6d, 0x62, 0x61, 0x62, 0x77, 0x65, 0x65,
0x73, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x74, 0x6f, 0x4d, 0x6f, 0x6e, 0x64, 0x6f, 0x65, 0x65, 0x73, 0x74, 0x69, 0x45, 0x65,
0x73, 0x74, 0x69, 0x45, 0x28b, 0x65, 0x67, 0x62, 0x65, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x6e, 0x75, 0x74, 0x6f, 0x6d,
0x65, 0x54, 0x6f, 0x67, 0x6f, 0x20, 0x6e, 0x75, 0x74, 0x6f, 0x6d, 0x65, 0x65, 0x77, 0x6f, 0x6e, 0x64, 0x6f, 0x4b, 0x61,
0x6d, 0x259, 0x72, 0xfa, 0x6e, 0x66, 0xf8, 0x72, 0x6f, 0x79, 0x73, 0x6b, 0x74, 0x46, 0xf8, 0x72, 0x6f, 0x79, 0x61, 0x72,
0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x73, 0x75, 0x6f, 0x6d, 0x69, 0x53, 0x75, 0x6f, 0x6d, 0x69, 0x66, 0x72,
0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x42,
0x65, 0x6c, 0x67, 0x69, 0x71, 0x75, 0x65, 0x42, 0xe9, 0x6e, 0x69, 0x6e, 0x42, 0x75, 0x72, 0x6b, 0x69, 0x6e, 0x61, 0x20,
0x46, 0x61, 0x73, 0x6f, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65,
0x6e, 0x52, 0xe9, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x71, 0x75, 0x65, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x66, 0x72,
0x69, 0x63, 0x61, 0x69, 0x6e, 0x65, 0x54, 0x63, 0x68, 0x61, 0x64, 0x43, 0x6f, 0x6d, 0x6f, 0x72, 0x65, 0x73, 0x43, 0x6f,
0x6e, 0x67, 0x6f, 0x2d, 0x42, 0x72, 0x61, 0x7a, 0x7a, 0x61, 0x76, 0x69, 0x6c, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x67, 0x6f,
0x2d, 0x4b, 0x69, 0x6e, 0x73, 0x68, 0x61, 0x73, 0x61, 0x44, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x47, 0x75, 0x69,
0x6e, 0xe9, 0x65, 0x20, 0xe9, 0x71, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x65, 0x47, 0x75, 0x79, 0x61, 0x6e,
0x65, 0x20, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6e, 0xe9, 0x73, 0x69, 0x65,
0x20, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65, 0x47, 0x61, 0x62, 0x6f, 0x6e, 0x47, 0x75, 0x61, 0x64, 0x65,
0x6c, 0x6f, 0x75, 0x70, 0x65, 0x48, 0x61, 0xef, 0x74, 0x69, 0x43, 0xf4, 0x74, 0x65, 0x20, 0x64, 0x2019, 0x49, 0x76, 0x6f,
0x69, 0x72, 0x65, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x6f, 0x75, 0x72, 0x67, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x69,
0x71, 0x75, 0x65, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x65,
0x4d, 0x61, 0x79, 0x6f, 0x74, 0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x61, 0x63, 0x6f, 0x4d, 0x61, 0x72, 0x6f, 0x63, 0x4e, 0x6f,
0x75, 0x76, 0x65, 0x6c, 0x6c, 0x65, 0x2d, 0x43, 0x61, 0x6c, 0xe9, 0x64, 0x6f, 0x6e, 0x69, 0x65, 0x4c, 0x61, 0x20, 0x52,
0xe9, 0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d, 0x42, 0x61, 0x72, 0x74, 0x68, 0xe9, 0x6c, 0x65,
0x6d, 0x79, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d,
0x50, 0x69, 0x65, 0x72, 0x72, 0x65, 0x2d, 0x65, 0x74, 0x2d, 0x4d, 0x69, 0x71, 0x75, 0x65, 0x6c, 0x6f, 0x6e, 0x53, 0xe9,
0x6e, 0xe9, 0x67, 0x61, 0x6c, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65,
0x53, 0x75, 0x69, 0x73, 0x73, 0x65, 0x53, 0x79, 0x72, 0x69, 0x65, 0x54, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x57, 0x61,
0x6c, 0x6c, 0x69, 0x73, 0x2d, 0x65, 0x74, 0x2d, 0x46, 0x75, 0x74, 0x75, 0x6e, 0x61, 0x66, 0x75, 0x72, 0x6c, 0x61, 0x6e,
0x49, 0x74, 0x61, 0x6c, 0x69, 0x65, 0x50, 0x75, 0x6c, 0x61, 0x61, 0x72, 0x53, 0x65, 0x6e, 0x65, 0x67, 0x61, 0x61, 0x6c,
0xd83a, 0xdd06, 0xd83a, 0xdd35, 0xd83a, 0xdd24, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd04, 0xd83a, 0xdd35, 0xd83a, 0xdd2a, 0xd83a, 0xdd33, 0xd83a, 0xdd2d,
0xd83a, 0xdd32, 0xd83a, 0xdd22, 0x20, 0xd83a, 0xdd0a, 0xd83a, 0xdd22, 0xd83a, 0xdd27, 0xd83a, 0xdd2e, 0xd83a, 0xdd45, 0xd83a, 0xdd11, 0xd83a, 0xdd22, 0xd83a,
0xdd25, 0xd83a, 0xdd22, 0xd83a, 0xdd2a, 0xd83a, 0xdd35, 0xd83a, 0xdd45, 0xd83a, 0xdd32, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd25, 0xd83a, 0xdd26, 0xd83a,
0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd18, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd22, 0xd83a, 0xdd18, 0xd83a, 0xdd2d, 0xd83a, 0xdd32, 0xd83a,
0xdd2b, 0x2d, 0xd83a, 0xdd04, 0xd83a, 0xdd2d, 0xd83a, 0xdd27, 0xd83a, 0xdd22, 0xd83a, 0xdd31, 0xd83a, 0xdd2e, 0xd83a, 0xdd45, 0xd83a, 0xdd02, 0xd83a, 0xdd22,
0xd83a, 0xdd26, 0xd83a, 0xdd2d, 0xd83a, 0xdd2a, 0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd03, 0xd83a, 0xdd2e, 0xd83a, 0xdd2a,
0xd83a, 0xdd3c, 0xd83a, 0xdd22, 0xd83a, 0xdd32, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd10, 0xd83a, 0xdd22, 0xd83a, 0xdd36, 0xd83a, 0xdd2b, 0xd83a, 0xdd2a,
0xd83a, 0xdd2d, 0xd83a, 0xdd34, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd10, 0xd83a, 0xdd2d, 0xd83a, 0xdd45, 0xd83a, 0xdd36, 0xd83a, 0xdd2b, 0xd83a, 0xdd2a,
0xd83a, 0xdd05, 0xd83a, 0xdd2b, 0xd83a, 0xdd32, 0xd83a, 0xdd2b, 0xd83a, 0xdd3a, 0xd83a, 0xdd22, 0xd83a, 0xdd44, 0xd83a, 0xdd24, 0xd83a, 0xdd05, 0xd83a, 0xdd22,
0xd83a, 0xdd2a, 0xd83a, 0xdd22, 0xd83a, 0xdd24, 0xd83a, 0xdd2e, 0xd83a, 0xdd32, 0x42, 0x75, 0x72, 0x6b, 0x69, 0x62, 0x61, 0x61, 0x20, 0x46,
0x61, 0x61, 0x73, 0x6f, 0x4b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x75, 0x6e, 0x47, 0x61, 0x6d, 0x6d, 0x62, 0x69, 0x47, 0x61,
0x6e, 0x61, 0x61, 0x47, 0x69, 0x6e, 0x65, 0x2d, 0x42, 0x69, 0x73, 0x61, 0x61, 0x77, 0x6f, 0x4c, 0x69, 0x62, 0x65, 0x72,
0x69, 0x79, 0x61, 0x61, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x4e, 0x69, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61,
0x61, 0x4e, 0x69, 0x6a, 0x65, 0x65, 0x72, 0x53, 0x65, 0x72, 0x61, 0x61, 0x20, 0x6c, 0x69, 0x79, 0x6f, 0x6e, 0x47, 0xe0,
0x69, 0x64, 0x68, 0x6c, 0x69, 0x67, 0x41, 0x6e, 0x20, 0x52, 0xec, 0x6f, 0x67, 0x68, 0x61, 0x63, 0x68, 0x64, 0x20, 0x41,
0x6f, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x74, 0x65, 0x67, 0x61, 0x6c, 0x65, 0x67, 0x6f, 0x4c, 0x75, 0x67, 0x61, 0x6e, 0x64,
0x61, 0x59, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x10e1, 0x10d0, 0x10e5, 0x10d0, 0x10e0,
0x10d7, 0x10d5, 0x10d4, 0x10da, 0x10dd, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x6c,
0x61, 0x6e, 0x64, 0xd6, 0x73, 0x74, 0x65, 0x72, 0x72, 0x65, 0x69, 0x63, 0x68, 0x69, 0x73, 0x63, 0x68, 0x65, 0x73, 0x20,
0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x65, 0x6e, 0x49, 0x74, 0x61, 0x6c, 0x69, 0x65,
0x6e, 0x4c, 0x69, 0x65, 0x63, 0x68, 0x74, 0x65, 0x6e, 0x73, 0x74, 0x65, 0x69, 0x6e, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62,
0x75, 0x72, 0x67, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x48, 0x6f, 0x63, 0x68, 0x64, 0x65, 0x75,
0x74, 0x73, 0x63, 0x68, 0x395, 0x3bb, 0x3bb, 0x3b7, 0x3bd, 0x3b9, 0x3ba, 0x3ac, 0x395, 0x3bb, 0x3bb, 0x3ac, 0x3b4, 0x3b1, 0x39a, 0x3cd,
0x3c0, 0x3c1, 0x3bf, 0x3c2, 0xa97, 0xac1, 0xa9c, 0xab0, 0xabe, 0xaa4, 0xac0, 0xaad, 0xabe, 0xab0, 0xaa4, 0x45, 0x6b, 0x65, 0x67, 0x75,
0x73, 0x69, 0x69, 0x48, 0x61, 0x75, 0x73, 0x61, 0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x4e, 0x69, 0x6a, 0x61,
0x72, 0x2bb, 0x14c, 0x6c, 0x65, 0x6c, 0x6f, 0x20, 0x48, 0x61, 0x77, 0x61, 0x69, 0x2bb, 0x69, 0x2bb, 0x41, 0x6d, 0x65, 0x6c,
0x69, 0x6b, 0x61, 0x20, 0x48, 0x75, 0x69, 0x20, 0x50, 0x16b, 0x20, 0x2bb, 0x49, 0x61, 0x5e2, 0x5d1, 0x5e8, 0x5d9, 0x5ea, 0x5d9,
0x5e9, 0x5e8, 0x5d0, 0x5dc, 0x939, 0x93f, 0x928, 0x94d, 0x926, 0x940, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x4d, 0x61, 0x67, 0x79,
0x61, 0x72, 0x6f, 0x72, 0x73, 0x7a, 0xe1, 0x67, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0xcd, 0x73, 0x6c, 0x61,
0x6e, 0x64, 0x49, 0x67, 0x62, 0x6f, 0x4e, 0x61, 0x1ecb, 0x6a, 0x1ecb, 0x72, 0x1ecb, 0x61, 0x61, 0x6e, 0x61, 0x72, 0xe2, 0x161,
0x6b, 0x69, 0x65, 0x6c, 0xe2, 0x53, 0x75, 0x6f, 0x6d, 0xe2, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x69,
0x6e, 0x74, 0x65, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x75, 0x61, 0x4d, 0x75, 0x6e, 0x64, 0x6f, 0x47, 0x61, 0x65, 0x69, 0x6c,
0x67, 0x65, 0xc9, 0x69, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x52, 0xed, 0x6f, 0x63, 0x68, 0x74, 0x20, 0x41, 0x6f, 0x6e, 0x74,
0x61, 0x69, 0x74, 0x68, 0x65, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x6f, 0x49, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x53,
0x61, 0x6e, 0x20, 0x4d, 0x61, 0x72, 0x69, 0x6e, 0x6f, 0x53, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x61, 0x43, 0x69, 0x74,
0x74, 0xe0, 0x20, 0x64, 0x65, 0x6c, 0x20, 0x56, 0x61, 0x74, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x65e5, 0x672c, 0x8a9e, 0x4a, 0x61,
0x77, 0x61, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0xe9, 0x73, 0x69, 0x61, 0x6a, 0x6f, 0x6f, 0x6c, 0x61, 0x53, 0x65, 0x6e, 0x65,
0x67, 0x61, 0x6c, 0x6b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x4b, 0x61, 0x62, 0x75, 0x20,
0x56, 0x65, 0x72, 0x64, 0x69, 0x54, 0x61, 0x71, 0x62, 0x61, 0x79, 0x6c, 0x69, 0x74, 0x4c, 0x65, 0x7a, 0x7a, 0x61, 0x79,
0x65, 0x72, 0x6b, 0x61, 0x6b, 0x254, 0x4b, 0x61, 0x6d, 0x25b, 0x72, 0x75, 0x6e, 0x6b, 0x61, 0x6c, 0x61, 0x61, 0x6c, 0x6c,
0x69, 0x73, 0x75, 0x74, 0x4b, 0x61, 0x6c, 0x61, 0x61, 0x6c, 0x6c, 0x69, 0x74, 0x20, 0x4e, 0x75, 0x6e, 0x61, 0x61, 0x74,
0x4b, 0x61, 0x6c, 0x65, 0x6e, 0x6a, 0x69, 0x6e, 0x45, 0x6d, 0x65, 0x74, 0x61, 0x62, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61,
0x4b, 0x69, 0x6b, 0x61, 0x6d, 0x62, 0x61, 0xc95, 0xca8, 0xccd, 0xca8, 0xca1, 0xcad, 0xcbe, 0xcb0, 0xca4, 0x6a9, 0x672, 0x634, 0x64f,
0x631, 0x6c1, 0x650, 0x646, 0x62f, 0x648, 0x633, 0x62a, 0x627, 0x646, 0x49b, 0x430, 0x437, 0x430, 0x49b, 0x20, 0x442, 0x456, 0x43b, 0x456,
0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x1781, 0x17d2, 0x1798, 0x17c2, 0x179a, 0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787,
0x17b6, 0x47, 0x69, 0x6b, 0x75, 0x79, 0x75, 0x4b, 0x69, 0x6e, 0x79, 0x61, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x55, 0x20,
0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x915, 0x94b, 0x902, 0x915, 0x923, 0x940, 0xd55c, 0xad6d, 0xc5b4, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0xc870,
0xc120, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0xc778, 0xbbfc, 0xacf5, 0xd654, 0xad6d, 0x4b, 0x6f, 0x79, 0x72, 0x61, 0x62, 0x6f, 0x72, 0x6f, 0x20,
0x73, 0x65, 0x6e, 0x6e, 0x69, 0x4d, 0x61, 0x61, 0x6c, 0x69, 0x4b, 0x6f, 0x79, 0x72, 0x61, 0x20, 0x63, 0x69, 0x69, 0x6e,
0x69, 0x6b, 0x75, 0x72, 0x64, 0xee, 0x54, 0x69, 0x72, 0x6b, 0x69, 0x79, 0x65, 0x4b, 0x77, 0x61, 0x73, 0x69, 0x6f, 0x4b,
0x61, 0x6d, 0x65, 0x72, 0x75, 0x6e, 0x43a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x447, 0x430, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437,
0x441, 0x442, 0x430, 0x43d, 0x4c, 0x61, 0x6b, 0x21f, 0xf3, 0x6c, 0x2bc, 0x69, 0x79, 0x61, 0x70, 0x69, 0x4d, 0xed, 0x6c, 0x61,
0x68, 0x61, 0x14b, 0x73, 0x6b, 0x61, 0x20, 0x54, 0x21f, 0x61, 0x6d, 0xe1, 0x6b, 0x21f, 0x6f, 0x10d, 0x68, 0x65, 0x4b, 0x268,
0x6c, 0x61, 0x61, 0x6e, 0x67, 0x69, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61, 0xea5, 0xeb2, 0xea7, 0x6c, 0x61,
0x74, 0x76, 0x69, 0x65, 0x161, 0x75, 0x4c, 0x61, 0x74, 0x76, 0x69, 0x6a, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0xe1, 0x6c, 0x61,
0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0xed, 0x6b, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3, 0x20, 0x44,
0x65, 0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x74, 0xed, 0x6b, 0x69, 0x41, 0x6e, 0x67, 0xf3, 0x6c, 0x61, 0x52, 0x65, 0x70, 0x69,
0x62, 0x69, 0x6b, 0x69, 0x20, 0x79, 0x61, 0x20, 0x41, 0x66, 0x72, 0xed, 0x6b, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0xe1,
0x74, 0x69, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x69, 0x173, 0x4c, 0x69, 0x65, 0x74, 0x75,
0x76, 0x61, 0x64, 0x6f, 0x6c, 0x6e, 0x6f, 0x73, 0x65, 0x72, 0x62, 0x161, 0x107, 0x69, 0x6e, 0x61, 0x4e, 0x69, 0x6d, 0x73,
0x6b, 0x61, 0x4e, 0x65, 0x64, 0x64, 0x65, 0x72, 0x73, 0x61, 0x73, 0x73, 0x2019, 0x73, 0x63, 0x68, 0x44, 0xfc, 0xfc, 0x74,
0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x65, 0x64, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x6e, 0x54,
0x73, 0x68, 0x69, 0x6c, 0x75, 0x62, 0x61, 0x44, 0x69, 0x74, 0x75, 0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f,
0x6e, 0x67, 0x75, 0x44, 0x68, 0x6f, 0x6c, 0x75, 0x6f, 0x4c, 0xeb, 0x74, 0x7a, 0x65, 0x62, 0x75, 0x65, 0x72, 0x67, 0x65,
0x73, 0x63, 0x68, 0x4c, 0x75, 0x6c, 0x75, 0x68, 0x69, 0x61, 0x43c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438,
0x421, 0x435, 0x432, 0x435, 0x440, 0x43d, 0x430, 0x20, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x438, 0x458, 0x430, 0x4b, 0x69,
0x6d, 0x61, 0x63, 0x68, 0x61, 0x6d, 0x65, 0x92e, 0x948, 0x925, 0x93f, 0x932, 0x940, 0x4d, 0x61, 0x6b, 0x75, 0x61, 0x55, 0x6d,
0x6f, 0x7a, 0x61, 0x6d, 0x62, 0x69, 0x6b, 0x69, 0x43, 0x68, 0x69, 0x6d, 0x61, 0x6b, 0x6f, 0x6e, 0x64, 0x65, 0x4d, 0x61,
0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73, 0x69, 0x6b, 0x61, 0x72, 0x61, 0xd2e, 0xd32,
0xd2f, 0xd3e, 0xd33, 0xd02, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0x4d, 0x65, 0x6c, 0x61, 0x79, 0x75, 0x42, 0x72, 0x75, 0x6e,
0x65, 0x69, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0x4d, 0x61, 0x6c, 0x74, 0x69, 0x9ae, 0x9c8, 0x9a4, 0x9c8,
0x9b2, 0x9cb, 0x9a8, 0x9cd, 0x987, 0x9a8, 0x9cd, 0x9a6, 0x9bf, 0x9af, 0x9bc, 0x9be, 0x47, 0x61, 0x65, 0x6c, 0x67, 0x45, 0x6c, 0x6c,
0x61, 0x6e, 0x20, 0x56, 0x61, 0x6e, 0x6e, 0x69, 0x6e, 0x74, 0x65, 0x20, 0x72, 0x65, 0x6f, 0x20, 0x4d, 0x101, 0x6f, 0x72,
0x69, 0x41, 0x6f, 0x74, 0x65, 0x61, 0x72, 0x6f, 0x61, 0x92e, 0x930, 0x93e, 0x920, 0x940, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e,
0x69, 0x61, 0x645, 0x627, 0x632, 0x631, 0x648, 0x646, 0x6cc, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x4b, 0x129, 0x6d, 0x129, 0x72, 0x169,
0x6d, 0x65, 0x74, 0x61, 0x2bc, 0x4b, 0x61, 0x6d, 0x61, 0x6c, 0x75, 0x6e, 0x43c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x41c, 0x43e,
0x43d, 0x433, 0x43e, 0x43b, 0x6b, 0x72, 0x65, 0x6f, 0x6c, 0x20, 0x6d, 0x6f, 0x72, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x4d, 0x6f,
0x72, 0x69, 0x73, 0x4d, 0x55, 0x4e, 0x44, 0x41, 0x14a, 0x6b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x14b, 0x4b, 0x68, 0x6f, 0x65,
0x6b, 0x68, 0x6f, 0x65, 0x67, 0x6f, 0x77, 0x61, 0x62, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x62, 0x928, 0x947, 0x92a,
0x93e, 0x932, 0x940, 0x53, 0x68, 0x77, 0xf3, 0x14b, 0xf2, 0x20, 0x6e, 0x67, 0x69, 0x65, 0x6d, 0x62, 0x254, 0x254, 0x6e, 0x4b,
0xe0, 0x6d, 0x61, 0x6c, 0xfb, 0x6d, 0x4e, 0x64, 0x61, 0xa78c, 0x61, 0x4b, 0x61, 0x6d, 0x25b, 0x6c, 0xfb, 0x6e, 0x4e, 0x61,
0x69, 0x6a, 0xed, 0x72, 0x69, 0xe1, 0x20, 0x50, 0xed, 0x6a, 0x69, 0x6e, 0x4e, 0x61, 0x69, 0x6a, 0xed, 0x72, 0x69, 0x61,
0x644, 0x6ca, 0x631, 0x6cc, 0x20, 0x634, 0x648, 0x645, 0x627, 0x644, 0x6cc, 0x64, 0x61, 0x76, 0x76, 0x69, 0x73, 0xe1, 0x6d, 0x65,
0x67, 0x69, 0x65, 0x6c, 0x6c, 0x61, 0x4e, 0x6f, 0x72, 0x67, 0x61, 0x53, 0x75, 0x6f, 0x70, 0x6d, 0x61, 0x52, 0x75, 0x6f,
0x167, 0x167, 0x61, 0x69, 0x73, 0x69, 0x4e, 0x64, 0x65, 0x62, 0x65, 0x6c, 0x65, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x62,
0x6f, 0x6b, 0x6d, 0xe5, 0x6c, 0x4e, 0x6f, 0x72, 0x67, 0x65, 0x53, 0x76, 0x61, 0x6c, 0x62, 0x61, 0x72, 0x64, 0x20, 0x6f,
0x67, 0x20, 0x4a, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x79, 0x65, 0x6e, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x6e, 0x79, 0x6e,
0x6f, 0x72, 0x73, 0x6b, 0x4e, 0x6f, 0x72, 0x65, 0x67, 0x54, 0x68, 0x6f, 0x6b, 0x20, 0x4e, 0x61, 0x74, 0x68, 0x52, 0x75,
0x6e, 0x79, 0x61, 0x6e, 0x6b, 0x6f, 0x72, 0x65, 0xb13, 0xb21, 0xb3c, 0xb3f, 0xb06, 0xb2d, 0xb3e, 0xb30, 0xb24, 0x4f, 0x72, 0x6f,
0x6d, 0x6f, 0x6f, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x4b, 0x65, 0x65, 0x6e, 0x69, 0x79, 0x61,
0x61, 0x438, 0x440, 0x43e, 0x43d, 0x413, 0x443, 0x44b, 0x440, 0x434, 0x437, 0x44b, 0x441, 0x442, 0x43e, 0x43d, 0x423, 0x4d5, 0x440, 0x4d5,
0x441, 0x435, 0x67e, 0x69a, 0x62a, 0x648, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627, 0x646, 0x67e, 0x627, 0x6a9, 0x633, 0x62a,
0x627, 0x646, 0x641, 0x627, 0x631, 0x633, 0x6cc, 0x62f, 0x631, 0x6cc, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x50, 0x6f, 0x6c, 0x73,
0x6b, 0x61, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73, 0x42, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x41, 0x6e, 0x67,
0x6f, 0x6c, 0x61, 0x43, 0x61, 0x62, 0x6f, 0x20, 0x56, 0x65, 0x72, 0x64, 0x65, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x20, 0x45,
0x71, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x2d, 0x42, 0x69, 0x73, 0x73, 0x61,
0x75, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x75, 0x72, 0x67, 0x6f, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x2c, 0x20, 0x52, 0x41,
0x45, 0x20, 0x64, 0x61, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65,
0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73, 0x20, 0x65, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x75, 0x50, 0x6f, 0x72,
0x74, 0x75, 0x67, 0x61, 0x6c, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e,
0x63, 0x69, 0x70, 0x65, 0x53, 0x75, 0xed, 0xe7, 0x61, 0x54, 0x69, 0x6d, 0x6f, 0x72, 0x2d, 0x4c, 0x65, 0x73, 0x74, 0x65,
0xa2a, 0xa70, 0xa1c, 0xa3e, 0xa2c, 0xa40, 0xa2d, 0xa3e, 0xa30, 0xa24, 0x67e, 0x646, 0x62c, 0x627, 0x628, 0x6cc, 0x52, 0x75, 0x6e, 0x61,
0x73, 0x69, 0x6d, 0x69, 0x50, 0x65, 0x72, 0xfa, 0x42, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x45, 0x63, 0x75, 0x61, 0x64,
0x6f, 0x72, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x103, 0x52, 0x6f, 0x6d, 0xe2, 0x6e, 0x69, 0x61, 0x52, 0x65, 0x70, 0x75, 0x62,
0x6c, 0x69, 0x63, 0x61, 0x20, 0x4d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x61, 0x72, 0x75, 0x6d, 0x61, 0x6e, 0x74, 0x73, 0x63,
0x68, 0x53, 0x76, 0x69, 0x7a, 0x72, 0x61, 0x4b, 0x69, 0x68, 0x6f, 0x72, 0x6f, 0x6d, 0x62, 0x6f, 0x49, 0x6b, 0x69, 0x72,
0x75, 0x6e, 0x64, 0x69, 0x55, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x420,
0x43e, 0x441, 0x441, 0x438, 0x44f, 0x41a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x442, 0x430, 0x43d, 0x41a, 0x438, 0x440, 0x433, 0x438, 0x437,
0x438, 0x44f, 0x41c, 0x43e, 0x43b, 0x434, 0x43e, 0x432, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x430, 0x4b, 0x69, 0x72, 0x75,
0x77, 0x61, 0x441, 0x430, 0x445, 0x430, 0x20, 0x442, 0x44b, 0x43b, 0x430, 0x410, 0x440, 0x430, 0x441, 0x441, 0x44b, 0x44b, 0x439, 0x430,
0x4b, 0x69, 0x73, 0x61, 0x6d, 0x70, 0x75, 0x72, 0x53, 0xe4, 0x6e, 0x67, 0xf6, 0x4b, 0xf6, 0x64, 0xf6, 0x72, 0xf6, 0x73,
0xea, 0x73, 0x65, 0x20, 0x74, 0xee, 0x20, 0x42, 0xea, 0x61, 0x66, 0x72, 0xee, 0x6b, 0x61, 0x49, 0x73, 0x68, 0x69, 0x73,
0x61, 0x6e, 0x67, 0x75, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0x69, 0x79, 0x61, 0x938, 0x902, 0x938, 0x94d, 0x915, 0x943, 0x924,
0x20, 0x92d, 0x93e, 0x937, 0x93e, 0x92d, 0x93e, 0x930, 0x924, 0x903, 0x1c65, 0x1c5f, 0x1c71, 0x1c5b, 0x1c5f, 0x1c72, 0x1c64, 0x1c64, 0x1c71, 0x1c70,
0x1c64, 0x1c6d, 0x1c5f, 0x73, 0x65, 0x6e, 0x61, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x421, 0x440, 0x431, 0x438, 0x458, 0x430, 0x73,
0x72, 0x70, 0x73, 0x6b, 0x69, 0x53, 0x72, 0x62, 0x69, 0x6a, 0x61, 0x41a, 0x43e, 0x441, 0x43e, 0x432, 0x43e, 0x426, 0x440, 0x43d,
0x430, 0x20, 0x413, 0x43e, 0x440, 0x430, 0x4b, 0x6f, 0x73, 0x6f, 0x76, 0x6f, 0x43, 0x72, 0x6e, 0x61, 0x20, 0x47, 0x6f, 0x72,
0x61, 0x4b, 0x69, 0x73, 0x68, 0x61, 0x6d, 0x62, 0x61, 0x61, 0x63, 0x68, 0x69, 0x53, 0x68, 0x6f, 0x6e, 0x61, 0xa188, 0xa320,
0xa259, 0xa34f, 0xa1e9, 0x633, 0x646, 0x68c, 0x64a, 0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627, 0x646, 0x938, 0x93f, 0x928, 0x94d, 0x927, 0x940,
0xdc3, 0xdd2, 0xd82, 0xdc4, 0xdbd, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0xdc0, 0x73, 0x6c, 0x6f, 0x76,
0x65, 0x6e, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x6f, 0x73, 0x6c, 0x6f, 0x76, 0x65,
0x6e, 0x161, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x69, 0x6a, 0x61, 0x4f, 0x6c, 0x75, 0x73, 0x6f,
0x67, 0x61, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x79, 0x61,
0x4a, 0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x69, 0x79, 0x61, 0x65, 0x73, 0x70, 0x61, 0xf1,
0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x45, 0x73, 0x70, 0x61, 0xf1, 0x61, 0x41, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e,
0x61, 0x42, 0x65, 0x6c, 0x69, 0x63, 0x65, 0x43, 0x61, 0x6e, 0x61, 0x72, 0x69, 0x61, 0x73, 0x43, 0x65, 0x75, 0x74, 0x61,
0x20, 0x79, 0x20, 0x4d, 0x65, 0x6c, 0x69, 0x6c, 0x6c, 0x61, 0x43, 0x68, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x6d,
0x62, 0x69, 0x61, 0x43, 0x6f, 0x73, 0x74, 0x61, 0x20, 0x52, 0x69, 0x63, 0x61, 0x43, 0x75, 0x62, 0x61, 0x52, 0x65, 0x70,
0xfa, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x20, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x61, 0x45, 0x6c, 0x20,
0x53, 0x61, 0x6c, 0x76, 0x61, 0x64, 0x6f, 0x72, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x20, 0x45, 0x63, 0x75, 0x61, 0x74,
0x6f, 0x72, 0x69, 0x61, 0x6c, 0x47, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x61, 0x48, 0x6f, 0x6e, 0x64, 0x75, 0x72,
0x61, 0x73, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x6f, 0x61, 0x6d, 0x65, 0x72,
0x69, 0x63, 0x61, 0x6e, 0x6f, 0x4c, 0x61, 0x74, 0x69, 0x6e, 0x6f, 0x61, 0x6d, 0xe9, 0x72, 0x69, 0x63, 0x61, 0x65, 0x73,
0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0xe9, 0x78, 0x69, 0x63, 0x6f, 0x4d, 0xe9, 0x78, 0x69, 0x63,
0x6f, 0x4e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x50, 0x61, 0x6e, 0x61, 0x6d, 0xe1, 0x50, 0x61, 0x72, 0x61,
0x67, 0x75, 0x61, 0x79, 0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73,
0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x55, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x56, 0x65, 0x6e, 0x65, 0x7a, 0x75,
0x65, 0x6c, 0x61, 0x2d5c, 0x2d30, 0x2d4e, 0x2d30, 0x2d63, 0x2d49, 0x2d56, 0x2d5c, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31, 0x42, 0x61, 0x73,
0x61, 0x20, 0x53, 0x75, 0x6e, 0x64, 0x61, 0x4b, 0x69, 0x73, 0x77, 0x61, 0x68, 0x69, 0x6c, 0x69, 0x4a, 0x61, 0x6d, 0x68,
0x75, 0x72, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x69, 0x64, 0x65, 0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x73, 0x69, 0x61, 0x20,
0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0x53, 0x76, 0x65, 0x72, 0x69,
0x67, 0x65, 0xc5, 0x6c, 0x61, 0x6e, 0x64, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x74, 0xfc, 0xfc, 0x74,
0x73, 0x63, 0x68, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x72, 0x69, 0x69, 0x63, 0x68, 0x4c, 0x69, 0xe4, 0x63, 0x68, 0x74, 0x65,
0x73, 0x63, 0x68, 0x74, 0xe4, 0x69, 0x2d5c, 0x2d30, 0x2d5b, 0x2d4d, 0x2d43, 0x2d49, 0x2d5c, 0x54, 0x61, 0x73, 0x68, 0x65, 0x6c, 0x1e25,
0x69, 0x79, 0x74, 0x6c, 0x6d, 0x263, 0x72, 0x69, 0x62, 0x4b, 0x69, 0x74, 0x61, 0x69, 0x74, 0x61, 0x442, 0x43e, 0x4b7, 0x438,
0x43a, 0x4e3, 0x422, 0x43e, 0x4b7, 0x438, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0xba4, 0xbae, 0xbbf, 0xbb4, 0xbcd, 0xb87, 0xba8, 0xbcd,
0xba4, 0xbbf, 0xbaf, 0xbbe, 0xbae, 0xbb2, 0xbc7, 0xb9a, 0xbbf, 0xbaf, 0xbbe, 0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2,
0xbb0, 0xbcd, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x54, 0x61, 0x73, 0x61, 0x77, 0x61, 0x71, 0x20, 0x73, 0x65, 0x6e, 0x6e,
0x69, 0x4e, 0x69, 0x17e, 0x65, 0x72, 0x442, 0x430, 0x442, 0x430, 0x440, 0xc24, 0xc46, 0xc32, 0xc41, 0xc17, 0xc41, 0xc2d, 0xc3e, 0xc30,
0xc24, 0xc26, 0xc47, 0xc36, 0xc02, 0x4b, 0x69, 0x74, 0x65, 0x73, 0x6f, 0x4b, 0x65, 0x6e, 0x69, 0x61, 0xe44, 0xe17, 0xe22, 0xf56,
0xf7c, 0xf51, 0xf0b, 0xf66, 0xf90, 0xf51, 0xf0b, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf53, 0xf42, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf42, 0xf62, 0xf0b,
0x1275, 0x130d, 0x122d, 0x12a4, 0x122d, 0x1275, 0x122b, 0x6c, 0x65, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61, 0x74, 0x6f, 0x6e, 0x67, 0x61,
0x54, 0xfc, 0x72, 0x6b, 0xe7, 0x65, 0x54, 0xfc, 0x72, 0x6b, 0x69, 0x79, 0x65, 0x4b, 0x131, 0x62, 0x72, 0x131, 0x73, 0x74,
0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x64, 0x69, 0x6c, 0x69, 0x54, 0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x69, 0x73,
0x74, 0x61, 0x6e, 0x443, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x441, 0x44c, 0x43a, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x430,
0x68, 0x6f, 0x72, 0x6e, 0x6a, 0x6f, 0x73, 0x65, 0x72, 0x62, 0x161, 0x107, 0x69, 0x6e, 0x61, 0x4e, 0x11b, 0x6d, 0x73, 0x6b,
0x61, 0x627, 0x631, 0x62f, 0x648, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x626, 0x6c7, 0x64a, 0x63a, 0x6c7, 0x631, 0x686, 0x6d5, 0x62c, 0x6c7,
0x6ad, 0x6af, 0x648, 0x6f, 0x2018, 0x7a, 0x62, 0x65, 0x6b, 0x4f, 0x2bb, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e,
0x627, 0x648, 0x632, 0x628, 0x6cc, 0x6a9, 0x45e, 0x437, 0x431, 0x435, 0x43a, 0x447, 0x430, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441,
0x442, 0x43e, 0x43d, 0xa559, 0xa524, 0xa55e, 0xa524, 0xa52b, 0xa569, 0x56, 0x61, 0x69, 0x4c, 0x61, 0x69, 0x62, 0x68, 0x69, 0x79, 0x61,
0x54, 0x69, 0x1ebf, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7, 0x74, 0x56, 0x69, 0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x4b, 0x79,
0x69, 0x76, 0x75, 0x6e, 0x6a, 0x6f, 0x57, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x53, 0x63, 0x68, 0x77, 0x69, 0x7a, 0x43, 0x79,
0x6d, 0x72, 0x61, 0x65, 0x67, 0x59, 0x20, 0x44, 0x65, 0x79, 0x72, 0x6e, 0x61, 0x73, 0x20, 0x55, 0x6e, 0x65, 0x64, 0x69,
0x67, 0x46, 0x72, 0x79, 0x73, 0x6b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0xe2, 0x6e, 0x57, 0x6f, 0x6c, 0x6f, 0x66, 0x69,
0x73, 0x69, 0x58, 0x68, 0x6f, 0x73, 0x61, 0x65, 0x4d, 0x7a, 0x61, 0x6e, 0x74, 0x73, 0x69, 0x20, 0x41, 0x66, 0x72, 0x69,
0x6b, 0x61, 0x6e, 0x75, 0x61, 0x73, 0x75, 0x65, 0x4b, 0x65, 0x6d, 0x65, 0x6c, 0xfa, 0x6e, 0x5d9, 0x5d9, 0x5b4, 0x5d3, 0x5d9,
0x5e9, 0x5d5, 0x5d5, 0x5e2, 0x5dc, 0x5d8, 0xc8, 0x64, 0xe8, 0x20, 0x59, 0x6f, 0x72, 0xf9, 0x62, 0xe1, 0x4e, 0xe0, 0xec, 0x6a,
0xed, 0x72, 0xed, 0xe0, 0x42, 0x25b, 0x300, 0x6e, 0x25b, 0x300, 0x5a, 0x61, 0x72, 0x6d, 0x61, 0x63, 0x69, 0x69, 0x6e, 0x65,
0x69, 0x73, 0x69, 0x5a, 0x75, 0x6c, 0x75, 0x69, 0x4e, 0x69, 0x6e, 0x67, 0x69, 0x7a, 0x69, 0x6d, 0x75, 0x20, 0x41, 0x66,
0x72, 0x69, 0x6b, 0x61
};

static const char language_name_list[] =
"Default\0"
"C\0"
"Abkhazian\0"
"Afar\0"
"Afrikaans\0"
"Aghem\0"
"Akan\0"
"Akkadian\0"
"Akoose\0"
"Albanian\0"
"American Sign Language\0"
"Amharic\0"
"Ancient Egyptian\0"
"Ancient Greek\0"
"Arabic\0"
"Aragonese\0"
"Aramaic\0"
"Armenian\0"
"Assamese\0"
"Asturian\0"
"Asu\0"
"Atsam\0"
"Avaric\0"
"Avestan\0"
"Aymara\0"
"Azerbaijani\0"
"Bafia\0"
"Balinese\0"
"Bambara\0"
"Bamun\0"
"Bangla\0"
"Basaa\0"
"Bashkir\0"
"Basque\0"
"Batak Toba\0"
"Belarusian\0"
"Bemba\0"
"Bena\0"
"Bhojpuri\0"
"Bislama\0"
"Blin\0"
"Bodo\0"
"Bosnian\0"
"Breton\0"
"Buginese\0"
"Bulgarian\0"
"Burmese\0"
"Cantonese\0"
"Catalan\0"
"Cebuano\0"
"Central Atlas Tamazight\0"
"Central Kurdish\0"
"Chakma\0"
"Chamorro\0"
"Chechen\0"
"Cherokee\0"
"Chickasaw\0"
"Chiga\0"
"Chinese\0"
"Church\0"
"Chuvash\0"
"Colognian\0"
"Coptic\0"
"Cornish\0"
"Corsican\0"
"Cree\0"
"Croatian\0"
"Czech\0"
"Danish\0"
"Divehi\0"
"Dogri\0"
"Duala\0"
"Dutch\0"
"Dzongkha\0"
"Embu\0"
"English\0"
"Erzya\0"
"Esperanto\0"
"Estonian\0"
"Ewe\0"
"Ewondo\0"
"Faroese\0"
"Fijian\0"
"Filipino\0"
"Finnish\0"
"French\0"
"Friulian\0"
"Fulah\0"
"Gaelic\0"
"Ga\0"
"Galician\0"
"Ganda\0"
"Geez\0"
"Georgian\0"
"German\0"
"Gothic\0"
"Greek\0"
"Guarani\0"
"Gujarati\0"
"Gusii\0"
"Haitian\0"
"Hausa\0"
"Hawaiian\0"
"Hebrew\0"
"Herero\0"
"Hindi\0"
"Hiri Motu\0"
"Hungarian\0"
"Icelandic\0"
"Ido\0"
"Igbo\0"
"Inari Sami\0"
"Indonesian\0"
"Ingush\0"
"Interlingua\0"
"Interlingue\0"
"Inuktitut\0"
"Inupiaq\0"
"Irish\0"
"Italian\0"
"Japanese\0"
"Javanese\0"
"Jju\0"
"Jola Fonyi\0"
"Kabuverdianu\0"
"Kabyle\0"
"Kako\0"
"Kalaallisut\0"
"Kalenjin\0"
"Kamba\0"
"Kannada\0"
"Kanuri\0"
"Kashmiri\0"
"Kazakh\0"
"Kenyang\0"
"Khmer\0"
"Kiche\0"
"Kikuyu\0"
"Kinyarwanda\0"
"Komi\0"
"Kongo\0"
"Konkani\0"
"Korean\0"
"Koro\0"
"Koyraboro Senni\0"
"Koyra Chiini\0"
"Kpelle\0"
"Kuanyama\0"
"Kurdish\0"
"Kwasio\0"
"Kyrgyz\0"
"Lakota\0"
"Langi\0"
"Lao\0"
"Latin\0"
"Latvian\0"
"Lezghian\0"
"Limburgish\0"
"Lingala\0"
"Literary Chinese\0"
"Lithuanian\0"
"Lojban\0"
"Lower Sorbian\0"
"Low German\0"
"Luba Katanga\0"
"Lule Sami\0"
"Luo\0"
"Luxembourgish\0"
"Luyia\0"
"Macedonian\0"
"Machame\0"
"Maithili\0"
"Makhuwa Meetto\0"
"Makonde\0"
"Malagasy\0"
"Malayalam\0"
"Malay\0"
"Maltese\0"
"Mandingo\0"
"Manipuri\0"
"Manx\0"
"Maori\0"
"Mapuche\0"
"Marathi\0"
"Marshallese\0"
"Masai\0"
"Mazanderani\0"
"Mende\0"
"Meru\0"
"Meta\0"
"Mohawk\0"
"Mongolian\0"
"Morisyen\0"
"Mundang\0"
"Muscogee\0"
"Nama\0"
"Nauru\0"
"Navajo\0"
"Ndonga\0"
"Nepali\0"
"Newari\0"
"Ngiemboon\0"
"Ngomba\0"
"Nigerian Pidgin\0"
"Nko\0"
"Northern Luri\0"
"Northern Sami\0"
"Northern Sotho\0"
"North Ndebele\0"
"Norwegian Bokmal\0"
"Norwegian Nynorsk\0"
"Nuer\0"
"Nyanja\0"
"Nyankole\0"
"Occitan\0"
"Odia\0"
"Ojibwa\0"
"Old Irish\0"
"Old Norse\0"
"Old Persian\0"
"Oromo\0"
"Osage\0"
"Ossetic\0"
"Pahlavi\0"
"Palauan\0"
"Pali\0"
"Papiamento\0"
"Pashto\0"
"Persian\0"
"Phoenician\0"
"Polish\0"
"Portuguese\0"
"Prussian\0"
"Punjabi\0"
"Quechua\0"
"Romanian\0"
"Romansh\0"
"Rombo\0"
"Rundi\0"
"Russian\0"
"Rwa\0"
"Saho\0"
"Sakha\0"
"Samburu\0"
"Samoan\0"
"Sango\0"
"Sangu\0"
"Sanskrit\0"
"Santali\0"
"Sardinian\0"
"Saurashtra\0"
"Sena\0"
"Serbian\0"
"Shambala\0"
"Shona\0"
"Sichuan Yi\0"
"Sicilian\0"
"Sidamo\0"
"Silesian\0"
"Sindhi\0"
"Sinhala\0"
"Skolt Sami\0"
"Slovak\0"
"Slovenian\0"
"Soga\0"
"Somali\0"
"Southern Kurdish\0"
"Southern Sami\0"
"Southern Sotho\0"
"South Ndebele\0"
"Spanish\0"
"Standard Moroccan Tamazight\0"
"Sundanese\0"
"Swahili\0"
"Swati\0"
"Swedish\0"
"Swiss German\0"
"Syriac\0"
"Tachelhit\0"
"Tahitian\0"
"Tai Dam\0"
"Taita\0"
"Tajik\0"
"Tamil\0"
"Taroko\0"
"Tasawaq\0"
"Tatar\0"
"Telugu\0"
"Teso\0"
"Thai\0"
"Tibetan\0"
"Tigre\0"
"Tigrinya\0"
"Tokelau\0"
"Tok Pisin\0"
"Tongan\0"
"Tsonga\0"
"Tswana\0"
"Turkish\0"
"Turkmen\0"
"Tuvalu\0"
"Tyap\0"
"Ugaritic\0"
"Ukrainian\0"
"Upper Sorbian\0"
"Urdu\0"
"Uyghur\0"
"Uzbek\0"
"Vai\0"
"Venda\0"
"Vietnamese\0"
"Volapuk\0"
"Vunjo\0"
"Walloon\0"
"Walser\0"
"Warlpiri\0"
"Welsh\0"
"Western Balochi\0"
"Western Frisian\0"
"Wolaytta\0"
"Wolof\0"
"Xhosa\0"
"Yangben\0"
"Yiddish\0"
"Yoruba\0"
"Zarma\0"
"Zhuang\0"
"Zulu\0"
;

static const quint16 language_name_index[] = {
     0, // AnyLanguage
     8, // C
    10, // Abkhazian
    20, // Afar
    25, // Afrikaans
    35, // Aghem
    41, // Akan
    46, // Akkadian
    55, // Akoose
    62, // Albanian
    71, // American Sign Language
    94, // Amharic
   102, // Ancient Egyptian
   119, // Ancient Greek
   133, // Arabic
   140, // Aragonese
   150, // Aramaic
   158, // Armenian
   167, // Assamese
   176, // Asturian
   185, // Asu
   189, // Atsam
   195, // Avaric
   202, // Avestan
   210, // Aymara
   217, // Azerbaijani
   229, // Bafia
   235, // Balinese
   244, // Bambara
   252, // Bamun
   258, // Bangla
   265, // Basaa
   271, // Bashkir
   279, // Basque
   286, // Batak Toba
   297, // Belarusian
   308, // Bemba
   314, // Bena
   319, // Bhojpuri
   328, // Bislama
   336, // Blin
   341, // Bodo
   346, // Bosnian
   354, // Breton
   361, // Buginese
   370, // Bulgarian
   380, // Burmese
   388, // Cantonese
   398, // Catalan
   406, // Cebuano
   414, // Central Atlas Tamazight
   438, // Central Kurdish
   454, // Chakma
   461, // Chamorro
   470, // Chechen
   478, // Cherokee
   487, // Chickasaw
   497, // Chiga
   503, // Chinese
   511, // Church
   518, // Chuvash
   526, // Colognian
   536, // Coptic
   543, // Cornish
   551, // Corsican
   560, // Cree
   565, // Croatian
   574, // Czech
   580, // Danish
   587, // Divehi
   594, // Dogri
   600, // Duala
   606, // Dutch
   612, // Dzongkha
   621, // Embu
   626, // English
   634, // Erzya
   640, // Esperanto
   650, // Estonian
   659, // Ewe
   663, // Ewondo
   670, // Faroese
   678, // Fijian
   685, // Filipino
   694, // Finnish
   702, // French
   709, // Friulian
   718, // Fulah
   724, // Gaelic
   731, // Ga
   734, // Galician
   743, // Ganda
   749, // Geez
   754, // Georgian
   763, // German
   770, // Gothic
   777, // Greek
   783, // Guarani
   791, // Gujarati
   800, // Gusii
   806, // Haitian
   814, // Hausa
   820, // Hawaiian
   829, // Hebrew
   836, // Herero
   843, // Hindi
   849, // Hiri Motu
   859, // Hungarian
   869, // Icelandic
   879, // Ido
   883, // Igbo
   888, // Inari Sami
   899, // Indonesian
   910, // Ingush
   917, // Interlingua
   929, // Interlingue
   941, // Inuktitut
   951, // Inupiaq
   959, // Irish
   965, // Italian
   973, // Japanese
   982, // Javanese
   991, // Jju
   995, // Jola Fonyi
  1006, // Kabuverdianu
  1019, // Kabyle
  1026, // Kako
  1031, // Kalaallisut
  1043, // Kalenjin
  1052, // Kamba
  1058, // Kannada
  1066, // Kanuri
  1073, // Kashmiri
  1082, // Kazakh
  1089, // Kenyang
  1097, // Khmer
  1103, // Kiche
  1109, // Kikuyu
  1116, // Kinyarwanda
  1128, // Komi
  1133, // Kongo
  1139, // Konkani
  1147, // Korean
  1154, // Koro
  1159, // Koyraboro Senni
  1175, // Koyra Chiini
  1188, // Kpelle
  1195, // Kuanyama
  1204, // Kurdish
  1212, // Kwasio
  1219, // Kyrgyz
  1226, // Lakota
  1233, // Langi
  1239, // Lao
  1243, // Latin
  1249, // Latvian
  1257, // Lezghian
  1266, // Limburgish
  1277, // Lingala
  1285, // Literary Chinese
  1302, // Lithuanian
  1313, // Lojban
  1320, // Lower Sorbian
  1334, // Low German
  1345, // Luba Katanga
  1358, // Lule Sami
  1368, // Luo
  1372, // Luxembourgish
  1386, // Luyia
  1392, // Macedonian
  1403, // Machame
  1411, // Maithili
  1420, // Makhuwa Meetto
  1435, // Makonde
  1443, // Malagasy
  1452, // Malayalam
  1462, // Malay
  1468, // Maltese
  1476, // Mandingo
  1485, // Manipuri
  1494, // Manx
  1499, // Maori
  1505, // Mapuche
  1513, // Marathi
  1521, // Marshallese
  1533, // Masai
  1539, // Mazanderani
  1551, // Mende
  1557, // Meru
  1562, // Meta
  1567, // Mohawk
  1574, // Mongolian
  1584, // Morisyen
  1593, // Mundang
  1601, // Muscogee
  1610, // Nama
  1615, // Nauru
  1621, // Navajo
  1628, // Ndonga
  1635, // Nepali
  1642, // Newari
  1649, // Ngiemboon
  1659, // Ngomba
  1666, // Nigerian Pidgin
  1682, // Nko
  1686, // Northern Luri
  1700, // Northern Sami
  1714, // Northern Sotho
  1729, // North Ndebele
  1743, // Norwegian Bokmal
  1760, // Norwegian Nynorsk
  1778, // Nuer
  1783, // Nyanja
  1790, // Nyankole
  1799, // Occitan
  1807, // Odia
  1812, // Ojibwa
  1819, // Old Irish
  1829, // Old Norse
  1839, // Old Persian
  1851, // Oromo
  1857, // Osage
  1863, // Ossetic
  1871, // Pahlavi
  1879, // Palauan
  1887, // Pali
  1892, // Papiamento
  1903, // Pashto
  1910, // Persian
  1918, // Phoenician
  1929, // Polish
  1936, // Portuguese
  1947, // Prussian
  1956, // Punjabi
  1964, // Quechua
  1972, // Romanian
  1981, // Romansh
  1989, // Rombo
  1995, // Rundi
  2001, // Russian
  2009, // Rwa
  2013, // Saho
  2018, // Sakha
  2024, // Samburu
  2032, // Samoan
  2039, // Sango
  2045, // Sangu
  2051, // Sanskrit
  2060, // Santali
  2068, // Sardinian
  2078, // Saurashtra
  2089, // Sena
  2094, // Serbian
  2102, // Shambala
  2111, // Shona
  2117, // Sichuan Yi
  2128, // Sicilian
  2137, // Sidamo
  2144, // Silesian
  2153, // Sindhi
  2160, // Sinhala
  2168, // Skolt Sami
  2179, // Slovak
  2186, // Slovenian
  2196, // Soga
  2201, // Somali
  2208, // Southern Kurdish
  2225, // Southern Sami
  2239, // Southern Sotho
  2254, // South Ndebele
  2268, // Spanish
  2276, // Standard Moroccan Tamazight
  2304, // Sundanese
  2314, // Swahili
  2322, // Swati
  2328, // Swedish
  2336, // Swiss German
  2349, // Syriac
  2356, // Tachelhit
  2366, // Tahitian
  2375, // Tai Dam
  2383, // Taita
  2389, // Tajik
  2395, // Tamil
  2401, // Taroko
  2408, // Tasawaq
  2416, // Tatar
  2422, // Telugu
  2429, // Teso
  2434, // Thai
  2439, // Tibetan
  2447, // Tigre
  2453, // Tigrinya
  2462, // Tokelau
  2470, // Tok Pisin
  2480, // Tongan
  2487, // Tsonga
  2494, // Tswana
  2501, // Turkish
  2509, // Turkmen
  2517, // Tuvalu
  2524, // Tyap
  2529, // Ugaritic
  2538, // Ukrainian
  2548, // Upper Sorbian
  2562, // Urdu
  2567, // Uyghur
  2574, // Uzbek
  2580, // Vai
  2584, // Venda
  2590, // Vietnamese
  2601, // Volapuk
  2609, // Vunjo
  2615, // Walloon
  2623, // Walser
  2630, // Warlpiri
  2639, // Welsh
  2645, // Western Balochi
  2661, // Western Frisian
  2677, // Wolaytta
  2686, // Wolof
  2692, // Xhosa
  2698, // Yangben
  2706, // Yiddish
  2714, // Yoruba
  2721, // Zarma
  2727, // Zhuang
  2734, // Zulu
};

static const char script_name_list[] =
"Default\0"
"Adlam\0"
"Ahom\0"
"Anatolian Hieroglyphs\0"
"Arabic\0"
"Armenian\0"
"Avestan\0"
"Balinese\0"
"Bamum\0"
"Bangla\0"
"Bassa Vah\0"
"Batak\0"
"Bhaiksuki\0"
"Bopomofo\0"
"Brahmi\0"
"Braille\0"
"Buginese\0"
"Buhid\0"
"Canadian Aboriginal\0"
"Carian\0"
"Caucasian Albanian\0"
"Chakma\0"
"Cham\0"
"Cherokee\0"
"Coptic\0"
"Cuneiform\0"
"Cypriot\0"
"Cyrillic\0"
"Deseret\0"
"Devanagari\0"
"Duployan\0"
"Egyptian Hieroglyphs\0"
"Elbasan\0"
"Ethiopic\0"
"Fraser\0"
"Georgian\0"
"Glagolitic\0"
"Gothic\0"
"Grantha\0"
"Greek\0"
"Gujarati\0"
"Gurmukhi\0"
"Hangul\0"
"Han\0"
"Hanunoo\0"
"Han with Bopomofo\0"
"Hatran\0"
"Hebrew\0"
"Hiragana\0"
"Imperial Aramaic\0"
"Inscriptional Pahlavi\0"
"Inscriptional Parthian\0"
"Jamo\0"
"Japanese\0"
"Javanese\0"
"Kaithi\0"
"Kannada\0"
"Katakana\0"
"Kayah Li\0"
"Kharoshthi\0"
"Khmer\0"
"Khojki\0"
"Khudawadi\0"
"Korean\0"
"Lanna\0"
"Lao\0"
"Latin\0"
"Lepcha\0"
"Limbu\0"
"Linear A\0"
"Linear B\0"
"Lycian\0"
"Lydian\0"
"Mahajani\0"
"Malayalam\0"
"Mandaean\0"
"Manichaean\0"
"Marchen\0"
"Meitei Mayek\0"
"Mende\0"
"Meroitic Cursive\0"
"Meroitic\0"
"Modi\0"
"Mongolian\0"
"Mro\0"
"Multani\0"
"Myanmar\0"
"Nabataean\0"
"Newa\0"
"New Tai Lue\0"
"Nko\0"
"Odia\0"
"Ogham\0"
"Ol Chiki\0"
"Old Hungarian\0"
"Old Italic\0"
"Old North Arabian\0"
"Old Permic\0"
"Old Persian\0"
"Old South Arabian\0"
"Orkhon\0"
"Osage\0"
"Osmanya\0"
"Pahawh Hmong\0"
"Palmyrene\0"
"Pau Cin Hau\0"
"Phags Pa\0"
"Phoenician\0"
"Pollard Phonetic\0"
"Psalter Pahlavi\0"
"Rejang\0"
"Runic\0"
"Samaritan\0"
"Saurashtra\0"
"Sharada\0"
"Shavian\0"
"Siddham\0"
"Sign Writing\0"
"Simplified Han\0"
"Sinhala\0"
"Sora Sompeng\0"
"Sundanese\0"
"Syloti Nagri\0"
"Syriac\0"
"Tagalog\0"
"Tagbanwa\0"
"Tai Le\0"
"Tai Viet\0"
"Takri\0"
"Tamil\0"
"Tangut\0"
"Telugu\0"
"Thaana\0"
"Thai\0"
"Tibetan\0"
"Tifinagh\0"
"Tirhuta\0"
"Traditional Han\0"
"Ugaritic\0"
"Vai\0"
"Varang Kshiti\0"
"Yi\0"
;

static const quint16 script_name_index[] = {
     0, // AnyScript
     8, // Adlam
    14, // Ahom
    19, // Anatolian Hieroglyphs
    41, // Arabic
    48, // Armenian
    57, // Avestan
    65, // Balinese
    74, // Bamum
    80, // Bangla
    87, // Bassa Vah
    97, // Batak
   103, // Bhaiksuki
   113, // Bopomofo
   122, // Brahmi
   129, // Braille
   137, // Buginese
   146, // Buhid
   152, // Canadian Aboriginal
   172, // Carian
   179, // Caucasian Albanian
   198, // Chakma
   205, // Cham
   210, // Cherokee
   219, // Coptic
   226, // Cuneiform
   236, // Cypriot
   244, // Cyrillic
   253, // Deseret
   261, // Devanagari
   272, // Duployan
   281, // Egyptian Hieroglyphs
   302, // Elbasan
   310, // Ethiopic
   319, // Fraser
   326, // Georgian
   335, // Glagolitic
   346, // Gothic
   353, // Grantha
   361, // Greek
   367, // Gujarati
   376, // Gurmukhi
   385, // Hangul
   392, // Han
   396, // Hanunoo
   404, // Han with Bopomofo
   422, // Hatran
   429, // Hebrew
   436, // Hiragana
   445, // Imperial Aramaic
   462, // Inscriptional Pahlavi
   484, // Inscriptional Parthian
   507, // Jamo
   512, // Japanese
   521, // Javanese
   530, // Kaithi
   537, // Kannada
   545, // Katakana
   554, // Kayah Li
   563, // Kharoshthi
   574, // Khmer
   580, // Khojki
   587, // Khudawadi
   597, // Korean
   604, // Lanna
   610, // Lao
   614, // Latin
   620, // Lepcha
   627, // Limbu
   633, // Linear A
   642, // Linear B
   651, // Lycian
   658, // Lydian
   665, // Mahajani
   674, // Malayalam
   684, // Mandaean
   693, // Manichaean
   704, // Marchen
   712, // Meitei Mayek
   725, // Mende
   731, // Meroitic Cursive
   748, // Meroitic
   757, // Modi
   762, // Mongolian
   772, // Mro
   776, // Multani
   784, // Myanmar
   792, // Nabataean
   802, // Newa
   807, // New Tai Lue
   819, // Nko
   823, // Odia
   828, // Ogham
   834, // Ol Chiki
   843, // Old Hungarian
   857, // Old Italic
   868, // Old North Arabian
   886, // Old Permic
   897, // Old Persian
   909, // Old South Arabian
   927, // Orkhon
   934, // Osage
   940, // Osmanya
   948, // Pahawh Hmong
   961, // Palmyrene
   971, // Pau Cin Hau
   983, // Phags Pa
   992, // Phoenician
  1003, // Pollard Phonetic
  1020, // Psalter Pahlavi
  1036, // Rejang
  1043, // Runic
  1049, // Samaritan
  1059, // Saurashtra
  1070, // Sharada
  1078, // Shavian
  1086, // Siddham
  1094, // Sign Writing
  1107, // Simplified Han
  1122, // Sinhala
  1130, // Sora Sompeng
  1143, // Sundanese
  1153, // Syloti Nagri
  1166, // Syriac
  1173, // Tagalog
  1181, // Tagbanwa
  1190, // Tai Le
  1197, // Tai Viet
  1206, // Takri
  1212, // Tamil
  1218, // Tangut
  1225, // Telugu
  1232, // Thaana
  1239, // Thai
  1244, // Tibetan
  1252, // Tifinagh
  1261, // Tirhuta
  1269, // Traditional Han
  1285, // Ugaritic
  1294, // Vai
  1298, // Varang Kshiti
  1312, // Yi
};

static const char country_name_list[] =
"Default\0"
"Afghanistan\0"
"Aland Islands\0"
"Albania\0"
"Algeria\0"
"American Samoa\0"
"Andorra\0"
"Angola\0"
"Anguilla\0"
"Antarctica\0"
"Antigua And Barbuda\0"
"Argentina\0"
"Armenia\0"
"Aruba\0"
"Ascension Island\0"
"Australia\0"
"Austria\0"
"Azerbaijan\0"
"Bahamas\0"
"Bahrain\0"
"Bangladesh\0"
"Barbados\0"
"Belarus\0"
"Belgium\0"
"Belize\0"
"Benin\0"
"Bermuda\0"
"Bhutan\0"
"Bolivia\0"
"Bosnia And Herzegovina\0"
"Botswana\0"
"Bouvet Island\0"
"Brazil\0"
"British Indian Ocean Territory\0"
"British Virgin Islands\0"
"Brunei\0"
"Bulgaria\0"
"Burkina Faso\0"
"Burundi\0"
"Cambodia\0"
"Cameroon\0"
"Canada\0"
"Canary Islands\0"
"Cape Verde\0"
"Caribbean Netherlands\0"
"Cayman Islands\0"
"Central African Republic\0"
"Ceuta And Melilla\0"
"Chad\0"
"Chile\0"
"China\0"
"Christmas Island\0"
"Clipperton Island\0"
"Cocos Islands\0"
"Colombia\0"
"Comoros\0"
"Congo Brazzaville\0"
"Congo Kinshasa\0"
"Cook Islands\0"
"Costa Rica\0"
"Croatia\0"
"Cuba\0"
"Curacao\0"
"Cyprus\0"
"Czechia\0"
"Denmark\0"
"Diego Garcia\0"
"Djibouti\0"
"Dominica\0"
"Dominican Republic\0"
"Ecuador\0"
"Egypt\0"
"El Salvador\0"
"Equatorial Guinea\0"
"Eritrea\0"
"Estonia\0"
"Eswatini\0"
"Ethiopia\0"
"Europe\0"
"European Union\0"
"Falkland Islands\0"
"Faroe Islands\0"
"Fiji\0"
"Finland\0"
"France\0"
"French Guiana\0"
"French Polynesia\0"
"French Southern Territories\0"
"Gabon\0"
"Gambia\0"
"Georgia\0"
"Germany\0"
"Ghana\0"
"Gibraltar\0"
"Greece\0"
"Greenland\0"
"Grenada\0"
"Guadeloupe\0"
"Guam\0"
"Guatemala\0"
"Guernsey\0"
"Guinea Bissau\0"
"Guinea\0"
"Guyana\0"
"Haiti\0"
"Heard And McDonald Islands\0"
"Honduras\0"
"Hong Kong\0"
"Hungary\0"
"Iceland\0"
"India\0"
"Indonesia\0"
"Iran\0"
"Iraq\0"
"Ireland\0"
"Isle Of Man\0"
"Israel\0"
"Italy\0"
"Ivory Coast\0"
"Jamaica\0"
"Japan\0"
"Jersey\0"
"Jordan\0"
"Kazakhstan\0"
"Kenya\0"
"Kiribati\0"
"Kosovo\0"
"Kuwait\0"
"Kyrgyzstan\0"
"Laos\0"
"Latin America\0"
"Latvia\0"
"Lebanon\0"
"Lesotho\0"
"Liberia\0"
"Libya\0"
"Liechtenstein\0"
"Lithuania\0"
"Luxembourg\0"
"Macao\0"
"Macedonia\0"
"Madagascar\0"
"Malawi\0"
"Malaysia\0"
"Maldives\0"
"Mali\0"
"Malta\0"
"Marshall Islands\0"
"Martinique\0"
"Mauritania\0"
"Mauritius\0"
"Mayotte\0"
"Mexico\0"
"Micronesia\0"
"Moldova\0"
"Monaco\0"
"Mongolia\0"
"Montenegro\0"
"Montserrat\0"
"Morocco\0"
"Mozambique\0"
"Myanmar\0"
"Namibia\0"
"Nauru\0"
"Nepal\0"
"Netherlands\0"
"New Caledonia\0"
"New Zealand\0"
"Nicaragua\0"
"Nigeria\0"
"Niger\0"
"Niue\0"
"Norfolk Island\0"
"Northern Mariana Islands\0"
"North Korea\0"
"Norway\0"
"Oman\0"
"Outlying Oceania\0"
"Pakistan\0"
"Palau\0"
"Palestinian Territories\0"
"Panama\0"
"Papua New Guinea\0"
"Paraguay\0"
"Peru\0"
"Philippines\0"
"Pitcairn\0"
"Poland\0"
"Portugal\0"
"Puerto Rico\0"
"Qatar\0"
"Reunion\0"
"Romania\0"
"Russia\0"
"Rwanda\0"
"Saint Barthelemy\0"
"Saint Helena\0"
"Saint Kitts And Nevis\0"
"Saint Lucia\0"
"Saint Martin\0"
"Saint Pierre And Miquelon\0"
"Saint Vincent And Grenadines\0"
"Samoa\0"
"San Marino\0"
"Sao Tome And Principe\0"
"Saudi Arabia\0"
"Senegal\0"
"Serbia\0"
"Seychelles\0"
"Sierra Leone\0"
"Singapore\0"
"Sint Maarten\0"
"Slovakia\0"
"Slovenia\0"
"Solomon Islands\0"
"Somalia\0"
"South Africa\0"
"South Georgia And South Sandwich Islands\0"
"South Korea\0"
"South Sudan\0"
"Spain\0"
"Sri Lanka\0"
"Sudan\0"
"Suriname\0"
"Svalbard And Jan Mayen\0"
"Sweden\0"
"Switzerland\0"
"Syria\0"
"Taiwan\0"
"Tajikistan\0"
"Tanzania\0"
"Thailand\0"
"Timor-Leste\0"
"Togo\0"
"Tokelau\0"
"Tonga\0"
"Trinidad And Tobago\0"
"Tristan Da Cunha\0"
"Tunisia\0"
"Turkey\0"
"Turkmenistan\0"
"Turks And Caicos Islands\0"
"Tuvalu\0"
"Uganda\0"
"Ukraine\0"
"United Arab Emirates\0"
"United Kingdom\0"
"United States Outlying Islands\0"
"United States\0"
"United States Virgin Islands\0"
"Uruguay\0"
"Uzbekistan\0"
"Vanuatu\0"
"Vatican City\0"
"Venezuela\0"
"Vietnam\0"
"Wallis And Futuna\0"
"Western Sahara\0"
"World\0"
"Yemen\0"
"Zambia\0"
"Zimbabwe\0"
;

static const quint16 country_name_index[] = {
     0, // AnyCountry
     8, // Afghanistan
    20, // Aland Islands
    34, // Albania
    42, // Algeria
    50, // American Samoa
    65, // Andorra
    73, // Angola
    80, // Anguilla
    89, // Antarctica
   100, // Antigua And Barbuda
   120, // Argentina
   130, // Armenia
   138, // Aruba
   144, // Ascension Island
   161, // Australia
   171, // Austria
   179, // Azerbaijan
   190, // Bahamas
   198, // Bahrain
   206, // Bangladesh
   217, // Barbados
   226, // Belarus
   234, // Belgium
   242, // Belize
   249, // Benin
   255, // Bermuda
   263, // Bhutan
   270, // Bolivia
   278, // Bosnia And Herzegovina
   301, // Botswana
   310, // Bouvet Island
   324, // Brazil
   331, // British Indian Ocean Territory
   362, // British Virgin Islands
   385, // Brunei
   392, // Bulgaria
   401, // Burkina Faso
   414, // Burundi
   422, // Cambodia
   431, // Cameroon
   440, // Canada
   447, // Canary Islands
   462, // Cape Verde
   473, // Caribbean Netherlands
   495, // Cayman Islands
   510, // Central African Republic
   535, // Ceuta And Melilla
   553, // Chad
   558, // Chile
   564, // China
   570, // Christmas Island
   587, // Clipperton Island
   605, // Cocos Islands
   619, // Colombia
   628, // Comoros
   636, // Congo Brazzaville
   654, // Congo Kinshasa
   669, // Cook Islands
   682, // Costa Rica
   693, // Croatia
   701, // Cuba
   706, // Curacao
   714, // Cyprus
   721, // Czechia
   729, // Denmark
   737, // Diego Garcia
   750, // Djibouti
   759, // Dominica
   768, // Dominican Republic
   787, // Ecuador
   795, // Egypt
   801, // El Salvador
   813, // Equatorial Guinea
   831, // Eritrea
   839, // Estonia
   847, // Eswatini
   856, // Ethiopia
   865, // Europe
   872, // European Union
   887, // Falkland Islands
   904, // Faroe Islands
   918, // Fiji
   923, // Finland
   931, // France
   938, // French Guiana
   952, // French Polynesia
   969, // French Southern Territories
   997, // Gabon
  1003, // Gambia
  1010, // Georgia
  1018, // Germany
  1026, // Ghana
  1032, // Gibraltar
  1042, // Greece
  1049, // Greenland
  1059, // Grenada
  1067, // Guadeloupe
  1078, // Guam
  1083, // Guatemala
  1093, // Guernsey
  1102, // Guinea Bissau
  1116, // Guinea
  1123, // Guyana
  1130, // Haiti
  1136, // Heard And McDonald Islands
  1163, // Honduras
  1172, // Hong Kong
  1182, // Hungary
  1190, // Iceland
  1198, // India
  1204, // Indonesia
  1214, // Iran
  1219, // Iraq
  1224, // Ireland
  1232, // Isle Of Man
  1244, // Israel
  1251, // Italy
  1257, // Ivory Coast
  1269, // Jamaica
  1277, // Japan
  1283, // Jersey
  1290, // Jordan
  1297, // Kazakhstan
  1308, // Kenya
  1314, // Kiribati
  1323, // Kosovo
  1330, // Kuwait
  1337, // Kyrgyzstan
  1348, // Laos
  1353, // Latin America
  1367, // Latvia
  1374, // Lebanon
  1382, // Lesotho
  1390, // Liberia
  1398, // Libya
  1404, // Liechtenstein
  1418, // Lithuania
  1428, // Luxembourg
  1439, // Macao
  1445, // Macedonia
  1455, // Madagascar
  1466, // Malawi
  1473, // Malaysia
  1482, // Maldives
  1491, // Mali
  1496, // Malta
  1502, // Marshall Islands
  1519, // Martinique
  1530, // Mauritania
  1541, // Mauritius
  1551, // Mayotte
  1559, // Mexico
  1566, // Micronesia
  1577, // Moldova
  1585, // Monaco
  1592, // Mongolia
  1601, // Montenegro
  1612, // Montserrat
  1623, // Morocco
  1631, // Mozambique
  1642, // Myanmar
  1650, // Namibia
  1658, // Nauru
  1664, // Nepal
  1670, // Netherlands
  1682, // New Caledonia
  1696, // New Zealand
  1708, // Nicaragua
  1718, // Nigeria
  1726, // Niger
  1732, // Niue
  1737, // Norfolk Island
  1752, // Northern Mariana Islands
  1777, // North Korea
  1789, // Norway
  1796, // Oman
  1801, // Outlying Oceania
  1818, // Pakistan
  1827, // Palau
  1833, // Palestinian Territories
  1857, // Panama
  1864, // Papua New Guinea
  1881, // Paraguay
  1890, // Peru
  1895, // Philippines
  1907, // Pitcairn
  1916, // Poland
  1923, // Portugal
  1932, // Puerto Rico
  1944, // Qatar
  1950, // Reunion
  1958, // Romania
  1966, // Russia
  1973, // Rwanda
  1980, // Saint Barthelemy
  1997, // Saint Helena
  2010, // Saint Kitts And Nevis
  2032, // Saint Lucia
  2044, // Saint Martin
  2057, // Saint Pierre And Miquelon
  2083, // Saint Vincent And Grenadines
  2112, // Samoa
  2118, // San Marino
  2129, // Sao Tome And Principe
  2151, // Saudi Arabia
  2164, // Senegal
  2172, // Serbia
  2179, // Seychelles
  2190, // Sierra Leone
  2203, // Singapore
  2213, // Sint Maarten
  2226, // Slovakia
  2235, // Slovenia
  2244, // Solomon Islands
  2260, // Somalia
  2268, // South Africa
  2281, // South Georgia And South Sandwich Islands
  2322, // South Korea
  2334, // South Sudan
  2346, // Spain
  2352, // Sri Lanka
  2362, // Sudan
  2368, // Suriname
  2377, // Svalbard And Jan Mayen
  2400, // Sweden
  2407, // Switzerland
  2419, // Syria
  2425, // Taiwan
  2432, // Tajikistan
  2443, // Tanzania
  2452, // Thailand
  2461, // Timor-Leste
  2473, // Togo
  2478, // Tokelau
  2486, // Tonga
  2492, // Trinidad And Tobago
  2512, // Tristan Da Cunha
  2529, // Tunisia
  2537, // Turkey
  2544, // Turkmenistan
  2557, // Turks And Caicos Islands
  2582, // Tuvalu
  2589, // Uganda
  2596, // Ukraine
  2604, // United Arab Emirates
  2625, // United Kingdom
  2640, // United States Outlying Islands
  2671, // United States
  2685, // United States Virgin Islands
  2714, // Uruguay
  2722, // Uzbekistan
  2733, // Vanuatu
  2741, // Vatican City
  2754, // Venezuela
  2764, // Vietnam
  2772, // Wallis And Futuna
  2790, // Western Sahara
  2805, // World
  2811, // Yemen
  2817, // Zambia
  2824, // Zimbabwe
};

static const unsigned char language_code_list[] =
"  \0" // AnyLanguage
"  \0" // C
"ab\0" // Abkhazian
"aa\0" // Afar
"af\0" // Afrikaans
"agq" // Aghem
"ak\0" // Akan
"akk" // Akkadian
"bss" // Akoose
"sq\0" // Albanian
"ase" // American Sign Language
"am\0" // Amharic
"egy" // Ancient Egyptian
"grc" // Ancient Greek
"ar\0" // Arabic
"an\0" // Aragonese
"arc" // Aramaic
"hy\0" // Armenian
"as\0" // Assamese
"ast" // Asturian
"asa" // Asu
"cch" // Atsam
"av\0" // Avaric
"ae\0" // Avestan
"ay\0" // Aymara
"az\0" // Azerbaijani
"ksf" // Bafia
"ban" // Balinese
"bm\0" // Bambara
"bax" // Bamun
"bn\0" // Bangla
"bas" // Basaa
"ba\0" // Bashkir
"eu\0" // Basque
"bbc" // Batak Toba
"be\0" // Belarusian
"bem" // Bemba
"bez" // Bena
"bho" // Bhojpuri
"bi\0" // Bislama
"byn" // Blin
"brx" // Bodo
"bs\0" // Bosnian
"br\0" // Breton
"bug" // Buginese
"bg\0" // Bulgarian
"my\0" // Burmese
"yue" // Cantonese
"ca\0" // Catalan
"ceb" // Cebuano
"tzm" // Central Atlas Tamazight
"ckb" // Central Kurdish
"ccp" // Chakma
"ch\0" // Chamorro
"ce\0" // Chechen
"chr" // Cherokee
"cic" // Chickasaw
"cgg" // Chiga
"zh\0" // Chinese
"cu\0" // Church
"cv\0" // Chuvash
"ksh" // Colognian
"cop" // Coptic
"kw\0" // Cornish
"co\0" // Corsican
"cr\0" // Cree
"hr\0" // Croatian
"cs\0" // Czech
"da\0" // Danish
"dv\0" // Divehi
"doi" // Dogri
"dua" // Duala
"nl\0" // Dutch
"dz\0" // Dzongkha
"ebu" // Embu
"en\0" // English
"myv" // Erzya
"eo\0" // Esperanto
"et\0" // Estonian
"ee\0" // Ewe
"ewo" // Ewondo
"fo\0" // Faroese
"fj\0" // Fijian
"fil" // Filipino
"fi\0" // Finnish
"fr\0" // French
"fur" // Friulian
"ff\0" // Fulah
"gd\0" // Gaelic
"gaa" // Ga
"gl\0" // Galician
"lg\0" // Ganda
"gez" // Geez
"ka\0" // Georgian
"de\0" // German
"got" // Gothic
"el\0" // Greek
"gn\0" // Guarani
"gu\0" // Gujarati
"guz" // Gusii
"ht\0" // Haitian
"ha\0" // Hausa
"haw" // Hawaiian
"he\0" // Hebrew
"hz\0" // Herero
"hi\0" // Hindi
"ho\0" // Hiri Motu
"hu\0" // Hungarian
"is\0" // Icelandic
"io\0" // Ido
"ig\0" // Igbo
"smn" // Inari Sami
"id\0" // Indonesian
"inh" // Ingush
"ia\0" // Interlingua
"ie\0" // Interlingue
"iu\0" // Inuktitut
"ik\0" // Inupiaq
"ga\0" // Irish
"it\0" // Italian
"ja\0" // Japanese
"jv\0" // Javanese
"kaj" // Jju
"dyo" // Jola Fonyi
"kea" // Kabuverdianu
"kab" // Kabyle
"kkj" // Kako
"kl\0" // Kalaallisut
"kln" // Kalenjin
"kam" // Kamba
"kn\0" // Kannada
"kr\0" // Kanuri
"ks\0" // Kashmiri
"kk\0" // Kazakh
"ken" // Kenyang
"km\0" // Khmer
"quc" // Kiche
"ki\0" // Kikuyu
"rw\0" // Kinyarwanda
"kv\0" // Komi
"kg\0" // Kongo
"kok" // Konkani
"ko\0" // Korean
"kfo" // Koro
"ses" // Koyraboro Senni
"khq" // Koyra Chiini
"kpe" // Kpelle
"kj\0" // Kuanyama
"ku\0" // Kurdish
"nmg" // Kwasio
"ky\0" // Kyrgyz
"lkt" // Lakota
"lag" // Langi
"lo\0" // Lao
"la\0" // Latin
"lv\0" // Latvian
"lez" // Lezghian
"li\0" // Limburgish
"ln\0" // Lingala
"lzh" // Literary Chinese
"lt\0" // Lithuanian
"jbo" // Lojban
"dsb" // Lower Sorbian
"nds" // Low German
"lu\0" // Luba Katanga
"smj" // Lule Sami
"luo" // Luo
"lb\0" // Luxembourgish
"luy" // Luyia
"mk\0" // Macedonian
"jmc" // Machame
"mai" // Maithili
"mgh" // Makhuwa Meetto
"kde" // Makonde
"mg\0" // Malagasy
"ml\0" // Malayalam
"ms\0" // Malay
"mt\0" // Maltese
"man" // Mandingo
"mni" // Manipuri
"gv\0" // Manx
"mi\0" // Maori
"arn" // Mapuche
"mr\0" // Marathi
"mh\0" // Marshallese
"mas" // Masai
"mzn" // Mazanderani
"men" // Mende
"mer" // Meru
"mgo" // Meta
"moh" // Mohawk
"mn\0" // Mongolian
"mfe" // Morisyen
"mua" // Mundang
"mus" // Muscogee
"naq" // Nama
"na\0" // Nauru
"nv\0" // Navajo
"ng\0" // Ndonga
"ne\0" // Nepali
"new" // Newari
"nnh" // Ngiemboon
"jgo" // Ngomba
"pcm" // Nigerian Pidgin
"nqo" // Nko
"lrc" // Northern Luri
"se\0" // Northern Sami
"nso" // Northern Sotho
"nd\0" // North Ndebele
"nb\0" // Norwegian Bokmal
"nn\0" // Norwegian Nynorsk
"nus" // Nuer
"ny\0" // Nyanja
"nyn" // Nyankole
"oc\0" // Occitan
"or\0" // Odia
"oj\0" // Ojibwa
"sga" // Old Irish
"non" // Old Norse
"peo" // Old Persian
"om\0" // Oromo
"osa" // Osage
"os\0" // Ossetic
"pal" // Pahlavi
"pau" // Palauan
"pi\0" // Pali
"pap" // Papiamento
"ps\0" // Pashto
"fa\0" // Persian
"phn" // Phoenician
"pl\0" // Polish
"pt\0" // Portuguese
"prg" // Prussian
"pa\0" // Punjabi
"qu\0" // Quechua
"ro\0" // Romanian
"rm\0" // Romansh
"rof" // Rombo
"rn\0" // Rundi
"ru\0" // Russian
"rwk" // Rwa
"ssy" // Saho
"sah" // Sakha
"saq" // Samburu
"sm\0" // Samoan
"sg\0" // Sango
"sbp" // Sangu
"sa\0" // Sanskrit
"sat" // Santali
"sc\0" // Sardinian
"saz" // Saurashtra
"seh" // Sena
"sr\0" // Serbian
"ksb" // Shambala
"sn\0" // Shona
"ii\0" // Sichuan Yi
"scn" // Sicilian
"sid" // Sidamo
"szl" // Silesian
"sd\0" // Sindhi
"si\0" // Sinhala
"sms" // Skolt Sami
"sk\0" // Slovak
"sl\0" // Slovenian
"xog" // Soga
"so\0" // Somali
"sdh" // Southern Kurdish
"sma" // Southern Sami
"st\0" // Southern Sotho
"nr\0" // South Ndebele
"es\0" // Spanish
"zgh" // Standard Moroccan Tamazight
"su\0" // Sundanese
"sw\0" // Swahili
"ss\0" // Swati
"sv\0" // Swedish
"gsw" // Swiss German
"syr" // Syriac
"shi" // Tachelhit
"ty\0" // Tahitian
"blt" // Tai Dam
"dav" // Taita
"tg\0" // Tajik
"ta\0" // Tamil
"trv" // Taroko
"twq" // Tasawaq
"tt\0" // Tatar
"te\0" // Telugu
"teo" // Teso
"th\0" // Thai
"bo\0" // Tibetan
"tig" // Tigre
"ti\0" // Tigrinya
"tkl" // Tokelau
"tpi" // Tok Pisin
"to\0" // Tongan
"ts\0" // Tsonga
"tn\0" // Tswana
"tr\0" // Turkish
"tk\0" // Turkmen
"tvl" // Tuvalu
"kcg" // Tyap
"uga" // Ugaritic
"uk\0" // Ukrainian
"hsb" // Upper Sorbian
"ur\0" // Urdu
"ug\0" // Uyghur
"uz\0" // Uzbek
"vai" // Vai
"ve\0" // Venda
"vi\0" // Vietnamese
"vo\0" // Volapuk
"vun" // Vunjo
"wa\0" // Walloon
"wae" // Walser
"wbp" // Warlpiri
"cy\0" // Welsh
"bgn" // Western Balochi
"fy\0" // Western Frisian
"wal" // Wolaytta
"wo\0" // Wolof
"xh\0" // Xhosa
"yav" // Yangben
"yi\0" // Yiddish
"yo\0" // Yoruba
"dje" // Zarma
"za\0" // Zhuang
"zu\0" // Zulu
;

static const unsigned char script_code_list[] =
"Zzzz" // AnyScript
"Adlm" // Adlam
"Ahom" // Ahom
"Hluw" // Anatolian Hieroglyphs
"Arab" // Arabic
"Armn" // Armenian
"Avst" // Avestan
"Bali" // Balinese
"Bamu" // Bamum
"Beng" // Bangla
"Bass" // Bassa Vah
"Batk" // Batak
"Bhks" // Bhaiksuki
"Bopo" // Bopomofo
"Brah" // Brahmi
"Brai" // Braille
"Bugi" // Buginese
"Buhd" // Buhid
"Cans" // Canadian Aboriginal
"Cari" // Carian
"Aghb" // Caucasian Albanian
"Cakm" // Chakma
"Cham" // Cham
"Cher" // Cherokee
"Copt" // Coptic
"Xsux" // Cuneiform
"Cprt" // Cypriot
"Cyrl" // Cyrillic
"Dsrt" // Deseret
"Deva" // Devanagari
"Dupl" // Duployan
"Egyp" // Egyptian Hieroglyphs
"Elba" // Elbasan
"Ethi" // Ethiopic
"Lisu" // Fraser
"Geor" // Georgian
"Glag" // Glagolitic
"Goth" // Gothic
"Gran" // Grantha
"Grek" // Greek
"Gujr" // Gujarati
"Guru" // Gurmukhi
"Hang" // Hangul
"Hani" // Han
"Hano" // Hanunoo
"Hanb" // Han with Bopomofo
"Hatr" // Hatran
"Hebr" // Hebrew
"Hira" // Hiragana
"Armi" // Imperial Aramaic
"Phli" // Inscriptional Pahlavi
"Prti" // Inscriptional Parthian
"Jamo" // Jamo
"Jpan" // Japanese
"Java" // Javanese
"Kthi" // Kaithi
"Knda" // Kannada
"Kana" // Katakana
"Kali" // Kayah Li
"Khar" // Kharoshthi
"Khmr" // Khmer
"Khoj" // Khojki
"Sind" // Khudawadi
"Kore" // Korean
"Lana" // Lanna
"Laoo" // Lao
"Latn" // Latin
"Lepc" // Lepcha
"Limb" // Limbu
"Lina" // Linear A
"Linb" // Linear B
"Lyci" // Lycian
"Lydi" // Lydian
"Mahj" // Mahajani
"Mlym" // Malayalam
"Mand" // Mandaean
"Mani" // Manichaean
"Marc" // Marchen
"Mtei" // Meitei Mayek
"Mend" // Mende
"Merc" // Meroitic Cursive
"Mero" // Meroitic
"Modi" // Modi
"Mong" // Mongolian
"Mroo" // Mro
"Mult" // Multani
"Mymr" // Myanmar
"Nbat" // Nabataean
"Newa" // Newa
"Talu" // New Tai Lue
"Nkoo" // Nko
"Orya" // Odia
"Ogam" // Ogham
"Olck" // Ol Chiki
"Hung" // Old Hungarian
"Ital" // Old Italic
"Narb" // Old North Arabian
"Perm" // Old Permic
"Xpeo" // Old Persian
"Sarb" // Old South Arabian
"Orkh" // Orkhon
"Osge" // Osage
"Osma" // Osmanya
"Hmng" // Pahawh Hmong
"Palm" // Palmyrene
"Pauc" // Pau Cin Hau
"Phag" // Phags Pa
"Phnx" // Phoenician
"Plrd" // Pollard Phonetic
"Phlp" // Psalter Pahlavi
"Rjng" // Rejang
"Runr" // Runic
"Samr" // Samaritan
"Saur" // Saurashtra
"Shrd" // Sharada
"Shaw" // Shavian
"Sidd" // Siddham
"Sgnw" // Sign Writing
"Hans" // Simplified Han
"Sinh" // Sinhala
"Sora" // Sora Sompeng
"Sund" // Sundanese
"Sylo" // Syloti Nagri
"Syrc" // Syriac
"Tglg" // Tagalog
"Tagb" // Tagbanwa
"Tale" // Tai Le
"Tavt" // Tai Viet
"Takr" // Takri
"Taml" // Tamil
"Tang" // Tangut
"Telu" // Telugu
"Thaa" // Thaana
"Thai" // Thai
"Tibt" // Tibetan
"Tfng" // Tifinagh
"Tirh" // Tirhuta
"Hant" // Traditional Han
"Ugar" // Ugaritic
"Vaii" // Vai
"Wara" // Varang Kshiti
"Yiii" // Yi
;

static const unsigned char country_code_list[] =
"ZZ\0" // AnyCountry
"AF\0" // Afghanistan
"AX\0" // Aland Islands
"AL\0" // Albania
"DZ\0" // Algeria
"AS\0" // American Samoa
"AD\0" // Andorra
"AO\0" // Angola
"AI\0" // Anguilla
"AQ\0" // Antarctica
"AG\0" // Antigua And Barbuda
"AR\0" // Argentina
"AM\0" // Armenia
"AW\0" // Aruba
"AC\0" // Ascension Island
"AU\0" // Australia
"AT\0" // Austria
"AZ\0" // Azerbaijan
"BS\0" // Bahamas
"BH\0" // Bahrain
"BD\0" // Bangladesh
"BB\0" // Barbados
"BY\0" // Belarus
"BE\0" // Belgium
"BZ\0" // Belize
"BJ\0" // Benin
"BM\0" // Bermuda
"BT\0" // Bhutan
"BO\0" // Bolivia
"BA\0" // Bosnia And Herzegovina
"BW\0" // Botswana
"BV\0" // Bouvet Island
"BR\0" // Brazil
"IO\0" // British Indian Ocean Territory
"VG\0" // British Virgin Islands
"BN\0" // Brunei
"BG\0" // Bulgaria
"BF\0" // Burkina Faso
"BI\0" // Burundi
"KH\0" // Cambodia
"CM\0" // Cameroon
"CA\0" // Canada
"IC\0" // Canary Islands
"CV\0" // Cape Verde
"BQ\0" // Caribbean Netherlands
"KY\0" // Cayman Islands
"CF\0" // Central African Republic
"EA\0" // Ceuta And Melilla
"TD\0" // Chad
"CL\0" // Chile
"CN\0" // China
"CX\0" // Christmas Island
"CP\0" // Clipperton Island
"CC\0" // Cocos Islands
"CO\0" // Colombia
"KM\0" // Comoros
"CG\0" // Congo Brazzaville
"CD\0" // Congo Kinshasa
"CK\0" // Cook Islands
"CR\0" // Costa Rica
"HR\0" // Croatia
"CU\0" // Cuba
"CW\0" // Curacao
"CY\0" // Cyprus
"CZ\0" // Czechia
"DK\0" // Denmark
"DG\0" // Diego Garcia
"DJ\0" // Djibouti
"DM\0" // Dominica
"DO\0" // Dominican Republic
"EC\0" // Ecuador
"EG\0" // Egypt
"SV\0" // El Salvador
"GQ\0" // Equatorial Guinea
"ER\0" // Eritrea
"EE\0" // Estonia
"SZ\0" // Eswatini
"ET\0" // Ethiopia
"150" // Europe
"EU\0" // European Union
"FK\0" // Falkland Islands
"FO\0" // Faroe Islands
"FJ\0" // Fiji
"FI\0" // Finland
"FR\0" // France
"GF\0" // French Guiana
"PF\0" // French Polynesia
"TF\0" // French Southern Territories
"GA\0" // Gabon
"GM\0" // Gambia
"GE\0" // Georgia
"DE\0" // Germany
"GH\0" // Ghana
"GI\0" // Gibraltar
"GR\0" // Greece
"GL\0" // Greenland
"GD\0" // Grenada
"GP\0" // Guadeloupe
"GU\0" // Guam
"GT\0" // Guatemala
"GG\0" // Guernsey
"GW\0" // Guinea Bissau
"GN\0" // Guinea
"GY\0" // Guyana
"HT\0" // Haiti
"HM\0" // Heard And McDonald Islands
"HN\0" // Honduras
"HK\0" // Hong Kong
"HU\0" // Hungary
"IS\0" // Iceland
"IN\0" // India
"ID\0" // Indonesia
"IR\0" // Iran
"IQ\0" // Iraq
"IE\0" // Ireland
"IM\0" // Isle Of Man
"IL\0" // Israel
"IT\0" // Italy
"CI\0" // Ivory Coast
"JM\0" // Jamaica
"JP\0" // Japan
"JE\0" // Jersey
"JO\0" // Jordan
"KZ\0" // Kazakhstan
"KE\0" // Kenya
"KI\0" // Kiribati
"XK\0" // Kosovo
"KW\0" // Kuwait
"KG\0" // Kyrgyzstan
"LA\0" // Laos
"419" // Latin America
"LV\0" // Latvia
"LB\0" // Lebanon
"LS\0" // Lesotho
"LR\0" // Liberia
"LY\0" // Libya
"LI\0" // Liechtenstein
"LT\0" // Lithuania
"LU\0" // Luxembourg
"MO\0" // Macao
"MK\0" // Macedonia
"MG\0" // Madagascar
"MW\0" // Malawi
"MY\0" // Malaysia
"MV\0" // Maldives
"ML\0" // Mali
"MT\0" // Malta
"MH\0" // Marshall Islands
"MQ\0" // Martinique
"MR\0" // Mauritania
"MU\0" // Mauritius
"YT\0" // Mayotte
"MX\0" // Mexico
"FM\0" // Micronesia
"MD\0" // Moldova
"MC\0" // Monaco
"MN\0" // Mongolia
"ME\0" // Montenegro
"MS\0" // Montserrat
"MA\0" // Morocco
"MZ\0" // Mozambique
"MM\0" // Myanmar
"NA\0" // Namibia
"NR\0" // Nauru
"NP\0" // Nepal
"NL\0" // Netherlands
"NC\0" // New Caledonia
"NZ\0" // New Zealand
"NI\0" // Nicaragua
"NG\0" // Nigeria
"NE\0" // Niger
"NU\0" // Niue
"NF\0" // Norfolk Island
"MP\0" // Northern Mariana Islands
"KP\0" // North Korea
"NO\0" // Norway
"OM\0" // Oman
"QO\0" // Outlying Oceania
"PK\0" // Pakistan
"PW\0" // Palau
"PS\0" // Palestinian Territories
"PA\0" // Panama
"PG\0" // Papua New Guinea
"PY\0" // Paraguay
"PE\0" // Peru
"PH\0" // Philippines
"PN\0" // Pitcairn
"PL\0" // Poland
"PT\0" // Portugal
"PR\0" // Puerto Rico
"QA\0" // Qatar
"RE\0" // Reunion
"RO\0" // Romania
"RU\0" // Russia
"RW\0" // Rwanda
"BL\0" // Saint Barthelemy
"SH\0" // Saint Helena
"KN\0" // Saint Kitts And Nevis
"LC\0" // Saint Lucia
"MF\0" // Saint Martin
"PM\0" // Saint Pierre And Miquelon
"VC\0" // Saint Vincent And Grenadines
"WS\0" // Samoa
"SM\0" // San Marino
"ST\0" // Sao Tome And Principe
"SA\0" // Saudi Arabia
"SN\0" // Senegal
"RS\0" // Serbia
"SC\0" // Seychelles
"SL\0" // Sierra Leone
"SG\0" // Singapore
"SX\0" // Sint Maarten
"SK\0" // Slovakia
"SI\0" // Slovenia
"SB\0" // Solomon Islands
"SO\0" // Somalia
"ZA\0" // South Africa
"GS\0" // South Georgia And South Sandwich Islands
"KR\0" // South Korea
"SS\0" // South Sudan
"ES\0" // Spain
"LK\0" // Sri Lanka
"SD\0" // Sudan
"SR\0" // Suriname
"SJ\0" // Svalbard And Jan Mayen
"SE\0" // Sweden
"CH\0" // Switzerland
"SY\0" // Syria
"TW\0" // Taiwan
"TJ\0" // Tajikistan
"TZ\0" // Tanzania
"TH\0" // Thailand
"TL\0" // Timor-Leste
"TG\0" // Togo
"TK\0" // Tokelau
"TO\0" // Tonga
"TT\0" // Trinidad And Tobago
"TA\0" // Tristan Da Cunha
"TN\0" // Tunisia
"TR\0" // Turkey
"TM\0" // Turkmenistan
"TC\0" // Turks And Caicos Islands
"TV\0" // Tuvalu
"UG\0" // Uganda
"UA\0" // Ukraine
"AE\0" // United Arab Emirates
"GB\0" // United Kingdom
"UM\0" // United States Outlying Islands
"US\0" // United States
"VI\0" // United States Virgin Islands
"UY\0" // Uruguay
"UZ\0" // Uzbekistan
"VU\0" // Vanuatu
"VA\0" // Vatican City
"VE\0" // Venezuela
"VN\0" // Vietnam
"WF\0" // Wallis And Futuna
"EH\0" // Western Sahara
"001" // World
"YE\0" // Yemen
"ZM\0" // Zambia
"ZW\0" // Zimbabwe
;

// GENERATED PART ENDS HERE

QT_END_NAMESPACE

#endif
