/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;

public class SerialVersionUID {
    public static void setSerialVersionUID(CtClass clazz) throws CannotCompileException, NotFoundException {
        try {
            clazz.getDeclaredField("serialVersionUID");
            return;
        }
        catch (NotFoundException notFoundException) {
            if (!SerialVersionUID.isSerializable(clazz)) {
                return;
            }
            CtField field = new CtField(CtClass.longType, "serialVersionUID", clazz);
            field.setModifiers(26);
            clazz.addField(field, SerialVersionUID.calculateDefault(clazz) + "L");
            return;
        }
    }

    private static boolean isSerializable(CtClass clazz) throws NotFoundException {
        ClassPool pool = clazz.getClassPool();
        return clazz.subtypeOf(pool.get("java.io.Serializable"));
    }

    public static long calculateDefault(CtClass clazz) throws CannotCompileException {
        try {
            int mods;
            int i;
            int i2;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out2 = new DataOutputStream(bout);
            ClassFile classFile = clazz.getClassFile();
            String javaName = SerialVersionUID.javaName(clazz);
            out2.writeUTF(javaName);
            CtMethod[] methods2 = clazz.getDeclaredMethods();
            int classMods = clazz.getModifiers();
            if ((classMods & 0x200) != 0) {
                classMods = methods2.length > 0 ? (classMods |= 0x400) : (classMods &= 0xFFFFFBFF);
            }
            out2.writeInt(classMods);
            Object[] interfaces = classFile.getInterfaces();
            for (i2 = 0; i2 < interfaces.length; ++i2) {
                interfaces[i2] = SerialVersionUID.javaName((String)interfaces[i2]);
            }
            Arrays.sort(interfaces);
            for (i2 = 0; i2 < interfaces.length; ++i2) {
                out2.writeUTF((String)interfaces[i2]);
            }
            CtField[] fields2 = clazz.getDeclaredFields();
            Arrays.sort(fields2, new Comparator(){

                public int compare(Object o1, Object o2) {
                    CtField field1 = (CtField)o1;
                    CtField field2 = (CtField)o2;
                    return field1.getName().compareTo(field2.getName());
                }
            });
            for (int i3 = 0; i3 < fields2.length; ++i3) {
                CtField field = fields2[i3];
                int mods2 = field.getModifiers();
                if ((mods2 & 2) != 0 && (mods2 & 0x88) != 0) continue;
                out2.writeUTF(field.getName());
                out2.writeInt(mods2);
                out2.writeUTF(field.getFieldInfo2().getDescriptor());
            }
            if (classFile.getStaticInitializer() != null) {
                out2.writeUTF("<clinit>");
                out2.writeInt(8);
                out2.writeUTF("()V");
            }
            CtConstructor[] constructors2 = clazz.getDeclaredConstructors();
            Arrays.sort(constructors2, new Comparator(){

                public int compare(Object o1, Object o2) {
                    CtConstructor c1 = (CtConstructor)o1;
                    CtConstructor c2 = (CtConstructor)o2;
                    return c1.getMethodInfo2().getDescriptor().compareTo(c2.getMethodInfo2().getDescriptor());
                }
            });
            for (i = 0; i < constructors2.length; ++i) {
                CtConstructor constructor = constructors2[i];
                mods = constructor.getModifiers();
                if ((mods & 2) != 0) continue;
                out2.writeUTF("<init>");
                out2.writeInt(mods);
                out2.writeUTF(constructor.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            Arrays.sort(methods2, new Comparator(){

                public int compare(Object o1, Object o2) {
                    CtMethod m1 = (CtMethod)o1;
                    CtMethod m2 = (CtMethod)o2;
                    int value2 = m1.getName().compareTo(m2.getName());
                    if (value2 == 0) {
                        value2 = m1.getMethodInfo2().getDescriptor().compareTo(m2.getMethodInfo2().getDescriptor());
                    }
                    return value2;
                }
            });
            for (i = 0; i < methods2.length; ++i) {
                CtMethod method = methods2[i];
                mods = method.getModifiers() & 0xD3F;
                if ((mods & 2) != 0) continue;
                out2.writeUTF(method.getName());
                out2.writeInt(mods);
                out2.writeUTF(method.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            out2.flush();
            MessageDigest digest = MessageDigest.getInstance("SHA");
            byte[] digested = digest.digest(bout.toByteArray());
            long hash = 0L;
            for (int i4 = Math.min(digested.length, 8) - 1; i4 >= 0; --i4) {
                hash = hash << 8 | (long)(digested[i4] & 0xFF);
            }
            return hash;
        }
        catch (IOException e) {
            throw new CannotCompileException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CannotCompileException(e);
        }
    }

    private static String javaName(CtClass clazz) {
        return Descriptor.toJavaName(Descriptor.toJvmName(clazz));
    }

    private static String javaName(String name) {
        return Descriptor.toJavaName(Descriptor.toJvmName(name));
    }
}

