/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.ReplicationStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class XByteBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(XByteBuffer.class);
    private static final byte[] START_DATA = new byte[]{70, 76, 84, 50, 48, 48, 50};
    private static final byte[] END_DATA = new byte[]{84, 76, 70, 50, 48, 48, 51};
    protected byte[] buf = null;
    protected int bufSize = 0;
    protected boolean discard = true;
    private static AtomicInteger invokecount = new AtomicInteger(0);

    public XByteBuffer(int n, boolean bl) {
        this.buf = new byte[n];
        this.discard = bl;
    }

    public XByteBuffer(byte[] byArray, boolean bl) {
        this(byArray, byArray.length + 128, bl);
    }

    public XByteBuffer(byte[] byArray, int n, boolean bl) {
        int n2 = Math.max(byArray.length, n);
        this.buf = new byte[n2];
        System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
        this.bufSize = byArray.length;
        this.discard = bl;
    }

    public int getLength() {
        return this.bufSize;
    }

    public void setLength(int n) {
        if (n > this.buf.length) {
            throw new ArrayIndexOutOfBoundsException("Size is larger than existing buffer.");
        }
        this.bufSize = n;
    }

    public void trim(int n) {
        if (this.bufSize - n < 0) {
            throw new ArrayIndexOutOfBoundsException("Can't trim more bytes than are available. length:" + this.bufSize + " trim:" + n);
        }
        this.bufSize -= n;
    }

    public void reset() {
        this.bufSize = 0;
    }

    public byte[] getBytesDirect() {
        return this.buf;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.bufSize];
        System.arraycopy(this.buf, 0, byArray, 0, this.bufSize);
        return byArray;
    }

    public void clear() {
        this.bufSize = 0;
    }

    public boolean append(ByteBuffer byteBuffer, int n) {
        int n2 = this.bufSize + n;
        if (n2 > this.buf.length) {
            this.expand(n2);
        }
        byteBuffer.get(this.buf, this.bufSize, n);
        this.bufSize = n2;
        if (this.discard && this.bufSize > START_DATA.length && XByteBuffer.firstIndexOf(this.buf, 0, START_DATA) == -1) {
            this.bufSize = 0;
            log.error((Object)"Discarded the package, invalid header");
            return false;
        }
        return true;
    }

    public boolean append(byte by) {
        int n = this.bufSize + 1;
        if (n > this.buf.length) {
            this.expand(n);
        }
        this.buf[this.bufSize] = by;
        this.bufSize = n;
        return true;
    }

    public boolean append(boolean bl) {
        int n = this.bufSize + 1;
        if (n > this.buf.length) {
            this.expand(n);
        }
        XByteBuffer.toBytes(bl, this.buf, this.bufSize);
        this.bufSize = n;
        return true;
    }

    public boolean append(long l) {
        int n = this.bufSize + 8;
        if (n > this.buf.length) {
            this.expand(n);
        }
        XByteBuffer.toBytes(l, this.buf, this.bufSize);
        this.bufSize = n;
        return true;
    }

    public boolean append(int n) {
        int n2 = this.bufSize + 4;
        if (n2 > this.buf.length) {
            this.expand(n2);
        }
        XByteBuffer.toBytes(n, this.buf, this.bufSize);
        this.bufSize = n2;
        return true;
    }

    public boolean append(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return false;
        }
        int n3 = this.bufSize + n2;
        if (n3 > this.buf.length) {
            this.expand(n3);
        }
        System.arraycopy(byArray, n, this.buf, this.bufSize, n2);
        this.bufSize = n3;
        if (this.discard && this.bufSize > START_DATA.length && XByteBuffer.firstIndexOf(this.buf, 0, START_DATA) == -1) {
            this.bufSize = 0;
            log.error((Object)"Discarded the package, invalid header");
            return false;
        }
        return true;
    }

    public void expand(int n) {
        byte[] byArray = new byte[Math.max(this.buf.length << 1, n)];
        System.arraycopy(this.buf, 0, byArray, 0, this.bufSize);
        this.buf = byArray;
    }

    public int getCapacity() {
        return this.buf.length;
    }

    public int countPackages() {
        return this.countPackages(false);
    }

    public int countPackages(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = START_DATA.length;
        int n6 = 0;
        while (n6 < this.bufSize && (n3 = XByteBuffer.firstIndexOf(this.buf, n6, START_DATA)) == n6 && this.bufSize - n6 >= 14 && (n5 = n6 + START_DATA.length + 4 + (n2 = XByteBuffer.toInt(this.buf, n5))) + END_DATA.length <= this.bufSize && (n = XByteBuffer.firstIndexOf(this.buf, n5, END_DATA)) == n5) {
            ++n4;
            n6 = n5 + END_DATA.length;
            n5 = n6 + START_DATA.length;
            if (!bl) continue;
            break;
        }
        return n4;
    }

    public boolean doesPackageExist() {
        return this.countPackages(true) > 0;
    }

    public XByteBuffer extractDataPackage(boolean bl) {
        int n = this.countPackages(true);
        if (n == 0) {
            throw new IllegalStateException("No package exists in XByteBuffer");
        }
        int n2 = XByteBuffer.toInt(this.buf, START_DATA.length);
        XByteBuffer xByteBuffer = BufferPool.getBufferPool().getBuffer(n2, false);
        xByteBuffer.setLength(n2);
        System.arraycopy(this.buf, START_DATA.length + 4, xByteBuffer.getBytesDirect(), 0, n2);
        if (bl) {
            int n3 = START_DATA.length + 4 + n2 + END_DATA.length;
            this.bufSize -= n3;
            System.arraycopy(this.buf, n3, this.buf, 0, this.bufSize);
        }
        return xByteBuffer;
    }

    public ChannelData extractPackage(boolean bl) throws IOException {
        XByteBuffer xByteBuffer = this.extractDataPackage(bl);
        ChannelData channelData = ChannelData.getDataFromPackage(xByteBuffer);
        return channelData;
    }

    public static byte[] createDataPackage(ChannelData channelData) {
        int n = channelData.getDataPackageLength();
        int n2 = XByteBuffer.getDataPackageLength(n);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        System.arraycopy(START_DATA, 0, byArray, n3, START_DATA.length);
        n3 += START_DATA.length;
        XByteBuffer.toBytes(n, byArray, START_DATA.length);
        channelData.getDataPackage(byArray, n3 += 4);
        System.arraycopy(END_DATA, 0, byArray, n3 += n, END_DATA.length);
        n3 += END_DATA.length;
        return byArray;
    }

    public static byte[] createDataPackage(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray2.length - n3 > XByteBuffer.getDataPackageLength(n2)) {
            throw new ArrayIndexOutOfBoundsException("Unable to create data package, buffer is too small.");
        }
        System.arraycopy(START_DATA, 0, byArray2, n3, START_DATA.length);
        XByteBuffer.toBytes(byArray.length, byArray2, n3 + START_DATA.length);
        System.arraycopy(byArray, n, byArray2, n3 + START_DATA.length + 4, n2);
        System.arraycopy(END_DATA, 0, byArray2, n3 + START_DATA.length + 4 + byArray.length, END_DATA.length);
        return byArray2;
    }

    public static int getDataPackageLength(int n) {
        int n2 = START_DATA.length + 4 + n + END_DATA.length;
        return n2;
    }

    public static byte[] createDataPackage(byte[] byArray) {
        int n = XByteBuffer.getDataPackageLength(byArray.length);
        byte[] byArray2 = new byte[n];
        return XByteBuffer.createDataPackage(byArray, 0, byArray.length, byArray2, 0);
    }

    public static int toInt(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 0] & 0xFF) << 24);
    }

    public static long toLong(byte[] byArray, int n) {
        return ((long)byArray[n + 7] & 0xFFL) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 0] & 0xFFL) << 56);
    }

    @Deprecated
    public static byte[] toBytes(boolean bl) {
        byte[] byArray = new byte[1];
        return XByteBuffer.toBytes(bl, byArray, 0);
    }

    public static byte[] toBytes(boolean bl, byte[] byArray, int n) {
        byArray[n] = (byte)(bl ? 1 : 0);
        return byArray;
    }

    public static boolean toBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    @Deprecated
    public static byte[] toBytes(int n) {
        return XByteBuffer.toBytes(n, new byte[4], 0);
    }

    public static byte[] toBytes(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)n;
        byArray[n2 + 2] = (byte)(n >>>= 8);
        byArray[n2 + 1] = (byte)(n >>>= 8);
        byArray[n2 + 0] = (byte)(n >>>= 8);
        return byArray;
    }

    @Deprecated
    public static byte[] toBytes(long l) {
        return XByteBuffer.toBytes(l, new byte[8], 0);
    }

    public static byte[] toBytes(long l, byte[] byArray, int n) {
        byArray[n + 7] = (byte)l;
        byArray[n + 6] = (byte)(l >>>= 8);
        byArray[n + 5] = (byte)(l >>>= 8);
        byArray[n + 4] = (byte)(l >>>= 8);
        byArray[n + 3] = (byte)(l >>>= 8);
        byArray[n + 2] = (byte)(l >>>= 8);
        byArray[n + 1] = (byte)(l >>>= 8);
        byArray[n + 0] = (byte)(l >>>= 8);
        return byArray;
    }

    public static int firstIndexOf(byte[] byArray, int n, byte[] byArray2) {
        int n2 = -1;
        if (byArray2.length > byArray.length) {
            return n2;
        }
        if (byArray2.length == 0 || byArray.length == 0) {
            return n2;
        }
        if (n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean bl = false;
        int n3 = byArray.length;
        int n4 = byArray2.length;
        byte by = byArray2[0];
        int n5 = n;
        while (!bl) {
            while (n5 < n3 && by != byArray[n5]) {
                ++n5;
            }
            if (n5 >= n3) {
                return -1;
            }
            if (n3 - n5 < n4) {
                return -1;
            }
            bl = true;
            for (int i = 1; i < n4 && bl; ++i) {
                bl = byArray2[i] == byArray[n5 + i];
            }
            if (bl) {
                n2 = n5;
                continue;
            }
            if (n3 - n5 < n4) {
                return -1;
            }
            ++n5;
        }
        return n2;
    }

    public static Serializable deserialize(byte[] byArray) throws IOException, ClassNotFoundException, ClassCastException {
        return XByteBuffer.deserialize(byArray, 0, byArray.length);
    }

    public static Serializable deserialize(byte[] byArray, int n, int n2) throws IOException, ClassNotFoundException, ClassCastException {
        return XByteBuffer.deserialize(byArray, n, n2, null);
    }

    public static Serializable deserialize(byte[] byArray, int n, int n2, ClassLoader[] classLoaderArray) throws IOException, ClassNotFoundException, ClassCastException {
        invokecount.addAndGet(1);
        Object object = null;
        if (classLoaderArray == null) {
            classLoaderArray = new ClassLoader[]{};
        }
        if (byArray != null && n2 > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            ObjectInputStream objectInputStream = null;
            objectInputStream = classLoaderArray.length > 0 ? new ReplicationStream(byteArrayInputStream, classLoaderArray) : new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            ((InputStream)byteArrayInputStream).close();
            objectInputStream.close();
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Serializable) {
            return (Serializable)object;
        }
        throw new ClassCastException("Message has the wrong class. It should implement Serializable, instead it is:" + object.getClass().getName());
    }

    public static byte[] serialize(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public void setDiscard(boolean bl) {
        this.discard = bl;
    }

    public boolean getDiscard() {
        return this.discard;
    }
}

