/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

public class IPv6Utils {
    private static final int MAX_NUMBER_OF_GROUPS = 8;
    private static final int MAX_GROUP_LENGTH = 4;

    public static String canonize(String string) throws IllegalArgumentException {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        if (!IPv6Utils.mayBeIPv6Address(string)) {
            return string;
        }
        int n3 = string.length();
        if (string.contains(".")) {
            int n4 = string.lastIndexOf(":");
            int n5 = string.lastIndexOf("::");
            n3 = n5 >= 0 && n4 == n5 + 1 ? n4 + 1 : n4;
        } else if (string.contains("%")) {
            n3 = string.lastIndexOf("%");
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[][] cArray = new char[8][4];
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        int n10 = -1;
        int n11 = 0;
        boolean bl = true;
        boolean bl2 = true;
        StringBuilder stringBuilder2 = new StringBuilder(string);
        int n12 = string.indexOf("::");
        int n13 = n3;
        int n14 = 0;
        if (n12 >= 0 && n12 < n3 - 1) {
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                if (string.charAt(n) != ':') continue;
                ++n2;
            }
            if (n12 == 0) {
                stringBuilder2.insert(0, "0");
                ++n14;
            }
            for (n = 0; n < 8 - n2; ++n) {
                stringBuilder2.insert(n12 + 1, "0:");
                n14 += 2;
            }
            if (n12 == n3 - 2) {
                stringBuilder2.setCharAt(n12 + n14 + 1, '0');
            } else {
                stringBuilder2.deleteCharAt(n12 + n14 + 1);
                --n14;
            }
            n13 += n14;
        }
        for (n2 = 0; n2 < n13; ++n2) {
            n = stringBuilder2.charAt(n2);
            if (n >= 65 && n <= 70) {
                n = (char)(n + 32);
            }
            if (n != 58) {
                cArray[n6][n7] = n;
                if (!bl2 || n != 48) {
                    ++n7;
                    bl2 = false;
                }
                if (n != 48) {
                    bl = false;
                }
            }
            if (n != 58 && n2 != n13 - 1) continue;
            if (bl) {
                ++n9;
                if (n8 == -1) {
                    n8 = n6;
                }
            }
            if (!bl || n2 == n13 - 1) {
                if (n9 > n11) {
                    n11 = n9;
                    n10 = n8;
                }
                n9 = 0;
                n8 = -1;
            }
            ++n6;
            n7 = 0;
            bl = true;
            bl2 = true;
        }
        n2 = n6;
        for (n6 = 0; n6 < n2; ++n6) {
            if (n11 <= 1 || n6 < n10 || n6 >= n10 + n11) {
                for (n = 0; n < 4; ++n) {
                    if (cArray[n6][n] == '\u0000') continue;
                    stringBuilder.append(cArray[n6][n]);
                }
                if (n6 >= n2 - 1 || n6 == n10 - 1 && n11 > 1) continue;
                stringBuilder.append(':');
                continue;
            }
            if (n6 != n10) continue;
            stringBuilder.append("::");
        }
        n = stringBuilder.length();
        if (stringBuilder.charAt(n - 1) == ':' && n3 < string.length() && string.charAt(n3) == ':') {
            stringBuilder.delete(n - 1, n);
        }
        for (int i = n3; i < string.length(); ++i) {
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    static boolean mayBeIPv6Address(String string) {
        char c;
        if (string == null) {
            return false;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2 && (c = string.charAt(i)) != '.' && c != '%'; ++i) {
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == ':')) {
                return false;
            }
            if (c != ':') continue;
            ++n;
        }
        return n >= 2;
    }
}

