/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import joptsimple.ArgumentList;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecVisitor;

abstract class OptionSpec {
    private final List options = new ArrayList();
    private final String description;

    protected OptionSpec(String option) {
        this(Collections.singletonList(option), "");
    }

    protected OptionSpec(List options, String description) {
        this.arrangeOptions(options);
        this.description = description;
    }

    List options() {
        return this.options;
    }

    String description() {
        return this.description;
    }

    abstract void handleOption(OptionParser var1, ArgumentList var2, OptionSet var3, String var4);

    abstract boolean acceptsArguments();

    abstract boolean requiresArgument();

    abstract void accept(OptionSpecVisitor var1);

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !this.getClass().equals(that.getClass())) {
            return false;
        }
        OptionSpec other = (OptionSpec)that;
        return ((Object)this.options).equals(other.options);
    }

    public int hashCode() {
        return ((Object)this.options).hashCode();
    }

    private void arrangeOptions(List unarranged) {
        if (unarranged.size() == 1) {
            this.options.addAll(unarranged);
            return;
        }
        ArrayList<String> shortOptions = new ArrayList<String>();
        ArrayList<String> longOptions = new ArrayList<String>();
        Iterator iter = unarranged.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            if (next.length() == 1) {
                shortOptions.add(next);
                continue;
            }
            longOptions.add(next);
        }
        Collections.sort(shortOptions);
        Collections.sort(longOptions);
        this.options.addAll(shortOptions);
        this.options.addAll(longOptions);
    }
}

