// export interface Thenable<R> {
//     then<U>(onFulfilled?: (value: R) => U | Thenable<U>,  onRejected?: (error: any) => U | Thenable<U>): Thenable<U>;
// }
//
// export interface Promise<R> extends Thenable<R> {
//
//     /**
//      * onFulfilled is called when/if "promise" resolves. onRejected is called when/if "promise" rejects.
//      * Both are optional, if either/both are omitted the next onFulfilled/onRejected in the chain is called.
//      * Both callbacks have a single parameter , the fulfillment value or rejection reason.
//      * "then" returns a new promise equivalent to the value you return from onFulfilled/onRejected after being passed through Promise.resolve.
//      * If an error is thrown in the callback, the returned promise rejects with that error.
//      *
//      * @param onFulfilled called when/if "promise" resolves
//      * @param onRejected called when/if "promise" rejects
//      */
//     then<U>(onFulfilled?: (value: R) => U | Thenable<U>,  onRejected?: (error: any) => U | Thenable<U>): Promise<U>;
//
//     /**
//      * Sugar for promise.then(undefined, onRejected)
//      *
//      * @param onRejected called when/if "promise" rejects
//      */
//     catch<U>(onRejected?: (error: any) => U | Thenable<U>): Promise<U>;
// }
//
//# sourceMappingURL=promise.js.map