/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;

public class IDTracker {
    private static final Log LOG = LogFactory.getLog(IDTracker.class);
    private Map<String, List<PageViewport>> idLocations = new HashMap<String, List<PageViewport>>();
    private Map<String, Set<Resolvable>> unresolvedIDRefs = new HashMap<String, Set<Resolvable>>();
    private Set<String> unfinishedIDs = new HashSet<String>();
    private Set<String> alreadyResolvedIDs = new HashSet<String>();

    public void associateIDWithPageViewport(String id, PageViewport pv) {
        List<PageViewport> pvList;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("associateIDWithPageViewport(" + id + ", " + pv + ")"));
        }
        if ((pvList = this.idLocations.get(id)) == null) {
            pvList = new ArrayList<PageViewport>();
            this.idLocations.put(id, pvList);
            pvList.add(pv);
            pv.setFirstWithID(id);
            if (!this.unfinishedIDs.contains(id)) {
                this.tryIDResolution(id, pvList);
            }
        } else if (!pvList.contains(pv)) {
            pvList.add(pv);
        }
    }

    public void signalPendingID(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("signalPendingID(" + id + ")"));
        }
        this.unfinishedIDs.add(id);
    }

    public void signalIDProcessed(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("signalIDProcessed(" + id + ")"));
        }
        this.alreadyResolvedIDs.add(id);
        if (!this.unfinishedIDs.contains(id)) {
            return;
        }
        this.unfinishedIDs.remove(id);
        List<PageViewport> idLocs = this.idLocations.get(id);
        Set<Resolvable> todo = this.unresolvedIDRefs.get(id);
        if (todo != null) {
            for (Resolvable res : todo) {
                res.resolveIDRef(id, idLocs);
            }
            this.unresolvedIDRefs.remove(id);
        }
    }

    public boolean alreadyResolvedID(String id) {
        return this.alreadyResolvedIDs.contains(id);
    }

    private void tryIDResolution(String id, List<PageViewport> pvList) {
        Set<Resolvable> todo = this.unresolvedIDRefs.get(id);
        if (todo != null) {
            for (Resolvable res : todo) {
                if (!this.unfinishedIDs.contains(id)) {
                    res.resolveIDRef(id, pvList);
                    continue;
                }
                return;
            }
            this.alreadyResolvedIDs.add(id);
            this.unresolvedIDRefs.remove(id);
        }
    }

    public void tryIDResolution(PageViewport pv) {
        String[] ids = pv.getIDRefs();
        if (ids != null) {
            for (String id : ids) {
                List<PageViewport> pvList = this.idLocations.get(id);
                if (pvList == null || pvList.isEmpty()) continue;
                this.tryIDResolution(id, pvList);
            }
        }
    }

    public List<PageViewport> getPageViewportsContainingID(String id) {
        List<PageViewport> idLocs;
        if (this.idLocations != null && !this.idLocations.isEmpty() && (idLocs = this.idLocations.get(id)) != null) {
            return idLocs;
        }
        return Collections.emptyList();
    }

    public PageViewport getFirstPageViewportContaining(String id) {
        List<PageViewport> list = this.getPageViewportsContainingID(id);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PageViewport getLastPageViewportContaining(String id) {
        List<PageViewport> list = this.getPageViewportsContainingID(id);
        if (list != null && !list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public void addUnresolvedIDRef(String idref, Resolvable res) {
        Set<Resolvable> todo = this.unresolvedIDRefs.get(idref);
        if (todo == null) {
            todo = new HashSet<Resolvable>();
            this.unresolvedIDRefs.put(idref, todo);
        }
        todo.add(res);
    }

    public void replacePageViewPort(PageViewport oldPageViewPort, PageViewport newPageViewPort) {
        for (List<PageViewport> viewPortList : this.idLocations.values()) {
            int len = viewPortList.size();
            for (int i = 0; i < len; ++i) {
                PageViewport currPV = viewPortList.get(i);
                if (currPV != oldPageViewPort) continue;
                viewPortList.set(i, newPageViewPort);
            }
        }
    }
}

