/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.util.CollectionUtils;

public final class UnitType
extends BuildableType
implements Consumer {
    public static final int DEFAULT_OFFENCE = 0;
    public static final int DEFAULT_DEFENCE = 1;
    private int offence = 0;
    private int defence = 1;
    private int space = 0;
    private boolean defaultUnit = false;
    private int hitPoints = 0;
    private int spaceTaken = 1;
    private int skill = Integer.MIN_VALUE;
    private int price = Integer.MIN_VALUE;
    private int movement = 3;
    private int lineOfSight = 1;
    private int recruitProbability = 0;
    private GoodsType expertProduction = null;
    private int scoreValue = 0;
    private int maximumExperience = 0;
    private int maximumAttrition = Integer.MAX_VALUE;
    private int priority = 1000;
    private UnitType skillTaught = null;
    private Role defaultRole = null;
    private List<UnitTypeChange> typeChanges = null;
    private TypeCountMap<GoodsType> consumption = null;
    private static final String CONSUMES_TAG = "consumes";
    private static final String DEFAULT_EQUIPMENT_TAG = "default-equipment";
    private static final String DEFAULT_ROLE_TAG = "default-role";
    private static final String DEFAULT_UNIT_TAG = "default-unit";
    private static final String DEFENCE_TAG = "defence";
    private static final String EXPERT_PRODUCTION_TAG = "expert-production";
    private static final String HIT_POINTS_TAG = "hit-points";
    private static final String LINE_OF_SIGHT_TAG = "line-of-sight";
    private static final String MOVEMENT_TAG = "movement";
    private static final String MAXIMUM_EXPERIENCE_TAG = "maximum-experience";
    private static final String MAXIMUM_ATTRITION_TAG = "maximum-attrition";
    private static final String OFFENCE_TAG = "offence";
    private static final String PRICE_TAG = "price";
    private static final String PRIORITY_TAG = "priority";
    private static final String RECRUIT_PROBABILITY_TAG = "recruit-probability";
    private static final String SCORE_VALUE_TAG = "score-value";
    private static final String SKILL_TAG = "skill";
    private static final String SKILL_TAUGHT_TAG = "skill-taught";
    private static final String SPACE_TAG = "space";
    private static final String SPACE_TAKEN_TAG = "space-taken";
    private static final String DOWNGRADE_TAG = "downgrade";
    private static final String UNIT_TAG = "unit";
    private static final String UPGRADE_TAG = "upgrade";
    private static final String OLD_DEFAULT_UNIT_TAG = "defaultUnit";
    private static final String OLD_HIT_POINTS_TAG = "hitPoints";
    private static final String OLD_LINE_OF_SIGHT_TAG = "lineOfSight";
    private static final String OLD_MAXIMUM_EXPERIENCE_TAG = "maximumExperience";
    private static final String OLD_MAXIMUM_ATTRITION_TAG = "maximumAttrition";
    private static final String OLD_RECRUIT_PROBABILITY_TAG = "recruitProbability";
    private static final String OLD_SCORE_VALUE_TAG = "scoreValue";
    private static final String OLD_SKILL_TAUGHT_TAG = "skillTaught";
    private static final String OLD_SPACE_TAKEN_TAG = "spaceTaken";

    public UnitType(String id, Specification specification) {
        super(id, specification);
        this.defaultRole = specification.getDefaultRole();
    }

    public final String getWorkingAsKey() {
        return this.getId() + ".workingAs";
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    public int getScoreValue() {
        return this.scoreValue;
    }

    public int getBaseOffence() {
        return this.offence;
    }

    public double getOffence() {
        return this.applyModifiers(this.offence, null, "model.modifier.offence");
    }

    public boolean isOffensive() {
        return this.getBaseOffence() > 0;
    }

    public int getBaseDefence() {
        return this.defence;
    }

    public double getDefence() {
        return this.applyModifiers(this.defence, null, "model.modifier.defence");
    }

    public boolean isDefensive() {
        return this.getBaseDefence() > 1;
    }

    public boolean isDefaultUnitType() {
        return this.defaultUnit;
    }

    public int getLineOfSight() {
        return this.lineOfSight;
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int newSpace) {
        this.space = newSpace;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public int getSpaceTaken() {
        return Math.max(this.spaceTaken, this.space + 1);
    }

    public void setSpaceTaken(int newSpaceTaken) {
        this.spaceTaken = newSpaceTaken;
    }

    public boolean isRecruitable() {
        return this.recruitProbability > 0;
    }

    public int getRecruitProbability() {
        return this.recruitProbability;
    }

    public int getSkill() {
        return this.skill;
    }

    public void setSkill(int newSkill) {
        this.skill = newSkill;
    }

    public int getPrice() {
        return this.price;
    }

    public int getMovement() {
        return this.movement;
    }

    public final int getMaximumExperience() {
        return this.maximumExperience;
    }

    public int getMaximumAttrition() {
        return this.maximumAttrition;
    }

    public GoodsType getExpertProduction() {
        return this.expertProduction;
    }

    public UnitType getSkillTaught() {
        return this.skillTaught;
    }

    public Role getDefaultRole() {
        return this.defaultRole;
    }

    public List<Role> getExpertRoles() {
        return this.getSpecification().getRoles().stream().filter(r -> r.getExpertUnit() == this).collect(Collectors.toList());
    }

    public String getDisplayRoleId() {
        Iterator<Role> iterator = this.getExpertRoles().iterator();
        if (iterator.hasNext()) {
            Role r = iterator.next();
            return r.getId();
        }
        return "model.role.default";
    }

    public List<UnitTypeChange> getTypeChanges() {
        return this.typeChanges == null ? Collections.emptyList() : this.typeChanges;
    }

    public void setTypeChanges(List<UnitTypeChange> typeChanges) {
        this.typeChanges = typeChanges;
    }

    private void addTypeChange(UnitTypeChange change) {
        if (this.typeChanges == null) {
            this.typeChanges = new ArrayList<UnitTypeChange>();
        }
        this.typeChanges.add(change);
    }

    public UnitType getTargetType(UnitTypeChange.ChangeType changeType, Player player) {
        UnitTypeChange change = this.getUnitTypeChange(changeType, player);
        return change == null ? null : change.getNewUnitType();
    }

    public UnitTypeChange getUnitTypeChange(UnitTypeChange.ChangeType changeType, Player player) {
        return CollectionUtils.find(this.getTypeChanges(), c -> c.asResultOf(changeType) && c.appliesTo(player) && c.getNewUnitType().isAvailableTo(player));
    }

    public UnitTypeChange getUnitTypeChange(UnitType newType) {
        return CollectionUtils.find(this.getTypeChanges(), c -> c.getNewUnitType() == newType);
    }

    public boolean canBeUpgraded(UnitType newType, UnitTypeChange.ChangeType changeType) {
        return CollectionUtils.any(this.getTypeChanges(), c -> (newType == null || newType == c.getNewUnitType()) && c.getProbability(changeType) > 0);
    }

    public List<UnitType> getUnitTypesLearntInLostCity() {
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        for (UnitTypeChange change : this.getTypeChanges()) {
            if (!change.asResultOf(UnitTypeChange.ChangeType.LOST_CITY)) continue;
            unitTypes.add(change.getNewUnitType());
        }
        return unitTypes;
    }

    public UnitType getEducationUnit(int maximumSkill) {
        return CollectionUtils.find(this.getTypeChanges().stream().filter(c -> c.canBeTaught()).map(UnitTypeChange::getNewUnitType), ut -> ut.hasSkill() && ut.getSkill() <= maximumSkill, null);
    }

    public int getEducationTurns(UnitType unitType) {
        UnitTypeChange utc = CollectionUtils.find(this.getTypeChanges(), c -> c.asResultOf(UnitTypeChange.ChangeType.EDUCATION) && unitType == c.getNewUnitType());
        return utc == null ? Integer.MIN_VALUE : utc.getTurnsToLearn();
    }

    public boolean isNaval() {
        return this.hasAbility("model.ability.navalUnit");
    }

    public boolean isPerson() {
        return this.hasAbility("model.ability.person");
    }

    public boolean canMoveToHighSeas() {
        return this.isNaval();
    }

    public boolean hasSkill() {
        return this.skill != Integer.MIN_VALUE;
    }

    public boolean hasPrice() {
        return this.price != Integer.MIN_VALUE;
    }

    public int getConsumptionOf(GoodsType goodsType) {
        return this.consumption == null ? 0 : this.consumption.getCount(goodsType);
    }

    private void addConsumption(GoodsType type, int amount) {
        if (this.consumption == null) {
            this.consumption = new TypeCountMap();
        }
        this.consumption.incrementCount(type, amount);
    }

    @Override
    public int compareTo(FreeColObject other) {
        int cmp = 0;
        if (other instanceof UnitType) {
            UnitType ut = (UnitType)other;
            cmp = this.getIndex() - ut.getIndex();
        }
        if (cmp == 0) {
            cmp = super.compareTo(other);
        }
        return cmp;
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        if (this.consumption != null) {
            for (GoodsType goodsType : this.consumption.keySet()) {
                result.add(new AbstractGoods(goodsType, this.consumption.getCount(goodsType)));
            }
        }
        return result;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean canBuildColony() {
        return this.hasAbility("model.ability.foundColony");
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OFFENCE_TAG, this.offence);
        xw.writeAttribute(DEFENCE_TAG, this.defence);
        xw.writeAttribute(DEFAULT_UNIT_TAG, this.defaultUnit);
        xw.writeAttribute(MOVEMENT_TAG, this.movement);
        xw.writeAttribute(LINE_OF_SIGHT_TAG, this.lineOfSight);
        xw.writeAttribute(SCORE_VALUE_TAG, this.scoreValue);
        xw.writeAttribute(SPACE_TAG, this.space);
        xw.writeAttribute(SPACE_TAKEN_TAG, this.spaceTaken);
        xw.writeAttribute(HIT_POINTS_TAG, this.hitPoints);
        xw.writeAttribute(MAXIMUM_EXPERIENCE_TAG, this.maximumExperience);
        if (this.maximumAttrition < Integer.MAX_VALUE) {
            xw.writeAttribute(MAXIMUM_ATTRITION_TAG, this.maximumAttrition);
        }
        xw.writeAttribute(RECRUIT_PROBABILITY_TAG, this.recruitProbability);
        if (this.hasSkill()) {
            xw.writeAttribute(SKILL_TAG, this.skill);
        }
        if (this.hasPrice()) {
            xw.writeAttribute(PRICE_TAG, this.price);
        }
        xw.writeAttribute(SKILL_TAUGHT_TAG, this.skillTaught);
        if (this.expertProduction != null) {
            xw.writeAttribute(EXPERT_PRODUCTION_TAG, this.expertProduction);
        }
        xw.writeAttribute(PRIORITY_TAG, this.priority);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        Specification spec = this.getSpecification();
        if (this.defaultRole != null && this.defaultRole != spec.getDefaultRole()) {
            xw.writeStartElement(DEFAULT_ROLE_TAG);
            xw.writeAttribute("id", this.defaultRole);
            xw.writeEndElement();
        }
        for (UnitTypeChange change : this.getTypeChanges()) {
            change.toXML(xw);
        }
        if (this.consumption != null) {
            for (GoodsType goodsType : this.consumption.keySet()) {
                xw.writeStartElement(CONSUMES_TAG);
                xw.writeAttribute("id", goodsType);
                xw.writeAttribute("value", this.consumption.getCount(goodsType));
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        UnitType parent = xr.getType(spec, "extends", UnitType.class, this);
        this.offence = xr.getAttribute(OFFENCE_TAG, parent.offence);
        this.defence = xr.getAttribute(DEFENCE_TAG, parent.defence);
        this.defaultUnit = xr.hasAttribute(OLD_DEFAULT_UNIT_TAG) ? xr.getAttribute(OLD_DEFAULT_UNIT_TAG, false) : xr.getAttribute(DEFAULT_UNIT_TAG, false);
        this.movement = xr.getAttribute(MOVEMENT_TAG, parent.movement);
        this.lineOfSight = xr.hasAttribute(OLD_LINE_OF_SIGHT_TAG) ? xr.getAttribute(OLD_LINE_OF_SIGHT_TAG, parent.lineOfSight) : xr.getAttribute(LINE_OF_SIGHT_TAG, parent.lineOfSight);
        this.scoreValue = xr.hasAttribute(OLD_SCORE_VALUE_TAG) ? xr.getAttribute(OLD_SCORE_VALUE_TAG, parent.scoreValue) : xr.getAttribute(SCORE_VALUE_TAG, parent.scoreValue);
        this.space = xr.getAttribute(SPACE_TAG, parent.space);
        this.hitPoints = xr.hasAttribute(OLD_HIT_POINTS_TAG) ? xr.getAttribute(OLD_HIT_POINTS_TAG, parent.hitPoints) : xr.getAttribute(HIT_POINTS_TAG, parent.hitPoints);
        this.spaceTaken = xr.hasAttribute(OLD_SPACE_TAKEN_TAG) ? xr.getAttribute(OLD_SPACE_TAKEN_TAG, parent.spaceTaken) : xr.getAttribute(SPACE_TAKEN_TAG, parent.spaceTaken);
        this.maximumExperience = xr.hasAttribute(OLD_MAXIMUM_EXPERIENCE_TAG) ? xr.getAttribute(OLD_MAXIMUM_EXPERIENCE_TAG, parent.maximumExperience) : xr.getAttribute(MAXIMUM_EXPERIENCE_TAG, parent.maximumExperience);
        this.maximumAttrition = xr.hasAttribute(OLD_MAXIMUM_ATTRITION_TAG) ? xr.getAttribute(OLD_MAXIMUM_ATTRITION_TAG, parent.maximumAttrition) : xr.getAttribute(MAXIMUM_ATTRITION_TAG, parent.maximumAttrition);
        this.skillTaught = xr.hasAttribute(OLD_SKILL_TAUGHT_TAG) ? xr.getType(spec, OLD_SKILL_TAUGHT_TAG, UnitType.class, this) : xr.getType(spec, SKILL_TAUGHT_TAG, UnitType.class, this);
        this.recruitProbability = xr.hasAttribute(OLD_RECRUIT_PROBABILITY_TAG) ? xr.getAttribute(OLD_RECRUIT_PROBABILITY_TAG, parent.recruitProbability) : xr.getAttribute(RECRUIT_PROBABILITY_TAG, parent.recruitProbability);
        this.priority = xr.getAttribute(PRIORITY_TAG, 1000);
        this.skill = xr.getAttribute(SKILL_TAG, parent.skill);
        this.price = xr.getAttribute(PRICE_TAG, parent.price);
        this.expertProduction = xr.getType(spec, EXPERT_PRODUCTION_TAG, GoodsType.class, parent.expertProduction);
        if (parent != this && !xr.hasAttribute("required-population")) {
            this.setRequiredPopulation(parent.getRequiredPopulation());
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        if (xr.shouldClearContainers()) {
            this.consumption = null;
            this.typeChanges = null;
        }
        this.defaultRole = spec.getDefaultRole();
        UnitType parent = xr.getType(spec, "extends", UnitType.class, this);
        if (parent != this) {
            this.defaultRole = parent.defaultRole;
            if (parent.typeChanges != null) {
                if (this.typeChanges == null) {
                    this.typeChanges = new ArrayList<UnitTypeChange>();
                }
                this.typeChanges.addAll(parent.typeChanges);
            }
            if (parent.consumption != null) {
                if (this.consumption == null) {
                    this.consumption = new TypeCountMap();
                }
                this.consumption.putAll(parent.consumption);
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
        super.readChildren(xr);
        if (this.hasAbility("model.ability.person")) {
            Modifier m;
            if (!this.containsModifierKey("model.modifier.conversionSkill")) {
                m = new Modifier("model.modifier.conversionSkill", 8.0f, Modifier.ModifierType.ADDITIVE);
                this.addModifier(m);
                if (this.hasAbility("model.ability.expertMissionary")) {
                    m = new Modifier("model.modifier.conversionSkill", 5.0f, Modifier.ModifierType.ADDITIVE);
                    this.addModifier(m);
                }
            }
            if (!this.containsModifierKey("model.modifier.conversionAlarmRate")) {
                m = new Modifier("model.modifier.conversionAlarmRate", 2.0f, Modifier.ModifierType.PERCENTAGE);
                this.addModifier(m);
            }
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (CONSUMES_TAG.equals(tag)) {
            this.addConsumption(xr.getType(spec, "id", GoodsType.class, null), xr.getAttribute("value", Integer.MIN_VALUE));
            xr.closeTag(CONSUMES_TAG);
        } else if (DEFAULT_EQUIPMENT_TAG.equals(tag)) {
            String id = xr.getAttribute("id", null);
            String roleId = "model.equipment.horses".equals(id) ? "model.role.scout" : ("model.equipment.muskets".equals(id) ? "model.role.soldier" : ("model.equipment.tools".equals(id) ? "model.role.pioneer" : ("model.equipment.missionary".equals(id) ? "model.role.missionary" : "model.role.default")));
            this.defaultRole = spec.getRole(roleId);
            xr.closeTag(DEFAULT_EQUIPMENT_TAG);
        } else if (DEFAULT_ROLE_TAG.equals(tag)) {
            this.defaultRole = xr.getType(spec, "id", Role.class, spec.getDefaultRole());
            xr.closeTag(DEFAULT_ROLE_TAG);
        } else if (DOWNGRADE_TAG.equals(tag) || UPGRADE_TAG.equals(tag)) {
            if (xr.getAttribute("delete", false)) {
                if (this.typeChanges != null) {
                    String unitId = xr.getAttribute(UNIT_TAG, null);
                    Iterator<UnitTypeChange> it = this.typeChanges.iterator();
                    while (it.hasNext()) {
                        if (!unitId.equals(it.next().getNewUnitType().getId())) continue;
                        it.remove();
                        break;
                    }
                }
                xr.closeTag(tag);
            } else {
                UnitTypeChange change = new UnitTypeChange(xr, spec);
                if (DOWNGRADE_TAG.equals(tag) && change.getChangeTypes().isEmpty()) {
                    change.getChangeTypes().put(UnitTypeChange.ChangeType.CLEAR_SKILL, 100);
                }
                this.addTypeChange(change);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    public String getXMLTagName() {
        return UnitType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "unit-type";
    }
}

