/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.deletebydate;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateInfo
implements Comparable<DateInfo> {
    private Date _date = null;
    private String _dateString = null;
    private int _numPoints = 0;
    private boolean _toDelete = false;
    private static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateInstance();

    public static void setTimezone(TimeZone timeZone) {
        DEFAULT_DATE_FORMAT.setTimeZone(timeZone);
    }

    public DateInfo(Date date) {
        this._date = date;
        this._dateString = this._date == null ? "" : DEFAULT_DATE_FORMAT.format(this._date);
        this._numPoints = 0;
        this._toDelete = false;
    }

    public boolean isDateless() {
        return this._date == null;
    }

    public String getString() {
        return this._dateString;
    }

    public boolean isSameDate(Date date) {
        if (date == null) {
            return this._date == null;
        }
        if (this._dateString == null) {
            return false;
        }
        String string = DEFAULT_DATE_FORMAT.format(date);
        return this._dateString.equals(string);
    }

    public void incrementCount() {
        ++this._numPoints;
    }

    public int getPointCount() {
        return this._numPoints;
    }

    public void setDeleteFlag(boolean bl) {
        this._toDelete = bl;
    }

    public boolean getDeleteFlag() {
        return this._toDelete;
    }

    @Override
    public int compareTo(DateInfo dateInfo) {
        if (this._date == null || this._dateString == null) {
            return -1;
        }
        if (dateInfo._date == null || dateInfo._dateString == null) {
            return 1;
        }
        return this._date.compareTo(dateInfo._date);
    }
}

