/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Copy;
import ch.poole.openinghoursparser.Rule;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Util {
    private Util() {
    }

    public static List<List<Rule>> getMergeableRules(List<Rule> rules) {
        ArrayList<List<Rule>> result = new ArrayList<List<Rule>>();
        ArrayList<Rule> copy = new ArrayList<Rule>(rules);
        while (!copy.isEmpty()) {
            Rule r = (Rule)copy.get(0);
            boolean found = false;
            for (List list : result) {
                if (list.isEmpty() || !r.isMergeableWith((Rule)list.get(0))) continue;
                list.add(r);
                found = true;
                break;
            }
            if (!found) {
                ArrayList<Rule> m = new ArrayList<Rule>();
                m.add(r);
                result.add(m);
            }
            copy.remove(0);
        }
        return result;
    }

    public static String rulesToOpeningHoursString(@NotNull List<Rule> rules) {
        return Util.rulesToOpeningHoursString(rules, false);
    }

    private static String rulesToOpeningHoursString(@NotNull List<Rule> rules, boolean debug) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Rule r : rules) {
            if (r.isEmpty()) continue;
            if (!first) {
                if (r.isAdditive()) {
                    result.append(", ");
                } else if (r.isFallBack()) {
                    result.append(" || ");
                } else {
                    result.append("; ");
                }
            } else {
                first = false;
            }
            result.append(debug ? r.toDebugString() : r.toString());
        }
        return result.toString();
    }

    public static String rulesToOpeningHoursDebugString(@NotNull List<Rule> rules) {
        return Util.rulesToOpeningHoursString(rules, true);
    }

    public static String capitalize(String s) {
        char[] c = s.toLowerCase(Locale.US).toCharArray();
        if (c.length > 0) {
            c[0] = Character.toUpperCase(c[0]);
            return new String(c);
        }
        return s;
    }

    @Nullable
    public static String deWeekDays2En(String s) {
        switch (s.toLowerCase(Locale.US)) {
            case "mo": {
                return "Mo";
            }
            case "di": {
                return "Tu";
            }
            case "mi": {
                return "We";
            }
            case "do": {
                return "Th";
            }
            case "fr": {
                return "Fr";
            }
            case "sa": {
                return "Sa";
            }
            case "so": {
                return "Su";
            }
        }
        return null;
    }

    static <T extends Copy<?>> List<T> copyList(List<T> l) {
        if (l == null) {
            return null;
        }
        ArrayList<Copy> r = new ArrayList<Copy>(l.size());
        for (Copy o : l) {
            r.add((Copy)o.copy());
        }
        return r;
    }

    static boolean equalsOrMore(@NotNull String token, int lower) {
        try {
            int temp = Integer.parseInt(token);
            return temp >= lower;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    static boolean between(@NotNull String token, int lower, int upper) {
        try {
            int temp = Integer.parseInt(token);
            return temp >= lower && temp <= upper;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

