/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SetRoleAction
extends AbstractRelationEditorAction
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private final transient AutoCompletingTextField tfRole;

    public SetRoleAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, new IRelationEditorUpdateOn[0]);
        this.tfRole = editorAccess.getTextFieldRole();
        this.putValue("ShortDescription", I18n.tr("Sets a role for the selected members", new Object[0]));
        new ImageProvider("apply").getResource().attachImageIcon(this);
        this.putValue("Name", I18n.tr("Apply Role", new Object[0]));
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.editorAccess.getMemberTable().getSelectedRowCount() > 0);
    }

    protected boolean isEmptyRole() {
        return this.tfRole.getText() == null || this.tfRole.getText().trim().isEmpty();
    }

    protected boolean confirmSettingEmptyRole(int onNumMembers) {
        String message = "<html>" + I18n.trn("You are setting an empty role on {0} object.", "You are setting an empty role on {0} objects.", onNumMembers, onNumMembers) + "<br>" + I18n.tr("This is equal to deleting the roles of these objects.", new Object[0]) + "<br>" + I18n.tr("Do you really want to apply the new role?", new Object[0]) + "</html>";
        Object[] options = new String[]{I18n.tr("Yes, apply it", new Object[0]), I18n.tr("No, do not apply", new Object[0])};
        int ret = ConditionalOptionPaneUtil.showOptionDialog("relation_editor.confirm_applying_empty_role", MainApplication.getMainFrame(), message, I18n.tr("Confirm empty role", new Object[0]), 0, 2, options, options[0]);
        switch (ret) {
            case -2147483648: 
            case 0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEmptyRole() && !this.confirmSettingEmptyRole(this.editorAccess.getMemberTable().getSelectedRowCount())) {
            return;
        }
        this.editorAccess.getMemberTableModel().updateRole(this.editorAccess.getMemberTable().getSelectedRows(), this.tfRole.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateEnabledState();
    }
}

