/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.advanced.ListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.ListListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.MapListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.preferences.advanced.StringEditor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.ListListSetting;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PreferencesTable
extends JTable {
    private final AllSettingsTableModel model;
    private final transient List<PrefEntry> displayData;

    public PreferencesTable(List<PrefEntry> displayData) {
        this.displayData = displayData;
        this.model = new AllSettingsTableModel();
        this.setModel(this.model);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getColumnModel().getColumn(1).setCellRenderer(new SettingCellRenderer());
        this.getColumnModel().getColumn(1).setCellEditor(new SettingCellEditor());
        TableHelper.setFont(this, this.getClass());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PreferencesTable.this.editPreference(PreferencesTable.this);
                }
            }
        });
    }

    public void fireDataChanged() {
        this.model.fireTableDataChanged();
    }

    public List<PrefEntry> getSelectedItems() {
        return Arrays.stream(this.getSelectedRows()).mapToObj(row -> (PrefEntry)this.model.getValueAt(row, -1)).collect(Collectors.toList());
    }

    public boolean editPreference(JComponent gui) {
        if (this.getSelectedRowCount() != 1) {
            return false;
        }
        PrefEntry e = (PrefEntry)this.model.getValueAt(this.getSelectedRow(), 1);
        Setting<?> stg = e.getValue();
        boolean ok = false;
        if (stg instanceof StringSetting) {
            this.editCellAt(this.getSelectedRow(), 1);
            Component editor = this.getEditorComponent();
            if (editor != null) {
                editor.requestFocus();
            }
        } else if (stg instanceof ListSetting) {
            ok = PreferencesTable.doAddEditList(gui, e, (ListSetting)stg);
        } else if (stg instanceof ListListSetting) {
            ok = PreferencesTable.doAddEditListList(gui, e, (ListListSetting)stg);
        } else if (stg instanceof MapListSetting) {
            ok = PreferencesTable.doAddEditMapList(gui, e, (MapListSetting)stg);
        }
        return ok;
    }

    public PrefEntry addPreference(JComponent gui) {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std().insets(0, 0, 5, 0));
        JosmTextField tkey = new JosmTextField("", 50);
        p.add((Component)tkey, GBC.eop().insets(5, 0, 0, 0).fill(2));
        p.add((Component)new JLabel(I18n.tr("Select Setting Type:", new Object[0])), GBC.eol().insets(5, 15, 5, 0));
        JRadioButton rbString = new JRadioButton(I18n.tr("Simple", new Object[0]));
        JRadioButton rbList = new JRadioButton(I18n.tr("List", new Object[0]));
        JRadioButton rbListList = new JRadioButton(I18n.tr("List of lists", new Object[0]));
        JRadioButton rbMapList = new JRadioButton(I18n.tr("List of maps", new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(rbString);
        group.add(rbList);
        group.add(rbListList);
        group.add(rbMapList);
        p.add((Component)rbString, GBC.eol());
        p.add((Component)rbList, GBC.eol());
        p.add((Component)rbListList, GBC.eol());
        p.add((Component)rbMapList, GBC.eol());
        rbString.setSelected(true);
        PrefEntry pe = null;
        boolean ok = false;
        if (PreferencesTable.askAddSetting(gui, p)) {
            if (rbString.isSelected()) {
                StringSetting sSetting = new StringSetting(null);
                pe = new PrefEntry(tkey.getText(), sSetting, sSetting, false);
                ok = PreferencesTable.doAddSimple(gui, pe, sSetting);
            } else if (rbList.isSelected()) {
                ListSetting lSetting = new ListSetting(null);
                pe = new PrefEntry(tkey.getText(), lSetting, lSetting, false);
                ok = PreferencesTable.doAddEditList(gui, pe, lSetting);
            } else if (rbListList.isSelected()) {
                ListListSetting llSetting = new ListListSetting(null);
                pe = new PrefEntry(tkey.getText(), llSetting, llSetting, false);
                ok = PreferencesTable.doAddEditListList(gui, pe, llSetting);
            } else if (rbMapList.isSelected()) {
                MapListSetting mlSetting = new MapListSetting(null);
                pe = new PrefEntry(tkey.getText(), mlSetting, mlSetting, false);
                ok = PreferencesTable.doAddEditMapList(gui, pe, mlSetting);
            }
        }
        return ok ? pe : null;
    }

    private static boolean askAddSetting(JComponent gui, JPanel p) {
        return new ExtendedDialog((Component)gui, I18n.tr("Add setting", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(p).setButtonIcons("ok", "cancel").showDialog().getValue() == 1;
    }

    private static boolean doAddSimple(JComponent gui, PrefEntry pe, StringSetting sSetting) {
        StringEditor sEditor = new StringEditor(gui, pe, sSetting);
        sEditor.showDialog();
        if (sEditor.getValue() == 1) {
            String data = sEditor.getData();
            if (!Objects.equals(sSetting.getValue(), data)) {
                pe.setValue(new StringSetting(data));
                return true;
            }
        }
        return false;
    }

    private static boolean doAddEditList(JComponent gui, PrefEntry pe, ListSetting lSetting) {
        List<String> data;
        ListEditor lEditor = new ListEditor(gui, pe, lSetting);
        lEditor.showDialog();
        if (lEditor.getValue() == 1 && !lSetting.equalVal(data = lEditor.getData())) {
            pe.setValue(new ListSetting(data));
            return true;
        }
        return false;
    }

    private static boolean doAddEditListList(JComponent gui, PrefEntry pe, ListListSetting llSetting) {
        List<List<String>> data;
        ListListEditor llEditor = new ListListEditor(gui, pe, llSetting);
        llEditor.showDialog();
        if (llEditor.getValue() == 1 && !llSetting.equalVal(data = llEditor.getData())) {
            pe.setValue(new ListListSetting(data));
            return true;
        }
        return false;
    }

    private static boolean doAddEditMapList(JComponent gui, PrefEntry pe, MapListSetting mlSetting) {
        List<Map<String, String>> data;
        MapListEditor mlEditor = new MapListEditor(gui, pe, mlSetting);
        mlEditor.showDialog();
        if (mlEditor.getValue() == 1 && !mlSetting.equalVal(data = mlEditor.getData())) {
            pe.setValue(new MapListSetting(data));
            return true;
        }
        return false;
    }

    public void resetPreferences(JComponent gui) {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        for (int row : this.getSelectedRows()) {
            PrefEntry e = this.displayData.get(row);
            e.reset();
        }
        this.fireDataChanged();
    }

    static final class SettingCellEditor
    extends DefaultCellEditor {
        SettingCellEditor() {
            super(new JosmTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PrefEntry pe = (PrefEntry)value;
            StringSetting stg = (StringSetting)pe.getValue();
            String s = stg.getValue() == null ? "" : (String)stg.getValue();
            return super.getTableCellEditorComponent(table, s, isSelected, row, column);
        }
    }

    static final class SettingCellRenderer
    extends DefaultTableCellRenderer {
        private final Color backgroundColor = UIManager.getColor("Table.background");
        private final Color changedColor = new NamedColorProperty(I18n.marktr("Advanced Background: Changed"), new Color(200, 255, 200)).get();
        private final Color nonDefaultColor = new NamedColorProperty(I18n.marktr("Advanced Background: NonDefault"), new Color(255, 255, 200)).get();

        SettingCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            PrefEntry pe = (PrefEntry)value;
            Setting<?> setting = pe.getValue();
            Object val = setting.getValue();
            String display = val != null ? val.toString() : "<html><i>&lt;" + I18n.tr("unset", new Object[0]) + "&gt;</i></html>";
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, display, isSelected, hasFocus, row, column);
            GuiHelper.setBackgroundReadable(label, this.backgroundColor);
            if (pe.isChanged()) {
                GuiHelper.setBackgroundReadable(label, this.changedColor);
            } else if (!pe.isDefault()) {
                GuiHelper.setBackgroundReadable(label, this.nonDefaultColor);
            }
            if (!pe.isDefault()) {
                label.setFont(label.getFont().deriveFont(1));
            }
            if ((val = pe.getDefaultValue().getValue()) != null) {
                if (pe.isDefault()) {
                    label.setToolTipText(I18n.tr("Current value is default.", new Object[0]));
                } else {
                    label.setToolTipText(I18n.tr("Default value is ''{0}''.", val));
                }
            } else {
                label.setToolTipText(I18n.tr("Default value currently unknown (setting has not been used yet).", new Object[0]));
            }
            return label;
        }
    }

    final class AllSettingsTableModel
    extends DefaultTableModel {
        AllSettingsTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1 && ((PrefEntry)PreferencesTable.this.displayData.get(row)).getValue() instanceof StringSetting;
        }

        @Override
        public int getRowCount() {
            return PreferencesTable.this.displayData.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((PrefEntry)PreferencesTable.this.displayData.get(row)).getKey();
            }
            return PreferencesTable.this.displayData.get(row);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            String s = (String)o;
            PrefEntry pe = (PrefEntry)PreferencesTable.this.displayData.get(row);
            if (!s.equals(pe.getValue().getValue())) {
                pe.setValue(new StringSetting(s));
                this.fireTableCellUpdated(row, column);
            }
        }
    }
}

