/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.actions.ZoomToAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JosmTable;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTableModel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;

public abstract class OsmPrimitivesTable
extends JosmTable {
    private transient OsmDataLayer layer;
    private JPopupMenu popupMenu;
    private ZoomToAction zoomToAction;

    protected OsmPrimitivesTable(OsmPrimitivesTableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.addMouseListener(new PopupMenuLauncher(this.getPopUpMenu()));
        this.addMouseListener(new DblClickHandler());
    }

    public OsmPrimitivesTableModel getOsmPrimitivesTableModel() {
        return (OsmPrimitivesTableModel)this.getModel();
    }

    public final OsmDataLayer getLayer() {
        return this.layer;
    }

    public final void setLayer(OsmDataLayer layer) {
        this.layer = layer;
    }

    protected final JPopupMenu getPopUpMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.buildPopupMenu();
        }
        return this.popupMenu;
    }

    protected abstract ZoomToAction buildZoomToAction();

    protected JPopupMenu buildPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.zoomToAction = this.buildZoomToAction();
        this.getSelectionModel().addListSelectionListener(this.zoomToAction);
        menu.add(this.zoomToAction);
        return menu;
    }

    public void registerListeners() {
        MainApplication.getLayerManager().addLayerChangeListener(this.zoomToAction);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.zoomToAction);
    }

    public void unregisterListeners() {
        MainApplication.getLayerManager().removeLayerChangeListener(this.zoomToAction);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this.zoomToAction);
    }

    public OsmPrimitive getPrimitiveInLayer(int row, OsmDataLayer layer) {
        return this.getOsmPrimitivesTableModel().getReferredPrimitive(row);
    }

    protected class DblClickHandler
    extends MouseAdapter {
        protected DblClickHandler() {
        }

        protected void setSelection(MouseEvent e) {
            int row = OsmPrimitivesTable.this.rowAtPoint(e.getPoint());
            if (row < 0) {
                return;
            }
            OsmPrimitive primitive = OsmPrimitivesTable.this.getPrimitiveInLayer(row, OsmPrimitivesTable.this.layer);
            if (OsmPrimitivesTable.this.layer != null && primitive != null) {
                ((OsmPrimitivesTable)OsmPrimitivesTable.this).layer.data.setSelected(primitive.getPrimitiveId());
            }
        }

        protected void addSelection(MouseEvent e) {
            int row = OsmPrimitivesTable.this.rowAtPoint(e.getPoint());
            if (row < 0) {
                return;
            }
            OsmPrimitive primitive = OsmPrimitivesTable.this.getPrimitiveInLayer(row, OsmPrimitivesTable.this.layer);
            OsmPrimitivesTable.this.getSelectionModel().addSelectionInterval(row, row);
            if (OsmPrimitivesTable.this.layer != null && primitive != null) {
                ((OsmPrimitivesTable)OsmPrimitivesTable.this).layer.data.addSelected(primitive.getPrimitiveId());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                if (e.isControlDown()) {
                    this.addSelection(e);
                } else {
                    this.setSelection(e);
                }
            }
        }
    }
}

