/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.RawIOBase;

public abstract class BufferedIOMixin
extends BufferedIOBase {
    protected RawIOBase rawIO;
    protected int bufferSize;

    public BufferedIOMixin(RawIOBase rawIO) {
        this(rawIO, 8192);
    }

    public BufferedIOMixin(RawIOBase rawIO, int bufferSize) {
        this.rawIO = rawIO;
        this.bufferSize = bufferSize;
    }

    @Override
    public long seek(long pos, int whence) {
        return this.rawIO.seek(pos, whence);
    }

    @Override
    public long tell() {
        return this.rawIO.tell();
    }

    @Override
    public long truncate(long size) {
        return this.rawIO.truncate(size);
    }

    @Override
    public void flush() {
        this.rawIO.flush();
    }

    @Override
    public void close() {
        block3: {
            if (this.closed()) {
                return;
            }
            try {
                this.flush();
            }
            catch (PyException pye) {
                if (pye.match(Py.IOError)) break block3;
                throw pye;
            }
        }
        this.rawIO.close();
    }

    @Override
    public RawIOBase fileno() {
        return this.rawIO.fileno();
    }

    @Override
    public boolean isatty() {
        return this.rawIO.isatty();
    }

    @Override
    public boolean readable() {
        return this.rawIO.readable();
    }

    @Override
    public boolean writable() {
        return this.rawIO.writable();
    }

    @Override
    public boolean closed() {
        return this.rawIO.closed();
    }

    @Override
    public InputStream asInputStream() {
        return this.rawIO.asInputStream();
    }

    @Override
    public OutputStream asOutputStream() {
        return this.rawIO.asOutputStream();
    }
}

