/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.beans.property.ObjectProperty;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.StackPane;
import javafx.scene.text.HitInfo;

public abstract class CustomTextFieldSkin
extends TextFieldSkin {
    private static final PseudoClass HAS_NO_SIDE_NODE = PseudoClass.getPseudoClass("no-side-nodes");
    private static final PseudoClass HAS_LEFT_NODE = PseudoClass.getPseudoClass("left-node-visible");
    private static final PseudoClass HAS_RIGHT_NODE = PseudoClass.getPseudoClass("right-node-visible");
    private Node left;
    private StackPane leftPane;
    private Node right;
    private StackPane rightPane;
    private final TextField control;

    public CustomTextFieldSkin(TextField control) {
        super(control);
        this.control = control;
        this.updateChildren();
        this.registerChangeListener(this.leftProperty(), e -> this.updateChildren());
        this.registerChangeListener(this.rightProperty(), e -> this.updateChildren());
    }

    public abstract ObjectProperty<Node> leftProperty();

    public abstract ObjectProperty<Node> rightProperty();

    private void updateChildren() {
        Node newRight;
        Node newLeft = (Node)this.leftProperty().get();
        if (newLeft != null) {
            this.getChildren().remove(this.leftPane);
            this.leftPane = new StackPane(newLeft);
            this.leftPane.setManaged(false);
            this.leftPane.setAlignment(Pos.CENTER_LEFT);
            this.leftPane.getStyleClass().add("left-pane");
            this.getChildren().add(this.leftPane);
            this.left = newLeft;
        }
        if ((newRight = (Node)this.rightProperty().get()) != null) {
            this.getChildren().remove(this.rightPane);
            this.rightPane = new StackPane(newRight);
            this.rightPane.setManaged(false);
            this.rightPane.setAlignment(Pos.CENTER_RIGHT);
            this.rightPane.getStyleClass().add("right-pane");
            this.getChildren().add(this.rightPane);
            this.right = newRight;
        }
        this.control.pseudoClassStateChanged(HAS_LEFT_NODE, this.left != null);
        this.control.pseudoClassStateChanged(HAS_RIGHT_NODE, this.right != null);
        this.control.pseudoClassStateChanged(HAS_NO_SIDE_NODE, this.left == null && this.right == null);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h2) {
        double fullHeight = h2 + this.snappedTopInset() + this.snappedBottomInset();
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(fullHeight));
        double rightWidth = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefWidth(fullHeight));
        double textFieldStartX = this.snapPosition(x) + this.snapSize(leftWidth);
        double textFieldWidth = w - this.snapSize(leftWidth) - this.snapSize(rightWidth);
        super.layoutChildren(textFieldStartX, 0.0, textFieldWidth, fullHeight);
        if (this.leftPane != null) {
            double leftStartX = 0.0;
            this.leftPane.resizeRelocate(0.0, 0.0, leftWidth, fullHeight);
        }
        if (this.rightPane != null) {
            double rightStartX = this.rightPane == null ? 0.0 : w - rightWidth + this.snappedLeftInset();
            this.rightPane.resizeRelocate(rightStartX, 0.0, rightWidth, fullHeight);
        }
    }

    @Override
    public HitInfo getIndex(double x, double y) {
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(((TextField)this.getSkinnable()).getHeight()));
        return super.getIndex(x - leftWidth, y);
    }

    @Override
    protected double computePrefWidth(double h2, double topInset, double rightInset, double bottomInset, double leftInset) {
        double pw = super.computePrefWidth(h2, topInset, rightInset, bottomInset, leftInset);
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(h2));
        double rightWidth = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefWidth(h2));
        return pw + leftWidth + rightWidth;
    }

    @Override
    protected double computePrefHeight(double w, double topInset, double rightInset, double bottomInset, double leftInset) {
        double ph = super.computePrefHeight(w, topInset, rightInset, bottomInset, leftInset);
        double leftHeight = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefHeight(-1.0));
        double rightHeight = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefHeight(-1.0));
        return Math.max(ph, Math.max(leftHeight, rightHeight));
    }

    @Override
    protected double computeMinWidth(double h2, double topInset, double rightInset, double bottomInset, double leftInset) {
        double mw = super.computeMinWidth(h2, topInset, rightInset, bottomInset, leftInset);
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.minWidth(h2));
        double rightWidth = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.minWidth(h2));
        return mw + leftWidth + rightWidth;
    }

    @Override
    protected double computeMinHeight(double w, double topInset, double rightInset, double bottomInset, double leftInset) {
        double mh = super.computeMinHeight(w, topInset, rightInset, bottomInset, leftInset);
        double leftHeight = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.minHeight(-1.0));
        double rightHeight = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.minHeight(-1.0));
        return Math.max(mh, Math.max(leftHeight, rightHeight));
    }
}

