/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import mediathek.config.Daten;
import mediathek.daten.DatenDownload;
import mediathek.tool.ByteUnitUtil;
import org.jetbrains.annotations.NotNull;

public class MVBandwidthCountingInputStream
extends InputStream {
    private final InputStream iStream;
    private final BandwidthCalculationTask calculationTask = new BandwidthCalculationTask();
    private final ScheduledFuture<?> calculationTaskFuture;

    public MVBandwidthCountingInputStream(InputStream in) {
        this.iStream = in;
        this.calculationTaskFuture = Daten.getInstance().getTimerPool().scheduleAtFixedRate(this.calculationTask, 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws IOException {
        this.iStream.close();
        super.close();
        if (this.calculationTaskFuture != null) {
            this.calculationTaskFuture.cancel(true);
        }
    }

    @Override
    public int read() throws IOException {
        int bytesRead = this.iStream.read();
        if (bytesRead != -1) {
            this.calculationTask.incrementBytesRead(1);
        }
        return bytesRead;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        int bytesRead = this.iStream.read(b);
        if (bytesRead != -1) {
            this.calculationTask.incrementBytesRead(bytesRead);
        }
        return bytesRead;
    }

    public long getBandwidth() {
        return this.calculationTask.getBandwidth();
    }

    public long getSumByte() {
        return this.calculationTask.getTotalBytesRead();
    }

    public long getSumBandwidth() {
        long bytesRead = this.calculationTask.getTotalBytesRead();
        long time = this.calculationTask.getSumTime();
        return bytesRead <= 0L ? 0L : bytesRead / time;
    }

    public String toString() {
        long bytesRead = this.calculationTask.getTotalBytesRead();
        long b = this.getSumBandwidth();
        String s2 = ByteUnitUtil.byteCountToDisplaySize(bytesRead);
        return "Download: Bytes gelesen: " + s2 + "  Bandbreite: " + DatenDownload.getTextBandbreite(b);
    }

    private static class BandwidthCalculationTask
    implements Runnable {
        private final AtomicLong _oldTotalBytes = new AtomicLong(0L);
        private final AtomicLong _totalBytesRead = new AtomicLong(0L);
        private final AtomicLong _bandwidth = new AtomicLong(0L);
        private final AtomicLong _sumTime = new AtomicLong(0L);

        private BandwidthCalculationTask() {
        }

        @Override
        public void run() {
            this._sumTime.incrementAndGet();
            long totalBytesRead = this._totalBytesRead.get();
            this._bandwidth.set(totalBytesRead - this._oldTotalBytes.getAndSet(totalBytesRead));
        }

        public void incrementBytesRead(int value) {
            this._totalBytesRead.addAndGet(value);
        }

        public long getTotalBytesRead() {
            return this._totalBytesRead.get();
        }

        public long getBandwidth() {
            return this._bandwidth.get();
        }

        public long getSumTime() {
            return this._sumTime.get();
        }
    }
}

