/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.DirectoryChooser;
import javafx.stage.Modality;
import javax.swing.AbstractAction;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.tool.Logfile;
import mediathek.tool.MVFunctionSys;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class CreateProtocolFileAction
extends AbstractAction {
    private static final String HEADER = "Protokolldatei erstellen";
    private String destDirFile;

    public CreateProtocolFileAction() {
        this.putValue("Name", "Protokolldatei erstellen...");
    }

    private void addFileToArchive(File f, ArchiveOutputStream o, String entryName) throws IOException {
        ArchiveEntry entry = o.createArchiveEntry(f, entryName);
        o.putArchiveEntry(entry);
        if (f.isFile()) {
            try (InputStream i = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                IOUtils.copy(i, o);
            }
        }
        o.closeArchiveEntry();
    }

    private void createArchive(File destDirectory) throws Exception {
        this.destDirFile = destDirectory.toString() + File.separator + "mv_protokoll.tar.gz";
        String settingsDir = Daten.getSettingsDirectory_String();
        try (OutputStream fo = Files.newOutputStream(Paths.get(this.destDirFile, new String[0]), new OpenOption[0]);
             GzipCompressorOutputStream gzo = new GzipCompressorOutputStream(fo);
             TarArchiveOutputStream o = new TarArchiveOutputStream(gzo);){
            File f = new File(settingsDir + File.separator + "mediathekview.log");
            this.addFileToArchive(f, o, "mediathekview.log");
            f = File.createTempFile("mediathekview_", "_suffix");
            boolean res = Logfile.LogDateiSchreiben(f.toString(), MVFunctionSys.getProgVersionString(), Daten.getSettingsDirectory_String(), Daten.listePset.getListProg(), MVConfig.getAll());
            if (!res) {
                throw new Exception("failed to create old log file");
            }
            this.addFileToArchive(f, o, "logfile_old.log");
            ((ArchiveOutputStream)o).finish();
            Files.deleteIfExists(f.toPath());
        }
    }

    private void success(String logFile) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("MediathekView");
        alert.setHeaderText(HEADER);
        alert.setContentText("Protokolldatei " + logFile + " wurde erfolgreich angelegt.");
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.showAndWait();
    }

    private void error() {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("MediathekView");
        alert.setHeaderText(HEADER);
        alert.setContentText("Protokolldatei konnte nicht geschrieben werden!");
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.showAndWait();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Platform.runLater(() -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle("Protokoll sichern");
            File dir = directoryChooser.showDialog(null);
            if (dir != null) {
                System.out.println("DIRECTORY: " + dir.toString());
                try {
                    this.createArchive(dir);
                    this.success(this.destDirFile);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    this.error();
                }
            }
        });
    }
}

