/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.data.LocationPoint;
import net.osmand.data.PointDescription;
import net.osmand.plus.Version;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class GPXUtilities {
    public static final Log log = PlatformUtil.getLog(GPXUtilities.class);
    private static final String GPX_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final NumberFormat latLonFormat = new DecimalFormat("0.00#####", new DecimalFormatSymbols(new Locale("EN", "US")));

    private static SplitMetric getDistanceMetric() {
        return new SplitMetric(){
            private float[] calculations = new float[1];

            @Override
            public double metric(WptPt p1, WptPt p2) {
                Location.distanceBetween(p1.lat, p1.lon, p2.lat, p2.lon, this.calculations);
                return this.calculations[0];
            }
        };
    }

    private static SplitMetric getTimeSplit() {
        return new SplitMetric(){

            @Override
            public double metric(WptPt p1, WptPt p2) {
                if (p1.time != 0L && p2.time != 0L) {
                    return (int)Math.abs((p2.time - p1.time) / 1000L);
                }
                return 0.0;
            }
        };
    }

    private static void splitSegment(SplitMetric metric, SplitMetric secondaryMetric, double metricLimit, List<SplitSegment> splitSegments, TrkSegment segment) {
        double currentMetricEnd = metricLimit;
        double secondaryMetricEnd = 0.0;
        SplitSegment sp = new SplitSegment(segment, 0, 0.0);
        double total = 0.0;
        WptPt prev = null;
        for (int k = 0; k < segment.points.size(); ++k) {
            WptPt point = segment.points.get(k);
            if (k > 0) {
                double currentSegment = metric.metric(prev, point);
                secondaryMetricEnd += secondaryMetric.metric(prev, point);
                while (total + currentSegment > currentMetricEnd) {
                    double p = currentMetricEnd - total;
                    double cf = p / currentSegment;
                    sp.setLastPoint(k - 1, cf);
                    sp.metricEnd = currentMetricEnd;
                    sp.secondaryMetricEnd = secondaryMetricEnd;
                    splitSegments.add(sp);
                    sp = new SplitSegment(segment, k - 1, cf);
                    currentMetricEnd += metricLimit;
                    prev = sp.get(0);
                }
                total += currentSegment;
            }
            prev = point;
        }
        if (segment.points.size() > 0 && (sp.endPointInd != segment.points.size() - 1 || sp.startCoeff != 1.0)) {
            sp.metricEnd = total;
            sp.secondaryMetricEnd = secondaryMetricEnd;
            sp.setLastPoint(segment.points.size() - 2, 1.0);
            splitSegments.add(sp);
        }
    }

    private static List<GPXTrackAnalysis> convert(List<SplitSegment> splitSegments) {
        ArrayList<GPXTrackAnalysis> ls = new ArrayList<GPXTrackAnalysis>();
        for (SplitSegment s : splitSegments) {
            GPXTrackAnalysis a = new GPXTrackAnalysis();
            a.prepareInformation(0L, s);
            ls.add(a);
        }
        return ls;
    }

    public static String asString(GPXFile file, OsmWindow ctx) {
        StringWriter writer = new StringWriter();
        GPXUtilities.writeGpx(writer, file, ctx);
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeGpxFile(File fout, GPXFile file, OsmWindow ctx) {
        Writer output = null;
        try {
            output = new OutputStreamWriter((OutputStream)new FileOutputStream(fout), "UTF-8");
            String string2 = GPXUtilities.writeGpx(output, file, ctx);
            return string2;
        }
        catch (IOException e) {
            log.error((Object)"Error saving gpx", (Throwable)e);
            String string3 = ctx.getString(785);
            return string3;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String writeGpx(Writer output, GPXFile file, OsmWindow ctx) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(GPX_TIME_FORMAT, Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            XmlSerializer serializer = PlatformUtil.newSerializer();
            serializer.setOutput(output);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(null, "gpx");
            serializer.attribute(null, "version", "1.1");
            if (file.author == null) {
                serializer.attribute(null, "creator", Version.getAppName(ctx));
            } else {
                serializer.attribute(null, "creator", file.author);
            }
            serializer.attribute(null, "xmlns", "http://www.topografix.com/GPX/1/1");
            serializer.attribute(null, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.attribute(null, "xsi:schemaLocation", "http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd");
            for (Track track : file.tracks) {
                serializer.startTag(null, "trk");
                GPXUtilities.writeNotNullText(serializer, "name", track.name);
                GPXUtilities.writeNotNullText(serializer, "desc", track.desc);
                for (TrkSegment segment : track.segments) {
                    serializer.startTag(null, "trkseg");
                    for (WptPt p : segment.points) {
                        serializer.startTag(null, "trkpt");
                        GPXUtilities.writeWpt(format, serializer, p);
                        serializer.endTag(null, "trkpt");
                    }
                    serializer.endTag(null, "trkseg");
                }
                GPXUtilities.writeExtensions(serializer, track);
                serializer.endTag(null, "trk");
            }
            for (Route route : file.routes) {
                serializer.startTag(null, "rte");
                GPXUtilities.writeNotNullText(serializer, "name", route.name);
                GPXUtilities.writeNotNullText(serializer, "desc", route.desc);
                for (WptPt p : route.points) {
                    serializer.startTag(null, "rtept");
                    GPXUtilities.writeWpt(format, serializer, p);
                    serializer.endTag(null, "rtept");
                }
                GPXUtilities.writeExtensions(serializer, route);
                serializer.endTag(null, "rte");
            }
            for (WptPt wptPt : file.points) {
                serializer.startTag(null, "wpt");
                GPXUtilities.writeWpt(format, serializer, wptPt);
                serializer.endTag(null, "wpt");
            }
            serializer.endTag(null, "gpx");
            serializer.flush();
            serializer.endDocument();
        }
        catch (RuntimeException e) {
            log.error((Object)"Error saving gpx", (Throwable)e);
            return ctx.getString(785);
        }
        catch (IOException e) {
            log.error((Object)"Error saving gpx", (Throwable)e);
            return ctx.getString(785);
        }
        return null;
    }

    private static void writeNotNullText(XmlSerializer serializer, String tag, String value) throws IOException {
        if (value != null) {
            serializer.startTag(null, tag);
            serializer.text(value);
            serializer.endTag(null, tag);
        }
    }

    private static void writeExtensions(XmlSerializer serializer, GPXExtensions p) throws IOException {
        if (!p.getExtensionsToRead().isEmpty()) {
            serializer.startTag(null, "extensions");
            for (Map.Entry<String, String> s : p.getExtensionsToRead().entrySet()) {
                GPXUtilities.writeNotNullText(serializer, s.getKey(), s.getValue());
            }
            serializer.endTag(null, "extensions");
        }
    }

    private static void writeWpt(SimpleDateFormat format, XmlSerializer serializer, WptPt p) throws IOException {
        serializer.attribute(null, "lat", latLonFormat.format(p.lat));
        serializer.attribute(null, "lon", latLonFormat.format(p.lon));
        if (!Double.isNaN(p.ele)) {
            GPXUtilities.writeNotNullText(serializer, "ele", p.ele + "");
        }
        if (p.time != 0L) {
            GPXUtilities.writeNotNullText(serializer, "time", format.format(new Date(p.time)));
        }
        GPXUtilities.writeNotNullText(serializer, "name", p.name);
        GPXUtilities.writeNotNullText(serializer, "desc", p.desc);
        if (p.link != null) {
            serializer.startTag(null, "link");
            serializer.attribute(null, "href", p.link);
            serializer.endTag(null, "link");
        }
        GPXUtilities.writeNotNullText(serializer, "type", p.category);
        if (!Double.isNaN(p.hdop)) {
            GPXUtilities.writeNotNullText(serializer, "hdop", p.hdop + "");
        }
        if (p.speed > 0.0) {
            p.getExtensionsToWrite().put("speed", p.speed + "");
        }
        GPXUtilities.writeExtensions(serializer, p);
    }

    private static String readText(XmlPullParser parser, String key) throws XmlPullParserException, IOException {
        int tok;
        String text = null;
        while (!((tok = parser.next()) == 1 || tok == 3 && parser.getName().equals(key))) {
            if (tok != 4) continue;
            if (text == null) {
                text = parser.getText();
                continue;
            }
            text = text + parser.getText();
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GPXFile loadGPXFile(OsmWindow ctx, File f) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            GPXFile file = GPXUtilities.loadGPXFile(ctx, fis);
            file.path = f.getAbsolutePath();
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            GPXFile gPXFile = file;
            return gPXFile;
        }
        catch (FileNotFoundException e) {
            GPXFile res = new GPXFile();
            res.path = f.getAbsolutePath();
            log.error((Object)"Error reading gpx", (Throwable)e);
            res.warning = ctx.getString(620);
            GPXFile gPXFile = res;
            return gPXFile;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static GPXFile loadGPXFile(OsmWindow ctx, InputStream f) {
        GPXFile res = new GPXFile();
        SimpleDateFormat format = new SimpleDateFormat(GPX_TIME_FORMAT, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            int tok;
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(GPXUtilities.getUTF8Reader(f));
            Stack<GPXExtensions> parserState = new Stack<GPXExtensions>();
            boolean extensionReadMode = false;
            parserState.push(res);
            while ((tok = parser.next()) != 1) {
                Object pop;
                String tag;
                Object parse;
                if (tok == 2) {
                    String text;
                    WptPt wptPt;
                    parse = parserState.peek();
                    tag = parser.getName();
                    if (extensionReadMode && parse instanceof GPXExtensions) {
                        String value = GPXUtilities.readText(parser, tag);
                        if (value == null) continue;
                        ((GPXExtensions)parse).getExtensionsToWrite().put(tag, value);
                        if (!tag.equals("speed") || !(parse instanceof WptPt)) continue;
                        try {
                            ((WptPt)parse).speed = Float.parseFloat(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (parse instanceof GPXExtensions && tag.equals("extensions")) {
                        extensionReadMode = true;
                        continue;
                    }
                    if (parse instanceof GPXFile) {
                        if (parser.getName().equals("gpx")) {
                            ((GPXFile)parse).author = parser.getAttributeValue("", "creator");
                        }
                        if (parser.getName().equals("trk")) {
                            Track track = new Track();
                            ((GPXFile)parse).tracks.add(track);
                            parserState.push(track);
                        }
                        if (parser.getName().equals("rte")) {
                            Route route = new Route();
                            ((GPXFile)parse).routes.add(route);
                            parserState.push(route);
                        }
                        if (!parser.getName().equals("wpt")) continue;
                        wptPt = GPXUtilities.parseWptAttributes(parser);
                        ((GPXFile)parse).points.add(wptPt);
                        parserState.push(wptPt);
                        continue;
                    }
                    if (parse instanceof Route) {
                        if (parser.getName().equals("name")) {
                            ((Route)parse).name = GPXUtilities.readText(parser, "name");
                        }
                        if (parser.getName().equals("desc")) {
                            ((Route)parse).desc = GPXUtilities.readText(parser, "desc");
                        }
                        if (!parser.getName().equals("rtept")) continue;
                        wptPt = GPXUtilities.parseWptAttributes(parser);
                        ((Route)parse).points.add(wptPt);
                        parserState.push(wptPt);
                        continue;
                    }
                    if (parse instanceof Track) {
                        if (parser.getName().equals("name")) {
                            ((Track)parse).name = GPXUtilities.readText(parser, "name");
                        }
                        if (parser.getName().equals("desc")) {
                            ((Track)parse).desc = GPXUtilities.readText(parser, "desc");
                        }
                        if (!parser.getName().equals("trkseg")) continue;
                        TrkSegment trkSeg = new TrkSegment();
                        ((Track)parse).segments.add(trkSeg);
                        parserState.push(trkSeg);
                        continue;
                    }
                    if (parse instanceof TrkSegment) {
                        if (!parser.getName().equals("trkpt")) continue;
                        wptPt = GPXUtilities.parseWptAttributes(parser);
                        ((TrkSegment)parse).points.add(wptPt);
                        parserState.push(wptPt);
                        continue;
                    }
                    if (!(parse instanceof WptPt)) continue;
                    if (parser.getName().equals("name")) {
                        ((WptPt)parse).name = GPXUtilities.readText(parser, "name");
                        continue;
                    }
                    if (parser.getName().equals("desc")) {
                        ((WptPt)parse).desc = GPXUtilities.readText(parser, "desc");
                        continue;
                    }
                    if (parser.getName().equals("link")) {
                        ((WptPt)parse).link = parser.getAttributeValue("", "href");
                        continue;
                    }
                    if (tag.equals("category")) {
                        ((WptPt)parse).category = GPXUtilities.readText(parser, "category");
                        continue;
                    }
                    if (tag.equals("type")) {
                        if (((WptPt)parse).category != null) continue;
                        ((WptPt)parse).category = GPXUtilities.readText(parser, "type");
                        continue;
                    }
                    if (parser.getName().equals("ele")) {
                        text = GPXUtilities.readText(parser, "ele");
                        if (text == null) continue;
                        try {
                            ((WptPt)parse).ele = Float.parseFloat(text);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (parser.getName().equals("hdop")) {
                        text = GPXUtilities.readText(parser, "hdop");
                        if (text == null) continue;
                        try {
                            ((WptPt)parse).hdop = Float.parseFloat(text);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (!parser.getName().equals("time") || (text = GPXUtilities.readText(parser, "time")) == null) continue;
                    try {
                        ((WptPt)parse).time = format.parse(text).getTime();
                    }
                    catch (ParseException parseException) {}
                    continue;
                }
                if (tok != 3) continue;
                parse = parserState.peek();
                tag = parser.getName();
                if (parse instanceof GPXExtensions && tag.equals("extensions")) {
                    extensionReadMode = false;
                }
                if (tag.equals("trkpt")) {
                    pop = parserState.pop();
                    assert (pop instanceof WptPt);
                    continue;
                }
                if (tag.equals("wpt")) {
                    pop = parserState.pop();
                    assert (pop instanceof WptPt);
                    continue;
                }
                if (tag.equals("rtept")) {
                    pop = parserState.pop();
                    assert (pop instanceof WptPt);
                    continue;
                }
                if (tag.equals("trk")) {
                    pop = parserState.pop();
                    assert (pop instanceof Track);
                    continue;
                }
                if (tag.equals("rte")) {
                    pop = parserState.pop();
                    assert (pop instanceof Route);
                    continue;
                }
                if (!tag.equals("trkseg")) continue;
                pop = parserState.pop();
                assert (pop instanceof TrkSegment);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Error reading gpx", (Throwable)e);
            res.warning = ctx.getString(620) + " " + e.getMessage();
        }
        catch (XmlPullParserException e) {
            log.error((Object)"Error reading gpx", (Throwable)e);
            res.warning = ctx.getString(620) + " " + e.getMessage();
        }
        catch (IOException e) {
            log.error((Object)"Error reading gpx", (Throwable)e);
            res.warning = ctx.getString(620) + " " + e.getMessage();
        }
        return res;
    }

    private static Reader getUTF8Reader(InputStream f) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(f);
        assert (bis.markSupported());
        bis.mark(3);
        boolean reset = true;
        byte[] t = new byte[3];
        bis.read(t);
        if (t[0] == -17 && t[1] == -69 && t[2] == -65) {
            reset = false;
        }
        if (reset) {
            bis.reset();
        }
        return new InputStreamReader((InputStream)bis, "UTF-8");
    }

    private static WptPt parseWptAttributes(XmlPullParser parser) {
        WptPt wpt = new WptPt();
        try {
            wpt.lat = Double.parseDouble(parser.getAttributeValue("", "lat"));
            wpt.lon = Double.parseDouble(parser.getAttributeValue("", "lon"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return wpt;
    }

    public static void mergeGPXFileInto(GPXFile to, GPXFile from) {
        if (from == null) {
            return;
        }
        if (from.showCurrentTrack) {
            to.showCurrentTrack = true;
        }
        if (from.points != null) {
            to.points.addAll(from.points);
        }
        if (from.tracks != null) {
            to.tracks.addAll(from.tracks);
        }
        if (from.routes != null) {
            to.routes.addAll(from.routes);
        }
        if (from.warning != null) {
            to.warning = from.warning;
        }
    }

    public static class GPXFileResult {
        public ArrayList<List<Location>> locations = new ArrayList();
        public ArrayList<WptPt> wayPoints = new ArrayList();
        public boolean cloudMadeFile;
        public String error;

        public Location findFistLocation() {
            for (List<Location> l : this.locations) {
                for (Location ls : l) {
                    if (ls == null) continue;
                    return ls;
                }
            }
            return null;
        }
    }

    public static class GPXFile
    extends GPXExtensions {
        public String author;
        public List<Track> tracks = new ArrayList<Track>();
        public List<WptPt> points = new ArrayList<WptPt>();
        public List<Route> routes = new ArrayList<Route>();
        public String warning = null;
        public String path = "";
        public boolean showCurrentTrack;
        public long modifiedTime = 0L;

        public boolean isCloudmadeRouteFile() {
            return "cloudmade".equalsIgnoreCase(this.author);
        }

        public String getName() {
            if (this.path == null) {
                return "";
            }
            try {
                return new File(this.path).getName();
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.path.replaceAll("^.*" + File.separatorChar, "");
            }
        }

        public GPXTrackAnalysis getAnalysis(long fileTimestamp) {
            GPXTrackAnalysis g = new GPXTrackAnalysis();
            g.wptPoints = this.points.size();
            ArrayList<SplitSegment> splitSegments = new ArrayList<SplitSegment>();
            for (int i = 0; i < this.tracks.size(); ++i) {
                Track subtrack = this.tracks.get(i);
                for (TrkSegment segment : subtrack.segments) {
                    ++g.totalTracks;
                    if (segment.points.size() <= 1) continue;
                    splitSegments.add(new SplitSegment(segment));
                }
            }
            g.prepareInformation(fileTimestamp, splitSegments.toArray(new SplitSegment[splitSegments.size()]));
            return g;
        }

        public boolean hasRtePt() {
            for (Route r : this.routes) {
                if (r.points.size() <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasWptPt() {
            return this.points.size() > 0;
        }

        public boolean hasTrkpt() {
            for (Track t : this.tracks) {
                for (TrkSegment ts : t.segments) {
                    if (ts.points.size() <= 0) continue;
                    return true;
                }
            }
            return false;
        }

        public WptPt addWptPt(double lat, double lon, long time, String description, String name, String category, int color2) {
            double latAdjusted = Double.parseDouble(latLonFormat.format(lat));
            double lonAdjusted = Double.parseDouble(latLonFormat.format(lon));
            WptPt pt = new WptPt(latAdjusted, lonAdjusted, time, Double.NaN, 0.0, Double.NaN);
            pt.name = name;
            pt.category = category;
            pt.desc = description;
            if (color2 != 0) {
                pt.setColor(color2);
            }
            this.points.add(pt);
            this.modifiedTime = System.currentTimeMillis();
            return pt;
        }

        public void updateWptPt(WptPt pt, double lat, double lon, long time, String description, String name, String category, int color2) {
            int index = this.points.indexOf(pt);
            double latAdjusted = Double.parseDouble(latLonFormat.format(lat));
            double lonAdjusted = Double.parseDouble(latLonFormat.format(lon));
            pt.lat = latAdjusted;
            pt.lon = lonAdjusted;
            pt.time = time;
            pt.desc = description;
            pt.name = name;
            pt.category = category;
            if (color2 != 0) {
                pt.setColor(color2);
            }
            if (index != -1) {
                this.points.set(index, pt);
            }
            this.modifiedTime = System.currentTimeMillis();
        }

        public boolean deleteWptPt(WptPt pt) {
            this.modifiedTime = System.currentTimeMillis();
            return this.points.remove(pt);
        }

        public List<TrkSegment> processRoutePoints() {
            ArrayList<TrkSegment> tpoints = new ArrayList<TrkSegment>();
            if (this.routes.size() > 0) {
                for (Route r : this.routes) {
                    TrkSegment sgmt = new TrkSegment();
                    tpoints.add(sgmt);
                    sgmt.points.addAll(r.points);
                }
            }
            return tpoints;
        }

        public List<TrkSegment> proccessPoints() {
            ArrayList<TrkSegment> tpoints = new ArrayList<TrkSegment>();
            for (Track t : this.tracks) {
                int trackColor = t.getColor(this.getColor(0));
                for (TrkSegment ts : t.segments) {
                    if (ts.points.size() <= 0) continue;
                    TrkSegment sgmt = new TrkSegment();
                    tpoints.add(sgmt);
                    sgmt.points.addAll(ts.points);
                    sgmt.setColor(trackColor);
                }
            }
            return tpoints;
        }

        public WptPt getLastPoint() {
            if (this.tracks.size() > 0) {
                Track tk = this.tracks.get(this.tracks.size() - 1);
                if (tk.segments.size() > 0) {
                    TrkSegment ts = tk.segments.get(tk.segments.size() - 1);
                    if (ts.points.size() > 0) {
                        return ts.points.get(ts.points.size() - 1);
                    }
                }
            }
            return null;
        }

        public WptPt findPointToShow() {
            for (Track t : this.tracks) {
                for (TrkSegment s : t.segments) {
                    if (s.points.size() <= 0) continue;
                    return s.points.get(0);
                }
            }
            for (Route s : this.routes) {
                if (s.points.size() <= 0) continue;
                return s.points.get(0);
            }
            if (this.points.size() > 0) {
                return this.points.get(0);
            }
            return null;
        }

        public boolean isEmpty() {
            for (Track t : this.tracks) {
                if (t.segments == null) continue;
                for (TrkSegment s : t.segments) {
                    boolean tracksEmpty = s.points.isEmpty();
                    if (tracksEmpty) continue;
                    return false;
                }
            }
            return this.points.isEmpty() && this.routes.isEmpty();
        }
    }

    private static abstract class SplitMetric {
        private SplitMetric() {
        }

        public abstract double metric(WptPt var1, WptPt var2);
    }

    private static class SplitSegment {
        TrkSegment segment;
        double startCoeff = 0.0;
        int startPointInd;
        double endCoeff = 0.0;
        int endPointInd;
        double metricEnd;
        double secondaryMetricEnd;

        public SplitSegment(TrkSegment s) {
            this.startPointInd = 0;
            this.startCoeff = 0.0;
            this.endPointInd = s.points.size() - 2;
            this.endCoeff = 1.0;
            this.segment = s;
        }

        public SplitSegment(TrkSegment s, int pointInd, double cf) {
            this.segment = s;
            this.startPointInd = pointInd;
            this.startCoeff = cf;
        }

        public int getNumberOfPoints() {
            return this.endPointInd - this.startPointInd + 2;
        }

        public WptPt get(int j) {
            int ind = j + this.startPointInd;
            if (j == 0) {
                if (this.startCoeff == 0.0) {
                    return this.segment.points.get(ind);
                }
                return this.approx(this.segment.points.get(ind), this.segment.points.get(ind + 1), this.startCoeff);
            }
            if (j == this.getNumberOfPoints() - 1) {
                if (this.endCoeff == 1.0) {
                    return this.segment.points.get(ind);
                }
                return this.approx(this.segment.points.get(ind - 1), this.segment.points.get(ind), this.endCoeff);
            }
            return this.segment.points.get(ind);
        }

        private WptPt approx(WptPt w1, WptPt w2, double cf) {
            long time = this.value(w1.time, w2.time, 0L, cf);
            double speed = this.value(w1.speed, w2.speed, 0.0, cf);
            double ele = this.value(w1.ele, w2.ele, 0.0, cf);
            double hdop = this.value(w1.hdop, w2.hdop, 0.0, cf);
            double lat = this.value(w1.lat, w2.lat, -360.0, cf);
            double lon = this.value(w1.lon, w2.lon, -360.0, cf);
            return new WptPt(lat, lon, time, ele, speed, hdop);
        }

        private double value(double vl, double vl2, double none, double cf) {
            if (vl == none || Double.isNaN(vl)) {
                return vl2;
            }
            if (vl2 == none || Double.isNaN(vl2)) {
                return vl;
            }
            return vl + cf * (vl2 - vl);
        }

        private long value(long vl, long vl2, long none, double cf) {
            if (vl == none) {
                return vl2;
            }
            if (vl2 == none) {
                return vl;
            }
            return vl + (long)(cf * (double)(vl2 - vl));
        }

        public double setLastPoint(int pointInd, double endCf) {
            this.endCoeff = endCf;
            this.endPointInd = pointInd;
            return this.endCoeff;
        }
    }

    public static class GPXTrackAnalysis {
        public float totalDistance = 0.0f;
        public int totalTracks = 0;
        public long startTime = Long.MAX_VALUE;
        public long endTime = Long.MIN_VALUE;
        public long timeSpan = 0L;
        public long timeMoving = 0L;
        public float totalDistanceMoving = 0.0f;
        public double diffElevationUp = 0.0;
        public double diffElevationDown = 0.0;
        public double avgElevation = 0.0;
        public double minElevation = 99999.0;
        public double maxElevation = -100.0;
        public float maxSpeed = 0.0f;
        public float avgSpeed;
        public int points;
        public int wptPoints = 0;
        public double metricEnd;
        public double secondaryMetricEnd;
        public WptPt locationStart;
        public WptPt locationEnd;

        public boolean isTimeSpecified() {
            return this.startTime != Long.MAX_VALUE && this.startTime != 0L;
        }

        public boolean isTimeMoving() {
            return this.timeMoving != 0L;
        }

        public boolean isElevationSpecified() {
            return this.maxElevation != -100.0;
        }

        public boolean isSpeedSpecified() {
            return this.avgSpeed > 0.0f;
        }

        public static GPXTrackAnalysis segment(long filetimestamp, TrkSegment segment) {
            return new GPXTrackAnalysis().prepareInformation(filetimestamp, new SplitSegment(segment));
        }

        public GPXTrackAnalysis prepareInformation(long filestamp, SplitSegment ... splitSegments) {
            double channelThresMin;
            float[] calculations = new float[1];
            float totalElevation = 0.0f;
            int elevationPoints = 0;
            int speedCount = 0;
            double totalSpeedSum = 0.0;
            this.points = 0;
            double channelThres = channelThresMin = 5.0;
            boolean climb = false;
            for (SplitSegment s : splitSegments) {
                double channelBase;
                int numberOfPoints = s.getNumberOfPoints();
                double channelTop = channelBase = 99999.0;
                double channelBottom = channelBase;
                channelThres = channelThresMin;
                this.metricEnd += s.metricEnd;
                this.secondaryMetricEnd += s.secondaryMetricEnd;
                this.points += numberOfPoints;
                for (int j = 0; j < numberOfPoints; ++j) {
                    float speed;
                    double elevation;
                    long time;
                    WptPt point = s.get(j);
                    if (j == 0 && this.locationStart == null) {
                        this.locationStart = point;
                    }
                    if (j == numberOfPoints - 1) {
                        this.locationEnd = point;
                    }
                    if ((time = point.time) != 0L) {
                        this.startTime = Math.min(this.startTime, time);
                        this.endTime = Math.max(this.endTime, time);
                    }
                    if (!Double.isNaN(elevation = point.ele)) {
                        totalElevation = (float)((double)totalElevation + elevation);
                        ++elevationPoints;
                        this.minElevation = Math.min(elevation, this.minElevation);
                        this.maxElevation = Math.max(elevation, this.maxElevation);
                    }
                    if ((speed = (float)point.speed) > 0.0f) {
                        totalSpeedSum += (double)speed;
                        this.maxSpeed = Math.max(speed, this.maxSpeed);
                        ++speedCount;
                    }
                    if (!Double.isNaN(point.ele)) {
                        if (channelBase == 99999.0) {
                            channelTop = channelBase = point.ele;
                            channelBottom = channelBase;
                            channelThres = channelThresMin;
                        }
                        if (point.ele > channelTop) {
                            channelTop = point.ele;
                            if (!Double.isNaN(point.hdop)) {
                                channelThres = Math.max(channelThres, 2.0 * point.hdop);
                            }
                        } else if (point.ele < channelBottom) {
                            channelBottom = point.ele;
                            if (!Double.isNaN(point.hdop)) {
                                channelThres = Math.max(channelThres, 2.0 * point.hdop);
                            }
                        }
                        if (point.ele <= channelTop - channelThres && climb) {
                            if (channelTop - channelBase >= channelThres) {
                                this.diffElevationUp += channelTop - channelBase;
                            }
                            channelBase = channelTop;
                            channelBottom = point.ele;
                            climb = false;
                            channelThres = channelThresMin;
                        } else if (point.ele >= channelBottom + channelThres && !climb) {
                            if (channelBase - channelBottom >= channelThres) {
                                this.diffElevationDown += channelBase - channelBottom;
                            }
                            channelBase = channelBottom;
                            channelTop = point.ele;
                            climb = true;
                            channelThres = channelThresMin;
                        }
                        if (j == numberOfPoints - 1) {
                            if (channelTop - channelBase >= channelThres) {
                                this.diffElevationUp += channelTop - channelBase;
                            }
                            if (channelBase - channelBottom >= channelThres) {
                                this.diffElevationDown += channelBase - channelBottom;
                            }
                        }
                    }
                    if (j <= 0) continue;
                    WptPt prev = s.get(j - 1);
                    Location.distanceBetween(prev.lat, prev.lon, point.lat, point.lon, calculations);
                    this.totalDistance += calculations[0];
                    if (!(speed > 0.0f) || point.time == 0L || prev.time == 0L) continue;
                    this.timeMoving += point.time - prev.time;
                    this.totalDistanceMoving += calculations[0];
                }
            }
            if (!this.isTimeSpecified()) {
                this.startTime = filestamp;
                this.endTime = filestamp;
            }
            this.timeSpan = this.endTime - this.startTime;
            if (elevationPoints > 0) {
                this.avgElevation = totalElevation / (float)elevationPoints;
            }
            this.avgSpeed = speedCount > 0 ? (this.timeMoving > 0L ? this.totalDistanceMoving / (float)this.timeMoving * 1000.0f : (float)totalSpeedSum / (float)speedCount) : -1.0f;
            return this;
        }
    }

    public static class Route
    extends GPXExtensions {
        public String name = null;
        public String desc = null;
        public List<WptPt> points = new ArrayList<WptPt>();
    }

    public static class Track
    extends GPXExtensions {
        public String name = null;
        public String desc = null;
        public List<TrkSegment> segments = new ArrayList<TrkSegment>();
    }

    public static class TrkSegment
    extends GPXExtensions {
        public List<WptPt> points = new ArrayList<WptPt>();

        public List<GPXTrackAnalysis> splitByDistance(double meters) {
            return this.split(GPXUtilities.getDistanceMetric(), GPXUtilities.getTimeSplit(), meters);
        }

        public List<GPXTrackAnalysis> splitByTime(int seconds) {
            return this.split(GPXUtilities.getTimeSplit(), GPXUtilities.getDistanceMetric(), seconds);
        }

        private List<GPXTrackAnalysis> split(SplitMetric metric, SplitMetric secondaryMetric, double metricLimit) {
            ArrayList splitSegments = new ArrayList();
            GPXUtilities.splitSegment(metric, secondaryMetric, metricLimit, splitSegments, this);
            return GPXUtilities.convert(splitSegments);
        }
    }

    public static class WptPt
    extends GPXExtensions
    implements LocationPoint {
        public double lat;
        public double lon;
        public String name = null;
        public String link = null;
        public String category = null;
        public String desc = null;
        public long time = 0L;
        public double ele = Double.NaN;
        public double speed = 0.0;
        public double hdop = Double.NaN;
        public boolean deleted = false;

        public WptPt() {
        }

        @Override
        public int getColor() {
            return this.getColor(0);
        }

        @Override
        public double getLatitude() {
            return this.lat;
        }

        @Override
        public double getLongitude() {
            return this.lon;
        }

        @Override
        public PointDescription getPointDescription(OsmWindow ctx) {
            return new PointDescription("wpt", this.name);
        }

        public WptPt(double lat, double lon, long time, double ele, double speed, double hdop) {
            this.lat = lat;
            this.lon = lon;
            this.time = time;
            this.ele = ele;
            this.speed = speed;
            this.hdop = hdop;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.lat == 0.0 ? 0 : Double.valueOf(this.lat).hashCode());
            result = 31 * result + (this.lon == 0.0 ? 0 : Double.valueOf(this.lon).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WptPt other = (WptPt)obj;
            return Algorithms.objectEquals(other.name, this.name) && Algorithms.objectEquals(other.category, this.category) && Algorithms.objectEquals(other.lat, this.lat) && Algorithms.objectEquals(other.lon, this.lon) && Algorithms.objectEquals(other.desc, this.desc);
        }

        public LatLon getLatLon() {
            return new LatLon(this.lat, this.lon);
        }
    }

    public static class GPXExtensions {
        Map<String, String> extensions = null;

        public Map<String, String> getExtensionsToRead() {
            if (this.extensions == null) {
                return Collections.emptyMap();
            }
            return this.extensions;
        }

        public int getColor(int defColor) {
            if (this.extensions != null && this.extensions.containsKey("color")) {
                try {
                    String colString = this.extensions.get("color").toUpperCase();
                    if (colString.startsWith("#")) {
                        colString = colString.substring(1);
                    }
                    return Integer.parseInt(colString, 16);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            return defColor;
        }

        public void setColor(int color2) {
            this.getExtensionsToWrite().put("color", Algorithms.colorToString(color2));
        }

        public Map<String, String> getExtensionsToWrite() {
            if (this.extensions == null) {
                this.extensions = new LinkedHashMap<String, String>();
            }
            return this.extensions;
        }
    }
}

