/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Map;
import net.osmand.data.Amenity;
import net.osmand.data.City;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiType;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.OsmandSettings;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;

public class OsmAndFormatter {
    public static final float METERS_IN_KILOMETER = 1000.0f;
    public static final float METERS_IN_ONE_MILE = 1609.344f;
    public static final float METERS_IN_ONE_NAUTICALMILE = 1852.0f;
    public static final float YARDS_IN_ONE_METER = 1.0936f;
    public static final float FOOTS_IN_ONE_METER = 3.2808f;
    private static final DecimalFormat fixed2 = new DecimalFormat("0.00");
    private static final DecimalFormat fixed1 = new DecimalFormat("0.0");

    public OsmAndFormatter() {
        fixed2.setMinimumFractionDigits(2);
        fixed1.setMinimumFractionDigits(1);
        fixed1.setMinimumIntegerDigits(1);
        fixed2.setMinimumIntegerDigits(1);
    }

    public static double calculateRoundedDist(double distInMeters, OsmWindow ctx) {
        OsmandSettings settings = ctx.getSettings();
        OsmandSettings.MetricsConstants mc = settings.METRIC_SYSTEM.get();
        double mainUnitInMeter = 1.0;
        double metersInSecondUnit = 1000.0;
        if (mc == OsmandSettings.MetricsConstants.MILES_AND_FOOTS) {
            mainUnitInMeter = 3.2808f;
            metersInSecondUnit = 1609.343994140625;
        } else if (mc == OsmandSettings.MetricsConstants.NAUTICAL_MILES) {
            mainUnitInMeter = 1.0;
            metersInSecondUnit = 1852.0;
        } else if (mc == OsmandSettings.MetricsConstants.MILES_AND_YARDS) {
            mainUnitInMeter = 1.0936f;
            metersInSecondUnit = 1609.343994140625;
        }
        int generator = 1;
        int pointer = 1;
        double point = mainUnitInMeter;
        double roundDist = 1.0;
        while (distInMeters * point > (double)generator) {
            roundDist = (double)generator / point;
            int n = pointer;
            pointer = (byte)(pointer + 1);
            generator = n % 3 == 2 ? generator * 5 / 2 : (generator *= 2);
            if (point != mainUnitInMeter || !(metersInSecondUnit * mainUnitInMeter * (double)0.9f <= (double)generator)) continue;
            point = 1.0 / metersInSecondUnit;
            generator = 1;
            pointer = 1;
        }
        if (mc == OsmandSettings.MetricsConstants.MILES_AND_FOOTS && roundDist == 609.6073934755952) {
            roundDist = 804.672f;
        } else if (mc == OsmandSettings.MetricsConstants.MILES_AND_FOOTS && roundDist == 304.8036967377976) {
            roundDist = 402.336f;
        } else if (mc == OsmandSettings.MetricsConstants.MILES_AND_YARDS && roundDist == 914.4110902133929) {
            roundDist = 804.672f;
        } else if (mc == OsmandSettings.MetricsConstants.MILES_AND_YARDS && roundDist == 457.20554510669643) {
            roundDist = 402.336f;
        }
        return roundDist;
    }

    public static String getFormattedRoundDistanceKm(float meters, int digits, OsmWindow ctx) {
        int mainUnitStr = 543;
        float mainUnitInMeters = 1000.0f;
        if (digits == 0) {
            return (int)((double)(meters / mainUnitInMeters) + 0.5) + " " + ctx.getString(mainUnitStr);
        }
        if (digits == 1) {
            return fixed1.format(meters / mainUnitInMeters) + " " + ctx.getString(mainUnitStr);
        }
        return fixed2.format(meters / mainUnitInMeters) + " " + ctx.getString(mainUnitStr);
    }

    public static String getFormattedDistance(float meters, OsmWindow ctx) {
        float mainUnitInMeters;
        int mainUnitStr;
        OsmandSettings settings = ctx.getSettings();
        OsmandSettings.MetricsConstants mc = settings.METRIC_SYSTEM.get();
        if (mc == OsmandSettings.MetricsConstants.KILOMETERS_AND_METERS) {
            mainUnitStr = 543;
            mainUnitInMeters = 1000.0f;
        } else if (mc == OsmandSettings.MetricsConstants.NAUTICAL_MILES) {
            mainUnitStr = 1902;
            mainUnitInMeters = 1852.0f;
        } else {
            mainUnitStr = 508;
            mainUnitInMeters = 1609.344f;
        }
        if (meters >= 100.0f * mainUnitInMeters) {
            return (int)((double)(meters / mainUnitInMeters) + 0.5) + " " + ctx.getString(mainUnitStr);
        }
        if (meters > 9.99f * mainUnitInMeters) {
            return MessageFormat.format("{0,number,#.#} " + ctx.getString(mainUnitStr), Float.valueOf(meters / mainUnitInMeters)).replace('\n', ' ');
        }
        if (meters > 0.999f * mainUnitInMeters) {
            return MessageFormat.format("{0,number,#.##} " + ctx.getString(mainUnitStr), Float.valueOf(meters / mainUnitInMeters)).replace('\n', ' ');
        }
        if (mc == OsmandSettings.MetricsConstants.MILES_AND_FOOTS && meters > 0.249f * mainUnitInMeters) {
            return MessageFormat.format("{0,number,#.##} " + ctx.getString(mainUnitStr), Float.valueOf(meters / mainUnitInMeters)).replace('\n', ' ');
        }
        if (mc == OsmandSettings.MetricsConstants.MILES_AND_YARDS && meters > 0.249f * mainUnitInMeters) {
            return MessageFormat.format("{0,number,#.##} " + ctx.getString(mainUnitStr), Float.valueOf(meters / mainUnitInMeters)).replace('\n', ' ');
        }
        if (mc == OsmandSettings.MetricsConstants.NAUTICAL_MILES && meters > 0.99f * mainUnitInMeters) {
            return MessageFormat.format("{0,number,#.##} " + ctx.getString(mainUnitStr), Float.valueOf(meters / mainUnitInMeters)).replace('\n', ' ');
        }
        if (mc == OsmandSettings.MetricsConstants.KILOMETERS_AND_METERS) {
            return (int)((double)meters + 0.5) + " " + ctx.getString(545);
        }
        if (mc == OsmandSettings.MetricsConstants.MILES_AND_FOOTS) {
            int foots = (int)((double)(meters * 3.2808f) + 0.5);
            return foots + " " + ctx.getString(506);
        }
        if (mc == OsmandSettings.MetricsConstants.MILES_AND_YARDS) {
            int yards = (int)((double)(meters * 1.0936f) + 0.5);
            return yards + " " + ctx.getString(505);
        }
        return (int)((double)meters + 0.5) + " " + ctx.getString(545);
    }

    public static String getFormattedAlt(double alt, OsmWindow ctx) {
        OsmandSettings settings = ctx.getSettings();
        OsmandSettings.MetricsConstants mc = settings.METRIC_SYSTEM.get();
        if (mc == OsmandSettings.MetricsConstants.KILOMETERS_AND_METERS) {
            return (int)(alt + 0.5) + " " + ctx.getString(545);
        }
        return (int)(alt * (double)3.2808f + 0.5) + " " + ctx.getString(506);
    }

    public static String getFormattedSpeed(float metersperseconds, OsmWindow ctx) {
        OsmandSettings settings = ctx.getSettings();
        OsmandSettings.SpeedConstants mc = settings.SPEED_SYSTEM.get();
        ApplicationMode am = settings.getApplicationMode();
        float kmh = metersperseconds * 3.6f;
        if (mc == OsmandSettings.SpeedConstants.KILOMETERS_PER_HOUR) {
            if (kmh >= 20.0f || am.hasFastSpeed()) {
                return Math.round(kmh) + " " + mc.toShortString();
            }
            int kmh10 = Math.round(kmh * 10.0f);
            return (float)kmh10 / 10.0f + " " + mc.toShortString();
        }
        if (mc == OsmandSettings.SpeedConstants.MILES_PER_HOUR) {
            float mph = kmh * 1000.0f / 1609.344f;
            if (mph >= 20.0f || am.hasFastSpeed()) {
                return Math.round(mph) + " " + mc.toShortString();
            }
            int mph10 = Math.round(mph * 10.0f);
            return (float)mph10 / 10.0f + " " + mc.toShortString();
        }
        if (mc == OsmandSettings.SpeedConstants.NAUTICALMILES_PER_HOUR) {
            float mph = kmh * 1000.0f / 1852.0f;
            if (mph >= 20.0f || am.hasFastSpeed()) {
                return Math.round(mph) + " " + mc.toShortString();
            }
            int mph10 = Math.round(mph * 10.0f);
            return (float)mph10 / 10.0f + " " + mc.toShortString();
        }
        if (mc == OsmandSettings.SpeedConstants.MINUTES_PER_KILOMETER) {
            if ((double)metersperseconds < 0.111111111) {
                return "-" + mc.toShortString();
            }
            float minperkm = 1000.0f / (metersperseconds * 60.0f);
            if (minperkm >= 10.0f) {
                return Math.round(minperkm) + " " + mc.toShortString();
            }
            int mph10 = Math.round(minperkm * 10.0f);
            return (float)mph10 / 10.0f + " " + mc.toShortString();
        }
        if (mc == OsmandSettings.SpeedConstants.MINUTES_PER_MILE) {
            if ((double)metersperseconds < 0.111111111) {
                return "-" + mc.toShortString();
            }
            float minperm = 1609.344f / (metersperseconds * 60.0f);
            if (minperm >= 10.0f) {
                return Math.round(minperm) + " " + mc.toShortString();
            }
            int mph10 = Math.round(minperm * 10.0f);
            return (float)mph10 / 10.0f + " " + mc.toShortString();
        }
        if (metersperseconds >= 10.0f) {
            return Math.round(metersperseconds) + " " + OsmandSettings.SpeedConstants.METERS_PER_SECOND.toShortString();
        }
        int kmh10 = Math.round(metersperseconds * 10.0f);
        return (float)kmh10 / 10.0f + " " + OsmandSettings.SpeedConstants.METERS_PER_SECOND.toShortString();
    }

    public static String toPublicString(City.CityType t, OsmWindow ctx) {
        switch (t) {
            case CITY: {
                return ctx.getString(373);
            }
            case HAMLET: {
                return ctx.getString(370);
            }
            case TOWN: {
                return ctx.getString(372);
            }
            case VILLAGE: {
                return ctx.getString(371);
            }
            case SUBURB: {
                return ctx.getString(369);
            }
        }
        return "";
    }

    public static String getPoiStringWithoutType(Amenity amenity, String locale) {
        PoiCategory pc = amenity.getType();
        PoiType pt = pc.getPoiTypeByKeyName(amenity.getSubType());
        String nm = amenity.getSubType();
        if (pt != null) {
            nm = pt.getTranslation();
        } else if (nm != null) {
            nm = Algorithms.capitalizeFirstLetterAndLowercase(nm.replace('_', ' '));
        }
        String n = amenity.getName(locale);
        if (n.indexOf(nm) != -1) {
            return n;
        }
        if (n.length() == 0) {
            return nm;
        }
        return nm + " " + n;
    }

    public static String getAmenityDescriptionContent(OsmWindow ctx, Amenity amenity, boolean shortDescription) {
        StringBuilder d = new StringBuilder();
        if (amenity.getType().isWiki()) {
            return "";
        }
        MapPoiTypes poiTypes = ctx.getPoiTypes();
        for (Map.Entry<String, String> e : amenity.getAdditionalInfo().entrySet()) {
            String key = e.getKey();
            String vl = e.getValue();
            if (key.startsWith("name:")) continue;
            if (vl.length() >= 150) {
                if (shortDescription) {
                    continue;
                }
            } else if ("opening_hours".equals(key)) {
                d.append(ctx.getString(771) + ": ");
            } else if ("phone".equals(key)) {
                d.append(ctx.getString(603) + ": ");
            } else if ("website".equals(key)) {
                d.append(ctx.getString(602) + ": ");
            } else {
                AbstractPoiType pt = poiTypes.getAnyPoiAdditionalTypeByKey(e.getKey());
                vl = pt != null ? (pt instanceof PoiType && !((PoiType)pt).isText() ? pt.getTranslation() : pt.getTranslation() + ": " + amenity.unzipContent(e.getValue())) : Algorithms.capitalizeFirstLetterAndLowercase(e.getKey()) + ": " + amenity.unzipContent(e.getValue());
            }
            d.append(vl).append('\n');
        }
        return d.toString().trim();
    }
}

