/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

public class TurnType {
    public static final int C = 1;
    public static final int TL = 2;
    public static final int TSLL = 3;
    public static final int TSHL = 4;
    public static final int TR = 5;
    public static final int TSLR = 6;
    public static final int TSHR = 7;
    public static final int KL = 8;
    public static final int KR = 9;
    public static final int TU = 10;
    public static final int TRU = 11;
    public static final int OFFR = 12;
    public static final int RNDB = 13;
    public static final int RNLB = 14;
    private final int value;
    private int exitOut;
    private float turnAngle;
    private boolean skipToSpeak;
    private int[] lanes;

    public static TurnType straight() {
        return TurnType.valueOf(1, false);
    }

    public String toXmlString() {
        switch (this.value) {
            case 1: {
                return "C";
            }
            case 2: {
                return "TL";
            }
            case 3: {
                return "TSLL";
            }
            case 4: {
                return "TSHL";
            }
            case 5: {
                return "TR";
            }
            case 6: {
                return "TSLR";
            }
            case 7: {
                return "TSHR";
            }
            case 8: {
                return "KL";
            }
            case 9: {
                return "KR";
            }
            case 10: {
                return "TU";
            }
            case 11: {
                return "TRU";
            }
            case 12: {
                return "OFFR";
            }
            case 13: {
                return "RNDB" + this.exitOut;
            }
            case 14: {
                return "RNLB" + this.exitOut;
            }
        }
        return "C";
    }

    public static TurnType fromString(String s, boolean leftSide) {
        TurnType t = null;
        if ("C".equals(s)) {
            t = TurnType.valueOf(1, leftSide);
        } else if ("TL".equals(s)) {
            t = TurnType.valueOf(2, leftSide);
        } else if ("TSLL".equals(s)) {
            t = TurnType.valueOf(3, leftSide);
        } else if ("TSHL".equals(s)) {
            t = TurnType.valueOf(4, leftSide);
        } else if ("TR".equals(s)) {
            t = TurnType.valueOf(5, leftSide);
        } else if ("TSLR".equals(s)) {
            t = TurnType.valueOf(6, leftSide);
        } else if ("TSHR".equals(s)) {
            t = TurnType.valueOf(7, leftSide);
        } else if ("KL".equals(s)) {
            t = TurnType.valueOf(8, leftSide);
        } else if ("KR".equals(s)) {
            t = TurnType.valueOf(9, leftSide);
        } else if ("TU".equals(s)) {
            t = TurnType.valueOf(10, leftSide);
        } else if ("TRU".equals(s)) {
            t = TurnType.valueOf(11, leftSide);
        } else if ("OFFR".equals(s)) {
            t = TurnType.valueOf(12, leftSide);
        } else if (s != null && (s.startsWith("EXIT") || s.startsWith("RNDB") || s.startsWith("RNLB"))) {
            try {
                t = TurnType.getExitTurn(Integer.parseInt(s.substring(4)), 0.0f, leftSide);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (t == null) {
            t = TurnType.straight();
        }
        return t;
    }

    public static TurnType valueOf(int vs, boolean leftSide) {
        if (vs == 10 && leftSide) {
            vs = 11;
        } else if (vs == 13 && leftSide) {
            vs = 14;
        }
        return new TurnType(vs);
    }

    public static TurnType getExitTurn(int out, float angle, boolean leftSide) {
        TurnType r = TurnType.valueOf(13, leftSide);
        r.exitOut = out;
        r.setTurnAngle(angle);
        return r;
    }

    private TurnType(int vl) {
        this.value = vl;
    }

    public float getTurnAngle() {
        return this.turnAngle;
    }

    public boolean isLeftSide() {
        return this.value == 14 || this.value == 11;
    }

    public void setTurnAngle(float turnAngle) {
        this.turnAngle = turnAngle;
    }

    public int getValue() {
        return this.value;
    }

    public int getExitOut() {
        return this.exitOut;
    }

    public boolean isRoundAbout() {
        return this.value == 13 || this.value == 14;
    }

    public void setLanes(int[] lanes) {
        this.lanes = lanes;
    }

    public static void setPrimaryTurnAndReset(int[] lanes, int lane, int turnType) {
        lanes[lane] = turnType << 1;
    }

    public static int getPrimaryTurn(int laneValue) {
        return laneValue >> 1 & 0xF;
    }

    public static void setSecondaryTurn(int[] lanes, int lane, int turnType) {
        int n = lane;
        lanes[n] = lanes[n] & 0xFFFFFE1F;
        int n2 = lane;
        lanes[n2] = lanes[n2] | turnType << 5;
    }

    public static int getSecondaryTurn(int laneValue) {
        return laneValue >> 5;
    }

    public int[] getLanes() {
        return this.lanes;
    }

    public boolean keepLeft() {
        return this.value == 8;
    }

    public boolean keepRight() {
        return this.value == 9;
    }

    public boolean goAhead() {
        return this.value == 1;
    }

    public boolean isSkipToSpeak() {
        return this.skipToSpeak;
    }

    public void setSkipToSpeak(boolean skipToSpeak) {
        this.skipToSpeak = skipToSpeak;
    }

    public String toString() {
        if (this.isRoundAbout()) {
            return "Take " + this.getExitOut() + " exit";
        }
        if (this.value == 1) {
            return "Go ahead";
        }
        if (this.value == 3) {
            return "Turn slightly left";
        }
        if (this.value == 2) {
            return "Turn left";
        }
        if (this.value == 4) {
            return "Turn sharply left";
        }
        if (this.value == 6) {
            return "Turn slightly right";
        }
        if (this.value == 5) {
            return "Turn right";
        }
        if (this.value == 7) {
            return "Turn sharply right";
        }
        if (this.value == 10) {
            return "Make uturn";
        }
        if (this.value == 11) {
            return "Make uturn";
        }
        if (this.value == 8) {
            return "Keep left";
        }
        if (this.value == 9) {
            return "Keep right";
        }
        if (this.value == 12) {
            return "Off route";
        }
        return super.toString();
    }

    public static boolean isLeftTurn(int type) {
        return type == 2 || type == 4 || type == 3 || type == 11;
    }

    public static boolean isRightTurn(int type) {
        return type == 5 || type == 7 || type == 6 || type == 10;
    }

    public static boolean isSlightTurn(int type) {
        return type == 3 || type == 6 || type == 1 || type == 8 || type == 9;
    }
}

