/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.ConvertUtil;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.ObjectOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.Property;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;

public class MapConverter
implements Converter {
    private static boolean sentNonStringWarning = false;
    private ConverterManager converterManager = null;
    private String nullKey = null;
    private static final Log log = LogFactory.getLog(MapConverter.class);

    @Override
    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{") || !value.endsWith("}")) {
            log.warn((Object)("Expected object while converting data for " + paramType.getName() + " in " + data.getContext().getCurrentProperty() + ". Passed: " + value));
            throw new ConversionException(paramType, "Data conversion error. See logs for more details.");
        }
        value = value.substring(1, value.length() - 1);
        try {
            Map map = !paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers()) ? (Map)paramType.newInstance() : new HashMap();
            Property parent = data.getContext().getCurrentProperty();
            Property keyProp = parent.createChild(0);
            keyProp = this.converterManager.checkOverride(keyProp);
            Class<?> keyType = keyProp.getPropertyType();
            Property valProp = parent.createChild(1);
            valProp = this.converterManager.checkOverride(valProp);
            Class<?> valType = valProp.getPropertyType();
            data.getContext().addConverted(data, paramType, map);
            InboundContext incx = data.getContext();
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                if (token.trim().length() == 0) continue;
                int colonpos = token.indexOf(":");
                if (colonpos == -1) {
                    throw new ConversionException(paramType, "Missing : in object description: {1}" + token);
                }
                String valStr = token.substring(colonpos + 1).trim();
                String[] splitIv = ConvertUtil.splitInbound(valStr);
                String splitIvValue = splitIv[1];
                String splitIvType = splitIv[0];
                InboundVariable valIv = new InboundVariable(incx, null, splitIvType, splitIvValue);
                valIv.dereference();
                Object val = this.converterManager.convertInbound(valType, valIv, valProp);
                String keyStr = token.substring(0, colonpos).trim();
                InboundVariable keyIv = new InboundVariable(incx, null, "string", keyStr);
                keyIv.dereference();
                Object key = this.converterManager.convertInbound(keyType, keyIv, keyProp);
                map.put(key, val);
            }
            return map;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        HashMap<String, OutboundVariable> ovs = LocalUtil.classNewInstance("OrderedConvertOutbound", "java.util.LinkedHashMap", Map.class);
        if (ovs == null) {
            ovs = new HashMap<String, OutboundVariable>();
        }
        ObjectOutboundVariable ov = new ObjectOutboundVariable(outctx);
        outctx.put(data, ov);
        Map map = (Map)data;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (null == key && null != this.nullKey) {
                log.debug((Object)("MapConverter: A null key was encountered DWR is using the configured nullKey string: " + this.nullKey));
                key = this.nullKey;
            }
            if (!(key instanceof String) && !sentNonStringWarning) {
                log.warn((Object)("--Javascript does not support non string keys. Converting '" + key.getClass().getName() + "' using toString()"));
                sentNonStringWarning = true;
            }
            String outkey = JavascriptUtil.escapeJavaScript(key.toString());
            OutboundVariable nested = this.converterManager.convertOutbound(value, outctx);
            ovs.put(outkey, nested);
        }
        ov.setChildren(ovs);
        return ov;
    }

    public String getNullKey() {
        return this.nullKey;
    }

    public void setNullKey(String nullKey) {
        this.nullKey = nullKey;
    }
}

