/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.filter.TextEncoder;
import com.opensymphony.module.sitemesh.util.FastByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;

public class Buffer {
    private final PageParser pageParser;
    private final String encoding;
    private static final TextEncoder TEXT_ENCODER = new TextEncoder();
    private CharArrayWriter bufferedWriter;
    private FastByteArrayOutputStream bufferedStream;
    private PrintWriter exposedWriter;
    private ServletOutputStream exposedStream;

    public Buffer(PageParser pageParser, String encoding) {
        this.pageParser = pageParser;
        this.encoding = encoding;
    }

    public char[] getContents() throws IOException {
        if (this.bufferedWriter != null) {
            return this.bufferedWriter.toCharArray();
        }
        if (this.bufferedStream != null) {
            return TEXT_ENCODER.encode(this.bufferedStream.toByteArray(), this.encoding);
        }
        return new char[0];
    }

    public Page parse() throws IOException {
        return this.pageParser.parse(this.getContents());
    }

    public PrintWriter getWriter() {
        if (this.bufferedWriter == null) {
            if (this.bufferedStream != null) {
                throw new IllegalStateException("response.getWriter() called after response.getOutputStream()");
            }
            this.bufferedWriter = new CharArrayWriter(128);
            this.exposedWriter = new PrintWriter(this.bufferedWriter);
        }
        return this.exposedWriter;
    }

    public ServletOutputStream getOutputStream() {
        if (this.bufferedStream == null) {
            if (this.bufferedWriter != null) {
                throw new IllegalStateException("response.getOutputStream() called after response.getWriter()");
            }
            this.bufferedStream = new FastByteArrayOutputStream();
            this.exposedStream = new ServletOutputStream(){

                public void write(int b) {
                    Buffer.this.bufferedStream.write(b);
                }
            };
        }
        return this.exposedStream;
    }

    public boolean isUsingStream() {
        return this.bufferedStream != null;
    }
}

