/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.MessageClass;

public class SimpleDataCoding
implements DataCoding {
    private final Alphabet alphabet;
    private final MessageClass messageClass;

    public SimpleDataCoding() {
        this(Alphabet.ALPHA_DEFAULT, MessageClass.CLASS1);
    }

    public SimpleDataCoding(Alphabet alphabet, MessageClass messageClass) throws IllegalArgumentException {
        if (alphabet == null) {
            throw new IllegalArgumentException("Alphabet is mandatory, can't be null");
        }
        if (alphabet.equals((Object)Alphabet.ALPHA_UCS2) || alphabet.isReserved()) {
            throw new IllegalArgumentException("Supported alphabet for SimpleDataCoding does not include " + (Object)((Object)Alphabet.ALPHA_UCS2) + " or " + "reserved alphabet codes. Current alphabet is " + (Object)((Object)alphabet));
        }
        if (messageClass == null) {
            throw new IllegalArgumentException("MessageClass is mandatory, can't be null");
        }
        this.alphabet = alphabet;
        this.messageClass = messageClass;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public MessageClass getMessageClass() {
        return this.messageClass;
    }

    @Override
    public byte toByte() {
        byte value = -16;
        value = (byte)(value | this.alphabet.value());
        value = (byte)(value | this.messageClass.value());
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alphabet == null ? 0 : this.alphabet.hashCode());
        result = 31 * result + (this.messageClass == null ? 0 : this.messageClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleDataCoding other = (SimpleDataCoding)obj;
        if (this.alphabet == null ? other.alphabet != null : !this.alphabet.equals((Object)other.alphabet)) {
            return false;
        }
        return !(this.messageClass == null ? other.messageClass != null : !this.messageClass.equals((Object)other.messageClass));
    }

    public String toString() {
        return "DataCoding:" + (0xFF & this.toByte());
    }
}

